/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.compiler;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.IDN;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.function.Consumer;
import org.xvm.asm.ErrorListener;
import org.xvm.asm.Version;
import org.xvm.compiler.CompilerException;
import org.xvm.compiler.Source;
import org.xvm.compiler.Token;
import org.xvm.util.Handy;
import org.xvm.util.PackedInteger;
import org.xvm.util.Severity;

public class Lexer
implements Iterator<Token> {
    public static final char HT = '\t';
    public static final char LF = '\n';
    public static final char VT = '\u000b';
    public static final char FF = '\f';
    public static final char CR = '\r';
    public static final char EOF = '\u001a';
    public static final char FS = '\u001c';
    public static final char GS = '\u001d';
    public static final char RS = '\u001e';
    public static final char US = '\u001f';
    public static final char NEL = '\u0085';
    public static final char NBS = '\u00a0';
    public static final char LS = '\u2028';
    public static final char PS = '\u2029';
    public static final String UNEXPECTED_EOF = "LEXER-01";
    public static final String EXPECTED_ENDCOMMENT = "LEXER-02";
    public static final String ILLEGAL_CHAR = "LEXER-03";
    public static final String ILLEGAL_NUMBER = "LEXER-04";
    public static final String CHAR_NO_TERM = "LEXER-05";
    public static final String CHAR_BAD_ESC = "LEXER-06";
    public static final String CHAR_NO_CHAR = "LEXER-07";
    public static final String STRING_NO_TERM = "LEXER-08";
    public static final String STRING_BAD_ESC = "LEXER-09";
    public static final String ILLEGAL_HEX = "LEXER-10";
    public static final String EXPECTED_CHAR = "LEXER-11";
    public static final String EXPECTED_DIGITS = "LEXER-12";
    public static final String BAD_DATE = "LEXER-13";
    public static final String BAD_TIME_OF_DAY = "LEXER-14";
    public static final String BAD_TIME = "LEXER-15";
    public static final String BAD_TIMEZONE = "LEXER-16";
    public static final String BAD_DURATION = "LEXER-17";
    public static final String UNEXPECTED_CHAR = "LEXER-18";
    private final Source m_source;
    private final ErrorListener m_errorListener;
    private boolean m_fWhitespace;

    public Lexer(Source source, ErrorListener errorListener) {
        if (source == null) {
            throw new IllegalArgumentException("Source required");
        }
        if (errorListener == null) {
            throw new IllegalArgumentException("ErrorListener required");
        }
        this.m_source = source;
        this.m_errorListener = errorListener;
        this.eatWhitespace();
    }

    protected Lexer(Lexer parent) {
        this.m_source = parent.m_source;
        this.m_errorListener = parent.m_errorListener;
        this.m_fWhitespace = parent.m_fWhitespace;
    }

    @Override
    public boolean hasNext() {
        return this.m_source.hasNext();
    }

    public static boolean isValidIdentifier(String sName) {
        if (sName == null) {
            return false;
        }
        int cch = sName.length();
        if (cch == 0) {
            return false;
        }
        if (!Lexer.isIdentifierStart(sName.charAt(0))) {
            return false;
        }
        for (int i = 1; i < cch; ++i) {
            if (Lexer.isIdentifierPart(sName.charAt(i))) continue;
            return false;
        }
        return Token.Id.valueByText(sName) == null;
    }

    public void emit(Consumer<Token> consumer) {
        while (this.m_source.hasNext()) {
            consumer.accept(this.next());
        }
    }

    public Lexer createLexer(final Token[] atoken) {
        return new Lexer(this, this){
            int iNext;
            {
                super(parent);
                this.iNext = 0;
            }

            @Override
            public boolean hasNext() {
                return this.iNext < atoken.length;
            }

            @Override
            public Token next() {
                if (this.hasNext()) {
                    return atoken[this.iNext++];
                }
                throw new NoSuchElementException();
            }

            @Override
            public long mark() {
                return this.iNext;
            }

            @Override
            public void restore(long lPos) {
                this.iNext = (int)lPos;
            }
        };
    }

    public static boolean isValidRFC1035Label(String sName) {
        if (sName == null) {
            return false;
        }
        try {
            sName = IDN.toASCII(sName);
        }
        catch (IllegalArgumentException e) {
            return false;
        }
        int cch = sName.length();
        if (cch == 0 || cch > 63) {
            return false;
        }
        if (!Handy.isAsciiLetter(sName.charAt(0))) {
            return false;
        }
        for (int i = 1; i < cch; ++i) {
            char ch = sName.charAt(i);
            if (Handy.isAsciiLetter(ch) || Handy.isDigit(ch) || i < cch - 1 && ch == '-') continue;
            return false;
        }
        return true;
    }

    public static boolean isValidQualifiedModule(String sName) {
        if (sName == null) {
            return false;
        }
        String[] asName = Handy.parseDelimitedString(sName, '.');
        int cNames = asName.length;
        if (cNames < 1) {
            return false;
        }
        if (!Lexer.isValidIdentifier(asName[0])) {
            return false;
        }
        if (cNames == 2) {
            return false;
        }
        for (int i = 1; i < cNames; ++i) {
            if (Lexer.isValidRFC1035Label(asName[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public Token next() {
        boolean fWhitespaceBefore = this.m_fWhitespace;
        Token token = this.eatToken();
        boolean fWhitespaceAfter = this.eatWhitespace();
        token.noteWhitespace(fWhitespaceBefore, fWhitespaceAfter);
        return token;
    }

    protected Token eatStringLiteral(long lInitPos) {
        return this.eatStringChars(lInitPos, false, false);
    }

    protected Token eatMultilineLiteral(long lInitPos) {
        return this.eatStringChars(lInitPos, false, true);
    }

    protected Token eatTemplateLiteral(long lInitPos) {
        return this.eatStringChars(lInitPos, true, false);
    }

    protected Token eatMultilineTemplateLiteral(long lInitPos) {
        return this.eatStringChars(lInitPos, true, true);
    }

    protected boolean eatWhitespace() {
        boolean fWhitespace = false;
        Source source = this.m_source;
        while (source.hasNext()) {
            if (Lexer.isWhitespace(this.nextChar())) {
                fWhitespace = true;
                continue;
            }
            source.rewind();
            break;
        }
        this.m_fWhitespace = fWhitespace;
        return fWhitespace;
    }

    protected boolean isMultilineContinued() {
        long lPrev = this.mark();
        Source source = this.m_source;
        while (source.hasNext()) {
            char ch = source.next();
            if (Lexer.isWhitespace(ch)) continue;
            if (ch != '|') break;
            return true;
        }
        this.restore(lPrev);
        return false;
    }

    protected Token[] eatTemplateExpression(boolean fMultiline) {
        int nPrevLine = this.m_source.getLine();
        long lInitPos = this.m_source.getPosition();
        Token curly = this.next();
        assert (curly.getId() == Token.Id.L_CURLY);
        long lPrevPos = this.mark();
        int cDepth = 1;
        ArrayList<Token> tokens = new ArrayList<Token>();
        while (true) {
            Token token;
            int nLine;
            if ((nLine = Source.calculateLine((token = this.next()).getEndPosition())) != nPrevLine) {
                if (!fMultiline || token.getId() != Token.Id.BIT_OR || Source.calculateLine(token.getStartPosition()) != nLine) {
                    this.restore(lPrevPos);
                    this.log(Severity.ERROR, STRING_NO_TERM, null, lInitPos);
                    return tokens.toArray(new Token[0]);
                }
                nPrevLine = nLine;
                continue;
            }
            switch (token.getId()) {
                case L_CURLY: {
                    ++cDepth;
                    break;
                }
                case R_CURLY: {
                    if (--cDepth > 0) break;
                    if (token.hasTrailingWhitespace()) {
                        this.m_source.setPosition(token.getEndPosition());
                    }
                    return tokens.toArray(new Token[0]);
                }
            }
            tokens.add(token);
            lPrevPos = this.mark();
        }
    }

    protected Token eatBinaryLiteral(long lInitPos, boolean fMultiline) {
        StringBuilder sb = new StringBuilder();
        Source source = this.m_source;
        boolean fFirst = true;
        while (source.hasNext()) {
            char ch = source.next();
            if (Handy.isHexit(ch)) {
                sb.append(ch);
            } else if (ch == '_') {
                if (fFirst) {
                    this.log(Severity.ERROR, ILLEGAL_HEX, new Object[]{String.valueOf(ch)}, lInitPos);
                }
            } else {
                if (!fMultiline) {
                    source.rewind();
                    break;
                }
                if (Lexer.isWhitespace(ch)) {
                    if (Lexer.isLineTerminator(ch) && !this.isMultilineContinued()) {
                        source.rewind();
                        break;
                    }
                } else {
                    this.log(Severity.ERROR, ILLEGAL_HEX, new Object[]{String.valueOf(ch)}, lInitPos);
                    source.rewind();
                    break;
                }
            }
            fFirst = false;
        }
        return new Token(lInitPos, source.getPosition(), Token.Id.LIT_BINSTR, this.toBinary(sb.toString().toCharArray()));
    }

    protected byte[] toBinary(char[] ach) {
        int cch = ach.length;
        int ofch = 0;
        int cb = (cch + 1) / 2;
        int ofb = 0;
        byte[] ab = new byte[cb];
        if ((cch & 1) != 0) {
            ab[ofb++] = (byte)Handy.hexitValue(ach[ofch++]);
        }
        while (ofb < cb) {
            ab[ofb++] = (byte)((Handy.hexitValue(ach[ofch++]) << 4) + Handy.hexitValue(ach[ofch++]));
        }
        return ab;
    }

    protected Token eatToken() {
        Source source = this.m_source;
        long lInitPos = source.getPosition();
        char chInit = this.nextChar();
        switch (chInit) {
            case '{': {
                return new Token(lInitPos, source.getPosition(), Token.Id.L_CURLY);
            }
            case '}': {
                return new Token(lInitPos, source.getPosition(), Token.Id.R_CURLY);
            }
            case '(': {
                return new Token(lInitPos, source.getPosition(), Token.Id.L_PAREN);
            }
            case ')': {
                return new Token(lInitPos, source.getPosition(), Token.Id.R_PAREN);
            }
            case '[': {
                return new Token(lInitPos, source.getPosition(), Token.Id.L_SQUARE);
            }
            case ']': {
                return new Token(lInitPos, source.getPosition(), Token.Id.R_SQUARE);
            }
            case ';': {
                return new Token(lInitPos, source.getPosition(), Token.Id.SEMICOLON);
            }
            case ',': {
                return new Token(lInitPos, source.getPosition(), Token.Id.COMMA);
            }
            case '.': {
                if (source.hasNext()) {
                    switch (this.nextChar()) {
                        case '.': {
                            if (source.hasNext()) {
                                switch (this.nextChar()) {
                                    case '/': {
                                        return new Token(lInitPos, source.getPosition(), Token.Id.DIR_PARENT);
                                    }
                                    case '<': {
                                        return new Token(lInitPos, source.getPosition(), Token.Id.I_RANGE_E);
                                    }
                                }
                                source.rewind();
                            }
                            return new Token(lInitPos, source.getPosition(), Token.Id.I_RANGE_I);
                        }
                        case '/': {
                            return new Token(lInitPos, source.getPosition(), Token.Id.DIR_CUR);
                        }
                        case '0': 
                        case '1': 
                        case '2': 
                        case '3': 
                        case '4': 
                        case '5': 
                        case '6': 
                        case '7': 
                        case '8': 
                        case '9': {
                            source.rewind();
                            source.rewind();
                            return this.eatNumericLiteral();
                        }
                    }
                    source.rewind();
                }
                return new Token(lInitPos, source.getPosition(), Token.Id.DOT);
            }
            case '$': {
                if (source.hasNext()) {
                    switch (this.nextChar()) {
                        case '\"': {
                            return this.eatTemplateLiteral(lInitPos);
                        }
                        case '|': {
                            return this.eatMultilineTemplateLiteral(lInitPos);
                        }
                        case '/': {
                            source.rewind();
                            return new Token(lInitPos, source.getPosition(), Token.Id.STR_FILE);
                        }
                        case '.': {
                            if (!source.hasNext()) break;
                            switch (this.nextChar()) {
                                case '.': {
                                    if (!source.hasNext()) break;
                                    if (this.nextChar() == '/') {
                                        source.rewind();
                                        source.rewind();
                                        source.rewind();
                                        return new Token(lInitPos, source.getPosition(), Token.Id.STR_FILE);
                                    }
                                    source.rewind();
                                    break;
                                }
                                case '/': {
                                    source.rewind();
                                    source.rewind();
                                    return new Token(lInitPos, source.getPosition(), Token.Id.STR_FILE);
                                }
                            }
                            source.rewind();
                        }
                    }
                    source.rewind();
                }
                Token token = new Token(lInitPos, source.getPosition(), Token.Id.IDENTIFIER, "$");
                this.peekNotIdentifierOrNumber();
                return token;
            }
            case '#': {
                if (source.hasNext()) {
                    switch (this.nextChar()) {
                        case '.': 
                        case '/': {
                            source.rewind();
                            return new Token(lInitPos, source.getPosition(), Token.Id.BIN_FILE);
                        }
                        case '|': {
                            return this.eatBinaryLiteral(lInitPos, true);
                        }
                    }
                    source.rewind();
                }
                return this.eatBinaryLiteral(lInitPos, false);
            }
            case '@': {
                return new Token(lInitPos, source.getPosition(), Token.Id.AT);
            }
            case '?': {
                if (source.hasNext()) {
                    switch (this.nextChar()) {
                        case '=': {
                            return new Token(lInitPos, source.getPosition(), Token.Id.COND_NN_ASN);
                        }
                        case ':': {
                            if (source.hasNext()) {
                                if (this.nextChar() == '=') {
                                    return new Token(lInitPos, source.getPosition(), Token.Id.COND_ELSE_ASN);
                                }
                                source.rewind();
                            }
                            return new Token(lInitPos, source.getPosition(), Token.Id.COND_ELSE);
                        }
                    }
                    source.rewind();
                }
                return new Token(lInitPos, source.getPosition(), Token.Id.COND);
            }
            case ':': {
                if (source.hasNext()) {
                    if (this.nextChar() == '=') {
                        return new Token(lInitPos, source.getPosition(), Token.Id.COND_ASN);
                    }
                    source.rewind();
                }
                return new Token(lInitPos, source.getPosition(), Token.Id.COLON);
            }
            case '+': {
                if (source.hasNext()) {
                    switch (this.nextChar()) {
                        case '+': {
                            return new Token(lInitPos, source.getPosition(), Token.Id.INC);
                        }
                        case '=': {
                            return new Token(lInitPos, source.getPosition(), Token.Id.ADD_ASN);
                        }
                    }
                    source.rewind();
                }
                return new Token(lInitPos, source.getPosition(), Token.Id.ADD);
            }
            case '-': {
                if (source.hasNext()) {
                    switch (this.nextChar()) {
                        case '-': {
                            return new Token(lInitPos, source.getPosition(), Token.Id.DEC);
                        }
                        case '>': {
                            return new Token(lInitPos, source.getPosition(), Token.Id.LAMBDA);
                        }
                        case '=': {
                            return new Token(lInitPos, source.getPosition(), Token.Id.SUB_ASN);
                        }
                    }
                    source.rewind();
                }
                return new Token(lInitPos, source.getPosition(), Token.Id.SUB);
            }
            case '*': {
                if (source.hasNext()) {
                    if (this.nextChar() == '=') {
                        return new Token(lInitPos, source.getPosition(), Token.Id.MUL_ASN);
                    }
                    source.rewind();
                }
                return new Token(lInitPos, source.getPosition(), Token.Id.MUL);
            }
            case '/': {
                if (source.hasNext()) {
                    switch (this.nextChar()) {
                        case '/': {
                            return this.eatSingleLineComment(lInitPos);
                        }
                        case '*': {
                            return this.eatEnclosedComment(lInitPos);
                        }
                        case '=': {
                            return new Token(lInitPos, source.getPosition(), Token.Id.DIV_ASN);
                        }
                        case '%': {
                            return new Token(lInitPos, source.getPosition(), Token.Id.DIVREM);
                        }
                    }
                    source.rewind();
                }
                return new Token(lInitPos, source.getPosition(), Token.Id.DIV);
            }
            case '<': {
                if (source.hasNext()) {
                    switch (this.nextChar()) {
                        case '<': {
                            if (source.hasNext()) {
                                if (this.nextChar() == '=') {
                                    return new Token(lInitPos, source.getPosition(), Token.Id.SHL_ASN);
                                }
                                source.rewind();
                            }
                            return new Token(lInitPos, source.getPosition(), Token.Id.SHL);
                        }
                        case '-': {
                            return new Token(lInitPos, source.getPosition(), Token.Id.ASN_EXPR);
                        }
                        case '=': {
                            if (source.hasNext()) {
                                if (this.nextChar() == '>') {
                                    return new Token(lInitPos, source.getPosition(), Token.Id.COMP_ORD);
                                }
                                source.rewind();
                            }
                            return new Token(lInitPos, source.getPosition(), Token.Id.COMP_LTEQ);
                        }
                    }
                    source.rewind();
                }
                return new Token(lInitPos, source.getPosition(), Token.Id.COMP_LT);
            }
            case '>': {
                if (source.hasNext()) {
                    switch (this.nextChar()) {
                        case '>': {
                            if (source.hasNext()) {
                                switch (this.nextChar()) {
                                    case '>': {
                                        if (source.hasNext()) {
                                            if (this.nextChar() == '=') {
                                                return new Token(lInitPos, source.getPosition(), Token.Id.USHR_ASN);
                                            }
                                            source.rewind();
                                        }
                                        return new Token(lInitPos, source.getPosition(), Token.Id.USHR);
                                    }
                                    case '=': {
                                        return new Token(lInitPos, source.getPosition(), Token.Id.SHR_ASN);
                                    }
                                }
                                source.rewind();
                            }
                            return new Token(lInitPos, source.getPosition(), Token.Id.SHR);
                        }
                        case '.': {
                            if (!source.hasNext()) break;
                            if (this.nextChar() == '.') {
                                if (source.hasNext()) {
                                    if (this.nextChar() == '<') {
                                        return new Token(lInitPos, source.getPosition(), Token.Id.E_RANGE_E);
                                    }
                                    source.rewind();
                                }
                                return new Token(lInitPos, source.getPosition(), Token.Id.E_RANGE_I);
                            }
                            source.rewind();
                            break;
                        }
                        case '=': {
                            return new Token(lInitPos, source.getPosition(), Token.Id.COMP_GTEQ);
                        }
                    }
                    source.rewind();
                }
                return new Token(lInitPos, source.getPosition(), Token.Id.COMP_GT);
            }
            case '&': {
                if (source.hasNext()) {
                    switch (this.nextChar()) {
                        case '&': {
                            if (source.hasNext()) {
                                if (this.nextChar() == '=') {
                                    return new Token(lInitPos, source.getPosition(), Token.Id.COND_AND_ASN);
                                }
                                source.rewind();
                            }
                            return new Token(lInitPos, source.getPosition(), Token.Id.COND_AND);
                        }
                        case '=': {
                            return new Token(lInitPos, source.getPosition(), Token.Id.BIT_AND_ASN);
                        }
                    }
                    source.rewind();
                }
                return new Token(lInitPos, source.getPosition(), Token.Id.BIT_AND);
            }
            case '|': {
                if (source.hasNext()) {
                    switch (this.nextChar()) {
                        case '|': {
                            if (source.hasNext()) {
                                if (this.nextChar() == '=') {
                                    return new Token(lInitPos, source.getPosition(), Token.Id.COND_OR_ASN);
                                }
                                source.rewind();
                            }
                            return new Token(lInitPos, source.getPosition(), Token.Id.COND_OR);
                        }
                        case '=': {
                            return new Token(lInitPos, source.getPosition(), Token.Id.BIT_OR_ASN);
                        }
                    }
                    source.rewind();
                }
                return new Token(lInitPos, source.getPosition(), Token.Id.BIT_OR);
            }
            case '=': {
                if (source.hasNext()) {
                    if (this.nextChar() == '=') {
                        return new Token(lInitPos, source.getPosition(), Token.Id.COMP_EQ);
                    }
                    source.rewind();
                }
                return new Token(lInitPos, source.getPosition(), Token.Id.ASN);
            }
            case '%': {
                if (source.hasNext()) {
                    if (this.nextChar() == '=') {
                        return new Token(lInitPos, source.getPosition(), Token.Id.MOD_ASN);
                    }
                    source.rewind();
                }
                return new Token(lInitPos, source.getPosition(), Token.Id.MOD);
            }
            case '!': {
                if (source.hasNext()) {
                    if (this.nextChar() == '=') {
                        return new Token(lInitPos, source.getPosition(), Token.Id.COMP_NEQ);
                    }
                    source.rewind();
                }
                return new Token(lInitPos, source.getPosition(), Token.Id.NOT);
            }
            case '^': {
                if (source.hasNext()) {
                    switch (this.nextChar()) {
                        case '^': {
                            return new Token(lInitPos, source.getPosition(), Token.Id.COND_XOR);
                        }
                        case '=': {
                            return new Token(lInitPos, source.getPosition(), Token.Id.BIT_XOR_ASN);
                        }
                        case '(': {
                            return new Token(lInitPos, source.getPosition(), Token.Id.ASYNC_PAREN);
                        }
                    }
                    source.rewind();
                }
                return new Token(lInitPos, source.getPosition(), Token.Id.BIT_XOR);
            }
            case '~': {
                return new Token(lInitPos, source.getPosition(), Token.Id.BIT_NOT);
            }
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                source.rewind();
                return this.eatNumericLiteral();
            }
            case '\'': {
                return this.eatCharLiteral(lInitPos);
            }
            case '\"': {
                return this.eatStringLiteral(lInitPos);
            }
            case '\\': {
                if (source.hasNext()) {
                    if (this.nextChar() == '|') {
                        return this.eatMultilineLiteral(lInitPos);
                    }
                    source.rewind();
                }
            }
            default: {
                if (Lexer.isIdentifierStart(chInit)) break;
                this.log(Severity.ERROR, ILLEGAL_CHAR, new Object[]{Handy.quotedChar(chInit)}, lInitPos);
            }
            case 'A': 
            case 'B': 
            case 'C': 
            case 'D': 
            case 'E': 
            case 'F': 
            case 'G': 
            case 'H': 
            case 'I': 
            case 'J': 
            case 'K': 
            case 'L': 
            case 'M': 
            case 'N': 
            case 'O': 
            case 'P': 
            case 'Q': 
            case 'R': 
            case 'S': 
            case 'T': 
            case 'U': 
            case 'V': 
            case 'W': 
            case 'X': 
            case 'Y': 
            case 'Z': 
            case '_': 
            case 'a': 
            case 'b': 
            case 'c': 
            case 'd': 
            case 'e': 
            case 'f': 
            case 'g': 
            case 'h': 
            case 'i': 
            case 'j': 
            case 'k': 
            case 'l': 
            case 'm': 
            case 'n': 
            case 'o': 
            case 'p': 
            case 'q': 
            case 'r': 
            case 's': 
            case 't': 
            case 'u': 
            case 'v': 
            case 'w': 
            case 'x': 
            case 'y': 
            case 'z': 
        }
        while (source.hasNext()) {
            if (Lexer.isIdentifierPart(this.nextChar())) continue;
            source.rewind();
            break;
        }
        String name = this.extractSource(lInitPos);
        long lPos = source.getPosition();
        if (source.hasNext()) {
            char chNext = source.next();
            if (name.equals(Token.Id.TODO.TEXT)) {
                source.rewind();
                if (chNext == '(') {
                    return new Token(lInitPos, source.getPosition(), Token.Id.TODO, null);
                }
                Token comment = this.eatSingleLineComment(lInitPos);
                return new Token(comment.getStartPosition(), comment.getEndPosition(), Token.Id.TODO, comment.getValue());
            }
            if (chNext == ':') {
                if (Token.Id.valueByPrefix(name) != null) {
                    String full;
                    while (source.hasNext()) {
                        if (Lexer.isIdentifierPart(this.nextChar())) continue;
                        source.rewind();
                        break;
                    }
                    if (Token.Id.valueByContextSensitiveText(full = this.extractSource(lInitPos)) != null) {
                        name = full;
                    } else {
                        source.setPosition(lPos);
                    }
                } else {
                    long lPosSuffix = source.getPosition();
                    while (source.hasNext()) {
                        if (Lexer.isIdentifierPart(this.nextChar())) continue;
                        source.rewind();
                        break;
                    }
                    String suffix = this.extractSource(lPosSuffix);
                    source.setPosition(lPosSuffix);
                    Token.Id idNum = null;
                    boolean fFloat = false;
                    if (Token.Id.valueByText(suffix) == null && source.hasNext() && !Lexer.isWhitespace(this.peekChar())) {
                        switch (name) {
                            case "Bit": {
                                idNum = Token.Id.LIT_BIT;
                                break;
                            }
                            case "Nibble": {
                                idNum = Token.Id.LIT_NIBBLE;
                                break;
                            }
                            case "Int8": {
                                idNum = Token.Id.LIT_INT8;
                                break;
                            }
                            case "Int16": {
                                idNum = Token.Id.LIT_INT16;
                                break;
                            }
                            case "Int32": {
                                idNum = Token.Id.LIT_INT32;
                                break;
                            }
                            case "Int": 
                            case "Int64": {
                                idNum = Token.Id.LIT_INT64;
                                break;
                            }
                            case "Int128": {
                                idNum = Token.Id.LIT_INT128;
                                break;
                            }
                            case "IntN": {
                                idNum = Token.Id.LIT_INTN;
                                break;
                            }
                            case "Byte": 
                            case "UInt8": {
                                idNum = Token.Id.LIT_UINT8;
                                break;
                            }
                            case "UInt16": {
                                idNum = Token.Id.LIT_UINT16;
                                break;
                            }
                            case "UInt32": {
                                idNum = Token.Id.LIT_UINT32;
                                break;
                            }
                            case "UInt": 
                            case "UInt64": {
                                idNum = Token.Id.LIT_UINT64;
                                break;
                            }
                            case "UInt128": {
                                idNum = Token.Id.LIT_UINT128;
                                break;
                            }
                            case "UIntN": {
                                idNum = Token.Id.LIT_UINTN;
                                break;
                            }
                            case "Dec32": {
                                idNum = Token.Id.LIT_DEC32;
                                fFloat = true;
                                break;
                            }
                            case "Dec": 
                            case "Dec64": {
                                idNum = Token.Id.LIT_DEC64;
                                fFloat = true;
                                break;
                            }
                            case "Dec128": {
                                idNum = Token.Id.LIT_DEC128;
                                fFloat = true;
                                break;
                            }
                            case "DecN": {
                                idNum = Token.Id.LIT_DECN;
                                fFloat = true;
                                break;
                            }
                            case "Float8e4": {
                                idNum = Token.Id.LIT_FLOAT8E4;
                                fFloat = true;
                                break;
                            }
                            case "Float8e5": {
                                idNum = Token.Id.LIT_FLOAT8E5;
                                fFloat = true;
                                break;
                            }
                            case "BFloat16": {
                                idNum = Token.Id.LIT_BFLOAT16;
                                fFloat = true;
                                break;
                            }
                            case "Float16": {
                                idNum = Token.Id.LIT_FLOAT16;
                                fFloat = true;
                                break;
                            }
                            case "Float": 
                            case "Float32": {
                                idNum = Token.Id.LIT_FLOAT32;
                                fFloat = true;
                                break;
                            }
                            case "Double": 
                            case "Float64": {
                                idNum = Token.Id.LIT_FLOAT64;
                                fFloat = true;
                                break;
                            }
                            case "Float128": {
                                idNum = Token.Id.LIT_FLOAT128;
                                fFloat = true;
                                break;
                            }
                            case "FloatN": {
                                idNum = Token.Id.LIT_FLOATN;
                                fFloat = true;
                                break;
                            }
                            case "Date": {
                                return this.eatDate(lInitPos, false);
                            }
                            case "TimeOfDay": {
                                return this.eatTimeOfDay(lInitPos, false);
                            }
                            case "Time": {
                                return this.eatTime(lInitPos);
                            }
                            case "TimeZone": {
                                return this.eatTimeZone(lInitPos);
                            }
                            case "Duration": {
                                return this.eatDuration(lInitPos);
                            }
                            case "Version": 
                            case "v": {
                                return this.eatVersion(lInitPos);
                            }
                            default: {
                                source.rewind();
                            }
                        }
                        if (idNum != null) {
                            Token tokNum = this.eatNumericLiteral();
                            switch (tokNum.getId()) {
                                case LIT_DEC: 
                                case LIT_FLOAT: {
                                    if (!fFloat) {
                                        this.log(Severity.ERROR, ILLEGAL_NUMBER, new Object[]{this.extractSource(lInitPos, tokNum.getEndPosition())}, lInitPos);
                                        return tokNum;
                                    }
                                }
                                case LIT_INT: {
                                    return tokNum.refine(idNum);
                                }
                            }
                            throw new IllegalStateException("id=" + String.valueOf((Object)idNum));
                        }
                    } else {
                        source.rewind();
                    }
                }
            } else {
                source.rewind();
            }
        }
        Token.Id id = Token.Id.valueByText(name);
        return new Token(lInitPos, source.getPosition(), id == null ? Token.Id.IDENTIFIER : id, name);
    }

    protected Token eatCharLiteral(long lInitPos) {
        Source source = this.m_source;
        long lPosChar = source.getPosition();
        int ch = 63;
        boolean term = false;
        if (source.hasNext()) {
            char c = source.next();
            ch = c;
            block0 : switch (c) {
                case '\'': {
                    if (!source.hasNext()) break;
                    if (source.next() == '\'') {
                        source.rewind();
                        this.log(Severity.ERROR, CHAR_BAD_ESC, null, lPosChar);
                        break;
                    }
                    source.rewind();
                    source.rewind();
                    this.log(Severity.ERROR, CHAR_NO_CHAR, null, lPosChar, lPosChar);
                    break;
                }
                case '\\': {
                    char c2 = source.next();
                    ch = c2;
                    switch (c2) {
                        case '\n': 
                        case '\u000b': 
                        case '\f': 
                        case '\r': 
                        case '\u0085': 
                        case '\u2028': 
                        case '\u2029': {
                            source.rewind();
                            this.log(Severity.ERROR, CHAR_NO_TERM, null, lInitPos);
                            ch = 92;
                            break block0;
                        }
                        case '\"': 
                        case '\'': 
                        case '\\': {
                            break block0;
                        }
                        case '0': {
                            ch = 0;
                            break block0;
                        }
                        case 'b': {
                            ch = 8;
                            break block0;
                        }
                        case 'd': {
                            ch = 127;
                            break block0;
                        }
                        case 'e': {
                            ch = 27;
                            break block0;
                        }
                        case 'f': {
                            ch = 12;
                            break block0;
                        }
                        case 'n': {
                            ch = 10;
                            break block0;
                        }
                        case 'r': {
                            ch = 13;
                            break block0;
                        }
                        case 't': {
                            ch = 9;
                            break block0;
                        }
                        case 'v': {
                            ch = 11;
                            break block0;
                        }
                        case 'z': {
                            ch = 26;
                            break block0;
                        }
                    }
                    this.log(Severity.ERROR, CHAR_BAD_ESC, null, lPosChar);
                    break;
                }
                case '\n': 
                case '\u000b': 
                case '\f': 
                case '\r': 
                case '\u0085': 
                case '\u2028': 
                case '\u2029': {
                    source.rewind();
                    this.log(Severity.ERROR, CHAR_NO_TERM, null, lInitPos);
                    break;
                }
            }
            if (source.hasNext()) {
                if (source.next() == '\'') {
                    term = true;
                } else {
                    source.rewind();
                }
            }
        }
        if (!term) {
            this.log(Severity.ERROR, CHAR_NO_TERM, null, lInitPos);
        }
        return new Token(lInitPos, source.getPosition(), Token.Id.LIT_CHAR, Character.valueOf((char)ch));
    }

    protected Token eatStringChars(long lInitPos, boolean fTemplate, boolean fMultiline) {
        Source source = this.m_source;
        StringBuilder sb = new StringBuilder();
        ArrayList<Object> list = fTemplate ? new ArrayList<Object>() : null;
        long lPosStart = lInitPos;
        block23: while (true) {
            if (source.hasNext()) {
                char ch = source.next();
                switch (ch) {
                    case '\"': {
                        if (!fMultiline) break block23;
                        sb.append(ch);
                        break;
                    }
                    case '\\': {
                        if (fMultiline) {
                            if (source.hasNext()) {
                                if (Lexer.isLineTerminator(source.next()) && this.isMultilineContinued()) continue block23;
                                source.rewind();
                            }
                            if (!fTemplate) {
                                sb.append(ch);
                                break;
                            }
                        }
                        ch = source.next();
                        switch (ch) {
                            case '\n': 
                            case '\u000b': 
                            case '\f': 
                            case '\r': 
                            case '\u0085': 
                            case '\u2028': 
                            case '\u2029': {
                                source.rewind();
                                this.log(Severity.ERROR, STRING_NO_TERM, null, lInitPos);
                                sb.append('\\');
                                break block23;
                            }
                            case '\\': {
                                sb.append('\\');
                                break;
                            }
                            case '\'': {
                                sb.append('\'');
                                break;
                            }
                            case '\"': {
                                sb.append('\"');
                                break;
                            }
                            case '0': {
                                sb.append('\u0000');
                                break;
                            }
                            case 'b': {
                                sb.append('\b');
                                break;
                            }
                            case 'd': {
                                sb.append('\u007f');
                                break;
                            }
                            case 'e': {
                                sb.append('\u001b');
                                break;
                            }
                            case 'f': {
                                sb.append('\f');
                                break;
                            }
                            case 'n': {
                                sb.append('\n');
                                break;
                            }
                            case 'r': {
                                sb.append('\r');
                                break;
                            }
                            case 't': {
                                sb.append('\t');
                                break;
                            }
                            case 'v': {
                                sb.append('\u000b');
                                break;
                            }
                            case 'z': {
                                sb.append('\u001a');
                                break;
                            }
                            case '{': {
                                if (fTemplate) {
                                    sb.append('{');
                                    break;
                                }
                            }
                            default: {
                                long lPosEscEnd = source.getPosition();
                                source.rewind();
                                source.rewind();
                                this.log(Severity.ERROR, STRING_BAD_ESC, null, source.getPosition(), lPosEscEnd);
                                source.setPosition(lPosEscEnd);
                                sb.append('\\').append(ch);
                                break;
                            }
                        }
                        continue block23;
                    }
                    case '\n': 
                    case '\u000b': 
                    case '\f': 
                    case '\r': 
                    case '\u0085': 
                    case '\u2028': 
                    case '\u2029': {
                        if (fMultiline) {
                            boolean fCRLF = false;
                            if (ch == '\r' && source.hasNext()) {
                                if (source.next() == '\n') {
                                    fCRLF = true;
                                } else {
                                    source.rewind();
                                }
                            }
                            if (this.isMultilineContinued()) {
                                if (fCRLF) {
                                    sb.append("\r\n");
                                    break;
                                }
                                sb.append(ch);
                                break;
                            }
                            source.rewind();
                            if (!fCRLF) break block23;
                            source.rewind();
                            break block23;
                        }
                        source.rewind();
                        this.log(Severity.ERROR, STRING_NO_TERM, null, lInitPos);
                        break block23;
                    }
                    case '{': {
                        if (fTemplate) {
                            long lPosStartExpr = source.getPosition();
                            source.rewind();
                            long lPosEndText = source.getPosition();
                            Token[] aTokens = this.eatTemplateExpression(fMultiline);
                            int cTokens = aTokens.length;
                            if (cTokens > 1 && aTokens[cTokens - 1].getId() == Token.Id.ASN) {
                                Token[] aTokensOld = aTokens;
                                aTokens = new Token[--cTokens];
                                System.arraycopy(aTokensOld, 0, aTokens, 0, cTokens);
                                sb.append(source.toString(lPosStartExpr, aTokensOld[cTokens].getEndPosition()));
                            }
                            if (!sb.isEmpty()) {
                                list.add(new Token(lPosStart, lPosEndText, Token.Id.LIT_STRING, sb.toString()));
                                sb = new StringBuilder();
                            }
                            list.add(aTokens);
                            lPosStart = source.getPosition();
                            break;
                        }
                    }
                    default: {
                        sb.append(ch);
                    }
                }
                continue;
            }
            this.log(Severity.ERROR, STRING_NO_TERM, null, lInitPos);
        }
        if (fTemplate) {
            long lPosCur = source.getPosition();
            if (!sb.isEmpty()) {
                list.add(new Token(lPosStart, lPosCur, Token.Id.LIT_STRING, sb.toString()));
            } else if (list.isEmpty()) {
                return new Token(lPosStart, lPosCur, Token.Id.LIT_STRING, "");
            }
            return new Token(lInitPos, lPosCur, Token.Id.TEMPLATE, list.toArray());
        }
        return new Token(lPosStart, source.getPosition(), Token.Id.LIT_STRING, sb.toString());
    }

    protected Token eatNumericLiteral() {
        Source source = this.m_source;
        long lStartPos = source.getPosition();
        int[] results = new int[2];
        PackedInteger piWhole = this.eatIntegerLiteral(results);
        int mantissaRadix = results[0];
        int signScalar = results[1];
        PackedInteger piFraction = null;
        int fractionalDigits = 0;
        if (source.hasNext()) {
            if (source.next() == '.') {
                if (source.hasNext()) {
                    boolean fNotDecimal = source.next() == '.';
                    source.rewind();
                    if (!fNotDecimal && !this.isNextCharDigit(mantissaRadix)) {
                        fNotDecimal = true;
                    }
                    if (fNotDecimal) {
                        source.rewind();
                        return new Token(lStartPos, source.getPosition(), Token.Id.LIT_INT, piWhole);
                    }
                }
                piFraction = this.eatDigits(false, mantissaRadix, results);
                fractionalDigits = results[0];
                if (fractionalDigits == 0) {
                    this.log(Severity.ERROR, ILLEGAL_NUMBER, lStartPos, lStartPos);
                }
            } else {
                source.rewind();
            }
        }
        PackedInteger piExp = null;
        boolean mustBeBinary = false;
        if (source.hasNext()) {
            char ch = source.next();
            switch (ch) {
                case 'E': 
                case 'e': {
                    piExp = this.eatIntegerLiteral(null);
                    break;
                }
                case 'P': 
                case 'p': {
                    piExp = this.eatIntegerLiteral(null);
                    mustBeBinary = true;
                    break;
                }
                default: {
                    long lEndPos = source.getPosition();
                    source.rewind();
                    if (!Lexer.isIdentifierPart(ch)) break;
                    this.log(Severity.ERROR, ILLEGAL_NUMBER, lStartPos, source.getPosition(), lEndPos);
                }
            }
        }
        long lPosEnd = source.getPosition();
        if (piFraction == null && piExp == null) {
            return new Token(lStartPos, lPosEnd, Token.Id.LIT_INT, piWhole);
        }
        if (!mustBeBinary && mantissaRadix == 10) {
            BigDecimal dec;
            BigInteger biWhole = piWhole.getBigInteger();
            if (piFraction == null) {
                dec = new BigDecimal(biWhole);
            } else {
                if (biWhole.signum() < 0) {
                    biWhole = biWhole.negate();
                }
                dec = new BigDecimal(biWhole.multiply(BigInteger.TEN.pow(fractionalDigits)).add(piFraction.getBigInteger()), fractionalDigits);
                if (signScalar < 0) {
                    dec = dec.negate();
                }
            }
            if (piExp != null) {
                long lExp = piExp.getLong();
                if (lExp > 6144L || lExp < -6143L) {
                    this.log(Severity.ERROR, ILLEGAL_NUMBER, lStartPos, lStartPos, lPosEnd);
                } else {
                    dec = dec.scaleByPowerOfTen((int)lExp);
                }
            }
            return new Token(lStartPos, lPosEnd, Token.Id.LIT_DEC, dec);
        }
        return new Token(lStartPos, lPosEnd, Token.Id.LIT_FLOAT, this.extractSource(lStartPos, lPosEnd));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected PackedInteger eatIntegerLiteral(int[] otherResults) {
        int iMul;
        Source source = this.m_source;
        boolean fNeg = false;
        char ch = this.needCharOrElse(ILLEGAL_NUMBER);
        if (ch == '+' || ch == '-') {
            fNeg = ch == '-';
            ch = this.needCharOrElse(ILLEGAL_NUMBER);
        }
        int radix = 10;
        if (ch == '0' && source.hasNext()) {
            switch (this.nextChar()) {
                case 'B': 
                case 'b': {
                    radix = 2;
                    break;
                }
                case 'o': {
                    radix = 8;
                    break;
                }
                case 'X': 
                case 'x': {
                    radix = 16;
                    break;
                }
                default: {
                    source.rewind();
                    source.rewind();
                    break;
                }
            }
        } else {
            source.rewind();
        }
        if (otherResults != null) {
            if (otherResults.length > 0) {
                otherResults[0] = radix;
            }
            if (otherResults.length > 1) {
                otherResults[1] = fNeg ? -1 : 1;
            }
        }
        PackedInteger pi = this.eatDigits(fNeg, radix, null);
        if (radix != 10) return pi;
        if (!source.hasNext()) return pi;
        switch (this.nextChar()) {
            case 'K': 
            case 'k': {
                iMul = 0;
                break;
            }
            case 'M': 
            case 'm': {
                iMul = 1;
                break;
            }
            case 'G': 
            case 'g': {
                iMul = 2;
                break;
            }
            case 'T': 
            case 't': {
                iMul = 3;
                break;
            }
            case 'P': 
            case 'p': {
                iMul = 4;
                break;
            }
            case 'E': 
            case 'e': {
                iMul = 5;
                break;
            }
            case 'Z': 
            case 'z': {
                iMul = 6;
                break;
            }
            case 'Y': 
            case 'y': {
                iMul = 7;
                break;
            }
            default: {
                source.rewind();
                return pi;
            }
        }
        PackedInteger[] factors = PackedInteger.xB_FACTORS;
        if (!source.hasNext()) return pi.mul(factors[iMul]);
        switch (this.nextChar()) {
            case 'B': 
            case 'b': {
                return pi.mul(factors[iMul]);
            }
            case 'I': 
            case 'i': {
                char optionalB;
                if (source.hasNext() && (optionalB = source.next()) != 'B' && optionalB != 'b') {
                    source.rewind();
                }
                factors = PackedInteger.xI_FACTORS;
                return pi.mul(factors[iMul]);
            }
            case '+': 
            case '-': 
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                if (iMul == 4 || iMul == 5) {
                    source.rewind();
                    source.rewind();
                    return pi;
                }
            }
            default: {
                source.rewind();
            }
        }
        return pi.mul(factors[iMul]);
    }

    protected long eatUnsignedLong() {
        long n = 0L;
        if (this.isNextCharDigit(10)) {
            do {
                if (n < 0L) {
                    return n;
                }
                n = n * 10L + (long)(this.nextChar() - 48);
            } while (this.isNextCharDigit(10));
            return n;
        }
        return -1L;
    }

    protected boolean isNextCharDigit(int radix) {
        boolean fDigit = false;
        Source source = this.m_source;
        if (source.hasNext()) {
            switch (this.nextChar()) {
                case 'A': 
                case 'B': 
                case 'C': 
                case 'D': 
                case 'E': 
                case 'F': 
                case 'a': 
                case 'b': 
                case 'c': 
                case 'd': 
                case 'e': 
                case 'f': {
                    fDigit = radix >= 16;
                    break;
                }
                case '8': 
                case '9': {
                    fDigit = radix >= 10;
                    break;
                }
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': {
                    fDigit = radix >= 8;
                    break;
                }
                case '0': 
                case '1': {
                    fDigit = true;
                    break;
                }
            }
            source.rewind();
        }
        return fDigit;
    }

    protected PackedInteger eatDigits(boolean fNeg, int radix, int[] digitCount) {
        long lValue = 0L;
        BigInteger bigint = null;
        boolean fError = false;
        int cDigits = 0;
        Source source = this.m_source;
        long lStartPos = source.getPosition();
        block7: while (source.hasNext()) {
            long lPos = source.getPosition();
            char ch = this.nextChar();
            switch (ch) {
                case 'A': 
                case 'B': 
                case 'C': 
                case 'D': 
                case 'E': 
                case 'F': 
                case 'a': 
                case 'b': 
                case 'c': 
                case 'd': 
                case 'e': 
                case 'f': {
                    if (radix >= 16) break;
                    if (ch != 'E' && ch != 'e' && !fError) {
                        this.log(Severity.ERROR, ILLEGAL_NUMBER, lStartPos, lPos);
                        fError = true;
                    }
                    source.rewind();
                    break block7;
                }
                case '8': 
                case '9': {
                    if (radix >= 10) break;
                    if (fError) continue block7;
                    this.log(Severity.ERROR, ILLEGAL_NUMBER, lStartPos, lPos);
                    fError = true;
                    continue block7;
                }
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': {
                    if (radix >= 8) break;
                    if (fError) continue block7;
                    this.log(Severity.ERROR, ILLEGAL_NUMBER, lStartPos, lPos);
                    fError = true;
                    continue block7;
                }
                case '0': 
                case '1': {
                    break;
                }
                case '_': {
                    if (cDigits != 0 || fError) continue block7;
                    this.log(Severity.ERROR, ILLEGAL_NUMBER, lStartPos, lPos);
                    fError = true;
                    continue block7;
                }
                default: {
                    source.rewind();
                    break block7;
                }
            }
            if (bigint == null) {
                if ((lValue = lValue * (long)radix + (long)Handy.hexitValue(ch)) > 0xFFFFFFFFFFFFFFL) {
                    bigint = BigInteger.valueOf(fNeg ? -lValue : lValue);
                }
            } else {
                bigint = bigint.multiply(BigInteger.valueOf(radix)).add(BigInteger.valueOf(Handy.hexitValue(ch)));
            }
            ++cDigits;
        }
        if (!fError && cDigits == 0) {
            this.log(Severity.ERROR, ILLEGAL_NUMBER, lStartPos, lStartPos);
        }
        if (digitCount != null && digitCount.length > 0) {
            digitCount[0] = cDigits;
        }
        return bigint == null ? new PackedInteger(fNeg ? -lValue : lValue) : new PackedInteger(bigint);
    }

    protected Token eatTime(long lInitPos) {
        Token tokDate = this.eatDate(lInitPos, true);
        if (!this.match('t') && !this.expect('T')) {
            this.log(Severity.ERROR, BAD_TIME, new Object[]{tokDate.getValue()}, tokDate.getStartPosition(), tokDate.getEndPosition());
            return tokDate;
        }
        Token tokTimeOfDay = this.eatTimeOfDay(lInitPos, true);
        long lEndPos = tokTimeOfDay.getEndPosition();
        String sDT = String.valueOf(tokDate.getValue()) + "T" + String.valueOf(tokTimeOfDay.getValue());
        if (this.match('Z') || this.match('z') || this.match('+') || this.match('-')) {
            this.m_source.rewind();
            Token tokZone = this.eatTimeZone(lInitPos);
            sDT = sDT + String.valueOf(tokZone.getValue());
            lEndPos = tokZone.getEndPosition();
        }
        return new Token(lInitPos, lEndPos, Token.Id.LIT_TIME, sDT);
    }

    protected Token eatTimeZone(long lInitPos) {
        if (this.match('Z') || this.match('z')) {
            this.peekNotIdentifierOrNumber();
            return new Token(lInitPos, this.m_source.getPosition(), Token.Id.LIT_TIMEZONE, "Z");
        }
        long lStart = this.m_source.getPosition();
        int nHour = 0;
        int nMin = 0;
        if ((this.match('-') || this.expect('+')) && (nHour = this.eatDigits(2)) >= 0) {
            if (this.match(':') || this.isNextCharDigit(10)) {
                nMin = this.eatDigits(2);
                if (nMin >= 0) {
                    this.peekNotIdentifierOrNumber();
                }
            } else {
                this.peekNotIdentifierOrNumber();
            }
        }
        long lEnd = this.m_source.getPosition();
        String sZone = this.extractSource(lStart, lEnd);
        if (nHour >= 0 && nMin >= 0 && (nHour > 16 || nMin > 59)) {
            this.log(Severity.ERROR, BAD_TIMEZONE, new Object[]{sZone}, lStart, lEnd);
        }
        return new Token(lInitPos, lEnd, Token.Id.LIT_TIMEZONE, sZone);
    }

    protected int eatDigits(int digitCount) {
        long lPosStart = this.m_source.getPosition();
        int n = 0;
        for (int i = 0; i < digitCount; ++i) {
            if (!this.isNextCharDigit(10)) {
                this.log(Severity.ERROR, EXPECTED_DIGITS, new Object[]{digitCount, i}, lPosStart);
                return -n;
            }
            n = n * 10 + (this.nextChar() - 48);
        }
        return n;
    }

    protected Token eatVersion(long lInitPos) {
        Version ver;
        Source source = this.m_source;
        ArrayList<Integer> listParts = new ArrayList<Integer>();
        boolean fSep = true;
        boolean fErr = false;
        long lPrev = 0L;
        while (this.isNextCharDigit(10)) {
            long lNum = this.eatUnsignedLong();
            if (lNum < 0L || lNum > Integer.MAX_VALUE) {
                if (!fErr) {
                    this.log(Severity.ERROR, "PARSER-04", null, lInitPos);
                    fErr = true;
                }
                lNum = 0L;
            }
            listParts.add((int)lNum);
            lPrev = this.mark();
            if (this.match('.')) {
                fSep = true;
                continue;
            }
            fSep = this.match('-');
            break;
        }
        int nNonGA = 0;
        char chAlpha = this.peekChar();
        switch (chAlpha) {
            case 'A': 
            case 'a': {
                if (!this.matchCaseInsens("alpha")) break;
                nNonGA = -3;
                break;
            }
            case 'B': 
            case 'b': {
                if (!this.matchCaseInsens("beta")) break;
                nNonGA = -2;
                break;
            }
            case 'C': 
            case 'c': {
                if (!this.matchCaseInsens("ci")) break;
                nNonGA = -6;
                break;
            }
            case 'D': 
            case 'd': {
                if (!this.matchCaseInsens("dev")) break;
                nNonGA = -5;
                break;
            }
            case 'Q': 
            case 'q': {
                if (!this.matchCaseInsens("qa")) break;
                nNonGA = -4;
                break;
            }
            case 'R': 
            case 'r': {
                if (!this.matchCaseInsens("rc")) break;
                nNonGA = -1;
            }
        }
        if (nNonGA == 0) {
            if (!fErr && (listParts.isEmpty() || !fSep && Lexer.isIdentifierPart(chAlpha))) {
                this.log(Severity.ERROR, "PARSER-04", null, lInitPos);
                fErr = true;
            }
            if (lPrev != 0L) {
                this.restore(lPrev);
            }
        } else {
            listParts.add(nNonGA);
            lPrev = this.mark();
            boolean bl = fSep = this.match('.') || this.match('-');
            if (this.isNextCharDigit(10)) {
                long lNum = this.eatUnsignedLong();
                if (lNum < 0L || lNum > Integer.MAX_VALUE || Lexer.isIdentifierPart(this.peekChar())) {
                    if (!fErr) {
                        this.log(Severity.ERROR, "PARSER-04", null, lInitPos);
                        fErr = true;
                    }
                    lNum = 0L;
                }
                listParts.add((int)lNum);
            } else {
                this.restore(lPrev);
            }
        }
        String sBuild = null;
        if (!fErr) {
            lPrev = this.mark();
            if (this.match('+')) {
                long lBuildEnd;
                long lBuildPos = source.getPosition();
                while (source.hasNext()) {
                    char ch = this.nextChar();
                    if (ch >= 'A' && ch <= 'Z' || ch >= 'a' && ch <= 'z' || ch >= '0' && ch <= '9' || ch == '-' || ch == '.') continue;
                    source.rewind();
                    break;
                }
                if (lBuildPos == (lBuildEnd = source.getPosition()) || Lexer.isIdentifierPart(this.peekChar())) {
                    this.restore(lPrev);
                } else {
                    sBuild = this.extractSource(lBuildPos, lBuildEnd);
                }
            } else if (Lexer.isIdentifierPart(this.peekChar())) {
                this.log(Severity.ERROR, "PARSER-04", null, lInitPos);
                fErr = true;
            }
        }
        if (fErr) {
            ver = new Version("0");
        } else {
            int c = listParts.size();
            int[] parts = new int[c];
            for (int i = 0; i < c; ++i) {
                parts[i] = (Integer)listParts.get(i);
            }
            ver = new Version(parts, sBuild);
        }
        return new Token(lInitPos, source.getPosition(), Token.Id.LIT_VERSION, ver);
    }

    protected Token eatDate(long lInitPos, boolean fContinued) {
        Source source = this.m_source;
        long lLitPos = source.getPosition();
        int nMonth = 0;
        int nDay = 0;
        int nYear = this.eatDigits(4);
        if (nYear >= 0) {
            boolean fSep = this.match('-');
            nMonth = this.eatDigits(2);
            if (nMonth >= 0) {
                if (fSep) {
                    this.expect('-');
                }
                if ((nDay = this.eatDigits(2)) >= 0 && !fContinued) {
                    this.peekNotIdentifierOrNumber();
                }
            }
        }
        long lEndPos = source.getPosition();
        String sDate = this.extractSource(lLitPos, lEndPos);
        if (nYear >= 0 && nMonth >= 0 && nDay >= 0 && (nYear < 1582 || nMonth < 1 || nMonth > 12 || nDay < 1 || nDay > 31)) {
            this.log(Severity.ERROR, BAD_DATE, new Object[]{sDate}, lLitPos, lEndPos);
        }
        return new Token(lInitPos, lEndPos, Token.Id.LIT_DATE, sDate);
    }

    protected Token eatTimeOfDay(long lInitPos, boolean fContinued) {
        Source source = this.m_source;
        long lStart = source.getPosition();
        int nMin = 0;
        int nSec = 0;
        long nPicos = 0L;
        int nHour = this.eatDigits(2);
        if (nHour >= 0) {
            boolean fSep = this.match(':');
            nMin = this.eatDigits(2);
            if (nMin >= 0) {
                if (fSep && this.match(':') || !fSep && this.isNextCharDigit(10)) {
                    nSec = this.eatDigits(2);
                    if (this.match('.')) {
                        if (this.isNextCharDigit(10)) {
                            int cDigits = 0;
                            do {
                                char ch = this.nextChar();
                                if (++cDigits > 12) continue;
                                nPicos = nPicos * 10L + (long)(ch - 48);
                            } while (this.isNextCharDigit(10));
                            while (++cDigits <= 12) {
                                nPicos *= 10L;
                            }
                        } else {
                            source.rewind();
                        }
                    }
                }
                if (!fContinued) {
                    this.peekNotIdentifierOrNumber();
                }
            }
        }
        long lEnd = source.getPosition();
        String sTime = this.extractSource(lStart, lEnd);
        if (nHour >= 0 && nMin >= 0 && nSec >= 0 && (nHour > 23 || nMin > 59 || nSec > 59 && (nHour != 23 || nMin != 59 || nSec != 60))) {
            this.log(Severity.ERROR, BAD_TIME_OF_DAY, new Object[]{sTime}, lStart, lEnd);
        }
        return new Token(lInitPos, lEnd, Token.Id.LIT_TIMEOFDAY, sTime);
    }

    public long mark() {
        long lPos = this.m_source.getPosition();
        assert ((lPos & Long.MIN_VALUE) == 0L);
        if (this.m_fWhitespace) {
            lPos |= Long.MIN_VALUE;
        }
        return lPos;
    }

    public void restore(long lPos) {
        this.m_fWhitespace = (lPos & Long.MIN_VALUE) != 0L;
        this.m_source.setPosition(lPos & Long.MAX_VALUE);
    }

    public char charAt(long lPos) {
        long lPrev = this.mark();
        this.restore(lPos);
        char ch = this.nextChar();
        this.restore(lPrev);
        return ch;
    }

    protected Token eatDuration(long lInitPos) {
        Source source = this.m_source;
        long lStart = source.getPosition();
        boolean fErr = false;
        if (!this.match('P')) {
            this.match('p');
        }
        int nPrevStage = this.match('T') ? 4 : 0;
        block8: while (true) {
            long lPos = source.getPosition();
            long lVal = this.eatUnsignedLong();
            if (lVal < 0L) {
                source.setPosition(lPos);
                break;
            }
            char ch = this.nextChar();
            switch (ch) {
                case 'Y': 
                case 'y': {
                    if (nPrevStage >= 1) {
                        fErr = true;
                    }
                    nPrevStage = Math.max(1, nPrevStage);
                    break;
                }
                case 'M': 
                case 'm': {
                    if (nPrevStage >= 2) {
                        if (nPrevStage < 4) {
                            fErr = true;
                        }
                        nPrevStage = Math.max(6, nPrevStage);
                        break;
                    }
                    nPrevStage = Math.max(2, nPrevStage);
                    break;
                }
                case 'D': 
                case 'd': {
                    if (nPrevStage >= 3) {
                        fErr = true;
                    }
                    nPrevStage = Math.max(3, nPrevStage);
                    break;
                }
                case 'H': 
                case 'h': {
                    if (nPrevStage >= 5) {
                        fErr = true;
                    }
                    nPrevStage = Math.max(5, nPrevStage);
                    break;
                }
                case 'S': 
                case 's': {
                    break block8;
                }
                case '.': {
                    if (nPrevStage >= 7) {
                        fErr = true;
                    }
                    nPrevStage = Math.max(7, nPrevStage);
                    break;
                }
                default: {
                    source.rewind();
                    fErr = true;
                    break block8;
                }
            }
            if (!this.match('T') && !this.match('t')) continue;
            if (nPrevStage >= 4) {
                fErr = true;
                continue;
            }
            nPrevStage = 4;
        }
        long lEnd = source.getPosition();
        String sDuration = this.extractSource(lStart, lEnd).toUpperCase();
        if (fErr) {
            this.log(Severity.ERROR, BAD_DURATION, new Object[]{sDuration}, lStart, lEnd);
        } else {
            this.peekNotIdentifierOrNumber();
        }
        return new Token(lStart, lEnd, Token.Id.LIT_DURATION, sDuration);
    }

    protected Token eatSingleLineComment(long lPosTokenStart) {
        Source source = this.m_source;
        long lPosTextStart = source.getPosition();
        while (source.hasNext()) {
            if (!Lexer.isLineTerminator(this.nextChar())) continue;
            source.rewind();
            break;
        }
        long lPosEnd = source.getPosition();
        return new Token(lPosTokenStart, lPosEnd, Token.Id.EOL_COMMENT, this.extractSource(lPosTextStart, lPosEnd));
    }

    protected Token eatEnclosedComment(long lPosTokenStart) {
        Source source = this.m_source;
        long lPosTextStart = source.getPosition();
        boolean fAsterisk = false;
        while (source.hasNext()) {
            char chNext = this.nextChar();
            if (chNext == '*') {
                fAsterisk = true;
                continue;
            }
            if (fAsterisk && chNext == '/') {
                long lPosTokenEnd = source.getPosition();
                source.rewind();
                source.rewind();
                long lPosTextEnd = source.getPosition();
                source.setPosition(lPosTokenEnd);
                return new Token(lPosTokenStart, lPosTokenEnd, Token.Id.ENC_COMMENT, this.extractSource(lPosTextStart, lPosTextEnd));
            }
            fAsterisk = false;
        }
        this.log(Severity.ERROR, EXPECTED_ENDCOMMENT, null, lPosTextStart);
        long lPosEnd = source.getPosition();
        return new Token(lPosTokenStart, lPosEnd, Token.Id.ENC_COMMENT, this.extractSource(lPosTextStart, lPosEnd));
    }

    protected boolean match(char ch) {
        char chActual;
        try {
            chActual = this.nextChar();
        }
        catch (NoSuchElementException e) {
            this.log(Severity.ERROR, UNEXPECTED_EOF, null, this.m_source.getPosition());
            return false;
        }
        if (chActual != ch) {
            this.m_source.rewind();
            return false;
        }
        return true;
    }

    protected boolean expect(char ch) {
        char chActual;
        try {
            chActual = this.nextChar();
        }
        catch (NoSuchElementException e) {
            this.log(Severity.ERROR, UNEXPECTED_EOF, null, this.m_source.getPosition());
            return false;
        }
        if (chActual != ch) {
            this.log(Severity.ERROR, EXPECTED_CHAR, new Object[]{String.valueOf(ch), String.valueOf(chActual)}, this.m_source.getPosition());
            return false;
        }
        return true;
    }

    protected boolean matchCaseInsens(String s) {
        int c = s.length();
        for (int i = 0; i < c; ++i) {
            char ch = s.charAt(i);
            if (this.match(ch) || this.match(Character.toLowerCase(ch)) || this.match(Character.toUpperCase(ch))) continue;
            return false;
        }
        char ch = this.peekChar();
        return !Lexer.isIdentifierPart(ch) || Handy.isDigit(ch);
    }

    protected void peekNotIdentifierOrNumber() {
        char ch = this.nextChar();
        long lEnd = this.m_source.getPosition();
        this.m_source.rewind();
        if (ch >= '0' && ch <= '9' || Lexer.isIdentifierPart(ch)) {
            this.log(Severity.ERROR, UNEXPECTED_CHAR, new Object[]{Character.valueOf(ch)}, this.m_source.getPosition(), lEnd);
        }
    }

    protected String extractSource(long lPosStart) {
        return this.extractSource(lPosStart, this.m_source.getPosition());
    }

    protected String extractSource(long lPosStart, long lPosEnd) {
        return this.m_source.toString(lPosStart, lPosEnd);
    }

    protected void log(Severity severity, String sCode, long lPosPrev, long lPosStart) {
        this.log(severity, sCode, lPosPrev, lPosStart, this.m_source.getPosition());
    }

    protected void log(Severity severity, String sCode, long lPosPrev, long lPosStart, long lPosEnd) {
        if (lPosPrev == lPosStart) {
            this.m_source.rewind();
            lPosPrev = this.m_source.getPosition();
            this.m_source.next();
        }
        this.log(severity, sCode, new Object[]{this.extractSource(lPosPrev, lPosEnd)}, lPosStart, lPosEnd);
    }

    protected void log(Severity severity, String sCode, Object[] aoParam, long lPosStart) {
        this.log(severity, sCode, aoParam, lPosStart, this.m_source.getPosition());
    }

    protected void log(Severity severity, String sCode, Object[] aoParam, long lPosStart, long lPosEnd) {
        if (this.m_errorListener.log(severity, sCode, aoParam, this.m_source, lPosStart, lPosEnd)) {
            throw new CompilerException("error list is full: " + String.valueOf(this.m_errorListener));
        }
    }

    public static boolean isWhitespace(char ch) {
        if (ch < '\u0080') {
            return ch <= ' ' && ch >= '\t' && (1 << ch - 9 & 0xFA001F) != 0;
        }
        return switch (ch) {
            case '\u0085', '\u00a0', '\u1680', '\u2000', '\u2001', '\u2002', '\u2003', '\u2004', '\u2005', '\u2006', '\u2007', '\u2008', '\u2009', '\u200a', '\u2028', '\u2029', '\u202f', '\u205f', '\u3000' -> true;
            default -> false;
        };
    }

    public static boolean isLineTerminator(char ch) {
        if (ch < '\u0080') {
            return ch >= '\n' && ch <= '\r';
        }
        return ch == '\u0085' | ch == '\u2028' | ch == '\u2029';
    }

    public static boolean isIdentifierStart(char ch) {
        return switch (Character.getType(ch)) {
            case 1 -> true;
            case 2 -> true;
            case 3 -> true;
            case 4 -> true;
            case 5 -> true;
            default -> ch == '_';
        };
    }

    public static boolean isIdentifierPart(char ch) {
        return switch (Character.getType(ch)) {
            case 1 -> true;
            case 2 -> true;
            case 3 -> true;
            case 4 -> true;
            case 5 -> true;
            case 6 -> true;
            case 8 -> true;
            case 7 -> true;
            case 9 -> true;
            case 10 -> true;
            case 11 -> true;
            case 26 -> true;
            default -> ch == '_';
        };
    }

    protected char peekChar() {
        char ch = this.m_source.next();
        this.m_source.rewind();
        return ch;
    }

    protected char nextChar() {
        Source source = this.m_source;
        char ch = source.next();
        if (ch == '\u001a' && source.hasNext()) {
            long lPos = source.getPosition();
            source.rewind();
            long lStartPos = source.getPosition();
            source.setPosition(lPos);
            this.log(Severity.ERROR, UNEXPECTED_EOF, null, lStartPos);
        }
        return ch;
    }

    protected char needCharOrElse(String sError) {
        try {
            return this.nextChar();
        }
        catch (NoSuchElementException e) {
            this.log(Severity.ERROR, sError, this.m_source.getPosition(), this.m_source.getPosition());
            return '}';
        }
    }
}

