/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.compiler;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.xvm.asm.ErrorList;
import org.xvm.asm.ErrorListener;
import org.xvm.asm.Version;
import org.xvm.compiler.CompilerException;
import org.xvm.compiler.Lexer;
import org.xvm.compiler.Source;
import org.xvm.compiler.Token;
import org.xvm.compiler.ast.AnnotatedTypeExpression;
import org.xvm.compiler.ast.AnnotationExpression;
import org.xvm.compiler.ast.ArrayAccessExpression;
import org.xvm.compiler.ast.ArrayTypeExpression;
import org.xvm.compiler.ast.AsExpression;
import org.xvm.compiler.ast.AssertStatement;
import org.xvm.compiler.ast.AssignmentStatement;
import org.xvm.compiler.ast.AstNode;
import org.xvm.compiler.ast.BadTypeExpression;
import org.xvm.compiler.ast.BiTypeExpression;
import org.xvm.compiler.ast.BreakStatement;
import org.xvm.compiler.ast.CaseStatement;
import org.xvm.compiler.ast.CatchStatement;
import org.xvm.compiler.ast.CmpChainExpression;
import org.xvm.compiler.ast.CmpExpression;
import org.xvm.compiler.ast.CompositionNode;
import org.xvm.compiler.ast.CondOpExpression;
import org.xvm.compiler.ast.ContinueStatement;
import org.xvm.compiler.ast.DecoratedTypeExpression;
import org.xvm.compiler.ast.ElseExpression;
import org.xvm.compiler.ast.ElvisExpression;
import org.xvm.compiler.ast.Expression;
import org.xvm.compiler.ast.ExpressionStatement;
import org.xvm.compiler.ast.FileExpression;
import org.xvm.compiler.ast.ForEachStatement;
import org.xvm.compiler.ast.ForStatement;
import org.xvm.compiler.ast.FunctionTypeExpression;
import org.xvm.compiler.ast.GotoStatement;
import org.xvm.compiler.ast.IfStatement;
import org.xvm.compiler.ast.IgnoredNameExpression;
import org.xvm.compiler.ast.ImportStatement;
import org.xvm.compiler.ast.InvocationExpression;
import org.xvm.compiler.ast.IsExpression;
import org.xvm.compiler.ast.KeywordTypeExpression;
import org.xvm.compiler.ast.LabeledExpression;
import org.xvm.compiler.ast.LabeledStatement;
import org.xvm.compiler.ast.LambdaExpression;
import org.xvm.compiler.ast.ListExpression;
import org.xvm.compiler.ast.LiteralExpression;
import org.xvm.compiler.ast.MapExpression;
import org.xvm.compiler.ast.MethodDeclarationStatement;
import org.xvm.compiler.ast.ModuleTypeExpression;
import org.xvm.compiler.ast.MultipleLValueStatement;
import org.xvm.compiler.ast.NameExpression;
import org.xvm.compiler.ast.NamedTypeExpression;
import org.xvm.compiler.ast.NewExpression;
import org.xvm.compiler.ast.NonBindingExpression;
import org.xvm.compiler.ast.NotNullExpression;
import org.xvm.compiler.ast.NullableTypeExpression;
import org.xvm.compiler.ast.Parameter;
import org.xvm.compiler.ast.ParenthesizedExpression;
import org.xvm.compiler.ast.PropertyDeclarationStatement;
import org.xvm.compiler.ast.RelOpExpression;
import org.xvm.compiler.ast.ReturnStatement;
import org.xvm.compiler.ast.SequentialAssignExpression;
import org.xvm.compiler.ast.Statement;
import org.xvm.compiler.ast.StatementBlock;
import org.xvm.compiler.ast.StatementExpression;
import org.xvm.compiler.ast.SwitchExpression;
import org.xvm.compiler.ast.SwitchStatement;
import org.xvm.compiler.ast.TemplateExpression;
import org.xvm.compiler.ast.TernaryExpression;
import org.xvm.compiler.ast.ThrowExpression;
import org.xvm.compiler.ast.TryStatement;
import org.xvm.compiler.ast.TupleExpression;
import org.xvm.compiler.ast.TupleTypeExpression;
import org.xvm.compiler.ast.TypeCompositionStatement;
import org.xvm.compiler.ast.TypeExpression;
import org.xvm.compiler.ast.TypedefStatement;
import org.xvm.compiler.ast.UnaryComplementExpression;
import org.xvm.compiler.ast.UnaryMinusExpression;
import org.xvm.compiler.ast.UnaryPlusExpression;
import org.xvm.compiler.ast.VariableDeclarationStatement;
import org.xvm.compiler.ast.VariableTypeExpression;
import org.xvm.compiler.ast.VersionOverride;
import org.xvm.compiler.ast.WhileStatement;
import org.xvm.tool.ResourceDir;
import org.xvm.util.Handy;
import org.xvm.util.ListMap;
import org.xvm.util.Severity;

public class Parser {
    public static final String FATAL_ERROR = "PARSER-01";
    public static final String UNEXPECTED_EOF = "PARSER-02";
    public static final String EXPECTED_TOKEN = "PARSER-03";
    public static final String BAD_VERSION = "PARSER-04";
    public static final String BAD_HEX_LITERAL = "PARSER-05";
    public static final String BAD_CUSTOM = "PARSER-06";
    public static final String NO_TOP_LEVEL = "PARSER-07";
    public static final String NOT_MULTI_ASN = "PARSER-08";
    public static final String NO_EMPTY_STMT = "PARSER-09";
    public static final String NONNARROW_CHILD = "PARSER-10";
    public static final String NO_CHILD_ACCESS = "PARSER-11";
    public static final String MISSING_CASE = "PARSER-12";
    public static final String ALL_OR_NO_DIMS = "PARSER-15";
    public static final String EXPECTED_EOF = "PARSER-16";
    public static final String NO_TYPE_FOUND = "PARSER-17";
    public static final String MODULE_NOT_ROOT = "PARSER-18";
    public static final String REPEAT_MODIFIER = "PARSER-19";
    public static final String MODIFIER_CONFLICT = "PARSER-20";
    public static final String REPEAT_DEFAULT = "PARSER-21";
    public static final String NOT_ASSIGNABLE = "PARSER-22";
    public static final String TEMPLATE_EXTRA = "PARSER-23";
    public static final String INVALID_PATH = "PARSER-24";
    public static final String BAD_CHAINED_EQ = "PARSER-25";
    public static final String BAD_CHAINED_CMP = "PARSER-26";
    public static final String EXT_TYPE_SYNTAX = "PARSER-27";
    private final Source m_source;
    private ErrorListener m_errorListener;
    private final Lexer m_lexer;
    private Token m_tokenPutBack;
    private Token m_tokenPrev;
    private Token m_token;
    private Token m_doc;
    private StatementBlock m_root;
    private boolean m_fDone;
    private boolean m_fAvoidRecovery;
    private SafeLookAhead m_lookAhead;

    public Parser(Source source, ErrorListener listener) {
        this(source, listener, new Lexer(source, listener));
    }

    protected Parser(Parser parent, Token[] atoken) {
        this(parent.m_source, parent.m_errorListener, parent.m_lexer.createLexer(atoken));
    }

    private Parser(Source source, ErrorListener errs, Lexer lexer) {
        if (source == null) {
            throw new IllegalArgumentException("Source required");
        }
        if (errs == null) {
            throw new IllegalArgumentException("ErrorListener required");
        }
        this.m_source = source;
        this.m_errorListener = errs;
        this.m_lexer = lexer;
        this.next();
    }

    public StatementBlock parseSource() {
        if (!this.m_fDone) {
            this.m_fDone = true;
            List<Statement> stmts = this.parseTypeCompositionComponents(null, new ArrayList<Statement>(), true);
            this.m_root = new StatementBlock(stmts, this.m_source, stmts.getFirst().getStartPosition(), stmts.getLast().getEndPosition());
            Token next = this.peek();
            if (next != null && next.getStartPosition() < next.getEndPosition()) {
                this.log(Severity.ERROR, EXPECTED_EOF, next.getStartPosition(), next.getEndPosition(), next);
            }
        }
        return this.m_root;
    }

    public Map<String, String[]> parseImplicits() {
        ListMap<String, String[]> imports = new ListMap<String, String[]>();
        while (!this.eof()) {
            ImportStatement stmt = this.parseImportStatement(null);
            imports.put(stmt.getAliasName(), stmt.getQualifiedName());
        }
        Token next = this.peek();
        if (next != null && next.getStartPosition() < next.getEndPosition()) {
            this.log(Severity.ERROR, EXPECTED_EOF, next.getStartPosition(), next.getEndPosition(), next);
        }
        return imports;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String parseModuleNameIgnoreEverythingElse() {
        ErrorListener errsPrev = this.m_errorListener;
        try {
            this.m_errorListener = ErrorListener.BLACKHOLE;
            block8: while (!this.eof()) {
                if (this.match(Token.Id.MODULE) != null) {
                    if (this.eof()) continue;
                    this.m_errorListener = new ErrorList(1);
                    List<Token> tokens = this.parseQualifiedName();
                    if (this.m_errorListener.hasSeriousErrors()) continue;
                    StringBuilder sb = new StringBuilder();
                    int c = tokens.size();
                    for (int i = 0; i < c; ++i) {
                        if (i > 0) {
                            sb.append('.');
                        }
                        sb.append(tokens.get(i).getValueText());
                    }
                    String string = sb.toString();
                    return string;
                }
                switch (this.current().getId()) {
                    case L_CURLY: 
                    case R_CURLY: {
                        return null;
                    }
                    default: {
                        continue block8;
                    }
                }
            }
            return null;
        }
        catch (RuntimeException runtimeException) {
            return null;
        }
        finally {
            this.m_errorListener = errsPrev;
        }
    }

    public TypeExpression parseClassExpression() {
        TypeExpression exprResult = null;
        do {
            AnnotationExpression annotation;
            ArrayList<AnnotationExpression> annotations = null;
            while ((annotation = this.parseAnnotation(false)) != null) {
                if (annotations == null) {
                    annotations = new ArrayList<AnnotationExpression>();
                }
                annotations.add(annotation);
            }
            List<Token> moduleNames = null;
            List<Token> classNames = this.parseQualifiedName();
            if (exprResult == null && this.match(Token.Id.COLON) != null) {
                moduleNames = classNames;
                classNames = this.parseQualifiedName(false);
            }
            List<TypeExpression> params = this.parseTypeParameterTypeList(false, true);
            exprResult = exprResult == null ? new NamedTypeExpression(moduleNames, classNames, params, this.prev().getEndPosition()) : new NamedTypeExpression(exprResult, classNames, params, this.prev().getEndPosition());
            if (annotations == null) continue;
            for (int i = annotations.size() - 1; i >= 0; --i) {
                exprResult = new AnnotatedTypeExpression((AnnotationExpression)annotations.get(i), exprResult);
            }
        } while (this.match(Token.Id.DOT) != null);
        while (!this.eof()) {
            this.expect(Token.Id.L_SQUARE);
            int cExplicitDims = 0;
            while (this.match(Token.Id.R_SQUARE) == null) {
                if (cExplicitDims > 0) {
                    this.expect(Token.Id.COMMA);
                }
                this.expect(Token.Id.COND);
                ++cExplicitDims;
            }
            exprResult = new ArrayTypeExpression(exprResult, cExplicitDims, this.prev().getEndPosition());
        }
        return exprResult;
    }

    TypeCompositionStatement parseTypeCompositionStatement() {
        Token doc = this.takeDoc();
        long lStartPos = this.peek().getStartPosition();
        List modifiers = null;
        List annotations = null;
        List[] twoLists = this.parseModifiers();
        if (twoLists != null) {
            modifiers = twoLists[0];
            annotations = twoLists[1];
        }
        return this.parseTypeDeclarationStatementAfterModifiers(lStartPos, null, doc, modifiers, annotations);
    }

    TypeCompositionStatement parseTypeDeclarationStatementAfterModifiers(long lStartPos, Expression exprCondition, Token doc, List<Token> modifiers, List<AnnotationExpression> annotations) {
        long lEndPos;
        Token name;
        List<Token> qualified = null;
        Token category = this.match(Token.Id.PACKAGE);
        if (category != null || (category = this.match(Token.Id.CLASS)) != null || (category = this.match(Token.Id.INTERFACE)) != null || (category = this.match(Token.Id.SERVICE)) != null || (category = this.match(Token.Id.CONST)) != null || (category = this.match(Token.Id.ENUM)) != null || (category = this.match(Token.Id.ANNOTATION)) != null || (category = this.match(Token.Id.MIXIN)) != null) {
            name = this.expect(Token.Id.IDENTIFIER);
        } else {
            category = this.expect(Token.Id.MODULE);
            qualified = this.parseQualifiedName();
            name = qualified.get(0);
        }
        List<Parameter> typeParams = this.parseTypeParameterList(false);
        List<Parameter> constructorParams = this.parseParameterList(false);
        List<CompositionNode> compositions = this.parseCompositions();
        StatementBlock body = null;
        if (this.peek(Token.Id.L_CURLY)) {
            body = this.parseTypeCompositionBody(category);
            lEndPos = body.getEndPosition();
        } else {
            lEndPos = this.prev().getEndPosition();
            this.expect(Token.Id.SEMICOLON);
        }
        return new TypeCompositionStatement(this.m_source, lStartPos, lEndPos, exprCondition, modifiers, annotations, category, name, qualified, typeParams, constructorParams, compositions, body, doc);
    }

    List<CompositionNode> parseCompositions() {
        ArrayList<CompositionNode> compositions = new ArrayList<CompositionNode>();
        block4: while (true) {
            TypeExpression type;
            Token keyword;
            if ((keyword = this.match(Token.Id.EXTENDS)) != null) {
                do {
                    type = this.parseExtendedTypeExpression();
                    List<Expression> args = this.parseArgumentList(false, false, false);
                    compositions.add(new CompositionNode.Extends(null, keyword, type, args, this.prev().getEndPosition()));
                } while (this.match(Token.Id.COMMA) != null);
                continue;
            }
            keyword = this.match(Token.Id.IMPLEMENTS);
            if (keyword != null) {
                do {
                    compositions.add(new CompositionNode.Implements(null, keyword, this.parseExtendedTypeExpression()));
                } while (this.match(Token.Id.COMMA) != null);
                continue;
            }
            keyword = this.match(Token.Id.DELEGATES);
            if (keyword != null) {
                do {
                    type = this.parseExtendedTypeExpression();
                    this.expect(Token.Id.L_PAREN);
                    Expression expr = this.parseExpression();
                    Token tokEnd = this.expect(Token.Id.R_PAREN);
                    compositions.add(new CompositionNode.Delegates(null, keyword, type, expr, tokEnd.getEndPosition()));
                } while (this.match(Token.Id.COMMA) != null);
                continue;
            }
            keyword = this.match(Token.Id.INCORPORATES);
            if (keyword != null) {
                do {
                    type = null;
                    List<Parameter> constraints = null;
                    if (this.match(Token.Id.CONDITIONAL) == null) {
                        type = this.parseTypeExpression();
                    } else {
                        do {
                            List<Token> names = this.parseQualifiedName();
                            List<Parameter> params = this.parseTypeParameterList(type == null);
                            ArrayList<TypeExpression> paramnames = null;
                            if (params != null) {
                                if (constraints == null) {
                                    constraints = params;
                                } else {
                                    constraints.addAll(params);
                                }
                                paramnames = new ArrayList<TypeExpression>();
                                for (Parameter param : params) {
                                    Token tokName = param.getNameToken();
                                    List<Token> listParamName = Collections.singletonList(tokName);
                                    paramnames.add(new NamedTypeExpression(null, listParamName, null, null, null, tokName.getEndPosition()));
                                }
                            }
                            TypeExpression typeExpression = type = type == null ? new NamedTypeExpression(null, names, null, null, paramnames, this.prev().getEndPosition()) : new NamedTypeExpression(type, names, paramnames, this.prev().getEndPosition());
                        } while (this.match(Token.Id.DOT) != null);
                    }
                    List<Expression> args = this.parseArgumentList(false, false, false);
                    compositions.add(new CompositionNode.Incorporates(null, keyword, type, args, constraints));
                } while (this.match(Token.Id.COMMA) != null);
                continue;
            }
            keyword = this.match(Token.Id.INTO);
            if (keyword != null) {
                compositions.add(new CompositionNode.Into(null, keyword, this.parseExtendedTypeExpression()));
                continue;
            }
            switch (this.peek().getId()) {
                case IMPORT: {
                    keyword = this.current();
                    Token modifier = this.match(Token.Id.EMBEDDED);
                    if (modifier != null || (modifier = this.match(Token.Id.REQUIRED)) != null || (modifier = this.match(Token.Id.DESIRED)) != null || (modifier = this.match(Token.Id.OPTIONAL)) != null) {
                        // empty if block
                    }
                    List<Token> names = this.parseQualifiedName();
                    ModuleTypeExpression module = new ModuleTypeExpression(names);
                    List<VersionOverride> versions = this.parseVersionRequirement(false);
                    List<Parameter> injects = this.parseResourceList();
                    NamedTypeExpression injector = null;
                    if (this.match(Token.Id.USING, injects != null) != null) {
                        injector = this.parseNamedTypeExpression(null);
                    }
                    compositions.add(new CompositionNode.Import(null, keyword, modifier, module, versions, injects, injector, this.prev().getEndPosition()));
                    continue block4;
                }
                case DEFAULT: {
                    keyword = this.expect(Token.Id.DEFAULT);
                    this.expect(Token.Id.L_PAREN);
                    compositions.add(new CompositionNode.Default(null, keyword, this.parseExpression(), this.expect(Token.Id.R_PAREN).getEndPosition()));
                    continue block4;
                }
            }
            break;
        }
        return compositions;
    }

    StatementBlock parseTypeCompositionBody(Token category) {
        ArrayList<Statement> stmts = new ArrayList<Statement>();
        Token tokLCurly = this.expect(Token.Id.L_CURLY);
        if (category.getId() == Token.Id.ENUM) {
            do {
                AnnotationExpression annotation;
                Token doc = this.takeDoc();
                long lStartPos = this.peek().getStartPosition();
                ArrayList<AnnotationExpression> annotations = null;
                while ((annotation = this.parseAnnotation(false)) != null) {
                    if (annotations == null) {
                        annotations = new ArrayList<AnnotationExpression>();
                    }
                    annotations.add(annotation);
                }
                Token name = this.expect(Token.Id.IDENTIFIER);
                List<TypeExpression> typeParams = this.parseTypeParameterTypeList(false, true);
                List<Expression> args = this.parseArgumentList(false, false, false);
                StatementBlock body = null;
                if (this.match(Token.Id.L_CURLY) != null) {
                    Token tokLCurly2 = this.prev();
                    body = new StatementBlock(this.parseTypeCompositionComponents(null, new ArrayList<Statement>(), false), tokLCurly2.getStartPosition(), this.prev().getEndPosition());
                }
                long lEndPos = this.prev().getEndPosition();
                stmts.add(new TypeCompositionStatement(annotations, name, typeParams, args, body, doc, lStartPos, lEndPos));
            } while (this.match(Token.Id.COMMA) != null && !this.peek(Token.Id.SEMICOLON) && !this.peek(Token.Id.R_CURLY));
            if (!this.peek(Token.Id.R_CURLY)) {
                this.expect(Token.Id.SEMICOLON);
            }
        }
        return new StatementBlock(this.parseTypeCompositionComponents(null, stmts, false), tokLCurly.getStartPosition(), this.prev().getEndPosition());
    }

    List<Statement> parseTypeCompositionComponents(Expression exprCondition, List<Statement> stmts, boolean fFileLevel) {
        boolean fFoundType = false;
        while (this.match(Token.Id.R_CURLY) == null) {
            MethodDeclarationStatement stmtFinally;
            Statement stmt;
            switch (this.peek().getId()) {
                case IMPORT: {
                    stmt = this.parseImportStatement(exprCondition);
                    break;
                }
                case TYPEDEF: {
                    stmt = this.parseTypeDefStatement(exprCondition, null);
                    break;
                }
                default: {
                    Token start = this.peek();
                    stmt = this.parseTypeCompositionComponent(exprCondition, false);
                    fFoundType = true;
                    if (!fFileLevel) break;
                    if (stmt instanceof TypeCompositionStatement) {
                        TypeCompositionStatement stmtType = (TypeCompositionStatement)stmt;
                        if (stmtType.getCategory().getId() != Token.Id.MODULE || stmts.isEmpty()) break;
                        if (stmts.stream().allMatch(ImportStatement.class::isInstance)) {
                            stmtType.ensureBody().getStatements().addAll(0, stmts);
                            stmts.clear();
                            break;
                        }
                        this.log(Severity.ERROR, MODULE_NOT_ROOT, start.getStartPosition(), start.getEndPosition(), new Object[0]);
                        break;
                    }
                    this.log(Severity.ERROR, NO_TYPE_FOUND, start.getStartPosition(), start.getEndPosition(), new Object[0]);
                    break;
                }
            }
            stmts.add(stmt);
            if (stmt instanceof MethodDeclarationStatement && (stmtFinally = ((MethodDeclarationStatement)stmt).getConstructorFinally()) != null) {
                stmts.add(stmtFinally);
            }
            if (!fFileLevel || !fFoundType) continue;
            break;
        }
        return stmts;
    }

    Statement parseTypeCompositionComponent(Expression exprCondition, boolean fInMethod) {
        TypeExpression type;
        assert (!fInMethod || exprCondition == null);
        Token doc = this.takeDoc();
        long lStartPos = this.peek().getStartPosition();
        List modifiers = null;
        List annotations = null;
        List[] twoLists = this.parseModifiers(true);
        if (twoLists != null) {
            modifiers = twoLists[0];
            annotations = twoLists[1];
        }
        switch (this.peek().getId()) {
            case TYPEDEF: {
                if (annotations != null) {
                    for (Object annotation : annotations) {
                        ((AstNode)annotation).log(this.m_errorListener, Severity.ERROR, "COMPILER-35", new Object[0]);
                    }
                }
                Token tokAccess = null;
                if (modifiers != null) {
                    block12: for (Token modifier : modifiers) {
                        switch (modifier.getId()) {
                            case PUBLIC: 
                            case PROTECTED: 
                            case PRIVATE: {
                                if (tokAccess != null) break;
                                tokAccess = modifier;
                                continue block12;
                            }
                        }
                        modifier.log(this.m_errorListener, this.m_source, Severity.ERROR, "COMPILER-15", modifier.getValueText());
                    }
                }
                return this.parseTypeDefStatement(exprCondition, tokAccess);
            }
            case COMP_LT: 
            case CONDITIONAL: 
            case VOID: {
                List<Parameter> typeVars = this.peek(Token.Id.COMP_LT) ? this.parseTypeParameterList(true) : null;
                Token conditional = this.match(Token.Id.CONDITIONAL);
                List<Parameter> returns = this.parseReturnList();
                Token name = this.expect(Token.Id.IDENTIFIER);
                return this.parseMethodDeclarationAfterName(lStartPos, exprCondition, doc, modifiers, annotations, typeVars, conditional, returns, name);
            }
            case CONSTRUCT: {
                if (fInMethod) {
                    ExpressionStatement stmt = new ExpressionStatement(this.parseExpression());
                    this.expect(Token.Id.SEMICOLON);
                    return stmt;
                }
                Token keyword = this.expect(Token.Id.CONSTRUCT);
                return this.parseMethodDeclarationAfterName(lStartPos, exprCondition, doc, modifiers, annotations, null, null, null, keyword);
            }
            case ASSERT: {
                assert (!fInMethod);
                Token keyword = this.expect(Token.Id.ASSERT);
                return this.parseMethodDeclarationAfterName(lStartPos, exprCondition, doc, modifiers, annotations, null, null, null, keyword);
            }
            case L_PAREN: {
                Mark mark = this.mark();
                ArrayList<Expression> listExpr = new ArrayList<Expression>();
                ArrayList<Token> listName = new ArrayList<Token>();
                boolean fAnyNames = false;
                Token start = this.expect(Token.Id.L_PAREN);
                do {
                    Expression exprType = null;
                    Token tokType = this.matchVarOrVal();
                    if (tokType != null) {
                        if (this.peekNameOrAny()) {
                            exprType = new VariableTypeExpression(tokType);
                        } else {
                            this.putBack(tokType);
                        }
                    }
                    if (exprType == null) {
                        exprType = this.parseExtendedExpression();
                    }
                    listExpr.add(exprType);
                    Token tokName = this.matchNameOrAny();
                    fAnyNames |= tokName != null;
                    listName.add(tokName);
                } while (this.match(Token.Id.COMMA) != null);
                if (this.match(Token.Id.R_PAREN) != null) {
                    Token tokAssign;
                    if (fInMethod && modifiers == null && ((tokAssign = this.match(Token.Id.ASN)) != null || (tokAssign = this.match(Token.Id.COND_ASN)) != null)) {
                        int cLVals = listExpr.size();
                        if (cLVals <= 1) {
                            this.log(Severity.ERROR, NOT_MULTI_ASN, start.getStartPosition(), this.peek().getEndPosition(), new Object[0]);
                            throw new CompilerException("multi assignment has only " + cLVals + " l-values");
                        }
                        Expression value = this.parseExpression();
                        this.expect(Token.Id.SEMICOLON);
                        ArrayList<AstNode> listLVals = new ArrayList<AstNode>(cLVals);
                        for (int i = 0; i < cLVals; ++i) {
                            Expression expr = (Expression)listExpr.get(i);
                            Token tokName = (Token)listName.get(i);
                            if (tokName == null) {
                                if (expr.isLValueSyntax()) {
                                    listLVals.add(expr);
                                    continue;
                                }
                                expr.log(this.m_errorListener, Severity.ERROR, NOT_ASSIGNABLE, new Object[0]);
                                continue;
                            }
                            listLVals.add(new VariableDeclarationStatement(expr.toTypeExpression(), tokName, false));
                        }
                        return new AssignmentStatement(new MultipleLValueStatement(listLVals), tokAssign, value);
                    }
                    if (fAnyNames || listExpr.size() > 1) {
                        int cReturns = listExpr.size();
                        ArrayList<Parameter> returns = new ArrayList<Parameter>(cReturns);
                        for (int i = 0; i < cReturns; ++i) {
                            Expression expr = (Expression)listExpr.get(i);
                            Token tokName = (Token)listName.get(i);
                            returns.add(new Parameter(expr.toTypeExpression(), tokName));
                        }
                        return this.parseMethodDeclarationAfterName(lStartPos, exprCondition, doc, modifiers, annotations, null, null, returns, this.expect(Token.Id.IDENTIFIER));
                    }
                }
                this.restore(mark);
            }
            default: {
                Token category = this.match(Token.Id.MODULE);
                if (category == null && (category = this.match(Token.Id.PACKAGE)) == null && (category = this.match(Token.Id.CLASS)) == null && (category = this.match(Token.Id.INTERFACE)) == null && (category = this.match(Token.Id.SERVICE)) == null && (category = this.match(Token.Id.CONST)) == null && (category = this.match(Token.Id.ENUM)) == null && (category = this.match(Token.Id.ANNOTATION)) == null && (category = this.match(Token.Id.MIXIN)) == null) break;
                this.putBack(category);
                if (fInMethod && (category.getId() == Token.Id.MODULE || category.getId() == Token.Id.PACKAGE)) {
                    this.log(Severity.ERROR, NO_TOP_LEVEL, this.peek().getStartPosition(), this.peek().getEndPosition(), new Object[0]);
                }
                return this.parseTypeDeclarationStatementAfterModifiers(lStartPos, exprCondition, doc, modifiers, annotations);
            }
            case VAL: 
            case VAR: 
        }
        Token tokType = this.matchVarOrVal();
        if (tokType != null) {
            if (!fInMethod) {
                Token tok = this.current();
                this.log(Severity.ERROR, NO_TYPE_FOUND, tok.getStartPosition(), tok.getEndPosition(), new Object[0]);
                throw new CompilerException("var or val keyword outside of method");
            }
            Token tokName = this.matchNameOrAny();
            if (tokName == null) {
                this.putBack(tokType);
            } else {
                VariableTypeExpression typeDecl = new VariableTypeExpression(tokType);
                VariableDeclarationStatement stmtDecl = new VariableDeclarationStatement(typeDecl, tokName, false);
                AssignmentStatement stmtAsn = new AssignmentStatement(stmtDecl, this.match(Token.Id.ASN), this.parseExpression());
                this.expect(Token.Id.SEMICOLON);
                return stmtAsn;
            }
        }
        if (fInMethod && modifiers == null && annotations == null) {
            Expression expr = this.parseExpression();
            Statement stmt = this.parsePossibleExpressionOrAssignmentStatement(expr);
            if (stmt != null) {
                return stmt;
            }
            type = expr.toTypeExpression();
        } else {
            type = this.parseTypeExpression();
        }
        if (type instanceof BadTypeExpression) {
            this.log(Severity.ERROR, NO_TYPE_FOUND, lStartPos, this.m_token.getStartPosition(), new Object[0]);
        }
        Token name = this.expectNameOrAny();
        if (this.peek(Token.Id.COMP_LT) || this.peek(Token.Id.L_PAREN)) {
            return this.parseMethodDeclarationAfterName(lStartPos, exprCondition, doc, modifiers, annotations, null, null, Collections.singletonList(new Parameter(type)), name);
        }
        if (fInMethod && modifiers == null) {
            return this.parseVariableDeclarationAfterName(annotations, type, name);
        }
        return this.parsePropertyDeclarationFinish(lStartPos, exprCondition, doc, modifiers, annotations, type, name);
    }

    Statement parsePossibleExpressionOrAssignmentStatement(Expression expr) {
        switch (this.peek().getId()) {
            case SEMICOLON: {
                this.expect(Token.Id.SEMICOLON);
                return new ExpressionStatement(expr);
            }
            case ASN: 
            case ADD_ASN: 
            case SUB_ASN: 
            case MUL_ASN: 
            case DIV_ASN: 
            case MOD_ASN: 
            case SHL_ASN: 
            case SHR_ASN: 
            case USHR_ASN: 
            case BIT_AND_ASN: 
            case BIT_OR_ASN: 
            case BIT_XOR_ASN: 
            case COND_ASN: 
            case COND_AND_ASN: 
            case COND_OR_ASN: 
            case COND_NN_ASN: 
            case COND_ELSE_ASN: {
                AssignmentStatement stmt = new AssignmentStatement(expr, this.current(), this.parseExpression());
                this.expect(Token.Id.SEMICOLON);
                return stmt;
            }
        }
        return null;
    }

    Statement parseVariableDeclarationAfterName(List<AnnotationExpression> annotations, TypeExpression type, Token name) {
        Expression value = null;
        Token op = this.match(Token.Id.ASN);
        if (op != null) {
            value = this.parseExpression();
        }
        this.expect(Token.Id.SEMICOLON);
        if (annotations != null) {
            for (int i = annotations.size() - 1; i >= 0; --i) {
                AnnotationExpression annotation = annotations.get(i);
                type = new AnnotatedTypeExpression(annotation, type);
            }
        }
        Statement stmt = new VariableDeclarationStatement(type, name, value == null);
        if (value != null) {
            stmt = new AssignmentStatement(stmt, op, value);
        }
        return stmt;
    }

    MethodDeclarationStatement parseMethodDeclarationAfterName(long lStartPos, Expression exprCondition, Token doc, List<Token> modifiers, List<AnnotationExpression> annotations, List<Parameter> typeVars, Token conditional, List<Parameter> returns, Token name) {
        StatementBlock body;
        List<TypeExpression> redundantReturns = this.parseTypeParameterTypeList(false, true);
        List<Parameter> params = this.parseParameterList(true);
        long lEndPos = this.prev().getEndPosition();
        switch (this.peek().getId()) {
            case SEMICOLON: {
                body = null;
                this.expect(Token.Id.SEMICOLON);
                break;
            }
            case ASN: {
                Token eq = this.expect(Token.Id.ASN);
                Expression expr = this.parseExpression();
                Token semi = this.expect(Token.Id.SEMICOLON);
                ReturnStatement stmt = new ReturnStatement(eq, expr);
                body = new StatementBlock(Arrays.asList(stmt), stmt.getStartPosition(), semi.getEndPosition());
                break;
            }
            default: {
                body = this.parseStatementBlock();
            }
        }
        Token tokFinally = null;
        StatementBlock stmtFinally = null;
        if (body != null) {
            if (name.getId() == Token.Id.CONSTRUCT && (tokFinally = this.match(Token.Id.FINALLY)) != null) {
                stmtFinally = this.parseStatementBlock();
                lEndPos = stmtFinally.getEndPosition();
            } else {
                lEndPos = body.getEndPosition();
            }
        }
        return new MethodDeclarationStatement(lStartPos, lEndPos, exprCondition, modifiers, annotations, typeVars, conditional, returns, name, redundantReturns, params, body, tokFinally, stmtFinally, doc);
    }

    PropertyDeclarationStatement parsePropertyDeclarationFinish(long lStartPos, Expression exprCondition, Token doc, List<Token> modifiers, List<AnnotationExpression> annotations, TypeExpression type, Token name) {
        StatementBlock body = null;
        long lEndPos = this.prev().getEndPosition();
        boolean fNeedsSemi = false;
        if (this.match(Token.Id.DOT) != null) {
            StatementBlock block;
            Token methodName = this.expect(Token.Id.IDENTIFIER);
            List<Parameter> params = this.parseParameterList(true);
            Token eq = this.match(Token.Id.ASN);
            if (eq != null) {
                Expression expr = this.parseExpression();
                ReturnStatement stmt = new ReturnStatement(eq, expr);
                block = new StatementBlock(Arrays.asList(stmt), stmt.getStartPosition(), stmt.getEndPosition());
                fNeedsSemi = true;
            } else {
                block = this.parseStatementBlock();
            }
            MethodDeclarationStatement method = new MethodDeclarationStatement(methodName.getStartPosition(), block.getEndPosition(), null, null, null, null, null, null, methodName, null, params, block, null, null, null);
            body = new StatementBlock(Collections.singletonList(method), method.getStartPosition(), method.getEndPosition());
            lEndPos = body.getEndPosition();
        } else if (this.peek(Token.Id.L_CURLY)) {
            body = this.parseTypeCompositionBody(new Token(name.getStartPosition(), name.getEndPosition(), Token.Id.CLASS));
            lEndPos = body.getEndPosition();
        }
        Token tokAsn = this.match(Token.Id.ASN);
        Expression value = null;
        if (tokAsn != null) {
            value = this.parseExpression();
            lEndPos = value.getEndPosition();
            this.expect(Token.Id.SEMICOLON);
        } else if (body == null || fNeedsSemi) {
            this.expect(Token.Id.SEMICOLON);
        }
        return new PropertyDeclarationStatement(lStartPos, lEndPos, exprCondition, modifiers, annotations, type, name, tokAsn, value, body, doc);
    }

    StatementBlock parseStatementBlock() {
        Token tokStart = this.expect(Token.Id.L_CURLY);
        ArrayList<Statement> stmts = new ArrayList<Statement>();
        while (this.match(Token.Id.R_CURLY) == null) {
            stmts.add(this.parseStatement());
        }
        return new StatementBlock(stmts, tokStart.getStartPosition(), this.prev().getEndPosition());
    }

    Statement parseStatement() {
        switch (this.peek().getId()) {
            case SEMICOLON: {
                Token tokSemi = this.match(Token.Id.SEMICOLON);
                this.log(Severity.ERROR, NO_EMPTY_STMT, tokSemi.getStartPosition(), tokSemi.getEndPosition(), new Object[0]);
                return new StatementBlock(null, tokSemi.getStartPosition(), tokSemi.getEndPosition());
            }
            case L_CURLY: {
                return this.parseStatementBlock();
            }
            case ASSERT: 
            case ASSERT_RND: 
            case ASSERT_ARG: 
            case ASSERT_BOUNDS: 
            case ASSERT_TODO: 
            case ASSERT_ONCE: 
            case ASSERT_TEST: 
            case ASSERT_DBG: {
                return this.parseAssertStatement();
            }
            case BREAK: 
            case CONTINUE: {
                Token keyword = this.current();
                Token name = this.match(Token.Id.IDENTIFIER);
                GotoStatement stmt = keyword.getId() == Token.Id.BREAK ? new BreakStatement(keyword, name) : new ContinueStatement(keyword, name);
                this.expect(Token.Id.SEMICOLON);
                return stmt;
            }
            case DO: {
                return this.parseDoStatement();
            }
            case FOR: {
                return this.parseForStatement();
            }
            case IF: {
                return this.parseIfStatement();
            }
            case IMPORT: {
                return this.parseImportStatement(null);
            }
            case RETURN: {
                return this.parseReturnStatement();
            }
            case SWITCH: {
                return this.parseSwitchStatement();
            }
            case TRY: {
                return this.parseTryStatement();
            }
            case TYPEDEF: {
                return this.parseTypeDefStatement(null, null);
            }
            case USING: {
                return this.parseUsingStatement();
            }
            case WHILE: {
                return this.parseWhileStatement();
            }
            case IDENTIFIER: {
                Token decl = null;
                decl = this.match(Token.Id.CLASS);
                if (decl != null || (decl = this.match(Token.Id.INTERFACE)) != null || (decl = this.match(Token.Id.SERVICE)) != null || (decl = this.match(Token.Id.CONST)) != null || (decl = this.match(Token.Id.ENUM)) != null || (decl = this.match(Token.Id.ANNOTATION)) != null || (decl = this.match(Token.Id.MIXIN)) != null) {
                    this.putBack(decl);
                    return this.parseTypeCompositionStatement();
                }
                Token name = this.expect(Token.Id.IDENTIFIER);
                if (!name.hasTrailingWhitespace() && this.peek(Token.Id.COLON) && this.peek().hasTrailingWhitespace()) {
                    this.expect(Token.Id.COLON);
                    return new LabeledStatement(name, this.parseStatement());
                }
                this.putBack(name);
            }
        }
        return this.parseTypeCompositionComponent(null, true);
    }

    Statement parseAssertStatement() {
        Token keyword = this.current();
        long lEndPos = keyword.getEndPosition();
        Expression exprRate = null;
        if (keyword.getId() == Token.Id.ASSERT_RND) {
            if (keyword.hasTrailingWhitespace()) {
                long lPos = keyword.getEndPosition();
                char ch = this.m_lexer.charAt(lPos);
                this.log(Severity.ERROR, "LEXER-11", lPos, lPos, "(", Handy.appendChar(new StringBuilder(), ch).toString());
            }
            this.expect(Token.Id.L_PAREN);
            exprRate = this.parseExpression();
            lEndPos = this.expect(Token.Id.R_PAREN).getEndPosition();
        }
        List<AstNode> conds = null;
        if (!this.peek(Token.Id.SEMICOLON) && !this.peek(Token.Id.AS)) {
            conds = this.parseConditionList();
            lEndPos = conds.getLast().getEndPosition();
        }
        Expression exprMsg = null;
        if (this.match(Token.Id.AS) != null) {
            exprMsg = this.parseExpression();
            lEndPos = exprMsg.getEndPosition();
        }
        this.expect(Token.Id.SEMICOLON);
        return new AssertStatement(keyword, exprRate, conds, exprMsg, lEndPos);
    }

    Statement parseDoStatement() {
        Token keyword = this.expect(Token.Id.DO);
        StatementBlock block = this.parseStatementBlock();
        this.expect(Token.Id.WHILE);
        this.expect(Token.Id.L_PAREN);
        List<AstNode> conds = this.parseConditionList();
        long lEndPos = this.expect(Token.Id.R_PAREN).getEndPosition();
        this.expect(Token.Id.SEMICOLON);
        return new WhileStatement(keyword, conds, block, lEndPos);
    }

    Statement parseForStatement() {
        Token keyword = this.expect(Token.Id.FOR);
        this.expect(Token.Id.L_PAREN);
        ArrayList<Statement> init = new ArrayList<Statement>();
        if (!this.peek(Token.Id.SEMICOLON)) {
            boolean fFirst = true;
            do {
                AstNode LVal;
                if ((LVal = this.peekMultiVariableInitializer()) == null) {
                    Token tokType = this.matchVarOrVal();
                    if (tokType != null) {
                        Token tokName = this.match(Token.Id.IDENTIFIER);
                        if (tokName == null) {
                            this.putBack(tokType);
                        } else {
                            LVal = new VariableDeclarationStatement(new VariableTypeExpression(tokType), tokName, false);
                        }
                    }
                    if (LVal == null) {
                        Expression expr = this.parseTernaryExpression();
                        if (this.peek(Token.Id.IDENTIFIER)) {
                            LVal = new VariableDeclarationStatement(expr.toTypeExpression(), this.expect(Token.Id.IDENTIFIER), false);
                        } else {
                            if (!expr.isLValueSyntax()) {
                                this.log(Severity.ERROR, NOT_ASSIGNABLE, expr.getStartPosition(), expr.getEndPosition(), new Object[0]);
                            }
                            LVal = expr;
                        }
                    }
                }
                if (fFirst && this.peek(Token.Id.COLON)) {
                    AssignmentStatement cond = new AssignmentStatement(LVal, this.expect(Token.Id.COLON), this.parseExpression(), false);
                    this.expect(Token.Id.R_PAREN);
                    return new ForEachStatement(keyword, cond, this.parseStatementBlock());
                }
                init.add(new AssignmentStatement(LVal, this.expect(Token.Id.ASN), this.parseExpression(), false));
                fFirst = false;
            } while (this.match(Token.Id.COMMA) != null);
        }
        this.expect(Token.Id.SEMICOLON);
        List<AstNode> conds = this.peek(Token.Id.SEMICOLON) ? null : this.parseConditionList();
        this.expect(Token.Id.SEMICOLON);
        ArrayList<Statement> update = new ArrayList<Statement>();
        block5: while (!this.peek(Token.Id.R_PAREN)) {
            if (!update.isEmpty()) {
                this.expect(Token.Id.COMMA);
            }
            Expression exprUpdate = this.parseExpression();
            Token.Id op = Token.Id.ASN;
            switch (this.peek().getId()) {
                case R_PAREN: 
                case COMMA: {
                    update.add(new ExpressionStatement(exprUpdate, false));
                    continue block5;
                }
                case ADD_ASN: 
                case SUB_ASN: 
                case MUL_ASN: 
                case DIV_ASN: 
                case MOD_ASN: 
                case SHL_ASN: 
                case SHR_ASN: 
                case USHR_ASN: 
                case BIT_AND_ASN: 
                case BIT_OR_ASN: 
                case BIT_XOR_ASN: 
                case COND_ASN: 
                case COND_AND_ASN: 
                case COND_OR_ASN: 
                case COND_NN_ASN: 
                case COND_ELSE_ASN: {
                    op = this.peek().getId();
                }
            }
            if (!exprUpdate.isLValueSyntax()) {
                this.log(Severity.ERROR, NOT_ASSIGNABLE, exprUpdate.getStartPosition(), exprUpdate.getEndPosition(), new Object[0]);
            }
            update.add(new AssignmentStatement(exprUpdate, this.expect(op), this.parseExpression(), false));
        }
        this.expect(Token.Id.R_PAREN);
        return new ForStatement(keyword, init, conds, update, this.parseStatementBlock());
    }

    Statement parseIfStatement() {
        Token keyword = this.expect(Token.Id.IF);
        this.expect(Token.Id.L_PAREN);
        List<AstNode> conds = this.parseConditionList();
        this.expect(Token.Id.R_PAREN);
        StatementBlock block = this.parseStatementBlock();
        if (this.match(Token.Id.ELSE) == null) {
            return new IfStatement(keyword, conds, block);
        }
        Statement stmtElse = this.peek(Token.Id.IF) ? this.parseIfStatement() : this.parseStatementBlock();
        return new IfStatement(keyword, conds, block, stmtElse);
    }

    List<AstNode> parseConditionList() {
        ArrayList<AstNode> list = new ArrayList<AstNode>(4);
        do {
            list.add(this.parseCondition(false));
        } while (this.match(Token.Id.COMMA) != null && !this.peek(Token.Id.R_PAREN));
        return list;
    }

    AstNode parseCondition(boolean fNegated) {
        Token tokAsn;
        AstNode LVal;
        if (!fNegated && this.peek(Token.Id.NOT)) {
            Token tokNot = null;
            AssignmentStatement stmtAsn = null;
            try (SafeLookAhead attempt2 = new SafeLookAhead();){
                tokNot = this.expect(Token.Id.NOT);
                if (this.match(Token.Id.L_PAREN) != null) {
                    AstNode stmtPeek = this.parseCondition(true);
                    if (attempt2.isClean() && stmtPeek instanceof AssignmentStatement) {
                        stmtAsn = (AssignmentStatement)stmtPeek;
                        attempt2.keepResults();
                    }
                }
            }
            catch (CompilerException attempt2) {
                // empty catch block
            }
            if (stmtAsn != null) {
                stmtAsn.negate(tokNot, this.expect(Token.Id.R_PAREN));
                return stmtAsn;
            }
        }
        if ((LVal = this.peekMultiVariableInitializer()) == null) {
            Token tokType = this.matchVarOrVal();
            if (tokType != null) {
                Token tokName = this.match(Token.Id.IDENTIFIER);
                if (tokName == null) {
                    this.putBack(tokType);
                } else {
                    LVal = new VariableDeclarationStatement(new VariableTypeExpression(tokType), tokName, false);
                }
            }
            if (LVal == null) {
                Expression expr = this.parseExpression();
                if (this.peek(Token.Id.IDENTIFIER)) {
                    LVal = new VariableDeclarationStatement(expr.toTypeExpression(), this.expect(Token.Id.IDENTIFIER), false);
                } else {
                    switch (this.peek().getId()) {
                        case COND_ASN: 
                        case COND_NN_ASN: {
                            if (!expr.isLValueSyntax()) {
                                this.log(Severity.ERROR, NOT_ASSIGNABLE, expr.getStartPosition(), expr.getEndPosition(), new Object[0]);
                            }
                            LVal = expr;
                            break;
                        }
                        default: {
                            return fNegated ? null : expr;
                        }
                    }
                }
            }
        }
        if ((tokAsn = this.match(Token.Id.COND_NN_ASN)) == null) {
            tokAsn = this.expect(Token.Id.COND_ASN);
        }
        return new AssignmentStatement(LVal, tokAsn, this.parseExpression(), false);
    }

    ImportStatement parseImportStatement(Expression exprCond) {
        ArrayList<Token> qualifiedName = new ArrayList<Token>();
        Token simpleName = null;
        Token keyword = this.expect(Token.Id.IMPORT);
        boolean first = true;
        while (first || this.match(Token.Id.DOT) != null) {
            if (!first && this.match(Token.Id.MUL) != null) {
                Token star = this.prev();
                this.expect(Token.Id.SEMICOLON);
                return new ImportStatement(exprCond, keyword, qualifiedName, star);
            }
            simpleName = this.expect(Token.Id.IDENTIFIER);
            qualifiedName.add(simpleName);
            first = false;
        }
        if (simpleName != null && this.match(Token.Id.AS) != null) {
            simpleName = this.expect(Token.Id.IDENTIFIER);
        }
        this.expect(Token.Id.SEMICOLON);
        return new ImportStatement(exprCond, keyword, simpleName, qualifiedName);
    }

    ReturnStatement parseReturnStatement() {
        Token keyword = this.expect(Token.Id.RETURN);
        if (this.match(Token.Id.SEMICOLON) != null) {
            return new ReturnStatement(keyword);
        }
        List<Expression> exprs = this.parseExpressionList();
        this.expect(Token.Id.SEMICOLON);
        return new ReturnStatement(keyword, exprs);
    }

    Statement parseSwitchStatement() {
        Token keyword = this.expect(Token.Id.SWITCH);
        this.expect(Token.Id.L_PAREN);
        List<AstNode> cond = this.parseSwitchCondition();
        this.expect(Token.Id.R_PAREN);
        Token tokLCurly = this.expect(Token.Id.L_CURLY);
        ArrayList<Statement> stmts = new ArrayList<Statement>();
        boolean fDefault = false;
        do {
            fDefault |= this.parseSwitchBlock(stmts, fDefault);
        } while (this.match(Token.Id.R_CURLY) == null);
        if (stmts.isEmpty()) {
            this.putBack(this.prev());
            this.expect(Token.Id.CASE);
        }
        return new SwitchStatement(keyword, cond, new StatementBlock(stmts, tokLCurly.getStartPosition(), this.prev().getEndPosition()));
    }

    private boolean parseSwitchBlock(List<Statement> stmts, boolean fDefault) {
        boolean fAnyLabels = false;
        boolean fAnyStmts = false;
        block5: while (true) {
            switch (this.peek().getId()) {
                case CASE: {
                    if (fAnyStmts) {
                        return fDefault;
                    }
                    stmts.add(new CaseStatement(this.current(), this.parseCaseOptionList(), this.expect(Token.Id.COLON)));
                    fAnyLabels = true;
                    continue block5;
                }
                case DEFAULT: {
                    if (fAnyStmts) {
                        return fDefault;
                    }
                    Token tokDefault = this.current();
                    if (fDefault) {
                        this.log(Severity.ERROR, REPEAT_DEFAULT, tokDefault.getStartPosition(), tokDefault.getEndPosition(), new Object[0]);
                    }
                    stmts.add(new CaseStatement(tokDefault, null, this.expect(Token.Id.COLON)));
                    fAnyLabels = true;
                    fDefault = true;
                    continue block5;
                }
                default: {
                    if (!fAnyLabels) {
                        this.log(Severity.ERROR, MISSING_CASE, this.peek().getStartPosition(), this.peek().getEndPosition(), new Object[0]);
                        if (stmts.isEmpty()) {
                            throw new CompilerException("switch must start with a case");
                        }
                    }
                    stmts.add(this.parseStatement());
                    fAnyStmts = true;
                    continue block5;
                }
                case R_CURLY: 
            }
            break;
        }
        if (stmts.isEmpty()) {
            this.log(Severity.ERROR, MISSING_CASE, this.peek().getStartPosition(), this.peek().getEndPosition(), new Object[0]);
        }
        return fDefault;
    }

    private List<AstNode> parseSwitchCondition() {
        if (this.peek(Token.Id.R_PAREN)) {
            return null;
        }
        ArrayList<AstNode> list = new ArrayList<AstNode>();
        do {
            list.add(this.parseSwitchConditionExpression());
        } while (this.match(Token.Id.COMMA) != null);
        return list;
    }

    private AstNode parseSwitchConditionExpression() {
        AstNode LVal = this.peekMultiVariableInitializer();
        if (LVal == null) {
            Token tokType = this.matchVarOrVal();
            if (tokType != null) {
                Token tokName = this.match(Token.Id.IDENTIFIER);
                if (tokName == null) {
                    this.putBack(tokType);
                } else {
                    LVal = new VariableDeclarationStatement(new VariableTypeExpression(tokType), tokName, false);
                }
            }
            if (LVal == null) {
                Expression expr = this.parseExpression();
                if (this.peek(Token.Id.IDENTIFIER)) {
                    LVal = new VariableDeclarationStatement(expr.toTypeExpression(), this.expect(Token.Id.IDENTIFIER), false);
                } else if (this.peek(Token.Id.ASN)) {
                    if (!expr.isLValueSyntax()) {
                        this.log(Severity.ERROR, NOT_ASSIGNABLE, expr.getStartPosition(), expr.getEndPosition(), new Object[0]);
                    }
                    LVal = expr;
                } else {
                    return expr;
                }
            }
        }
        return new AssignmentStatement(LVal, this.expect(Token.Id.ASN), this.parseExpression(), false);
    }

    private List<Expression> parseCaseOptionList() {
        ArrayList<Expression> listCaseOptions = new ArrayList<Expression>();
        do {
            if (this.peek(Token.Id.L_PAREN)) {
                Expression expr;
                Mark mark = this.mark();
                long lStart = this.expect(Token.Id.L_PAREN).getStartPosition();
                Expression expression = expr = this.peek(Token.Id.ANY) ? new IgnoredNameExpression(this.current()) : this.parseExpression();
                if (this.peek(Token.Id.COMMA)) {
                    ArrayList<Expression> listTupleValues = new ArrayList<Expression>();
                    listTupleValues.add(expr);
                    while (this.match(Token.Id.COMMA) != null) {
                        listTupleValues.add(this.peek(Token.Id.ANY) ? new IgnoredNameExpression(this.current()) : this.parseExpression());
                    }
                    long lEnd = this.expect(Token.Id.R_PAREN).getEndPosition();
                    listCaseOptions.add(new TupleExpression(null, listTupleValues, lStart, lEnd));
                    continue;
                }
                this.restore(mark);
            }
            listCaseOptions.add(this.peek(Token.Id.ANY) ? new IgnoredNameExpression(this.current()) : this.parseTernaryExpression());
        } while (this.match(Token.Id.COMMA) != null);
        return listCaseOptions;
    }

    MultipleLValueStatement peekMultiVariableInitializer() {
        if (!this.peek(Token.Id.L_PAREN)) {
            return null;
        }
        Mark mark = this.mark();
        this.expect(Token.Id.L_PAREN);
        ArrayList<AstNode> listLVals = new ArrayList<AstNode>();
        while (true) {
            AstNode LVal = null;
            boolean fFirst = listLVals.isEmpty();
            Token tokType = this.matchVarOrVal();
            if (tokType != null) {
                Token tokName = this.matchNameOrAny();
                if (tokName == null) {
                    this.putBack(tokType);
                } else {
                    LVal = new VariableDeclarationStatement(new VariableTypeExpression(tokType), tokName, false);
                }
            }
            if (LVal == null) {
                Expression expr = this.parseExtendedExpression();
                LVal = this.peekNameOrAny() ? new VariableDeclarationStatement(expr.toTypeExpression(), this.expect(Token.Id.IDENTIFIER), false) : expr;
            }
            if (fFirst && !this.peek(Token.Id.COMMA)) {
                this.restore(mark);
                return null;
            }
            if (!LVal.isLValueSyntax()) {
                this.log(Severity.ERROR, NOT_ASSIGNABLE, LVal.getStartPosition(), LVal.getEndPosition(), new Object[0]);
            } else {
                listLVals.add(LVal);
            }
            Token comma = this.match(Token.Id.COMMA);
            if (!fFirst && this.match(Token.Id.R_PAREN) != null) {
                return new MultipleLValueStatement(listLVals);
            }
            if (comma != null) continue;
            this.expect(Token.Id.COMMA);
        }
    }

    Statement parseTryStatement() {
        Token keyword = this.expect(Token.Id.TRY);
        List<AssignmentStatement> resources = null;
        if (this.match(Token.Id.L_PAREN) != null) {
            resources = this.parseVariableInitializationList(true, false);
            this.expect(Token.Id.R_PAREN);
        }
        StatementBlock block = this.parseStatementBlock();
        ArrayList<CatchStatement> catches = new ArrayList<CatchStatement>();
        while (this.match(Token.Id.CATCH) != null) {
            long lStartPos = this.prev().getStartPosition();
            this.expect(Token.Id.L_PAREN);
            VariableDeclarationStatement var = new VariableDeclarationStatement(this.parseTypeExpression(), this.expectNameOrAny(), false);
            this.expect(Token.Id.R_PAREN);
            catches.add(new CatchStatement(var, this.parseStatementBlock(), lStartPos));
        }
        StatementBlock catchall = null;
        if (this.match(Token.Id.FINALLY) != null) {
            catchall = this.parseStatementBlock();
        }
        return new TryStatement(keyword, resources, block, catches, catchall);
    }

    TypedefStatement parseTypeDefStatement(Expression exprCond, Token tokenAccess) {
        Token keyword = this.expect(Token.Id.TYPEDEF);
        TypeExpression type = this.parseExtendedTypeExpression();
        this.expect(Token.Id.AS);
        Token simpleName = this.expect(Token.Id.IDENTIFIER);
        this.expect(Token.Id.SEMICOLON);
        return new TypedefStatement(exprCond, tokenAccess == null ? keyword : tokenAccess, type, simpleName);
    }

    Statement parseUsingStatement() {
        Token keyword = this.expect(Token.Id.USING);
        this.expect(Token.Id.L_PAREN);
        List<AssignmentStatement> resources = this.parseVariableInitializationList(true, true);
        this.expect(Token.Id.R_PAREN);
        return new TryStatement(keyword, resources, this.parseStatementBlock(), null, null);
    }

    Statement parseWhileStatement() {
        Token keyword = this.expect(Token.Id.WHILE);
        this.expect(Token.Id.L_PAREN);
        List<AstNode> conds = this.parseConditionList();
        this.expect(Token.Id.R_PAREN);
        StatementBlock block = this.parseStatementBlock();
        return new WhileStatement(keyword, conds, block);
    }

    List<AssignmentStatement> parseVariableInitializationList(boolean fRequired, boolean fAllowExpr) {
        if (!fRequired) {
            switch (this.peek().getId()) {
                case SEMICOLON: 
                case R_PAREN: 
                case COMMA: {
                    return null;
                }
            }
        }
        ArrayList<AssignmentStatement> list = new ArrayList<AssignmentStatement>();
        do {
            list.add(this.parseVariableInitializer(fAllowExpr));
        } while (this.match(Token.Id.COMMA) != null);
        return list;
    }

    AssignmentStatement parseVariableInitializer(boolean fAllowExpr) {
        TypeExpression type = null;
        Token tokType = this.matchVarOrVal();
        if (tokType != null) {
            if (this.peekNameOrAny()) {
                type = new VariableTypeExpression(tokType);
            } else {
                this.putBack(tokType);
            }
        }
        if (type == null) {
            Expression expr = this.parseExpression();
            switch (this.peek().getId()) {
                case ASN: 
                case COND_ASN: 
                case COND_NN_ASN: {
                    return new AssignmentStatement(expr, this.current(), this.parseExpression(), false);
                }
                case SEMICOLON: 
                case R_PAREN: 
                case COMMA: {
                    if (!fAllowExpr) break;
                    long lPos = expr.getStartPosition();
                    type = new VariableTypeExpression(new Token(lPos, lPos, Token.Id.VAL));
                    Token tokName = new Token(lPos, lPos, Token.Id.ANY);
                    Token tokAsn = new Token(lPos, lPos, Token.Id.ASN);
                    VariableDeclarationStatement var = new VariableDeclarationStatement(type, tokName, false);
                    return new AssignmentStatement(var, tokAsn, expr);
                }
            }
            type = expr.toTypeExpression();
        }
        VariableDeclarationStatement var = new VariableDeclarationStatement(type, this.expectNameOrAny(), false);
        Token tokAsn = switch (this.peek().getId()) {
            case Token.Id.ASN, Token.Id.COND_ASN, Token.Id.COND_NN_ASN -> this.current();
            default -> this.expect(Token.Id.ASN);
        };
        return new AssignmentStatement(var, tokAsn, this.parseExpression());
    }

    Expression parseLinkerCondition() {
        Expression expr = this.parseExpression();
        expr.validateCondition(this.m_errorListener);
        return expr;
    }

    List<Expression> parseExpressionList() {
        ArrayList<Expression> exprs = new ArrayList<Expression>();
        do {
            exprs.add(this.parseExpression());
        } while (this.match(Token.Id.COMMA) != null);
        return exprs;
    }

    Expression parseExpression() {
        return this.parseElseExpression(false);
    }

    Expression parseExtendedExpression() {
        return this.parseElseExpression(true);
    }

    Expression parseElseExpression(boolean fExtended) {
        Expression expr = this.parseTernaryExpression(fExtended);
        if (this.peek(Token.Id.COLON)) {
            expr = new ElseExpression(expr, this.current(), this.parseElseExpression(false));
        }
        return expr;
    }

    Expression parseTernaryExpression() {
        return this.parseTernaryExpression(false);
    }

    Expression parseTernaryExpression(boolean fExtended) {
        Expression expr = this.parseOrExpression(fExtended);
        if (this.peek(Token.Id.COND)) {
            this.expect(Token.Id.COND);
            Expression exprThen = this.parseTernaryExpression(false);
            this.expect(Token.Id.COLON);
            Expression exprElse = this.parseTernaryExpression(false);
            expr = new TernaryExpression(expr, exprThen, exprElse);
        }
        return expr;
    }

    Expression parseOrExpression(boolean fExtended) {
        Expression expr = this.parseAndExpression(fExtended);
        block4: while (true) {
            switch (this.peek().getId()) {
                case COND_OR: {
                    expr = new CondOpExpression(expr, this.current(), this.parseAndExpression(false));
                    continue block4;
                }
                case COND_XOR: {
                    expr = new RelOpExpression(expr, this.current(), this.parseAndExpression(false));
                    continue block4;
                }
            }
            break;
        }
        return expr;
    }

    Expression parseAndExpression(boolean fExtended) {
        Expression expr = this.parseEqualityExpression(fExtended);
        while (this.peek(Token.Id.COND_AND)) {
            expr = new CondOpExpression(expr, this.current(), this.parseEqualityExpression(false));
        }
        return expr;
    }

    Expression parseEqualityExpression(boolean fExtended) {
        Expression expr = this.parseRelationalExpression(fExtended);
        ArrayList<Expression> listExpr = null;
        ArrayList<Token> listOps = null;
        Token.Id idPrev = null;
        boolean fErr = false;
        while (this.peek(Token.Id.COMP_EQ) || this.peek(Token.Id.COMP_NEQ)) {
            Token tokCmp = this.current();
            Expression exprNext = this.parseRelationalExpression(false);
            if (idPrev == null) {
                expr = new CmpExpression(expr, tokCmp, exprNext);
            } else {
                if (listExpr == null) {
                    listExpr = new ArrayList<Expression>();
                    listOps = new ArrayList<Token>();
                    CmpExpression exprPrev = (CmpExpression)expr;
                    listExpr.add(exprPrev.getExpression1());
                    listOps.add(exprPrev.getOperator());
                    listExpr.add(exprPrev.getExpression2());
                    expr = null;
                }
                listOps.add(tokCmp);
                listExpr.add(exprNext);
                Token.Id idCur = tokCmp.getId();
                if (idPrev != null && idCur != idPrev && !fErr) {
                    this.log(Severity.ERROR, BAD_CHAINED_EQ, tokCmp.getStartPosition(), tokCmp.getEndPosition(), new Object[0]);
                    fErr = true;
                }
            }
            idPrev = tokCmp.getId();
        }
        return expr == null ? new CmpChainExpression(listExpr, listOps.toArray(new Token[0])) : expr;
    }

    Expression parseRelationalExpression(boolean fExtended) {
        Expression expr = this.parseAssignmentExpression(fExtended);
        block0 : switch (this.peek().getId()) {
            case COMP_LT: 
            case COMP_LTEQ: 
            case COMP_GT: 
            case COMP_GTEQ: {
                expr = new CmpExpression(expr, this.current(), this.parseAssignmentExpression(false));
                switch (this.peek().getId()) {
                    case COMP_LT: 
                    case COMP_LTEQ: 
                    case COMP_GT: 
                    case COMP_GTEQ: {
                        break block0;
                    }
                }
                return expr;
            }
            case COMP_ORD: {
                return new CmpExpression(expr, this.current(), this.parseAssignmentExpression(false));
            }
            default: {
                return expr;
            }
        }
        ArrayList<Expression> listExpr = new ArrayList<Expression>();
        ArrayList<Token> listOps = new ArrayList<Token>();
        CmpExpression exprPrev = (CmpExpression)expr;
        listExpr.add(exprPrev.getExpression1());
        listOps.add(exprPrev.getOperator());
        listExpr.add(exprPrev.getExpression2());
        boolean fFirstAscending = exprPrev.isAscending();
        boolean fErr = false;
        while (true) {
            boolean fThisAscending;
            switch (this.peek().getId()) {
                case COMP_LT: 
                case COMP_LTEQ: {
                    fThisAscending = true;
                    break;
                }
                case COMP_GT: 
                case COMP_GTEQ: {
                    fThisAscending = false;
                    break;
                }
                default: {
                    return new CmpChainExpression(listExpr, listOps.toArray(new Token[0]));
                }
            }
            listOps.add(this.current());
            listExpr.add(this.parseAssignmentExpression(false));
            if (fThisAscending == fFirstAscending || fErr) continue;
            this.log(Severity.ERROR, BAD_CHAINED_CMP, expr.getStartPosition(), expr.getEndPosition(), new Object[0]);
            fErr = true;
        }
    }

    Expression parseAssignmentExpression(boolean fExtended) {
        Expression expr = this.parseRangeExpression(fExtended);
        if (this.peek(Token.Id.ASN_EXPR)) {
            Expression exprLValue = expr;
            Token tokAsnExpr = this.expect(Token.Id.ASN_EXPR);
            Expression exprRValue = this.parseAssignmentExpression(false);
            Token tokVal = new Token(tokAsnExpr.getStartPosition(), tokAsnExpr.getEndPosition(), Token.Id.VAL);
            Token tokTmp = new Token(tokAsnExpr.getStartPosition(), tokAsnExpr.getEndPosition(), Token.Id.IDENTIFIER, "#tmp");
            Token tokAsn = new Token(tokAsnExpr.getStartPosition(), tokAsnExpr.getEndPosition(), Token.Id.ASN);
            VariableTypeExpression typeDecl = new VariableTypeExpression(tokVal);
            VariableDeclarationStatement stmtDecl = new VariableDeclarationStatement(typeDecl, tokTmp, false);
            AssignmentStatement stmtTmp = new AssignmentStatement(stmtDecl, tokAsn, exprRValue);
            AssignmentStatement stmtAsn = new AssignmentStatement(exprLValue, tokAsn, new NameExpression(tokTmp));
            Token tokRet = new Token(exprLValue.getStartPosition(), exprLValue.getStartPosition(), Token.Id.RETURN);
            ReturnStatement stmtRet = new ReturnStatement(tokRet, new NameExpression(tokTmp));
            StatementBlock stmtBlock = new StatementBlock(List.of(stmtTmp, stmtAsn, stmtRet), exprLValue.getStartPosition(), exprRValue.getEndPosition());
            expr = new StatementExpression(stmtBlock);
        }
        return expr;
    }

    Expression parseRangeExpression(boolean fExtended) {
        Expression expr = this.parseBitwiseExpression(fExtended);
        block3: while (true) {
            switch (this.peek().getId()) {
                case I_RANGE_I: 
                case E_RANGE_I: 
                case I_RANGE_E: 
                case E_RANGE_E: {
                    expr = new RelOpExpression(expr, this.current(), this.parseBitwiseExpression(fExtended));
                    continue block3;
                }
            }
            break;
        }
        return expr;
    }

    Expression parseBitwiseExpression(boolean fExtended) {
        Expression expr = this.parseAdditiveExpression(fExtended);
        block3: while (true) {
            switch (this.peek().getId()) {
                case SHL: 
                case SHR: 
                case USHR: 
                case BIT_AND: 
                case BIT_XOR: 
                case BIT_OR: {
                    expr = new RelOpExpression(expr, this.current(), this.parseAdditiveExpression(fExtended));
                    continue block3;
                }
            }
            break;
        }
        return expr;
    }

    Expression parseAdditiveExpression(boolean fExtended) {
        Expression expr = this.parseMultiplicativeExpression(fExtended);
        while (this.peek(Token.Id.ADD) || this.peek(Token.Id.SUB)) {
            expr = new RelOpExpression(expr, this.current(), this.parseMultiplicativeExpression(fExtended));
        }
        return expr;
    }

    Expression parseMultiplicativeExpression(boolean fExtended) {
        Expression expr = this.parseElvisExpression(fExtended);
        block3: while (true) {
            switch (this.peek().getId()) {
                case MUL: 
                case DIV: 
                case MOD: 
                case DIVREM: {
                    expr = new RelOpExpression(expr, this.current(), this.parseElvisExpression(false));
                    continue block3;
                }
            }
            break;
        }
        return expr;
    }

    Expression parseElvisExpression(boolean fExtended) {
        Expression expr = this.parsePrefixExpression(fExtended);
        if (this.peek(Token.Id.COND_ELSE)) {
            expr = new ElvisExpression(expr, this.current(), this.parseElvisExpression(false));
        }
        return expr;
    }

    Expression parsePrefixExpression(boolean fExtended) {
        switch (this.peek().getId()) {
            case ADD: {
                return new UnaryPlusExpression(this.current(), this.parsePrefixExpression(false));
            }
            case SUB: {
                return new UnaryMinusExpression(this.current(), this.parsePrefixExpression(false));
            }
            case NOT: 
            case BIT_NOT: {
                return new UnaryComplementExpression(this.current(), this.parsePrefixExpression(false));
            }
            case INC: 
            case DEC: {
                return new SequentialAssignExpression(this.current(), this.parsePrefixExpression(false));
            }
        }
        return this.parsePostfixExpression(fExtended);
    }

    Expression parsePostfixExpression(boolean fExtended) {
        Expression expr = this.parsePrimaryExpression(fExtended);
        block19: while (true) {
            switch (this.peek().getId()) {
                case COND: {
                    if (this.peek().hasLeadingWhitespace()) {
                        return expr;
                    }
                    expr = new NotNullExpression(expr, this.current());
                    continue block19;
                }
                case INC: 
                case DEC: {
                    expr = new SequentialAssignExpression(expr, this.current());
                    continue block19;
                }
                case DOT: {
                    this.expect(Token.Id.DOT);
                    switch (this.peek().getId()) {
                        case NEW: {
                            expr = this.parseNewExpression(expr);
                            continue block19;
                        }
                        case AS: 
                        case IS: {
                            Token keyword = this.current();
                            Token tokOpen = this.expect(Token.Id.L_PAREN);
                            TypeExpression exprType = this.parseExtendedTypeExpression();
                            Token tokClose = this.expect(Token.Id.R_PAREN);
                            expr = keyword.getId() == Token.Id.AS ? new AsExpression(expr, keyword, exprType, tokClose) : new IsExpression(expr, keyword, exprType, tokClose);
                            continue block19;
                        }
                        case DEFAULT: 
                        case IDENTIFIER: 
                        case BIT_AND: {
                            Token noDeRef = this.match(Token.Id.BIT_AND);
                            Token name = this.match(Token.Id.DEFAULT);
                            if (name == null && (name = this.match(Token.Id.NEW)) == null) {
                                name = this.expect(Token.Id.IDENTIFIER);
                            }
                            long lEndPos = name.getEndPosition();
                            List<TypeExpression> params = null;
                            Token tokPeekLT = this.match(Token.Id.COMP_LT);
                            if (tokPeekLT != null) {
                                this.putBack(tokPeekLT);
                                try (SafeLookAhead attempt = new SafeLookAhead();){
                                    params = this.parseTypeParameterTypeList(true, true);
                                    if (attempt.isClean()) {
                                        attempt.keepResults();
                                        lEndPos = this.prev().getEndPosition();
                                    } else {
                                        params = null;
                                    }
                                }
                                catch (CompilerException compilerException) {
                                    // empty catch block
                                }
                            }
                            if (expr instanceof NamedTypeExpression) {
                                expr = new NamedTypeExpression((NamedTypeExpression)expr, Collections.singletonList(name), params, lEndPos);
                                continue block19;
                            }
                            expr = new NameExpression(expr, noDeRef, name, params, lEndPos);
                            continue block19;
                        }
                    }
                    this.expect(Token.Id.IDENTIFIER);
                    this.skipToNextStatement();
                    return expr;
                }
                case L_PAREN: 
                case ASYNC_PAREN: {
                    expr = new InvocationExpression(expr, this.peek(Token.Id.ASYNC_PAREN), this.parseArgumentList(true, true, false), this.prev().getEndPosition());
                    continue block19;
                }
                case L_SQUARE: {
                    this.expect(Token.Id.L_SQUARE);
                    if (this.match(Token.Id.R_SQUARE) != null) {
                        ArrayTypeExpression type = new ArrayTypeExpression(expr.toTypeExpression(), 0, this.prev().getEndPosition());
                        Token tokNext = this.peek();
                        if (tokNext.getId() == Token.Id.COLON && !tokNext.hasLeadingWhitespace()) {
                            this.expect(Token.Id.COLON);
                            expr = this.parseComplexLiteral(type);
                            continue block19;
                        }
                        expr = type;
                        continue block19;
                    }
                    if (this.match(Token.Id.COND) == null) {
                        List<Expression> indexes = this.parseExpressionList();
                        expr = new ArrayAccessExpression(expr, indexes, this.expect(Token.Id.R_SQUARE));
                        continue block19;
                    }
                    int cExplicitDims = 1;
                    while (this.match(Token.Id.R_SQUARE) == null) {
                        this.expect(Token.Id.COMMA);
                        this.expect(Token.Id.COND);
                        ++cExplicitDims;
                    }
                    ArrayTypeExpression type = new ArrayTypeExpression(expr.toTypeExpression(), cExplicitDims, this.prev().getEndPosition());
                    Token tokNext = this.peek();
                    if (tokNext.getId() == Token.Id.COLON && !tokNext.hasLeadingWhitespace()) {
                        this.expect(Token.Id.COLON);
                        expr = this.parseComplexLiteral(type);
                        continue block19;
                    }
                    expr = type;
                    continue block19;
                }
            }
            break;
        }
        return expr;
    }

    NewExpression parseNewExpression(Expression left) {
        Token keyword = this.expect(Token.Id.NEW);
        TypeExpression type = null;
        List<Expression> args = null;
        int dims = -1;
        StatementBlock body = null;
        long lEndPos = 0L;
        if (this.peek(Token.Id.L_PAREN)) {
            Mark mark = this.mark();
            args = this.parseArgumentList(true, false, false);
            lEndPos = this.prev().getEndPosition();
            Token.Id idNext = this.peek().getId();
            if (args.size() == 1 && (idNext == Token.Id.L_PAREN || idNext == Token.Id.L_SQUARE)) {
                this.restore(mark);
                args = null;
            }
        }
        if (args == null) {
            type = this.parseTypeExpression();
            lEndPos = type.getEndPosition();
            boolean fArray = type instanceof ArrayTypeExpression;
            if (fArray) {
                if (this.peek(Token.Id.L_SQUARE)) {
                    args = this.parseArgumentList(true, false, true);
                    dims = args.size();
                    lEndPos = this.prev().getEndPosition();
                } else {
                    args = Collections.emptyList();
                }
                List<Expression> argsTrailing = this.parseArgumentList(false, false, false);
                if (argsTrailing != null) {
                    if (!argsTrailing.isEmpty()) {
                        if (args.isEmpty()) {
                            args = argsTrailing;
                        } else {
                            args.addAll(argsTrailing);
                        }
                    }
                    lEndPos = this.prev().getEndPosition();
                }
            } else {
                args = this.parseArgumentList(true, false, false);
                lEndPos = this.prev().getEndPosition();
            }
            if (left == null && this.peek(Token.Id.L_CURLY)) {
                body = this.parseTypeCompositionBody(keyword);
                lEndPos = this.prev().getEndPosition();
            }
        }
        return new NewExpression(left, keyword, type, args, dims, body, lEndPos);
    }

    Expression parsePrimaryExpression(boolean fExtended) {
        switch (this.peek().getId()) {
            case ANY: {
                IgnoredNameExpression exprIgnore = new IgnoredNameExpression(this.current());
                return this.peek(Token.Id.LAMBDA) ? new LambdaExpression(Collections.singletonList(exprIgnore), this.expect(Token.Id.LAMBDA), this.parseLambdaBody(), exprIgnore.getStartPosition()) : exprIgnore;
            }
            case NEW: {
                return this.parseNewExpression(null);
            }
            case THROW: {
                return new ThrowExpression(this.expect(Token.Id.THROW), this.parseTernaryExpression(), null);
            }
            case ASSERT: 
            case ASSERT_RND: 
            case ASSERT_ARG: 
            case ASSERT_BOUNDS: 
            case ASSERT_TODO: 
            case ASSERT_ONCE: 
            case ASSERT_TEST: 
            case ASSERT_DBG: {
                Token keyword = this.current();
                Expression expr = null;
                switch (this.peek().getId()) {
                    case R_CURLY: 
                    case SEMICOLON: 
                    case R_PAREN: 
                    case COMMA: 
                    case AS: 
                    case COND: 
                    case COLON: 
                    case R_SQUARE: {
                        break;
                    }
                    default: {
                        expr = this.parseTernaryExpression();
                    }
                }
                Expression exprMsg = null;
                if (this.match(Token.Id.AS) != null) {
                    exprMsg = this.parseTernaryExpression();
                }
                return new ThrowExpression(keyword, expr, exprMsg);
            }
            case TODO: {
                return this.parseTodoExpression();
            }
            case FUNCTION: 
            case IMMUTABLE: 
            case AT: {
                return fExtended ? this.parseExtendedTypeExpression() : this.parseTypeExpression();
            }
            case PUBLIC: 
            case PROTECTED: 
            case PRIVATE: {
                if (fExtended) {
                    return this.parseExtendedTypeExpression();
                }
            }
            default: {
                Token dot;
                boolean fNormal;
                Token decl;
                if (fExtended && ((decl = this.match(Token.Id.CONST)) != null || (decl = this.match(Token.Id.ENUM)) != null || (decl = this.match(Token.Id.MODULE)) != null || (decl = this.match(Token.Id.PACKAGE)) != null || (decl = this.match(Token.Id.SERVICE)) != null || (decl = this.match(Token.Id.CLASS)) != null || (decl = this.match(Token.Id.STRUCT)) != null)) {
                    this.putBack(decl);
                    return this.parseExtendedTypeExpression();
                }
                Token amp = this.match(Token.Id.BIT_AND);
                Token construct = this.match(Token.Id.CONSTRUCT);
                Token name = this.expect(Token.Id.IDENTIFIER);
                boolean bl = fNormal = amp == null && construct == null;
                if (fNormal && this.peek(Token.Id.LAMBDA)) {
                    return new LambdaExpression(Collections.singletonList(new NameExpression(name)), this.expect(Token.Id.LAMBDA), this.parseLambdaBody(), name.getStartPosition());
                }
                Token nameNDR = construct == null ? amp : null;
                Token constructNDR = construct != null ? amp : null;
                long lEndPos = this.prev().getEndPosition();
                NameExpression left = null;
                boolean fQuit = false;
                while (nameNDR == null && (dot = this.match(Token.Id.DOT)) != null) {
                    Token nameNext = this.match(Token.Id.IDENTIFIER);
                    if (nameNext == null) {
                        this.putBack(dot);
                        fQuit = true;
                        break;
                    }
                    left = new NameExpression(left, nameNDR, name, null, lEndPos);
                    nameNDR = null;
                    name = nameNext;
                    lEndPos = name.getEndPosition();
                }
                if (fQuit || !fNormal) {
                    NameExpression expr = new NameExpression(left, nameNDR, name, this.parseTypeParameterTypeList(false, true), lEndPos);
                    if (construct != null) {
                        expr = new NameExpression(expr, constructNDR, construct, null, lEndPos);
                    }
                    return expr;
                }
                Token tokNoNarrow = !this.peek().hasLeadingWhitespace() ? this.match(Token.Id.NOT) : null;
                List<TypeExpression> params = null;
                Token tokPeekLT = this.match(Token.Id.COMP_LT);
                if (tokPeekLT != null) {
                    this.putBack(tokPeekLT);
                    try (SafeLookAhead attempt2 = new SafeLookAhead();){
                        params = this.parseTypeParameterTypeList(true, true);
                        if (attempt2.isClean() && (this.peek().getId() != Token.Id.COMP_GT || this.peek().hasLeadingWhitespace())) {
                            attempt2.keepResults();
                            lEndPos = this.prev().getEndPosition();
                        } else {
                            params = null;
                        }
                    }
                    catch (CompilerException attempt2) {
                        // empty catch block
                    }
                }
                if (this.peek(Token.Id.COLON)) {
                    Token colon = this.expect(Token.Id.COLON);
                    if (!colon.hasLeadingWhitespace()) {
                        switch (this.peek().getId()) {
                            case L_PAREN: {
                                if (left != null || !"Tuple".equals(name.getValueText())) break;
                            }
                            case DIV: 
                            case L_SQUARE: 
                            case DIR_CUR: 
                            case DIR_PARENT: {
                                return this.parseComplexLiteral(new NamedTypeExpression(null, Parser.toList(left, name), null, tokNoNarrow, params, lEndPos));
                            }
                        }
                    }
                    this.putBack(colon);
                }
                return tokNoNarrow == null ? new NameExpression(left, null, name, params, lEndPos) : new NamedTypeExpression(null, Parser.toList(left, name), null, tokNoNarrow, params, lEndPos);
            }
            case L_PAREN: {
                Token tokLParen = this.expect(Token.Id.L_PAREN);
                if (this.match(Token.Id.R_PAREN, this.match(Token.Id.COMMA) != null) != null) {
                    Token lambdaOp = this.match(Token.Id.LAMBDA);
                    if (lambdaOp != null) {
                        return new LambdaExpression(Collections.emptyList(), lambdaOp, this.parseLambdaBody(), tokLParen.getStartPosition());
                    }
                    return new TupleExpression(null, null, tokLParen.getStartPosition(), this.prev().getEndPosition());
                }
                Expression expr = this.parseExtendedExpression();
                switch (this.peek().getId()) {
                    case COMMA: {
                        ArrayList<Expression> exprs = new ArrayList<Expression>();
                        exprs.add(expr);
                        while (this.match(Token.Id.R_PAREN, this.match(Token.Id.COMMA) == null) == null) {
                            exprs.add(this.parseExpression());
                        }
                        if (this.peek(Token.Id.LAMBDA)) {
                            return new LambdaExpression(exprs, this.expect(Token.Id.LAMBDA), this.parseLambdaBody(), tokLParen.getStartPosition());
                        }
                        return new TupleExpression(null, exprs, tokLParen.getStartPosition(), this.prev().getEndPosition());
                    }
                    case R_PAREN: {
                        this.expect(Token.Id.R_PAREN);
                        if (this.peek(Token.Id.LAMBDA)) {
                            return new LambdaExpression(Collections.singletonList(expr), this.expect(Token.Id.LAMBDA), this.parseLambdaBody(), tokLParen.getStartPosition());
                        }
                        return new ParenthesizedExpression(expr, tokLParen.getStartPosition(), this.prev().getEndPosition());
                    }
                    case IDENTIFIER: 
                    case ANY: {
                        ArrayList<Parameter> params = new ArrayList<Parameter>();
                        params.add(new Parameter(expr.toTypeExpression(), this.expectNameOrAny()));
                        while (this.match(Token.Id.R_PAREN, this.match(Token.Id.COMMA) == null) == null) {
                            TypeExpression type = this.parseTypeExpression();
                            Token name = this.expectNameOrAny();
                            params.add(new Parameter(type, name));
                        }
                        return new LambdaExpression(params, this.expect(Token.Id.LAMBDA), this.parseLambdaBody(), tokLParen.getStartPosition());
                    }
                }
                this.expect(Token.Id.R_PAREN);
                this.skipToNextStatement();
                return expr;
            }
            case L_CURLY: {
                return new StatementExpression(this.parseStatementBlock());
            }
            case SWITCH: {
                return this.parseSwitchExpression();
            }
            case L_SQUARE: {
                return this.parseComplexLiteral(null);
            }
            case LIT_BIT: 
            case LIT_NIBBLE: 
            case LIT_CHAR: 
            case LIT_STRING: 
            case LIT_BINSTR: 
            case LIT_INT: 
            case LIT_INT8: 
            case LIT_INT16: 
            case LIT_INT32: 
            case LIT_INT64: 
            case LIT_INT128: 
            case LIT_INTN: 
            case LIT_UINT8: 
            case LIT_UINT16: 
            case LIT_UINT32: 
            case LIT_UINT64: 
            case LIT_UINT128: 
            case LIT_UINTN: 
            case LIT_DEC: 
            case LIT_DECA: 
            case LIT_DEC32: 
            case LIT_DEC64: 
            case LIT_DEC128: 
            case LIT_DECN: 
            case LIT_FLOAT: 
            case LIT_FLOAT8E4: 
            case LIT_FLOAT8E5: 
            case LIT_BFLOAT16: 
            case LIT_FLOAT16: 
            case LIT_FLOAT32: 
            case LIT_FLOAT64: 
            case LIT_FLOAT128: 
            case LIT_FLOATN: 
            case LIT_DATE: 
            case LIT_TIMEOFDAY: 
            case LIT_TIME: 
            case LIT_TIMEZONE: 
            case LIT_DURATION: 
            case LIT_VERSION: {
                return new LiteralExpression(this.current());
            }
            case TEMPLATE: {
                Token token = this.current();
                long lStart = token.getStartPosition();
                long lEnd = token.getEndPosition();
                Object[] aoParts = (Object[])token.getValue();
                int cParts = aoParts.length;
                ArrayList<Expression> listExpr = new ArrayList<Expression>(cParts);
                for (Object oPart : aoParts) {
                    if (oPart instanceof Token[]) {
                        Token[] aToken = (Token[])oPart;
                        Parser parser = new Parser(this, aToken);
                        listExpr.add(parser.parseExpression());
                        if (parser.eof()) continue;
                        Token tokNext = parser.next();
                        this.log(Severity.ERROR, TEMPLATE_EXTRA, lStart, lEnd, tokNext.getValueText());
                        continue;
                    }
                    listExpr.add(new LiteralExpression((Token)oPart));
                }
                return new TemplateExpression(listExpr, lStart, lEnd);
            }
            case DIV: 
            case DIR_CUR: 
            case DIR_PARENT: 
            case BIN_FILE: 
            case STR_FILE: 
        }
        Token tokStart = this.peek();
        long lStart = tokStart.getStartPosition();
        boolean fBin = tokStart.getId() == Token.Id.BIN_FILE;
        boolean fStr = tokStart.getId() == Token.Id.STR_FILE;
        boolean fContents = fBin | fStr;
        if (fContents) {
            assert (!tokStart.hasTrailingWhitespace());
            this.next();
        }
        Token tokFile = this.parsePath();
        String sFile = (String)tokFile.getValue();
        boolean fDir = !fContents && sFile.endsWith("/");
        long lEnd = tokFile.getEndPosition();
        Object resource = this.m_source.resolvePath(sFile);
        Token tokData = null;
        boolean fErr = false;
        if (fContents || resource != null) {
            if (fBin) {
                byte[] abData = null;
                try {
                    abData = this.m_source.includeBinary(sFile);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if (abData == null) {
                    abData = new byte[]{};
                    fErr = true;
                }
                tokData = new Token(lStart, lEnd, Token.Id.LIT_BINSTR, abData);
            } else if (fStr) {
                String sData = null;
                try {
                    Source source = this.m_source.includeString(sFile);
                    sData = source == null ? null : source.toRawString();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if (sData == null) {
                    sData = "";
                    fErr = true;
                }
                tokData = new Token(lStart, lEnd, Token.Id.LIT_STRING, sData);
            }
        } else {
            return new LiteralExpression(tokFile);
        }
        if (fErr) {
            this.log(Severity.ERROR, INVALID_PATH, lStart, lEnd, sFile);
            throw new CompilerException("no such directory or file: " + sFile);
        }
        return fContents ? new LiteralExpression(tokData) : new FileExpression(null, tokFile, resource);
    }

    private static List<Token> toList(NameExpression left, Token name) {
        if (left == null) {
            return Collections.singletonList(name);
        }
        List<Token> names = left.getNameTokens();
        names.add(name);
        return names;
    }

    Token parsePath() {
        StringBuilder sb = new StringBuilder();
        Token tokDiv = this.current();
        long lPos = tokDiv.getStartPosition();
        block12: while (true) {
            sb.append(tokDiv.getId().TEXT);
            if (tokDiv.hasTrailingWhitespace()) {
                return new Token(lPos, tokDiv.getEndPosition(), Token.Id.LIT_PATH, sb.toString());
            }
            switch (this.peek().getId()) {
                case DOT: {
                    Token tokDot = this.current();
                    sb.append('.');
                    if (tokDot.hasTrailingWhitespace()) {
                        this.log(Severity.ERROR, INVALID_PATH, lPos, tokDot.getEndPosition(), sb.toString());
                        throw new CompilerException("illegal include-file path: " + String.valueOf(sb));
                    }
                }
                case IMPORT: 
                case DEFAULT: 
                case TYPEDEF: 
                case PUBLIC: 
                case PROTECTED: 
                case PRIVATE: 
                case CONDITIONAL: 
                case VOID: 
                case CONSTRUCT: 
                case ASSERT: 
                case VAL: 
                case VAR: 
                case BREAK: 
                case CONTINUE: 
                case DO: 
                case FOR: 
                case IF: 
                case RETURN: 
                case SWITCH: 
                case TRY: 
                case USING: 
                case WHILE: 
                case IDENTIFIER: 
                case CASE: 
                case NEW: 
                case AS: 
                case IS: 
                case THROW: 
                case FUNCTION: 
                case IMMUTABLE: 
                case ALLOW: 
                case ANNOTATION: 
                case AVOID: 
                case CATCH: 
                case CLASS: 
                case CONST: 
                case DELEGATES: 
                case DESIRED: 
                case ELSE: 
                case EMBEDDED: 
                case ENUM: 
                case EXTENDS: 
                case FINALLY: 
                case IMPLEMENTS: 
                case INCORPORATES: 
                case INJECT: 
                case INTERFACE: 
                case INTO: 
                case MIXIN: 
                case MODULE: 
                case OPTIONAL: 
                case OUTER: 
                case PACKAGE: 
                case PREFER: 
                case REQUIRED: 
                case SERVICE: 
                case STATIC: 
                case STRUCT: 
                case SUPER: 
                case THIS: {
                    Token tokName;
                    Token tokDot;
                    block13: while (true) {
                        switch (this.peek().getId()) {
                            case IMPORT: 
                            case DEFAULT: 
                            case TYPEDEF: 
                            case PUBLIC: 
                            case PROTECTED: 
                            case PRIVATE: 
                            case CONDITIONAL: 
                            case VOID: 
                            case CONSTRUCT: 
                            case ASSERT: 
                            case VAL: 
                            case VAR: 
                            case BREAK: 
                            case CONTINUE: 
                            case DO: 
                            case FOR: 
                            case IF: 
                            case RETURN: 
                            case SWITCH: 
                            case TRY: 
                            case USING: 
                            case WHILE: 
                            case IDENTIFIER: 
                            case CASE: 
                            case NEW: 
                            case AS: 
                            case IS: 
                            case THROW: 
                            case FUNCTION: 
                            case IMMUTABLE: 
                            case ALLOW: 
                            case ANNOTATION: 
                            case AVOID: 
                            case CATCH: 
                            case CLASS: 
                            case CONST: 
                            case DELEGATES: 
                            case DESIRED: 
                            case ELSE: 
                            case EMBEDDED: 
                            case ENUM: 
                            case EXTENDS: 
                            case FINALLY: 
                            case IMPLEMENTS: 
                            case INCORPORATES: 
                            case INJECT: 
                            case INTERFACE: 
                            case INTO: 
                            case MIXIN: 
                            case MODULE: 
                            case OPTIONAL: 
                            case OUTER: 
                            case PACKAGE: 
                            case PREFER: 
                            case REQUIRED: 
                            case SERVICE: 
                            case STATIC: 
                            case STRUCT: 
                            case SUPER: 
                            case THIS: {
                                tokName = this.current();
                                break;
                            }
                            default: {
                                tokName = this.expect(Token.Id.IDENTIFIER);
                            }
                        }
                        sb.append(tokName.getValue());
                        if (tokName.hasTrailingWhitespace()) {
                            return new Token(lPos, tokName.getEndPosition(), Token.Id.LIT_PATH, sb.toString());
                        }
                        Token.Id id = this.peek().getId();
                        switch (id) {
                            case SUB: 
                            case DOT: {
                                tokDot = this.current();
                                sb.append(id.TEXT);
                                if (!tokDot.hasTrailingWhitespace()) continue block13;
                                this.log(Severity.ERROR, INVALID_PATH, lPos, tokDot.getEndPosition(), sb.toString());
                                throw new CompilerException("illegal include-file path: " + String.valueOf(sb));
                            }
                            case DIV: {
                                tokDiv = this.current();
                                continue block12;
                            }
                        }
                        break;
                    }
                    return new Token(lPos, tokName.getEndPosition(), Token.Id.LIT_PATH, sb.toString());
                }
                case DIR_CUR: 
                case DIR_PARENT: {
                    tokDiv = this.current();
                    continue block12;
                }
            }
            break;
        }
        return new Token(lPos, tokDiv.getEndPosition(), Token.Id.LIT_PATH, sb.toString());
    }

    StatementBlock parseLambdaBody() {
        Token firstToken = this.peek();
        if (firstToken.getId() == Token.Id.L_CURLY) {
            return this.parseStatementBlock();
        }
        Token fakeReturn = new Token(firstToken.getStartPosition(), firstToken.getStartPosition(), Token.Id.RETURN);
        ReturnStatement stmt = new ReturnStatement(fakeReturn, this.parseExpression());
        return new StatementBlock(Collections.singletonList(stmt), stmt.getStartPosition(), stmt.getEndPosition());
    }

    ThrowExpression parseTodoExpression() {
        Expression message = null;
        Token keyword = this.expect(Token.Id.TODO);
        Token endToken = null;
        if (keyword.getValue() == null) {
            if (this.match(Token.Id.L_PAREN) != null && (endToken = this.match(Token.Id.R_PAREN)) == null) {
                message = this.parseExpression();
                endToken = this.expect(Token.Id.R_PAREN);
            }
        } else {
            message = new LiteralExpression(keyword);
            this.putBack(new Token(keyword.getEndPosition(), keyword.getEndPosition(), Token.Id.SEMICOLON));
        }
        return new ThrowExpression(keyword, null, message, endToken);
    }

    SwitchExpression parseSwitchExpression() {
        Token keyword = this.expect(Token.Id.SWITCH);
        this.expect(Token.Id.L_PAREN);
        List<AstNode> cond = this.parseSwitchCondition();
        this.expect(Token.Id.R_PAREN);
        ArrayList<AstNode> contents = new ArrayList<AstNode>();
        boolean fDefault = false;
        boolean fNeedExpr = false;
        this.expect(Token.Id.L_CURLY);
        block5: while (true) {
            switch (this.peek().getId()) {
                case CASE: {
                    contents.add(new CaseStatement(this.current(), this.parseCaseOptionList(), this.expect(Token.Id.COLON)));
                    fNeedExpr = true;
                    continue block5;
                }
                case DEFAULT: {
                    Token tokDefault = this.current();
                    if (fDefault) {
                        this.log(Severity.ERROR, REPEAT_DEFAULT, tokDefault.getStartPosition(), tokDefault.getEndPosition(), new Object[0]);
                    }
                    contents.add(new CaseStatement(tokDefault, null, this.expect(Token.Id.COLON)));
                    fDefault = true;
                    fNeedExpr = true;
                    continue block5;
                }
                default: {
                    if (!fNeedExpr) {
                        this.log(Severity.ERROR, MISSING_CASE, this.peek().getStartPosition(), this.peek().getEndPosition(), new Object[0]);
                        throw new CompilerException("switch must start with a case");
                    }
                    contents.add(this.parseExpression());
                    this.expect(Token.Id.SEMICOLON);
                    fNeedExpr = false;
                    continue block5;
                }
                case R_CURLY: 
            }
            break;
        }
        if (contents.isEmpty()) {
            this.expect(Token.Id.CASE);
        } else if (fNeedExpr) {
            contents.add(this.parseExpression());
        }
        return new SwitchExpression(keyword, cond, contents, this.expect(Token.Id.R_CURLY).getEndPosition());
    }

    Expression parseComplexLiteral(TypeExpression type) {
        String sType;
        if (type == null) {
            sType = "";
        } else if (type instanceof ArrayTypeExpression) {
            sType = "Array";
        } else {
            sType = type.toString();
            int of = sType.indexOf(60);
            if (of >= 0) {
                sType = sType.substring(0, of);
            }
        }
        switch (sType) {
            case "": 
            case "Collection": 
            case "Set": 
            case "List": 
            case "Array": {
                Token tokOpen = this.expect(Token.Id.L_SQUARE);
                long lStartPos = type == null ? tokOpen.getStartPosition() : type.getStartPosition();
                ArrayList<Expression> exprs = new ArrayList<Expression>();
                while (this.match(Token.Id.R_SQUARE) == null) {
                    Expression expr = this.parseExpression();
                    exprs.add(expr);
                    if (this.match(Token.Id.COMMA) != null) continue;
                    if (sType.isEmpty() && exprs.size() == 1 && this.peek().getId() == Token.Id.ASN) {
                        ArrayList<Expression> keys = new ArrayList<Expression>();
                        ArrayList<Expression> values = new ArrayList<Expression>();
                        while (this.match(Token.Id.R_SQUARE) == null) {
                            keys.add(keys.isEmpty() ? expr : this.parseExpression());
                            this.expect(Token.Id.ASN);
                            values.add(this.parseExpression());
                            if (this.match(Token.Id.COMMA) != null) continue;
                            this.expect(Token.Id.R_SQUARE);
                            break;
                        }
                        long ofMap = tokOpen.getStartPosition();
                        Token tokName = new Token(ofMap, ofMap, Token.Id.IDENTIFIER, "Map");
                        NamedTypeExpression exprType = new NamedTypeExpression(null, Collections.singletonList(tokName), null, null, null, ofMap);
                        return new MapExpression(exprType, keys, values, this.prev().getEndPosition());
                    }
                    this.expect(Token.Id.R_SQUARE);
                    break;
                }
                return new ListExpression(type, exprs, lStartPos, this.prev().getEndPosition());
            }
            case "Range": 
            case "Interval": {
                Expression expr1 = this.parseBitwiseExpression(false);
                Token tokDotDot = switch (this.peek().getId()) {
                    case Token.Id.E_RANGE_I, Token.Id.I_RANGE_E, Token.Id.E_RANGE_E -> this.current();
                    default -> this.expect(Token.Id.I_RANGE_I);
                };
                Expression expr2 = this.parseBitwiseExpression(false);
                return new RelOpExpression(expr1, tokDotDot, expr2);
            }
            case "Map": {
                this.expect(Token.Id.L_SQUARE);
                ArrayList<Expression> keys = new ArrayList<Expression>();
                ArrayList<Expression> values = new ArrayList<Expression>();
                while (this.match(Token.Id.R_SQUARE) == null) {
                    keys.add(this.parseExpression());
                    this.expect(Token.Id.ASN);
                    values.add(this.parseExpression());
                    if (this.match(Token.Id.COMMA) != null) continue;
                    this.expect(Token.Id.R_SQUARE);
                    break;
                }
                return new MapExpression(type, keys, values, this.prev().getEndPosition());
            }
            case "Tuple": {
                this.expect(Token.Id.L_PAREN);
                ArrayList<Expression> exprs = null;
                while (this.match(Token.Id.R_PAREN) == null) {
                    if (exprs == null) {
                        exprs = new ArrayList<Expression>();
                    } else {
                        this.expect(Token.Id.COMMA);
                    }
                    exprs.add(this.parseExpression());
                }
                return new TupleExpression(type, exprs, type.getStartPosition(), this.prev().getEndPosition());
            }
            case "Path": {
                return new LiteralExpression(this.parsePath());
            }
            case "File": 
            case "Directory": 
            case "FileStore": {
                Token tokFile = this.parsePath();
                String sFile = (String)tokFile.getValue();
                boolean fReqFile = "File".equals(sType);
                boolean fReqDir = sFile.endsWith("/") || !fReqFile;
                long lStart = type.getStartPosition();
                long lEnd = tokFile.getEndPosition();
                Object resource = this.m_source.resolvePath(sFile);
                if (resource == null || fReqFile && fReqDir || fReqDir && !(resource instanceof ResourceDir) || fReqFile && !(resource instanceof File)) {
                    this.log(Severity.ERROR, INVALID_PATH, lStart, lEnd, sFile);
                    if (resource == null) {
                        throw new CompilerException("no such file: " + sFile);
                    }
                }
                return new FileExpression(type, tokFile, resource);
            }
        }
        Expression expr = this.parseExpression();
        this.log(Severity.ERROR, BAD_CUSTOM, expr.getStartPosition(), expr.getEndPosition(), type, expr);
        return expr;
    }

    public TypeExpression parseTypeExpression() {
        return this.parseIntersectingTypeExpression(false);
    }

    public TypeExpression parseExtendedTypeExpression() {
        return this.parseIntersectingTypeExpression(true);
    }

    TypeExpression parseIntersectingTypeExpression(boolean fExtended) {
        Token tokOp;
        TypeExpression expr = this.parseUnionedTypeExpression(fExtended);
        do {
            if ((tokOp = this.match(Token.Id.ADD)) == null && (tokOp = this.match(Token.Id.SUB)) == null) continue;
            expr = new BiTypeExpression(expr, tokOp, this.parseUnionedTypeExpression(fExtended));
        } while (tokOp != null);
        return expr;
    }

    TypeExpression parseUnionedTypeExpression(boolean fExtended) {
        TypeExpression expr = this.parseNonBiTypeExpression(fExtended);
        while (this.peek(Token.Id.BIT_OR)) {
            expr = new BiTypeExpression(expr, this.expect(Token.Id.BIT_OR), this.parseNonBiTypeExpression(fExtended));
        }
        return expr;
    }

    TypeExpression parseNonBiTypeExpression(boolean fExtended) {
        TypeExpression type;
        Token tokAccess = null;
        switch (this.peek().getId()) {
            case L_PAREN: {
                this.expect(Token.Id.L_PAREN);
                type = this.parseExtendedTypeExpression();
                this.expect(Token.Id.R_PAREN);
                break;
            }
            case AT: {
                type = this.parseAnnotatedTypeExpression(fExtended);
                break;
            }
            case FUNCTION: {
                type = this.parseFunctionTypeExpression();
                break;
            }
            case IMMUTABLE: {
                Token tokImmut = this.current();
                if (fExtended) {
                    switch (this.peek().getId()) {
                        case R_PAREN: 
                        case COMMA: 
                        case COMP_GT: 
                        case BIT_OR: 
                        case ADD: 
                        case SUB: 
                        case AS: {
                            return new KeywordTypeExpression(tokImmut);
                        }
                    }
                }
                type = new DecoratedTypeExpression(tokImmut, this.parseNonBiTypeExpression(fExtended));
                break;
            }
            case ANY: {
                return new KeywordTypeExpression(this.current());
            }
            case PUBLIC: 
            case PROTECTED: 
            case PRIVATE: {
                tokAccess = this.current();
                if (!fExtended) {
                    this.log(Severity.ERROR, EXT_TYPE_SYNTAX, tokAccess.getStartPosition(), tokAccess.getEndPosition(), tokAccess.getValueText());
                }
            }
            default: {
                if (fExtended && tokAccess == null) {
                    Token tokKeyword = this.match(Token.Id.CONST);
                    if (tokKeyword != null || (tokKeyword = this.match(Token.Id.ENUM)) != null || (tokKeyword = this.match(Token.Id.MODULE)) != null || (tokKeyword = this.match(Token.Id.PACKAGE)) != null || (tokKeyword = this.match(Token.Id.SERVICE)) != null || (tokKeyword = this.match(Token.Id.CLASS)) != null) {
                        return new KeywordTypeExpression(tokKeyword);
                    }
                    tokAccess = this.match(Token.Id.STRUCT);
                }
                type = this.parseNamedTypeExpression(tokAccess);
            }
        }
        block15: while (true) {
            switch (this.peek().getId()) {
                case L_SQUARE: {
                    Mark mark = this.mark();
                    this.expect(Token.Id.L_SQUARE);
                    int cDims = 0;
                    int cIndexes = 0;
                    while (this.match(Token.Id.R_SQUARE) == null) {
                        if (cDims + cIndexes > 0) {
                            this.expect(Token.Id.COMMA);
                        }
                        Token dim = this.peek();
                        if (this.match(Token.Id.COND) == null) {
                            this.parseExpression();
                            if (cIndexes == 0 && cDims > 0) {
                                this.log(Severity.ERROR, ALL_OR_NO_DIMS, dim.getStartPosition(), dim.getEndPosition(), new Object[0]);
                            }
                            ++cIndexes;
                            continue;
                        }
                        if (cDims == 0 && cIndexes > 0) {
                            this.log(Severity.ERROR, ALL_OR_NO_DIMS, dim.getStartPosition(), dim.getEndPosition(), new Object[0]);
                        }
                        ++cDims;
                    }
                    long lEndPos = this.prev().getEndPosition();
                    type = new ArrayTypeExpression(type, cDims + cIndexes, lEndPos);
                    if (cDims != 0 || cIndexes <= 0) continue block15;
                    this.restore(mark);
                    return type;
                }
                case COND: {
                    if (!this.peek().hasLeadingWhitespace()) {
                        type = new NullableTypeExpression(type, this.expect(Token.Id.COND).getEndPosition());
                        continue block15;
                    }
                    return type;
                }
            }
            break;
        }
        return type;
    }

    AnnotatedTypeExpression parseAnnotatedTypeExpression(boolean fExtended) {
        AnnotationExpression annotation = this.parseAnnotation(true);
        TypeExpression type = this.parseNonBiTypeExpression(fExtended);
        return new AnnotatedTypeExpression(annotation, type);
    }

    FunctionTypeExpression parseFunctionTypeExpression() {
        Token function = this.expect(Token.Id.FUNCTION);
        Token conditional = this.match(Token.Id.CONDITIONAL);
        List<Parameter> listReturn = this.parseReturnList();
        List<TypeExpression> listParam = this.parseParameterTypeList(false);
        if (listParam == null) {
            Token name = this.expect(Token.Id.IDENTIFIER);
            listParam = this.parseParameterTypeList(true);
            this.putBack(name);
        }
        return new FunctionTypeExpression(function, conditional, listReturn, listParam, this.prev().getEndPosition());
    }

    NamedTypeExpression parseNamedTypeExpression(Token tokAccess) {
        NamedTypeExpression expr = null;
        do {
            Token tokNarrow;
            if (expr != null) {
                // empty if block
            }
            List<Token> names = this.parseQualifiedName();
            if (tokAccess != null && expr != null) {
                this.log(Severity.ERROR, NO_CHILD_ACCESS, tokAccess.getStartPosition(), tokAccess.getEndPosition(), tokAccess);
            }
            Token token = tokNarrow = !this.peek().hasLeadingWhitespace() ? this.match(Token.Id.NOT) : null;
            if (tokNarrow != null && expr != null) {
                this.log(Severity.ERROR, NONNARROW_CHILD, tokNarrow.getStartPosition(), tokNarrow.getEndPosition(), new Object[0]);
            }
            List<TypeExpression> params = this.parseTypeParameterTypeList(false, true);
            expr = expr == null ? new NamedTypeExpression(null, names, tokAccess, tokNarrow, params, this.prev().getEndPosition()) : new NamedTypeExpression(expr, names, params, this.prev().getEndPosition());
        } while (this.match(Token.Id.DOT) != null);
        return expr;
    }

    List<Token> parseQualifiedName(boolean fRequired) {
        if (!fRequired) {
            Token tokTest = this.match(Token.Id.IDENTIFIER);
            if (tokTest == null) {
                return Collections.emptyList();
            }
            this.putBack(tokTest);
        }
        return this.parseQualifiedName();
    }

    List<Token> parseQualifiedName() {
        ArrayList<Token> names = new ArrayList<Token>();
        do {
            names.add(this.expect(Token.Id.IDENTIFIER));
        } while (this.match(Token.Id.DOT) != null);
        return names;
    }

    List[] parseModifiers() {
        return this.parseModifiers(false);
    }

    List[] parseModifiers(boolean couldBeProperty) {
        List[] listArray;
        ArrayList<Token> modifiers = null;
        ArrayList<AnnotationExpression> annotations = null;
        boolean err = false;
        Token access = null;
        block4: while (true) {
            switch (this.peek().getId()) {
                case PUBLIC: 
                case PROTECTED: 
                case PRIVATE: 
                case STATIC: {
                    boolean isAccess;
                    Token modifier = this.current();
                    boolean bl = isAccess = modifier.getId() != Token.Id.STATIC;
                    if (modifiers == null) {
                        modifiers = new ArrayList<Token>();
                    } else if (!err && modifiers.contains(modifier)) {
                        err = true;
                        this.log(Severity.ERROR, REPEAT_MODIFIER, modifier.getStartPosition(), modifier.getEndPosition(), modifier);
                    } else if (!err && isAccess && access != null) {
                        err = true;
                        this.log(Severity.ERROR, MODIFIER_CONFLICT, modifier.getStartPosition(), modifier.getEndPosition(), access, modifier);
                    }
                    modifiers.add(modifier);
                    if (couldBeProperty && this.peek(Token.Id.DIV)) {
                        modifiers.add(this.expect(Token.Id.DIV));
                        Token second = this.match(Token.Id.PUBLIC);
                        if (second == null) {
                            second = this.match(Token.Id.PROTECTED);
                            if (second == null) {
                                second = this.expect(Token.Id.PRIVATE);
                            } else if (modifier.getId() == Token.Id.PRIVATE) {
                                this.log(Severity.ERROR, MODIFIER_CONFLICT, modifier.getStartPosition(), modifier.getEndPosition(), modifier, second);
                            }
                        } else if (modifier.getId() != Token.Id.PUBLIC) {
                            this.log(Severity.ERROR, MODIFIER_CONFLICT, modifier.getStartPosition(), modifier.getEndPosition(), modifier, second);
                        }
                        modifiers.add(second);
                    }
                    if (!isAccess) continue block4;
                    access = modifier;
                    continue block4;
                }
                case AT: {
                    if (annotations == null) {
                        annotations = new ArrayList<AnnotationExpression>();
                    }
                    annotations.add(this.parseAnnotation(true));
                    continue block4;
                }
            }
            break;
        }
        if (modifiers != null || annotations != null) {
            List[] listArray2 = new List[2];
            listArray2[0] = modifiers;
            listArray = listArray2;
            listArray2[1] = annotations;
        } else {
            listArray = null;
        }
        return listArray;
    }

    AnnotationExpression parseAnnotation(boolean required) {
        long lStartPos = this.peek().getStartPosition();
        if (this.match(Token.Id.AT, required) == null) {
            return null;
        }
        NamedTypeExpression type = new NamedTypeExpression(null, this.parseQualifiedName(), null, null, null, this.prev().getEndPosition());
        List<Expression> args = null;
        Token token = this.peek();
        if (token != null && token.getId() == Token.Id.L_PAREN && !token.hasLeadingWhitespace()) {
            args = this.parseArgumentList(true, false, false);
        }
        long lEndPos = args == null ? type.getEndPosition() : this.prev().getEndPosition();
        return new AnnotationExpression(type, args, lStartPos, lEndPos);
    }

    List<Parameter> parseTypeParameterList(boolean required) {
        ArrayList<Parameter> typeParams = null;
        if (this.match(Token.Id.COMP_LT, required) != null) {
            typeParams = new ArrayList<Parameter>();
            boolean first = true;
            while (this.match(Token.Id.COMP_GT) == null) {
                if (first) {
                    first = false;
                } else {
                    this.expect(Token.Id.COMMA);
                }
                Token param = this.expect(Token.Id.IDENTIFIER);
                TypeExpression type = null;
                if (this.match(Token.Id.EXTENDS) != null) {
                    type = this.parseExtendedTypeExpression();
                }
                typeParams.add(new Parameter(type, param));
            }
        }
        return typeParams;
    }

    List<TypeExpression> parseTypeParameterTypeList(boolean required, boolean fAllowTypeSequence) {
        List<Object> types = null;
        if (this.match(Token.Id.COMP_LT, required) != null) {
            if (this.match(Token.Id.COMP_GT) != null) {
                types = Collections.emptyList();
            } else {
                types = this.parseTypeExpressionList(fAllowTypeSequence);
                this.expect(Token.Id.COMP_GT);
            }
        }
        return types;
    }

    List<TypeExpression> parseTypeExpressionList(boolean fAllowTypeSequence) {
        ArrayList<TypeExpression> types = new ArrayList<TypeExpression>();
        while (types.isEmpty() || this.match(Token.Id.COMMA) != null) {
            if (fAllowTypeSequence && this.peek(Token.Id.COMP_LT)) {
                Token tokStart = this.peek();
                List<TypeExpression> listSeq = this.parseTypeParameterTypeList(true, false);
                Token tokEnd = this.prev();
                types.add(new TupleTypeExpression(listSeq, tokStart.getStartPosition(), tokEnd.getEndPosition()));
                continue;
            }
            types.add(this.parseExtendedTypeExpression());
        }
        return types;
    }

    List<Parameter> parseResourceList() {
        if (this.match(Token.Id.INJECT) == null) {
            return null;
        }
        ArrayList<Parameter> resources = new ArrayList<Parameter>();
        this.expect(Token.Id.L_PAREN);
        if (this.match(Token.Id.R_PAREN) != null) {
            return resources;
        }
        do {
            TypeExpression type = this.parseTypeExpression();
            Token name = this.expectNameOrAny();
            resources.add(new Parameter(type, name));
        } while (this.match(Token.Id.R_PAREN, this.match(Token.Id.COMMA) == null) == null);
        return resources;
    }

    List<Parameter> parseParameterList(boolean required) {
        ArrayList<Parameter> params = null;
        if (this.match(Token.Id.L_PAREN, required) != null) {
            params = new ArrayList<Parameter>();
            if (this.match(Token.Id.R_PAREN) == null) {
                do {
                    TypeExpression type = this.parseTypeExpression();
                    Token name = this.expect(Token.Id.IDENTIFIER);
                    Expression value = null;
                    if (this.match(Token.Id.ASN) != null) {
                        value = this.parseExpression();
                    }
                    params.add(new Parameter(type, name, value));
                } while (this.match(Token.Id.R_PAREN, this.match(Token.Id.COMMA) == null) == null);
            }
        }
        return params;
    }

    List<TypeExpression> parseParameterTypeList(boolean required) {
        List types = null;
        if (this.match(Token.Id.L_PAREN, required) != null) {
            types = this.peek(Token.Id.R_PAREN) ? Collections.emptyList() : this.parseTypeExpressionList(false);
            this.expect(Token.Id.R_PAREN);
        }
        return types;
    }

    List<Expression> parseArgumentList(boolean required, boolean allowCurrying, boolean allowArraySize) {
        Token.Id idClose;
        boolean fArray = false;
        switch (this.peek().getId()) {
            case ASYNC_PAREN: {
                this.expect(Token.Id.ASYNC_PAREN);
                idClose = Token.Id.R_PAREN;
                break;
            }
            case L_PAREN: {
                this.expect(Token.Id.L_PAREN);
                idClose = Token.Id.R_PAREN;
                break;
            }
            case L_SQUARE: {
                if (!allowArraySize) {
                    return null;
                }
                this.expect(Token.Id.L_SQUARE);
                idClose = Token.Id.R_SQUARE;
                fArray = true;
                break;
            }
            default: {
                if (required) {
                    this.expect(Token.Id.L_PAREN);
                }
                return null;
            }
        }
        ArrayList<Expression> args = new ArrayList<Expression>();
        if (this.match(idClose) == null) {
            do {
                Expression expr;
                Token label = null;
                if (!fArray && this.peek(Token.Id.IDENTIFIER)) {
                    Token name = this.expect(Token.Id.IDENTIFIER);
                    if (this.match(Token.Id.ASN) == null) {
                        this.putBack(name);
                    } else {
                        label = name;
                    }
                }
                if (allowCurrying && !fArray) {
                    switch (this.peek().getId()) {
                        case ANY: {
                            Token tokUnbound = this.expect(Token.Id.ANY);
                            expr = new NonBindingExpression(tokUnbound.getStartPosition(), tokUnbound.getEndPosition(), null);
                            break;
                        }
                        case COMP_LT: {
                            Token tokOpen = this.expect(Token.Id.COMP_LT);
                            TypeExpression type = this.parseTypeExpression();
                            Token tokClose = this.expect(Token.Id.COMP_GT);
                            Token tokUnbound = this.expect(Token.Id.ANY);
                            expr = new NonBindingExpression(tokOpen.getStartPosition(), tokUnbound.getEndPosition(), type);
                            break;
                        }
                        default: {
                            expr = this.parseExpression();
                            break;
                        }
                    }
                } else {
                    expr = this.parseExpression();
                }
                args.add(label == null ? expr : new LabeledExpression(label, expr));
            } while (this.match(idClose, this.match(Token.Id.COMMA) == null) == null);
        }
        return args;
    }

    List<Parameter> parseReturnList() {
        List<Parameter> listReturn;
        if (this.match(Token.Id.VOID) != null) {
            listReturn = Collections.emptyList();
        } else if (this.match(Token.Id.L_PAREN) == null) {
            listReturn = Collections.singletonList(new Parameter(this.parseTypeExpression()));
        } else {
            listReturn = new ArrayList<Parameter>();
            do {
                listReturn.add(new Parameter(this.parseTypeExpression(), this.matchNameOrAny()));
            } while (this.match(Token.Id.R_PAREN, this.match(Token.Id.COMMA) == null) == null);
        }
        return listReturn;
    }

    List<VersionOverride> parseVersionRequirement(boolean required) {
        Token verb;
        LiteralExpression exprVer = this.parseVersionLiteral(required);
        if (exprVer == null) {
            return null;
        }
        ArrayList<VersionOverride> overrides = new ArrayList<VersionOverride>();
        overrides.add(new VersionOverride(exprVer));
        HashSet<Version> setGood = new HashSet<Version>();
        HashSet<Version> setBad = new HashSet<Version>();
        setGood.add(exprVer.getVersion());
        while ((verb = this.match(Token.Id.ALLOW)) != null || (verb = this.match(Token.Id.AVOID)) != null || (verb = this.match(Token.Id.PREFER)) != null) {
            boolean first = true;
            while (first || this.match(Token.Id.COMMA) != null) {
                exprVer = this.parseVersionLiteral(true);
                overrides.add(new VersionOverride(verb, exprVer));
                Version ver = exprVer.getVersion();
                if ((verb.getId() == Token.Id.AVOID ? setGood : setBad).contains(ver)) {
                    this.log(Severity.ERROR, "COMPILER-25", verb.getStartPosition(), this.prev().getEndPosition(), ver.toString());
                }
                (verb.getId() == Token.Id.AVOID ? setBad : setGood).add(ver);
                first = false;
            }
        }
        return overrides;
    }

    LiteralExpression parseVersionLiteral(boolean fRequired) {
        Token tokVer = this.match(Token.Id.LIT_VERSION, fRequired);
        return tokVer == null ? null : new LiteralExpression(tokVer);
    }

    void skipToNextStatement() {
        block6: while (true) {
            switch (this.peek().getId()) {
                case SEMICOLON: {
                    this.next();
                    return;
                }
                case L_CURLY: 
                case L_PAREN: 
                case L_SQUARE: {
                    this.skipEnclosed(this.current().getId());
                    continue block6;
                }
                case R_CURLY: {
                    return;
                }
                case IMPORT: 
                case TYPEDEF: 
                case CONSTRUCT: 
                case ASSERT: 
                case ASSERT_RND: 
                case ASSERT_ARG: 
                case ASSERT_BOUNDS: 
                case ASSERT_TODO: 
                case ASSERT_ONCE: 
                case ASSERT_TEST: 
                case ASSERT_DBG: 
                case BREAK: 
                case CONTINUE: 
                case DO: 
                case IF: 
                case RETURN: 
                case SWITCH: 
                case TRY: 
                case USING: 
                case WHILE: 
                case THROW: 
                case TODO: {
                    return;
                }
            }
            Token category = this.match(Token.Id.MODULE);
            if (category != null || (category = this.match(Token.Id.PACKAGE)) != null || (category = this.match(Token.Id.CLASS)) != null || (category = this.match(Token.Id.INTERFACE)) != null || (category = this.match(Token.Id.SERVICE)) != null || (category = this.match(Token.Id.CONST)) != null || (category = this.match(Token.Id.ENUM)) != null || (category = this.match(Token.Id.ANNOTATION)) != null || (category = this.match(Token.Id.MIXIN)) != null) {
                this.putBack(category);
                return;
            }
            this.next();
        }
    }

    void skipEnclosed(Token.Id idOpen) {
        block6: while (true) {
            switch (this.peek().getId()) {
                case L_CURLY: 
                case L_PAREN: 
                case L_SQUARE: {
                    this.skipEnclosed(this.current().getId());
                    continue block6;
                }
                case R_CURLY: {
                    if (idOpen == Token.Id.L_CURLY) {
                        this.next();
                    }
                    return;
                }
                case R_PAREN: {
                    this.next();
                    if (idOpen != Token.Id.L_PAREN) continue block6;
                    return;
                }
                case R_SQUARE: {
                    this.next();
                    if (idOpen != Token.Id.L_SQUARE) continue block6;
                    return;
                }
            }
            this.next();
        }
    }

    protected Token peek() {
        Token token;
        Token token2 = token = this.m_tokenPutBack == null ? this.m_token : this.m_tokenPutBack;
        if (token == null) {
            this.m_token = token = new Token(this.m_source.getPosition(), this.m_source.getPosition(), Token.Id.R_CURLY);
        }
        return token;
    }

    protected boolean peek(Token.Id id) {
        return this.peek().getId() == id;
    }

    protected boolean peekNameOrAny() {
        Token.Id id = this.peek().getId();
        return id == Token.Id.IDENTIFIER || id == Token.Id.ANY;
    }

    protected Token current() {
        Token token = this.peek();
        this.next();
        this.m_tokenPrev = token;
        return token;
    }

    protected Token next() {
        if (this.m_tokenPutBack != null) {
            this.m_tokenPutBack = null;
            return this.m_token;
        }
        block4: while (this.m_lexer.hasNext()) {
            this.m_token = this.m_lexer.next();
            switch (this.m_token.getId()) {
                case ENC_COMMENT: {
                    String sComment = (String)this.m_token.getValue();
                    if (!sComment.startsWith("*")) continue block4;
                    this.m_doc = this.m_token;
                    continue block4;
                }
                case EOL_COMMENT: {
                    continue block4;
                }
            }
            return this.m_token;
        }
        if (this.m_token != null && this.m_token.getStartPosition() != this.m_token.getEndPosition()) {
            this.m_token = new Token(this.m_token.getEndPosition(), this.m_token.getEndPosition(), Token.Id.R_CURLY);
            return this.m_token;
        }
        this.log(Severity.ERROR, UNEXPECTED_EOF, this.m_source.getPosition(), this.m_source.getPosition(), new Object[0]);
        throw new CompilerException("unexpected EOF");
    }

    protected void putBack(Token token) {
        assert (this.m_tokenPutBack == null);
        Token tokenUnpeeled = (token = token.desensitize()).anneal(this.m_token);
        if (tokenUnpeeled == null) {
            this.m_tokenPutBack = token;
        } else {
            this.m_token = tokenUnpeeled;
        }
    }

    protected Mark mark() {
        Mark mark = new Mark();
        mark.pos = this.m_lexer.mark();
        mark.token = this.m_token == null ? null : this.m_token.clone();
        mark.putBack = this.m_tokenPutBack == null ? null : this.m_tokenPutBack.clone();
        mark.lastMatch = this.m_tokenPrev == null ? null : this.m_tokenPrev.clone();
        mark.doc = this.m_doc;
        mark.noRec = this.m_fAvoidRecovery;
        return mark;
    }

    protected void restore(Mark mark) {
        this.m_lexer.restore(mark.pos);
        this.m_token = mark.token;
        this.m_tokenPutBack = mark.putBack;
        this.m_tokenPrev = mark.lastMatch;
        this.m_doc = mark.doc;
        this.m_fAvoidRecovery = mark.noRec;
    }

    protected Token match(Token.Id id, boolean required) {
        return required ? this.expect(id) : this.match(id);
    }

    protected Token match(Token.Id id) {
        Token token = this.peek();
        if (token.getId() == id) {
            return this.current();
        }
        if (token.getId() == Token.Id.IDENTIFIER && id.ContextSensitive && token.getValue().equals(id.TEXT)) {
            this.next();
            this.m_tokenPrev = token = token.convertToKeyword();
            return token;
        }
        if ((token = token.peel(id, this.m_source)) != null) {
            this.m_tokenPrev = token;
        }
        return token;
    }

    protected Token matchVarOrVal() {
        Token token = this.match(Token.Id.VAR);
        if (token != null) {
            return token;
        }
        return this.match(Token.Id.VAL);
    }

    protected Token matchNameOrAny() {
        Token token = this.match(Token.Id.ANY);
        if (token == null) {
            token = this.match(Token.Id.IDENTIFIER);
        }
        return token;
    }

    protected Token prev() {
        return this.m_tokenPrev;
    }

    protected Token expect(Token.Id id) {
        Token token = this.match(id);
        if (token != null) {
            return token;
        }
        long lPos = this.m_tokenPrev == null ? this.m_token.getEndPosition() : this.m_tokenPrev.getEndPosition();
        this.log(Severity.ERROR, EXPECTED_TOKEN, lPos, lPos, new Object[]{id, this.m_token.getId()});
        throw new CompilerException("expected token: " + String.valueOf((Object)id) + " (found: " + String.valueOf((Object)this.m_token.getId()) + ")");
    }

    protected Token expectNameOrAny() {
        Token token = this.match(Token.Id.ANY);
        if (token == null) {
            token = this.expect(Token.Id.IDENTIFIER);
        }
        return token;
    }

    protected boolean eof() {
        return !this.m_lexer.hasNext() && !this.notEof(this.m_token) && !this.notEof(this.m_tokenPutBack);
    }

    private boolean notEof(Token token) {
        return token != null && (token.getStartPosition() != token.getEndPosition() || token.getId() != Token.Id.R_CURLY);
    }

    protected Token takeDoc() {
        Token doc = this.m_doc;
        this.m_doc = null;
        return doc;
    }

    protected void log(Severity severity, String sCode, long lPosStart, long lPosEnd, Object ... aoParam) {
        if (this.m_lookAhead != null) {
            this.m_lookAhead.log(severity, sCode, aoParam, lPosStart, lPosEnd);
        } else if (this.m_errorListener.log(severity, sCode, aoParam, this.m_source, lPosStart, lPosEnd)) {
            this.m_fAvoidRecovery = true;
            throw new CompilerException("error list is full: " + String.valueOf(this.m_errorListener));
        }
    }

    protected boolean recoverable() {
        return !this.eof() && !this.m_fAvoidRecovery && this.m_lookAhead == null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        Source source = this.m_source;
        sb.append(source.getSimpleFileName());
        Token token = this.peek();
        if (token == null) {
            sb.append(' ').append(source.getLine() + 1).append(':').append(source.getOffset() + 1);
        } else {
            sb.append(' ').append(Source.calculateLine(token.getStartPosition()) + 1).append(':').append(Source.calculateOffset(token.getStartPosition()) + 1).append(' ').append(token);
        }
        return sb.toString();
    }

    protected static class Mark {
        long pos;
        Token token;
        Token putBack;
        Token lastMatch;
        Token doc;
        boolean noRec;

        protected Mark() {
        }
    }

    public class SafeLookAhead
    implements AutoCloseable {
        SafeLookAhead m_oldLookAhead;
        Mark m_mark;
        ErrorListener.ErrorInfo m_err;
        boolean m_fKeepResults;

        public SafeLookAhead() {
            this.m_oldLookAhead = Parser.this.m_lookAhead;
            Parser.this.m_lookAhead = this;
            this.m_mark = Parser.this.mark();
        }

        public void log(Severity severity, String sCode, Object[] aoParam, long lPosStart, long lPosEnd) {
            if (severity.ordinal() >= Severity.ERROR.ordinal()) {
                this.m_err = new ErrorListener.ErrorInfo(severity, sCode, aoParam, Parser.this.m_source, lPosStart, lPosEnd);
                this.m_fKeepResults = false;
                throw new CompilerException("err=" + String.valueOf(this.m_err));
            }
        }

        public boolean isClean() {
            return this.m_err == null;
        }

        public void keepResults() {
            this.m_fKeepResults = true;
        }

        @Override
        public void close() {
            assert (Parser.this.m_lookAhead == this);
            Parser.this.m_lookAhead = this.m_oldLookAhead;
            if (this.m_fKeepResults) {
                assert (this.m_err == null);
            } else {
                Parser.this.restore(this.m_mark);
            }
        }
    }
}

