/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.compiler;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.NoSuchElementException;
import org.xvm.compiler.Constants;
import org.xvm.compiler.Lexer;
import org.xvm.tool.ModuleInfo;
import org.xvm.util.Handy;

public class Source
implements Constants,
Cloneable {
    private final char[] m_ach;
    private final int m_cch;
    private int m_of;
    private int m_iLine;
    private int m_iLineOffset;
    private boolean m_fEscapesEncountered;
    private ModuleInfo.FileNode m_node;
    private String m_sFile;
    private File m_file;

    public Source(String sScript) {
        this(sScript.toCharArray());
    }

    public Source(File file) throws IOException {
        this(Handy.readFileChars(file));
        this.m_file = file;
    }

    public Source(ModuleInfo.FileNode node) {
        this.m_file = node.file();
        this.m_ach = node.content();
        this.m_cch = this.m_ach.length;
        this.m_node = node;
    }

    public Source(InputStream stream) {
        this(Source.fromInputStream(stream));
    }

    private static char[] fromInputStream(InputStream stream) {
        try {
            int n;
            StringBuilder sb = new StringBuilder();
            while ((n = stream.read()) >= 0) {
                sb.append((char)n);
            }
            return sb.toString().toCharArray();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    Source(char[] ach) {
        assert (ach != null);
        this.m_ach = ach;
        this.m_cch = ach.length;
    }

    public String getFileName() {
        if (this.m_sFile == null && this.m_file != null) {
            this.m_sFile = this.m_file.getPath();
        }
        return this.m_sFile;
    }

    public String getSimpleFileName() {
        return this.m_file == null ? "<no file>" : this.m_file.getName();
    }

    public Object resolvePath(String sFile) {
        return sFile != null && !sFile.isEmpty() && this.m_node != null ? this.m_node.resolveResource(sFile) : null;
    }

    public Source includeString(String sFile) throws IOException {
        File file;
        Object resource = this.resolvePath(sFile);
        if (resource instanceof File && Handy.checkReadable(file = (File)resource)) {
            return new Source(file);
        }
        return null;
    }

    public byte[] includeBinary(String sFile) throws IOException {
        File file;
        Object resource = this.resolvePath(sFile);
        if (resource instanceof File && Handy.checkReadable(file = (File)resource)) {
            return Handy.readFileBytes(file);
        }
        return null;
    }

    public boolean hasNext() {
        return this.m_of < this.m_cch;
    }

    public char next() {
        int ch;
        char[] ach = this.m_ach;
        int of = this.m_of;
        int cch = this.m_cch;
        if (of >= cch) {
            throw new NoSuchElementException();
        }
        if (Lexer.isLineTerminator((char)(ch = ach[of++]))) {
            if (ch == 13 && of < cch && ach[of] == '\n') {
                ++of;
                ch = 10;
            }
            ++this.m_iLine;
            this.m_iLineOffset = 0;
        } else {
            int cchAdjust = 1;
            if (ch == 92 && of + 4 < cch && Handy.isHexit(ach[of + 1]) && Handy.isHexit(ach[of + 2]) && Handy.isHexit(ach[of + 3]) && Handy.isHexit(ach[of + 4])) {
                char chU = ach[of];
                if (chU == 'u') {
                    int nch = Handy.hexitValue(ach[of + 1]) << 12 | Handy.hexitValue(ach[of + 2]) << 8 | Handy.hexitValue(ach[of + 3]) << 4 | Handy.hexitValue(ach[of + 4]);
                    ch = (char)nch;
                    of += 5;
                    cchAdjust += 5;
                    this.m_fEscapesEncountered = true;
                } else if (chU == 'U' && of + 8 < cch && Handy.isHexit(ach[of + 5]) && Handy.isHexit(ach[of + 6]) && Handy.isHexit(ach[of + 7]) && Handy.isHexit(ach[of + 8])) {
                    int nch = Handy.hexitValue(ach[of + 1]) << 28 | Handy.hexitValue(ach[of + 2]) << 24 | Handy.hexitValue(ach[of + 3]) << 20 | Handy.hexitValue(ach[of + 4]) << 16 | Handy.hexitValue(ach[of + 5]) << 12 | Handy.hexitValue(ach[of + 6]) << 8 | Handy.hexitValue(ach[of + 7]) << 4 | Handy.hexitValue(ach[of + 8]);
                    ch = (char)(nch > 65535 ? 63 : (char)nch);
                    of += 9;
                    cchAdjust += 9;
                    this.m_fEscapesEncountered = true;
                }
            }
            if (this.m_iLineOffset >= 0) {
                this.m_iLineOffset += cchAdjust;
            }
        }
        this.m_of = of;
        return (char)ch;
    }

    public void rewind() {
        char ch;
        int of = this.m_of;
        if (of <= 0) {
            throw new NoSuchElementException();
        }
        char[] ach = this.m_ach;
        if (Lexer.isLineTerminator(ch = ach[--of])) {
            if (ch == '\n' && of > 0 && ach[of - 1] == '\r') {
                --of;
            }
            --this.m_iLine;
            this.m_iLineOffset = -1;
        } else {
            int cchAdjust = 1;
            if (this.m_fEscapesEncountered && Handy.isHexit(ch) && of >= 5 && Handy.isHexit(ach[of - 1]) && Handy.isHexit(ach[of - 2]) && Handy.isHexit(ach[of - 3])) {
                if (ach[of - 5] == '\\' && ach[of - 4] == 'u') {
                    of -= 5;
                    cchAdjust += 5;
                } else if (of >= 9 && ach[of - 9] == '\\' && ach[of - 8] == 'U' && Handy.isHexit(ach[of - 7]) && Handy.isHexit(ach[of - 6]) && Handy.isHexit(ach[of - 5]) && Handy.isHexit(ach[of - 4])) {
                    of -= 9;
                    cchAdjust += 9;
                }
            }
            if (this.m_iLineOffset >= 0) {
                this.m_iLineOffset -= cchAdjust;
            }
        }
        this.m_of = of;
    }

    public int getLine() {
        return this.m_iLine;
    }

    public int getOffset() {
        int iLineOffset = this.m_iLineOffset;
        if (iLineOffset < 0) {
            iLineOffset = 0;
            int of = this.m_of;
            while (of > 0 && !Lexer.isLineTerminator(this.m_ach[--of])) {
                ++iLineOffset;
            }
            this.m_iLineOffset = iLineOffset;
        }
        return iLineOffset;
    }

    public long getPosition() {
        int iLineOffset = this.getOffset();
        assert (this.m_of >= 0);
        assert (this.m_iLine >= 0);
        assert (iLineOffset >= 0);
        if (this.m_of > 0xFFFFFF || this.m_iLine > 1048575 || iLineOffset >= 1048575) {
            throw new IllegalStateException();
        }
        return ((long)this.m_of & 0xFFFFFFL) << 40 | ((long)this.m_iLine & 0xFFFFFL) << 20 | (long)iLineOffset & 0xFFFFFL;
    }

    public void setPosition(long lPosition) {
        this.m_of = (int)(lPosition >>> 40) & 0xFFFFFF;
        this.m_iLine = (int)(lPosition >>> 20) & 0xFFFFF;
        this.m_iLineOffset = (int)lPosition & 0xFFFFF;
    }

    public static int calculateLine(long lPosition) {
        return (int)(lPosition >>> 20) & 0xFFFFF;
    }

    public static int calculateOffset(long lPosition) {
        return (int)lPosition & 0xFFFFF;
    }

    public String toString(long lPositionFrom, long lPositionTo) {
        long lPositionSave = this.getPosition();
        this.setPosition(lPositionFrom);
        int ofEnd = (int)(lPositionTo >>> 40) & 0xFFFFFF;
        assert (ofEnd >= this.m_of);
        char[] ach = new char[ofEnd - this.m_of];
        int cch = 0;
        while (this.m_of < ofEnd) {
            ach[cch++] = this.next();
        }
        this.setPosition(lPositionSave);
        return new String(ach, 0, cch);
    }

    public Source clone() {
        try {
            Source that = (Source)super.clone();
            that.reset();
            return that;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public void reset() {
        this.m_of = 0;
        this.m_iLine = 0;
        this.m_iLineOffset = 0;
    }

    public String toString() {
        long lCur = this.getPosition();
        String sIntro = "...";
        for (int i = 0; i < 20; ++i) {
            try {
                this.rewind();
                continue;
            }
            catch (NoSuchElementException e) {
                sIntro = "";
                break;
            }
        }
        long lPre = this.getPosition();
        this.setPosition(lCur);
        String sEpilogue = "...";
        for (int i = 0; i < 20; ++i) {
            try {
                this.next();
                continue;
            }
            catch (NoSuchElementException e) {
                sEpilogue = "(EOF)";
                break;
            }
        }
        long lPost = this.getPosition();
        this.setPosition(lCur);
        String sPre = this.toString(lPre, lCur);
        String sPost = this.toString(lCur, lPost);
        StringBuilder sb = new StringBuilder(sIntro);
        Handy.appendString(sb, sPre);
        char[] achIndent = new char[sb.length()];
        Arrays.fill(achIndent, ' ');
        Handy.appendString(sb, sPost).append(sEpilogue).append('\n').append(new String(achIndent)).append('^');
        return sb.toString();
    }

    public String toRawString() {
        return new String(this.m_ach);
    }
}

