/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.compiler;

import java.util.HashMap;
import java.util.Map;
import org.xvm.asm.ErrorListener;
import org.xvm.compiler.Source;
import org.xvm.util.Handy;
import org.xvm.util.Severity;

public class Token
implements Cloneable {
    private long m_lStartPos;
    private final long m_lEndPos;
    private Id m_id;
    private final Object m_oValue;
    private boolean m_fLeadingWhitespace;
    private boolean m_fTrailingWhitespace;

    public Token(long lStartPos, long lEndPos, Id id) {
        this(lStartPos, lEndPos, id, null);
    }

    public Token(long lStartPos, long lEndPos, Id id, Object oValue) {
        this.m_lStartPos = lStartPos;
        this.m_lEndPos = lEndPos;
        this.m_id = id;
        this.m_oValue = oValue;
    }

    public Token withValue(Object oValue) {
        return new Token(this.m_lStartPos, this.m_lEndPos, this.m_id, oValue);
    }

    public void noteWhitespace(boolean fWhitespaceBefore, boolean fWhitespaceAfter) {
        this.m_fLeadingWhitespace = fWhitespaceBefore;
        this.m_fTrailingWhitespace = fWhitespaceAfter;
    }

    public long getStartPosition() {
        return this.m_lStartPos;
    }

    public long getEndPosition() {
        return this.m_lEndPos;
    }

    public boolean hasLeadingWhitespace() {
        return this.m_fLeadingWhitespace;
    }

    public boolean hasTrailingWhitespace() {
        return this.m_fTrailingWhitespace;
    }

    public Id getId() {
        return this.m_id;
    }

    public Object getValue() {
        return this.m_oValue;
    }

    public String getValueText() {
        return this.m_oValue == null ? this.m_id.TEXT : this.m_oValue.toString();
    }

    public boolean isSpecial() {
        if (this.m_id == Id.IDENTIFIER) {
            Id keywordId = Id.valueByContextSensitiveText((String)this.getValue());
            return keywordId != null && keywordId.Special;
        }
        return false;
    }

    public boolean isContextSensitive() {
        return this.m_id == Id.IDENTIFIER && Id.valueByContextSensitiveText((String)this.getValue()) != null;
    }

    public Id getContextSensitiveId() {
        return this.m_id == Id.IDENTIFIER ? Id.valueByContextSensitiveText(this.m_oValue.toString()) : null;
    }

    public Token convertToKeyword() {
        if (this.m_id != Id.IDENTIFIER) {
            throw new IllegalStateException("not an identifier! (" + String.valueOf(this) + ")");
        }
        Id id = Id.valueByContextSensitiveText((String)this.getValue());
        if (id == null) {
            throw new IllegalStateException("missing context sensitive keyword for: " + String.valueOf(this.getValue()));
        }
        return new Token(this.m_lStartPos, this.m_lEndPos, id, this.m_oValue);
    }

    public Token desensitize() {
        return this.m_id.ContextSensitive ? new Token(this.m_lStartPos, this.m_lEndPos, Id.IDENTIFIER, this.m_oValue) : this;
    }

    Token refine(Id id) {
        this.m_id = id;
        return this;
    }

    public Token peel(Id id, Source source) {
        Id newId = null;
        if (id == Id.COMP_GT) {
            switch (this.m_id.ordinal()) {
                default: {
                    return null;
                }
                case 47: {
                    newId = Id.SHR_ASN;
                    break;
                }
                case 29: {
                    newId = Id.SHR;
                    break;
                }
                case 46: {
                    newId = Id.COMP_GTEQ;
                    break;
                }
                case 28: {
                    newId = Id.COMP_GT;
                    break;
                }
                case 62: {
                    newId = Id.ASN;
                    break;
                }
            }
        } else if (id == Id.COMP_LT) {
            switch (this.m_id.ordinal()) {
                default: {
                    return null;
                }
                case 45: {
                    newId = Id.COMP_LTEQ;
                    break;
                }
                case 27: {
                    newId = Id.COMP_LT;
                }
            }
        }
        if (newId == null) {
            return null;
        }
        long start = this.m_lStartPos;
        long current = source.getPosition();
        source.setPosition(start);
        source.next();
        long middle = source.getPosition();
        source.setPosition(current);
        this.m_lStartPos = middle;
        this.m_id = newId;
        Token peeled = new Token(start, middle, id);
        peeled.noteWhitespace(this.hasLeadingWhitespace(), false);
        this.noteWhitespace(false, this.hasTrailingWhitespace());
        return peeled;
    }

    public Token anneal(Token that) {
        if (this.m_id == Id.COMP_LT && this.m_lEndPos == that.m_lStartPos) {
            switch (that.m_id.ordinal()) {
                case 60: {
                    return new Token(this.m_lStartPos, that.m_lEndPos, Id.SHL_ASN);
                }
                case 59: {
                    return new Token(this.m_lStartPos, that.m_lEndPos, Id.SHL);
                }
            }
        }
        return null;
    }

    public String getString(Source source) {
        return source.toString(this.m_lStartPos, this.m_lEndPos);
    }

    public boolean log(ErrorListener errs, Source source, Severity severity, String sCode, Object ... aoParam) {
        if (aoParam == null || aoParam.length == 0) {
            aoParam = new Object[]{source == null ? this.toString() : this.getString(source)};
        }
        return errs.log(severity, sCode, aoParam, source, source == null ? 0L : this.getStartPosition(), source == null ? 0L : this.getEndPosition());
    }

    public String toDebugString() {
        return "[" + Source.calculateLine(this.m_lStartPos) + "," + Source.calculateOffset(this.m_lStartPos) + " - " + Source.calculateLine(this.m_lEndPos) + "," + Source.calculateOffset(this.m_lEndPos) + "] " + String.valueOf(this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        switch (this.m_id.ordinal()) {
            case 148: {
                sb.append('\'');
                Handy.appendChar(sb, ((Character)this.m_oValue).charValue());
                sb.append('\'');
                break;
            }
            case 149: {
                sb.append('\"');
                Handy.appendString(sb, (String)this.m_oValue);
                sb.append('\"');
                break;
            }
            case 151: 
            case 164: 
            case 170: {
                sb.append(this.m_oValue);
                break;
            }
            case 146: 
            case 147: 
            case 152: 
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: 
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 166: 
            case 167: 
            case 168: 
            case 169: 
            case 173: 
            case 174: 
            case 175: 
            case 176: 
            case 177: 
            case 178: {
                sb.append(this.m_id.TEXT).append(':').append(this.m_oValue);
                break;
            }
            case 143: {
                sb.append("name:").append(this.m_oValue);
                break;
            }
            case 145: {
                Object sComment = (String)this.m_oValue;
                if (((String)sComment).length() > 47) {
                    sComment = ((String)sComment).substring(0, 44) + "...";
                }
                Handy.appendString(sb.append("/*"), (String)sComment).append("*/");
                break;
            }
            case 144: {
                Object sComment = (String)this.m_oValue;
                if (((String)sComment).length() > 50) {
                    sComment = ((String)sComment).substring(0, 47) + "...";
                }
                Handy.appendString(sb.append("//"), (String)sComment);
                break;
            }
            default: {
                sb.append(this.m_id.TEXT);
            }
        }
        return sb.toString();
    }

    public Token clone() {
        try {
            return (Token)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException(e);
        }
    }

    public static enum Id {
        COLON(":"),
        SEMICOLON(";"),
        COMMA(","),
        DOT("."),
        I_RANGE_I(".."),
        E_RANGE_I(">.."),
        I_RANGE_E("..<"),
        E_RANGE_E(">..<"),
        DIR_CUR("./"),
        DIR_PARENT("../"),
        STR_FILE("$"),
        BIN_FILE("#"),
        AT("@"),
        COND("?"),
        L_PAREN("("),
        ASYNC_PAREN("^("),
        R_PAREN(")"),
        L_CURLY("{"),
        R_CURLY("}"),
        L_SQUARE("["),
        R_SQUARE("]"),
        ADD("+"),
        SUB("-"),
        MUL("*"),
        DIV("/"),
        MOD("%"),
        DIVREM("/%"),
        SHL("<<"),
        SHR(">>"),
        USHR(">>>"),
        BIT_AND("&"),
        BIT_OR("|"),
        BIT_XOR("^"),
        BIT_NOT("~"),
        NOT("!"),
        COND_AND("&&"),
        COND_XOR("^^"),
        COND_OR("||"),
        COND_ELSE("?:"),
        ASN("="),
        ADD_ASN("+="),
        SUB_ASN("-="),
        MUL_ASN("*="),
        DIV_ASN("/="),
        MOD_ASN("%="),
        SHL_ASN("<<="),
        SHR_ASN(">>="),
        USHR_ASN(">>>="),
        BIT_AND_ASN("&="),
        BIT_OR_ASN("|="),
        BIT_XOR_ASN("^="),
        COND_AND_ASN("&&="),
        COND_OR_ASN("||="),
        COND_ASN(":="),
        COND_NN_ASN("?="),
        COND_ELSE_ASN("?:="),
        COMP_EQ("=="),
        COMP_NEQ("!="),
        COMP_ORD("<=>"),
        COMP_LT("<"),
        COMP_LTEQ("<="),
        COMP_GT(">"),
        COMP_GTEQ(">="),
        INC("++"),
        DEC("--"),
        LAMBDA("->"),
        ASN_EXPR("<-"),
        ANY("_"),
        ALLOW("allow", true),
        ANNOTATION("annotation"),
        AS("as"),
        ASSERT("assert"),
        ASSERT_RND("assert:rnd"),
        ASSERT_ARG("assert:arg"),
        ASSERT_BOUNDS("assert:bounds"),
        ASSERT_TODO("assert:TODO"),
        ASSERT_ONCE("assert:once"),
        ASSERT_TEST("assert:test"),
        ASSERT_DBG("assert:debug"),
        AVOID("avoid", true),
        BREAK("break"),
        CASE("case"),
        CATCH("catch"),
        CLASS("class", true),
        CONDITIONAL("conditional"),
        CONST("const", true),
        CONSTRUCT("construct"),
        CONTINUE("continue"),
        DEFAULT("default"),
        DELEGATES("delegates", true),
        DESIRED("desired", true),
        DO("do"),
        ELSE("else"),
        EMBEDDED("embedded", true),
        ENUM("enum", true),
        EXTENDS("extends", true),
        FINALLY("finally"),
        FOR("for"),
        FUNCTION("function"),
        IF("if"),
        IMMUTABLE("immutable"),
        IMPLEMENTS("implements", true),
        IMPORT("import"),
        INCORPORATES("incorporates", true),
        INJECT("inject", true),
        INTERFACE("interface", true),
        INTO("into", true),
        IS("is"),
        MIXIN("mixin", true),
        MODULE("module", true),
        NEW("new"),
        OPTIONAL("optional", true),
        OUTER("outer", true, true),
        PACKAGE("package", true),
        PREFER("prefer", true),
        PRIVATE("private"),
        PROTECTED("protected"),
        PUBLIC("public"),
        REQUIRED("required", true),
        RETURN("return"),
        SERVICE("service", true),
        STATIC("static"),
        STRUCT("struct", true),
        SUPER("super", true, true),
        SWITCH("switch"),
        THIS("this", true, true),
        THIS_CLASS("this:class", true, true),
        THIS_MODULE("this:module", true, true),
        THIS_PRI("this:private", true, true),
        THIS_PRO("this:protected", true, true),
        THIS_PUB("this:public", true, true),
        THIS_SERV("this:service", true, true),
        THIS_STRUCT("this:struct", true, true),
        THIS_TARGET("this:target", true, true),
        THROW("throw"),
        TODO("TODO"),
        TRY("try"),
        TYPEDEF("typedef"),
        USING("using"),
        VAL("val", true),
        VAR("var", true),
        VOID("void"),
        WHILE("while"),
        IDENTIFIER(null),
        EOL_COMMENT(null),
        ENC_COMMENT(null),
        LIT_BIT(null),
        LIT_NIBBLE(null),
        LIT_CHAR(null),
        LIT_STRING(null),
        LIT_BINSTR(null),
        LIT_INT(null),
        LIT_INT8("Int8", true, true),
        LIT_INT16("Int16", true, true),
        LIT_INT32("Int32", true, true),
        LIT_INT64("Int64", true, true),
        LIT_INT128("Int128", true, true),
        LIT_INTN("IntN", true, true),
        LIT_UINT8("UInt8", true, true),
        LIT_UINT16("UInt16", true, true),
        LIT_UINT32("UInt32", true, true),
        LIT_UINT64("UInt64", true, true),
        LIT_UINT128("UInt128", true, true),
        LIT_UINTN("UIntN", true, true),
        LIT_DEC(null),
        LIT_DECA("Dec", true, true),
        LIT_DEC32("Dec32", true, true),
        LIT_DEC64("Dec64", true, true),
        LIT_DEC128("Dec128", true, true),
        LIT_DECN("DecN", true, true),
        LIT_FLOAT(null),
        LIT_FLOAT8E4("Float8e4", true, true),
        LIT_FLOAT8E5("Float8e5", true, true),
        LIT_BFLOAT16("BFloat16", true, true),
        LIT_FLOAT16("Float16", true, true),
        LIT_FLOAT32("Float32", true, true),
        LIT_FLOAT64("Float64", true, true),
        LIT_FLOAT128("Float128", true, true),
        LIT_FLOATN("FloatN", true, true),
        LIT_DATE(null),
        LIT_TIMEOFDAY(null),
        LIT_TIME(null),
        LIT_TIMEZONE(null),
        LIT_DURATION(null),
        LIT_VERSION(null),
        LIT_PATH(null),
        TEMPLATE("{...}"),
        ENUM_VAL("enum-value");

        private static final Id[] IDs;
        private static final Map<String, Id> KEYWORDS;
        private static final Map<String, Id> ALL_KEYWORDS;
        private static final Map<String, Id> PREFIXES;
        public final String TEXT;
        final boolean ContextSensitive;
        final boolean Special;

        private Id(String sText) {
            this(sText, false);
        }

        private Id(String sText, boolean fContextSensitive) {
            this(sText, fContextSensitive, false);
        }

        private Id(String sText, boolean fContextSensitive, boolean fSpecial) {
            this.TEXT = sText;
            this.ContextSensitive = fContextSensitive;
            this.Special = fSpecial;
        }

        public String toString() {
            return this.TEXT == null ? super.toString() : "\"" + this.TEXT + "\"";
        }

        public static Id valueOf(int i) {
            return IDs[i];
        }

        public static Id valueByText(String sText) {
            return KEYWORDS.get(sText);
        }

        public static Id valueByContextSensitiveText(String sText) {
            return ALL_KEYWORDS.get(sText);
        }

        public static Id valueByPrefix(String sText) {
            return PREFIXES.get(sText);
        }

        static {
            IDs = Id.values();
            KEYWORDS = new HashMap<String, Id>();
            ALL_KEYWORDS = new HashMap<String, Id>();
            PREFIXES = new HashMap<String, Id>();
            for (Id id : IDs) {
                Id prefix;
                int ofColon;
                char ch;
                String sText = id.TEXT;
                if (sText == null || sText.isEmpty() || !((ch = sText.charAt(0)) >= 'A' && ch <= 'Z' || ch >= 'a' && ch <= 'z') && ch != '_') continue;
                ALL_KEYWORDS.put(sText, id);
                if (!id.ContextSensitive) {
                    KEYWORDS.put(sText, id);
                }
                if ((ofColon = sText.indexOf(58)) <= 0 || (prefix = ALL_KEYWORDS.get(sText.substring(0, ofColon))) == null) continue;
                PREFIXES.put(prefix.TEXT, prefix);
            }
        }
    }
}

