/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.compiler.ast;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import org.xvm.asm.Annotation;
import org.xvm.asm.ClassStructure;
import org.xvm.asm.Component;
import org.xvm.asm.Constant;
import org.xvm.asm.ConstantPool;
import org.xvm.asm.ErrorListener;
import org.xvm.asm.constants.AnnotatedTypeConstant;
import org.xvm.asm.constants.IdentityConstant;
import org.xvm.asm.constants.TypeConstant;
import org.xvm.asm.constants.TypedefConstant;
import org.xvm.asm.constants.UnresolvedNameConstant;
import org.xvm.asm.constants.UnresolvedTypeConstant;
import org.xvm.compiler.ast.AnnotationExpression;
import org.xvm.compiler.ast.AnonInnerClass;
import org.xvm.compiler.ast.AstNode;
import org.xvm.compiler.ast.Context;
import org.xvm.compiler.ast.Expression;
import org.xvm.compiler.ast.Parameter;
import org.xvm.compiler.ast.StageMgr;
import org.xvm.compiler.ast.TypeExpression;
import org.xvm.util.Severity;

public class AnnotatedTypeExpression
extends TypeExpression {
    protected AnnotationExpression annotation;
    protected TypeExpression type;
    private transient boolean m_fDisassociateRef;
    private transient boolean m_fDisassociateClass;
    private transient boolean m_fAnonInner;
    private transient boolean m_fVar;
    private transient boolean m_fInjected;
    private transient UnresolvedTypeConstant m_typeUnresolved;
    private static final Field[] CHILD_FIELDS = AnnotatedTypeExpression.fieldsForNames(AnnotatedTypeExpression.class, "annotation", "type");

    public AnnotatedTypeExpression(AnnotationExpression annotation, TypeExpression type) {
        this.annotation = annotation;
        this.type = type;
    }

    AnnotationExpression getAnnotation() {
        return this.annotation;
    }

    public boolean isDisassociated() {
        return this.m_fDisassociateRef;
    }

    public boolean isIntoRef() {
        AnnotatedTypeExpression exprType;
        TypeExpression typeExpression;
        return this.m_fDisassociateRef || (typeExpression = this.type) instanceof AnnotatedTypeExpression && (exprType = (AnnotatedTypeExpression)typeExpression).isIntoRef();
    }

    public boolean isVar() {
        AnnotatedTypeExpression exprType;
        TypeExpression typeExpression;
        return this.m_fVar || (typeExpression = this.type) instanceof AnnotatedTypeExpression && (exprType = (AnnotatedTypeExpression)typeExpression).isVar();
    }

    public boolean isInjected() {
        AnnotatedTypeExpression exprType;
        TypeExpression typeExpression;
        return this.m_fInjected || (typeExpression = this.type) instanceof AnnotatedTypeExpression && (exprType = (AnnotatedTypeExpression)typeExpression).isInjected();
    }

    public boolean contains(Constant clzAnno) {
        AnnotatedTypeExpression exprType;
        TypeExpression typeExpression;
        Annotation anno = this.annotation.ensureAnnotation(this.pool());
        return anno.getAnnotationClass().equals(clzAnno) || (typeExpression = this.type) instanceof AnnotatedTypeExpression && (exprType = (AnnotatedTypeExpression)typeExpression).contains(clzAnno);
    }

    public List<AnnotationExpression> getRefAnnotations() {
        ArrayList<AnnotationExpression> list = new ArrayList<AnnotationExpression>();
        this.collectRefAnnotations(list);
        return list;
    }

    protected void collectRefAnnotations(List<AnnotationExpression> list) {
        TypeExpression typeExpression;
        if (this.m_fDisassociateRef) {
            list.add(this.annotation);
        }
        if ((typeExpression = this.type) instanceof AnnotatedTypeExpression) {
            AnnotatedTypeExpression exprType = (AnnotatedTypeExpression)typeExpression;
            exprType.collectRefAnnotations(list);
        }
    }

    @Override
    protected boolean canResolveNames() {
        return super.canResolveNames() || this.type.canResolveNames();
    }

    @Override
    public long getStartPosition() {
        return this.annotation.getStartPosition();
    }

    @Override
    public long getEndPosition() {
        return this.type.getEndPosition();
    }

    @Override
    protected Field[] getChildFields() {
        return CHILD_FIELDS;
    }

    @Override
    public boolean isIntroductoryType() {
        return true;
    }

    @Override
    public TypeExpression unwrapIntroductoryType() {
        return this.type;
    }

    @Override
    public void replaceIntroducedType(TypeExpression type) {
        this.type = type;
        type.setParent(this);
    }

    @Override
    protected TypeConstant instantiateTypeConstant(Context ctx, ErrorListener errs) {
        return this.calculateType(ctx, errs);
    }

    @Override
    protected void collectAnonInnerClassInfo(AnonInnerClass info) {
        this.m_fAnonInner = true;
        info.addAnnotation(this.getAnnotation());
        this.type.collectAnonInnerClassInfo(info);
    }

    @Override
    protected void setTypeConstant(TypeConstant constType) {
        TypeConstant constBase = constType;
        if (!this.m_fDisassociateClass && !this.m_fDisassociateRef) {
            constBase = constType.getUnderlyingType();
        }
        this.type.setTypeConstant(constBase);
        super.setTypeConstant(constType);
    }

    @Override
    public void resolveNames(StageMgr mgr, ErrorListener errs) {
        if (!mgr.processChildren()) {
            mgr.requestRevisit();
            return;
        }
        this.calculateType(null, errs);
        if (this.m_typeUnresolved == null) {
            this.resetTypeConstant();
        } else {
            mgr.requestRevisit();
        }
    }

    @Override
    protected Expression validate(Context ctx, TypeConstant typeRequired, ErrorListener errs) {
        TypeConstant typeType;
        TypeConstant typeReq;
        ConstantPool pool = this.pool();
        TypeExpression exprTypeNew = (TypeExpression)this.type.validate(ctx, pool.typeType(), errs);
        if (exprTypeNew == null) {
            return null;
        }
        this.type = exprTypeNew;
        TypeConstant typeReferent = this.ensureTypeConstant(ctx, errs);
        Annotation anno = this.annotation.ensureAnnotation(pool);
        TypeConstant typeAnno = anno.getAnnotationType();
        if (typeAnno.containsUnresolved()) {
            this.annotation.log(errs, Severity.ERROR, "COMPILER-38", typeAnno.getValueString());
            return null;
        }
        if (this.m_fDisassociateRef) {
            Constant clzAnno = anno.getAnnotationClass();
            if (clzAnno.equals(pool.clzInject())) {
                this.m_fInjected = true;
            }
            if (exprTypeNew instanceof AnnotatedTypeExpression) {
                AnnotatedTypeExpression exprTypeNext = (AnnotatedTypeExpression)exprTypeNew;
                if (this.m_fInjected || exprTypeNext.isInjected()) {
                    this.log(errs, Severity.ERROR, "COMPILER-165", new Object[0]);
                    return null;
                }
                if (exprTypeNext.contains(clzAnno)) {
                    this.log(errs, Severity.ERROR, "VERIFY-28", anno.getAnnotationType().getValueString());
                    return null;
                }
            }
            this.m_fVar = typeAnno.getIntoVariableType().isA(pool.typeVar());
            typeReq = pool.ensureParameterizedTypeConstant(this.m_fVar ? pool.typeVar() : pool.typeRef(), typeReferent);
        } else if (typeReferent.isA(typeAnno.ensureTypeInfo(errs).getInto())) {
            TypeConstant typeConstant;
            if (typeReferent instanceof AnnotatedTypeConstant) {
                AnnotatedTypeConstant exprAnno = (AnnotatedTypeConstant)typeReferent;
                typeConstant = exprAnno.getAnnotationType();
            } else {
                typeConstant = typeAnno;
            }
            typeReq = typeConstant;
        } else if (this.m_fAnonInner && this.m_fDisassociateClass) {
            typeReq = null;
        } else {
            this.log(errs, Severity.ERROR, "VERIFY-32", this.type.ensureTypeConstant(ctx, errs).getValueString(), anno.getAnnotationClass().getValueString(), typeAnno.ensureTypeInfo(errs).getInto().getValueString());
            return null;
        }
        AnnotationExpression exprOld = this.annotation;
        AnnotationExpression exprNew = (AnnotationExpression)exprOld.validate(ctx, typeReq, errs);
        if (exprNew == null) {
            return null;
        }
        this.annotation = exprNew;
        this.resetTypeConstant();
        typeAnno = this.ensureTypeConstant(ctx, errs);
        Constant constValue = typeType = typeAnno.getType();
        if (typeRequired != null) {
            if (typeRequired.isA(pool.typeClass())) {
                IdentityConstant clzAnno = pool.ensureClassConstant(typeAnno);
                typeType = clzAnno.getValueType(pool, null);
                constValue = clzAnno;
            } else {
                TypeConstant typeInferred = this.inferTypeFromRequired(typeType, typeRequired);
                if (typeInferred != null) {
                    constValue = typeType = typeInferred;
                }
            }
        }
        return this.finishValidation(ctx, typeRequired, typeType, Expression.TypeFit.Fit, constValue, errs);
    }

    protected TypeConstant calculateType(Context ctx, ErrorListener errs) {
        TypeConstant type;
        boolean fResolved;
        ConstantPool pool = this.pool();
        TypeConstant typeUnderlying = this.type.ensureTypeConstant(ctx, errs);
        Annotation anno = this.annotation.ensureAnnotation(this.pool());
        Constant constAnno = anno.getAnnotationClass();
        boolean bl = fResolved = !constAnno.containsUnresolved();
        if (fResolved) {
            ClassStructure clzAnno;
            IdentityConstant idAnno = (IdentityConstant)constAnno;
            if (idAnno instanceof TypedefConstant) {
                TypedefConstant idTypedef = (TypedefConstant)idAnno;
                TypeConstant typeRef = idTypedef.getReferredToType();
                if (typeRef.isSingleUnderlyingClass(false)) {
                    idAnno = typeRef.getSingleUnderlyingClass(false);
                } else {
                    this.log(errs, Severity.ERROR, "VERIFY-27", idTypedef);
                    return null;
                }
            }
            if ((clzAnno = (ClassStructure)idAnno.getComponent()).getFormat() != Component.Format.ANNOTATION) {
                this.log(errs, Severity.ERROR, "VERIFY-27", clzAnno.getName());
                return idAnno.getType();
            }
            TypeConstant typeInto = clzAnno.getTypeInto();
            if (typeInto.containsUnresolved()) {
                fResolved = false;
            } else {
                this.m_fDisassociateClass = typeInto.isIntoClassType();
                boolean bl2 = this.m_fDisassociateRef = typeInto.isIntoVariableType() || this.isMethodParameter() && typeInto.isIntoMethodParameterType();
            }
        }
        if (!fResolved) {
            return this.m_typeUnresolved == null ? (this.m_typeUnresolved = new UnresolvedTypeConstant(pool, new UnresolvedNameConstant(pool, constAnno.getValueString()))) : this.m_typeUnresolved;
        }
        if (this.m_fDisassociateClass || this.m_fDisassociateRef) {
            type = typeUnderlying;
        } else if (typeUnderlying.isA(anno.getAnnotationType())) {
            type = typeUnderlying;
            this.log(errs, Severity.ERROR, "VERIFY-28", anno.getAnnotationClass().getValueString());
        } else {
            type = pool.ensureAnnotatedTypeConstant(typeUnderlying, anno);
        }
        if (this.m_typeUnresolved != null) {
            this.m_typeUnresolved.resolve(type);
            this.m_typeUnresolved = null;
        }
        return type;
    }

    private boolean isMethodParameter() {
        AstNode parent = this.getParent();
        while (parent instanceof AnnotatedTypeExpression) {
            parent = parent.getParent();
        }
        return parent instanceof Parameter;
    }

    @Override
    public String toString() {
        return String.valueOf(this.annotation) + " " + String.valueOf(this.type);
    }

    @Override
    public String getDumpDesc() {
        return this.toString();
    }
}

