/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.compiler.ast;

import java.lang.reflect.Field;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.xvm.asm.Annotation;
import org.xvm.asm.Argument;
import org.xvm.asm.Assignment;
import org.xvm.asm.ClassStructure;
import org.xvm.asm.Component;
import org.xvm.asm.Constant;
import org.xvm.asm.ConstantPool;
import org.xvm.asm.ErrorListener;
import org.xvm.asm.MethodStructure;
import org.xvm.asm.ModuleStructure;
import org.xvm.asm.PropertyStructure;
import org.xvm.asm.Register;
import org.xvm.asm.constants.ClassConstant;
import org.xvm.asm.constants.ExpressionConstant;
import org.xvm.asm.constants.IdentityConstant;
import org.xvm.asm.constants.MethodBindingConstant;
import org.xvm.asm.constants.MethodConstant;
import org.xvm.asm.constants.TypeConstant;
import org.xvm.asm.constants.TypeInfo;
import org.xvm.asm.constants.UnresolvedNameConstant;
import org.xvm.compiler.Compiler;
import org.xvm.compiler.Source;
import org.xvm.compiler.Token;
import org.xvm.compiler.ast.AstNode;
import org.xvm.compiler.ast.Context;
import org.xvm.compiler.ast.Expression;
import org.xvm.compiler.ast.LabeledExpression;
import org.xvm.compiler.ast.LambdaExpression;
import org.xvm.compiler.ast.LiteralExpression;
import org.xvm.compiler.ast.NameExpression;
import org.xvm.compiler.ast.NameResolver;
import org.xvm.compiler.ast.NamedTypeExpression;
import org.xvm.compiler.ast.NonBindingExpression;
import org.xvm.compiler.ast.PropertyDeclarationStatement;
import org.xvm.compiler.ast.StageMgr;
import org.xvm.compiler.ast.TypeExpression;
import org.xvm.util.Severity;

public class AnnotationExpression
extends Expression {
    protected NamedTypeExpression type;
    protected List<Expression> args;
    protected long lStartPos;
    protected long lEndPos;
    private transient AstNode m_node;
    private transient Annotation m_anno;
    private transient boolean m_fConst;
    private static final Field[] CHILD_FIELDS = AnnotationExpression.fieldsForNames(AnnotationExpression.class, "type", "args");

    public AnnotationExpression(NamedTypeExpression type, List<Expression> args, long lStartPos, long lEndPos) {
        this.type = type;
        this.args = args;
        this.lStartPos = lStartPos;
        this.lEndPos = lEndPos;
    }

    public AnnotationExpression(Annotation anno, AstNode node) {
        this.m_anno = anno;
        this.m_node = node;
        this.lStartPos = node.getStartPosition();
        this.lEndPos = node.getEndPosition();
    }

    @Override
    public NamedTypeExpression toTypeExpression() {
        NamedTypeExpression exprType = this.type;
        if (exprType == null) {
            assert (this.m_node != null && this.m_anno != null);
            List<Token> names = Collections.singletonList(new Token(this.lStartPos, this.lEndPos, Token.Id.IDENTIFIER, ((IdentityConstant)this.m_anno.getAnnotationClass()).getName()));
            exprType = new NamedTypeExpression(null, names, null, null, null, this.lEndPos);
            exprType.setParent(this.getParent());
            this.type = exprType;
        }
        return exprType;
    }

    @Override
    public boolean isConstant() {
        return this.m_fConst;
    }

    @Override
    public boolean isAutoNarrowingAllowed(TypeExpression type) {
        return false;
    }

    @Override
    protected boolean canResolveNames() {
        return this.m_anno != null || super.canResolveNames() || this.type.canResolveNames();
    }

    @Override
    public long getStartPosition() {
        return this.lStartPos;
    }

    @Override
    public long getEndPosition() {
        return this.lEndPos;
    }

    @Override
    protected Field[] getChildFields() {
        return CHILD_FIELDS;
    }

    public Annotation ensureAnnotation(ConstantPool pool) {
        int cArgs;
        if (this.m_anno != null) {
            return this.m_anno;
        }
        Constant constClass = this.toTypeExpression().getIdentityConstant();
        List<Expression> listArgs = this.args;
        Constant[] aconstArgs = Constant.NO_CONSTS;
        int n = cArgs = listArgs == null ? 0 : listArgs.size();
        if (cArgs > 0) {
            aconstArgs = new Constant[cArgs];
            for (int iArg = 0; iArg < cArgs; ++iArg) {
                Expression exprArg = listArgs.get(iArg);
                if (exprArg.alreadyReached(Compiler.Stage.Validated)) {
                    aconstArgs[iArg] = exprArg.isConstant() ? exprArg.toConstant() : (exprArg instanceof NonBindingExpression ? pool.valDefault() : new ExpressionConstant(pool, exprArg));
                    continue;
                }
                if (exprArg instanceof LabeledExpression) {
                    LabeledExpression exprLbl = (LabeledExpression)exprArg;
                    exprArg = exprLbl.getUnderlyingExpression();
                }
                if (exprArg instanceof LiteralExpression) {
                    LiteralExpression exprLit = (LiteralExpression)exprArg;
                    if (exprLit.getLiteral().getId() == Token.Id.LIT_STRING) {
                        aconstArgs[iArg] = pool.ensureStringConstant(((LiteralExpression)exprArg).getLiteral().getValue().toString());
                        continue;
                    }
                    aconstArgs[iArg] = exprLit.getLiteralConstant();
                    continue;
                }
                if (exprArg instanceof NameExpression) {
                    NameExpression exprName = (NameExpression)exprArg;
                    aconstArgs[iArg] = new UnresolvedNameConstant(pool, exprName.collectNames(1), false);
                    continue;
                }
                aconstArgs[iArg] = new ExpressionConstant(pool, exprArg);
            }
        }
        this.m_anno = pool.ensureAnnotation(constClass, aconstArgs);
        return this.m_anno;
    }

    protected PropertyStructure getAnnotatedProperty() {
        PropertyStructure propertyStructure;
        AstNode astNode = this.getParent();
        if (astNode instanceof PropertyDeclarationStatement) {
            PropertyDeclarationStatement stmtProp = (PropertyDeclarationStatement)astNode;
            propertyStructure = (PropertyStructure)stmtProp.getComponent();
        } else {
            propertyStructure = null;
        }
        return propertyStructure;
    }

    protected boolean hasThis() {
        PropertyStructure prop = this.getAnnotatedProperty();
        return prop != null && !prop.isStatic();
    }

    @Override
    public void validateContent(StageMgr mgr, ErrorListener errs) {
        TypeInfo infoAnno;
        MethodConstant idConstruct;
        PropertyStructure prop;
        TypeConstant typeAnno;
        ClassStructure classStructure;
        Annotation anno = this.m_anno;
        assert (anno != null);
        Constant constAnno = anno.getAnnotationClass();
        if (constAnno.containsUnresolved()) {
            return;
        }
        ClassConstant idAnno = (ClassConstant)constAnno;
        if (idAnno.getComponent().getFormat() != Component.Format.ANNOTATION) {
            this.log(errs, Severity.ERROR, "VERIFY-27", anno.getValueString());
            return;
        }
        if (!mgr.processChildren()) {
            mgr.requestRevisit();
            return;
        }
        if (this.getCodeContainer() != null) {
            return;
        }
        ConstantPool pool = this.pool();
        List<Expression> listArgs = this.args;
        int cArgs = listArgs == null ? 0 : listArgs.size();
        Component comp = this.getComponent();
        if (comp instanceof ModuleStructure) {
            ModuleStructure module = (ModuleStructure)comp;
            classStructure = module;
        } else {
            classStructure = comp.getContainingClass();
        }
        ValidatingContext ctx = new ValidatingContext(classStructure);
        TypeConstant typeConstant = typeAnno = this.type == null ? idAnno.getType() : this.type.ensureTypeConstant();
        if (!typeAnno.isParamsSpecified() && typeAnno.isA(pool.typeRef()) && (prop = this.getAnnotatedProperty()) != null) {
            typeAnno = pool.ensureParameterizedTypeConstant(typeAnno, prop.getType());
        }
        if ((idConstruct = this.findMethod(ctx, typeAnno, infoAnno = this.ensureTypeInfo(typeAnno, errs), "construct", listArgs, TypeInfo.MethodKind.Constructor, true, false, TypeConstant.NO_TYPES, errs)) == null) {
            if (!errs.hasSeriousErrors()) {
                this.log(errs, Severity.ERROR, "COMPILER-65", idAnno.getValueString());
            }
            return;
        }
        if (cArgs > 0) {
            boolean fDefaults;
            MethodStructure constructor = infoAnno.getMethodById(idConstruct).getTopmostMethodStructure(infoAnno);
            if (this.containsNamedArgs(listArgs)) {
                if ((listArgs = this.rearrangeNamedArgs(constructor, listArgs, errs)) == null) {
                    return;
                }
                this.args = listArgs;
                cArgs = listArgs.size();
            }
            TypeConstant[] atypeParams = idConstruct.getRawParams();
            int cAll = constructor.getParamCount();
            int cRequired = constructor.getRequiredParamCount();
            Constant[] aconstArgs = new Constant[cAll];
            boolean bl = fDefaults = cArgs < cAll;
            assert (cArgs <= cAll && cArgs >= cRequired);
            for (int iArg = 0; iArg < cArgs; ++iArg) {
                int n;
                Expression exprOld = listArgs.get(iArg);
                if (exprOld instanceof LabeledExpression) {
                    LabeledExpression exprLbl = (LabeledExpression)exprOld;
                    n = constructor.getParam(exprLbl.getName()).getIndex();
                } else {
                    n = iArg;
                }
                int iParam = n;
                Expression exprNew = exprOld.validate(ctx, atypeParams[iParam], errs);
                if (exprNew == null) continue;
                if (exprNew != exprOld) {
                    listArgs.set(iArg, exprNew);
                }
                if (exprNew.isConstant()) {
                    aconstArgs[iParam] = exprNew.toConstant();
                    continue;
                }
                if (exprNew.isNonBinding()) {
                    fDefaults = true;
                    continue;
                }
                if (this.hasThis()) {
                    NameExpression exprName;
                    MethodStructure method = null;
                    if (exprNew instanceof NameExpression && (exprName = (NameExpression)exprNew).getMeaning() == NameExpression.Meaning.Method) {
                        MethodConstant idMethod = (MethodConstant)exprName.resolveRawArgument(ctx, false, ErrorListener.BLACKHOLE);
                        method = (MethodStructure)idMethod.getComponent();
                    } else if (exprNew instanceof LambdaExpression) {
                        LambdaExpression exprLambda = (LambdaExpression)exprNew;
                        method = exprLambda.getLambda();
                        exprLambda.calculateBindings(ctx, method.createCode(), errs);
                    }
                    if (method != null && method.getParamCount() == 0) {
                        aconstArgs[iParam] = new MethodBindingConstant(pool, method.getIdentityConstant());
                        continue;
                    }
                }
                exprOld.log(errs, Severity.ERROR, "COMPILER-47", new Object[0]);
                return;
            }
            if (fDefaults) {
                for (int iParam = 0; iParam < cAll; ++iParam) {
                    if (aconstArgs[iParam] != null) continue;
                    aconstArgs[iParam] = pool.valDefault();
                }
            }
            this.m_anno = anno.resolveParams(aconstArgs);
        }
    }

    @Override
    protected Expression validate(Context ctx, TypeConstant typeRequired, ErrorListener errs) {
        TypeConstant typeInferred;
        ConstantPool pool = this.pool();
        List<Expression> listArgs = this.args;
        int cArgs = listArgs == null ? 0 : listArgs.size();
        NamedTypeExpression exprTypeOld = this.toTypeExpression();
        NamedTypeExpression exprTypeNew = (NamedTypeExpression)exprTypeOld.validate(ctx, null, errs);
        if (exprTypeNew == null) {
            return null;
        }
        this.type = exprTypeNew;
        TypeConstant typeAnno = exprTypeNew.ensureTypeConstant(ctx, errs);
        ClassConstant idAnno = (ClassConstant)typeAnno.getDefiningConstant();
        if (typeRequired != null && (typeInferred = this.inferTypeFromRequired(typeAnno, typeRequired)) != null) {
            typeAnno = typeInferred;
        }
        if (idAnno.equals(pool.clzInject()) && cArgs == 0) {
            return this.finishValidation(ctx, typeRequired, typeAnno, Expression.TypeFit.Fit, null, errs);
        }
        if (typeRequired != null && !typeAnno.isA(typeRequired)) {
            this.log(errs, Severity.ERROR, "COMPILER-43", typeRequired.getValueString(), typeAnno.getValueString());
            return null;
        }
        TypeInfo infoAnno = typeAnno.ensureTypeInfo(errs);
        MethodConstant idConstruct = this.findMethod(ctx, typeAnno, infoAnno, "construct", listArgs, TypeInfo.MethodKind.Constructor, true, false, null, errs);
        if (idConstruct == null) {
            this.log(errs, Severity.ERROR, "COMPILER-65", idAnno.getValueString());
            return null;
        }
        if (cArgs > 0 && this.containsNamedArgs(listArgs)) {
            listArgs = this.rearrangeNamedArgs((MethodStructure)idConstruct.getComponent(), listArgs, errs);
            if (listArgs == null) {
                return null;
            }
            this.args = listArgs;
            cArgs = listArgs.size();
        }
        TypeConstant[] atypeParam = idConstruct.getRawParams();
        boolean fValid = true;
        boolean fConst = true;
        assert (atypeParam.length >= cArgs);
        for (int iArg = 0; iArg < cArgs; ++iArg) {
            Expression exprArgOld = listArgs.get(iArg);
            Expression exprArgNew = exprArgOld.validate(ctx, atypeParam[iArg], errs);
            if (exprArgNew == null) {
                fValid = false;
                continue;
            }
            if (exprArgNew != exprArgOld) {
                listArgs.set(iArg, exprArgNew);
            }
            fConst &= exprArgNew.isConstant();
        }
        if (fValid) {
            this.m_fConst = fConst;
            this.m_anno = null;
            Annotation anno = this.ensureAnnotation(pool);
            TypeConstant typeInto = anno.getAnnotationType().getExplicitClassInto();
            if (typeRequired != null) {
                typeInto = typeInto.resolveGenerics(pool, typeAnno);
            }
            typeAnno = pool.ensureAnnotatedTypeConstant(typeInto, anno);
            return this.finishValidation(ctx, typeRequired, typeAnno, Expression.TypeFit.Fit, null, errs);
        }
        return null;
    }

    @Override
    public String toString() {
        if (this.m_anno != null) {
            return this.m_anno.getValueString();
        }
        StringBuilder sb = new StringBuilder();
        sb.append('@').append(this.type);
        if (this.args != null) {
            sb.append('(');
            boolean first = true;
            for (Expression expr : this.args) {
                if (first) {
                    first = false;
                } else {
                    sb.append(", ");
                }
                sb.append(expr);
            }
            sb.append(')');
        }
        return sb.toString();
    }

    @Override
    public String getDumpDesc() {
        return this.toString();
    }

    protected class ValidatingContext
    extends Context {
        private final ClassStructure f_clzContainer;

        public ValidatingContext(ClassStructure clzContainer) {
            super(null, false);
            assert (clzContainer != null);
            this.f_clzContainer = clzContainer;
        }

        @Override
        public ClassStructure getThisClass() {
            return this.f_clzContainer;
        }

        @Override
        public MethodStructure getMethod() {
            return null;
        }

        @Override
        public Source getSource() {
            return AnnotationExpression.this.getSource();
        }

        @Override
        public ConstantPool pool() {
            return AnnotationExpression.this.pool();
        }

        @Override
        public Context enterFork(boolean fWhenTrue) {
            throw new IllegalStateException();
        }

        @Override
        public Context enter() {
            return this;
        }

        @Override
        public void registerVar(Token tokName, Register reg, ErrorListener errs) {
        }

        @Override
        public void unregisterVar(Token tokName) {
        }

        @Override
        public boolean isVarDeclaredInThisScope(String sName) {
            return false;
        }

        @Override
        public boolean isVarReadable(String sName) {
            return "this".equals(sName) && AnnotationExpression.this.hasThis();
        }

        @Override
        public boolean isVarWritable(String sName) {
            return false;
        }

        @Override
        protected Argument resolveRegularName(Context ctxFrom, String sName, Token name, ErrorListener errs) {
            return new NameResolver((AstNode)AnnotationExpression.this, sName).forceResolve(errs);
        }

        @Override
        protected Argument resolveReservedName(String sName, Token name, ErrorListener errs) {
            return "this:module".equals(sName) ? AnnotationExpression.this.getComponent().getIdentityConstant().getModuleConstant() : null;
        }

        @Override
        public Context exit() {
            return this;
        }

        @Override
        public boolean requireThis(long lPos, ErrorListener errs) {
            return AnnotationExpression.this.hasThis() || super.requireThis(lPos, errs);
        }

        @Override
        public TypeConstant getThisType() {
            PropertyStructure prop = AnnotationExpression.this.getAnnotatedProperty();
            return prop == null || prop.isStatic() ? null : prop.getContainingClass().getFormalType();
        }

        @Override
        public Map<String, Assignment> prepareJump(Context ctxDest) {
            return Collections.emptyMap();
        }
    }
}

