/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.compiler.ast;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.xvm.asm.Component;
import org.xvm.asm.ErrorListener;
import org.xvm.asm.constants.AnnotatedTypeConstant;
import org.xvm.asm.constants.IdentityConstant;
import org.xvm.asm.constants.TypeConstant;
import org.xvm.compiler.Token;
import org.xvm.compiler.ast.AnnotationExpression;
import org.xvm.compiler.ast.AstNode;
import org.xvm.compiler.ast.CompositionNode;
import org.xvm.compiler.ast.TypeExpression;
import org.xvm.util.Severity;

public class AnonInnerClass {
    private final TypeExpression m_exprType;
    private Component.Format m_fmt;
    private String m_sName;
    private List<AnnotationExpression> m_listAnnos;
    private List<CompositionNode> m_listCompositions;
    private boolean m_fError;
    private final ErrorListener f_errs;

    public AnonInnerClass(TypeExpression expr, ErrorListener errs) {
        assert (expr != null);
        assert (errs != null);
        this.m_exprType = expr;
        this.f_errs = errs;
    }

    public TypeExpression getTypeExpression() {
        return this.m_exprType;
    }

    public boolean isValid() {
        return !this.m_fError;
    }

    public Component.Format getFormat() {
        return this.m_fmt == null ? Component.Format.CLASS : this.m_fmt;
    }

    public Token getCategory() {
        TypeExpression location = this.getTypeExpression();
        return switch (this.getFormat()) {
            case Component.Format.CLASS -> this.genKeyword(location, Token.Id.CLASS);
            case Component.Format.CONST -> this.genKeyword(location, Token.Id.CONST);
            case Component.Format.SERVICE -> this.genKeyword(location, Token.Id.SERVICE);
            default -> throw new IllegalStateException();
        };
    }

    public String getDefaultName() {
        return this.m_sName == null ? "Object" : this.m_sName;
    }

    public List<CompositionNode> getCompositions() {
        return this.m_listCompositions == null ? Collections.emptyList() : this.m_listCompositions;
    }

    public List<AnnotationExpression> getAnnotations() {
        return this.m_listAnnos == null ? Collections.emptyList() : this.m_listAnnos;
    }

    protected ErrorListener getErrorListener(boolean fError) {
        if (fError) {
            this.markInvalid();
        }
        return this.f_errs;
    }

    private void logError(String sCode, Object ... aoParam) {
        this.getTypeExpression().log(this.getErrorListener(true), Severity.ERROR, sCode, aoParam);
    }

    private void markInvalid() {
        this.m_fError = true;
    }

    private void ensureMutable() {
        if (this.m_fmt == Component.Format.CONST) {
            this.logError("COMPILER-99", new Object[0]);
        }
    }

    protected void markImmutable() {
        if (this.m_fmt == Component.Format.SERVICE) {
            this.logError("COMPILER-99", new Object[0]);
        } else {
            this.m_fmt = Component.Format.CONST;
        }
    }

    protected void addAnnotation(AnnotationExpression anno) {
        assert (anno != null);
        this.ensureAnnotations().add(anno);
    }

    protected void addContribution(TypeExpression exprType) {
        TypeConstant type = exprType.ensureTypeConstant().resolveTypedefs();
        if (type.containsUnresolved()) {
            this.logError("COMPILER-38", type.getValueString());
        } else {
            this.addContribution(exprType, type);
        }
    }

    private void addContribution(TypeExpression exprType, TypeConstant type) {
        switch (type.getFormat()) {
            case ImmutableType: {
                this.addContribution(exprType, type.getUnderlyingType());
                this.markImmutable();
                return;
            }
            case AnnotatedType: {
                this.addContribution(exprType, type.getUnderlyingType());
                this.addAnnotation(new AnnotationExpression(((AnnotatedTypeConstant)type).getAnnotation(), exprType));
                return;
            }
            case IntersectionType: {
                this.addContribution(exprType, type.getUnderlyingType());
                this.addContribution(exprType, type.getUnderlyingType2());
                return;
            }
            case UnionType: {
                exprType.log(this.getErrorListener(true), Severity.ERROR, "COMPILER-100", new Object[0]);
                return;
            }
            case VirtualChildType: 
            case InnerChildType: {
                break;
            }
            case DifferenceType: 
            case AccessType: 
            case TerminalType: 
            case ParameterizedType: {
                break;
            }
            default: {
                throw new IllegalStateException("type=" + String.valueOf(type));
            }
        }
        if (type.isExplicitClassIdentity(true)) {
            switch (type.getExplicitClassFormat()) {
                case CLASS: {
                    this.setSuper(exprType, type);
                    this.m_fmt = Component.Format.CLASS;
                    return;
                }
                case ENUM: 
                case ENUMVALUE: 
                case PACKAGE: 
                case MODULE: {
                    exprType.log(this.getErrorListener(true), Severity.ERROR, "COMPILER-98", type.getExplicitClassFormat().toString().toLowerCase());
                }
                case CONST: {
                    this.setSuper(exprType, type);
                    this.markImmutable();
                    this.m_fmt = Component.Format.CONST;
                    return;
                }
                case SERVICE: {
                    this.ensureMutable();
                    this.setSuper(exprType, type);
                    this.m_fmt = Component.Format.SERVICE;
                    return;
                }
                case MIXIN: {
                    this.ensureCompositions().add(new CompositionNode.Incorporates(null, this.genKeyword(exprType, Token.Id.INCORPORATES), exprType, null, null));
                    return;
                }
                case INTERFACE: {
                    break;
                }
                default: {
                    throw new IllegalStateException("type=" + String.valueOf(type) + ", format=" + String.valueOf((Object)type.getExplicitClassFormat()));
                }
            }
        }
        if (this.m_sName == null) {
            this.m_sName = type.isExplicitClassIdentity(true) ? type.getSingleUnderlyingClass(true).getName() : type.getValueString().replace(" ", "");
        }
        this.ensureCompositions().add(new CompositionNode.Implements(null, this.genKeyword(exprType, Token.Id.IMPLEMENTS), exprType));
    }

    private List<AnnotationExpression> ensureAnnotations() {
        List<AnnotationExpression> list = this.m_listAnnos;
        if (list == null) {
            this.m_listAnnos = list = new ArrayList<AnnotationExpression>();
        }
        return list;
    }

    private Token genKeyword(AstNode location, Token.Id id) {
        long lPos = location.getStartPosition();
        return new Token(lPos, lPos, id);
    }

    private void setSuper(TypeExpression exprType, TypeConstant type) {
        CompositionNode compositionNode;
        assert (exprType != null);
        assert (type.isClassType());
        IdentityConstant idSuper = type.getSingleUnderlyingClass(false);
        this.m_sName = idSuper.getName();
        List<CompositionNode> list = this.ensureCompositions();
        if (!list.isEmpty() && (compositionNode = list.getFirst()) instanceof CompositionNode.Extends) {
            CompositionNode.Extends nodeFirst = (CompositionNode.Extends)compositionNode;
            this.getTypeExpression().log(this.getErrorListener(true), Severity.ERROR, "COMPILER-97", nodeFirst.getType().ensureTypeConstant().getValueString(), type.getValueString());
            return;
        }
        list.addFirst(new CompositionNode.Extends(null, this.genKeyword(exprType, Token.Id.EXTENDS), exprType));
    }

    private List<CompositionNode> ensureCompositions() {
        List<CompositionNode> list = this.m_listCompositions;
        if (list == null) {
            this.m_listCompositions = list = new ArrayList<CompositionNode>();
        }
        return list;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (!this.isValid()) {
            sb.append("**ERROR** ");
        }
        for (AnnotationExpression anno : this.getAnnotations()) {
            sb.append(anno).append(' ');
        }
        sb.append((Object)this.getFormat()).append(' ').append(this.getDefaultName());
        for (CompositionNode comp : this.getCompositions()) {
            sb.append(' ').append(comp);
        }
        return sb.toString();
    }
}

