/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.compiler.ast;

import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.xvm.asm.Argument;
import org.xvm.asm.Constant;
import org.xvm.asm.ConstantPool;
import org.xvm.asm.ErrorListener;
import org.xvm.asm.MethodStructure;
import org.xvm.asm.ast.ArrayAccessExprAST;
import org.xvm.asm.ast.ExprAST;
import org.xvm.asm.ast.InvokeExprAST;
import org.xvm.asm.constants.ArrayConstant;
import org.xvm.asm.constants.IntConstant;
import org.xvm.asm.constants.MapConstant;
import org.xvm.asm.constants.MethodConstant;
import org.xvm.asm.constants.MethodInfo;
import org.xvm.asm.constants.RangeConstant;
import org.xvm.asm.constants.SignatureConstant;
import org.xvm.asm.constants.TypeConstant;
import org.xvm.asm.constants.TypeInfo;
import org.xvm.asm.op.I_Get;
import org.xvm.asm.op.Invoke_11;
import org.xvm.asm.op.Invoke_N1;
import org.xvm.compiler.Token;
import org.xvm.compiler.ast.ArrayTypeExpression;
import org.xvm.compiler.ast.Context;
import org.xvm.compiler.ast.Expression;
import org.xvm.compiler.ast.LiteralExpression;
import org.xvm.compiler.ast.RelOpExpression;
import org.xvm.compiler.ast.TypeExpression;
import org.xvm.util.PackedInteger;
import org.xvm.util.Severity;

public class ArrayAccessExpression
extends Expression {
    protected Expression expr;
    protected List<Expression> indexes;
    protected Token tokClose;
    private transient MethodConstant m_idGet;
    private transient MethodConstant m_idSet;
    private transient boolean m_fSlice;
    private static final Field[] CHILD_FIELDS = ArrayAccessExpression.fieldsForNames(ArrayAccessExpression.class, "expr", "indexes");

    public ArrayAccessExpression(Expression expr, List<Expression> indexes, Token tokClose) {
        this.expr = expr;
        this.indexes = indexes;
        this.tokClose = tokClose;
    }

    @Override
    public TypeExpression toTypeExpression() {
        assert (this.tokClose.getId() == Token.Id.R_SQUARE);
        ArrayTypeExpression exprType = new ArrayTypeExpression(this.expr.toTypeExpression(), this.indexes, this.tokClose.getEndPosition());
        exprType.setParent(this.getParent());
        return exprType;
    }

    @Override
    public long getStartPosition() {
        return this.expr.getStartPosition();
    }

    @Override
    public long getEndPosition() {
        return this.tokClose.getEndPosition();
    }

    @Override
    protected Field[] getChildFields() {
        return CHILD_FIELDS;
    }

    boolean isSliceOp() {
        for (Expression index : this.indexes) {
            if (!(index instanceof RelOpExpression)) continue;
            RelOpExpression exprRel = (RelOpExpression)index;
            switch (exprRel.operator.getId()) {
                case I_RANGE_I: 
                case E_RANGE_I: 
                case I_RANGE_E: 
                case E_RANGE_E: {
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public boolean isLValueSyntax() {
        return !this.isSliceOp();
    }

    @Override
    public Expression getLValueExpression() {
        assert (this.isLValueSyntax());
        return this;
    }

    @Override
    public void updateLValueFromRValueTypes(Context ctx, Context.Branch branch, boolean fCond, TypeConstant[] aTypes) {
    }

    @Override
    public void resetLValueTypes(Context ctx) {
    }

    @Override
    public TypeConstant getImplicitType(Context ctx) {
        TypeConstant typeTarget;
        if (this.isValidated()) {
            return this.getType();
        }
        TypeConstant typeConstant = typeTarget = this.expr.isValidated() ? this.expr.getType() : this.expr.getImplicitType(ctx);
        if (typeTarget == null) {
            return null;
        }
        if (typeTarget.isTuple()) {
            return typeTarget.isParamsSpecified() || typeTarget.isFormalTypeSequence() ? this.determineTupleResultType(typeTarget) : null;
        }
        TypeInfo infoTarget = typeTarget.ensureTypeInfo();
        int cIndexes = this.indexes.size();
        Set<MethodConstant> setMethods = this.findPotentialOps(infoTarget, cIndexes);
        for (MethodConstant idMethod : setMethods) {
            TypeConstant[] atypeReturns;
            if (setMethods.size() != 1 && !this.indexesFit(ctx, idMethod) || (atypeReturns = idMethod.getRawReturns()).length < 1) continue;
            return idMethod.getRawReturns()[0];
        }
        return null;
    }

    @Override
    public Expression.TypeFit testFit(Context ctx, TypeConstant typeRequired, boolean fExhaustive, ErrorListener errs) {
        Expression.TypeFit fit = super.testFit(ctx, typeRequired, fExhaustive, errs);
        if (fit.isFit()) {
            return fit;
        }
        ConstantPool pool = this.pool();
        int cIndexes = this.indexes.size();
        TypeConstant typeTarget = this.expr.getImplicitType(ctx);
        if (typeTarget != null) {
            TypeInfo infoTarget = typeTarget.ensureTypeInfo();
            Set<MethodConstant> setMethods = this.findPotentialOps(infoTarget, cIndexes);
            for (MethodConstant idMethod : setMethods) {
                TypeConstant[] atypeReturns = idMethod.getRawReturns();
                if (atypeReturns.length < 1 || !this.indexesFit(ctx, idMethod) || !(fit = this.calcFit(ctx, atypeReturns[0], typeRequired)).isFit()) continue;
                return fit;
            }
        }
        switch (cIndexes) {
            default: {
                break;
            }
            case 1: {
                TypeConstant typeValue;
                if (typeTarget != null && typeTarget.isTuple() || this.expr.testFit(ctx, pool.typeTuple(), fExhaustive, null) == Expression.TypeFit.Fit) {
                    TypeConstant typeTest = this.determineTupleTestType(typeRequired);
                    return typeTest == null ? (pool.typeObject().isA(typeRequired) ? Expression.TypeFit.Fit : Expression.TypeFit.NoFit) : this.expr.testFit(ctx, typeTest, fExhaustive, errs);
                }
                Expression exprTarget = this.expr;
                Expression exprIndex = this.indexes.get(0);
                if (this.testType(ctx, exprTarget, typeTarget, pool.typeList())) {
                    if (!this.isSliceOp() && exprIndex.testFit(ctx, pool.typeInt64(), fExhaustive, null).isFit()) {
                        return exprTarget.testFit(ctx, pool.ensureParameterizedTypeConstant(pool.typeList(), typeRequired), fExhaustive, errs);
                    }
                    if (exprTarget.testFit(ctx, typeRequired, fExhaustive, errs) == Expression.TypeFit.Fit && exprIndex.testFit(ctx, pool.ensureRangeType(pool.typeInt64()), fExhaustive, null).isFit()) {
                        return Expression.TypeFit.Fit;
                    }
                } else {
                    TypeConstant typeIndex;
                    if (!this.isSliceOp() && this.testType(ctx, exprTarget, typeTarget, pool.typeIndexed()) && (typeIndex = this.estimateIndexType(ctx, typeTarget, "Index", exprIndex)) != null && (fit = exprTarget.testFit(ctx, pool.ensureParameterizedTypeConstant(pool.typeIndexed(), typeIndex, typeRequired), fExhaustive, errs)).isFit()) {
                        return fit;
                    }
                    if (this.testType(ctx, exprTarget, typeTarget, pool.typeSliceable()) && exprIndex.testFit(ctx, pool.typeRange(), fExhaustive, null).isFit() && (fit = exprTarget.testFit(ctx, typeRequired, fExhaustive, errs)).isFit()) {
                        return fit;
                    }
                }
                if (typeTarget == null || this.isSliceOp() || !this.testType(ctx, exprTarget, typeTarget, pool.typeMap()) || !(fit = this.calcFit(ctx, typeValue = typeTarget.resolveGenericType("Value"), typeRequired)).isFit() || !typeRequired.isA(pool.typeNullable())) break;
                return fit;
            }
            case 2: {
                if (!this.testType(ctx, this.expr, typeTarget, pool.typeMatrix())) break;
                Expression exprCol = this.indexes.get(0);
                Expression exprRow = this.indexes.get(1);
                if (exprCol.testFit(ctx, pool.typeInt64(), fExhaustive, null).isFit() && exprRow.testFit(ctx, pool.typeInt64(), fExhaustive, null).isFit()) {
                    return this.expr.testFit(ctx, pool.ensureParameterizedTypeConstant(pool.typeMatrix(), typeRequired), fExhaustive, errs);
                }
                TypeConstant typeInterval = pool.ensureRangeType(pool.typeInt64());
                if (!typeRequired.isA(pool.typeMatrix()) || !exprCol.testFit(ctx, typeInterval, fExhaustive, null).isFit() || !exprRow.testFit(ctx, typeInterval, fExhaustive, null).isFit()) break;
                TypeConstant typeElement = typeRequired.resolveGenericType("Element");
                return typeElement == null ? Expression.TypeFit.Fit : this.expr.testFit(ctx, pool.ensureParameterizedTypeConstant(pool.typeMatrix(), typeElement), fExhaustive, errs);
            }
        }
        return Expression.TypeFit.NoFit;
    }

    @Override
    protected Expression validate(Context ctx, TypeConstant typeRequired, ErrorListener errs) {
        TypeConstant typeField;
        Cloneable exprNew;
        ConstantPool pool = this.pool();
        Expression exprArray = this.expr;
        TypeConstant typeArray = exprArray.getImplicitType(ctx);
        TypeConstant typeArrayReq = null;
        int cIndexes = this.indexes.size();
        Expression[] aexprIndexes = this.indexes.toArray(new Expression[cIndexes]);
        if (typeArray != null && typeArray.isTuple() || typeArray == null && exprArray.testFit(ctx, pool.typeTuple(), false, null) == Expression.TypeFit.Fit) {
            if (typeArray == null) {
                typeArrayReq = pool.typeTuple();
            } else {
                TypeConstant typeTupleTest = this.determineTupleTestType(typeRequired);
                if (exprArray.testFit(ctx, typeTupleTest, false, null).isFit()) {
                    typeArrayReq = typeTupleTest;
                }
            }
        } else if (this.testType(ctx, exprArray, typeArray, pool.typeList()) && cIndexes == 1) {
            typeArrayReq = pool.typeList();
            if (typeRequired != null) {
                TypeConstant typeArrayTest;
                TypeConstant typeElement = null;
                if (!this.isSliceOp() && aexprIndexes[0].testFit(ctx, pool.typeInt64(), false, null).isFit()) {
                    typeElement = typeRequired;
                } else if (typeRequired.isA(pool.typeList()) && aexprIndexes[0].testFit(ctx, pool.ensureRangeType(pool.typeInt64()), false, null).isFit()) {
                    typeElement = typeRequired.resolveGenericType("Element");
                }
                if (typeElement != null && exprArray.testFit(ctx, typeArrayTest = pool.ensureParameterizedTypeConstant(typeArrayReq, typeElement), false, null).isFit()) {
                    typeArrayReq = typeArrayTest;
                }
            }
        } else if (this.testType(ctx, exprArray, typeArray, pool.typeIndexed()) && cIndexes == 1) {
            TypeConstant typeIndex;
            typeArrayReq = pool.typeIndexed();
            TypeConstant typeConstant = typeIndex = typeArray == null ? null : typeArray.resolveGenericType("Index");
            if (typeIndex == null || !aexprIndexes[0].testFit(ctx, typeIndex, false, null).isFit()) {
                typeIndex = aexprIndexes[0].getImplicitType(ctx);
                typeIndex = this.determineIndexType(ctx, exprArray, typeArray, aexprIndexes, typeIndex);
            }
            if (typeIndex != null) {
                TypeConstant typeArrayTest;
                TypeConstant typeTest;
                TypeConstant typeElement = null;
                if (typeRequired != null && exprArray.testFit(ctx, typeTest = pool.ensureParameterizedTypeConstant(pool.typeIndexed(), typeIndex, typeRequired), false, null).isFit()) {
                    typeElement = typeRequired;
                    typeArrayReq = typeTest;
                }
                if (typeElement == null && exprArray.testFit(ctx, typeArrayTest = pool.ensureParameterizedTypeConstant(typeArrayReq, typeIndex), false, null).isFit()) {
                    typeArrayReq = typeArrayTest;
                }
            }
        } else if (this.testType(ctx, this.expr, typeArray, pool.typeMatrix()) && cIndexes == 2) {
            typeArrayReq = pool.typeMatrix();
            if (typeRequired != null) {
                TypeConstant typeArrayTest;
                TypeConstant typeIntInterval;
                Expression exprCol = aexprIndexes[0];
                Expression exprRow = aexprIndexes[1];
                TypeConstant typeElement = null;
                if (exprCol.testFit(ctx, pool.typeInt64(), false, null).isFit() && exprRow.testFit(ctx, pool.typeInt64(), false, null).isFit()) {
                    typeElement = typeRequired;
                } else if (typeRequired.isA(pool.typeInterval()) && exprCol.testFit(ctx, typeIntInterval = pool.ensureRangeType(pool.typeInt64()), false, null).isFit() && exprRow.testFit(ctx, typeIntInterval, false, null).isFit()) {
                    typeElement = typeRequired.resolveGenericType("Element");
                }
                if (typeElement != null && exprArray.testFit(ctx, typeArrayTest = pool.ensureParameterizedTypeConstant(typeArrayReq, typeRequired), false, null).isFit()) {
                    typeArrayReq = typeArrayTest;
                }
            }
        }
        boolean fValid = true;
        TypeConstant[] aIndexTypes = null;
        TypeConstant typeResult = null;
        boolean fSlice = false;
        Expression exprArrayNew = exprArray.validate(ctx, typeArrayReq, errs);
        if (exprArrayNew == null) {
            fValid = false;
        } else {
            MethodConstant idGet;
            if (exprArrayNew != exprArray) {
                this.expr = exprArray = exprArrayNew;
            }
            if ((idGet = this.findArrayAccessor(ctx, typeArray = exprArray.getType(), aexprIndexes, typeRequired)) == null) {
                this.log(errs, Severity.ERROR, "COMPILER-68", "[]", typeArray.getValueString(), cIndexes);
                fValid = false;
            } else {
                TypeInfo infoArray = typeArray.ensureTypeInfo();
                MethodInfo infoGet = infoArray.getMethodById(idGet);
                assert (infoGet != null);
                if (!infoGet.isOp("getElement", "[]", -1)) {
                    fSlice = true;
                    this.m_fSlice = true;
                }
                aIndexTypes = idGet.getRawParams();
                typeResult = idGet.getRawReturns()[0].resolveAutoNarrowing(pool, true, typeArray, null);
                this.m_idGet = idGet;
            }
        }
        for (int i = 0; i < cIndexes; ++i) {
            Expression exprOld = aexprIndexes[i];
            exprNew = exprOld.validate(ctx, (TypeConstant)(aIndexTypes == null ? null : aIndexTypes[i]), errs);
            if (exprNew == null) {
                fValid = false;
                continue;
            }
            if (exprNew == exprOld) continue;
            aexprIndexes[i] = exprNew;
            this.indexes.set(i, (Expression)exprNew);
        }
        if (!fValid) {
            if (typeResult == null) {
                typeResult = typeRequired == null ? this.pool().typeObject() : typeRequired;
            }
            return this.finishValidation(ctx, typeRequired, typeResult, Expression.TypeFit.NoFit, null, errs);
        }
        if (!fSlice) {
            Expression[] aExprSet = new Expression[cIndexes + 1];
            System.arraycopy(aexprIndexes, 0, aExprSet, 0, cIndexes);
            this.m_idSet = this.findOpMethod(ctx, typeArray, "setElement", "[]=", aExprSet, null, ErrorListener.BLACKHOLE);
        }
        if (typeArray.isTuple() && aexprIndexes[0].isConstant() && (typeField = this.determineTupleResultType(typeArray)) != null) {
            typeResult = typeField;
        }
        Constant constVal = null;
        exprNew = exprArray.toConstant();
        if (exprNew instanceof ArrayConstant) {
            ArrayConstant constArray = (ArrayConstant)exprNew;
            if (aexprIndexes[0].isConstant() && (cIndexes == 1 || aexprIndexes[1].isConstant())) {
                if (typeArray.isTuple() || typeArray.isA(pool.typeList()) && cIndexes == 1) {
                    Constant constIndex = aexprIndexes[0].toConstant();
                    if (fSlice) {
                        if (constIndex instanceof RangeConstant) {
                            RangeConstant constRange = (RangeConstant)constIndex;
                            constVal = this.evalConst(constArray, constRange, typeResult, errs);
                        }
                    } else if ((constIndex = this.validateAndConvertConstant(constIndex, pool.typeInt64(), errs)) instanceof IntConstant) {
                        IntConstant constInt = (IntConstant)constIndex;
                        constVal = this.evalConst(constArray, constInt, errs);
                    }
                } else if (typeArray.isA(pool.typeIndexed())) {
                    Constant constInt;
                    if (!fSlice && typeArray.isA(pool.typeMap()) && (constInt = exprArray.toConstant()) instanceof MapConstant) {
                        MapConstant constMap = (MapConstant)constInt;
                        Constant constKey = aexprIndexes[0].toConstant();
                        constVal = (Constant)constMap.getValue().get(constKey);
                    }
                } else if (!typeArray.isA(pool.typeMatrix()) || fSlice) {
                    // empty if block
                }
            }
        }
        return this.finishValidation(ctx, typeRequired, typeResult, Expression.TypeFit.Fit, constVal, errs);
    }

    @Override
    public boolean isCompletable() {
        for (Expression index : this.indexes) {
            if (index.isCompletable()) continue;
            return false;
        }
        return this.expr.isCompletable();
    }

    @Override
    public boolean isShortCircuiting() {
        for (Expression index : this.indexes) {
            if (!index.isShortCircuiting()) continue;
            return true;
        }
        return this.expr.isShortCircuiting();
    }

    @Override
    public boolean isAssignable(Context ctx) {
        assert (this.isValidated());
        return this.m_idSet != null;
    }

    @Override
    public void generateAssignment(Context ctx, MethodStructure.Code code, Expression.Assignable LVal, ErrorListener errs) {
        if (this.isConstant()) {
            LVal.assign(this.toConstant(), code, errs);
        } else {
            Argument argResult = LVal.isLocalArgument() ? LVal.getLocalArgument() : this.createTempVar(code, this.getType(), true).getRegister();
            Argument argArray = this.expr.generateArgument(ctx, code, true, !this.m_fSlice, errs);
            List<Expression> listIndexExprs = this.indexes;
            int cIndexes = listIndexExprs.size();
            if (cIndexes == 1) {
                Argument argIndex = listIndexExprs.get(0).generateArgument(ctx, code, true, true, errs);
                if (this.m_fSlice) {
                    code.add(new Invoke_11(argArray, this.m_idGet, argIndex, argResult));
                } else {
                    code.add(new I_Get(argArray, argIndex, argResult));
                }
            } else {
                Argument[] aIndexArgs = new Argument[cIndexes];
                for (int i = 0; i < cIndexes; ++i) {
                    Expression expr = listIndexExprs.get(i);
                    Argument arg = expr.generateArgument(ctx, code, true, true, errs);
                    aIndexArgs[i] = expr.ensurePointInTime(code, arg, listIndexExprs, i);
                }
                if (this.m_idGet == null) {
                    throw this.notImplemented();
                }
                code.add(new Invoke_N1(argArray, this.m_idGet, aIndexArgs, argResult));
            }
            if (!LVal.isLocalArgument()) {
                LVal.assign(argResult, code, errs);
            }
        }
    }

    @Override
    public Expression.Assignable generateAssignable(Context ctx, MethodStructure.Code code, ErrorListener errs) {
        Argument argArray = this.expr.generateArgument(ctx, code, true, true, errs);
        List<Expression> listIndex = this.indexes;
        int cIndexes = listIndex.size();
        if (cIndexes == 1) {
            Argument argIndex = listIndex.get(0).generateArgument(ctx, code, true, false, errs);
            return new Expression.Assignable((Expression)this, argArray, argIndex);
        }
        Argument[] aArgIndexes = new Argument[cIndexes];
        for (int i = 0; i < cIndexes; ++i) {
            Expression expr = listIndex.get(i);
            Argument arg = expr.generateArgument(ctx, code, true, false, errs);
            aArgIndexes[i] = expr.ensurePointInTime(code, arg, listIndex, i);
        }
        return new Expression.Assignable((Expression)this, argArray, aArgIndexes);
    }

    @Override
    public ExprAST getExprAST(Context ctx) {
        int cIndexes = this.indexes.size();
        if (cIndexes == 1) {
            ExprAST astArray = this.expr.getExprAST(ctx);
            ExprAST astArg = this.indexes.get(0).getExprAST(ctx);
            return this.m_fSlice ? new InvokeExprAST(this.m_idGet, this.getTypes(), astArray, new ExprAST[]{astArg}, false) : new ArrayAccessExprAST(astArray, astArg);
        }
        if (this.m_idGet == null) {
            throw this.notImplemented();
        }
        ExprAST[] astArgs = new ExprAST[cIndexes];
        for (int i = 0; i < cIndexes; ++i) {
            astArgs[i] = this.indexes.get(i).getExprAST(ctx);
        }
        return new InvokeExprAST(this.m_idGet, this.getTypes(), this.expr.getExprAST(ctx), astArgs, false);
    }

    private MethodConstant findArrayAccessor(Context ctx, TypeConstant typeTarget, Expression[] aexprArgs, TypeConstant typeReturn) {
        int cArgs = aexprArgs.length;
        TypeConstant[] atypeArgs = new TypeConstant[cArgs];
        for (int i = 0; i < cArgs; ++i) {
            Expression exprArg = aexprArgs[i];
            atypeArgs[i] = exprArg.isValidated() ? exprArg.getType() : exprArg.getImplicitType(ctx);
        }
        TypeInfo infoTarget = typeTarget.ensureTypeInfo();
        boolean fTuple = typeTarget.isTuple();
        HashSet<MethodConstant> setMatch = new HashSet<MethodConstant>();
        HashMap<MethodConstant, MethodStructure> mapMethods = new HashMap<MethodConstant, MethodStructure>();
        Set<MethodConstant> setAll = this.findPotentialOps(infoTarget, cArgs);
        block5: for (MethodConstant idMethod : setAll) {
            MethodInfo infoNarrowing;
            TypeConstant[] atypeParams;
            int cParams;
            SignatureConstant sig = idMethod.getSignature();
            if (sig.containsAutoNarrowing(false)) {
                sig = sig.resolveAutoNarrowing(this.pool(), typeTarget, null);
            }
            if (!fTuple && typeReturn != null && (sig.getRawReturns().length < 1 || !this.isAssignable(ctx, sig.getRawReturns()[0], typeReturn)) || (cParams = (atypeParams = sig.getRawParams()).length) < cArgs) continue;
            MethodInfo info = infoTarget.getMethodById(idMethod);
            MethodStructure method = info.getTopmostMethodStructure(infoTarget);
            if (cParams > cArgs && cParams - cArgs < method.getDefaultParamCount()) continue;
            for (int i = 0; i < cArgs; ++i) {
                Expression exprArg;
                TypeConstant typeParam = atypeParams[i];
                TypeConstant typeArg = atypeArgs[i];
                if ((typeArg == null || !this.isAssignable(ctx, typeArg, typeParam)) && !(exprArg = aexprArgs[i]).testFit(ctx, typeParam, false, null).isFit()) continue block5;
            }
            if (info.isCapped() && (infoNarrowing = infoTarget.getNarrowingMethod(info)).isOp()) {
                setMatch.add(infoTarget.resolveMethodConstant(infoNarrowing));
                continue;
            }
            setMatch.add(idMethod);
            mapMethods.put(idMethod, method);
        }
        return switch (setMatch.size()) {
            case 0 -> null;
            case 1 -> (MethodConstant)setMatch.iterator().next();
            default -> this.chooseBest(setMatch, typeTarget, mapMethods, ErrorListener.BLACKHOLE);
        };
    }

    private Set<MethodConstant> findPotentialOps(TypeInfo infoTarget, int cArgs) {
        Set<MethodConstant> setGet = infoTarget.findOpMethods("getElement", "[]", cArgs);
        Set<MethodConstant> setSlice = infoTarget.findOpMethods("slice", "[..]", cArgs);
        if (setGet.isEmpty()) {
            return setSlice;
        }
        if (setSlice.isEmpty()) {
            return setGet;
        }
        HashSet<MethodConstant> setUnion = new HashSet<MethodConstant>();
        setUnion.addAll(setGet);
        setUnion.addAll(setSlice);
        return setUnion;
    }

    private MethodConstant findOpMethod(Context ctx, TypeConstant typeTarget, String sMethodName, String sOp, Expression[] aexprArgs, TypeConstant typeReturn, ErrorListener errs) {
        int cParams;
        assert (sMethodName != null && !sMethodName.isEmpty());
        assert (sOp != null && !sOp.isEmpty());
        TypeInfo infoTarget = typeTarget.ensureTypeInfo(errs);
        Set<MethodConstant> setMethods = infoTarget.findOpMethods(sMethodName, sOp, cParams = aexprArgs == null ? -1 : aexprArgs.length);
        if (setMethods.isEmpty()) {
            if (cParams < 0 || infoTarget.findOpMethods(sMethodName, sOp, -1).isEmpty()) {
                this.log(errs, Severity.ERROR, "COMPILER-67", sOp, typeTarget.getValueString());
            } else {
                this.log(errs, Severity.ERROR, "COMPILER-68", sOp, typeTarget.getValueString(), cParams);
            }
            return null;
        }
        TypeConstant[] atypeParams = null;
        if (cParams > 0) {
            atypeParams = new TypeConstant[cParams];
            for (int i = 0; i < cParams; ++i) {
                Expression exprParam = aexprArgs[i];
                if (exprParam == null) continue;
                atypeParams[i] = exprParam.isValidated() ? exprParam.getType() : exprParam.getImplicitType(ctx);
            }
        }
        MethodConstant idBest = null;
        block1: for (MethodConstant idOp : setMethods) {
            boolean fNewBetter;
            TypeConstant[] atypeOpReturns;
            if (cParams > 0) {
                TypeConstant[] atypeOpParams = idOp.getRawParams();
                int cOpParams = atypeOpParams.length;
                if (cParams != cOpParams) continue;
                for (int i = 0; i < cParams; ++i) {
                    if (atypeParams[i] != null && !this.isAssignable(ctx, atypeParams[i], atypeOpParams[i])) continue block1;
                }
            }
            if (typeReturn != null && ((atypeOpReturns = idOp.getRawReturns()).length == 0 || this.isAssignable(ctx, atypeOpReturns[0], typeReturn))) continue;
            if (idBest == null) {
                idBest = idOp;
                continue;
            }
            boolean fOldBetter = idOp.getSignature().isSubstitutableFor(idBest.getSignature(), typeTarget);
            if (fOldBetter ^ (fNewBetter = idBest.getSignature().isSubstitutableFor(idOp.getSignature(), typeTarget))) {
                if (!fNewBetter) continue;
                idBest = idOp;
                continue;
            }
            this.log(errs, Severity.ERROR, "COMPILER-69", sOp, typeTarget.getValueString());
            return null;
        }
        if (idBest == null) {
            this.log(errs, Severity.ERROR, "COMPILER-68", sOp, typeTarget.getValueString(), cParams);
        }
        return idBest;
    }

    private boolean indexesFit(Context ctx, MethodConstant method) {
        TypeConstant[] atypes;
        int cTypes;
        if (method.getRawReturns().length > 0 && (cTypes = (atypes = method.getRawParams()).length) == this.indexes.size()) {
            for (int i = 0; i < cTypes; ++i) {
                if (this.indexes.get(i).testFit(ctx, atypes[i], false, null).isFit()) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private TypeConstant determineTupleResultType(TypeConstant typeTuple) {
        boolean fReverse;
        int nHi;
        int nLo;
        RangeConstant range;
        int nIndex;
        Constant constIndex = this.extractArrayIndex(this.indexes.get(0));
        if (typeTuple == null || constIndex == null) {
            return null;
        }
        ConstantPool pool = this.pool();
        if (typeTuple.isFormalTypeSequence()) {
            return pool.typeType();
        }
        try {
            Constant constInt = constIndex.convertTo(pool.typeInt64());
            nIndex = constInt == null ? -1 : constInt.getIntValue().getInt();
        }
        catch (RuntimeException e) {
            nIndex = -1;
        }
        List<TypeConstant> listFields = typeTuple.getTupleParamTypes();
        if (nIndex >= 0) {
            return nIndex >= 0 && nIndex < listFields.size() ? listFields.get(nIndex) : null;
        }
        try {
            range = (RangeConstant)constIndex.convertTo(pool.typeInterval());
            nLo = range.getFirst().convertTo(pool.typeInt64()).getIntValue().getInt();
            nHi = range.getLast().convertTo(pool.typeInt64()).getIntValue().getInt();
        }
        catch (RuntimeException e) {
            return null;
        }
        boolean bl = fReverse = nLo > nHi;
        if (range.isFirstExcluded()) {
            int n = nLo = fReverse ? nLo - 1 : nLo + 1;
        }
        if (range.isLastExcluded()) {
            nHi = fReverse ? nHi + 1 : nHi - 1;
        }
        int cFields = listFields.size();
        if (nLo < 0 || nLo >= cFields || nHi < 0 || nHi >= cFields) {
            return null;
        }
        int cSlice = Math.max(0, fReverse ? nLo - nHi + 1 : nHi - nLo + 1);
        TypeConstant[] atypeSlice = new TypeConstant[cSlice];
        int cStep = fReverse ? -1 : 1;
        int iSrc = nLo;
        int iDest = 0;
        while (iDest < cSlice) {
            atypeSlice[iDest] = listFields.get(iSrc);
            ++iDest;
            iSrc += cStep;
        }
        return pool.ensureTupleType(atypeSlice);
    }

    private TypeConstant determineTupleTestType(TypeConstant typeRequired) {
        boolean fReverse;
        boolean fSlice;
        int nHi;
        int nLo;
        Constant index = this.extractArrayIndex(this.indexes.get(0));
        if (typeRequired == null || index == null) {
            return null;
        }
        ConstantPool pool = this.pool();
        try {
            if (index instanceof RangeConstant) {
                RangeConstant interval = (RangeConstant)index;
                nLo = interval.getEffectiveFirst().convertTo(pool.typeInt64()).getIntValue().getInt();
                nHi = interval.getEffectiveLast().convertTo(pool.typeInt64()).getIntValue().getInt();
                fSlice = true;
                fReverse = interval.isReverse();
                if (fReverse) {
                    int nTemp = nLo;
                    nLo = nHi;
                    nHi = nTemp;
                }
                assert (nLo <= nHi);
            } else {
                nLo = nHi = index.convertTo(pool.typeInt64()).getIntValue().getInt();
                fSlice = false;
                fReverse = false;
            }
        }
        catch (RuntimeException e) {
            return null;
        }
        if (nLo < 0 || nHi < 0 || nLo > 255 || nHi > 255 || fSlice && !typeRequired.isTuple()) {
            return null;
        }
        Object[] atypeFields = new TypeConstant[nHi + 1];
        Arrays.fill(atypeFields, pool.typeObject());
        if (fSlice) {
            int cStep;
            int cElements = nHi - nLo + 1;
            if (cElements <= 0) {
                return null;
            }
            TypeConstant[] atypeReq = typeRequired.getParamTypesArray();
            int cReq = atypeReq.length;
            if (cReq > cElements) {
                return null;
            }
            int iSrc = 0;
            int iDest = fReverse ? nHi : nLo;
            int n = cStep = fReverse ? -1 : 1;
            while (iSrc < cReq) {
                atypeFields[iDest] = atypeReq[iSrc];
                ++iSrc;
                iDest += cStep;
            }
        } else if (typeRequired != null) {
            atypeFields[nLo] = typeRequired;
        }
        return pool.ensureTupleType((TypeConstant[])atypeFields);
    }

    private Constant extractArrayIndex(Expression exprIndex) {
        if (exprIndex.isConstant()) {
            ConstantPool pool = this.pool();
            Constant constRaw = exprIndex.toConstant();
            Constant constIndex = this.convertConstant(constRaw, pool.typeInt64());
            return constIndex == null ? this.convertConstant(constRaw, pool.ensureRangeType(pool.typeInt64())) : constIndex;
        }
        if (exprIndex instanceof LiteralExpression) {
            return this.fromLiteral(exprIndex);
        }
        if (exprIndex instanceof RelOpExpression) {
            RelOpExpression exprInterval = (RelOpExpression)exprIndex;
            boolean slice = false;
            boolean fExLo = false;
            boolean fExHi = false;
            switch (exprInterval.operator.getId()) {
                case I_RANGE_I: {
                    slice = true;
                    break;
                }
                case E_RANGE_I: {
                    slice = true;
                    fExLo = true;
                    break;
                }
                case I_RANGE_E: {
                    slice = true;
                    fExHi = true;
                    break;
                }
                case E_RANGE_E: {
                    slice = true;
                    fExLo = true;
                    fExHi = true;
                }
            }
            if (slice) {
                IntConstant constLo = this.fromLiteral(exprInterval.getExpression1());
                IntConstant constHi = this.fromLiteral(exprInterval.getExpression2());
                if (constLo != null && constHi != null) {
                    return this.pool().ensureRangeConstant(constLo, fExLo, constHi, fExHi);
                }
            }
        }
        return null;
    }

    private IntConstant fromLiteral(Expression expr) {
        if (expr instanceof LiteralExpression) {
            LiteralExpression exprLit = (LiteralExpression)expr;
            Constant constLit = exprLit.getLiteralConstant();
            try {
                return (IntConstant)constLit.convertTo(this.pool().typeInt64());
            }
            catch (ArithmeticException arithmeticException) {
                // empty catch block
            }
        }
        return null;
    }

    TypeConstant estimateIndexType(Context ctx, TypeConstant typeTarget, String sIndexParam, Expression exprIndex) {
        TypeConstant typeIndex;
        TypeConstant typeConstant = typeIndex = typeTarget == null ? null : typeTarget.resolveGenericType(sIndexParam);
        if (typeIndex == null || !exprIndex.testFit(ctx, typeIndex, false, null).isFit()) {
            typeIndex = exprIndex.getImplicitType(ctx);
        }
        return typeIndex;
    }

    private TypeConstant determineIndexType(Context ctx, Expression exprArray, TypeConstant typeArray, Expression[] aexprIndexes, TypeConstant typeIndex) {
        ConstantPool pool = this.pool();
        if (typeIndex == null) {
            MethodConstant id;
            if (typeArray != null && (id = this.findOpMethod(ctx, typeArray, "getElement", "[]", aexprIndexes, null, ErrorListener.BLACKHOLE)) != null && id.getRawReturns().length >= 1) {
                typeIndex = id.getRawReturns()[0];
                if (!pool.typeObject().isA(typeIndex)) {
                    return typeIndex;
                }
            }
            return null;
        }
        if (exprArray.testFit(ctx, pool.ensureParameterizedTypeConstant(pool.typeIndexed(), typeIndex), false, null).isFit()) {
            return typeIndex;
        }
        Set<MethodInfo> setInfos = typeIndex.ensureTypeInfo().getAutoMethodInfos();
        for (MethodInfo info : setInfos) {
            typeIndex = info.getSignature().getRawReturns()[0];
            if (!exprArray.testFit(ctx, pool.ensureParameterizedTypeConstant(pool.typeIndexed(), typeIndex), false, null).isFit()) continue;
            return typeIndex;
        }
        return null;
    }

    private boolean testType(Context ctx, Expression expr, TypeConstant typeExpr, TypeConstant typeTest) {
        if (typeExpr != null && typeExpr.isA(typeTest)) {
            return true;
        }
        return expr.testFit(ctx, typeTest, false, null) == Expression.TypeFit.Fit;
    }

    private Constant evalConst(ArrayConstant constArray, IntConstant constIndex, ErrorListener errs) {
        Constant[] aconstVals = constArray.getValue();
        int cVals = aconstVals.length;
        PackedInteger piIndex = constIndex.getValue();
        if (piIndex.checkRange(0L, cVals - 1)) {
            return aconstVals[piIndex.getInt()];
        }
        this.log(errs, Severity.ERROR, "COMPILER-95", piIndex, 0, cVals - 1);
        return null;
    }

    private Constant evalConst(ArrayConstant constArray, RangeConstant constIndex, TypeConstant typeResult, ErrorListener errs) {
        Constant[] aOldVals = constArray.getValue();
        int cOldVals = aOldVals.length;
        PackedInteger piIndex1 = constIndex.getEffectiveFirst().getIntValue();
        PackedInteger piIndex2 = constIndex.getEffectiveLast().getIntValue();
        if (piIndex1.checkRange(0L, cOldVals - 1) && piIndex2.checkRange(0L, cOldVals - 1)) {
            int cNewVals = (int)constIndex.size();
            Constant[] aNewVals = new Constant[cNewVals];
            if (cNewVals > 0) {
                int nLast;
                int nFirst = piIndex1.getInt();
                int nStep = nFirst <= (nLast = piIndex2.getInt()) ? 1 : -1;
                int iNew = 0;
                int iOld = nFirst;
                while (iNew < cNewVals) {
                    aNewVals[iNew] = aOldVals[iOld];
                    ++iNew;
                    iOld += nStep;
                }
            }
            ConstantPool pool = this.pool();
            return typeResult.isTuple() ? pool.ensureTupleConstant(typeResult, aNewVals) : pool.ensureArrayConstant(typeResult, aNewVals);
        }
        PackedInteger piIndex = piIndex1.checkRange(0L, cOldVals - 1) ? piIndex2 : piIndex1;
        this.log(errs, Severity.ERROR, "COMPILER-95", piIndex, 0, cOldVals - 1);
        return null;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.expr).append('[');
        boolean first = true;
        for (Expression index : this.indexes) {
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            sb.append(index);
        }
        sb.append(this.tokClose.getId().TEXT);
        return sb.toString();
    }

    @Override
    public String getDumpDesc() {
        return this.toString();
    }
}

