/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.compiler.ast;

import java.lang.reflect.Field;
import java.util.List;
import org.xvm.asm.ClassStructure;
import org.xvm.asm.ConstantPool;
import org.xvm.asm.ErrorListener;
import org.xvm.asm.constants.ClassConstant;
import org.xvm.asm.constants.MethodConstant;
import org.xvm.asm.constants.TypeConstant;
import org.xvm.compiler.ast.AnonInnerClass;
import org.xvm.compiler.ast.Context;
import org.xvm.compiler.ast.Expression;
import org.xvm.compiler.ast.TypeExpression;

public class ArrayTypeExpression
extends TypeExpression {
    protected TypeExpression type;
    protected int dims;
    protected List<Expression> indexes;
    protected long lEndPos;
    private static final Field[] CHILD_FIELDS = ArrayTypeExpression.fieldsForNames(ArrayTypeExpression.class, "type", "indexes");

    public ArrayTypeExpression(TypeExpression type, int dims, long lEndPos) {
        this(type, dims, null, lEndPos);
    }

    public ArrayTypeExpression(TypeExpression type, List<Expression> indexes, long lEndPos) {
        this(type, indexes.size(), indexes, lEndPos);
    }

    private ArrayTypeExpression(TypeExpression type, int dims, List<Expression> indexes, long lEndPos) {
        this.type = type;
        this.dims = dims;
        this.indexes = indexes;
        this.lEndPos = lEndPos;
    }

    public int getDimensions() {
        return this.dims;
    }

    @Override
    protected boolean canResolveNames() {
        return super.canResolveNames() || this.type.canResolveNames();
    }

    @Override
    public long getStartPosition() {
        return this.type.getStartPosition();
    }

    @Override
    public long getEndPosition() {
        return this.lEndPos;
    }

    @Override
    protected Field[] getChildFields() {
        return CHILD_FIELDS;
    }

    @Override
    public Expression.TypeFit testFit(Context ctx, TypeConstant typeRequired, boolean fExhaustive, ErrorListener errs) {
        TypeConstant typeEl = this.type.ensureTypeConstant(ctx, errs);
        return typeEl.containsUnresolved() ? Expression.TypeFit.NoFit : super.testFit(ctx, typeRequired, fExhaustive, errs);
    }

    @Override
    protected Expression validate(Context ctx, TypeConstant typeRequired, ErrorListener errs) {
        TypeExpression exprTypeOld = this.type;
        TypeExpression exprTypeNew = (TypeExpression)exprTypeOld.validate(ctx, this.pool().typeType(), errs);
        if (exprTypeNew == null) {
            return null;
        }
        this.type = exprTypeNew;
        return super.validate(ctx, typeRequired, errs);
    }

    public MethodConstant getSupplyConstructor() {
        ClassConstant idArray = this.pool().clzArray();
        ClassStructure clzArray = (ClassStructure)idArray.getComponent();
        return clzArray.findMethod("construct", 2, this.pool().typeInt64()).getIdentityConstant();
    }

    @Override
    protected TypeConstant instantiateTypeConstant(Context ctx, ErrorListener errs) {
        ConstantPool pool = this.pool();
        return pool.ensureClassTypeConstant(pool.clzArray(), null, this.type.ensureTypeConstant(ctx, errs));
    }

    @Override
    protected void collectAnonInnerClassInfo(AnonInnerClass info) {
        info.addContribution(this);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.type).append('[');
        for (int i = 0; i < this.dims; ++i) {
            if (i > 0) {
                sb.append(',');
            }
            if (this.indexes == null) {
                sb.append('?');
                continue;
            }
            sb.append(this.indexes.get(i));
        }
        sb.append(']');
        return sb.toString();
    }

    @Override
    public String getDumpDesc() {
        return this.toString();
    }
}

