/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.compiler.ast;

import org.xvm.asm.Argument;
import org.xvm.asm.Constant;
import org.xvm.asm.ErrorListener;
import org.xvm.asm.MethodStructure;
import org.xvm.asm.Register;
import org.xvm.asm.ast.BiExprAST;
import org.xvm.asm.ast.ExprAST;
import org.xvm.asm.ast.RelOpExprAST;
import org.xvm.asm.constants.CastTypeConstant;
import org.xvm.asm.constants.TypeConstant;
import org.xvm.asm.op.Move;
import org.xvm.asm.op.MoveCast;
import org.xvm.compiler.Token;
import org.xvm.compiler.ast.BiExpression;
import org.xvm.compiler.ast.Context;
import org.xvm.compiler.ast.Expression;
import org.xvm.compiler.ast.TypeExpression;

public class AsExpression
extends BiExpression {
    protected long lEndPos;
    private transient boolean m_fCastRequired = true;

    public AsExpression(Expression expr1, Token operator, TypeExpression expr2, Token tokClose) {
        super(expr1, operator, expr2);
        this.lEndPos = tokClose.getEndPosition();
    }

    @Override
    public long getEndPosition() {
        return this.lEndPos;
    }

    @Override
    public TypeConstant getImplicitType(Context ctx) {
        return ((TypeExpression)this.expr2).ensureTypeConstant(ctx, null);
    }

    @Override
    protected Expression.TypeFit calcFit(Context ctx, TypeConstant typeIn, TypeConstant typeOut) {
        if (typeIn.containsUnresolved()) {
            return Expression.TypeFit.NoFit;
        }
        return super.calcFit(ctx, typeIn, typeOut);
    }

    @Override
    protected Expression validate(Context ctx, TypeConstant typeRequired, ErrorListener errs) {
        Expression exprTarget;
        TypeExpression exprType = (TypeExpression)this.expr2.validate(ctx, this.pool().typeType(), errs);
        if (exprType == null) {
            return null;
        }
        TypeConstant typeRequest = null;
        TypeConstant type = exprType.ensureTypeConstant(ctx, errs).resolveAutoNarrowingBase();
        if (!exprType.isDynamic() && this.expr1.testFit(ctx, type, false, null).isFit()) {
            typeRequest = type;
            this.m_fCastRequired = false;
        }
        if ((exprTarget = this.expr1.validate(ctx, typeRequest, errs)) == null) {
            return null;
        }
        this.expr1 = exprTarget;
        this.expr2 = exprType;
        TypeConstant typeTarget = exprTarget.getType();
        if (!type.isA(typeTarget)) {
            type = new CastTypeConstant(this.pool(), typeTarget, type);
        }
        Constant constVal = null;
        if (!this.m_fCastRequired && exprTarget.isConstant()) {
            constVal = exprTarget.toConstant();
        }
        return this.finishValidation(ctx, typeRequired, type, Expression.TypeFit.Fit, constVal, errs);
    }

    @Override
    public Argument generateArgument(Context ctx, MethodStructure.Code code, boolean fLocalPropOk, boolean fUsedOnce, ErrorListener errs) {
        Argument argBefore = this.expr1.generateArgument(ctx, code, true, true, errs);
        TypeConstant type = this.getTargetType();
        if (this.m_fCastRequired || !argBefore.getType().equals(type)) {
            Register argAfter = code.createRegister(type, fUsedOnce);
            code.add(new MoveCast(argBefore, argAfter, type));
            return argAfter;
        }
        return argBefore;
    }

    @Override
    public void generateAssignment(Context ctx, MethodStructure.Code code, Expression.Assignable LVal, ErrorListener errs) {
        if (LVal.isLocalArgument()) {
            Argument argTarget = this.expr1.generateArgument(ctx, code, true, true, errs);
            if (this.m_fCastRequired) {
                code.add(new MoveCast(argTarget, LVal.getLocalArgument(), this.getTargetType()));
            } else {
                code.add(new Move(argTarget, LVal.getLocalArgument()));
            }
        } else {
            super.generateAssignment(ctx, code, LVal, errs);
        }
    }

    @Override
    public ExprAST getExprAST(Context ctx) {
        return new RelOpExprAST(this.expr1.getExprAST(ctx), BiExprAST.Operator.As, this.expr2.getExprAST(ctx), this.getType());
    }

    private TypeConstant getTargetType() {
        TypeConstant typeTarget = this.getType();
        return typeTarget instanceof CastTypeConstant ? typeTarget.getUnderlyingType2() : typeTarget;
    }

    @Override
    public String toString() {
        return String.valueOf(this.expr1) + "." + this.operator.getId().TEXT + "(" + String.valueOf(this.expr2) + ")";
    }
}

