/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.compiler.ast;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.xvm.asm.Argument;
import org.xvm.asm.Assignment;
import org.xvm.asm.ConstantPool;
import org.xvm.asm.ErrorListener;
import org.xvm.asm.MethodStructure;
import org.xvm.asm.Op;
import org.xvm.asm.Register;
import org.xvm.asm.ast.AssertStmtAST;
import org.xvm.asm.ast.BinaryAST;
import org.xvm.asm.ast.ConstantExprAST;
import org.xvm.asm.ast.ExprAST;
import org.xvm.asm.ast.UnaryOpExprAST;
import org.xvm.asm.constants.ClassConstant;
import org.xvm.asm.constants.FormalConstant;
import org.xvm.asm.constants.MethodConstant;
import org.xvm.asm.constants.StringConstant;
import org.xvm.asm.constants.TypeConstant;
import org.xvm.asm.op.Assert;
import org.xvm.asm.op.AssertM;
import org.xvm.asm.op.AssertV;
import org.xvm.asm.op.IsNot;
import org.xvm.asm.op.Jump;
import org.xvm.asm.op.JumpFalse;
import org.xvm.asm.op.JumpNCond;
import org.xvm.asm.op.JumpNFirst;
import org.xvm.asm.op.JumpNSample;
import org.xvm.asm.op.JumpTrue;
import org.xvm.asm.op.Label;
import org.xvm.asm.op.New_N;
import org.xvm.asm.op.Throw;
import org.xvm.compiler.Token;
import org.xvm.compiler.ast.AssignmentStatement;
import org.xvm.compiler.ast.AstNode;
import org.xvm.compiler.ast.BiExpression;
import org.xvm.compiler.ast.Context;
import org.xvm.compiler.ast.Expression;
import org.xvm.compiler.ast.Statement;
import org.xvm.compiler.ast.TraceExpression;
import org.xvm.compiler.ast.UnaryComplementExpression;
import org.xvm.util.Handy;
import org.xvm.util.ListMap;
import org.xvm.util.Severity;

public class AssertStatement
extends Statement {
    protected Token keyword;
    protected Expression interval;
    protected List<AstNode> conds;
    protected Expression message;
    protected long lEndPos;
    private List<String> m_listTexts;
    private static final Field[] CHILD_FIELDS = AssertStatement.fieldsForNames(AssertStatement.class, "interval", "conds", "message");

    public AssertStatement(Token keyword, Expression exprInterval, List<AstNode> conds, Expression exprMsg, long lEndPos) {
        switch (keyword.getId()) {
            case ASSERT: 
            case ASSERT_RND: 
            case ASSERT_ARG: 
            case ASSERT_BOUNDS: 
            case ASSERT_TODO: 
            case ASSERT_ONCE: 
            case ASSERT_TEST: 
            case ASSERT_DBG: {
                break;
            }
            default: {
                throw new IllegalArgumentException("keyword=" + String.valueOf(keyword));
            }
        }
        this.keyword = keyword;
        this.interval = exprInterval;
        this.conds = conds == null ? Collections.emptyList() : conds;
        this.message = exprMsg;
        this.lEndPos = lEndPos;
    }

    @Override
    public long getStartPosition() {
        return this.keyword.getStartPosition();
    }

    @Override
    public long getEndPosition() {
        return this.lEndPos;
    }

    public int getConditionCount() {
        return this.conds.size();
    }

    public AstNode getCondition(int i) {
        return this.conds.get(i);
    }

    public int findCondition(AstNode nodeChild) {
        int c = this.getConditionCount();
        for (int i = 0; i < c; ++i) {
            if (this.conds.get(i) != nodeChild) continue;
            return i;
        }
        return -1;
    }

    public boolean isDebugOnly() {
        return this.keyword.getId() == Token.Id.ASSERT_DBG;
    }

    public boolean isTestOnly() {
        return this.keyword.getId() == Token.Id.ASSERT_TEST;
    }

    public boolean isLinktimeConditional() {
        return this.isDebugOnly() | this.isTestOnly();
    }

    public boolean isOnlyOnce() {
        return this.keyword.getId() == Token.Id.ASSERT_ONCE;
    }

    public boolean isSampling() {
        return this.keyword.getId() == Token.Id.ASSERT_RND;
    }

    public boolean isNotAlways() {
        return this.isOnlyOnce() | this.isSampling();
    }

    public boolean alwaysEvaluated() {
        return !this.isNotAlways() && !this.isLinktimeConditional();
    }

    public Expression getSampleInterval() {
        return this.interval;
    }

    @Override
    protected Field[] getChildFields() {
        return CHILD_FIELDS;
    }

    @Override
    protected boolean allowsShortCircuit(AstNode nodeChild) {
        return true;
    }

    @Override
    protected Statement validateImpl(Context ctx, ErrorListener errs) {
        boolean fValid = true;
        if (this.message == null) {
            this.demorgan();
        }
        if (this.interval != null) {
            Expression exprNew = this.interval.validate(ctx, this.pool().typeInt64(), errs);
            if (exprNew == null) {
                fValid = false;
            } else {
                this.interval = exprNew;
                if (!this.interval.isRuntimeConstant()) {
                    this.interval.log(errs, Severity.ERROR, "COMPILER-47", new Object[0]);
                    fValid = false;
                }
            }
        }
        Expression exprMessage = this.message;
        Map<String, Argument> mapMessageArgs = null;
        int c = this.getConditionCount();
        for (int i = 0; i < c; ++i) {
            AstNode cond = this.getCondition(i);
            if (cond instanceof AssignmentStatement) {
                AssignmentStatement stmtOld = (AssignmentStatement)cond;
                if (stmtOld.isNegated()) {
                    ctx = ctx.enterNot();
                }
                AssignmentStatement stmtNew = (AssignmentStatement)stmtOld.validate(ctx, errs);
                if (stmtOld.isNegated()) {
                    ctx = ctx.exit();
                }
                if (stmtNew == null) {
                    fValid = false;
                    continue;
                }
                if (stmtNew == stmtOld) continue;
                this.conds.set(i, stmtNew);
                continue;
            }
            if (!(cond instanceof Expression)) continue;
            Expression exprOld = (Expression)cond;
            Expression exprNew = exprOld.validate(ctx = new AssertContext(ctx), this.pool().typeBoolean(), errs);
            if (exprNew == null) {
                fValid = false;
            } else {
                if (exprNew != exprOld) {
                    this.conds.set(i, exprNew);
                }
                if (exprNew.isConstantFalse() && this.alwaysEvaluated()) {
                    ctx.setReachable(false);
                }
            }
            if (exprMessage != null) {
                mapMessageArgs = ctx.mergeNarrowedElseTypes(mapMessageArgs);
            }
            ctx = ctx.exit();
        }
        if (exprMessage != null) {
            Context ctxMsg = ctx.enter();
            ctxMsg.replaceArguments(mapMessageArgs);
            Expression exprNew = exprMessage.validate(ctxMsg, this.pool().typeString(), errs);
            if (exprNew != exprMessage) {
                fValid &= exprNew != null;
                if (exprNew != null) {
                    this.message = exprNew;
                }
            }
            ctxMsg.discard();
        }
        if (this.conds.isEmpty() && this.alwaysEvaluated()) {
            ctx.setReachable(false);
        }
        return fValid ? this : null;
    }

    @Override
    protected boolean emit(Context ctx, boolean fReachable, MethodStructure.Code code, ErrorListener errs) {
        ConstantPool pool = this.pool();
        Statement.AstHolder holder = ctx.getHolder();
        boolean fDebug = this.isDebugOnly();
        if (this.isLinktimeConditional()) {
            String sCond = fDebug ? "debug" : "test";
            code.add(new JumpNCond(pool.ensureNamedCondition(sCond), (Op)this.getEndLabel()));
        }
        ExprAST astInterval = null;
        if (this.isNotAlways()) {
            if (this.isOnlyOnce()) {
                code.add(new JumpNFirst(this.getEndLabel()));
            } else {
                assert (this.interval != null);
                code.add(new JumpNSample(this.interval.generateArgument(ctx, code, true, true, errs), this.getEndLabel()));
                astInterval = this.interval.getExprAST(ctx);
            }
        }
        String sThrow = switch (this.keyword.getId()) {
            default -> "IllegalState";
            case Token.Id.ASSERT_ARG -> "IllegalArgument";
            case Token.Id.ASSERT_BOUNDS -> "OutOfBounds";
            case Token.Id.ASSERT_TODO -> "NotImplemented";
            case Token.Id.ASSERT_RND, Token.Id.ASSERT_ONCE, Token.Id.ASSERT_TEST -> "Assertion";
            case Token.Id.ASSERT_DBG -> null;
        };
        ClassConstant constEx = sThrow == null ? null : pool.ensureEcstasyClassConstant(sThrow);
        MethodConstant constNew = sThrow == null ? null : AssertStatement.findExceptionConstructor(pool, sThrow, errs);
        int cConds = this.getConditionCount();
        if (cConds == 0) {
            ExprAST astMessage = null;
            if (this.message == null || fDebug) {
                code.add(new Assert(pool.valFalse(), constNew));
            } else {
                assert (constNew != null);
                Register argEx = code.createRegister(constEx.getType());
                Argument argMsg = this.message.generateArgument(ctx, code, true, true, errs);
                code.add(new New_N(constNew, new Argument[]{argMsg, pool.valNull()}, argEx));
                code.add(new Throw(argEx));
                astMessage = this.message.getExprAST(ctx);
            }
            holder.setAst(this, new AssertStmtAST(null, astInterval, astMessage));
            return !this.alwaysEvaluated();
        }
        boolean fCompletes = fReachable;
        Label labelMessage = new Label("CustomMessage");
        ExprAST[] aAstCond = new ExprAST[cConds];
        for (int i = 0; i < cConds; ++i) {
            Argument argCond;
            AstNode cond = this.getCondition(i);
            StringConstant constText = null;
            ListMap<String, Expression> mapTrace = null;
            if (this.message == null) {
                String sCond = this.m_listTexts.get(i);
                int cTrace = 0;
                mapTrace = new ListMap<String, Expression>();
                cond.selectTraceableExpressions(mapTrace);
                if (!mapTrace.isEmpty()) {
                    StringBuilder sb = new StringBuilder().append('\"').append(sCond).append('\"');
                    boolean fFirst = true;
                    for (Map.Entry entry : mapTrace.entrySet()) {
                        Expression expr = (Expression)entry.getValue();
                        expr.requireTrace();
                        sb.append(fFirst ? ": " : ", ").append((String)entry.getKey()).append('=');
                        fFirst = false;
                        TypeConstant[] aTypes = expr.getTypes();
                        int cTypes = aTypes.length;
                        if (cTypes != 1) {
                            sb.append('(');
                        }
                        for (int iType = 0; iType < cTypes; ++iType) {
                            if (iType > 0) {
                                sb.append(", ");
                            }
                            sb.append('{').append(cTrace++).append('}');
                        }
                        if (cTypes == 1) continue;
                        sb.append(')');
                    }
                    sCond = sb.toString();
                }
                constText = pool.ensureStringConstant(sCond);
                cond = this.getCondition(i);
            }
            boolean fNegated = false;
            if (cond instanceof AssignmentStatement) {
                AssignmentStatement stmtCond = (AssignmentStatement)cond;
                fNegated = stmtCond.isNegated();
                fCompletes &= stmtCond.completes(ctx, fCompletes, code, errs);
                argCond = stmtCond.getConditionRegister();
                ExprAST astCond = (ExprAST)ctx.getHolder().getAst(stmtCond);
                aAstCond[i] = fNegated ? new UnaryOpExprAST(astCond, UnaryOpExprAST.Operator.Not, pool.typeBoolean()) : astCond;
            } else {
                Expression exprCond = (Expression)cond;
                if (exprCond.isConstantFalse()) {
                    code.add(this.message == null ? new Assert(pool.valFalse(), constNew) : new Jump(labelMessage));
                    fCompletes = false;
                    aAstCond[i] = new ConstantExprAST(pool.valFalse());
                    continue;
                }
                if (exprCond.isConstantTrue()) {
                    aAstCond[i] = new ConstantExprAST(pool.valTrue());
                    continue;
                }
                fCompletes &= exprCond.isCompletable();
                argCond = exprCond.generateArgument(ctx, code, true, true, errs);
                aAstCond[i] = exprCond.getExprAST(ctx);
            }
            if (this.message == null || fDebug) {
                if (fNegated) {
                    Register regNeg = new Register(pool.typeBoolean(), null, -1);
                    code.add(new IsNot(argCond, regNeg));
                    argCond = regNeg;
                }
                if (fDebug) {
                    code.add(new Assert(argCond, null));
                    continue;
                }
                if (mapTrace.isEmpty()) {
                    code.add(new AssertM(argCond, constNew, constText));
                    continue;
                }
                ArrayList argV = new ArrayList();
                for (Expression expr : mapTrace.values()) {
                    Argument[] aArgs = ((TraceExpression)expr.getParent()).getArguments();
                    Collections.addAll(argV, aArgs);
                }
                code.add(new AssertV(argCond, constNew, constText, argV.toArray(Expression.NO_RVALUES)));
                continue;
            }
            if (i == cConds - 1) {
                code.add(fNegated ? new JumpFalse(argCond, this.getEndLabel()) : new JumpTrue(argCond, this.getEndLabel()));
                continue;
            }
            code.add(fNegated ? new JumpTrue(argCond, labelMessage) : new JumpFalse(argCond, labelMessage));
        }
        ExprAST astMessage = null;
        if (this.message != null && !fDebug) {
            code.add(labelMessage);
            Register argEx = code.createRegister(constEx.getType());
            Argument argMsg = this.message.generateArgument(ctx, code, true, true, errs);
            code.add(new New_N(constNew, new Argument[]{argMsg, pool.valNull()}, argEx));
            code.add(new Throw(argEx));
            astMessage = this.message.getExprAST(ctx);
        }
        holder.setAst(this, new AssertStmtAST(BinaryAST.makeCondition(aAstCond), astInterval, astMessage));
        return fCompletes;
    }

    public static MethodConstant findExceptionConstructor(ConstantPool pool, String sName, ErrorListener errs) {
        return pool.ensureEcstasyTypeConstant(sName).ensureTypeInfo(errs).findConstructor(null);
    }

    protected void demorgan() {
        if (!this.conds.isEmpty()) {
            List<AstNode> listOldConds = this.conds;
            this.conds = new ArrayList<AstNode>(this.conds.size());
            this.m_listTexts = new ArrayList<String>(this.conds.size());
            for (AstNode cond : listOldConds) {
                this.demorgan(cond);
            }
        }
    }

    private void demorgan(AstNode cond) {
        String sCond = Handy.appendString(new StringBuilder(), cond.getSource().toString(cond.getStartPosition(), cond.getEndPosition())).toString();
        if (cond instanceof UnaryComplementExpression) {
            UnaryComplementExpression exprNot = (UnaryComplementExpression)cond;
            Expression exprSub = exprNot.expr;
            if (exprSub instanceof BiExpression) {
                BiExpression exprOr = (BiExpression)exprSub;
                if (exprOr.operator.getId() == Token.Id.COND_OR) {
                    UnaryComplementExpression exprNot2 = (UnaryComplementExpression)exprNot.clone();
                    exprNot.expr = exprOr.expr1;
                    exprNot2.expr = exprOr.expr2;
                    this.demorgan(exprNot);
                    this.demorgan(exprNot2);
                    exprOr.discard(false);
                    return;
                }
            }
        } else if (cond instanceof BiExpression) {
            BiExpression exprAnd = (BiExpression)cond;
            if (exprAnd.operator.getId() == Token.Id.COND_AND) {
                this.demorgan(exprAnd.expr1);
                this.demorgan(exprAnd.expr2);
                exprAnd.discard(false);
                return;
            }
        }
        this.conds.add(cond);
        this.m_listTexts.add(sCond);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.keyword.getId().TEXT);
        if (this.interval != null) {
            sb.append('(').append(this.interval).append(')');
        }
        if (!this.conds.isEmpty()) {
            sb.append(' ').append(this.conds.get(0));
            int c = this.conds.size();
            for (int i = 1; i < c; ++i) {
                sb.append(", ").append(this.conds.get(i));
            }
        }
        sb.append(';');
        return sb.toString();
    }

    @Override
    public String getDumpDesc() {
        return this.toString();
    }

    static class AssertContext
    extends Context {
        public AssertContext(Context outer) {
            super(outer, true);
        }

        @Override
        protected Assignment promote(String sName, Assignment asnInner, Assignment asnOuter) {
            return asnInner.whenTrue();
        }

        @Override
        protected void promoteNarrowedType(String sName, Argument arg, Context.Branch branch) {
            super.promoteNarrowedType(sName, arg, branch);
            if (branch == Context.Branch.WhenTrue) {
                this.getOuterContext().replaceArgument(sName, Context.Branch.Always, arg);
            }
        }

        @Override
        protected void promoteNarrowedGenericType(FormalConstant constFormal, TypeConstant typeNarrowed, Context.Branch branch) {
            super.promoteNarrowedGenericType(constFormal, typeNarrowed, branch);
            if (branch == Context.Branch.WhenTrue) {
                this.getOuterContext().replaceGenericType(constFormal, Context.Branch.Always, typeNarrowed);
            }
        }
    }
}

