/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.compiler.ast;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.xvm.asm.Argument;
import org.xvm.asm.Assignment;
import org.xvm.asm.Constant;
import org.xvm.asm.ConstantPool;
import org.xvm.asm.ErrorListener;
import org.xvm.asm.MethodStructure;
import org.xvm.asm.PropertyStructure;
import org.xvm.asm.Register;
import org.xvm.asm.ast.AssignAST;
import org.xvm.asm.ast.BinaryAST;
import org.xvm.asm.ast.ExprAST;
import org.xvm.asm.ast.InvokeExprAST;
import org.xvm.asm.ast.MultiExprAST;
import org.xvm.asm.ast.UnaryOpExprAST;
import org.xvm.asm.constants.MethodConstant;
import org.xvm.asm.constants.PropertyConstant;
import org.xvm.asm.constants.TypeConstant;
import org.xvm.asm.op.Jump;
import org.xvm.asm.op.JumpFalse;
import org.xvm.asm.op.JumpNotNull;
import org.xvm.asm.op.JumpNull;
import org.xvm.asm.op.JumpTrue;
import org.xvm.asm.op.Label;
import org.xvm.asm.op.Move;
import org.xvm.compiler.Token;
import org.xvm.compiler.ast.AssertStatement;
import org.xvm.compiler.ast.AstNode;
import org.xvm.compiler.ast.BiExpression;
import org.xvm.compiler.ast.CondOpExpression;
import org.xvm.compiler.ast.ConditionalStatement;
import org.xvm.compiler.ast.Context;
import org.xvm.compiler.ast.ConvertExpression;
import org.xvm.compiler.ast.ElvisExpression;
import org.xvm.compiler.ast.Expression;
import org.xvm.compiler.ast.ForStatement;
import org.xvm.compiler.ast.IfStatement;
import org.xvm.compiler.ast.InvocationExpression;
import org.xvm.compiler.ast.MultipleLValueStatement;
import org.xvm.compiler.ast.NameExpression;
import org.xvm.compiler.ast.RelOpExpression;
import org.xvm.compiler.ast.Statement;
import org.xvm.compiler.ast.UnpackExpression;
import org.xvm.compiler.ast.VariableDeclarationStatement;
import org.xvm.compiler.ast.WhileStatement;
import org.xvm.util.Severity;

public class AssignmentStatement
extends Statement {
    protected AstNode lvalue;
    protected Expression lvalueExpr;
    protected Token op;
    protected Expression rvalue;
    protected boolean term;
    protected Token tokNegate;
    protected long endNegate;
    private transient VariableDeclarationStatement[] m_decls;
    private transient Register m_regCond;
    private static final Field[] CHILD_FIELDS = AssignmentStatement.fieldsForNames(AssignmentStatement.class, "lvalue", "lvalueExpr", "rvalue");

    public AssignmentStatement(AstNode lvalue, Token op, Expression rvalue) {
        this(lvalue, op, rvalue, true);
    }

    public AssignmentStatement(AstNode lvalue, Token op, Expression rvalue, boolean standalone) {
        this.lvalue = lvalue;
        this.op = op;
        this.rvalue = rvalue;
        this.term = standalone;
    }

    public boolean hasDeclarations() {
        if (this.m_decls != null) {
            return this.m_decls.length > 0;
        }
        if (this.lvalue instanceof VariableDeclarationStatement) {
            return true;
        }
        AstNode astNode = this.lvalue;
        if (astNode instanceof MultipleLValueStatement) {
            MultipleLValueStatement stmtMulti = (MultipleLValueStatement)astNode;
            for (AstNode LVal : stmtMulti.LVals) {
                if (!(LVal instanceof VariableDeclarationStatement)) continue;
                return true;
            }
        }
        this.m_decls = VariableDeclarationStatement.NONE;
        return false;
    }

    public VariableDeclarationStatement[] getDeclarations() {
        VariableDeclarationStatement[] aDecls = this.m_decls;
        if (aDecls == null) {
            AstNode LVal = this.lvalue;
            if (LVal instanceof VariableDeclarationStatement) {
                VariableDeclarationStatement stmtVar = (VariableDeclarationStatement)LVal;
                aDecls = new VariableDeclarationStatement[]{stmtVar};
            } else if (LVal instanceof MultipleLValueStatement) {
                MultipleLValueStatement stmtMulti = (MultipleLValueStatement)LVal;
                ArrayList<VariableDeclarationStatement> list = new ArrayList<VariableDeclarationStatement>();
                for (AstNode node : stmtMulti.LVals) {
                    if (!(node instanceof VariableDeclarationStatement)) continue;
                    VariableDeclarationStatement stmtVar = (VariableDeclarationStatement)node;
                    list.add(stmtVar);
                }
                aDecls = list.isEmpty() ? VariableDeclarationStatement.NONE : list.toArray(VariableDeclarationStatement.NONE);
            } else {
                aDecls = VariableDeclarationStatement.NONE;
            }
            this.m_decls = aDecls;
        }
        return aDecls;
    }

    public VariableDeclarationStatement[] takeDeclarations() {
        if (!this.hasDeclarations()) {
            return VariableDeclarationStatement.NONE;
        }
        VariableDeclarationStatement[] aDecls = this.m_decls;
        AstNode LVal = this.lvalue;
        if (LVal instanceof VariableDeclarationStatement) {
            VariableDeclarationStatement stmt = (VariableDeclarationStatement)LVal;
            this.lvalue = new NameExpression(this, stmt.getNameToken(), stmt.getRegister());
            if (aDecls == null) {
                aDecls = new VariableDeclarationStatement[]{stmt};
            }
        } else {
            List<AstNode> LVals = ((MultipleLValueStatement)LVal).LVals;
            ArrayList<VariableDeclarationStatement> listDecls = aDecls == null ? new ArrayList<VariableDeclarationStatement>() : null;
            int c = LVals.size();
            for (int i = 0; i < c; ++i) {
                AstNode node = LVals.get(i);
                if (!(node instanceof VariableDeclarationStatement)) continue;
                VariableDeclarationStatement stmt = (VariableDeclarationStatement)node;
                LVals.set(i, stmt.getLValueExpression());
                if (listDecls == null) continue;
                listDecls.add(stmt);
            }
            if (aDecls == null) {
                aDecls = listDecls.toArray(VariableDeclarationStatement.NONE);
            }
        }
        this.m_decls = VariableDeclarationStatement.NONE;
        return aDecls;
    }

    public void negate(Token tokNegate, Token tokEnd) {
        assert (!this.isNegated() && tokNegate.getId() == Token.Id.NOT && tokEnd.getId() == Token.Id.R_PAREN);
        this.tokNegate = tokNegate;
        this.endNegate = tokEnd.getEndPosition();
    }

    public boolean isForEachCondition() {
        return this.op.getId() == Token.Id.COLON;
    }

    public boolean isConditional() {
        switch (this.op.getId()) {
            case COND_ASN: 
            case COND_NN_ASN: {
                AssertStatement parentAssert;
                ForStatement parentFor;
                AstNode parent = this.getParent();
                return parent instanceof IfStatement || parent instanceof WhileStatement || parent instanceof ForStatement && (parentFor = (ForStatement)parent).findCondition(this) >= 0 || parent instanceof AssertStatement && (parentAssert = (AssertStatement)parent).findCondition(this) >= 0;
            }
            case COLON: {
                return true;
            }
        }
        return false;
    }

    public Category getCategory() {
        return switch (this.op.getId()) {
            case Token.Id.ASN -> Category.Assign;
            case Token.Id.ADD_ASN, Token.Id.SUB_ASN, Token.Id.MUL_ASN, Token.Id.DIV_ASN, Token.Id.MOD_ASN, Token.Id.SHL_ASN, Token.Id.SHR_ASN, Token.Id.USHR_ASN, Token.Id.BIT_AND_ASN, Token.Id.BIT_OR_ASN, Token.Id.BIT_XOR_ASN -> Category.InPlace;
            case Token.Id.COND_AND_ASN, Token.Id.COND_OR_ASN, Token.Id.COND_ELSE_ASN -> Category.CondLeft;
            case Token.Id.COND_ASN, Token.Id.COND_NN_ASN, Token.Id.COLON -> Category.CondRight;
            default -> throw new IllegalStateException("op=" + String.valueOf(this.op));
        };
    }

    public Register getConditionRegister() {
        Register reg = this.m_regCond;
        if (reg == null) {
            switch (this.op.getId()) {
                case COND_ASN: 
                case COND_NN_ASN: 
                case COLON: {
                    this.m_regCond = reg = new Register(this.pool().typeBoolean(), null, -1);
                    break;
                }
                default: {
                    throw new IllegalStateException("op=\"" + this.op.getValueText() + "\"");
                }
            }
        }
        return reg;
    }

    public AstNode getLValue() {
        return this.lvalue;
    }

    public Token getOp() {
        return this.op;
    }

    public boolean isNegated() {
        return this.tokNegate != null;
    }

    public Expression getRValue() {
        return this.rvalue;
    }

    @Override
    protected boolean allowsConditional(Expression exprChild) {
        return this.getCategory() == Category.CondRight && exprChild == this.rvalue;
    }

    @Override
    protected boolean allowsShortCircuit(AstNode nodeChild) {
        AstNode parent = this.getParent();
        if (parent instanceof ConditionalStatement) {
            return parent.allowsShortCircuit(this);
        }
        return !this.hasDeclarations();
    }

    @Override
    protected Label ensureShortCircuitLabel(AstNode nodeOrigin, Context ctxOrigin) {
        return this.getParent() instanceof ConditionalStatement ? this.getParent().ensureShortCircuitLabel(nodeOrigin, ctxOrigin) : super.ensureShortCircuitLabel(nodeOrigin, ctxOrigin);
    }

    @Override
    public long getStartPosition() {
        return this.tokNegate == null ? this.lvalue.getStartPosition() : this.tokNegate.getStartPosition();
    }

    @Override
    public long getEndPosition() {
        return this.tokNegate == null ? this.rvalue.getEndPosition() : this.endNegate;
    }

    @Override
    protected Field[] getChildFields() {
        return CHILD_FIELDS;
    }

    @Override
    public Expression getLValueExpression() {
        return this.lvalueExpr;
    }

    @Override
    protected boolean isRValue(Expression exprChild) {
        return exprChild != this.lvalue;
    }

    @Override
    protected Statement validateImpl(Context ctx, ErrorListener errs) {
        AstNode nodeLeft = this.lvalue;
        Expression exprLeftCopy = null;
        boolean fConditional = this.isConditional();
        switch (this.getCategory().ordinal()) {
            case 1: 
            case 2: {
                if (!nodeLeft.isLValueSyntax()) {
                    nodeLeft.log(errs, Severity.ERROR, "COMPILER-70", new Object[0]);
                    return null;
                }
                exprLeftCopy = (Expression)nodeLeft.getLValueExpression().clone();
            }
        }
        ConstantPool pool = this.pool();
        Context ctxRValue = ctx;
        Context ctxLValue = ctx;
        if (nodeLeft instanceof Statement) {
            Statement stmtLeft = (Statement)nodeLeft;
            assert (stmtLeft instanceof VariableDeclarationStatement || stmtLeft instanceof MultipleLValueStatement);
            ErrorListener errsTmp = errs.branch(this);
            LValueContext ctxLV = new LValueContext(ctx);
            Statement lvalueNew = stmtLeft.validate(ctxLV, errsTmp);
            errsTmp.merge();
            if (lvalueNew == null || errsTmp.hasSeriousErrors()) {
                return null;
            }
            this.lvalue = nodeLeft = lvalueNew;
            ctxLValue = ctxLV.enterLValue();
        }
        if (!nodeLeft.isLValueSyntax()) {
            nodeLeft.log(errs, Severity.ERROR, "COMPILER-70", new Object[0]);
            return null;
        }
        Expression exprLeft = nodeLeft.getLValueExpression();
        if (!exprLeft.isValidated()) {
            Expression exprNew;
            TypeConstant[] atypeLeft = exprLeft.getImplicitTypes(ctxLValue);
            int cLeft = atypeLeft.length;
            if (cLeft > 0) {
                UnpackExpression exprUnpack;
                TypeConstant[] atypeTest = atypeLeft;
                if (this.op.getId() == Token.Id.COND_NN_ASN) {
                    atypeTest = new TypeConstant[]{atypeLeft[0].ensureNullable()};
                } else if (fConditional) {
                    atypeTest = new TypeConstant[cLeft + 1];
                    atypeTest[0] = pool.typeBoolean();
                    System.arraycopy(atypeLeft, 0, atypeTest, 1, cLeft);
                }
                Context.InferringContext ctxInfer = ctxRValue.enterInferring(atypeLeft[0]);
                Expression.TypeFit fit = this.rvalue.testFitMulti(ctxInfer, atypeTest, false, null);
                if (!fit.isFit() && cLeft > 1 && (fit = ((Expression)(exprUnpack = new UnpackExpression(this.rvalue, null))).testFitMulti(ctxInfer, atypeTest, false, null)).isFit()) {
                    this.rvalue = exprUnpack;
                }
                if (!fit.isFit()) {
                    atypeLeft = TypeConstant.NO_TYPES;
                }
                ctxInfer.discard();
            }
            if ((exprNew = exprLeft.validateMulti(ctxLValue, atypeLeft, errs)) == null) {
                return null;
            }
            if (exprLeft == nodeLeft) {
                this.lvalue = nodeLeft = exprNew;
            }
            exprLeft = exprNew;
        }
        this.lvalueExpr = exprLeft;
        exprLeft.requireAssignable(ctxLValue, errs);
        Expression exprRight = null;
        TypeConstant[] atypeRight = null;
        switch (this.getCategory().ordinal()) {
            case 0: {
                NameExpression exprName;
                TypeConstant typeLeft;
                if (exprLeft.isSingle()) {
                    Object exprInvoke;
                    TypeConstant typeFuture;
                    boolean fInfer;
                    typeLeft = exprLeft.getType();
                    boolean bl = fInfer = typeLeft != null;
                    if (fInfer) {
                        ctxRValue = ctxRValue.enterInferring(typeLeft);
                    }
                    if (exprLeft instanceof NameExpression && (exprName = (NameExpression)exprLeft).isDynamicVar() && this.rvalue.testFit(ctxRValue, typeFuture = pool.ensureFuture(typeLeft), false, null).isFit()) {
                        typeLeft = typeFuture;
                    }
                    exprRight = this.rvalue.validate(ctxRValue, typeLeft, errs);
                    if (fInfer) {
                        ctxRValue = ctxRValue.exit();
                    }
                    if (exprRight instanceof InvocationExpression && ((InvocationExpression)(exprInvoke = (InvocationExpression)exprRight)).isAsync() && exprLeft instanceof NameExpression) {
                        NameExpression exprName2 = (NameExpression)exprLeft;
                        this.addFutureAnnotation(ctxLValue, exprName2);
                    }
                } else {
                    InvocationExpression exprInvoke;
                    exprRight = this.rvalue.validateMulti(ctxRValue, exprLeft.getTypes(), errs);
                    if (exprRight instanceof InvocationExpression && (exprInvoke = (InvocationExpression)exprRight).isAsync() && exprLeft instanceof MultipleLValueStatement.MultipleLValueExpression) {
                        MultipleLValueStatement.MultipleLValueExpression exprLMulti = (MultipleLValueStatement.MultipleLValueExpression)exprLeft;
                        for (Expression expr : exprLMulti.ensureExpressions()) {
                            if (!(expr instanceof NameExpression)) continue;
                            NameExpression exprName3 = (NameExpression)expr;
                            this.addFutureAnnotation(ctxLValue, exprName3);
                        }
                    }
                }
                this.merge(ctxRValue, ctxLValue);
                exprLeft.markAssignment(ctxRValue, exprRight != null && exprRight.isConditionalResult(), errs);
                if (exprRight == null) break;
                atypeRight = exprRight.getTypes();
                break;
            }
            case 3: {
                NameExpression exprName;
                if (this.op.getId() == Token.Id.COND_NN_ASN) {
                    TypeConstant typeReq;
                    if (!exprLeft.isSingle()) {
                        this.lvalueExpr.log(errs, Severity.ERROR, "COMPILER-44", 1, exprLeft.getValueCount());
                    }
                    if ((typeReq = exprLeft.getType()) != null) {
                        typeReq = typeReq.ensureNullable();
                    }
                    exprRight = this.rvalue.validate(ctxRValue, typeReq, errs);
                    this.merge(ctxRValue, ctxLValue);
                    exprLeft.markAssignment(ctxRValue, fConditional, errs);
                    if (exprRight != null && (atypeRight = exprRight.getTypes()).length == 1) {
                        TypeConstant typeRight = atypeRight[0];
                        if (typeRight.isNullable()) {
                            typeRight = typeRight.removeNullable();
                            atypeRight = new TypeConstant[]{typeRight};
                            if (exprRight instanceof NameExpression) {
                                exprName = (NameExpression)exprRight;
                                exprName.narrowType(ctx, Context.Branch.WhenTrue, typeRight);
                                exprName.narrowType(ctx, Context.Branch.WhenFalse, pool.typeNull());
                            }
                        } else {
                            this.rvalue.log(errs, Severity.ERROR, "COMPILER-91", typeRight.getValueString());
                        }
                    }
                } else {
                    TypeConstant[] atypeAll;
                    int cTypes;
                    TypeConstant[] atypeLVals = exprLeft.getTypes();
                    int cLVals = atypeLVals.length;
                    int cReq = cLVals + 1;
                    TypeConstant[] atypeReq = new TypeConstant[cReq];
                    atypeReq[0] = this.pool().typeBoolean();
                    System.arraycopy(atypeLVals, 0, atypeReq, 1, cLVals);
                    exprRight = this.rvalue.validateMulti(ctxRValue, atypeReq, errs);
                    this.merge(ctxRValue, ctxLValue);
                    exprLeft.markAssignment(ctxRValue, fConditional && exprRight != null && exprRight.isConditionalResult(), errs);
                    if (exprRight != null && (cTypes = (atypeAll = exprRight.getTypes()).length - 1) >= 1) {
                        atypeRight = new TypeConstant[cTypes];
                        System.arraycopy(atypeAll, 1, atypeRight, 0, cTypes);
                    }
                }
                if (!this.hasDeclarations() || fConditional) break;
                this.log(errs, Severity.ERROR, "COMPILER-61", new Object[0]);
                break;
            }
            case 1: 
            case 2: {
                BiExpression exprFakeRValue;
                Expression exprFakeRValueNew;
                boolean fInfer;
                assert (exprLeftCopy != null);
                TypeConstant typeLeft = exprLeft.getType();
                boolean bl = fInfer = typeLeft != null;
                if (fInfer) {
                    ctxRValue = ctxRValue.enterInferring(typeLeft);
                }
                if ((exprFakeRValueNew = (exprFakeRValue = this.createBiExpression(exprLeftCopy, this.op, this.rvalue)).validate(ctxRValue, typeLeft, errs)) instanceof ConvertExpression) {
                    ConvertExpression exprConv = (ConvertExpression)exprFakeRValueNew;
                    exprFakeRValueNew = exprConv.getUnderlyingExpression();
                }
                if (exprFakeRValueNew instanceof BiExpression) {
                    BiExpression exprBi = (BiExpression)exprFakeRValueNew;
                    exprRight = exprBi.getExpression2();
                    if (this.getCategory() == Category.CondLeft) {
                        atypeRight = exprRight.getTypes();
                    }
                }
                if (fInfer) {
                    ctxRValue = ctxRValue.exit();
                }
                this.merge(ctxRValue, ctxLValue);
                exprLeft.markAssignment(ctxRValue, false, errs);
                break;
            }
        }
        if (exprRight == null) {
            nodeLeft.resetLValueTypes(ctx);
            return null;
        }
        this.rvalue = exprRight;
        if (atypeRight != null) {
            boolean fCondRight = this.getCategory() == Category.CondRight && !(this.getParent() instanceof AssertStatement);
            Context.Branch branch = fCondRight && fConditional ? Context.Branch.WhenTrue : Context.Branch.Always;
            nodeLeft.updateLValueFromRValueTypes(ctxRValue, branch, fCondRight && !fConditional, atypeRight);
        }
        return this;
    }

    private void addFutureAnnotation(Context ctxLValue, NameExpression exprName) {
        Argument argLeft = ctxLValue.getVar(exprName.getName());
        if (argLeft instanceof Register) {
            Register regLeft = (Register)argLeft;
            ConstantPool pool = this.pool();
            TypeConstant typeRef = regLeft.ensureRegType(false);
            if (!typeRef.containsAnnotation(pool.clzFuture())) {
                regLeft.specifyRegType(pool.ensureAnnotatedTypeConstant(typeRef, pool.ensureAnnotation(pool.clzFuture(), new Constant[0])));
            }
        }
    }

    @Override
    protected void selectTraceableExpressions(Map<String, Expression> mapExprs) {
        assert (this.op.getId() == Token.Id.COND_ASN || this.op.getId() == Token.Id.COND_NN_ASN);
        this.rvalue.selectTraceableExpressions(mapExprs);
    }

    @Override
    public boolean isTodo() {
        return this.rvalue.isTodo();
    }

    @Override
    protected boolean emit(Context ctx, boolean fReachable, MethodStructure.Code code, ErrorListener errs) {
        boolean fCompletes = fReachable;
        ConstantPool pool = this.pool();
        ExprAST astAssign = null;
        switch (this.getCategory().ordinal()) {
            case 0: {
                ConvertExpression exprConv;
                VariableDeclarationStatement stmtVar;
                AstNode astNode;
                if (this.lvalueExpr.isSingle() && (astNode = this.lvalue) instanceof VariableDeclarationStatement && !(stmtVar = (VariableDeclarationStatement)astNode).hasRefAnnotations() && this.rvalue.supportsCompactInit(stmtVar)) {
                    assert (this.lvalueExpr.isCompletable());
                    this.rvalue.generateCompactInit(ctx, code, stmtVar, errs);
                    astAssign = new AssignAST(stmtVar.getRegister().getRegAllocAST(), AssignAST.Operator.Asn, this.rvalue.getExprAST(ctx));
                    break;
                }
                ExprAST astLVal = null;
                AstNode astNode2 = this.lvalue;
                if (astNode2 instanceof Statement) {
                    Statement stmt = (Statement)astNode2;
                    fCompletes = stmt.completes(ctx, fCompletes, code, errs);
                    astLVal = (ExprAST)ctx.getHolder().getAst(stmt);
                }
                Expression.Assignable[] LVals = this.lvalueExpr.generateAssignables(ctx, code, errs);
                if (fCompletes &= this.lvalueExpr.isCompletable()) {
                    this.rvalue.generateAssignments(ctx, code, LVals, errs);
                    fCompletes &= this.rvalue.isCompletable();
                }
                astLVal = AssignmentStatement.combineLValueAST(astLVal, this.lvalueExpr.getExprAST(ctx));
                Expression expression = this.rvalue;
                astAssign = expression instanceof ConvertExpression && !(exprConv = (ConvertExpression)expression).isSingle() && !exprConv.isConstant() ? exprConv.unwrapConvertAST(ctx, astLVal) : new AssignAST(astLVal, AssignAST.Operator.Asn, this.rvalue.getExprAST(ctx));
                break;
            }
            case 3: {
                AssignAST.Operator operAsn;
                ExprAST astLVal = null;
                AstNode exprConv = this.lvalue;
                if (exprConv instanceof Statement) {
                    Statement stmt = (Statement)exprConv;
                    fCompletes = stmt.completes(ctx, fCompletes, code, errs);
                    astLVal = (ExprAST)ctx.getHolder().getAst(stmt);
                }
                if (this.op.getId() == Token.Id.COND_NN_ASN) {
                    Register regCond;
                    Argument arg = this.rvalue.generateArgument(ctx, code, false, false, errs);
                    fCompletes &= this.rvalue.isCompletable();
                    Label labelSkipAssign = new Label("?=Null");
                    code.add(new JumpNull(arg, labelSkipAssign));
                    Expression.Assignable LVal = this.lvalueExpr.generateAssignable(ctx, code, errs);
                    LVal.assign(arg, code, errs);
                    Register register = regCond = this.isConditional() ? this.getConditionRegister() : null;
                    if (regCond != null) {
                        code.add(new Move(pool.valTrue(), regCond));
                        code.add(new Jump(this.getEndLabel()));
                    }
                    code.add(labelSkipAssign);
                    if (regCond != null) {
                        code.add(new Move(pool.valFalse(), regCond));
                    }
                    operAsn = AssignAST.Operator.AsnIfNotNull;
                } else {
                    Expression.Assignable[] LVals = this.lvalueExpr.generateAssignables(ctx, code, errs);
                    int cLVals = LVals.length;
                    int cAll = cLVals + 1;
                    Expression.Assignable[] LValsAll = new Expression.Assignable[cAll];
                    boolean fCond = this.isConditional();
                    Register regCond = this.getConditionRegister();
                    Expression expression = this.lvalueExpr;
                    Objects.requireNonNull(expression);
                    LValsAll[0] = new Expression.Assignable(expression, regCond);
                    if (fCompletes &= this.lvalueExpr.isCompletable()) {
                        if (fCond || this.rvalue.isConditionalResult()) {
                            System.arraycopy(LVals, 0, LValsAll, 1, cLVals);
                            this.rvalue.generateAssignments(ctx, code, LValsAll, errs);
                        } else {
                            for (int i = 1; i < cAll; ++i) {
                                Expression expression2 = this.lvalueExpr;
                                Objects.requireNonNull(expression2);
                                LValsAll[i] = new Expression.Assignable(expression2, code.createRegister(LVals[i - 1].getType()));
                            }
                            this.rvalue.generateAssignments(ctx, code, LValsAll, errs);
                            Label label = new Label("skip_copy");
                            code.add(new JumpFalse(regCond, label));
                            for (int i = 0; i < cLVals; ++i) {
                                LVals[i].assign(LValsAll[i + 1].getRegister(), code, errs);
                            }
                            code.add(label);
                        }
                        fCompletes &= this.rvalue.isCompletable();
                    }
                    operAsn = AssignAST.Operator.AsnIfNotFalse;
                }
                astLVal = AssignmentStatement.combineLValueAST(astLVal, this.lvalueExpr.getExprAST(ctx));
                astAssign = new AssignAST(astLVal, operAsn, this.rvalue.getExprAST(ctx));
                break;
            }
            case 2: {
                Expression.Assignable LVal = this.lvalueExpr.generateAssignable(ctx, code, errs);
                if (!(fCompletes &= this.lvalueExpr.isCompletable())) break;
                Argument argLVal = LVal.generateArgument(ctx, code, true, true, errs);
                Label labelSkip = new Label(this.op.getValueText() + " _skip_assign");
                AssignAST.Operator operAsn = switch (this.op.getId()) {
                    case Token.Id.COND_AND_ASN -> {
                        code.add(new JumpFalse(argLVal, labelSkip));
                        yield AssignAST.Operator.AsnIfWasTrue;
                    }
                    case Token.Id.COND_OR_ASN -> {
                        code.add(new JumpTrue(argLVal, labelSkip));
                        yield AssignAST.Operator.AsnIfWasFalse;
                    }
                    case Token.Id.COND_ELSE_ASN -> {
                        code.add(new JumpNotNull(argLVal, labelSkip));
                        yield AssignAST.Operator.AsnIfWasNull;
                    }
                    default -> throw new IllegalStateException("op=" + this.op.getId().TEXT);
                };
                this.rvalue.generateAssignment(ctx, code, LVal, errs);
                fCompletes &= this.rvalue.isCompletable();
                code.add(labelSkip);
                astAssign = new AssignAST(this.lvalueExpr.getExprAST(ctx), operAsn, this.rvalue.getExprAST(ctx));
                break;
            }
            case 1: {
                MethodConstant idOp;
                PropertyConstant idProp;
                PropertyStructure prop;
                Expression.Assignable LVal = this.lvalueExpr.generateAssignable(ctx, code, errs);
                if (!(fCompletes &= this.lvalueExpr.isCompletable())) break;
                Argument argRVal = this.rvalue.generateArgument(ctx, code, true, true, errs);
                if (!(fCompletes &= this.rvalue.isCompletable())) break;
                LVal.assignInPlaceResult(this.op, argRVal, code, errs);
                ExprAST astLValue = this.lvalueExpr.getExprAST(ctx);
                ExprAST astRValue = this.rvalue.getExprAST(ctx);
                AssignAST.Operator operAsn = switch (this.op.getId()) {
                    case Token.Id.ADD_ASN -> AssignAST.Operator.AddAsn;
                    case Token.Id.SUB_ASN -> AssignAST.Operator.SubAsn;
                    case Token.Id.MUL_ASN -> AssignAST.Operator.MulAsn;
                    case Token.Id.DIV_ASN -> AssignAST.Operator.DivAsn;
                    case Token.Id.MOD_ASN -> AssignAST.Operator.ModAsn;
                    case Token.Id.SHL_ASN -> AssignAST.Operator.ShiftLAsn;
                    case Token.Id.SHR_ASN -> AssignAST.Operator.ShiftRAsn;
                    case Token.Id.USHR_ASN -> AssignAST.Operator.UShiftRAsn;
                    case Token.Id.BIT_AND_ASN -> AssignAST.Operator.AndAsn;
                    case Token.Id.BIT_OR_ASN -> AssignAST.Operator.OrAsn;
                    case Token.Id.BIT_XOR_ASN -> AssignAST.Operator.XorAsn;
                    default -> throw new IllegalStateException("op=" + this.op.getId().TEXT);
                };
                if (LVal.isProperty() && (prop = (PropertyStructure)(idProp = LVal.getProperty()).getComponent()) != null && prop.isAtomic() && (idOp = this.findAtomicInPlaceAssignMethod(ctx, LVal.getType())) != null) {
                    UnaryOpExprAST astVar = new UnaryOpExprAST(astLValue, UnaryOpExprAST.Operator.Var, idProp.getRefType(null));
                    astAssign = new InvokeExprAST(idOp, TypeConstant.NO_TYPES, astVar, new ExprAST[]{astRValue}, false);
                    break;
                }
                TypeConstant typeTarget = astLValue.getType(0);
                TypeConstant typeArg = argRVal.getType();
                astAssign = new AssignAST(astLValue, operAsn, astRValue, this.findInPlaceAssignMethod(ctx, typeTarget, typeArg, errs));
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        if (astAssign != null) {
            ctx.getHolder().setAst(this, astAssign);
        }
        return fCompletes;
    }

    private MethodConstant findAtomicInPlaceAssignMethod(Context ctx, TypeConstant typeArg) {
        Expression expression = this.lvalueExpr;
        if (expression instanceof NameExpression) {
            String sMethod;
            NameExpression exprLValue = (NameExpression)expression;
            return exprLValue.findAtomicInPlaceAssignMethod(ctx, sMethod, switch (this.op.getId()) {
                case Token.Id.ADD_ASN -> {
                    sMethod = "addAssign";
                    yield "+=";
                }
                case Token.Id.SUB_ASN -> {
                    sMethod = "subAssign";
                    yield "-=";
                }
                case Token.Id.MUL_ASN -> {
                    sMethod = "mulAssign";
                    yield "*=";
                }
                case Token.Id.DIV_ASN -> {
                    sMethod = "divAssign";
                    yield "/=";
                }
                case Token.Id.MOD_ASN -> {
                    sMethod = "modAssign";
                    yield "%=";
                }
                case Token.Id.SHL_ASN -> {
                    sMethod = "shiftLeftAssign";
                    yield "<<=";
                }
                case Token.Id.SHR_ASN -> {
                    sMethod = "shiftRightAssign";
                    yield ">>=";
                }
                case Token.Id.USHR_ASN -> {
                    sMethod = "shiftAllRightAssign";
                    yield ">>>=";
                }
                case Token.Id.BIT_AND_ASN -> {
                    sMethod = "andAssign";
                    yield "&=";
                }
                case Token.Id.BIT_OR_ASN -> {
                    sMethod = "orAssign";
                    yield "|=";
                }
                case Token.Id.BIT_XOR_ASN -> {
                    sMethod = "xorAssign";
                    yield "^=";
                }
                default -> throw new IllegalStateException("op=" + this.op.getId().TEXT);
            }, typeArg);
        }
        return null;
    }

    private MethodConstant findInPlaceAssignMethod(Context ctx, TypeConstant typeTarget, TypeConstant typeArg, ErrorListener errs) {
        MethodConstant idOp;
        String sMethod;
        Set<MethodConstant> setMethods = typeTarget.ensureTypeInfo().findOpMethods(sMethod, switch (this.op.getId()) {
            case Token.Id.ADD_ASN -> {
                sMethod = "add";
                yield "+";
            }
            case Token.Id.SUB_ASN -> {
                sMethod = "sub";
                yield "-";
            }
            case Token.Id.MUL_ASN -> {
                sMethod = "mul";
                yield "*";
            }
            case Token.Id.DIV_ASN -> {
                sMethod = "div";
                yield "/";
            }
            case Token.Id.MOD_ASN -> {
                sMethod = "mod";
                yield "%";
            }
            case Token.Id.SHL_ASN -> {
                sMethod = "shiftLeft";
                yield "<<";
            }
            case Token.Id.SHR_ASN -> {
                sMethod = "shiftRight";
                yield ">>";
            }
            case Token.Id.USHR_ASN -> {
                sMethod = "shiftAllRight";
                yield ">>>";
            }
            case Token.Id.BIT_AND_ASN -> {
                sMethod = "and";
                yield "&";
            }
            case Token.Id.BIT_OR_ASN -> {
                sMethod = "or";
                yield "|";
            }
            case Token.Id.BIT_XOR_ASN -> {
                sMethod = "xor";
                yield "^";
            }
            default -> throw new IllegalStateException("op=" + this.op.getId().TEXT);
        }, 1);
        switch (setMethods.size()) {
            case 0: {
                MethodConstant methodConstant = null;
                break;
            }
            case 1: {
                MethodConstant methodConstant = setMethods.iterator().next();
                break;
            }
            default: {
                MethodConstant methodConstant = idOp = RelOpExpression.chooseBestMethod(setMethods, typeArg);
            }
        }
        if (idOp != null) {
            return idOp;
        }
        this.lvalueExpr.log(errs, Severity.ERROR, setMethods == null ? "COMPILER-67" : "COMPILER-69", this.op.getValueText(), typeTarget.getValueString());
        return null;
    }

    public static ExprAST combineLValueAST(ExprAST astLVal, ExprAST astLValExpr) {
        if (astLVal == null) {
            return astLValExpr;
        }
        if (!(astLVal instanceof MultiExprAST)) {
            return astLVal;
        }
        MultiExprAST astLValMulti = (MultiExprAST)astLVal;
        ExprAST[] aAstLVal = astLValMulti.getExprs();
        ExprAST[] aAstLValExpr = ((MultiExprAST)astLValExpr).getExprs();
        boolean fReplaced = false;
        int c = aAstLVal.length;
        for (int i = 0; i < c; ++i) {
            if (aAstLVal[i] != BinaryAST.POISON) continue;
            if (!fReplaced) {
                fReplaced = true;
                aAstLVal = (ExprAST[])aAstLVal.clone();
            }
            aAstLVal[i] = aAstLValExpr[i];
        }
        return fReplaced ? new MultiExprAST(aAstLVal) : astLVal;
    }

    private BiExpression createBiExpression(Expression exprLeft, Token opIP, Expression exprRight) {
        Token.Id idBi = switch (opIP.getId()) {
            case Token.Id.ADD_ASN -> Token.Id.ADD;
            case Token.Id.SUB_ASN -> Token.Id.SUB;
            case Token.Id.MUL_ASN -> Token.Id.MUL;
            case Token.Id.DIV_ASN -> Token.Id.DIV;
            case Token.Id.MOD_ASN -> Token.Id.MOD;
            case Token.Id.SHL_ASN -> Token.Id.SHL;
            case Token.Id.SHR_ASN -> Token.Id.SHR;
            case Token.Id.USHR_ASN -> Token.Id.USHR;
            case Token.Id.BIT_AND_ASN -> Token.Id.BIT_AND;
            case Token.Id.BIT_OR_ASN -> Token.Id.BIT_OR;
            case Token.Id.BIT_XOR_ASN -> Token.Id.BIT_XOR;
            case Token.Id.COND_AND_ASN -> Token.Id.COND_AND;
            case Token.Id.COND_OR_ASN -> Token.Id.COND_OR;
            case Token.Id.COND_ELSE_ASN -> Token.Id.COND_ELSE;
            default -> throw new IllegalStateException("op=" + opIP.getId().TEXT);
        };
        Token opBi = new Token(opIP.getStartPosition(), opIP.getEndPosition(), idBi);
        BiExpression exprResult = switch (idBi) {
            case Token.Id.ADD, Token.Id.SUB, Token.Id.MUL, Token.Id.DIV, Token.Id.MOD, Token.Id.SHL, Token.Id.SHR, Token.Id.USHR, Token.Id.BIT_AND, Token.Id.BIT_OR, Token.Id.BIT_XOR -> new RelOpExpression(exprLeft, opBi, exprRight);
            case Token.Id.COND_AND, Token.Id.COND_OR -> new CondOpExpression(exprLeft, opBi, exprRight);
            case Token.Id.COND_ELSE -> new ElvisExpression(exprLeft, opBi, exprRight);
            default -> throw new IllegalStateException("op=" + opBi.getId().TEXT);
        };
        exprResult.setParent(this);
        return exprResult;
    }

    private void merge(Context ctx, Context ctxLvalue) {
        if (ctx != ctxLvalue) {
            assert (ctxLvalue.getOuterContext() == ctx);
            ctxLvalue.exit();
        }
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.isNegated()) {
            sb.append("!(");
        }
        sb.append(this.lvalue).append(' ').append(this.op.getId().TEXT).append(' ').append(this.rvalue);
        if (this.isNegated()) {
            sb.append(')');
        }
        if (this.term) {
            sb.append(';');
        }
        return sb.toString();
    }

    @Override
    public String getDumpDesc() {
        return this.toString();
    }

    public static enum Category {
        Assign,
        InPlace,
        CondLeft,
        CondRight;

    }

    protected static class LValueContext
    extends Context {
        private boolean m_fInLValue;

        protected LValueContext(Context ctxOuter) {
            super(ctxOuter, false);
        }

        @Override
        protected Argument resolveRegisterType(Context.Branch branch, Register reg) {
            return this.m_fInLValue ? reg.getOriginalRegister() : reg;
        }

        @Override
        public Context exit() {
            String sName;
            Context ctxOuter = this.getOuterContext();
            for (Map.Entry<String, Assignment> entry : this.getDefiniteAssignments().entrySet()) {
                sName = entry.getKey();
                if (!this.isVarDeclaredInThisScope(sName)) continue;
                ctxOuter.setVarAssignment(sName, entry.getValue());
            }
            for (Map.Entry<String, Object> entry : this.getNameMap().entrySet()) {
                sName = entry.getKey();
                if (!this.isVarDeclaredInThisScope(sName)) continue;
                ctxOuter.replaceArgument(sName, Context.Branch.Always, (Argument)entry.getValue());
            }
            return super.exit();
        }

        protected LValueContext enterLValue() {
            this.m_fInLValue = true;
            return this;
        }
    }
}

