/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.compiler.ast;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.invoke.LambdaMetafactory;
import java.lang.reflect.Field;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.xvm.asm.Argument;
import org.xvm.asm.Component;
import org.xvm.asm.ComponentResolver;
import org.xvm.asm.Constant;
import org.xvm.asm.ConstantPool;
import org.xvm.asm.Constants;
import org.xvm.asm.ErrorListener;
import org.xvm.asm.GenericTypeResolver;
import org.xvm.asm.MethodStructure;
import org.xvm.asm.Parameter;
import org.xvm.asm.Register;
import org.xvm.asm.ast.ConstantExprAST;
import org.xvm.asm.ast.ExprAST;
import org.xvm.asm.constants.DynamicFormalConstant;
import org.xvm.asm.constants.FormalConstant;
import org.xvm.asm.constants.IdentityConstant;
import org.xvm.asm.constants.MethodConstant;
import org.xvm.asm.constants.PendingTypeConstant;
import org.xvm.asm.constants.PropertyConstant;
import org.xvm.asm.constants.SignatureConstant;
import org.xvm.asm.constants.TypeConstant;
import org.xvm.asm.constants.TypeInfo;
import org.xvm.asm.op.Label;
import org.xvm.compiler.Compiler;
import org.xvm.compiler.Source;
import org.xvm.compiler.Token;
import org.xvm.compiler.ast.Context;
import org.xvm.compiler.ast.Expression;
import org.xvm.compiler.ast.ImportStatement;
import org.xvm.compiler.ast.LabeledExpression;
import org.xvm.compiler.ast.LiteralExpression;
import org.xvm.compiler.ast.NameExpression;
import org.xvm.compiler.ast.NameResolver;
import org.xvm.compiler.ast.NonBindingExpression;
import org.xvm.compiler.ast.StageMgr;
import org.xvm.compiler.ast.StatementBlock;
import org.xvm.compiler.ast.TypeExpression;
import org.xvm.util.Handy;
import org.xvm.util.ListMap;
import org.xvm.util.Severity;

public abstract class AstNode
implements Cloneable {
    protected static final Field[] NO_FIELDS = new Field[0];
    private Compiler.Stage m_stage = Compiler.Stage.Initial;
    private AstNode m_parent;

    public AstNode getParent() {
        return this.m_parent;
    }

    protected void setParent(AstNode parent) {
        assert (parent == null || !this.isDiscarded() && !parent.isDiscarded());
        this.m_parent = parent;
    }

    protected void introduceParentage() {
        for (AstNode node : this.children()) {
            node.setParent(this);
            node.introduceParentage();
        }
    }

    protected void adopt(Iterable<? extends AstNode> children) {
        if (children != null) {
            for (AstNode astNode : children) {
                astNode.setParent(this);
            }
        }
    }

    protected <T extends AstNode> T adopt(T child) {
        if (child != null) {
            child.setParent(this);
        }
        return child;
    }

    public ChildIterator children() {
        Field[] fields = this.getChildFields();
        return fields.length == 0 ? ChildIterator.EMPTY : new ChildIteratorImpl(fields);
    }

    public void replaceChild(AstNode nodeOld, AstNode nodeNew) {
        ChildIterator children = this.children();
        for (AstNode node : children) {
            if (node != nodeOld) continue;
            children.replaceWith(this.adopt(nodeNew));
            return;
        }
        throw new IllegalStateException("no such child \"" + String.valueOf(nodeOld) + "\" on \"" + String.valueOf(this) + "\"");
    }

    public AstNode findChild(AstNode node) {
        AstNode parent;
        AstNode child = node;
        do {
            if ((parent = child.getParent()) != this) continue;
            return child;
        } while ((child = parent) != null);
        return null;
    }

    protected void discard(boolean fRecurse) {
        this.m_stage = Compiler.Stage.Discarded;
        if (fRecurse) {
            for (AstNode node : this.children()) {
                node.discard(true);
            }
        }
    }

    protected boolean isDiscarded() {
        return this.m_stage == Compiler.Stage.Discarded;
    }

    protected Field[] getChildFields() {
        return NO_FIELDS;
    }

    public AstNode clone() {
        AstNode that;
        try {
            that = (AstNode)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException(e);
        }
        for (Field field : this.getChildFields()) {
            ArrayList<AstNode> oVal;
            try {
                oVal = field.get(this);
            }
            catch (NullPointerException e) {
                throw new IllegalStateException("class=" + this.getClass().getSimpleName(), e);
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException(e);
            }
            if (oVal == null) continue;
            if (oVal instanceof AstNode) {
                AstNode node = (AstNode)((Object)oVal);
                AstNode nodeNew = node.clone();
                that.adopt(nodeNew);
                oVal = nodeNew;
            } else if (oVal instanceof List) {
                List list = oVal;
                ArrayList<AstNode> listNew = new ArrayList<AstNode>();
                for (AstNode node : list) {
                    listNew.add(node.clone());
                }
                that.adopt((AstNode)((Object)listNew));
                oVal = listNew;
            } else {
                throw new IllegalStateException("unsupported container type: " + oVal.getClass().getSimpleName());
            }
            try {
                field.set(that, oVal);
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException(e);
            }
        }
        return that;
    }

    public Compiler.Stage getStage() {
        return this.m_stage;
    }

    protected boolean alreadyReached(Compiler.Stage stage) {
        assert (stage != null);
        return this.getStage().compareTo(stage) >= 0;
    }

    protected void setStage(Compiler.Stage stage) {
        if (stage != null && stage.compareTo(this.m_stage) > 0) {
            this.m_stage = stage;
        }
    }

    public Source getSource() {
        AstNode parent = this.getParent();
        return parent == null ? null : parent.getSource();
    }

    public abstract long getStartPosition();

    public abstract long getEndPosition();

    void donateSource(MethodStructure method) {
        if (method != null) {
            long lStart = this.getStartPosition();
            long lEnd = this.getEndPosition();
            int iLine = Source.calculateLine(lStart);
            String sSrc = this.getSource().toString(lStart, lEnd);
            if (sSrc.startsWith("{") && sSrc.endsWith("}")) {
                sSrc = sSrc.substring(1, sSrc.length() - 1);
            }
            method.configureSource(sSrc, iLine);
        }
    }

    public boolean isComponentNode() {
        return false;
    }

    public Component getComponent() {
        AstNode parent = this.getParent();
        return parent == null ? null : parent.getComponent();
    }

    public ComponentResolver getComponentResolver() {
        return this.getComponent();
    }

    protected AstNode getCodeContainer() {
        AstNode parent = this.getParent();
        return parent == null ? null : parent.getCodeContainer();
    }

    protected int getCodeContainerCounter() {
        AstNode parent = this.getParent();
        return parent == null ? null : Integer.valueOf(parent.getCodeContainerCounter());
    }

    public StatementBlock getParentBlock() {
        for (AstNode parent = this.getParent(); parent != null; parent = parent.getParent()) {
            if (!(parent instanceof StatementBlock)) continue;
            StatementBlock block = (StatementBlock)parent;
            return block;
        }
        return null;
    }

    public boolean isAutoNarrowingAllowed(TypeExpression type) {
        return true;
    }

    public TypeConstant[] getReturnTypes() {
        throw this.notCodeContainer();
    }

    public boolean isReturnConditional() {
        throw this.notCodeContainer();
    }

    public void collectReturnTypes(TypeConstant[] atypeRet) {
        throw this.notCodeContainer();
    }

    protected RuntimeException notCodeContainer() {
        throw new IllegalStateException("not code container: " + this.getClass().getSimpleName());
    }

    protected boolean usesSuper() {
        return false;
    }

    public boolean isLValueSyntax() {
        return false;
    }

    public Expression getLValueExpression() {
        throw this.notLValue();
    }

    public void updateLValueFromRValueTypes(Context ctx, Context.Branch branch, boolean fCond, TypeConstant[] aTypes) {
        throw this.notLValue();
    }

    public void resetLValueTypes(Context ctx) {
        throw this.notLValue();
    }

    private RuntimeException notLValue() {
        assert (!this.isLValueSyntax());
        throw new IllegalStateException("not LValue: " + this.getClass().getSimpleName());
    }

    protected boolean isRValue(Expression exprChild) {
        return true;
    }

    protected boolean allowsConditional(Expression exprChild) {
        return false;
    }

    protected boolean allowsShortCircuit(AstNode nodeChild) {
        return false;
    }

    protected Label ensureShortCircuitLabel(AstNode nodeOrigin, Context ctxOrigin) {
        throw new IllegalStateException("no short circuit label for: " + this.getClass().getSimpleName());
    }

    protected void selectTraceableExpressions(Map<String, Expression> mapExprs) {
        for (AstNode node : this.children()) {
            if (node instanceof Expression) {
                String sExpr;
                Expression expr = (Expression)node;
                if (expr.isValidated() && expr.isTraceworthy() && !mapExprs.containsKey(sExpr = expr.toString())) {
                    mapExprs.put(sExpr, expr);
                }
                if (expr.isConstant()) continue;
            }
            node.selectTraceableExpressions(mapExprs);
        }
    }

    public boolean isCompletable() {
        return true;
    }

    public boolean isTodo() {
        return false;
    }

    protected ConstantPool pool() {
        AstNode nodeParent = this.getParent();
        return nodeParent == null ? null : nodeParent.pool();
    }

    public Constants.Access getDefaultAccess() {
        AstNode parent = this.getParent();
        return parent == null ? Constants.Access.PUBLIC : parent.getDefaultAccess();
    }

    public boolean log(ErrorListener errs, Severity severity, String sCode, Object ... aoParam) {
        Source source = this.getSource();
        return errs == null ? severity.ordinal() >= Severity.ERROR.ordinal() : errs.log(severity, sCode, aoParam, source, source == null ? 0L : this.getStartPosition(), source == null ? 0L : this.getEndPosition());
    }

    protected void registerStructures(StageMgr mgr, ErrorListener errs) {
    }

    public void resolveNames(StageMgr mgr, ErrorListener errs) {
    }

    public void validateContent(StageMgr mgr, ErrorListener errs) {
    }

    public void generateCode(StageMgr mgr, ErrorListener errs) {
    }

    protected void updateLineNumber(MethodStructure.Code code) {
        code.updateLineNumber(Source.calculateLine(this.getStartPosition()));
    }

    protected boolean catchUpChildren(ErrorListener errs) {
        Compiler.Stage stageTarget = this.getStage();
        if (!stageTarget.isTargetable() && !(stageTarget = stageTarget.prevTarget()).isTargetable()) {
            assert (stageTarget == Compiler.Stage.Initial);
            return true;
        }
        Enum stageOldest = null;
        ArrayList<AstNode> listChildren = new ArrayList<AstNode>();
        for (AstNode node : this.children()) {
            Compiler.Stage stage = node.getStage();
            if (stage.compareTo(stageTarget) >= 0) continue;
            listChildren.add(node);
            if (stageOldest == null) {
                stageOldest = stage;
                continue;
            }
            if (stage.compareTo(stageOldest) >= 0) continue;
            stageOldest = stage;
        }
        if (stageOldest == null) {
            return true;
        }
        ErrorListener errsTemp = errs.branch(this);
        while (stageOldest.compareTo(stageTarget) < 0) {
            Compiler.Stage stageNext = ((Compiler.Stage)stageOldest).nextTarget();
            StageMgr mgrKids = new StageMgr(listChildren, stageNext, errsTemp);
            int cTries = 0;
            while (!mgrKids.processComplete()) {
                if (errsTemp.isAbortDesired() || cTries > 20) {
                    mgrKids.logDeferredAsErrors(errsTemp);
                    errsTemp.merge();
                    return false;
                }
                if (cTries == 20) {
                    mgrKids.markLastAttempt();
                }
                ++cTries;
            }
            stageOldest = stageNext;
        }
        boolean fFailure = errsTemp.hasSeriousErrors();
        errsTemp.merge();
        return !fFailure;
    }

    protected ImportStatement resolveImportBySingleName(String sName, ErrorListener errs) {
        AstNode parent = this.getParent();
        return parent == null ? null : parent.resolveImportBySingleName(sName, errs);
    }

    protected boolean canResolveNames() {
        AstNode astNode = this;
        if (astNode instanceof NameResolver.NameResolving) {
            NameResolver.NameResolving resolver = (NameResolver.NameResolving)((Object)astNode);
            return !resolver.getNameResolver().isFirstTime();
        }
        return this.alreadyReached(Compiler.Stage.Resolving);
    }

    protected TypeConstant[] validateExpressions(Context ctx, List<Expression> listExpr, TypeConstant[] atypeRequired, ErrorListener errs) {
        int cReq = atypeRequired == null ? 0 : atypeRequired.length;
        int cExprs = listExpr.size();
        TypeConstant[] atype = new TypeConstant[cExprs];
        boolean fValid = true;
        for (int i = 0; i < cExprs; ++i) {
            TypeConstant typeRequired;
            Expression exprOld = listExpr.get(i);
            if (exprOld.isValidated()) {
                atype[i] = exprOld.getType();
                continue;
            }
            TypeConstant typeConstant = typeRequired = i < cReq ? atypeRequired[i] : null;
            if (typeRequired != null) {
                ctx = ctx.enterInferring(typeRequired);
            }
            Expression exprNew = exprOld.validate(ctx, typeRequired, errs);
            if (typeRequired != null) {
                ctx = ctx.exit();
            }
            if (exprNew == null) {
                fValid = false;
                continue;
            }
            if (exprNew != exprOld) {
                listExpr.set(i, exprNew);
            }
            if (exprNew.isSingle()) {
                atype[i] = exprNew.getType();
                continue;
            }
            if (cExprs == 1) {
                atype = exprNew.getTypes();
                continue;
            }
            if (i == cExprs - 1) {
                atype[i] = exprNew.getType();
                continue;
            }
            exprNew.log(errs, Severity.ERROR, "COMPILER-84", 1, exprNew.getValueCount());
            fValid = false;
        }
        return fValid ? atype : null;
    }

    protected MethodConstant findMethod(Context ctx, TypeConstant typeTarget, TypeInfo infoTarget, String sMethodName, List<Expression> listExprArgs, TypeInfo.MethodKind kind, boolean fCall, boolean fAllowNested, TypeConstant[] atypeReturn, ErrorListener errs) {
        Map<String, Expression> mapNamedExpr;
        assert (sMethodName != null && !sMethodName.isEmpty());
        int cExpr = listExprArgs == null ? 0 : listExprArgs.size();
        Map<String, Expression> map = mapNamedExpr = cExpr > 0 ? this.collectNamedArgs(listExprArgs, errs) : Collections.emptyMap();
        if (mapNamedExpr == null) {
            return null;
        }
        int cArgs = fCall ? cExpr : -1;
        Set<MethodConstant> setMethods = infoTarget.findMethods(sMethodName, cArgs, kind);
        ErrorListener errsTemp = errs.branch(this);
        if (fAllowNested) {
            IdentityConstant idScope = ctx.getMethod().getIdentityConstant();
            do {
                Set<MethodConstant> setNested;
                if (!infoTarget.containsNestedMultiMethod(idScope, sMethodName) || (setNested = infoTarget.findNestedMethods(idScope, sMethodName, cArgs)).isEmpty()) continue;
                if (setMethods.isEmpty()) {
                    setMethods = setNested;
                    continue;
                }
                setMethods = new HashSet<MethodConstant>(setMethods);
                setMethods.addAll(setNested);
            } while ((idScope = idScope.getNamespace()).isNested());
        }
        if (!setMethods.isEmpty()) {
            boolean fArgsComplete;
            HashSet<MethodConstant> setIs = new HashSet<MethodConstant>();
            HashSet<MethodConstant> setConvert = new HashSet<MethodConstant>();
            HashMap<MethodConstant, MethodStructure> mapMethods = new HashMap<MethodConstant, MethodStructure>();
            this.collectMatchingMethods(ctx, typeTarget, infoTarget, setMethods, listExprArgs, fCall, mapNamedExpr, atypeReturn, setIs, setConvert, mapMethods, errsTemp);
            boolean bl = fArgsComplete = cArgs == 0 || listExprArgs.stream().allMatch(AstNode::isCompletable);
            if (!setIs.isEmpty()) {
                return fArgsComplete ? this.chooseBest(setIs, typeTarget, mapMethods, errs) : (MethodConstant)setIs.iterator().next();
            }
            if (!setConvert.isEmpty()) {
                return fArgsComplete ? this.chooseBest(setConvert, typeTarget, mapMethods, errs) : (MethodConstant)setConvert.iterator().next();
            }
        }
        if (errsTemp.hasSeriousErrors()) {
            errsTemp.merge();
        } else {
            if (!typeTarget.isAccessSpecified() && typeTarget.isAccessModifiable() && !typeTarget.ensureAccess(Constants.Access.PRIVATE).ensureTypeInfo(errs).findMethods(sMethodName, cArgs, kind).isEmpty()) {
                this.log(errs, Severity.ERROR, "COMPILER-177", sMethodName, typeTarget.getValueString());
                return null;
            }
            if (kind == TypeInfo.MethodKind.Constructor) {
                this.log(errs, Severity.ERROR, "COMPILER-65", typeTarget.getValueString());
            } else {
                this.log(errs, Severity.ERROR, "COMPILER-56", sMethodName, typeTarget.getValueString());
            }
        }
        return null;
    }

    protected boolean containsNamedArgs(List<Expression> listExprArgs) {
        for (Expression exprArg : listExprArgs) {
            if (!(exprArg instanceof LabeledExpression)) continue;
            return true;
        }
        return false;
    }

    protected Map<String, Expression> collectNamedArgs(List<Expression> listExprArgs, ErrorListener errs) {
        HashMap<String, LabeledExpression> mapNamed = null;
        int cExpr = listExprArgs.size();
        for (int i = 0; i < cExpr; ++i) {
            Expression exprArg = listExprArgs.get(i);
            if (exprArg instanceof LabeledExpression) {
                LabeledExpression exprLabel = (LabeledExpression)exprArg;
                String sName = exprLabel.getName();
                if (mapNamed == null) {
                    mapNamed = new HashMap<String, LabeledExpression>(cExpr);
                } else if (mapNamed.containsKey(sName)) {
                    exprArg.log(errs, Severity.ERROR, "COMPILER-31", sName);
                    return null;
                }
                mapNamed.put(sName, exprLabel);
                continue;
            }
            if (mapNamed == null) continue;
            exprArg.log(errs, Severity.ERROR, "COMPILER-60", i);
            return null;
        }
        return mapNamed == null ? Collections.emptyMap() : mapNamed;
    }

    /*
     * Unable to fully structure code
     */
    private void collectMatchingMethods(Context ctx, TypeConstant typeTarget, TypeInfo infoTarget, Set<MethodConstant> setMethods, List<Expression> listExprArgs, boolean fCall, Map<String, Expression> mapNamedExpr, TypeConstant[] atypeReturn, Set<MethodConstant> setIs, Set<MethodConstant> setConvert, Map<MethodConstant, MethodStructure> mapMethods, ErrorListener errs) {
        pool = this.pool();
        cExprs = listExprArgs == null ? 0 : listExprArgs.size();
        cReturns = atypeReturn == null ? 0 : atypeReturn.length;
        cNamed = mapNamedExpr.size();
        errsTemp = errs.branch(this);
        errsKeep = null;
        cNameErrs = 0;
        cArityErrs = 0;
        cTypeErrs = 0;
        block0: for (MethodConstant idMethod : setMethods) {
            infoMethod = infoTarget.getMethodById(idMethod);
            method = infoMethod.getTopmostMethodStructure(infoTarget);
            sigMethod = idMethod.getSignature();
            cTypeParams = method.getTypeParamCount();
            cVisible = method.getVisibleParamCount();
            cRequired = method.getRequiredParamCount();
            if (cExprs > cVisible || fCall && cExprs < cRequired) {
                if (cNameErrs != 0 || cArityErrs++ != 0 || cTypeErrs != 0) continue;
                errsKeep = errs.branch(this);
                this.log(errsKeep, Severity.ERROR, "COMPILER-84", new Object[]{cRequired, cExprs});
                continue;
            }
            cMethodRets = method.getReturnCount();
            if (cReturns > cMethodRets) {
                v0 = fTuple = cReturns == 1 && AstNode.isVoid(atypeReturn) != false;
                if (cMethodRets != 0 || !fTuple) {
                    if (cNameErrs != 0 || cArityErrs++ != 0 || cTypeErrs != 0) continue;
                    errsKeep = errs.branch(this);
                    this.log(errsKeep, Severity.ERROR, "COMPILER-152", new Object[]{sigMethod.getValueString(), cReturns, cMethodRets});
                    continue;
                }
            }
            listArgs = listExprArgs;
            cArgs = cExprs;
            if (cArgs > 0 && cNamed > 0) {
                if ((listArgs = this.rearrangeNamedArgs(method, listArgs, mapNamedExpr, errsTemp)) == null) {
                    if (cNameErrs++ != 0) continue;
                    errsKeep = errsTemp;
                    continue;
                }
                cArgs = listArgs.size();
                if (fCall) {
                    for (i = 0; i < cRequired; ++i) {
                        if (listArgs.get(i) instanceof NonBindingExpression) continue block0;
                    }
                }
            }
            atypeArgs = new TypeConstant[cArgs];
            for (i = 0; i < cArgs; ++i) {
                exprArg = listArgs.get(i);
                atypeArgs[i] = exprArg.isValidated() != false ? exprArg.getType() : exprArg.getImplicitType(ctx);
            }
            if (cTypeParams > 0) {
                mapTypeParams = method.resolveTypeParameters(pool, typeTarget, atypeArgs = this.transformTypeArguments(ctx, listArgs, atypeArgs), atypeReturn, true);
                if (mapTypeParams.size() < cTypeParams) continue;
                sigMethod = sigMethod.resolveGenericTypes(pool, GenericTypeResolver.of(mapTypeParams));
            }
            atypeParam = sigMethod.getRawParams();
            fit = Expression.TypeFit.Fit;
            fExact = true;
            for (i = 0; i < cArgs; ++i) {
                block32: {
                    block31: {
                        exprArg = listArgs.get(i);
                        typeParam = atypeParam[cTypeParams + i];
                        typeArg = atypeArgs[i];
                        if (typeParam != null) {
                            ctx = ctx.enterInferring(typeParam);
                        }
                        v1 = typeExpr = exprArg.isValidated() != false ? exprArg.getType() : exprArg.getImplicitType(ctx);
                        if (typeExpr != null && typeExpr.isA(typeParam)) {
                            fit = Expression.TypeFit.Fit;
                            fExact = typeExpr.equals(typeParam);
                        } else {
                            fit = exprArg.testFit(ctx, typeParam, true, errsTemp);
                            fExact = false;
                        }
                        if (!fit.isFit()) break block31;
                        if (typeArg == null) {
                            typeArg = typeExpr;
                        } else if (typeExpr != null && !typeArg.equals(typeExpr)) {
                            typeArg = typeArg.isA(typeExpr) != false ? typeArg : (typeExpr.isA(typeArg) != false ? typeExpr : null);
                        }
                        atypeArgs[i] = typeArg;
                        break block32;
                    }
                    if (typeParam == null || errsTemp.hasSeriousErrors()) break block32;
                    if (!(exprArg instanceof LiteralExpression)) ** GOTO lbl-1000
                    lit = (LiteralExpression)exprArg;
                    if (typeParam.isA(pool.typeFileNode()) && lit.getLiteral().getId() == Token.Id.LIT_PATH) {
                        this.log(errsTemp, Severity.ERROR, "COMPILER-200", new Object[]{String.valueOf(i + 1), method.getParam(i).getName(), lit.getLiteral().getValueText()});
                    } else lbl-1000:
                    // 2 sources

                    {
                        if (exprArg instanceof NameExpression) {
                            exprName = (NameExpression)exprArg;
                            typeExpr = exprName.getImplicitType(ctx, typeParam, ErrorListener.BLACKHOLE);
                        }
                        this.log(errsTemp, Severity.ERROR, "COMPILER-150", new Object[]{String.valueOf(i + 1), method.getParam(i).getName(), method.getIdentityConstant().getSignature().removeAutoNarrowing().getValueString(), typeParam.removeAutoNarrowing().getValueString(), typeExpr == null ? exprArg.toString() : typeExpr.removeAutoNarrowing().getValueString()});
                    }
                }
                if (typeParam != null) {
                    ctx = ctx.exit();
                }
                if (!fit.isFit()) break;
            }
            if (fit.isFit() && cTypeParams > 0) {
                mapTypeParams = method.resolveTypeParameters(pool, typeTarget, atypeArgs, atypeReturn, true);
                if (mapTypeParams.size() < cTypeParams) {
                    this.log(errsTemp, Severity.ERROR, "COMPILER-145", new Object[]{method.collectUnresolvedTypeParameters(mapTypeParams.keySet().stream().map((Function<FormalConstant, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getName(), (Lorg/xvm/asm/constants/FormalConstant;)Ljava/lang/String;)()).collect(Collectors.toSet()))});
                    fit = Expression.TypeFit.NoFit;
                } else {
                    sigMethod = sigMethod.resolveGenericTypes(pool, GenericTypeResolver.of(mapTypeParams));
                }
            }
            if (fit.isFit() && cReturns > 0) {
                fit = this.calculateReturnFit(sigMethod, fCall, atypeReturn, typeTarget, errsTemp);
            }
            if (!fit.isFit()) {
                if (!errsTemp.hasSeriousErrors()) continue;
                if (cNameErrs == 0 && cTypeErrs++ == 0) {
                    errsKeep = errsTemp;
                }
                errsTemp = errs.branch(this);
                continue;
            }
            if (fExact) {
                setConvert.clear();
                setIs.clear();
                mapMethods.clear();
            }
            if (fit.isConverting()) {
                setConvert.add(idMethod);
            } else {
                setIs.add(idMethod);
            }
            mapMethods.put(idMethod, method);
            if (!fExact) continue;
            return;
        }
        if (cNameErrs > 0 || cTypeErrs == 1 || cTypeErrs == 0 && cArityErrs == 1) {
            errsKeep.merge();
        }
    }

    protected TypeConstant[] transformTypeArguments(Context ctx, List<Expression> listArgs, TypeConstant[] atypeArgs) {
        assert (listArgs.size() == atypeArgs.length);
        TypeConstant typeObj = this.pool().typeObject();
        int cArgs = atypeArgs.length;
        for (int i = 0; i < cArgs; ++i) {
            NameExpression exprName;
            Expression expression;
            TypeConstant type = atypeArgs[i];
            if (type != null && type.isTypeOfType() && type.getParamType(0).equals(typeObj) && (expression = listArgs.get(i)) instanceof NameExpression && (exprName = (NameExpression)expression).getMeaning() == NameExpression.Meaning.Variable) {
                type = this.transformType(ctx, exprName);
            }
            atypeArgs[i] = type;
        }
        return atypeArgs;
    }

    protected TypeConstant transformType(Context ctx, NameExpression exprName) {
        ConstantPool pool = this.pool();
        TypeConstant type = pool.typeType();
        Argument arg = exprName.resolveRawArgument(ctx, false, ErrorListener.BLACKHOLE);
        if (arg instanceof Register) {
            Register reg = (Register)arg;
            PropertyConstant idProp = type.ensureTypeInfo().findProperty("DataType").getIdentity();
            DynamicFormalConstant idFormal = pool.ensureDynamicFormal(ctx.getMethod().getIdentityConstant(), reg, idProp, exprName.getName());
            type = pool.ensureParameterizedTypeConstant(type, idFormal.getType());
        }
        return type;
    }

    protected List<Expression> rearrangeNamedArgs(MethodStructure method, List<Expression> listExprArgs, ErrorListener errs) {
        Map<String, Expression> mapNamedExpr = this.collectNamedArgs(listExprArgs, errs);
        return mapNamedExpr == null ? null : this.rearrangeNamedArgs(method, listExprArgs, mapNamedExpr, errs);
    }

    protected List<Expression> rearrangeNamedArgs(MethodStructure method, List<Expression> listExprArgs, Map<String, Expression> mapNamedExpr, ErrorListener errs) {
        int cTypeParams = method.getTypeParamCount();
        int cParams = method.getVisibleParamCount();
        int cArgs = listExprArgs.size();
        int cNamed = mapNamedExpr.size();
        int cUnnamed = cArgs - cNamed;
        Expression[] aexpr = new Expression[cParams];
        for (int i = 0; i < cUnnamed; ++i) {
            aexpr[i] = listExprArgs.get(i);
        }
        for (String sName : mapNamedExpr.keySet()) {
            Parameter param = method.getParam(sName);
            if (param == null) {
                this.log(errs, Severity.ERROR, "COMPILER-38", sName);
                return null;
            }
            int iParam = param.getIndex() - cTypeParams;
            if (iParam < cUnnamed) {
                this.log(errs, Severity.ERROR, "COMPILER-85", sName);
                return null;
            }
            aexpr[iParam] = mapNamedExpr.get(sName);
        }
        long lPos = this.getStartPosition();
        for (int i = cUnnamed; i < cParams; ++i) {
            if (aexpr[i] != null) continue;
            NonBindingExpression exprNB = new NonBindingExpression(lPos, lPos, null);
            this.adopt(exprNB);
            exprNB.setStage(Compiler.Stage.Validated);
            aexpr[i] = exprNB;
        }
        return Arrays.asList(aexpr);
    }

    protected MethodConstant chooseBest(Set<MethodConstant> setMethods, TypeConstant typeTarget, Map<MethodConstant, MethodStructure> mapMethods, ErrorListener errs) {
        assert (!setMethods.isEmpty());
        MethodConstant idBest = null;
        for (MethodConstant idMethod : setMethods) {
            boolean fNewBetter;
            boolean fOldBetter;
            int cParamsNew;
            if (idBest == null) {
                idBest = idMethod;
                continue;
            }
            SignatureConstant sigOld = this.truncateSignature(idBest, mapMethods.get(idBest));
            SignatureConstant sigNew = this.truncateSignature(idMethod, mapMethods.get(idMethod));
            int cParamsOld = sigOld.getParamCount();
            if (cParamsOld == (cParamsNew = sigNew.getParamCount())) {
                fOldBetter = sigNew.isSubstitutableFor(sigOld, typeTarget);
                fNewBetter = sigOld.isSubstitutableFor(sigNew, typeTarget);
                if (!fOldBetter && !fNewBetter) {
                    for (int i = 0; i < cParamsOld; ++i) {
                        TypeConstant typeNew;
                        TypeConstant typeOld = sigOld.getRawParams()[i];
                        if (typeOld.isA(typeNew = sigNew.getRawParams()[i]) && !typeNew.isA(typeOld)) {
                            fOldBetter = true;
                        }
                        if (typeNew.isA(typeOld) && !typeOld.isA(typeNew)) {
                            fNewBetter = true;
                        }
                        if (!fNewBetter || !fOldBetter) continue;
                        fNewBetter = false;
                        fOldBetter = false;
                        break;
                    }
                }
            } else {
                fNewBetter = cParamsNew < cParamsOld;
                boolean bl = fOldBetter = !fNewBetter;
            }
            if (fOldBetter || fNewBetter) {
                if (!fNewBetter) continue;
                idBest = idMethod;
                continue;
            }
            this.log(errs, Severity.ERROR, "COMPILER-63", idBest.getSignature().removeAutoNarrowing().getValueString());
            return null;
        }
        return idBest;
    }

    private SignatureConstant truncateSignature(MethodConstant idMethod, MethodStructure method) {
        SignatureConstant sig = idMethod.getSignature();
        int c = method.getTypeParamCount();
        return c > 0 ? sig.truncateParams(c, -1) : sig;
    }

    protected Expression.TypeFit calculateReturnFit(SignatureConstant sigMethod, boolean fCall, TypeConstant[] atypeReturn, TypeConstant typeCtx, ErrorListener errs) {
        return this.calculateReturnFit(sigMethod.getRawReturns(), sigMethod.getValueString(), fCall, atypeReturn, typeCtx, errs);
    }

    protected Expression.TypeFit calculateReturnFit(TypeConstant[] atypeMethodReturn, String sName, boolean fCall, TypeConstant[] atypeReturn, TypeConstant typeCtx, ErrorListener errs) {
        int cMethodReturns = atypeMethodReturn.length;
        int cReturns = atypeReturn.length;
        Expression.TypeFit fit = Expression.TypeFit.Fit;
        if (cMethodReturns < cReturns) {
            if (cMethodReturns == 0 && cReturns == 1 && AstNode.isVoid(atypeReturn)) {
                return Expression.TypeFit.Pack;
            }
            this.log(errs, Severity.ERROR, "COMPILER-152", sName, String.valueOf(cReturns), String.valueOf(cMethodReturns));
            return Expression.TypeFit.NoFit;
        }
        if (cMethodReturns > cReturns) {
            if (cReturns == 1 && atypeReturn[0].isTuple()) {
                fit = fit.addPack();
                atypeReturn = atypeReturn[0].getParamTypesArray();
                cReturns = atypeReturn.length;
            }
            if (cMethodReturns < cReturns) {
                this.log(errs, Severity.ERROR, "COMPILER-152", sName, String.valueOf(cReturns), String.valueOf(cMethodReturns));
                return Expression.TypeFit.NoFit;
            }
        }
        for (int i = 0; i < cReturns; ++i) {
            TypeConstant typeMethodReturn = atypeMethodReturn[i];
            TypeConstant typeReturn = atypeReturn[i];
            if (typeMethodReturn.isCovariantReturn(typeReturn, typeCtx)) continue;
            if (typeMethodReturn.getConverterTo(typeReturn) != null) {
                fit = fit.addConversion();
                continue;
            }
            if (fCall && cReturns == 1 && cMethodReturns == 1 && typeReturn.isTuple() && typeReturn.getParamsCount() <= 1 && typeMethodReturn.isCovariantReturn(typeReturn.getParamType(0), typeCtx)) {
                return Expression.TypeFit.Pack;
            }
            this.log(errs, Severity.ERROR, "COMPILER-151", sName, typeReturn.getValueString(), typeMethodReturn.getValueString());
            return Expression.TypeFit.NoFit;
        }
        return fit;
    }

    protected static boolean isPending(TypeConstant ... atype) {
        for (TypeConstant type : atype) {
            if (type instanceof PendingTypeConstant) continue;
            return false;
        }
        return true;
    }

    protected static boolean isVoid(TypeConstant ... atype) {
        for (TypeConstant type : atype) {
            if (type.isTuple() && type.getParamsCount() <= 0) continue;
            return false;
        }
        return true;
    }

    protected static ExprAST toTypeParameterAst(Context ctx, Argument arg) {
        if (arg instanceof TypeConstant) {
            FormalConstant constFormal;
            ExprAST ast;
            TypeConstant type = (TypeConstant)arg;
            assert (type.isTypeOfType());
            TypeConstant typeData = type.getParamType(0);
            if (typeData.isFormalType() && (ast = (constFormal = (FormalConstant)typeData.getDefiningConstant()).toExprAst(ctx)) != null) {
                return ast;
            }
        }
        return AstNode.toExprAst(arg);
    }

    protected static ExprAST toExprAst(Argument arg) {
        if (arg instanceof Register) {
            Register reg = (Register)arg;
            return reg.getRegisterAST();
        }
        if (arg instanceof Constant) {
            Constant constant = (Constant)arg;
            return new ConstantExprAST(constant);
        }
        throw new UnsupportedOperationException(arg.toString());
    }

    protected TypeInfo ensureTypeInfo(TypeConstant type, ErrorListener errs) {
        errs = errs.branch(this);
        TypeInfo info = type.ensureTypeInfo(errs);
        errs.merge();
        return info;
    }

    public abstract String toString();

    public String toDumpString() {
        StringWriter sw = new StringWriter();
        this.dump(new PrintWriter(sw), "", "");
        return sw.toString();
    }

    public void dump() {
        this.dump(new PrintWriter(System.out, true), "", "");
    }

    protected void dump(PrintWriter out, String sIndentFirst, String sIndent) {
        Map<String, Object> cats = this.getDumpChildren();
        Iterator<Map.Entry<String, Object>> iter = cats.entrySet().iterator();
        while (iter.hasNext()) {
            Object value;
            Map.Entry<String, Object> entry = iter.next();
            Object object = value = entry.getValue();
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Map.class, Collection.class, Object[].class}, (Object)object, n)) {
                case -1: {
                    iter.remove();
                    break;
                }
                case 0: {
                    Map map = (Map)object;
                    if (!map.isEmpty()) break;
                    iter.remove();
                    break;
                }
                case 1: {
                    Collection coll = (Collection)object;
                    if (!coll.isEmpty()) break;
                    iter.remove();
                    break;
                }
                case 2: {
                    Object[] ao = (Object[])object;
                    if (ao.length != 0) break;
                    iter.remove();
                    break;
                }
            }
        }
        if (!sIndentFirst.isEmpty()) {
            out.print(sIndentFirst + "- ");
        }
        out.print(this.getClass().getSimpleName());
        String sThis = this.getDumpDesc();
        if (sThis == null || sThis.isEmpty()) {
            out.println();
        } else if (sThis.indexOf(10) < 0) {
            out.println(": " + sThis);
        } else {
            out.println();
            out.println(Handy.indentLines(sThis, sIndent + (cats.isEmpty() ? "      " : " |    ")));
        }
        String sIndentCat = sIndent + "   |- ";
        String sIndentKid = sIndent + "   |   |";
        String sIndentLastC = sIndent + "       |";
        String sIndentLastK = sIndent + "        ";
        int cCats = 0;
        for (Map.Entry<String, Object> entry : cats.entrySet()) {
            int cKids;
            boolean fLastC = ++cCats == cats.size();
            String sCat = entry.getKey();
            Object value = entry.getValue();
            out.print(sIndentCat + sCat);
            Object object = value;
            int n = 0;
            Iterator<Object> iterK = switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Map.class, Collection.class, Object[].class}, (Object)object, n)) {
                case 0 -> {
                    Map kids = (Map)object;
                    cKids = kids.size();
                    yield kids.entrySet().iterator();
                }
                case 1 -> {
                    Collection kids = (Collection)object;
                    cKids = kids.size();
                    yield kids.iterator();
                }
                case 2 -> {
                    Object[] kids = (Object[])object;
                    cKids = kids.length;
                    yield Arrays.asList(kids).iterator();
                }
                default -> {
                    cKids = 1;
                    yield Collections.singletonList(value).iterator();
                }
            };
            for (int i = 0; i < cKids; ++i) {
                String sIndent2;
                String sIndent1;
                Object kid = iterK.next();
                boolean fFirstK = i == 0;
                boolean fLastK = i == cKids - 1;
                String string = sIndent1 = fLastC ? sIndentLastC : sIndentKid;
                String string2 = fLastC ? (fLastK ? sIndentLastK : sIndentLastC) : (sIndent2 = sIndentKid);
                if (kid instanceof AstNode) {
                    AstNode node = (AstNode)kid;
                    if (fFirstK) {
                        out.println();
                    }
                    node.dump(out, sIndent1, sIndent2);
                    continue;
                }
                if (kid instanceof Map.Entry) {
                    if (fFirstK) {
                        out.println();
                    }
                    throw new UnsupportedOperationException("TODO");
                }
                Object sKid = String.valueOf(kid);
                if (((String)sKid).indexOf(10) < 0) {
                    if (cKids == 1) {
                        out.print(": ");
                    } else {
                        if (fFirstK) {
                            out.println();
                        }
                        out.print(sIndent1 + "- ");
                    }
                } else {
                    if (fFirstK) {
                        out.println();
                    }
                    sKid = Handy.indentLines((String)sKid, sIndent2 + "  ");
                    sKid = sIndent1 + "- " + ((String)sKid).substring(sIndent1.length() + 2);
                }
                out.println((String)sKid);
            }
        }
    }

    public String getDumpDesc() {
        return null;
    }

    public Map<String, Object> getDumpChildren() {
        Field[] fields = this.getChildFields();
        if (fields.length == 0) {
            return Collections.emptyMap();
        }
        ListMap<String, Object> map = new ListMap<String, Object>();
        for (Field field : fields) {
            try {
                map.put(field.getName(), field.get(this));
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException(e);
            }
        }
        return map;
    }

    protected UnsupportedOperationException notImplemented() {
        throw new UnsupportedOperationException("not implemented by: " + this.getClass().getSimpleName());
    }

    protected static <T> ArrayList<T> ensureArrayList(List<T> list) {
        ArrayList<T> arrayList;
        if (list instanceof ArrayList) {
            ArrayList alist = (ArrayList)list;
            arrayList = alist;
        } else {
            arrayList = new ArrayList<T>(list);
        }
        return arrayList;
    }

    protected static Field[] fieldsForNames(Class clz, String ... names) {
        if (names == null || names.length == 0) {
            return NO_FIELDS;
        }
        Field[] fields = new Field[names.length];
        int c = fields.length;
        block3: for (int i = 0; i < c; ++i) {
            NoSuchFieldException eOrig = null;
            for (Class clzTry = clz; clzTry != null; clzTry = clzTry.getSuperclass()) {
                try {
                    Field field = clzTry.getDeclaredField(names[i]);
                    assert (field != null);
                    if (!field.getType().isInstance(AstNode.class) && field.getType().isInstance(List.class)) {
                        throw new IllegalStateException("unsupported field type " + field.getType().getSimpleName() + " on field " + clzTry.getSimpleName() + "." + names[i]);
                    }
                    fields[i] = field;
                    continue block3;
                }
                catch (NoSuchFieldException e) {
                    if (eOrig != null) continue;
                    eOrig = e;
                    if (clz != null) continue;
                    throw new IllegalStateException(eOrig);
                }
                catch (SecurityException e) {
                    throw new IllegalStateException(e);
                }
            }
        }
        return fields;
    }

    public static interface ChildIterator
    extends Iterable<AstNode>,
    Iterator<AstNode> {
        public static final ChildIterator EMPTY = new ChildIterator(){

            @Override
            public boolean hasNext() {
                return false;
            }

            @Override
            public AstNode next() {
                throw new NoSuchElementException();
            }
        };

        @Override
        default public Iterator<AstNode> iterator() {
            return this;
        }

        default public void replaceWith(AstNode nodeNew) {
            throw new IllegalStateException();
        }
    }

    protected final class ChildIteratorImpl
    implements ChildIterator {
        private static final int NOT_PREP = 0;
        private static final int HAS_NEXT = 1;
        private static final int HAS_PREV = 2;
        private final Field[] fields;
        private int iField = -1;
        private Object value;
        private int state = 0;

        private ChildIteratorImpl(Field[] fields) {
            this.fields = fields;
        }

        @Override
        public boolean hasNext() {
            return this.state == 1 || this.prepareNextElement();
        }

        @Override
        public AstNode next() {
            if (this.state == 1 || this.prepareNextElement()) {
                this.state = 2;
                Object object = this.value;
                if (object instanceof AstNode) {
                    AstNode node = (AstNode)object;
                    return node;
                }
                return (AstNode)((Iterator)this.value).next();
            }
            throw new NoSuchElementException();
        }

        private boolean prepareNextElement() {
            Iterator iter;
            Object object = this.value;
            if (object instanceof Iterator && (iter = (Iterator)object).hasNext()) {
                this.state = 1;
                return true;
            }
            boolean prepped = this.prepareNextField();
            this.state = prepped ? 1 : 0;
            return prepped;
        }

        private boolean prepareNextField() {
            while (++this.iField < this.fields.length) {
                Object next;
                try {
                    next = this.fields[this.iField].get(AstNode.this);
                }
                catch (NullPointerException e) {
                    throw new IllegalStateException("class=" + AstNode.this.getClass().getSimpleName() + ", field=" + this.iField);
                }
                catch (IllegalAccessException e) {
                    throw new IllegalStateException(e);
                }
                if (next == null) continue;
                if (next instanceof List) {
                    List list = (List)next;
                    if (list.isEmpty()) continue;
                    this.value = list.listIterator();
                    return true;
                }
                if (next instanceof Collection) {
                    Collection coll = (Collection)next;
                    if (coll.isEmpty()) continue;
                    this.value = coll.iterator();
                    return true;
                }
                assert (next instanceof AstNode);
                this.value = next;
                return true;
            }
            this.value = null;
            return false;
        }

        @Override
        public void remove() {
            if (this.state == 2) {
                if (this.value instanceof AstNode) {
                    try {
                        this.fields[this.iField].set(AstNode.this, null);
                    }
                    catch (IllegalAccessException e) {
                        throw new IllegalStateException(e);
                    }
                    this.state = 0;
                    return;
                }
                Object object = this.value;
                if (object instanceof Iterator) {
                    Iterator iter = (Iterator)object;
                    iter.remove();
                    this.state = 0;
                    return;
                }
            }
            throw new IllegalStateException();
        }

        @Override
        public void replaceWith(AstNode newChild) {
            if (this.state == 2) {
                if (this.value instanceof AstNode) {
                    try {
                        this.fields[this.iField].set(AstNode.this, newChild);
                    }
                    catch (IllegalAccessException e) {
                        throw new IllegalStateException(e);
                    }
                    return;
                }
                Object object = this.value;
                if (object instanceof ListIterator) {
                    ListIterator iter = (ListIterator)object;
                    iter.set(newChild);
                    return;
                }
            }
            throw new IllegalStateException();
        }
    }
}

