/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.compiler.ast;

import java.lang.reflect.Field;
import org.xvm.asm.ast.BiExprAST;
import org.xvm.asm.ast.CondOpExprAST;
import org.xvm.asm.ast.DivRemExprAST;
import org.xvm.asm.ast.ExprAST;
import org.xvm.asm.ast.RelOpExprAST;
import org.xvm.asm.constants.TypeConstant;
import org.xvm.compiler.Token;
import org.xvm.compiler.ast.Context;
import org.xvm.compiler.ast.Expression;

public abstract class BiExpression
extends Expression {
    protected Expression expr1;
    protected Token operator;
    protected Expression expr2;
    private static final Field[] CHILD_FIELDS = BiExpression.fieldsForNames(BiExpression.class, "expr1", "expr2");

    public BiExpression(Expression expr1, Token operator, Expression expr2) {
        this.expr1 = expr1;
        this.operator = operator;
        this.expr2 = expr2;
    }

    public Expression getExpression1() {
        return this.expr1;
    }

    public Token getOperator() {
        return this.operator;
    }

    public Expression getExpression2() {
        return this.expr2;
    }

    @Override
    public long getStartPosition() {
        return this.expr1.getStartPosition();
    }

    @Override
    public long getEndPosition() {
        return this.expr2.getEndPosition();
    }

    @Override
    protected Field[] getChildFields() {
        return CHILD_FIELDS;
    }

    @Override
    public boolean isShortCircuiting() {
        return this.expr1.isShortCircuiting() || this.expr2.isShortCircuiting();
    }

    @Override
    public boolean isCompletable() {
        return this.expr1.isCompletable() && this.expr2.isCompletable();
    }

    @Override
    public ExprAST getExprAST(Context ctx) {
        BiExprAST.Operator op;
        ExprAST ast1 = this.expr1.getExprAST(ctx);
        ExprAST ast2 = this.expr2.getExprAST(ctx);
        switch (this.operator.getId()) {
            case DIVREM: {
                return new DivRemExprAST(this.getTypes(), ast1, ast2);
            }
            case COND_XOR: {
                return new CondOpExprAST(ast1, BiExprAST.Operator.CondXor, ast2);
            }
            case COLON: {
                op = BiExprAST.Operator.Else;
                break;
            }
            case COND_ELSE: {
                op = BiExprAST.Operator.CondElse;
                break;
            }
            case BIT_OR: {
                op = BiExprAST.Operator.BitOr;
                break;
            }
            case BIT_XOR: {
                op = BiExprAST.Operator.BitXor;
                break;
            }
            case BIT_AND: {
                op = BiExprAST.Operator.BitAnd;
                break;
            }
            case I_RANGE_I: {
                op = BiExprAST.Operator.RangeII;
                break;
            }
            case E_RANGE_I: {
                op = BiExprAST.Operator.RangeEI;
                break;
            }
            case I_RANGE_E: {
                op = BiExprAST.Operator.RangeIE;
                break;
            }
            case E_RANGE_E: {
                op = BiExprAST.Operator.RangeEE;
                break;
            }
            case SHL: {
                op = BiExprAST.Operator.Shl;
                break;
            }
            case SHR: {
                op = BiExprAST.Operator.Shr;
                break;
            }
            case USHR: {
                op = BiExprAST.Operator.Ushr;
                break;
            }
            case ADD: {
                op = BiExprAST.Operator.Add;
                break;
            }
            case SUB: {
                op = BiExprAST.Operator.Sub;
                break;
            }
            case MUL: {
                op = BiExprAST.Operator.Mul;
                break;
            }
            case DIV: {
                op = BiExprAST.Operator.Div;
                break;
            }
            case MOD: {
                op = BiExprAST.Operator.Mod;
                break;
            }
            case AS: {
                op = BiExprAST.Operator.As;
                break;
            }
            default: {
                throw new UnsupportedOperationException(this.operator.getValueText());
            }
        }
        TypeConstant typeResult = this.getType();
        if (typeResult == null) {
            typeResult = this.pool().typeObject();
        }
        return new RelOpExprAST(ast1, op, ast2, typeResult);
    }

    @Override
    public String toString() {
        return String.valueOf(this.expr1) + " " + this.operator.getId().TEXT + " " + String.valueOf(this.expr2);
    }

    @Override
    public String getDumpDesc() {
        return this.toString();
    }
}

