/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.compiler.ast;

import java.lang.reflect.Field;
import org.xvm.asm.ConstantPool;
import org.xvm.asm.ErrorListener;
import org.xvm.asm.constants.TypeConstant;
import org.xvm.compiler.Token;
import org.xvm.compiler.ast.AnonInnerClass;
import org.xvm.compiler.ast.Context;
import org.xvm.compiler.ast.Expression;
import org.xvm.compiler.ast.TypeExpression;
import org.xvm.util.Severity;

public class BiTypeExpression
extends TypeExpression {
    protected TypeExpression type1;
    protected Token operator;
    protected TypeExpression type2;
    private static final Field[] CHILD_FIELDS = BiTypeExpression.fieldsForNames(BiTypeExpression.class, "type1", "type2");

    public BiTypeExpression(TypeExpression type1, Token operator, TypeExpression type2) {
        this.type1 = type1;
        this.operator = operator;
        this.type2 = type2;
    }

    @Override
    protected boolean canResolveNames() {
        return super.canResolveNames() || this.type1.canResolveNames() && this.type2.canResolveNames();
    }

    @Override
    public long getStartPosition() {
        return this.type1.getStartPosition();
    }

    @Override
    public long getEndPosition() {
        return this.type2.getEndPosition();
    }

    @Override
    protected Field[] getChildFields() {
        return CHILD_FIELDS;
    }

    @Override
    protected TypeConstant instantiateTypeConstant(Context ctx, ErrorListener errs) {
        TypeConstant constType1 = this.type1.ensureTypeConstant(ctx, errs);
        TypeConstant constType2 = this.type2.ensureTypeConstant(ctx, errs);
        ConstantPool pool = this.pool();
        return switch (this.operator.getId()) {
            case Token.Id.ADD -> pool.ensureIntersectionTypeConstant(constType1, constType2);
            case Token.Id.BIT_OR -> pool.ensureUnionTypeConstant(constType1, constType2);
            case Token.Id.SUB -> pool.ensureDifferenceTypeConstant(constType1, constType2);
            default -> throw new IllegalStateException("unsupported operator: " + String.valueOf(this.operator));
        };
    }

    @Override
    protected void collectAnonInnerClassInfo(AnonInnerClass info) {
        switch (this.operator.getId()) {
            case ADD: {
                this.type1.collectAnonInnerClassInfo(info);
                this.type2.collectAnonInnerClassInfo(info);
                break;
            }
            case BIT_OR: {
                this.log(info.getErrorListener(true), Severity.ERROR, "COMPILER-100", new Object[0]);
                break;
            }
            case SUB: {
                info.addContribution(this);
                break;
            }
            default: {
                throw new IllegalStateException("unsupported operator: " + String.valueOf(this.operator));
            }
        }
    }

    @Override
    protected Expression validate(Context ctx, TypeConstant typeRequired, ErrorListener errs) {
        boolean fValid = true;
        TypeExpression exprNew = (TypeExpression)this.type1.validate(ctx, null, errs);
        if (exprNew == null) {
            fValid = false;
        } else {
            this.type1 = exprNew;
        }
        exprNew = (TypeExpression)this.type2.validate(ctx, null, errs);
        if (exprNew == null) {
            fValid = false;
        } else {
            this.type2 = exprNew;
        }
        return fValid ? super.validate(ctx, typeRequired, errs) : null;
    }

    @Override
    public String toString() {
        return String.valueOf(this.type1) + " " + this.operator.getId().TEXT + " " + String.valueOf(this.type2);
    }

    @Override
    public String getDumpDesc() {
        return this.toString();
    }
}

