/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.compiler.ast;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.xvm.asm.Argument;
import org.xvm.asm.Component;
import org.xvm.asm.Constant;
import org.xvm.asm.ConstantPool;
import org.xvm.asm.ErrorListener;
import org.xvm.asm.MethodStructure;
import org.xvm.asm.Op;
import org.xvm.asm.ast.ExprAST;
import org.xvm.asm.ast.MultiExprAST;
import org.xvm.asm.constants.ArrayConstant;
import org.xvm.asm.constants.IntConstant;
import org.xvm.asm.constants.MatchAnyConstant;
import org.xvm.asm.constants.RangeConstant;
import org.xvm.asm.constants.TypeConstant;
import org.xvm.asm.constants.ValueConstant;
import org.xvm.asm.op.Assert;
import org.xvm.asm.op.Jump;
import org.xvm.asm.op.JumpInt;
import org.xvm.asm.op.JumpIsA;
import org.xvm.asm.op.JumpVal;
import org.xvm.asm.op.JumpVal_N;
import org.xvm.asm.op.Label;
import org.xvm.compiler.Token;
import org.xvm.compiler.ast.AssertStatement;
import org.xvm.compiler.ast.AssignmentStatement;
import org.xvm.compiler.ast.AstNode;
import org.xvm.compiler.ast.CaseStatement;
import org.xvm.compiler.ast.Context;
import org.xvm.compiler.ast.Expression;
import org.xvm.compiler.ast.IgnoredNameExpression;
import org.xvm.compiler.ast.IsExpression;
import org.xvm.compiler.ast.KeywordTypeExpression;
import org.xvm.compiler.ast.MultipleLValueStatement;
import org.xvm.compiler.ast.NameExpression;
import org.xvm.compiler.ast.Statement;
import org.xvm.compiler.ast.SwitchStatement;
import org.xvm.compiler.ast.ToIntExpression;
import org.xvm.compiler.ast.TupleExpression;
import org.xvm.compiler.ast.VariableDeclarationStatement;
import org.xvm.util.BitCube;
import org.xvm.util.ListMap;
import org.xvm.util.ListSet;
import org.xvm.util.PackedInteger;
import org.xvm.util.Severity;

public class CaseManager<CookieType> {
    private final AstNode m_nodeSwitch;
    private boolean m_fHasDecl;
    private int m_cCondVals = -1;
    private List<AstNode> m_listCond;
    private boolean m_fCondAborts;
    private boolean m_fCompletes;
    private TypeConstant[] m_atypeCond;
    private long m_afIsSwitch;
    private Constant[] m_aconstCond;
    private ExprAST m_bastCond;
    private TypeConstant m_typeCase;
    private long m_lTypeExpr;
    private CaseStatement m_caseCurrent;
    private Label m_labelCurrent;
    private Label m_labelDefault;
    private Label m_labelConstant;
    private final ListSet<Constant> m_listsetCase = new ListSet();
    private final List<Label> m_listLabels = new ArrayList<Label>();
    private boolean m_fAllConsts = true;
    private final ListMap<Label, CookieType> m_mapLabels = new ListMap();
    private ListMap<Constant, Long> m_mapWild;
    private Constant[] m_aconstCase;
    private Label[] m_alabelCase;
    private boolean m_fUseJumpInt = false;
    private PackedInteger m_pintMin;
    private PackedInteger m_pintMax;

    public CaseManager(AstNode nodeSwitch) {
        this.m_nodeSwitch = nodeSwitch;
    }

    public ConstantPool pool() {
        return this.getSwitch().pool();
    }

    public AstNode getSwitch() {
        return this.m_nodeSwitch;
    }

    public boolean hasDeclarations() {
        return this.m_fHasDecl;
    }

    public boolean hasTypeConditions() {
        return this.m_lTypeExpr != 0L;
    }

    public TypeConstant getConditionType() {
        return this.m_typeCase;
    }

    public int getConditionCount() {
        return this.m_cCondVals;
    }

    public boolean isSingleEquals() {
        return this.m_cCondVals == 1 && this.m_afIsSwitch == 0L;
    }

    public int getCaseGroupCount() {
        return this.m_mapLabels.size();
    }

    public boolean isCardinal() {
        return this.getConditionCount() == 1 && this.getConditionType().isIntConvertible();
    }

    public boolean isCompletable() {
        return this.m_fCompletes;
    }

    public boolean usesNonExactMatching() {
        return this.m_mapWild != null;
    }

    public boolean usesIfLadder() {
        return this.getConditionCount() == 0;
    }

    public boolean usesJmpInt() {
        return this.m_fUseJumpInt;
    }

    public PackedInteger getJmpIntOffset() {
        return this.m_pintMin;
    }

    public boolean isSwitchConstant() {
        return this.m_labelConstant != null;
    }

    public Label getSwitchConstantLabel() {
        return this.m_labelConstant;
    }

    public Label[] getCaseLabels() {
        return this.m_alabelCase;
    }

    public Constant[] getCaseConstants() {
        return this.m_aconstCase;
    }

    public int getCaseCount() {
        return this.m_aconstCase.length + (this.hasDefaultCase() ? 1 : 0);
    }

    public Label getDefaultLabel() {
        return this.m_labelDefault;
    }

    public boolean hasDefaultCase() {
        SwitchStatement stmt;
        AstNode astNode;
        return !(this.m_labelDefault == null || (astNode = this.m_nodeSwitch) instanceof SwitchStatement && (stmt = (SwitchStatement)astNode).getEndLabel() == this.m_labelDefault);
    }

    public CookieType getCookie(Label label) {
        return this.m_mapLabels.get(label);
    }

    public ExprAST getConditionBAST() {
        return this.m_bastCond;
    }

    public long getConditionIsA() {
        return this.m_afIsSwitch;
    }

    protected int computeArity(List<? extends AstNode> listNodes, ErrorListener errs) {
        int nArity = 0;
        for (AstNode astNode : listNodes) {
            CaseStatement stmtCase;
            if (!(astNode instanceof CaseStatement) || (stmtCase = (CaseStatement)astNode).isDefault()) continue;
            for (Expression expr : stmtCase.getExpressions()) {
                int n;
                if (expr instanceof TupleExpression) {
                    TupleExpression exprTuple = (TupleExpression)expr;
                    v0 = exprTuple.getExpressions().size();
                } else {
                    v0 = n = 1;
                }
                if (nArity == 0) {
                    nArity = n;
                    continue;
                }
                if (nArity == n) continue;
                expr.log(errs, Severity.ERROR, "COMPILER-116", new Object[0]);
                return 0;
            }
        }
        return nArity == 0 ? 1 : nArity;
    }

    protected boolean validateCondition(Context ctx, List<AstNode> listCond, int nArity, ErrorListener errs) {
        boolean fIfSwitch;
        boolean fValid = true;
        ConstantPool pool = this.pool();
        boolean bl = fIfSwitch = listCond == null;
        if (fIfSwitch) {
            this.m_cCondVals = 0;
            this.m_atypeCond = new TypeConstant[]{pool.typeBoolean()};
            this.m_afIsSwitch = 0L;
            this.m_aconstCond = new Constant[]{pool.valTrue()};
        } else {
            int i;
            ArrayList<TypeConstant> listTypes = new ArrayList<TypeConstant>();
            ArrayList<Constant> listConsts = new ArrayList<Constant>();
            long afIsSwitch = 0L;
            boolean fAllConst = true;
            int c = listCond.size();
            for (i = 0; i < c; ++i) {
                KeywordTypeExpression exprType;
                IsExpression exprIs;
                AstNode nodeLVal;
                AstNode nodeNew;
                AstNode node = listCond.get(i);
                TypeConstant[] atype = null;
                boolean fIsSwitch = false;
                Constant[] aconst = null;
                if (node instanceof AssignmentStatement) {
                    AssignmentStatement stmtCond = (AssignmentStatement)node;
                    fAllConst = false;
                    this.m_fHasDecl |= stmtCond.hasDeclarations();
                    nodeNew = stmtCond.validate(ctx, errs);
                    if (nodeNew != null) {
                        TypeConstant[] typeConstantArray;
                        nodeLVal = ((AssignmentStatement)nodeNew).getLValue();
                        if (nodeLVal instanceof VariableDeclarationStatement) {
                            VariableDeclarationStatement stmtVarDecl = (VariableDeclarationStatement)nodeLVal;
                            TypeConstant[] typeConstantArray2 = new TypeConstant[1];
                            typeConstantArray = typeConstantArray2;
                            typeConstantArray2[0] = stmtVarDecl.getType();
                        } else if (nodeLVal instanceof MultipleLValueStatement) {
                            MultipleLValueStatement stmtMulti = (MultipleLValueStatement)nodeLVal;
                            typeConstantArray = stmtMulti.getTypes();
                        } else {
                            typeConstantArray = nodeLVal.getLValueExpression().getTypes();
                        }
                        atype = typeConstantArray;
                    }
                } else if (node instanceof IsExpression && (nodeLVal = (exprIs = (IsExpression)node).getExpression2()) instanceof KeywordTypeExpression && (exprType = (KeywordTypeExpression)nodeLVal).getKeyword().getId() == Token.Id.ANY) {
                    nodeNew = exprIs.getExpression1().validate(ctx, null, errs);
                    if (nodeNew != null) {
                        nodeNew.setParent(exprIs.getParent());
                    }
                    atype = new TypeConstant[]{pool.typeType()};
                    fIsSwitch = true;
                } else {
                    nodeNew = ((Expression)node).validate(ctx, null, errs);
                    if (nodeNew != null) {
                        Expression expr = nodeNew;
                        atype = expr.getTypes();
                        aconst = expr.toConstants();
                    }
                }
                if (nodeNew == null) {
                    fValid = false;
                } else if (nodeNew != node) {
                    listCond.set(i, nodeNew);
                }
                if (atype == null) {
                    fValid = false;
                    listTypes.add(pool.typeObject());
                } else {
                    int j = 0;
                    for (int iType = i; j < atype.length && iType < nArity; ++j, ++iType) {
                        TypeConstant type = atype[j];
                        if (type.isTypeOfType() && type.containsFormalType(true)) {
                            type = type.resolveConstraints();
                        }
                        listTypes.add(type);
                        if (!fIsSwitch) continue;
                        if (iType >= 63) {
                            node.log(errs, Severity.ERROR, "COMPILER-181", new Object[0]);
                            fValid = false;
                        }
                        afIsSwitch |= 1L << iType;
                    }
                }
                if (!fAllConst) continue;
                if (aconst == null) {
                    fAllConst = false;
                    continue;
                }
                assert (aconst.length == atype.length);
                for (Constant constant : aconst) {
                    assert (constant != null);
                    listConsts.add(constant);
                }
                assert (listConsts.size() == listTypes.size());
            }
            this.m_cCondVals = listTypes.size();
            this.m_atypeCond = listTypes.toArray(TypeConstant.NO_TYPES);
            this.m_afIsSwitch = afIsSwitch;
            if (fValid) {
                if (fAllConst) {
                    this.m_aconstCond = listConsts.toArray(Constant.NO_CONSTS);
                } else {
                    c = this.m_cCondVals;
                    for (i = 0; i < c; ++i) {
                        if (!this.m_atypeCond[i].isTypeOfType()) continue;
                        this.m_lTypeExpr |= 1L << i;
                    }
                }
            }
        }
        this.m_listCond = listCond;
        this.m_typeCase = this.m_atypeCond.length == 1 ? this.m_atypeCond[0].freeze() : pool.ensureImmutableTypeConstant(pool.ensureTupleType(this.m_atypeCond));
        return fValid;
    }

    public boolean validateCase(Context ctx, CaseStatement stmtCase, ErrorListener errs) {
        boolean fValid = true;
        if (this.m_labelCurrent == null) {
            this.m_labelCurrent = new Label("case_" + (this.m_mapLabels.size() + 1));
            this.m_mapLabels.put(this.m_labelCurrent, null);
        }
        stmtCase.setLabel(this.m_labelCurrent);
        this.m_caseCurrent = stmtCase;
        List<Expression> listExprs = stmtCase.exprs;
        if (listExprs == null) {
            if (this.m_labelDefault == null) {
                this.m_labelDefault = this.m_labelCurrent;
            } else {
                stmtCase.log(errs, Severity.ERROR, "COMPILER-75", new Object[0]);
                fValid = false;
            }
            return fValid;
        }
        ctx = ctx.enterInferring(this.m_typeCase);
        ConstantPool pool = this.pool();
        boolean fIfSwitch = this.usesIfLadder();
        boolean fIntConsts = this.isCardinal() && this.m_typeCase.getExplicitClassFormat() != Component.Format.ENUM;
        int cPrevCases = this.m_listsetCase.size();
        int cExprs = listExprs.size();
        block0: for (int iExpr = 0; iExpr < cExprs; ++iExpr) {
            Expression exprNew;
            Cloneable typeRange;
            Expression exprCase = listExprs.get(iExpr);
            TypeConstant typeMatch = this.m_typeCase;
            long lIgnore = 0L;
            long lRange = 0L;
            int cFields = 1;
            TypeConstant[] atypeAlt = null;
            if (exprCase instanceof TupleExpression) {
                TupleExpression exprTuple = (TupleExpression)exprCase;
                List<Expression> listFields = exprTuple.exprs;
                cFields = listFields.size();
                for (int i = 0; i < cFields; ++i) {
                    Expression exprField = listFields.get(i);
                    if (exprField instanceof IgnoredNameExpression) {
                        lIgnore |= 1L << i;
                        continue;
                    }
                    if (exprField.testFit(ctx, this.m_atypeCond[i], false, null).isFit() || !exprField.testFit(ctx, (TypeConstant)(typeRange = pool.ensureRangeType(this.m_atypeCond[i])), false, null).isFit()) continue;
                    lRange |= 1L << i;
                    if (atypeAlt == null) {
                        atypeAlt = (TypeConstant[])this.m_atypeCond.clone();
                    }
                    atypeAlt[i] = typeRange;
                }
            } else if (this.getConditionCount() == 1) {
                TypeConstant typeRange2;
                if (exprCase instanceof IgnoredNameExpression) {
                    lIgnore = 1L;
                } else if (!exprCase.testFit(ctx, this.m_typeCase, false, null).isFit() && exprCase.testFit(ctx, typeRange2 = pool.ensureRangeType(this.m_typeCase), false, null).isFit()) {
                    lRange = 1L;
                    typeMatch = typeRange2;
                }
            } else if (exprCase instanceof IgnoredNameExpression) {
                exprCase.log(errs, Severity.ERROR, "COMPILER-116", new Object[0]);
                fValid = false;
            }
            if (Long.bitCount(lIgnore) == cFields) {
                if (this.m_labelDefault == null) {
                    this.m_labelDefault = this.m_labelCurrent;
                } else {
                    stmtCase.log(errs, Severity.ERROR, "COMPILER-75", new Object[0]);
                    fValid = false;
                }
                exprNew = exprCase.validate(ctx, typeMatch, errs);
                assert (exprNew == exprCase);
                continue;
            }
            if (atypeAlt != null) {
                typeMatch = pool.ensureImmutableTypeConstant(pool.ensureTupleType(atypeAlt));
            }
            if ((exprNew = exprCase.validate(ctx, typeMatch, errs)) == null) {
                fValid = false;
                continue;
            }
            if (exprNew != exprCase) {
                exprCase = exprNew;
                listExprs.set(iExpr, exprCase);
            }
            if (exprCase.isConstant()) {
                Constant constCase = exprCase.toConstant();
                if (this.m_fAllConsts && this.m_aconstCond != null && this.m_labelConstant == null) {
                    Constant constCond;
                    Constant constant = constCond = this.m_aconstCond.length == 1 ? this.m_aconstCond[0] : pool.ensureArrayConstant(this.m_typeCase, this.m_aconstCond);
                    if (this.covers(constCase, lRange, constCond, 0L)) {
                        this.m_labelConstant = this.m_labelCurrent;
                    }
                }
                if (fIfSwitch) continue;
                if (this.collides(constCase, lIgnore, lRange)) {
                    stmtCase.log(errs, Severity.ERROR, "COMPILER-77", constCase.getValueString());
                    fValid = false;
                    continue;
                }
                this.m_listsetCase.add(constCase);
                this.m_listLabels.add(this.m_labelCurrent);
                if (fIntConsts && !(constCase instanceof MatchAnyConstant)) {
                    if (constCase instanceof RangeConstant) {
                        RangeConstant constRange = (RangeConstant)constCase;
                        this.incorporateInt(constRange.getFirst().getIntValue());
                        this.incorporateInt(constRange.getLast().getIntValue());
                    } else {
                        this.incorporateInt(constCase.getIntValue());
                    }
                }
                if (this.getConditionCount() == 1) {
                    TypeConstant typeCase;
                    if ((this.m_afIsSwitch & 1L) == 0L || !((typeRange = this.m_listCond.get(0)) instanceof Expression)) continue;
                    Expression exprTest = (Expression)typeRange;
                    if (constCase instanceof TypeConstant && (typeCase = (TypeConstant)constCase).isTypeOfType()) {
                        typeCase = typeCase.getParamType(0);
                        TypeConstant typeTest = exprTest.getImplicitType(ctx);
                        if (typeTest != null && typeTest.isTypeOfType() && !typeCase.isTypeOfType()) {
                            exprNew.log(errs, Severity.ERROR, "COMPILER-134", exprTest.toString(), typeCase.getValueString());
                            fValid = false;
                            continue;
                        }
                        Iterator<Constant> iter = this.m_listsetCase.iterator();
                        for (int i2 = 0; i2 < cPrevCases; ++i2) {
                            TypeConstant typePrev = (TypeConstant)iter.next();
                            assert (typePrev.isTypeOfType());
                            if (!typeCase.isA(typePrev = typePrev.getParamType(0))) continue;
                            stmtCase.log(errs, Severity.ERROR, "COMPILER-46", new Object[0]);
                            fValid = false;
                            continue block0;
                        }
                        continue;
                    }
                    exprNew.log(errs, Severity.ERROR, "COMPILER-134", exprTest.toString(), constCase.getValueString());
                    fValid = false;
                    continue;
                }
                if (this.m_afIsSwitch == 0L || !(constCase instanceof ArrayConstant)) continue;
                ArrayConstant constArray = (ArrayConstant)constCase;
                Constant[] aConstCase = constArray.getValue();
                int c = 64 - Long.numberOfLeadingZeros(this.m_afIsSwitch);
                for (int i = 0; i < c; ++i) {
                    TypeConstant typeCase;
                    AstNode i2;
                    if ((this.m_afIsSwitch & 1L << i) == 0L || !((i2 = this.m_listCond.get(i)) instanceof Expression)) continue;
                    Expression exprTest = (Expression)i2;
                    Constant constCaseNext = aConstCase[i];
                    if (constCaseNext instanceof TypeConstant && (typeCase = (TypeConstant)constCaseNext).isTypeOfType()) {
                        typeCase = typeCase.getParamType(0);
                        TypeConstant typeTest = exprTest.getImplicitType(ctx);
                        if (typeTest == null || !typeTest.isTypeOfType() || typeCase.isTypeOfType()) continue;
                        exprNew.log(errs, Severity.ERROR, "COMPILER-134", exprTest.toString(), typeCase.getValueString());
                        fValid = false;
                        continue;
                    }
                    if (constCaseNext instanceof MatchAnyConstant) continue;
                    exprNew.log(errs, Severity.ERROR, "COMPILER-134", exprTest.toString(), constCase.getValueString());
                    fValid = false;
                }
                continue;
            }
            this.m_fAllConsts = false;
            if (fIfSwitch) continue;
            stmtCase.log(errs, Severity.ERROR, "COMPILER-78", new Object[0]);
            fValid = false;
        }
        ctx.exit();
        return fValid;
    }

    protected boolean addTypeInference(Context ctx, CaseStatement stmtCase, ErrorListener errs) {
        block10: {
            Constant constCase;
            ConstantPool pool;
            block9: {
                AstNode astNode;
                if (this.m_lTypeExpr == 0L) {
                    return false;
                }
                pool = this.pool();
                constCase = this.m_listsetCase.last();
                if (this.getConditionCount() != 1) break block9;
                if ((this.m_lTypeExpr & 1L) == 0L || !((astNode = this.m_listCond.get(0)) instanceof NameExpression)) break block10;
                NameExpression exprTest = (NameExpression)astNode;
                if (!(constCase instanceof TypeConstant)) break block10;
                TypeConstant typeCase = (TypeConstant)constCase;
                assert (typeCase.isTypeOfType());
                if ((this.m_afIsSwitch & 1L) != 0L) {
                    typeCase = typeCase.getParamType(0);
                    TypeConstant typeTest = exprTest.getImplicitType(ctx);
                    if (typeTest != null) {
                        typeCase = typeCase.combine(pool, typeTest);
                    }
                }
                exprTest.narrowType(ctx, Context.Branch.Always, typeCase);
                break block10;
            }
            if (constCase instanceof ArrayConstant) {
                ArrayConstant constArray = (ArrayConstant)constCase;
                Constant[] aConstCase = constArray.getValue();
                int c = 64 - Long.numberOfLeadingZeros(this.m_lTypeExpr);
                for (int i = 0; i < c; ++i) {
                    Cloneable cloneable;
                    long lPos = 1L << i;
                    if ((this.m_lTypeExpr & lPos) == 0L || !((cloneable = this.m_listCond.get(i)) instanceof NameExpression)) continue;
                    NameExpression exprTest = (NameExpression)cloneable;
                    cloneable = aConstCase[i];
                    if (!(cloneable instanceof TypeConstant)) continue;
                    TypeConstant typeCase = (TypeConstant)cloneable;
                    assert (typeCase.isTypeOfType());
                    if ((this.m_afIsSwitch & lPos) != 0L) {
                        typeCase = typeCase.getParamType(0);
                        TypeConstant typeTest = exprTest.getImplicitType(ctx);
                        if (typeTest != null) {
                            typeCase = typeCase.combine(pool, typeTest);
                        }
                    }
                    exprTest.narrowType(ctx, Context.Branch.Always, typeCase);
                }
            }
        }
        return true;
    }

    private void incorporateInt(PackedInteger pint) {
        if (this.m_pintMin == null) {
            this.m_pintMin = this.m_pintMax = pint;
        } else if (pint.compareTo(this.m_pintMax) > 0) {
            this.m_pintMax = pint;
        } else if (pint.compareTo(this.m_pintMin) < 0) {
            this.m_pintMin = pint;
        }
    }

    public void endCaseGroup(CookieType cookie) {
        if (this.m_labelCurrent == null) {
            throw new IllegalStateException();
        }
        if (cookie != null) {
            this.m_mapLabels.put(this.m_labelCurrent, cookie);
        }
        this.m_labelCurrent = null;
        this.m_caseCurrent = null;
    }

    public boolean validateEnd(Context ctx, ErrorListener errs) {
        boolean fValid = true;
        if (this.m_labelCurrent != null) {
            this.m_caseCurrent.log(errs, Severity.ERROR, "COMPILER-80", new Object[0]);
            fValid = false;
        } else if (this.m_aconstCond != null && this.m_labelConstant == null && this.m_fAllConsts && this.m_labelDefault != null) {
            this.m_labelConstant = this.m_labelDefault;
        } else if (this.m_labelDefault == null && !this.areAllCasesCovered()) {
            this.m_fCompletes = true;
            AstNode astNode = this.m_nodeSwitch;
            if (astNode instanceof Statement) {
                Statement stmtSwitch = (Statement)astNode;
                this.m_labelDefault = stmtSwitch.getEndLabel();
            } else {
                this.m_nodeSwitch.log(errs, Severity.ERROR, "COMPILER-76", new Object[0]);
                fValid = false;
            }
        }
        if (!this.usesIfLadder()) {
            PackedInteger pintRange;
            int cVals = this.m_listsetCase.size();
            int cRange = 0;
            if (fValid && this.m_pintMin != null && this.getConditionCount() == 1 && !(pintRange = this.m_pintMax.sub(this.m_pintMin)).isBig() && (long)this.m_listsetCase.size() >= pintRange.getLong() >>> 2) {
                cRange = pintRange.getInt() + 1;
                this.m_fUseJumpInt = true;
            }
            Constant[] aConstCase = this.m_listsetCase.toArray(Constant.NO_CONSTS);
            Label[] aLabelCase = this.m_listLabels.toArray(new Label[0]);
            if (this.m_fUseJumpInt) {
                AstNode astNode;
                Label[] aLabels = new Label[cRange];
                for (int i = 0; i < cVals; ++i) {
                    Label label = aLabelCase[i];
                    Constant constCase = aConstCase[i];
                    if (constCase instanceof RangeConstant) {
                        RangeConstant constRange = (RangeConstant)constCase;
                        int iFirst = constRange.getFirst().getIntValue().sub(this.m_pintMin).getInt();
                        int iLast = constRange.getLast().getIntValue().sub(this.m_pintMin).getInt();
                        boolean fFirstEx = constRange.isFirstExcluded();
                        boolean fLastEx = constRange.isLastExcluded();
                        if (iFirst > iLast) {
                            int iTemp = iFirst;
                            iFirst = fLastEx ? iLast + 1 : iLast;
                            iLast = fFirstEx ? iTemp - 1 : iTemp;
                        } else {
                            if (fFirstEx) {
                                ++iFirst;
                            }
                            if (fLastEx) {
                                --iLast;
                            }
                        }
                        for (int iVal = iFirst; iVal <= iLast; ++iVal) {
                            if (aLabels[iVal] != null) continue;
                            aLabels[iVal] = label;
                        }
                        continue;
                    }
                    aLabels[constCase.getIntValue().sub((PackedInteger)this.m_pintMin).getInt()] = label;
                }
                Label labelMiss = this.m_labelDefault;
                if (labelMiss == null && (astNode = this.m_nodeSwitch) instanceof Statement) {
                    Statement stmtSwitch = (Statement)astNode;
                    labelMiss = stmtSwitch.getEndLabel();
                }
                for (int i = 0; i < cRange; ++i) {
                    if (aLabels[i] != null) continue;
                    assert (labelMiss != null || !fValid);
                    aLabels[i] = labelMiss;
                }
                this.m_alabelCase = aLabels;
            } else {
                this.m_alabelCase = aLabelCase;
            }
            this.m_aconstCase = aConstCase;
        }
        return fValid;
    }

    private boolean collides(Constant constCase, long lIgnore, long lRange) {
        if (this.m_listsetCase.contains(constCase)) {
            return true;
        }
        if (this.usesNonExactMatching()) {
            for (Map.Entry<Constant, Long> entry : this.m_mapWild.entrySet()) {
                long lWildRanges;
                Constant constWild = entry.getKey();
                if (!this.covers(constWild, lWildRanges = entry.getValue().longValue(), constCase, lRange)) continue;
                return true;
            }
        }
        if ((lIgnore | lRange) != 0L) {
            if (this.m_mapWild == null) {
                this.m_mapWild = new ListMap();
            }
            this.m_mapWild.put(constCase, lRange);
        }
        return false;
    }

    private boolean covers(Constant constThis, long lRangeThis, Constant constThat, long lRangeThat) {
        if (constThis.equals(constThat)) {
            return true;
        }
        int cConds = this.getConditionCount();
        if (cConds == 1) {
            return CaseManager.covers(constThis, (lRangeThis & 1L) != 0L, constThat, (lRangeThat & 1L) != 0L);
        }
        assert (cConds > 1);
        if (constThis.getFormat() == Constant.Format.Tuple && constThat.getFormat() == Constant.Format.Tuple) {
            Constant[] aconstThis = ((ArrayConstant)constThis).getValue();
            Constant[] aconstThat = ((ArrayConstant)constThat).getValue();
            for (int i = 0; i < cConds; ++i) {
                if (CaseManager.covers(aconstThis[i], (lRangeThis & 1L << i) != 0L, aconstThat[i], (lRangeThat & 1L << i) != 0L)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean covers(Constant constThis, boolean fRangeThis, Constant constThat, boolean fRangeThat) {
        Object oThatHi;
        Object oThatLo;
        Object oThisHi;
        Object oThisLo;
        if (constThis.equals(constThat)) return true;
        if (constThis instanceof MatchAnyConstant) {
            return true;
        }
        if (constThat instanceof MatchAnyConstant) return false;
        if (!fRangeThis) {
            if (!fRangeThat) return false;
        }
        if (!(constThis instanceof ValueConstant)) return false;
        if (!(constThat instanceof ValueConstant)) {
            return false;
        }
        if (fRangeThis) {
            if (!(constThis instanceof RangeConstant)) return false;
            RangeConstant constRange = (RangeConstant)constThis;
            oThisLo = constRange.getEffectiveLow();
            oThisHi = constRange.getEffectiveHigh();
            if (!(oThisLo instanceof ValueConstant)) return false;
            ValueConstant valLo = (ValueConstant)oThisLo;
            if (!(oThisHi instanceof ValueConstant)) return false;
            ValueConstant valHi = (ValueConstant)oThisHi;
            oThisLo = valLo.getValue();
            oThisHi = valHi.getValue();
        } else {
            oThisLo = oThisHi = ((ValueConstant)constThis).getValue();
        }
        if (!(oThisLo instanceof Comparable)) return false;
        Comparable cmpThisLo = (Comparable)oThisLo;
        if (!(oThisHi instanceof Comparable)) return false;
        Comparable cmpThisHi = (Comparable)oThisHi;
        if (fRangeThat) {
            if (!(constThat instanceof RangeConstant)) return false;
            RangeConstant constRange = (RangeConstant)constThat;
            oThatLo = constRange.getEffectiveLow();
            oThatHi = constRange.getEffectiveHigh();
            if (!(oThatLo instanceof ValueConstant)) return false;
            ValueConstant valueLo = (ValueConstant)oThatLo;
            if (!(oThatHi instanceof ValueConstant)) return false;
            ValueConstant valueHi = (ValueConstant)oThatHi;
            oThatLo = valueLo.getValue();
            oThatHi = valueHi.getValue();
        } else {
            oThatLo = oThatHi = ((ValueConstant)constThat).getValue();
        }
        if (!(oThatLo instanceof Comparable)) return false;
        Comparable cmpThatLo = (Comparable)oThatLo;
        if (!(oThatHi instanceof Comparable)) return false;
        Comparable cmpThatHi = (Comparable)oThatHi;
        try {
            if (cmpThisLo.compareTo(cmpThatLo) > 0) return false;
            if (cmpThisHi.compareTo(cmpThatHi) < 0) return false;
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private boolean areAllCasesCovered() {
        if (this.usesIfLadder()) {
            return false;
        }
        int cCases = this.m_listsetCase.size();
        int cConds = this.getConditionCount();
        if (cConds == 1) {
            TypeConstant typeCase = this.m_typeCase;
            if (!typeCase.isIntConvertible()) {
                return false;
            }
            int cCardinality = typeCase.getIntCardinality();
            if (cCardinality == Integer.MAX_VALUE) {
                return false;
            }
            if (this.usesNonExactMatching()) {
                Constant constBase = typeCase.getCardinalBase();
                BitSet setCovered = new BitSet(cCardinality);
                for (Constant constCase : this.m_listsetCase) {
                    if (constCase instanceof MatchAnyConstant) {
                        return true;
                    }
                    if (constCase instanceof RangeConstant) {
                        RangeConstant constRange = (RangeConstant)constCase;
                        int nLo = CaseManager.getOrdinal(constRange.getEffectiveLow(), constBase);
                        int nHi = CaseManager.getOrdinal(constRange.getEffectiveHigh(), constBase);
                        setCovered.set(nLo, nHi + 1);
                        continue;
                    }
                    setCovered.set(CaseManager.getOrdinal(constCase, constBase));
                }
                return setCovered.cardinality() == cCardinality;
            }
            return cCardinality == cCases;
        }
        TypeConstant[] atype = this.m_typeCase.getParamTypesArray();
        assert (atype.length == cConds);
        int[] aiCardinals = new int[cConds];
        Constant[] aconstBase = new Constant[cConds];
        int cTotal = 1;
        for (int i = 0; i < cConds; ++i) {
            TypeConstant typeCase = atype[i];
            if (!typeCase.isIntConvertible()) {
                return false;
            }
            int cCardinality = typeCase.getIntCardinality();
            if (cCardinality == Integer.MAX_VALUE) {
                return false;
            }
            Constant constBase = typeCase.getCardinalBase();
            if (constBase == null) {
                return false;
            }
            if ((cTotal *= cCardinality) >= 32000) {
                return false;
            }
            aiCardinals[i] = cCardinality;
            aconstBase[i] = constBase;
        }
        BitCube cube = new BitCube(aiCardinals);
        int[] anPoint = new int[cConds];
        Iterator<Constant> iter = this.m_listsetCase.iterator();
        for (int iCase = 0; iCase < cCases; ++iCase) {
            Constant constTuple = iter.next();
            if (constTuple.getFormat() != Constant.Format.Tuple) continue;
            Constant[] aconstCase = ((ArrayConstant)constTuple).getValue();
            assert (aconstCase.length == cConds);
            CaseManager.processCondition(cube, 0, anPoint, cConds, aconstCase, aconstBase);
        }
        return cube.isFull();
    }

    private static void processCondition(BitCube cube, int iCond, int[] anPoint, int cCondVals, Constant[] aconstCase, Constant[] aconstBase) {
        if (iCond == cCondVals) {
            cube.set(anPoint);
            return;
        }
        Constant constCase = aconstCase[iCond];
        if (constCase instanceof MatchAnyConstant) {
            int i = 0;
            int c = cube.getSize(iCond);
            while (i < c) {
                anPoint[iCond] = i++;
                CaseManager.processCondition(cube, iCond + 1, anPoint, cCondVals, aconstCase, aconstBase);
            }
        } else if (constCase instanceof RangeConstant) {
            RangeConstant constRange = (RangeConstant)constCase;
            Constant constBase = aconstBase[iCond];
            int nMin = CaseManager.getOrdinal(constRange.getEffectiveLow(), constBase);
            int nMax = CaseManager.getOrdinal(constRange.getEffectiveHigh(), constBase);
            int i = nMin;
            while (i <= nMax) {
                anPoint[iCond] = i++;
                CaseManager.processCondition(cube, iCond + 1, anPoint, cCondVals, aconstCase, aconstBase);
            }
        } else {
            anPoint[iCond] = CaseManager.getOrdinal(constCase, aconstBase[iCond]);
            CaseManager.processCondition(cube, iCond + 1, anPoint, cCondVals, aconstCase, aconstBase);
        }
    }

    private static int getOrdinal(Constant constVal, Constant constBase) {
        IntConstant constSub = (IntConstant)constVal.apply(Token.Id.SUB, constBase);
        return constSub.getIntValue().getInt();
    }

    public Argument[] generateConditionArguments(Context ctx, MethodStructure.Code code, ErrorListener errs) {
        assert (this.m_listCond != null && !this.m_listCond.isEmpty());
        Argument[] aArgVal = new Argument[this.getConditionCount()];
        int ofArgVal = 0;
        ExprAST[] abast = new ExprAST[this.m_listCond.size()];
        int ibast = 0;
        for (AstNode node : this.m_listCond) {
            Expression exprCond;
            Expression exprBast = null;
            if (node instanceof AssignmentStatement) {
                AssignmentStatement stmt = (AssignmentStatement)node;
                if (!stmt.completes(ctx, true, code, errs)) {
                    this.m_fCondAborts = true;
                }
                exprCond = stmt.getLValue().getLValueExpression();
                abast[ibast++] = (ExprAST)ctx.getHolder().getAst(stmt);
            } else {
                exprBast = exprCond = (Expression)node;
            }
            if (!(!this.usesJmpInt() || this.getJmpIntOffset().equals(PackedInteger.ZERO) && exprCond.getType().isA(this.pool().typeInt64()))) {
                exprCond = new ToIntExpression(exprCond, this.getJmpIntOffset(), errs);
            }
            Argument[] aArgsAdd = exprCond.generateArguments(ctx, code, true, false, errs);
            int cArgsAdd = Math.min(aArgsAdd.length, aArgVal.length - ofArgVal);
            System.arraycopy(aArgsAdd, 0, aArgVal, ofArgVal, cArgsAdd);
            ofArgVal += cArgsAdd;
            if (exprBast == null) continue;
            abast[ibast++] = exprBast.getExprAST(ctx);
        }
        assert (ofArgVal == aArgVal.length);
        assert (ibast == abast.length && Arrays.stream(abast).allMatch(Objects::nonNull));
        this.m_bastCond = abast.length == 1 ? abast[0] : new MultiExprAST(abast);
        return aArgVal;
    }

    public boolean isConditionAborting() {
        return this.m_fCondAborts;
    }

    public void generateJumpTable(Context ctx, MethodStructure.Code code, ErrorListener errs) {
        boolean fDefaultAssert = false;
        Label labelDefault = this.m_labelDefault;
        if (labelDefault == null) {
            labelDefault = new Label("default_assert");
            fDefaultAssert = true;
        }
        Argument[] aArgVal = this.generateConditionArguments(ctx, code, errs);
        Op[] alabelCase = this.m_alabelCase;
        if (this.usesJmpInt()) {
            assert (this.getConditionCount() == 1 && aArgVal.length == 1);
            code.add(new JumpInt(aArgVal[0], alabelCase, labelDefault));
        } else if (this.isSingleEquals()) {
            code.add(new JumpVal(aArgVal[0], this.m_aconstCase, alabelCase, labelDefault));
        } else if (this.getConditionCount() == 1) {
            assert (this.m_afIsSwitch == 1L);
            code.add(new JumpIsA(aArgVal[0], this.m_aconstCase, alabelCase, labelDefault));
        } else {
            code.add(new JumpVal_N(aArgVal, this.m_afIsSwitch, this.m_aconstCase, alabelCase, labelDefault));
        }
        if (fDefaultAssert) {
            code.add(labelDefault);
            code.add(new Assert(this.pool().valFalse(), AssertStatement.findExceptionConstructor(this.pool(), "IllegalArgument", errs)));
        }
    }

    public void generateIfLadder(Context ctx, MethodStructure.Code code, List<? extends AstNode> aNodes, ErrorListener errs) {
        for (AstNode astNode : aNodes) {
            CaseStatement stmt;
            if (!(astNode instanceof CaseStatement) || (stmt = (CaseStatement)astNode).isDefault()) continue;
            stmt.updateLineNumber(code);
            Label labelCur = stmt.getLabel();
            for (Expression expr : stmt.getExpressions()) {
                expr.generateConditionalJump(ctx, code, labelCur, true, errs);
            }
        }
        Label labelDefault = this.m_labelDefault;
        assert (labelDefault != null);
        code.add(new Jump(labelDefault));
    }
}

