/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.compiler.ast;

import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.List;
import org.xvm.asm.Constant;
import org.xvm.asm.ErrorListener;
import org.xvm.asm.MethodStructure;
import org.xvm.asm.constants.ArrayConstant;
import org.xvm.asm.constants.MatchAnyConstant;
import org.xvm.asm.op.Label;
import org.xvm.compiler.Token;
import org.xvm.compiler.ast.Context;
import org.xvm.compiler.ast.Expression;
import org.xvm.compiler.ast.Statement;

public class CaseStatement
extends Statement {
    protected Token keyword;
    protected List<Expression> exprs;
    protected long lEndPos;
    private transient Label m_label;
    private static final Field[] CHILD_FIELDS = CaseStatement.fieldsForNames(CaseStatement.class, "exprs");

    public CaseStatement(Token keyword, List<Expression> exprs, Token tokColon) {
        this.keyword = keyword;
        this.exprs = exprs;
        this.lEndPos = tokColon.getEndPosition();
    }

    public boolean isDefault() {
        return this.exprs == null;
    }

    public List<Expression> getExpressions() {
        return this.exprs;
    }

    public int getExpressionCount() {
        return this.exprs == null ? 0 : this.exprs.size();
    }

    public Label getLabel() {
        return this.m_label;
    }

    void setLabel(Label label) {
        assert (this.m_label == null);
        this.m_label = label;
    }

    @Override
    public long getStartPosition() {
        return this.keyword.getStartPosition();
    }

    @Override
    public long getEndPosition() {
        return this.lEndPos;
    }

    @Override
    protected Field[] getChildFields() {
        return CHILD_FIELDS;
    }

    @Override
    protected Statement validateImpl(Context ctx, ErrorListener errs) {
        throw new IllegalStateException();
    }

    @Override
    protected boolean emit(Context ctx, boolean fReachable, MethodStructure.Code code, ErrorListener errs) {
        throw new IllegalStateException();
    }

    protected int collectConstants(int iCase, Constant[] aconstCase) {
        if (this.exprs == null) {
            aconstCase[++iCase] = null;
        } else {
            for (Expression expr : this.exprs) {
                ArrayConstant tup;
                Constant constVal = expr.toConstant();
                if (constVal instanceof MatchAnyConstant || constVal instanceof ArrayConstant && (tup = (ArrayConstant)constVal).getFormat() == Constant.Format.Tuple && Arrays.stream(tup.getValue()).allMatch(c -> c instanceof MatchAnyConstant)) {
                    aconstCase[++iCase] = null;
                    continue;
                }
                aconstCase[++iCase] = constVal;
            }
        }
        return iCase;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.keyword.getId().TEXT);
        if (this.exprs != null) {
            sb.append(' ').append(this.exprs.get(0));
            int c = this.exprs.size();
            for (int i = 1; i < c; ++i) {
                sb.append(", ").append(this.exprs.get(i));
            }
        }
        sb.append(':');
        return sb.toString();
    }

    @Override
    public String getDumpDesc() {
        return this.toString();
    }
}

