/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.compiler.ast;

import java.lang.reflect.Field;
import org.xvm.asm.Assignment;
import org.xvm.asm.ErrorListener;
import org.xvm.asm.MethodStructure;
import org.xvm.asm.Register;
import org.xvm.asm.constants.TypeConstant;
import org.xvm.asm.op.CatchEnd;
import org.xvm.asm.op.CatchStart;
import org.xvm.asm.op.Label;
import org.xvm.compiler.ast.Context;
import org.xvm.compiler.ast.Statement;
import org.xvm.compiler.ast.StatementBlock;
import org.xvm.compiler.ast.VariableDeclarationStatement;
import org.xvm.util.Handy;
import org.xvm.util.Severity;

public class CatchStatement
extends Statement {
    protected VariableDeclarationStatement target;
    protected StatementBlock block;
    protected long lStartPos;
    private transient CatchStart m_opCatch;
    private transient Label m_labelEndCatch;
    private static final Field[] CHILD_FIELDS = CatchStatement.fieldsForNames(CatchStatement.class, "target", "block");

    public CatchStatement(VariableDeclarationStatement target, StatementBlock block, long lStartPos) {
        this.target = target;
        this.block = block;
        this.lStartPos = lStartPos;
    }

    public TypeConstant getCatchType() {
        return this.target.getType();
    }

    public Register getCatchRegister() {
        return this.target.getRegister();
    }

    public String getCatchVariableName() {
        return this.target.getName();
    }

    public CatchStart ensureCatchStart() {
        CatchStart op = this.m_opCatch;
        if (op == null) {
            this.m_opCatch = op = new CatchStart(this.getCatchRegister(), this.pool().ensureStringConstant(this.getCatchVariableName()));
        }
        return op;
    }

    public void setCatchLabel(Label label) {
        this.m_labelEndCatch = label;
    }

    @Override
    public long getStartPosition() {
        return this.lStartPos;
    }

    @Override
    public long getEndPosition() {
        return this.block.getEndPosition();
    }

    @Override
    protected Field[] getChildFields() {
        return CHILD_FIELDS;
    }

    @Override
    protected Statement validateImpl(Context ctx, ErrorListener errs) {
        boolean fValid = true;
        VariableDeclarationStatement targetNew = (VariableDeclarationStatement)this.target.validate(ctx = ctx.enter(), errs);
        if (targetNew == null) {
            fValid = false;
        } else {
            this.target = targetNew;
            ctx.ensureDefiniteAssignments().put(this.target.getName(), Assignment.AssignedOnce);
            TypeConstant typeE = this.target.getType();
            if (!typeE.isA(this.pool().typeException())) {
                fValid = false;
                this.target.log(errs, Severity.ERROR, "COMPILER-43", this.pool().typeException().getValueString(), typeE.getValueString());
            }
            this.block.suppressScope();
            StatementBlock blockNew = (StatementBlock)this.block.validate(ctx, errs);
            if (blockNew != null) {
                this.block = blockNew;
            }
        }
        ctx.exit();
        return fValid ? this : null;
    }

    @Override
    protected boolean emit(Context ctx, boolean fReachable, MethodStructure.Code code, ErrorListener errs) {
        assert (this.m_opCatch != null && this.m_labelEndCatch != null);
        code.add(this.m_opCatch);
        this.block.suppressScope();
        boolean fCompletes = this.block.completes(ctx, fReachable, code, errs);
        code.add(new CatchEnd(this.m_labelEndCatch));
        ctx.getHolder().setAst(this, ctx.getHolder().getAst(this.block));
        return fCompletes;
    }

    @Override
    public String toString() {
        return "catch (" + String.valueOf(this.target) + ")\n" + Handy.indentLines(this.block.toString(), "    ");
    }
}

