/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.compiler.ast;

import java.lang.reflect.Field;
import java.util.HashSet;
import java.util.List;
import org.xvm.asm.Argument;
import org.xvm.asm.Constant;
import org.xvm.asm.ConstantPool;
import org.xvm.asm.ErrorListener;
import org.xvm.asm.MethodStructure;
import org.xvm.asm.OpCondJump;
import org.xvm.asm.OpTest;
import org.xvm.asm.ast.BiExprAST;
import org.xvm.asm.ast.CmpChainExprAST;
import org.xvm.asm.ast.ExprAST;
import org.xvm.asm.constants.MethodConstant;
import org.xvm.asm.constants.MethodInfo;
import org.xvm.asm.constants.SignatureConstant;
import org.xvm.asm.constants.SingletonConstant;
import org.xvm.asm.constants.TypeConstant;
import org.xvm.asm.op.IsEq;
import org.xvm.asm.op.IsGt;
import org.xvm.asm.op.IsGte;
import org.xvm.asm.op.IsLt;
import org.xvm.asm.op.IsLte;
import org.xvm.asm.op.IsNotEq;
import org.xvm.asm.op.IsNull;
import org.xvm.asm.op.Jump;
import org.xvm.asm.op.JumpEq;
import org.xvm.asm.op.JumpGt;
import org.xvm.asm.op.JumpGte;
import org.xvm.asm.op.JumpLt;
import org.xvm.asm.op.JumpLte;
import org.xvm.asm.op.JumpNotEq;
import org.xvm.asm.op.JumpNotNull;
import org.xvm.asm.op.JumpNull;
import org.xvm.asm.op.Label;
import org.xvm.asm.op.Move;
import org.xvm.compiler.Token;
import org.xvm.compiler.ast.CmpExpression;
import org.xvm.compiler.ast.Context;
import org.xvm.compiler.ast.ConvertExpression;
import org.xvm.compiler.ast.Expression;
import org.xvm.util.Severity;

public class CmpChainExpression
extends Expression {
    protected List<Expression> expressions;
    protected Token[] operators;
    private TypeConstant m_typeCommon;
    protected transient MethodConstant m_idCmp;
    private Constant m_constEq;
    private static final Field[] CHILD_FIELDS = CmpChainExpression.fieldsForNames(CmpChainExpression.class, "expressions");

    public CmpChainExpression(List<Expression> expressions, Token[] operators) {
        this.expressions = expressions;
        this.operators = operators;
    }

    public boolean usesEquals() {
        Token.Id id = this.operators[0].getId();
        return id == Token.Id.COMP_EQ | id == Token.Id.COMP_NEQ;
    }

    public boolean isAscending() {
        Token.Id id = this.operators[0].getId();
        return id == Token.Id.COMP_LT | id == Token.Id.COMP_LTEQ;
    }

    @Override
    public long getStartPosition() {
        return this.expressions.getFirst().getStartPosition();
    }

    @Override
    public long getEndPosition() {
        return this.expressions.getLast().getEndPosition();
    }

    @Override
    protected Field[] getChildFields() {
        return CHILD_FIELDS;
    }

    @Override
    public TypeConstant getImplicitType(Context ctx) {
        return ctx.pool().typeBoolean();
    }

    @Override
    protected Expression validate(Context ctx, TypeConstant typeRequired, ErrorListener errs) {
        int i;
        boolean fInfer;
        boolean fForceFirst;
        boolean fValid = true;
        ConstantPool pool = ctx.pool();
        boolean fOrdered = !this.usesEquals();
        List<Expression> listExprs = this.expressions;
        int cExprs = listExprs.size();
        TypeConstant typeCommon = this.chooseCommonType(ctx, false);
        boolean bl = fForceFirst = typeCommon == null;
        if (fForceFirst) {
            Expression exprOld = listExprs.get(0);
            Expression exprNew = exprOld.validate(ctx, fOrdered ? pool.typeOrderable() : null, errs);
            if (exprNew == null) {
                return null;
            }
            if (exprNew != exprOld) {
                listExprs.set(0, exprNew);
            }
            typeCommon = this.chooseCommonType(ctx, false);
        }
        boolean bl2 = fInfer = typeCommon != null;
        if (fInfer) {
            ctx = ctx.enterInferring(typeCommon);
        } else {
            typeCommon = fOrdered ? pool.typeOrderable() : null;
        }
        int n = i = fForceFirst ? 1 : 0;
        while (i < cExprs) {
            Expression exprOld = listExprs.get(i);
            Expression exprNew = listExprs.get(i).validate(ctx, typeCommon, errs);
            if (exprNew == null) {
                fValid = false;
            } else if (exprNew != exprOld) {
                listExprs.set(i, exprNew);
            }
            ++i;
        }
        if (fInfer) {
            ctx = ctx.exit();
        } else {
            block30: {
                typeCommon = this.chooseCommonType(ctx, true);
                if (typeCommon != null) {
                    int i2;
                    MethodConstant[] aConvMethod = new MethodConstant[cExprs];
                    for (i2 = 0; i2 < cExprs; ++i2) {
                        TypeConstant typePre = listExprs.get(i2).getType();
                        if (typePre.isA(typeCommon)) continue;
                        MethodConstant method = typePre.getConverterTo(typeCommon);
                        if (method == null) {
                            typeCommon = null;
                            break block30;
                        }
                        aConvMethod[i2] = method;
                    }
                    for (i2 = 0; i2 < cExprs; ++i2) {
                        MethodConstant method = aConvMethod[i2];
                        if (method == null) continue;
                        listExprs.set(i2, new ConvertExpression(listExprs.get(i2), new MethodConstant[]{method}, errs));
                    }
                }
            }
            if (typeCommon == null) {
                if (fOrdered) {
                    this.log(errs, Severity.ERROR, "COMPILER-92", listExprs.getFirst().getType().getValueString(), "...");
                    fValid = false;
                } else {
                    typeCommon = pool.typeObject();
                }
            }
        }
        if (fValid) {
            assert (typeCommon != null);
            SignatureConstant sigCmp = fOrdered ? pool.sigCompare() : pool.sigEquals();
            MethodInfo infoCmp = typeCommon.ensureTypeInfo(errs).getMethodBySignature(sigCmp);
            if (infoCmp == null) {
                fValid = false;
                this.log(errs, Severity.ERROR, "COMPILER-56", sigCmp.getName(), typeCommon.getValueString());
            } else {
                this.m_typeCommon = typeCommon;
                this.m_idCmp = infoCmp.getIdentity();
            }
        }
        Constant constVal = null;
        if (fValid) {
            Constant constPrev = null;
            boolean fEquality = this.operators[0].getId() == Token.Id.COMP_EQ;
            SingletonConstant FALSE = pool.valFalse();
            boolean fAllConst = true;
            for (int i3 = 0; i3 < cExprs; ++i3) {
                Expression expr = listExprs.get(i3);
                boolean fConst = expr.isConstant();
                TypeConstant type = expr.getType();
                if (fEquality ? !typeCommon.supportsEquals(type, fConst) : !typeCommon.supportsCompare(type, fConst)) {
                    this.log(errs, Severity.ERROR, "COMPILER-92", typeCommon.getValueString(), type.getValueString());
                    return null;
                }
                if (fConst) {
                    if (fAllConst && i3 > 0) {
                        try {
                            constVal = constPrev.apply(this.operators[i3 - 1].getId(), expr.toConstant());
                        }
                        catch (RuntimeException e) {
                            constVal = null;
                            fAllConst = false;
                        }
                        if (constVal != null && constVal.equals(FALSE)) break;
                    }
                    if (!fEquality || this.m_constEq != null) continue;
                    this.m_constEq = expr.toConstant();
                    continue;
                }
                fAllConst = false;
            }
            if (this.m_constEq != null && this.m_constEq.equals(pool.valNull())) {
                fValid = this.checkNullComparison(ctx, listExprs, errs);
            }
        }
        return this.finishValidation(ctx, typeRequired, this.getImplicitType(ctx), fValid ? Expression.TypeFit.Fit : Expression.TypeFit.NoFit, constVal, errs);
    }

    @Override
    public void generateAssignment(Context ctx, MethodStructure.Code code, Expression.Assignable LVal, ErrorListener errs) {
        Argument arg;
        if (!LVal.isLocalArgument()) {
            super.generateAssignment(ctx, code, LVal, errs);
            return;
        }
        ConstantPool pool = this.pool();
        List<Expression> listExprs = this.expressions;
        int cExprs = listExprs.size();
        Argument[] aArgs = new Argument[cExprs];
        Constant constVal = this.m_constEq;
        TypeConstant typeCmp = this.m_typeCommon;
        Argument argResult = LVal.getLocalArgument();
        Label labelFalse = new Label("not_eq");
        Label labelEnd = new Label("end_eq");
        for (int i = 0; i < cExprs; ++i) {
            Expression expr = listExprs.get(i);
            arg = expr.generateArgument(ctx, code, false, i == cExprs - 1, errs);
            aArgs[i] = expr.ensurePointInTime(code, arg, listExprs, i);
        }
        if (constVal == null) {
            Token[] aTokOp = this.operators;
            int cOps = aTokOp.length;
            for (int iCmp = 0; iCmp < cOps; ++iCmp) {
                Token tok = aTokOp[iCmp];
                Argument arg1 = aArgs[iCmp];
                Argument arg2 = aArgs[iCmp + 1];
                if (iCmp == cOps - 1) {
                    code.add(switch (tok.getId()) {
                        case Token.Id.COMP_EQ -> new IsEq(typeCmp, arg1, arg2, argResult);
                        case Token.Id.COMP_NEQ -> new IsNotEq(typeCmp, arg1, arg2, argResult);
                        case Token.Id.COMP_LT -> new IsLt(typeCmp, arg1, arg2, argResult);
                        case Token.Id.COMP_GT -> new IsGt(typeCmp, arg1, arg2, argResult);
                        case Token.Id.COMP_LTEQ -> new IsLte(typeCmp, arg1, arg2, argResult);
                        case Token.Id.COMP_GTEQ -> new IsGte(typeCmp, arg1, arg2, argResult);
                        default -> throw new IllegalStateException();
                    });
                    continue;
                }
                code.add(switch (tok.getId()) {
                    case Token.Id.COMP_EQ -> new JumpNotEq(typeCmp, arg1, arg2, labelFalse);
                    case Token.Id.COMP_NEQ -> new JumpEq(typeCmp, arg1, arg2, labelFalse);
                    case Token.Id.COMP_LT -> new JumpGte(typeCmp, arg1, arg2, labelFalse);
                    case Token.Id.COMP_GT -> new JumpLte(typeCmp, arg1, arg2, labelFalse);
                    case Token.Id.COMP_LTEQ -> new JumpGt(typeCmp, arg1, arg2, labelFalse);
                    case Token.Id.COMP_GTEQ -> new JumpLt(typeCmp, arg1, arg2, labelFalse);
                    default -> throw new IllegalStateException();
                });
            }
        } else {
            boolean fNull = constVal.equals(pool.valNull());
            for (int iExpr = 0; iExpr < cExprs; ++iExpr) {
                arg = aArgs[iExpr];
                if (iExpr == cExprs - 1) {
                    OpTest opTest = fNull ? new IsNull(arg, argResult) : new IsEq(typeCmp, arg, constVal, argResult);
                    code.add(opTest);
                    continue;
                }
                OpCondJump opCondJump = fNull ? new JumpNotNull(arg, labelFalse) : new JumpNotEq(typeCmp, arg, constVal, labelFalse);
                code.add(opCondJump);
            }
        }
        code.add(new Jump(labelEnd)).add(labelFalse).add(new Move(pool.valFalse(), argResult)).add(labelEnd);
    }

    @Override
    public void generateConditionalJump(Context ctx, MethodStructure.Code code, Label label, boolean fWhenTrue, ErrorListener errs) {
        Argument arg;
        if (this.isConstant()) {
            super.generateConditionalJump(ctx, code, label, fWhenTrue, errs);
            return;
        }
        List<Expression> listExprs = this.expressions;
        int cExprs = listExprs.size();
        Argument[] aArgs = new Argument[cExprs];
        Constant constVal = this.m_constEq;
        TypeConstant typeCmp = this.m_typeCommon;
        for (int i = 0; i < cExprs; ++i) {
            Expression expr = listExprs.get(i);
            arg = expr.generateArgument(ctx, code, false, i == cExprs - 1, errs);
            aArgs[i] = expr.ensurePointInTime(code, arg, listExprs, i);
        }
        if (constVal != null) {
            boolean fNull = constVal.equals(this.pool().valNull());
            for (int i = 0; i < cExprs; ++i) {
                arg = aArgs[i];
                OpCondJump op = fNull ? new JumpNull(arg, label) : new JumpEq(typeCmp, arg, constVal, label);
                code.add(op);
            }
            return;
        }
        Label labelFalse = fWhenTrue ? new Label("not_eq") : label;
        Token[] aTokOp = this.operators;
        int cOps = aTokOp.length;
        for (int iCmp = 0; iCmp < cOps; ++iCmp) {
            Argument arg1 = aArgs[iCmp];
            Argument arg2 = aArgs[iCmp + 1];
            code.add(switch (aTokOp[iCmp].getId()) {
                case Token.Id.COMP_EQ -> new JumpNotEq(typeCmp, arg1, arg2, labelFalse);
                case Token.Id.COMP_NEQ -> new JumpEq(typeCmp, arg1, arg2, labelFalse);
                case Token.Id.COMP_LT -> new JumpGte(typeCmp, arg1, arg2, labelFalse);
                case Token.Id.COMP_GT -> new JumpLte(typeCmp, arg1, arg2, labelFalse);
                case Token.Id.COMP_LTEQ -> new JumpGt(typeCmp, arg1, arg2, labelFalse);
                case Token.Id.COMP_GTEQ -> new JumpLt(typeCmp, arg1, arg2, labelFalse);
                default -> throw new IllegalStateException();
            });
        }
        if (fWhenTrue) {
            code.add(new Jump(label));
            code.add(labelFalse);
        }
    }

    @Override
    public ExprAST getExprAST(Context ctx) {
        int cExpr = this.expressions.size();
        ExprAST[] aAst = new ExprAST[cExpr];
        BiExprAST.Operator[] aOp = new BiExprAST.Operator[cExpr - 1];
        for (int i = 0; i < cExpr; ++i) {
            aAst[i] = this.expressions.get(i).getExprAST(ctx);
            if (i >= cExpr - 1) continue;
            aOp[i] = switch (this.operators[i].getId()) {
                case Token.Id.COMP_EQ -> BiExprAST.Operator.CompEq;
                case Token.Id.COMP_NEQ -> BiExprAST.Operator.CompNeq;
                case Token.Id.COMP_LT -> BiExprAST.Operator.CompLt;
                case Token.Id.COMP_GT -> BiExprAST.Operator.CompGt;
                case Token.Id.COMP_LTEQ -> BiExprAST.Operator.CompLtEq;
                case Token.Id.COMP_GTEQ -> BiExprAST.Operator.CompGtEq;
                default -> throw new IllegalStateException();
            };
        }
        return new CmpChainExprAST(aAst, aOp, this.m_idCmp);
    }

    @Override
    public boolean isShortCircuiting() {
        for (Expression expr : this.expressions) {
            if (!expr.isShortCircuiting()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isCompletable() {
        return this.expressions.get(0).isCompletable() && this.expressions.get(1).isCompletable();
    }

    protected TypeConstant chooseCommonType(Context ctx, boolean fCheck) {
        ConstantPool pool = this.pool();
        boolean fEqual = this.usesEquals();
        List<Expression> listExprs = this.expressions;
        HashSet<TypeConstant> setTried = new HashSet<TypeConstant>();
        int c = listExprs.size();
        for (int i = 0; i < c; ++i) {
            Expression expr1 = listExprs.get(i);
            TypeConstant type1 = expr1.getImplicitType(ctx);
            if (type1 == null) continue;
            ctx = ctx.enterInferring(type1);
            for (int j = 0; j < c; ++j) {
                Expression expr2;
                TypeConstant type2;
                TypeConstant typeC;
                if (j == i || (typeC = CmpExpression.chooseCommonType(pool, fEqual, type1, type2 = (expr2 = listExprs.get(j)).getImplicitType(ctx))) == null || setTried.contains(typeC)) continue;
                if (this.testCommonType(ctx = ctx.exit(), typeC)) {
                    return typeC;
                }
                setTried.add(typeC);
                ctx = ctx.enterInferring(type1);
            }
        }
        return null;
    }

    protected boolean testCommonType(Context ctx, TypeConstant type) {
        ctx = ctx.enterInferring(type);
        for (Expression expr : this.expressions) {
            if (expr.testFit(ctx, type, false, null).isFit()) continue;
            return false;
        }
        return true;
    }

    boolean checkNullComparison(Context ctx, List<Expression> listExprs, ErrorListener errs) {
        TypeConstant typeNull = this.pool().typeNull();
        for (Expression expr : listExprs) {
            TypeConstant type = expr.getType();
            if (type.isNullable() || typeNull.isA(type.resolveConstraints())) continue;
            this.log(errs, Severity.ERROR, "COMPILER-91", type.getValueString());
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.expressions.get(0));
        int c = this.operators.length;
        for (int i = 0; i < c; ++i) {
            sb.append(' ').append(this.operators[i].getId().TEXT).append(' ').append(this.expressions.get(i + 1));
        }
        return sb.toString();
    }

    @Override
    public String getDumpDesc() {
        return this.toString();
    }
}

