/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.compiler.ast;

import org.xvm.asm.Argument;
import org.xvm.asm.Component;
import org.xvm.asm.ConstantPool;
import org.xvm.asm.ErrorListener;
import org.xvm.asm.MethodStructure;
import org.xvm.asm.Op;
import org.xvm.asm.OpTest;
import org.xvm.asm.Register;
import org.xvm.asm.ast.CallExprAST;
import org.xvm.asm.ast.ConstantExprAST;
import org.xvm.asm.ast.ExprAST;
import org.xvm.asm.ast.NotNullExprAST;
import org.xvm.asm.ast.OrderedExprAST;
import org.xvm.asm.ast.UnaryExprAST;
import org.xvm.asm.ast.UnaryOpExprAST;
import org.xvm.asm.constants.CastTypeConstant;
import org.xvm.asm.constants.MethodConstant;
import org.xvm.asm.constants.TypeConstant;
import org.xvm.asm.constants.TypeInfo;
import org.xvm.asm.op.Cmp;
import org.xvm.asm.op.IsEq;
import org.xvm.asm.op.IsGt;
import org.xvm.asm.op.IsGte;
import org.xvm.asm.op.IsLt;
import org.xvm.asm.op.IsLte;
import org.xvm.asm.op.IsNotEq;
import org.xvm.asm.op.IsNotNull;
import org.xvm.asm.op.IsNull;
import org.xvm.asm.op.JumpEq;
import org.xvm.asm.op.JumpGt;
import org.xvm.asm.op.JumpGte;
import org.xvm.asm.op.JumpLt;
import org.xvm.asm.op.JumpLte;
import org.xvm.asm.op.JumpNotEq;
import org.xvm.asm.op.JumpNotNull;
import org.xvm.asm.op.JumpNull;
import org.xvm.asm.op.Label;
import org.xvm.compiler.Token;
import org.xvm.compiler.ast.BiExpression;
import org.xvm.compiler.ast.Context;
import org.xvm.compiler.ast.Expression;
import org.xvm.compiler.ast.NameExpression;
import org.xvm.util.Severity;

public class CmpExpression
extends BiExpression {
    protected transient TypeConstant m_typeCommon;
    protected transient MethodConstant m_idCmp;
    private transient boolean m_fArg1Null;
    private transient boolean m_fArg2Null;

    public CmpExpression(Expression expr1, Token operator, Expression expr2) {
        super(expr1, operator, expr2);
        switch (operator.getId()) {
            case COMP_EQ: 
            case COMP_NEQ: 
            case COMP_LT: 
            case COMP_GT: 
            case COMP_LTEQ: 
            case COMP_GTEQ: 
            case COMP_ORD: {
                break;
            }
            default: {
                throw new IllegalArgumentException("operator: " + String.valueOf(operator));
            }
        }
    }

    public boolean producesBoolean() {
        return this.operator.getId() != Token.Id.COMP_ORD;
    }

    public boolean usesEquals() {
        Token.Id id = this.operator.getId();
        return id == Token.Id.COMP_EQ | id == Token.Id.COMP_NEQ;
    }

    public boolean isAscending() {
        Token.Id id = this.operator.getId();
        return id == Token.Id.COMP_LT | id == Token.Id.COMP_LTEQ;
    }

    @Override
    public TypeConstant getImplicitType(Context ctx) {
        return this.producesBoolean() ? this.pool().typeBoolean() : this.pool().typeOrdered();
    }

    /*
     * Unable to fully structure code
     */
    @Override
    protected Expression validate(Context ctx, TypeConstant typeRequired, ErrorListener errs) {
        block37: {
            block38: {
                pool = this.pool();
                fValid = true;
                fEqual = this.usesEquals();
                type1 = this.expr1.getImplicitType(ctx);
                v0 = fInfer = type1 != null;
                if (fInfer) {
                    ctx = ctx.enterInferring(type1);
                }
                type2 = this.expr2.getImplicitType(ctx);
                if (fInfer) {
                    ctx = ctx.exit();
                }
                type1Orig = type1;
                type2Orig = type2;
                var14_12 = this.expr1;
                if (var14_12 instanceof NameExpression && (var14_12 = ctx.getVar((exprName = (NameExpression)var14_12).getName())) instanceof Register) {
                    reg = (Register)var14_12;
                    type1Orig = reg.getOriginalType();
                }
                if ((var14_12 = this.expr2) instanceof NameExpression && (var14_12 = ctx.getVar((exprName = (NameExpression)var14_12).getName())) instanceof Register) {
                    reg = (Register)var14_12;
                    type2Orig = reg.getOriginalType();
                }
                if ((expr1New = this.expr1.validate(ctx, typeRequest = CmpExpression.chooseCommonType(pool, fEqual, type1, type1Orig, false, type2, type2Orig, false, false), errs)) == null) {
                    fValid = false;
                } else {
                    this.expr1 = expr1New;
                    type1 = expr1New.getType();
                    if (typeRequest == null) {
                        typeRequest = CmpExpression.chooseCommonType(pool, fEqual, type1, type2);
                    }
                    if (typeRequest == null) {
                        typeRequest = type1;
                    }
                }
                if (fInfer) {
                    ctx = ctx.enterInferring(type1);
                }
                expr2New = this.expr2.validate(ctx, typeRequest, errs);
                if (fInfer) {
                    ctx = ctx.exit();
                }
                if (expr2New == null) {
                    fValid = false;
                } else {
                    this.expr2 = expr2New;
                    type2 = expr2New.getType();
                    if (fValid) {
                        fConst1 = expr1New.isConstant();
                        typeCommon = CmpExpression.chooseCommonType(pool, fEqual, type1, fConst1, type2, fConst2 = expr2New.isConstant(), true);
                        if (typeCommon == null) {
                            typeCommon = CmpExpression.chooseCommonType(pool, fEqual, type1, type1Orig, fConst1, type2, type2Orig, fConst2, true);
                        }
                        if (typeCommon == null) {
                            type1R = ctx.resolveFormalType(type1);
                            type2R = ctx.resolveFormalType(type2);
                            typeCommon = CmpExpression.chooseCommonType(pool, fEqual, type1R, fConst1, type2R, fConst2, true);
                        }
                        if (typeCommon == null) {
                            fValid = false;
                            if (type1.equals(pool.typeNull())) {
                                this.log(errs, Severity.ERROR, "COMPILER-91", new Object[]{type2.getValueString()});
                            } else if (type2.equals(pool.typeNull())) {
                                this.log(errs, Severity.ERROR, "COMPILER-91", new Object[]{type1.getValueString()});
                            } else {
                                this.log(errs, Severity.ERROR, "COMPILER-92", new Object[]{type1.getValueString(), type2.getValueString()});
                            }
                        } else {
                            sigCmp = fEqual != false ? pool.sigEquals() : pool.sigCompare();
                            infoCmp = typeCommon.ensureTypeInfo(errs).getMethodBySignature(sigCmp);
                            if (infoCmp == null) {
                                fValid = false;
                                this.log(errs, Severity.ERROR, "COMPILER-56", new Object[]{sigCmp.getName(), typeCommon.getValueString()});
                            } else {
                                this.m_typeCommon = typeCommon;
                                this.m_idCmp = infoCmp.getIdentity();
                            }
                        }
                    }
                }
                typeResult = this.getImplicitType(ctx);
                constVal = null;
                if (!fValid) break block37;
                if (!expr1New.isConstant() || !expr2New.isConstant()) break block38;
                try {
                    constVal = expr1New.toConstant().apply(this.operator.getId(), expr2New.toConstant());
                }
                catch (RuntimeException typeCommon) {}
                break block37;
            }
            this.m_fArg1Null = type1.equals(pool.typeNull());
            this.m_fArg2Null = type2.equals(pool.typeNull());
            if (!(expr1New instanceof NameExpression)) ** GOTO lbl-1000
            expr1Name = (NameExpression)expr1New;
            if (this.m_fArg2Null) {
                fValid = this.checkNullComparison(ctx, expr1Name, errs);
            } else if (type2.isTypeOfType()) {
                this.checkFormalType(ctx, expr1Name, type2);
            } else if (expr2New.isConstant() && !type2.equals(type1)) {
                this.checkConstType(ctx, expr1Name, type2);
            } else if (expr2New instanceof NameExpression) {
                expr2Name = (NameExpression)expr2New;
                if (this.m_fArg1Null) {
                    fValid = this.checkNullComparison(ctx, expr2Name, errs);
                } else if (type1.isTypeOfType()) {
                    this.checkFormalType(ctx, expr2Name, type1);
                } else if (expr1New.isConstant() && !type1.equals(type2)) {
                    this.checkConstType(ctx, expr2Name, type1);
                }
            }
        }
        return this.finishValidation(ctx, typeRequired, typeResult, fValid != false ? Expression.TypeFit.Fit : Expression.TypeFit.NoFit, constVal, errs);
    }

    protected static TypeConstant chooseCommonType(ConstantPool pool, boolean fEqual, TypeConstant type1, TypeConstant type1Orig, boolean fConst1, TypeConstant type2, TypeConstant type2Orig, boolean fConst2, boolean fCheck) {
        TypeConstant typeCommon = CmpExpression.chooseCommonType(pool, fEqual, type1, fConst1, type2, fConst2, fCheck);
        if (typeCommon == null) {
            if (type1 != null && type1.equals(type1Orig)) {
                if (!type2.equals(type2Orig)) {
                    typeCommon = CmpExpression.chooseCommonType(pool, fEqual, type1, fConst1, type2Orig, fConst2, fCheck);
                }
            } else {
                typeCommon = CmpExpression.chooseCommonType(pool, fEqual, type1Orig, fConst1, type2, fConst2, fCheck);
                if (typeCommon == null && type2 != null && !type2.equals(type2Orig)) {
                    typeCommon = CmpExpression.chooseCommonType(pool, fEqual, type1Orig, fConst1, type2Orig, fConst2, fCheck);
                }
            }
        }
        return typeCommon;
    }

    protected static TypeConstant chooseCommonType(ConstantPool pool, boolean fEqual, TypeConstant type1, TypeConstant type2) {
        return CmpExpression.chooseCommonType(pool, fEqual, type1, false, type2, false, false);
    }

    protected static TypeConstant chooseCommonType(ConstantPool pool, boolean fEqual, TypeConstant type1, boolean fConst1, TypeConstant type2, boolean fConst2, boolean fCheck) {
        if (type1 == null && type2 == null || type1 != null && type1.containsUnresolved() || type2 != null && type2.containsUnresolved()) {
            return null;
        }
        if (type1 instanceof CastTypeConstant) {
            type1 = type1.getUnderlyingType2();
        }
        if (type2 instanceof CastTypeConstant) {
            type2 = type2.getUnderlyingType2();
        }
        TypeConstant typeCommon = Op.selectCommonType(type1, type2, ErrorListener.BLACKHOLE);
        if (type1 == null || type2 == null) {
            return typeCommon;
        }
        if (typeCommon != null && fCheck) {
            if (fEqual ? typeCommon.supportsEquals(type1, fConst1) && typeCommon.supportsEquals(type2, fConst2) : typeCommon.supportsCompare(type1, fConst1) && typeCommon.supportsCompare(type2, fConst2)) {
                return typeCommon;
            }
            typeCommon = null;
        }
        if (typeCommon == null) {
            boolean fFormal2;
            if (fEqual && type1.isA(pool.typeRef()) && type2.isA(pool.typeRef())) {
                return pool.typeRef();
            }
            if (fEqual && (type1.isA(pool.typeType()) && type2.isA(pool.typeClass()) || type2.isA(pool.typeType()) && type1.isA(pool.typeClass()))) {
                return pool.typeType();
            }
            boolean fFormal1 = type1.containsFormalType(true);
            if (fFormal1 ^ (fFormal2 = type2.containsFormalType(true))) {
                if (fFormal1) {
                    type1 = type1.resolveConstraints();
                }
                if (fFormal2) {
                    type2 = type2.resolveConstraints();
                }
                typeCommon = CmpExpression.chooseCommonType(pool, fEqual, type1, fConst1, type2, fConst2, fCheck);
            }
        }
        return typeCommon;
    }

    private boolean checkNullComparison(Context ctx, NameExpression exprTarget, ErrorListener errs) {
        TypeConstant typeTarget = exprTarget.getType();
        TypeConstant typeNull = this.pool().typeNull();
        TypeConstant typeTrue = null;
        TypeConstant typeFalse = null;
        if (!typeTarget.isNullable() && !typeNull.isA(typeTarget.resolveConstraints())) {
            this.log(errs, Severity.ERROR, "COMPILER-91", typeTarget.getValueString());
            return false;
        }
        if (typeTarget.isOnlyNullable()) {
            this.log(errs, Severity.WARNING, "COMPILER-137", exprTarget, typeNull, typeNull);
        }
        switch (this.operator.getId()) {
            case COMP_EQ: {
                typeTrue = typeNull;
                typeFalse = typeTarget.removeNullable();
                break;
            }
            case COMP_NEQ: {
                typeTrue = typeTarget.removeNullable();
                typeFalse = typeNull;
            }
        }
        exprTarget.narrowType(ctx, Context.Branch.WhenTrue, typeTrue);
        exprTarget.narrowType(ctx, Context.Branch.WhenFalse, typeFalse);
        return true;
    }

    private void checkFormalType(Context ctx, NameExpression exprTarget, TypeConstant typeType) {
        TypeConstant typeTarget = exprTarget.getType();
        if (typeTarget.isFormalTypeType()) {
            switch (this.operator.getId()) {
                case COMP_EQ: {
                    exprTarget.narrowType(ctx, Context.Branch.WhenTrue, typeType);
                    break;
                }
                case COMP_NEQ: {
                    exprTarget.narrowType(ctx, Context.Branch.WhenFalse, typeType);
                }
            }
        }
    }

    private void checkConstType(Context ctx, NameExpression exprTarget, TypeConstant type) {
        TypeInfo info = type.ensureTypeInfo();
        if (info.getFormat() == Component.Format.ENUMVALUE) {
            type = info.getExtends();
        }
        if (!type.equals(exprTarget.getType())) {
            switch (this.operator.getId()) {
                case COMP_EQ: {
                    exprTarget.narrowType(ctx, Context.Branch.WhenTrue, type);
                    break;
                }
                case COMP_NEQ: {
                    exprTarget.narrowType(ctx, Context.Branch.WhenFalse, type);
                }
            }
        }
    }

    @Override
    public void generateAssignment(Context ctx, MethodStructure.Code code, Expression.Assignable LVal, ErrorListener errs) {
        if (LVal.isLocalArgument()) {
            Argument arg1 = this.expr1.ensurePointInTime(code, this.expr1.generateArgument(ctx, code, true, true, errs), this.expr2);
            Argument arg2 = this.expr2.generateArgument(ctx, code, true, true, errs);
            Argument argResult = LVal.getLocalArgument();
            OpTest op = switch (this.operator.getId()) {
                case Token.Id.COMP_EQ -> {
                    if (this.m_fArg1Null) {
                        yield new IsNull(arg2, argResult);
                    }
                    if (this.m_fArg2Null) {
                        yield new IsNull(arg1, argResult);
                    }
                    yield new IsEq(this.m_typeCommon, arg1, arg2, argResult);
                }
                case Token.Id.COMP_NEQ -> {
                    if (this.m_fArg1Null) {
                        yield new IsNotNull(arg2, argResult);
                    }
                    if (this.m_fArg2Null) {
                        yield new IsNotNull(arg1, argResult);
                    }
                    yield new IsNotEq(this.m_typeCommon, arg1, arg2, argResult);
                }
                case Token.Id.COMP_LT -> new IsLt(this.m_typeCommon, arg1, arg2, argResult);
                case Token.Id.COMP_GT -> new IsGt(this.m_typeCommon, arg1, arg2, argResult);
                case Token.Id.COMP_LTEQ -> new IsLte(this.m_typeCommon, arg1, arg2, argResult);
                case Token.Id.COMP_GTEQ -> new IsGte(this.m_typeCommon, arg1, arg2, argResult);
                case Token.Id.COMP_ORD -> new Cmp(this.m_typeCommon, arg1, arg2, argResult);
                default -> throw new IllegalStateException();
            };
            code.add(op);
            return;
        }
        super.generateAssignment(ctx, code, LVal, errs);
    }

    @Override
    public void generateConditionalJump(Context ctx, MethodStructure.Code code, Label label, boolean fWhenTrue, ErrorListener errs) {
        if (!this.isConstant() && this.producesBoolean()) {
            Argument arg1 = this.expr1.ensurePointInTime(code, this.expr1.generateArgument(ctx, code, true, true, errs), this.expr2);
            Argument arg2 = this.expr2.generateArgument(ctx, code, true, true, errs);
            code.add(switch (this.operator.getId()) {
                case Token.Id.COMP_EQ -> {
                    if (fWhenTrue) {
                        if (this.m_fArg1Null) {
                            yield new JumpNull(arg2, label);
                        }
                        if (this.m_fArg2Null) {
                            yield new JumpNull(arg1, label);
                        }
                        yield new JumpEq(this.m_typeCommon, arg1, arg2, label);
                    }
                    if (this.m_fArg1Null) {
                        yield new JumpNotNull(arg2, label);
                    }
                    if (this.m_fArg2Null) {
                        yield new JumpNotNull(arg1, label);
                    }
                    yield new JumpNotEq(this.m_typeCommon, arg1, arg2, label);
                }
                case Token.Id.COMP_NEQ -> {
                    if (fWhenTrue) {
                        if (this.m_fArg1Null) {
                            yield new JumpNotNull(arg2, label);
                        }
                        if (this.m_fArg2Null) {
                            yield new JumpNotNull(arg1, label);
                        }
                        yield new JumpNotEq(this.m_typeCommon, arg1, arg2, label);
                    }
                    if (this.m_fArg1Null) {
                        yield new JumpNull(arg2, label);
                    }
                    if (this.m_fArg2Null) {
                        yield new JumpNull(arg1, label);
                    }
                    yield new JumpEq(this.m_typeCommon, arg1, arg2, label);
                }
                case Token.Id.COMP_LT -> {
                    if (fWhenTrue) {
                        yield new JumpLt(this.m_typeCommon, arg1, arg2, label);
                    }
                    yield new JumpGte(this.m_typeCommon, arg1, arg2, label);
                }
                case Token.Id.COMP_GT -> {
                    if (fWhenTrue) {
                        yield new JumpGt(this.m_typeCommon, arg1, arg2, label);
                    }
                    yield new JumpLte(this.m_typeCommon, arg1, arg2, label);
                }
                case Token.Id.COMP_LTEQ -> {
                    if (fWhenTrue) {
                        yield new JumpLte(this.m_typeCommon, arg1, arg2, label);
                    }
                    yield new JumpGt(this.m_typeCommon, arg1, arg2, label);
                }
                case Token.Id.COMP_GTEQ -> {
                    if (fWhenTrue) {
                        yield new JumpGte(this.m_typeCommon, arg1, arg2, label);
                    }
                    yield new JumpLt(this.m_typeCommon, arg1, arg2, label);
                }
                default -> throw new IllegalStateException();
            });
            return;
        }
        super.generateConditionalJump(ctx, code, label, fWhenTrue, errs);
    }

    @Override
    public ExprAST getExprAST(Context ctx) {
        ExprAST exprAst;
        ConstantPool pool = this.pool();
        ExprAST ast1 = this.expr1.getExprAST(ctx);
        ExprAST ast2 = this.expr2.getExprAST(ctx);
        if (this.m_fArg1Null || this.m_fArg2Null) {
            boolean fNot = false;
            switch (this.operator.getId()) {
                case COMP_EQ: {
                    break;
                }
                case COMP_NEQ: {
                    fNot = true;
                    break;
                }
                default: {
                    throw new UnsupportedOperationException(this.operator.getValueText());
                }
            }
            UnaryExprAST exprAST = new NotNullExprAST(this.m_fArg1Null ? ast2 : ast1, pool.typeBoolean());
            if (!fNot) {
                exprAST = new UnaryOpExprAST(exprAST, UnaryOpExprAST.Operator.Not, pool.typeBoolean());
            }
            return exprAST;
        }
        ExprAST[] aAstArgs = new ExprAST[]{CmpExpression.toTypeParameterAst(ctx, this.m_typeCommon.getType()), ast1, ast2};
        ConstantExprAST exprCmp = new ConstantExprAST(this.m_idCmp);
        boolean fNot = false;
        OrderedExprAST.Operator opCmp = null;
        switch (this.operator.getId()) {
            case COMP_ORD: {
                return new CallExprAST(exprCmp, pool.typeOrdered(), aAstArgs);
            }
            case COMP_EQ: {
                break;
            }
            case COMP_NEQ: {
                fNot = true;
                break;
            }
            case COMP_LT: {
                opCmp = OrderedExprAST.Operator.Less;
                break;
            }
            case COMP_GT: {
                opCmp = OrderedExprAST.Operator.Greater;
                break;
            }
            case COMP_LTEQ: {
                opCmp = OrderedExprAST.Operator.Greater;
                fNot = true;
                break;
            }
            case COMP_GTEQ: {
                opCmp = OrderedExprAST.Operator.Less;
                fNot = true;
                break;
            }
            default: {
                throw new UnsupportedOperationException(this.operator.getValueText());
            }
        }
        ExprAST exprAST = exprAst = opCmp == null ? new CallExprAST(exprCmp, pool.typeBoolean(), aAstArgs) : new OrderedExprAST(new CallExprAST(exprCmp, pool.typeOrdered(), aAstArgs), opCmp);
        if (fNot) {
            exprAst = new UnaryOpExprAST(exprAst, UnaryOpExprAST.Operator.Not, pool.typeBoolean());
        }
        return exprAst;
    }
}

