/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.compiler.ast;

import java.util.List;
import org.xvm.asm.Annotation;
import org.xvm.asm.Component;
import org.xvm.asm.ConstantPool;
import org.xvm.asm.Constants;
import org.xvm.compiler.Token;
import org.xvm.compiler.ast.AnnotationExpression;
import org.xvm.compiler.ast.Statement;
import org.xvm.compiler.ast.TypeExpression;

public abstract class ComponentStatement
extends Statement {
    private Component component;
    private final long lStartPos;
    private final long lEndPos;

    protected ComponentStatement(long lStartPos, long lEndPos) {
        this.lStartPos = lStartPos;
        this.lEndPos = lEndPos;
    }

    @Override
    public boolean isComponentNode() {
        return true;
    }

    @Override
    public Component getComponent() {
        return this.component;
    }

    protected void setComponent(Component component) {
        this.component = component;
    }

    @Override
    public boolean isAutoNarrowingAllowed(TypeExpression type) {
        return false;
    }

    @Override
    protected ConstantPool pool() {
        return this.component == null ? super.pool() : this.component.getConstantPool();
    }

    @Override
    public long getStartPosition() {
        return this.lStartPos;
    }

    @Override
    public long getEndPosition() {
        return this.lEndPos;
    }

    protected AnnotationExpression findAnnotationExpression(Annotation anno, List<AnnotationExpression> listAnno) {
        if (listAnno.size() > 1) {
            for (AnnotationExpression exprAnno : listAnno) {
                if (!exprAnno.ensureAnnotation(this.pool()).equals(anno)) continue;
                return exprAnno;
            }
        }
        return listAnno.getFirst();
    }

    public static boolean isStatic(List<Token> modifiers) {
        if (modifiers != null && !modifiers.isEmpty()) {
            for (Token modifier : modifiers) {
                if (modifier.getId() != Token.Id.STATIC) continue;
                return true;
            }
        }
        return false;
    }

    public static Constants.Access getAccess(List<Token> modifiers) {
        if (modifiers != null && !modifiers.isEmpty()) {
            for (Token modifier : modifiers) {
                switch (modifier.getId()) {
                    case PUBLIC: {
                        return Constants.Access.PUBLIC;
                    }
                    case PROTECTED: {
                        return Constants.Access.PROTECTED;
                    }
                    case PRIVATE: {
                        return Constants.Access.PRIVATE;
                    }
                }
            }
        }
        return null;
    }
}

