/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.compiler.ast;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.xvm.asm.Annotation;
import org.xvm.asm.Component;
import org.xvm.asm.ConstantPool;
import org.xvm.asm.Version;
import org.xvm.asm.VersionTree;
import org.xvm.compiler.Source;
import org.xvm.compiler.Token;
import org.xvm.compiler.ast.AnnotationExpression;
import org.xvm.compiler.ast.AstNode;
import org.xvm.compiler.ast.Expression;
import org.xvm.compiler.ast.NamedTypeExpression;
import org.xvm.compiler.ast.Parameter;
import org.xvm.compiler.ast.TypeExpression;
import org.xvm.compiler.ast.VersionOverride;

public abstract class CompositionNode
extends AstNode {
    protected Expression condition;
    protected Token keyword;
    protected TypeExpression type;
    private transient Component.Contribution m_contribution;
    private static final Field[] CHILD_FIELDS = CompositionNode.fieldsForNames(CompositionNode.class, "condition", "type");

    public CompositionNode(Expression condition, Token keyword, TypeExpression type) {
        this.condition = condition;
        this.keyword = keyword;
        this.type = type;
    }

    public Expression getCondition() {
        return this.condition;
    }

    public Token getKeyword() {
        return this.keyword;
    }

    public TypeExpression getType() {
        return this.type;
    }

    public Component.Contribution getContribution() {
        return this.m_contribution;
    }

    public void setContribution(Component.Contribution contribution) {
        this.m_contribution = contribution;
    }

    @Override
    public Source getSource() {
        Source source = super.getSource();
        if (source == null) {
            source = this.condition == null ? this.type.getSource() : this.condition.getSource();
        }
        return source;
    }

    @Override
    public long getStartPosition() {
        return this.condition == null ? this.keyword.getStartPosition() : this.condition.getStartPosition();
    }

    @Override
    public long getEndPosition() {
        return this.condition == null ? this.type.getEndPosition() : this.condition.getEndPosition();
    }

    @Override
    protected Field[] getChildFields() {
        return CHILD_FIELDS;
    }

    @Override
    public String toString() {
        return this.toStartString() + this.toEndString();
    }

    public String toStartString() {
        StringBuilder sb = new StringBuilder();
        if (this.condition != null) {
            sb.append("if (").append(this.condition).append(") { ");
        }
        sb.append(this.keyword.getId().TEXT);
        if (this.type != null) {
            sb.append(' ').append(this.type);
        }
        return sb.toString();
    }

    protected String toEndString() {
        return this.condition == null ? "" : " }";
    }

    @Override
    public String getDumpDesc() {
        return this.toString();
    }

    public static class Default
    extends CompositionNode {
        protected Expression expr;
        protected long lEndPos;
        private static final Field[] CHILD_FIELDS = Default.fieldsForNames(Default.class, "condition", "expr");

        public Default(Expression condition, Token keyword, Expression expr, long lEndPos) {
            super(condition, keyword, null);
            this.expr = expr;
            this.lEndPos = lEndPos;
        }

        public Expression getValueExpression() {
            return this.expr;
        }

        @Override
        public long getEndPosition() {
            return this.lEndPos;
        }

        @Override
        protected Field[] getChildFields() {
            return CHILD_FIELDS;
        }

        @Override
        public String toString() {
            return this.toStartString() + "(" + String.valueOf(this.expr) + ")" + this.toEndString();
        }
    }

    public static class Import
    extends CompositionNode {
        protected Token modifier;
        protected List<VersionOverride> vers;
        protected List<Parameter> injects;
        protected NamedTypeExpression injector;
        protected long lEndPos;
        private static final Field[] CHILD_FIELDS = Import.fieldsForNames(Import.class, "condition", "type", "vers", "injects", "injector");

        public Import(Expression condition, Token keyword, Token modifier, NamedTypeExpression type, List<VersionOverride> vers, List<Parameter> injects, NamedTypeExpression injector, long lEndPos) {
            super(condition, keyword, type);
            this.modifier = modifier;
            this.vers = vers;
            this.injects = injects;
            this.injector = injector;
            this.lEndPos = lEndPos;
        }

        public Token getModifier() {
            return this.modifier;
        }

        public Token.Id getImplicitModifier() {
            return this.modifier == null ? Token.Id.REQUIRED : this.modifier.getId();
        }

        public VersionTree<Boolean> getAllowVersionTree() {
            VersionTree<Boolean> vtree = new VersionTree<Boolean>();
            if (this.vers != null) {
                for (VersionOverride override : this.vers) {
                    Version ver = override.getVersion();
                    Boolean BPrevAllow = vtree.get(ver);
                    boolean fAllow = override.isAllowed();
                    if (BPrevAllow != null && fAllow != BPrevAllow) {
                        throw new IllegalStateException("version " + String.valueOf(ver) + " is both allowed and disallowed");
                    }
                    vtree.put(ver, fAllow);
                }
            }
            return vtree;
        }

        public List<Version> getPreferVersionList() {
            if (this.vers == null) {
                return Collections.emptyList();
            }
            ArrayList<Version> list = new ArrayList<Version>();
            for (VersionOverride override : this.vers) {
                if (!override.isPreferred()) continue;
                list.add(override.getVersion());
            }
            return list;
        }

        NamedTypeExpression getInjector() {
            return this.injector;
        }

        List<Parameter> getSpecificInjections() {
            return this.injects;
        }

        @Override
        public long getEndPosition() {
            return this.lEndPos;
        }

        @Override
        protected Field[] getChildFields() {
            return CHILD_FIELDS;
        }

        @Override
        public String toString() {
            boolean first;
            StringBuilder sb = new StringBuilder();
            sb.append(this.keyword.getId().TEXT).append(' ');
            if (this.modifier != null) {
                sb.append(this.modifier.getId().TEXT).append(' ');
            }
            sb.append(this.type);
            if (this.vers != null) {
                first = true;
                for (VersionOverride ver : this.vers) {
                    if (first) {
                        sb.append(' ');
                        first = false;
                    } else {
                        sb.append("\n        ");
                    }
                    sb.append(ver);
                }
            }
            if (this.injects != null) {
                sb.append("\n        ").append(Token.Id.INJECT.TEXT).append(' ').append('(');
                first = true;
                for (Parameter injection : this.injects) {
                    if (first) {
                        first = false;
                    } else {
                        sb.append(", ");
                    }
                    sb.append(injection);
                }
                sb.append(')');
            }
            if (this.injector != null) {
                sb.append("\n        ").append(Token.Id.USING.TEXT).append(' ').append(this.injector);
            }
            return sb.toString();
        }
    }

    public static class Into
    extends CompositionNode {
        public Into(Expression condition, Token keyword, TypeExpression type) {
            super(condition, keyword, type);
        }
    }

    public static class Delegates
    extends CompositionNode {
        protected Expression delegatee;
        protected long lEndPos;
        protected transient String name;
        private static final Field[] CHILD_FIELDS = Delegates.fieldsForNames(Delegates.class, "condition", "type", "delegatee");

        public Delegates(Expression condition, Token keyword, TypeExpression type, Expression delegatee, long lEndPos) {
            super(condition, keyword, type);
            this.delegatee = delegatee;
            this.lEndPos = lEndPos;
        }

        public Expression getDelegatee() {
            return this.delegatee;
        }

        public void setPropertyName(String sName) {
            assert (this.name == null);
            this.name = sName;
        }

        public String getPropertyName() {
            assert (this.name != null);
            return this.name;
        }

        @Override
        public long getEndPosition() {
            return this.lEndPos;
        }

        @Override
        protected Field[] getChildFields() {
            return CHILD_FIELDS;
        }

        @Override
        public String toString() {
            return this.toStartString() + "(" + String.valueOf(this.delegatee) + ")" + this.toEndString();
        }
    }

    public static class Implements
    extends CompositionNode {
        public Implements(Expression condition, Token keyword, TypeExpression type) {
            super(condition, keyword, type);
        }
    }

    public static class Incorporates
    extends CompositionNode {
        protected List<Expression> args;
        protected List<Parameter> constraints;
        private static final Field[] CHILD_FIELDS = Incorporates.fieldsForNames(Incorporates.class, "condition", "type", "args", "constraints");

        public Incorporates(Expression condition, Token keyword, TypeExpression type, List<Expression> args, List<Parameter> constraints) {
            super(condition, keyword, type);
            this.args = args;
            this.constraints = constraints;
        }

        public boolean isConditional() {
            return this.constraints != null;
        }

        public List<Parameter> getConstraints() {
            return this.constraints;
        }

        @Override
        public long getEndPosition() {
            return this.condition == null && this.args != null && !this.args.isEmpty() ? this.args.get(this.args.size() - 1).getEndPosition() : super.getEndPosition();
        }

        @Override
        protected Field[] getChildFields() {
            return CHILD_FIELDS;
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder();
            if (this.condition != null) {
                sb.append("if (").append(this.condition).append(") { ");
            }
            sb.append(this.keyword.getId().TEXT);
            if (this.isConditional()) {
                String sType = this.type.toString();
                sb.append(" conditional ").append(sType, 0, sType.indexOf(60));
                sb.append('<');
                boolean first = true;
                for (Parameter param : this.constraints) {
                    if (first) {
                        first = false;
                    } else {
                        sb.append(", ");
                    }
                    sb.append(param.toTypeParamString());
                }
                sb.append('>');
            } else {
                sb.append(' ').append(this.type);
            }
            if (this.args != null) {
                sb.append('(');
                boolean first = true;
                for (Expression arg : this.args) {
                    if (first) {
                        first = false;
                    } else {
                        sb.append(", ");
                    }
                    sb.append(arg);
                }
                sb.append(')');
            }
            sb.append(this.toEndString());
            return sb.toString();
        }
    }

    public static class Annotates
    extends CompositionNode {
        protected AnnotationExpression annotation;
        private static final Field[] CHILD_FIELDS = Annotates.fieldsForNames(Annotates.class, "annotation");

        public Annotates(AnnotationExpression annotation) {
            super(null, new Token(annotation.getStartPosition(), annotation.getStartPosition(), Token.Id.ANNOTATION), annotation.type);
            this.annotation = annotation;
        }

        public Annotation ensureAnnotation(ConstantPool pool) {
            return this.annotation.ensureAnnotation(pool);
        }

        @Override
        public long getEndPosition() {
            List<Expression> listArgs = this.annotation.args;
            return listArgs != null && !listArgs.isEmpty() ? listArgs.getLast().getEndPosition() : super.getEndPosition();
        }

        @Override
        protected Field[] getChildFields() {
            return CHILD_FIELDS;
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder();
            if (this.condition != null) {
                sb.append("if (").append(this.condition).append(") { ");
            }
            sb.append(this.keyword.getId().TEXT).append(' ').append(this.annotation.type);
            if (this.annotation.args != null) {
                sb.append('(');
                boolean first = true;
                for (Expression arg : this.annotation.args) {
                    if (first) {
                        first = false;
                    } else {
                        sb.append(", ");
                    }
                    sb.append(arg);
                }
                sb.append(')');
            }
            sb.append(this.toEndString());
            return sb.toString();
        }
    }

    public static class Extends
    extends CompositionNode {
        protected List<Expression> args;
        protected long lEndPos;
        private static final Field[] CHILD_FIELDS = Extends.fieldsForNames(Extends.class, "condition", "type", "args");

        public Extends(Expression condition, Token keyword, TypeExpression type) {
            super(condition, keyword, type);
        }

        public Extends(Expression condition, Token keyword, TypeExpression type, List<Expression> args, long lEndPos) {
            super(condition, keyword, type);
            this.args = args;
            this.lEndPos = lEndPos;
        }

        @Override
        public long getEndPosition() {
            return this.lEndPos == 0L ? super.getEndPosition() : this.lEndPos;
        }

        @Override
        protected Field[] getChildFields() {
            return CHILD_FIELDS;
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.toStartString());
            if (this.args != null) {
                sb.append('(');
                boolean first = true;
                for (Expression arg : this.args) {
                    if (first) {
                        first = false;
                    } else {
                        sb.append(", ");
                    }
                    sb.append(arg);
                }
                sb.append(')');
            }
            sb.append(this.toEndString());
            return sb.toString();
        }
    }
}

