/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.compiler.ast;

import org.xvm.asm.Argument;
import org.xvm.asm.Constant;
import org.xvm.asm.ConstantPool;
import org.xvm.asm.ErrorListener;
import org.xvm.asm.MethodStructure;
import org.xvm.asm.Register;
import org.xvm.asm.ast.BiExprAST;
import org.xvm.asm.ast.CondOpExprAST;
import org.xvm.asm.ast.ExprAST;
import org.xvm.asm.constants.ConditionalConstant;
import org.xvm.asm.constants.SingletonConstant;
import org.xvm.asm.constants.TypeConstant;
import org.xvm.asm.op.JumpFalse;
import org.xvm.asm.op.JumpTrue;
import org.xvm.asm.op.Label;
import org.xvm.asm.op.Var;
import org.xvm.compiler.Token;
import org.xvm.compiler.ast.BiExpression;
import org.xvm.compiler.ast.Context;
import org.xvm.compiler.ast.Expression;
import org.xvm.util.Handy;

public class CondOpExpression
extends BiExpression {
    static final int ForF = 3177520;
    static final int ForT = 3177521;
    static final int ForU = 3177535;
    static final int TorF = 3243056;
    static final int TorT = 3243057;
    static final int TorU = 3243071;
    static final int UorF = 4160560;
    static final int UorT = 4160561;
    static final int UorU = 4160575;
    static final int FandF = 3155504;
    static final int FandT = 3155505;
    static final int FandU = 3155519;
    static final int TandF = 3221040;
    static final int TandT = 3221041;
    static final int TandU = 3221055;
    static final int UandF = 4138544;
    static final int UandT = 4138545;
    static final int UandU = 4138559;

    public CondOpExpression(Expression expr1, Token operator, Expression expr2) {
        super(expr1, operator, expr2);
        switch (operator.getId()) {
            case COND_OR: 
            case COND_AND: {
                break;
            }
            default: {
                throw new IllegalArgumentException("operator: " + String.valueOf(operator));
            }
        }
    }

    public boolean isAnd() {
        return this.operator.getId() == Token.Id.COND_AND;
    }

    public boolean isOr() {
        return this.operator.getId() == Token.Id.COND_OR;
    }

    @Override
    public boolean validateCondition(ErrorListener errs) {
        return this.expr1.validateCondition(errs) && this.expr2.validateCondition(errs);
    }

    @Override
    public ConditionalConstant toConditionalConstant() {
        return this.isAnd() ? this.expr1.toConditionalConstant().addAnd(this.expr2.toConditionalConstant()) : this.expr1.toConditionalConstant().addOr(this.expr2.toConditionalConstant());
    }

    @Override
    public TypeConstant getImplicitType(Context ctx) {
        return this.pool().typeBoolean();
    }

    @Override
    protected Expression validate(Context ctx, TypeConstant typeRequired, ErrorListener errs) {
        Expression.TypeFit fit = Expression.TypeFit.Fit;
        ConstantPool pool = this.pool();
        TypeConstant typeBoolean = pool.typeBoolean();
        Expression expr1Old = this.expr1;
        Expression expr1New = expr1Old.validate(ctx, typeBoolean, errs);
        Constant const1 = null;
        if (expr1New == null) {
            fit = Expression.TypeFit.NoFit;
        } else {
            if (expr1New != expr1Old) {
                this.expr1 = expr1New;
            }
            const1 = expr1New.toConstant();
        }
        ctx = this.isAnd() ? ctx.enterAnd() : ctx.enterOr();
        Expression expr2Old = this.expr2;
        Expression expr2New = expr2Old.validate(ctx, typeBoolean, errs);
        Constant const2 = null;
        ctx = ctx.exit();
        if (expr2New == null) {
            fit = Expression.TypeFit.NoFit;
        } else {
            if (expr2New != expr2Old) {
                this.expr2 = expr2New;
            }
            const2 = expr2New.toConstant();
        }
        SingletonConstant constResult = null;
        switch (this.combine(const1, this.getOperatorString(), const2)) {
            case 4138544: {
                if (this.expr1.hasSideEffects()) break;
            }
            case 3155504: 
            case 3155505: 
            case 3155519: 
            case 3177520: 
            case 3221040: {
                constResult = pool.valFalse();
                break;
            }
            case 4160561: {
                if (this.expr1.hasSideEffects()) break;
            }
            case 3177521: 
            case 3221041: 
            case 3243056: 
            case 3243057: 
            case 3243071: {
                constResult = pool.valTrue();
            }
        }
        return this.finishValidation(ctx, typeRequired, typeBoolean, fit, constResult, errs);
    }

    @Override
    public boolean isCompletable() {
        return this.expr1.isCompletable();
    }

    @Override
    public Argument generateArgument(Context ctx, MethodStructure.Code code, boolean fLocalPropOk, boolean fUsedOnce, ErrorListener errs) {
        if (this.isConstant()) {
            return this.toConstant();
        }
        switch (this.combine(this.expr1.toConstant(), this.getOperatorString(), this.expr2.toConstant())) {
            case 4138545: 
            case 4160560: {
                return this.expr1.generateArgument(ctx, code, fLocalPropOk, fUsedOnce, errs);
            }
            case 3177535: 
            case 3221055: {
                return this.expr2.generateArgument(ctx, code, fLocalPropOk, fUsedOnce, errs);
            }
            case 4138559: 
            case 4160575: {
                Label labelEnd = new Label(this.getCodeContainerCounter());
                Register regAccum = code.createRegister(this.getType());
                Expression.Assignable LValAccum = new Expression.Assignable(this, regAccum);
                code.add(new Var(regAccum));
                this.expr1.generateAssignment(ctx, code, LValAccum, errs);
                if (this.isAnd()) {
                    code.add(new JumpFalse(regAccum, labelEnd));
                } else {
                    code.add(new JumpTrue(regAccum, labelEnd));
                }
                this.expr2.generateAssignment(ctx, code, LValAccum, errs);
                code.add(labelEnd);
                return regAccum;
            }
            case 4160561: {
                this.expr1.generateArgument(ctx, code, fLocalPropOk, fUsedOnce, errs);
            }
            case 3177521: {
                return this.pool().valTrue();
            }
        }
        throw new IllegalStateException();
    }

    @Override
    public void generateAssignment(Context ctx, MethodStructure.Code code, Expression.Assignable LVal, ErrorListener errs) {
        if (this.isConstant()) {
            LVal.assign(this.toConstant(), code, errs);
            return;
        }
        if (LVal.isNormalVariable()) {
            switch (this.combine(this.expr1.toConstant(), this.getOperatorString(), this.expr1.toConstant())) {
                case 4138545: 
                case 4160560: {
                    this.expr1.generateAssignment(ctx, code, LVal, errs);
                    return;
                }
                case 3177535: 
                case 3221055: {
                    this.expr2.generateAssignment(ctx, code, LVal, errs);
                    return;
                }
            }
        }
        super.generateAssignment(ctx, code, LVal, errs);
    }

    @Override
    public ExprAST getExprAST(Context ctx) {
        if (this.isConstant()) {
            return CondOpExpression.toExprAst(this.toConstant());
        }
        switch (this.combine(this.expr1.toConstant(), this.getOperatorString(), this.expr2.toConstant())) {
            case 4138545: 
            case 4160560: {
                return this.expr1.getExprAST(ctx);
            }
            case 3177521: 
            case 3177535: 
            case 3221055: {
                return this.expr2.getExprAST(ctx);
            }
        }
        return new CondOpExprAST(this.expr1.getExprAST(ctx), this.isAnd() ? BiExprAST.Operator.CondAnd : BiExprAST.Operator.CondOr, this.expr2.getExprAST(ctx));
    }

    public String getDefaultMethodName() {
        return this.isAnd() ? "and" : "or";
    }

    public String getOperatorString() {
        return this.isAnd() ? "&" : "|";
    }

    private int combine(Constant const1, String sOp, Constant const2) {
        SingletonConstant TRUE = this.pool().valTrue();
        SingletonConstant FALSE = this.pool().valFalse();
        int n = Handy.equals(const1, TRUE) ? 49 : (Handy.equals(const1, FALSE) ? 48 : 63);
        n = n << 16 | sOp.charAt(0) << 8;
        n = Handy.equals(const2, TRUE) ? (n |= 0x31) : (Handy.equals(const2, FALSE) ? (n |= 0x30) : (n |= 0x3F));
        return n;
    }
}

