/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.compiler.ast;

import java.util.Collections;
import java.util.List;
import org.xvm.compiler.Token;
import org.xvm.compiler.ast.AstNode;
import org.xvm.compiler.ast.Statement;

public abstract class ConditionalStatement
extends Statement {
    protected Token keyword;
    protected List<AstNode> conds;
    private static int s_nLabelCounter;
    private transient int m_nLabel;

    public ConditionalStatement(Token keyword, List<AstNode> conds) {
        this.keyword = keyword;
        this.conds = conds == null ? Collections.emptyList() : conds;
    }

    @Override
    public long getStartPosition() {
        return this.keyword.getStartPosition();
    }

    public int getConditionCount() {
        return this.conds.size();
    }

    public AstNode getCondition(int i) {
        return this.conds.get(i);
    }

    public int findCondition(AstNode nodeChild) {
        int c = this.getConditionCount();
        for (int i = 0; i < c; ++i) {
            if (this.conds.get(i) != nodeChild) continue;
            return i;
        }
        return -1;
    }

    @Override
    protected boolean allowsShortCircuit(AstNode nodeChild) {
        return this.findCondition(nodeChild) >= 0;
    }

    protected int getLabelId() {
        int n = this.m_nLabel;
        if (n == 0) {
            n = ++s_nLabelCounter;
            this.m_nLabel = s_nLabelCounter;
        }
        return n;
    }
}

