/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.compiler.ast;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.xvm.asm.Argument;
import org.xvm.asm.Assignment;
import org.xvm.asm.ClassStructure;
import org.xvm.asm.Component;
import org.xvm.asm.ComponentResolver;
import org.xvm.asm.Constant;
import org.xvm.asm.ConstantPool;
import org.xvm.asm.Constants;
import org.xvm.asm.ErrorListener;
import org.xvm.asm.GenericTypeResolver;
import org.xvm.asm.MethodStructure;
import org.xvm.asm.Parameter;
import org.xvm.asm.PropertyStructure;
import org.xvm.asm.Register;
import org.xvm.asm.ast.BinaryAST;
import org.xvm.asm.ast.ExprAST;
import org.xvm.asm.ast.RegisterAST;
import org.xvm.asm.constants.FormalConstant;
import org.xvm.asm.constants.IdentityConstant;
import org.xvm.asm.constants.MethodConstant;
import org.xvm.asm.constants.PropertyConstant;
import org.xvm.asm.constants.TypeConstant;
import org.xvm.compiler.Source;
import org.xvm.compiler.Token;
import org.xvm.compiler.ast.Statement;
import org.xvm.compiler.ast.StatementBlock;
import org.xvm.util.Severity;

public class Context {
    private Context m_ctxOuter;
    private final boolean m_fDemuxOnExit;
    boolean m_fReachable;
    private Map<String, Argument> m_mapByName;
    private Map<String, Argument> m_mapWhenTrue;
    private Map<String, Argument> m_mapWhenFalse;
    private Map<FormalConstant, TypeConstant> m_mapFormal;
    private Map<FormalConstant, TypeConstant> m_mapFormalWhenTrue;
    private Map<FormalConstant, TypeConstant> m_mapFormalWhenFalse;
    private Map<String, Assignment> m_mapAssigned;
    private Register m_regThis;

    protected Context(Context ctxOuter, boolean fDemuxOnExit) {
        this.m_ctxOuter = ctxOuter;
        this.m_fDemuxOnExit = fDemuxOnExit;
        this.m_fReachable = ctxOuter == null || ctxOuter.isReachable();
    }

    protected Context getOuterContext() {
        return this.m_ctxOuter;
    }

    protected Branch getOuterBranch(Branch branch) {
        return Branch.Always;
    }

    protected boolean isDemuxing() {
        return this.m_fDemuxOnExit;
    }

    public MethodStructure getMethod() {
        return this.getOuterContext().getMethod();
    }

    public boolean isMethod() {
        Context ctx = this.getOuterContext();
        return ctx != null && ctx.isMethod();
    }

    public boolean isFunction() {
        Context ctx = this.getOuterContext();
        return ctx != null && ctx.isFunction();
    }

    public boolean isConstructor() {
        Context ctx = this.getOuterContext();
        return ctx != null && ctx.isConstructor();
    }

    public Source getSource() {
        return this.getOuterContext().getSource();
    }

    public ClassStructure getThisClass() {
        return this.getOuterContext().getThisClass();
    }

    public IdentityConstant getThisClassId() {
        return this.getThisClass().getIdentityConstant();
    }

    public TypeConstant getThisType() {
        Argument argThis = this.getVar("this");
        return argThis == null ? this.getThisClass().getFormalType() : argThis.getType().removeAccess();
    }

    public Register getThisRegister() {
        Register regThis = this.m_regThis;
        if (regThis == null) {
            TypeConstant typeThis = this.getThisType();
            ConstantPool pool = this.pool();
            if (this.isConstructor()) {
                TypeConstant typeStruct = pool.ensureAccessTypeConstant(typeThis, Constants.Access.STRUCT);
                regThis = new Register(typeStruct, "this", -10);
            } else {
                regThis = new Register(typeThis, "this", -5);
            }
            this.m_regThis = regThis;
        }
        return regThis;
    }

    public ExprAST getThisRegisterAST() {
        return this.getThisRegister().getRegisterAST();
    }

    public Statement.AstHolder getHolder() {
        return this.getOuterContext().getHolder();
    }

    public ConstantPool pool() {
        return this.getOuterContext().pool();
    }

    public Context enter() {
        return new Context(this, true);
    }

    public Context enterIf() {
        return new IfContext(this);
    }

    public Context enterAndIf() {
        return new AndIfContext(this);
    }

    public Context enterFork(boolean fWhenTrue) {
        return new ForkedContext(this, fWhenTrue);
    }

    public Context enterInfiniteLoop() {
        ForkedContext ctxFork = (ForkedContext)this.enterFork(true);
        ctxFork.markExclusive();
        return ctxFork;
    }

    public Context enterAnd() {
        return new AndContext(this);
    }

    public Context enterOr() {
        return new OrContext(this);
    }

    public Context enterNot() {
        return new NotContext(this);
    }

    public Context enterLoop() {
        return new LoopingContext(this);
    }

    public InferringContext enterInferring(TypeConstant typeLeft) {
        return new InferringContext(this, typeLeft);
    }

    public Context enterList() {
        return new Context(this, true);
    }

    public boolean isReachable() {
        return this.m_fReachable;
    }

    public void setReachable(boolean fReachable) {
        this.m_fReachable = fReachable;
    }

    public Context exit() {
        Context ctxOuter = this.getOuterContext();
        this.promoteAssignments(ctxOuter);
        if (this.isReachable()) {
            this.promoteNarrowedTypes();
            this.promoteNarrowedGenericTypes();
        } else {
            ctxOuter.promoteNonCompleting(this);
        }
        return ctxOuter;
    }

    public void discard() {
        Context ctxOuter = this.getOuterContext();
        if (ctxOuter != null) {
            ctxOuter.unlink(this);
        }
        this.m_fReachable = false;
        this.m_ctxOuter = null;
    }

    protected void unlink(Context ctxDiscarded) {
    }

    public Map<String, Assignment> prepareJump(Context ctxDest) {
        if (!this.isReachable() && ctxDest.isReachable()) {
            return Collections.emptyMap();
        }
        HashMap<String, Assignment> mapMods = new HashMap<String, Assignment>();
        this.prepareJump(ctxDest, mapMods, null);
        return mapMods;
    }

    public void prepareJump(Context ctxDest, Map<String, Assignment> mapAsnMods, Map<String, Argument> mapArgMods) {
        if (!this.isReachable() && ctxDest.isReachable()) {
            return;
        }
        boolean fDemux = false;
        for (Context ctxInner = this; ctxInner != ctxDest; ctxInner = ctxInner.getOuterContext()) {
            mapAsnMods.keySet().removeIf(sName -> ctxDest.getVar((String)sName) == null);
            for (String string : ctxInner.getDefiniteAssignments().keySet()) {
                if (mapAsnMods.containsKey(string) || ctxInner.isVarDeclaredInThisScope(string)) continue;
                mapAsnMods.put(string, this.getVarAssignment(string));
            }
            fDemux |= ctxInner.isDemuxing();
        }
        if (fDemux) {
            for (Map.Entry entry : mapAsnMods.entrySet()) {
                entry.setValue(((Assignment)((Object)entry.getValue())).demux());
            }
        }
        if (mapArgMods != null) {
            for (String string : mapAsnMods.keySet()) {
                mapArgMods.put(string, this.getVar(string));
            }
            for (String string : this.getNameMap().keySet()) {
                Argument argument;
                if (mapArgMods.containsKey(string) || !((argument = ctxDest.getVar(string)) instanceof Register)) continue;
                Register regDest = (Register)argument;
                TypeConstant typeArg = this.getVar(string).getType();
                if (regDest.getType().equals(typeArg)) continue;
                mapArgMods.put(string, regDest.narrowType(typeArg));
            }
        }
    }

    public void merge(Map<String, Assignment> mapAdd) {
        this.merge(mapAdd, Collections.emptyMap());
    }

    public void merge(Map<String, Assignment> mapAddAsn, Map<String, Argument> mapAddArg) {
        String sName;
        Map<String, Assignment> mapAsn = this.ensureDefiniteAssignments();
        boolean fCompletes = this.isReachable();
        for (Map.Entry<String, Assignment> entry : mapAddAsn.entrySet()) {
            sName = entry.getKey();
            Assignment asnNew = entry.getValue();
            if (fCompletes) {
                asnNew = this.getVarAssignment(sName).join(asnNew);
            }
            mapAsn.put(sName, asnNew);
        }
        for (Map.Entry<String, Object> entry : mapAddArg.entrySet()) {
            TypeConstant typeNew;
            sName = entry.getKey();
            Object object = entry.getValue();
            if (!(object instanceof Register)) continue;
            Register regNew = (Register)object;
            Register regOld = (Register)this.getVar(sName);
            assert (regOld != null);
            TypeConstant typeOld = regOld.getType();
            if (typeOld.equals(typeNew = regNew.getType())) continue;
            if (typeOld.isA(typeNew)) {
                this.replaceArgument(sName, Branch.Always, regOld.narrowType(typeNew));
                continue;
            }
            TypeConstant typeJoin = typeNew.union(this.pool(), typeOld);
            if (typeJoin.equals(typeOld)) continue;
            this.replaceArgument(sName, Branch.Always, regOld.narrowType(typeJoin));
        }
    }

    protected Map<String, Argument> mergeNarrowedElseTypes(Map<String, Argument> map) {
        Map<String, Argument> mapThis = this.getNarrowingMap(false);
        if (map == null || map.isEmpty()) {
            return mapThis.isEmpty() ? null : new HashMap<String, Argument>(mapThis);
        }
        map.keySet().retainAll(mapThis.keySet());
        for (Map.Entry<String, Argument> entry : map.entrySet()) {
            String sName = entry.getKey();
            Argument argPrev = entry.getValue();
            Argument argThis = mapThis.get(sName);
            TypeConstant typePrev = argPrev.getType();
            TypeConstant typeThis = argThis.getType();
            TypeConstant typeJoin = typeThis.union(this.pool(), typePrev);
            if (typeJoin.equals(typePrev)) continue;
            if (argPrev instanceof Register) {
                Register regPrev = (Register)argPrev;
                map.put(sName, regPrev.narrowType(typeJoin));
                continue;
            }
            map.remove(sName);
        }
        return map;
    }

    public void promoteAssignments(Context ctxOuter) {
        boolean fCompletes = this.isReachable();
        boolean fDemuxing = this.isDemuxing();
        for (Map.Entry<String, Assignment> entry : this.getDefiniteAssignments().entrySet()) {
            String sName = entry.getKey();
            Assignment asnInner = entry.getValue();
            if (this.isVarDeclaredInThisScope(sName)) {
                if (!asnInner.isEffectivelyFinal()) continue;
                ((Register)this.getVar(sName)).markEffectivelyFinal();
                continue;
            }
            Assignment asnOuter = ctxOuter.getVarAssignment(sName);
            Assignment assignment = asnOuter = fCompletes ? this.promote(sName, asnInner, asnOuter) : asnOuter.promoteFromNonCompleting(asnInner);
            if (fDemuxing) {
                asnOuter = asnOuter.demux();
            }
            ctxOuter.setVarAssignment(sName, asnOuter);
        }
    }

    protected Assignment promote(String sName, Assignment asnInner, Assignment asnOuter) {
        return asnInner;
    }

    protected void promoteNarrowedTypes() {
        for (Map.Entry<String, Argument> entry : this.getNameMap().entrySet()) {
            this.promoteNarrowedType(entry.getKey(), entry.getValue(), Branch.Always);
        }
        for (Map.Entry<String, Argument> entry : this.getNarrowingMap(true).entrySet()) {
            this.promoteNarrowedType(entry.getKey(), entry.getValue(), Branch.WhenTrue);
        }
        for (Map.Entry<String, Argument> entry : this.getNarrowingMap(false).entrySet()) {
            this.promoteNarrowedType(entry.getKey(), entry.getValue(), Branch.WhenFalse);
        }
    }

    protected void promoteNarrowedType(String sName, Argument arg, Branch branch) {
        if (branch == Branch.Always && !this.isVarDeclaredInThisScope(sName)) {
            this.getOuterContext().replaceArgument(sName, branch, arg);
        }
    }

    protected void promoteNarrowedGenericTypes() {
        for (Map.Entry<FormalConstant, TypeConstant> entry : this.getFormalTypeMap(Branch.Always).entrySet()) {
            this.promoteNarrowedGenericType(entry.getKey(), entry.getValue(), Branch.Always);
        }
        for (Map.Entry<FormalConstant, TypeConstant> entry : this.getFormalTypeMap(Branch.WhenTrue).entrySet()) {
            this.promoteNarrowedGenericType(entry.getKey(), entry.getValue(), Branch.WhenTrue);
        }
        for (Map.Entry<FormalConstant, TypeConstant> entry : this.getFormalTypeMap(Branch.WhenFalse).entrySet()) {
            this.promoteNarrowedGenericType(entry.getKey(), entry.getValue(), Branch.WhenFalse);
        }
    }

    protected void promoteNarrowedGenericType(FormalConstant constFormal, TypeConstant typeNarrow, Branch branch) {
        if (branch == Branch.Always) {
            this.getOuterContext().replaceGenericType(constFormal, branch, typeNarrow);
        }
    }

    protected void promoteNonCompleting(Context ctxInner) {
        this.setReachable(false);
    }

    protected void retainNarrowedTypes(Map<String, Argument> map, boolean fWhenTrue) {
        Map<String, Argument> mapNarrowing = this.ensureNarrowingMap(fWhenTrue);
        if (!mapNarrowing.isEmpty()) {
            if (map.isEmpty()) {
                mapNarrowing.clear();
            } else {
                mapNarrowing.keySet().retainAll(map.keySet());
            }
        }
    }

    public void restoreOriginalTypes() {
        for (String sName : this.getNameMap().keySet()) {
            this.restoreOriginalType(sName);
        }
    }

    protected void restoreOriginalType(String sName) {
        Argument argument = this.getVar(sName);
        if (argument instanceof Register) {
            Register regOrig = (Register)argument;
            this.replaceArgument(sName, Branch.Always, regOrig.restoreType());
        }
    }

    public void registerVar(Token tokName, Register reg, ErrorListener errs) {
        String sName = tokName.getValueText();
        if (this.isVarDeclaredInThisScope(sName) || !this.isVarHideable(sName)) {
            tokName.log(errs, this.getSource(), Severity.ERROR, "COMPILER-51", sName);
        }
        this.ensureNameMap().put(sName, reg);
        this.ensureDefiniteAssignments().put(sName, reg.isPredefined() ? Assignment.AssignedOnce : Assignment.Unassigned);
    }

    public void unregisterVar(Token tokName) {
        String sName = tokName.getValueText();
        this.ensureNameMap().remove(sName);
        this.ensureDefiniteAssignments().remove(sName);
    }

    public final Argument getVar(String sName) {
        return this.getVar(sName, null, Branch.Always, null);
    }

    public final Argument getVar(Token name, ErrorListener errs) {
        return this.getVar(name.getValueText(), name, Branch.Always, errs);
    }

    protected Argument getVar(String sName, Token name, Branch branch, ErrorListener errs) {
        Context ctxOuter;
        Argument arg = this.getLocalVar(sName, branch);
        if (arg == null && (ctxOuter = this.getOuterContext()) != null) {
            arg = ctxOuter.getVar(sName, name, this.getOuterBranch(branch), errs);
        }
        if (arg instanceof Register) {
            Register reg = (Register)arg;
            arg = this.resolveRegisterType(branch, reg);
        }
        return arg;
    }

    protected Argument getLocalVar(String sName, Branch branch) {
        Argument arg;
        if (branch != Branch.Always && (arg = this.getNarrowingMap(branch == Branch.WhenTrue).get(sName)) != null) {
            return arg;
        }
        return this.getNameMap().get(sName);
    }

    public boolean isVarDeclaredInThisScope(String sName) {
        Register reg;
        Argument arg = this.getNameMap().get(sName);
        return arg instanceof Register && (reg = (Register)arg).isInPlace();
    }

    public boolean isAnyVarDeclaredInThisScope() {
        for (String sName : this.getNameMap().keySet()) {
            if (!this.isVarDeclaredInThisScope(sName)) continue;
            return true;
        }
        return false;
    }

    public Assignment getVarAssignment(String sName) {
        Assignment asn = this.getDefiniteAssignments().get(sName);
        if (asn != null) {
            return asn;
        }
        assert (!this.isVarDeclaredInThisScope(sName));
        Context ctxOuter = this.getOuterContext();
        return ctxOuter == null ? null : ctxOuter.getVarAssignment(sName);
    }

    public void setVarAssignment(String sName, Assignment asn) {
        this.ensureDefiniteAssignments().put(sName, asn);
    }

    public boolean isVarReadable(String sName) {
        Assignment asn = this.getVarAssignment(sName);
        if (asn != null) {
            Register reg;
            Argument arg = this.getVar(sName);
            if (!asn.isDefinitelyAssigned()) {
                Register reg2;
                return arg instanceof Register && (reg2 = (Register)arg).isAllowedUnassigned();
            }
            return !(arg instanceof Register) || (reg = (Register)arg).isReadable();
        }
        return this.isReservedName(sName) && this.getOuterContext().isVarReadable(sName);
    }

    public final void markVarRead(Token tokName, boolean fDeref, ErrorListener errs) {
        this.markVarRead(false, tokName.getValueText(), tokName, fDeref, errs);
    }

    protected void markVarRead(boolean fNested, String sName, Token tokName, boolean fDeref, ErrorListener errs) {
        if (fNested || this.isVarReadable(sName)) {
            Context ctxOuter;
            if (!this.isVarDeclaredInThisScope(sName) && (ctxOuter = this.getOuterContext()) != null) {
                ctxOuter.markVarRead(true, sName, tokName, fDeref, errs);
            }
        } else if (tokName != null && errs != null) {
            if (this.isReservedName(sName)) {
                MethodStructure method = this.getMethod();
                IdentityConstant idCtx = method == null ? this.getThisClassId() : method.getIdentityConstant();
                tokName.log(errs, this.getSource(), Severity.ERROR, sName.startsWith("this") ? "COMPILER-52" : ("super".equals(sName) ? "COMPILER-53" : "COMPILER-36"), sName, idCtx.getValueString());
                this.setVarAssignment(sName, Assignment.AssignedOnce);
            } else if (fDeref) {
                tokName.log(errs, this.getSource(), Severity.ERROR, "COMPILER-81", sName);
                this.setVarAssignment(sName, this.getVarAssignment(sName).applyAssignment());
            } else {
                Argument argument = this.getVar(sName);
                if (argument instanceof Register) {
                    Register reg = (Register)argument;
                    reg.markAllowUnassigned();
                }
            }
        } else {
            throw new IllegalStateException("illegal var read: name=" + sName);
        }
    }

    public boolean isVarWritable(String sName) {
        if ("$".equals(sName)) {
            return false;
        }
        if (this.isVarDeclaredInThisScope(sName)) {
            Register reg;
            Argument arg = this.getVar(sName);
            if (arg instanceof Register && (reg = (Register)arg).isWritable()) {
                return !reg.isMarkedFinal() || this.getVarAssignment(sName).isDefinitelyUnassigned();
            }
            return false;
        }
        Context ctxOuter = this.getOuterContext();
        return ctxOuter != null && ctxOuter.isVarWritable(sName);
    }

    public final void markVarWrite(Token tokName, boolean fCond, ErrorListener errs) {
        this.markVarWrite(tokName.getValueText(), tokName, fCond, errs);
    }

    public boolean requireThis(long lPos, ErrorListener errs) {
        Context ctxOuter = this.getOuterContext();
        if (ctxOuter == null) {
            if (errs != null) {
                errs.log(Severity.ERROR, "COMPILER-52", new Object[0], this.getSource(), lPos, lPos);
            }
            return false;
        }
        return ctxOuter.requireThis(lPos, errs);
    }

    protected void markVarWrite(String sName, Token tokName, boolean fCond, ErrorListener errs) {
        if (this.getVar(sName) == null) {
            assert (errs.hasSeriousErrors());
            return;
        }
        if (this.isVarWritable(sName)) {
            this.setVarAssignment(sName, this.getVarAssignment(sName).applyAssignment());
        } else if (tokName != null && errs != null) {
            tokName.log(errs, this.getSource(), Severity.ERROR, "COMPILER-82", sName);
        } else {
            throw new IllegalStateException("illegal var write: name=" + sName);
        }
    }

    public void useFormalType(TypeConstant type, ErrorListener errs) {
        Context ctxOuter = this.getOuterContext();
        if (ctxOuter != null) {
            ctxOuter.useFormalType(type, errs);
        }
    }

    public boolean isVarHideable(String sName) {
        if ("$".equals(sName) || "_".equals(sName)) {
            return true;
        }
        return !(this.getVar(sName) instanceof Register);
    }

    protected Map<String, Assignment> getDefiniteAssignments() {
        Map<String, Assignment> map = this.m_mapAssigned;
        return map == null ? Collections.emptyMap() : map;
    }

    protected Map<String, Assignment> ensureDefiniteAssignments() {
        Map<String, Assignment> map = this.m_mapAssigned;
        if (map == null) {
            this.m_mapAssigned = map = new HashMap<String, Assignment>();
        }
        return map;
    }

    public final Argument resolveName(String sName) {
        return this.resolveName(sName, null, ErrorListener.BLACKHOLE);
    }

    public final Argument resolveName(Token name, ErrorListener errs) {
        return this.resolveName(name.getValueText(), name, errs);
    }

    protected Argument resolveName(String sName, Token name, ErrorListener errs) {
        Argument arg = this.getVar(sName, name, Branch.Always, errs);
        if (arg == null && (arg = this.resolveReservedName(sName, name, errs)) == null) {
            arg = this.resolveRegularName(this, sName, name, errs);
        }
        return arg;
    }

    protected Map<String, Argument> getNameMap() {
        return this.hasInitialNames() ? this.ensureNameMap() : (this.m_mapByName == null ? Collections.emptyMap() : this.m_mapByName);
    }

    protected Map<String, Argument> ensureNameMap() {
        Map<String, Argument> mapByName = this.m_mapByName;
        if (mapByName == null) {
            mapByName = new HashMap<String, Argument>();
            if (this.hasInitialNames()) {
                this.initNameMap(mapByName);
            }
            this.m_mapByName = mapByName;
        }
        return mapByName;
    }

    protected boolean hasInitialNames() {
        return false;
    }

    protected void initNameMap(Map<String, Argument> mapByName) {
    }

    protected Argument resolveRegularName(Context ctxFrom, String sName, Token name, ErrorListener errs) {
        return this.getOuterContext().resolveRegularName(ctxFrom, sName, name, errs);
    }

    public boolean isReservedName(String sName) {
        return switch (sName) {
            case "this", "this:target", "this:public", "this:protected", "this:private", "this:struct", "this:class", "this:service", "this:module", "super" -> true;
            default -> false;
        };
    }

    protected Argument resolveReservedName(String sName, Token name, ErrorListener errs) {
        return this.getOuterContext().resolveReservedName(sName, name, errs);
    }

    protected void narrowLocalRegister(String sName, Register reg, Branch branch, TypeConstant typeNarrow) {
        assert (typeNarrow.isA(reg.getType()) || typeNarrow.isA(reg.getOriginalType()) || reg.getOriginalType().isFormalType() || reg.getOriginalType().getParamType(0).isFormalType());
        if (reg.isInPlace() || !reg.getType().equals(typeNarrow)) {
            this.replaceArgument(sName, branch, reg.narrowType(typeNarrow));
        }
    }

    protected void replaceArgument(String sName, Branch branch, Argument argNew) {
        if (branch == Branch.Always) {
            if (argNew instanceof Register) {
                Register reg = (Register)argNew;
                if (this.isVarDeclaredInThisScope(sName)) {
                    reg.markInPlace();
                }
            }
            this.ensureNameMap().put(sName, argNew);
        } else {
            this.ensureNarrowingMap(branch == Branch.WhenTrue).put(sName, argNew);
        }
    }

    protected void replaceArguments(Map<String, Argument> mapArgs) {
        if (mapArgs != null) {
            for (Map.Entry<String, Argument> entry : mapArgs.entrySet()) {
                this.replaceArgument(entry.getKey(), Branch.Always, entry.getValue());
            }
        }
    }

    public void restoreArgument(String sName, Register regOrig) {
        Map<String, Argument> map = this.ensureNameMap();
        if (this.isVarDeclaredInThisScope(sName)) {
            map.put(sName, regOrig);
        } else {
            map.remove(sName);
            Argument argOrig = this.getVar(sName);
            if (argOrig != null && !argOrig.getType().equals(regOrig.getType())) {
                map.put(sName, regOrig);
            }
        }
    }

    protected void replaceGenericArgument(FormalConstant constFormal, Branch branch, StatementBlock.TargetInfo infoNew) {
        switch (branch.ordinal()) {
            case 1: {
                if (!(constFormal instanceof PropertyConstant)) break;
                this.ensureNarrowingMap(true).put(constFormal.getName(), infoNew);
                break;
            }
            case 2: {
                if (!(constFormal instanceof PropertyConstant)) break;
                this.ensureNarrowingMap(false).put(constFormal.getName(), infoNew);
                break;
            }
            default: {
                if (!(constFormal instanceof PropertyConstant)) break;
                this.ensureNameMap().put(constFormal.getName(), infoNew);
            }
        }
        this.replaceGenericType(constFormal, branch, infoNew.getType());
    }

    protected void replaceGenericType(FormalConstant constFormal, Branch branch, TypeConstant typeNew) {
        assert (typeNew.isTypeOfType());
        this.ensureFormalTypeMap(branch).put(constFormal, typeNew);
    }

    protected void narrowProperty(String sName, PropertyConstant idProp, Branch branch, Argument argNarrow) {
        if (argNarrow.getType().isA(idProp.getType())) {
            this.replaceArgument(sName, branch, argNarrow);
        }
    }

    protected void joinArgument(String sName, Branch branch, Argument argNew) {
        Map<String, Argument> map = branch == Branch.Always ? this.ensureNameMap() : this.ensureNarrowingMap(branch == Branch.WhenTrue);
        Argument argOld = map.get(sName);
        if (argOld != null) {
            TypeConstant typeOld = argOld.getType();
            TypeConstant typeNew = argNew.getType();
            TypeConstant typeJoin = typeNew.union(this.pool(), typeOld);
            if (!typeJoin.equals(typeOld)) {
                if (argOld instanceof Register) {
                    Register regOld = (Register)argOld;
                    map.put(sName, regOld.narrowType(typeJoin));
                } else {
                    map.remove(sName);
                }
            }
        }
    }

    protected void joinGenericType(FormalConstant constFormal, Branch branch, Argument argNew) {
        Map<FormalConstant, TypeConstant> map = this.ensureFormalTypeMap(branch);
        TypeConstant typeOld = map.get(constFormal);
        if (typeOld == null) {
            map.remove(constFormal);
        } else {
            map.put(constFormal, argNew.getType().union(this.pool(), typeOld));
        }
    }

    protected Map<String, Argument> getNarrowingMap(boolean fWhenTrue) {
        Map<String, Argument> map = fWhenTrue ? this.m_mapWhenTrue : this.m_mapWhenFalse;
        return map == null ? Collections.emptyMap() : map;
    }

    protected Map<String, Argument> ensureNarrowingMap(boolean fWhenTrue) {
        Map<String, Argument> map;
        Map<String, Argument> map2 = map = fWhenTrue ? this.m_mapWhenTrue : this.m_mapWhenFalse;
        if (map == null) {
            map = new HashMap<String, Argument>();
            if (fWhenTrue) {
                this.m_mapWhenTrue = map;
            } else {
                this.m_mapWhenFalse = map;
            }
        }
        return map;
    }

    protected Map<FormalConstant, TypeConstant> getFormalTypeMap(Branch branch) {
        Map<FormalConstant, TypeConstant> map = switch (branch.ordinal()) {
            case 1 -> this.m_mapFormalWhenTrue;
            case 2 -> this.m_mapFormalWhenFalse;
            default -> this.m_mapFormal;
        };
        return map == null ? Collections.emptyMap() : map;
    }

    protected Map<FormalConstant, TypeConstant> ensureFormalTypeMap(Branch branch) {
        Map<FormalConstant, TypeConstant> map = this.getFormalTypeMap(branch);
        if (map.isEmpty()) {
            return switch (branch.ordinal()) {
                case 1 -> {
                    this.m_mapFormalWhenTrue = new HashMap<FormalConstant, TypeConstant>();
                    yield this.m_mapFormalWhenTrue;
                }
                case 2 -> {
                    this.m_mapFormalWhenFalse = new HashMap<FormalConstant, TypeConstant>();
                    yield this.m_mapFormalWhenFalse;
                }
                default -> {
                    this.m_mapFormal = new HashMap<FormalConstant, TypeConstant>();
                    yield this.m_mapFormal;
                }
            };
        }
        return map;
    }

    protected GenericTypeResolver getLocalResolver(final Branch branch) {
        return new GenericTypeResolver(){
            final /* synthetic */ Context this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public TypeConstant resolveFormalType(FormalConstant constFormal) {
                TypeConstant typeType = this.this$0.getFormalTypeMap(branch).get(constFormal);
                if (typeType != null) {
                    assert (typeType.isTypeOfType());
                    return typeType.getParamType(0);
                }
                String sName = constFormal.getName();
                Argument arg = this.this$0.getLocalVar(sName, branch);
                return arg == null ? (this.this$0.isFunction() || !constFormal.isProperty() ? null : this.this$0.getThisClass().getFormalType().resolveGenericType(sName)) : this.extractElementType(arg);
            }

            @Override
            public TypeConstant resolveGenericType(String sFormalName) {
                for (Map.Entry<FormalConstant, TypeConstant> entry : this.this$0.getFormalTypeMap(branch).entrySet()) {
                    FormalConstant constFormal = entry.getKey();
                    if (!(constFormal instanceof PropertyConstant) || !constFormal.getName().equals(sFormalName)) continue;
                    return entry.getValue();
                }
                Argument arg = this.this$0.getLocalVar(sFormalName, branch);
                return arg == null ? (this.this$0.isFunction() ? null : this.this$0.getThisClass().getFormalType().resolveGenericType(sFormalName)) : this.extractElementType(arg);
            }

            private TypeConstant extractElementType(Argument arg) {
                TypeConstant typeType = arg.getType();
                return typeType.isTypeOfType() ? typeType.getParamType(0) : null;
            }
        };
    }

    protected Argument resolveRegisterType(Branch branch, Register reg) {
        TypeConstant typeOriginal = reg.getType();
        TypeConstant typeResolved = typeOriginal.resolveGenerics(this.pool(), this.getLocalResolver(branch));
        return typeResolved.equals(typeOriginal) ? reg : reg.narrowType(typeResolved);
    }

    public TypeConstant resolveFormalType(TypeConstant typeFormal) {
        return this.resolveFormalType(typeFormal, Branch.Always);
    }

    protected TypeConstant resolveFormalType(TypeConstant typeFormal, Branch branch) {
        TypeConstant typeResolved = typeFormal.resolveGenerics(this.pool(), this.getLocalResolver(branch));
        if (!typeResolved.containsFormalType(true)) {
            return typeResolved;
        }
        typeFormal = typeResolved;
        Context ctxOuter = this.getOuterContext();
        return ctxOuter == null ? typeFormal : ctxOuter.resolveFormalType(typeFormal, this.getOuterBranch(branch));
    }

    protected void collectVariables(Set<String> setVars) {
        Context ctxOuter = this.getOuterContext();
        if (ctxOuter != null) {
            ctxOuter.collectVariables(setVars);
        }
        setVars.addAll(this.getDefiniteAssignments().keySet());
    }

    public int getStepsToOuterClass(ClassStructure clzParent) {
        Component component;
        int cSteps = 0;
        IdentityConstant idParent = clzParent.getIdentityConstant();
        MethodStructure method = this.getMethod();
        Component component2 = component = method == null ? this.getThisClass() : method.getParent().getParent();
        while (component != null) {
            IdentityConstant id = component.getIdentityConstant();
            switch (id.getFormat()) {
                case Module: 
                case Package: 
                case Class: {
                    if (id.equals(idParent)) {
                        return cSteps;
                    }
                    ClassStructure clz = (ClassStructure)component;
                    if (clz.hasContribution(idParent)) {
                        return cSteps;
                    }
                    if (clz.isStatic() || clz.isTopLevel()) {
                        return -1;
                    }
                    ++cSteps;
                    break;
                }
                case Method: 
                case MultiMethod: {
                    break;
                }
                case Property: {
                    PropertyStructure prop = (PropertyStructure)id.getComponent();
                    if (!prop.isRefAnnotated()) break;
                    ++cSteps;
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            component = component.getParent();
        }
        return -1;
    }

    public Register createRegister(TypeConstant type, String sName) {
        return new Register(type, sName, this.getMethod());
    }

    public Register getParameter(int iReg) {
        Parameter param = this.getMethod().getParam(iReg);
        String sName = param.getName();
        Register reg = (Register)this.getVar(sName);
        if (reg == null) {
            reg = new Register(param.getType(), sName, iReg);
            this.ensureNameMap().put(sName, reg);
        }
        return reg;
    }

    public RegisterAST[] collectParameters() {
        MethodStructure method = this.getMethod();
        int cParams = method.getParamCount();
        if (cParams == 0) {
            return BinaryAST.NO_REGS;
        }
        RegisterAST[] aReg = new RegisterAST[cParams];
        for (int i = 0; i < cParams; ++i) {
            Parameter param = method.getParam(i);
            Register reg = (Register)this.getVar(param.getName());
            aReg[i] = reg == null ? new RegisterAST(param.getType(), param.getNameConstant()) : (RegisterAST)reg.getOriginalRegister().getRegisterAST();
        }
        return aReg;
    }

    public String toString() {
        TreeSet<String> setVars;
        StringBuilder sb = new StringBuilder();
        sb.append("Current: ");
        Map<String, Assignment> mapVars = this.getDefiniteAssignments();
        if (mapVars.isEmpty()) {
            sb.append("none");
        } else {
            setVars = new TreeSet<String>(mapVars.keySet());
            boolean fFirst = true;
            for (String s : setVars) {
                if (fFirst) {
                    fFirst = false;
                } else {
                    sb.append(", ");
                }
                sb.append(s).append("=").append((Object)this.getVarAssignment(s));
            }
        }
        setVars = new TreeSet();
        this.collectVariables(setVars);
        if (setVars.size() > mapVars.size()) {
            sb.append("; all variables:");
            for (String s : setVars) {
                sb.append('\n').append(s).append('=').append((Object)this.getVarAssignment(s));
            }
        }
        return sb.toString();
    }

    public static enum Branch {
        Always,
        WhenTrue,
        WhenFalse;


        public Branch complement() {
            return switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> Always;
                case 1 -> WhenFalse;
                case 2 -> WhenTrue;
            };
        }

        public static Branch of(boolean f) {
            return f ? WhenTrue : WhenFalse;
        }
    }

    static class IfContext
    extends Context {
        private Context m_ctxWhenTrue;
        private Context m_ctxWhenFalse;

        public IfContext(Context outer) {
            super(outer, true);
        }

        @Override
        public boolean isReachable() {
            return this.m_fReachable && (this.m_ctxWhenTrue == null || this.m_ctxWhenTrue.isReachable() || this.m_ctxWhenFalse == null || this.m_ctxWhenFalse.isReachable());
        }

        @Override
        public Context enterFork(boolean fWhenTrue) {
            Context ctx = super.enterFork(fWhenTrue);
            if (fWhenTrue) {
                this.m_ctxWhenTrue = ctx;
            } else {
                this.forgetDeclaredVars(this.m_ctxWhenTrue);
                this.m_ctxWhenFalse = ctx;
            }
            return ctx;
        }

        private void forgetDeclaredVars(Context ctxBranch) {
            Iterator<String> iter = this.getNameMap().keySet().iterator();
            while (iter.hasNext()) {
                String sVar = iter.next();
                if (!this.isVarDeclaredInThisScope(sVar)) continue;
                iter.remove();
                this.getDefiniteAssignments().remove(sVar);
                if (ctxBranch == null) continue;
                ctxBranch.getNameMap().remove(sVar);
                ctxBranch.getDefiniteAssignments().remove(sVar);
            }
        }

        @Override
        protected void markVarWrite(String sName, Token tokName, boolean fCond, ErrorListener errs) {
            if (this.getVar(sName) != null && this.isVarWritable(sName)) {
                Assignment asn = this.getVarAssignment(sName);
                if (fCond) {
                    Assignment asnTrue = asn.whenTrue().applyAssignment();
                    asn = asnTrue.join(asn, false);
                } else {
                    asn = asn.applyAssignment();
                }
                this.setVarAssignment(sName, asn);
            } else {
                super.markVarWrite(sName, tokName, fCond, errs);
            }
        }

        @Override
        protected void promoteNarrowedType(String sName, Argument arg, Branch branch) {
            Context ctxOuter = this.getOuterContext();
            Argument argOrig = ctxOuter.getVar(sName);
            if (argOrig != null) {
                Register regOrig;
                TypeConstant typeOrig;
                TypeConstant typeFalse;
                TypeConstant typeTrue;
                Argument argFalse;
                Argument argTrue;
                switch (branch.ordinal()) {
                    case 1: {
                        argTrue = arg;
                        argFalse = this.getNarrowingMap(false).get(sName);
                        typeTrue = argTrue.getType();
                        typeFalse = argFalse == null ? argOrig.getType() : argFalse.getType();
                        break;
                    }
                    case 2: {
                        argTrue = this.getNarrowingMap(true).get(sName);
                        if (argTrue != null) {
                            return;
                        }
                        argFalse = arg;
                        typeTrue = argOrig.getType();
                        typeFalse = argFalse.getType();
                        break;
                    }
                    default: {
                        super.promoteNarrowedType(sName, arg, branch);
                        return;
                    }
                }
                if (typeFalse.isA(typeTrue)) {
                    if (argTrue != null) {
                        ctxOuter.replaceArgument(sName, Branch.Always, argTrue);
                    }
                } else if (typeTrue.isA(typeFalse)) {
                    if (argFalse != null) {
                        ctxOuter.replaceArgument(sName, Branch.Always, argFalse);
                    }
                } else if (!(!(argOrig instanceof Register) || typeFalse.isA(typeOrig = (regOrig = (Register)argOrig).getType()) && typeTrue.isA(typeOrig))) {
                    ctxOuter.replaceArgument(sName, Branch.Always, regOrig.restoreType());
                }
            }
        }

        @Override
        protected void promoteNarrowedGenericType(FormalConstant constFormal, TypeConstant typeNarrowed, Branch branch) {
            if (branch == Branch.WhenTrue) {
                TypeConstant typeTrue = typeNarrowed;
                TypeConstant typeFalse = this.getFormalTypeMap(Branch.WhenFalse).get(constFormal);
                if (typeFalse != null) {
                    Context ctxOuter = this.getOuterContext();
                    TypeConstant typeOrig = ctxOuter.getFormalTypeMap(Branch.Always).get(constFormal);
                    if (typeFalse.isA(typeTrue)) {
                        if (!typeTrue.equals(typeOrig)) {
                            ctxOuter.replaceGenericType(constFormal, Branch.Always, typeTrue);
                        }
                    } else if (typeTrue.isA(typeFalse) && !typeFalse.equals(typeOrig)) {
                        ctxOuter.replaceGenericType(constFormal, Branch.Always, typeFalse);
                    }
                }
            }
        }

        @Override
        protected void promoteNonCompleting(Context ctxInner) {
        }

        @Override
        public Context exit() {
            if (this.isReachable()) {
                if (this.m_ctxWhenTrue != null && !this.m_ctxWhenTrue.isReachable()) {
                    this.discardBranch(true);
                } else if (this.m_ctxWhenFalse != null && !this.m_ctxWhenFalse.isReachable()) {
                    this.discardBranch(false);
                }
            }
            return super.exit();
        }

        private void discardBranch(boolean fWhenTrue) {
            Context ctxPromote;
            Map<Object, Argument> mapBranch = this.getNarrowingMap(fWhenTrue);
            if (!mapBranch.isEmpty()) {
                mapBranch.clear();
            }
            if (!(mapBranch = this.getFormalTypeMap(Branch.of(fWhenTrue))).isEmpty()) {
                mapBranch.clear();
            }
            if (!(mapBranch = this.getNarrowingMap(!fWhenTrue)).isEmpty()) {
                this.ensureNarrowingMap(fWhenTrue).putAll(mapBranch);
            }
            if (!(mapBranch = this.getFormalTypeMap(Branch.of(!fWhenTrue))).isEmpty()) {
                this.ensureFormalTypeMap(Branch.of(fWhenTrue)).putAll(mapBranch);
            }
            Context context = ctxPromote = fWhenTrue ? this.m_ctxWhenFalse : this.m_ctxWhenTrue;
            if (ctxPromote == null) {
                Map<String, Assignment> mapAssign = this.ensureDefiniteAssignments();
                for (Map.Entry<String, Assignment> entry : mapAssign.entrySet()) {
                    if (this.isVarDeclaredInThisScope(entry.getKey())) continue;
                    Assignment asnCurrent = entry.getValue();
                    entry.setValue(fWhenTrue ? asnCurrent.whenFalse() : asnCurrent.whenTrue());
                }
            } else {
                HashSet<String> setVars = new HashSet<String>();
                ctxPromote.collectVariables(setVars);
                Map<String, Assignment> mapAssign = this.ensureDefiniteAssignments();
                for (String sName : setVars) {
                    if (ctxPromote.isVarDeclaredInThisScope(sName)) continue;
                    Assignment asnPromote = ctxPromote.getVarAssignment(sName);
                    Assignment asnCurrent = mapAssign.get(sName);
                    assert (asnPromote != null);
                    if (asnCurrent == null) {
                        asnCurrent = asnPromote;
                    } else {
                        asnCurrent = fWhenTrue ? asnCurrent.whenFalse() : asnCurrent.whenTrue();
                        asnCurrent = asnCurrent.join(asnPromote);
                    }
                    if (asnCurrent.equals((Object)this.getVarAssignment(sName))) continue;
                    mapAssign.put(sName, asnCurrent);
                }
            }
        }

        @Override
        protected void unlink(Context ctxDiscarded) {
            if (ctxDiscarded == this.m_ctxWhenTrue) {
                this.m_ctxWhenTrue = null;
            }
            if (ctxDiscarded == this.m_ctxWhenFalse) {
                this.m_ctxWhenFalse = null;
            }
        }
    }

    static class AndIfContext
    extends AndContext {
        public AndIfContext(Context outer) {
            super(outer);
        }

        @Override
        protected Assignment promote(String sName, Assignment asnInner, Assignment asnOuter) {
            Assignment asnJoin = Assignment.join(asnOuter.whenFalse(), asnInner.whenTrue());
            return asnJoin;
        }

        @Override
        public Context exit() {
            if (!this.isReachable()) {
                Context ctxOuter = this.getOuterContext();
                while (true) {
                    if (ctxOuter instanceof IfContext) {
                        IfContext ctxIf = (IfContext)ctxOuter;
                        assert (ctxIf.m_ctxWhenTrue == null);
                        ctxIf.enterFork(true).setReachable(false);
                        this.setReachable(true);
                        break;
                    }
                    ctxOuter = ctxOuter.getOuterContext();
                }
            }
            return super.exit();
        }
    }

    public static class ForkedContext
    extends Context {
        private final boolean m_fWhenTrue;
        private boolean m_fExclusive;

        public ForkedContext(Context ctxOuter, boolean fWhenTrue) {
            super(ctxOuter, false);
            this.m_fWhenTrue = fWhenTrue;
        }

        public boolean isWhenTrue() {
            return this.m_fWhenTrue;
        }

        void markExclusive() {
            assert (this.m_fWhenTrue);
            this.m_fExclusive = true;
        }

        @Override
        protected Branch getOuterBranch(Branch branch) {
            return Branch.of(this.m_fWhenTrue);
        }

        @Override
        public Context exit() {
            Context ctxOuter = super.exit();
            if (this.m_fExclusive) {
                Context ctxFalse = ctxOuter.enterFork(false);
                ctxFalse.setReachable(false);
                ctxFalse.exit();
            }
            return ctxOuter;
        }

        @Override
        public Assignment getVarAssignment(String sName) {
            Assignment asn = super.getVarAssignment(sName);
            assert (asn != null);
            if (!this.getDefiniteAssignments().containsKey(sName)) {
                asn = this.isWhenTrue() ? asn.whenTrue() : asn.whenFalse();
            }
            return asn;
        }

        @Override
        protected Assignment promote(String sName, Assignment asnInner, Assignment asnOuter) {
            return asnOuter.join(asnInner, this.isWhenTrue());
        }

        @Override
        protected void promoteNarrowedType(String sName, Argument arg, Branch branch) {
            if (branch == Branch.Always && !this.isVarDeclaredInThisScope(sName)) {
                this.getOuterContext().replaceArgument(sName, Branch.of(this.m_fWhenTrue), arg);
            }
        }

        @Override
        protected void promoteNarrowedGenericType(FormalConstant constFormal, TypeConstant typeNarrowed, Branch branch) {
            if (branch == Branch.Always) {
                this.getOuterContext().replaceGenericType(constFormal, Branch.of(this.m_fWhenTrue), typeNarrowed);
            }
        }
    }

    public static class AndContext
    extends Context {
        public AndContext(Context ctxOuter) {
            super(ctxOuter, false);
        }

        @Override
        protected Branch getOuterBranch(Branch branch) {
            return Branch.WhenTrue;
        }

        @Override
        public Assignment getVarAssignment(String sName) {
            Assignment asn = super.getVarAssignment(sName);
            return this.getDefiniteAssignments().containsKey(sName) ? asn : asn.whenTrue();
        }

        @Override
        protected Assignment promote(String sName, Assignment asnInner, Assignment asnOuter) {
            Assignment asnFalse = Assignment.join(asnOuter.whenFalse(), asnInner.whenFalse());
            Assignment asnJoin = Assignment.join(asnFalse, asnInner.whenTrue());
            return asnJoin;
        }

        @Override
        protected void promoteNarrowedTypes() {
            this.getOuterContext().retainNarrowedTypes(this.getNarrowingMap(false), false);
            super.promoteNarrowedTypes();
        }

        @Override
        protected void promoteNarrowedType(String sName, Argument arg, Branch branch) {
            super.promoteNarrowedType(sName, arg, branch);
            switch (branch.ordinal()) {
                case 1: {
                    this.getOuterContext().replaceArgument(sName, branch, arg);
                    break;
                }
                case 2: {
                    this.getOuterContext().joinArgument(sName, branch, arg);
                }
            }
        }

        @Override
        protected void promoteNarrowedGenericTypes() {
            Map<FormalConstant, TypeConstant> map = this.getFormalTypeMap(Branch.WhenFalse);
            if (!map.isEmpty()) {
                this.getOuterContext().ensureFormalTypeMap(Branch.WhenFalse).keySet().retainAll(map.keySet());
            }
            super.promoteNarrowedGenericTypes();
        }

        @Override
        protected void promoteNarrowedGenericType(FormalConstant constFormal, TypeConstant typeNarrowed, Branch branch) {
            super.promoteNarrowedGenericType(constFormal, typeNarrowed, branch);
            switch (branch.ordinal()) {
                case 1: {
                    this.getOuterContext().replaceGenericType(constFormal, branch, typeNarrowed);
                    break;
                }
                case 2: {
                    this.getOuterContext().joinGenericType(constFormal, branch, typeNarrowed);
                }
            }
        }
    }

    public static class OrContext
    extends Context {
        public OrContext(Context ctxOuter) {
            super(ctxOuter, false);
        }

        @Override
        protected Branch getOuterBranch(Branch branch) {
            return Branch.WhenFalse;
        }

        @Override
        public Assignment getVarAssignment(String sName) {
            Assignment asn = super.getVarAssignment(sName);
            return this.getDefiniteAssignments().containsKey(sName) ? asn : asn.whenFalse();
        }

        @Override
        protected Assignment promote(String sName, Assignment asnInner, Assignment asnOuter) {
            Assignment asnTrue = Assignment.join(asnOuter.whenTrue(), asnInner.whenTrue());
            Assignment asnJoin = Assignment.join(asnInner.whenFalse(), asnTrue);
            return asnJoin;
        }

        @Override
        protected void promoteNarrowedTypes() {
            this.getOuterContext().retainNarrowedTypes(this.getNarrowingMap(true), true);
            super.promoteNarrowedTypes();
        }

        @Override
        protected void promoteNarrowedType(String sName, Argument arg, Branch branch) {
            super.promoteNarrowedType(sName, arg, branch);
            switch (branch.ordinal()) {
                case 2: {
                    this.getOuterContext().replaceArgument(sName, branch, arg);
                    break;
                }
                case 1: {
                    this.getOuterContext().joinArgument(sName, branch, arg);
                }
            }
        }

        @Override
        protected void promoteNarrowedGenericTypes() {
            Map<FormalConstant, TypeConstant> map = this.getFormalTypeMap(Branch.WhenTrue);
            if (!map.isEmpty()) {
                this.getOuterContext().ensureFormalTypeMap(Branch.WhenTrue).keySet().retainAll(map.keySet());
            }
            super.promoteNarrowedGenericTypes();
        }

        @Override
        protected void promoteNarrowedGenericType(FormalConstant constFormal, TypeConstant typeNarrowed, Branch branch) {
            super.promoteNarrowedGenericType(constFormal, typeNarrowed, branch);
            switch (branch.ordinal()) {
                case 2: {
                    this.getOuterContext().replaceGenericType(constFormal, branch, typeNarrowed);
                    break;
                }
                case 1: {
                    this.getOuterContext().joinGenericType(constFormal, branch, typeNarrowed);
                }
            }
        }
    }

    public static class NotContext
    extends Context {
        public NotContext(Context ctxOuter) {
            super(ctxOuter, false);
        }

        @Override
        protected Branch getOuterBranch(Branch branch) {
            return branch.complement();
        }

        @Override
        public Assignment getVarAssignment(String sName) {
            Assignment asn = super.getVarAssignment(sName);
            return this.getDefiniteAssignments().containsKey(sName) ? asn : asn.negate();
        }

        @Override
        protected Assignment promote(String sName, Assignment asnInner, Assignment asnOuter) {
            return asnInner.negate();
        }

        @Override
        protected void promoteNarrowedType(String sName, Argument arg, Branch branch) {
            if (branch == Branch.Always) {
                super.promoteNarrowedType(sName, arg, branch);
            } else {
                this.getOuterContext().replaceArgument(sName, branch.complement(), arg);
            }
        }

        @Override
        protected void promoteNarrowedGenericType(FormalConstant constFormal, TypeConstant typeNarrowed, Branch branch) {
            if (branch == Branch.Always) {
                super.promoteNarrowedGenericType(constFormal, typeNarrowed, branch);
            } else {
                this.getOuterContext().replaceGenericType(constFormal, branch.complement(), typeNarrowed);
            }
        }
    }

    public static class LoopingContext
    extends Context {
        public LoopingContext(Context ctxOuter) {
            super(ctxOuter, true);
        }

        @Override
        protected Assignment promote(String sName, Assignment asnInner, Assignment asnOuter) {
            Assignment asnJoin = asnOuter.joinLoop(asnInner);
            return asnJoin;
        }
    }

    public static class InferringContext
    extends Context {
        private final TypeConstant f_typeLeft;

        public InferringContext(Context ctxOuter, TypeConstant typeLeft) {
            super(ctxOuter, true);
            this.f_typeLeft = typeLeft;
        }

        @Override
        public Context enterList() {
            TypeConstant typeCtx = this.f_typeLeft;
            TypeConstant typeEl = typeCtx.isA(this.pool().typeList()) ? typeCtx.resolveGenericType("Element") : null;
            return typeEl == null ? new Context(this, true) : new InferringContext((Context)this, typeEl);
        }

        @Override
        protected Argument resolveRegularName(Context ctxFrom, String sName, Token name, ErrorListener errs) {
            Argument arg = super.resolveRegularName(ctxFrom, sName, name, errs = errs.branch(null));
            if (!(arg instanceof StatementBlock.TargetInfo)) {
                PropertyConstant idProp;
                Constant constant;
                MethodConstant idMethod;
                Component.SimpleCollector collector = new Component.SimpleCollector(errs);
                TypeConstant typeLeft = this.f_typeLeft;
                Constants.Access access = typeLeft.getAccess();
                MethodStructure method = this.getMethod();
                MethodConstant methodConstant = idMethod = method == null ? null : method.getIdentityConstant();
                if (typeLeft.resolveContributedName(sName, access, idMethod, collector) == ComponentResolver.ResolutionResult.RESOLVED && (!((constant = collector.getResolvedConstant()) instanceof PropertyConstant) || (idProp = (PropertyConstant)constant).isConstant() || idProp.isFormalType())) {
                    return constant;
                }
            }
            errs.merge();
            return arg;
        }

        @Override
        public void registerVar(Token tokName, Register reg, ErrorListener errs) {
            this.getOuterContext().registerVar(tokName, reg, errs);
        }

        @Override
        public void unregisterVar(Token tokName) {
            this.getOuterContext().unregisterVar(tokName);
        }

        @Override
        protected void promoteNarrowedType(String sName, Argument arg, Branch branch) {
            switch (branch.ordinal()) {
                case 0: {
                    super.promoteNarrowedType(sName, arg, branch);
                    break;
                }
                case 1: 
                case 2: {
                    this.getOuterContext().replaceArgument(sName, branch, arg);
                }
            }
        }

        @Override
        protected void promoteNarrowedGenericType(FormalConstant constFormal, TypeConstant typeNarrowed, Branch branch) {
            this.getOuterContext().replaceGenericType(constFormal, branch, typeNarrowed);
        }
    }

    public static class CaptureContext
    extends Context {
        private Map<String, Boolean> m_mapCapture;
        private Map<String, Register> m_mapRegisters;
        private Map<String, Argument> m_mapFormalInfo;
        private boolean m_fCaptureThis;

        public CaptureContext(Context ctxOuter) {
            super(ctxOuter, true);
        }

        @Override
        public Context exit() {
            Context ctxOuter = super.exit();
            Map<String, Boolean> mapCapture = this.ensureCaptureMap();
            Map<String, Register> mapVars = this.ensureRegisterMap();
            for (String sName : mapCapture.keySet()) {
                mapVars.put(sName, (Register)this.getVar(sName));
            }
            return ctxOuter;
        }

        @Override
        protected Assignment promote(String sName, Assignment asnInner, Assignment asnOuter) {
            Register reg;
            this.ensureCaptureMap().put(sName, true);
            Argument argument = this.getOuterContext().getVar(sName);
            if (argument instanceof Register && (reg = (Register)argument).isVar() && asnInner.isDefinitelyAssigned()) {
                reg.markAllowUnassigned();
            }
            return asnOuter.applyAssignmentFromCapture();
        }

        @Override
        public boolean requireThis(long lPos, ErrorListener errs) {
            this.captureThis();
            return true;
        }

        @Override
        protected void markVarRead(boolean fNested, String sName, Token tokName, boolean fDeref, ErrorListener errs) {
            if (!this.isVarDeclaredInThisScope(sName) && this.getOuterContext().isVarReadable(sName)) {
                this.ensureCaptureMap().putIfAbsent(sName, false);
            }
            super.markVarRead(fNested, sName, tokName, fDeref, errs);
        }

        @Override
        public void useFormalType(TypeConstant type, ErrorListener errs) {
            super.useFormalType(type, errs);
            if (type.isFormalType()) {
                FormalConstant constFormal = (FormalConstant)type.getDefiningConstant();
                switch (constFormal.getFormat()) {
                    case Property: 
                    case TypeParameter: {
                        String sName = constFormal.getName();
                        Argument arg = this.resolveName(sName, null, ErrorListener.BLACKHOLE);
                        if (arg == null) break;
                        this.ensureFormalMap().putIfAbsent(sName, arg);
                        break;
                    }
                    case FormalTypeChild: {
                        FormalConstant constParent = (FormalConstant)constFormal.getParentConstant();
                        this.useFormalType(constParent.getType(), errs);
                        break;
                    }
                }
            } else if (type.containsFormalType(true)) {
                HashSet<TypeConstant> setTypes = new HashSet<TypeConstant>();
                type.collectFormalTypes(true, setTypes);
                for (TypeConstant typeFormal : setTypes) {
                    this.useFormalType(typeFormal, errs);
                }
            }
        }

        @Override
        protected void collectVariables(Set<String> setVars) {
        }

        public Map<String, Boolean> getCaptureMap() {
            return this.m_mapCapture == null ? Collections.emptyMap() : this.m_mapCapture;
        }

        public Map<String, Register> ensureRegisterMap() {
            Map<String, Register> map = this.m_mapRegisters;
            if (map == null) {
                if (this.getCaptureMap().isEmpty()) {
                    return Collections.emptyMap();
                }
                this.m_mapRegisters = map = new HashMap<String, Register>();
            }
            return map;
        }

        public Map<String, Argument> getFormalMap() {
            return this.m_mapFormalInfo == null ? Collections.emptyMap() : this.m_mapFormalInfo;
        }

        protected void captureThis() {
            this.m_fCaptureThis = true;
        }

        public boolean isThisCaptured() {
            return this.m_fCaptureThis;
        }

        protected Map<String, Boolean> ensureCaptureMap() {
            Map<String, Boolean> map = this.m_mapCapture;
            if (map == null) {
                this.m_mapCapture = map = new TreeMap<String, Boolean>();
            }
            return map;
        }

        protected Map<String, Argument> ensureFormalMap() {
            Map<String, Argument> map = this.m_mapFormalInfo;
            if (map == null) {
                this.m_mapFormalInfo = map = new TreeMap<String, Argument>();
            }
            return map;
        }
    }
}

