/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.compiler.ast;

import org.xvm.asm.ErrorListener;
import org.xvm.asm.MethodStructure;
import org.xvm.asm.ast.ContinueStmtAST;
import org.xvm.asm.op.Jump;
import org.xvm.compiler.Token;
import org.xvm.compiler.ast.Context;
import org.xvm.compiler.ast.GotoStatement;
import org.xvm.compiler.ast.Statement;
import org.xvm.util.Severity;

public class ContinueStatement
extends GotoStatement {
    public ContinueStatement(Token keyword, Token name) {
        super(keyword, name);
    }

    @Override
    protected Statement validateImpl(Context ctx, ErrorListener errs) {
        Statement stmtTarget = this.getTargetStatement();
        if (stmtTarget == null) {
            if (this.isLabeled()) {
                this.log(errs, Severity.ERROR, "COMPILER-88", this.getLabeledName());
            } else {
                this.log(errs, Severity.ERROR, "COMPILER-89", new Object[0]);
            }
            return null;
        }
        if (!stmtTarget.isNaturalGotoStatementTarget()) {
            this.log(errs, Severity.ERROR, "COMPILER-90", new Object[0]);
            return null;
        }
        this.setJumpLabel(stmtTarget.ensureContinueLabel(this, ctx));
        ctx.setReachable(false);
        return this;
    }

    @Override
    protected boolean emit(Context ctx, boolean fReachable, MethodStructure.Code code, ErrorListener errs) {
        code.add(new Jump(this.getJumpLabel()));
        ctx.getHolder().setAst(this, new ContinueStmtAST(this.getTargetDepth()));
        return false;
    }
}

