/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.compiler.ast;

import java.util.ArrayList;
import org.xvm.asm.Argument;
import org.xvm.asm.Component;
import org.xvm.asm.Constant;
import org.xvm.asm.ErrorListener;
import org.xvm.asm.MethodStructure;
import org.xvm.asm.Register;
import org.xvm.asm.ast.AssignAST;
import org.xvm.asm.ast.ConstantExprAST;
import org.xvm.asm.ast.ConvertExprAST;
import org.xvm.asm.ast.ExprAST;
import org.xvm.asm.ast.InvokeExprAST;
import org.xvm.asm.ast.MultiExprAST;
import org.xvm.asm.ast.StmtExprAST;
import org.xvm.asm.constants.MethodConstant;
import org.xvm.asm.constants.TypeConstant;
import org.xvm.asm.op.Invoke_01;
import org.xvm.asm.op.JumpFalse;
import org.xvm.asm.op.Label;
import org.xvm.asm.op.Var;
import org.xvm.compiler.ast.Context;
import org.xvm.compiler.ast.Expression;
import org.xvm.compiler.ast.SyntheticExpression;

public class ConvertExpression
extends SyntheticExpression {
    private final MethodConstant[] m_aidConv;

    public ConvertExpression(Expression expr, MethodConstant[] aidConv, ErrorListener errs) {
        super(expr);
        assert (aidConv != null && aidConv.length >= 1);
        for (MethodConstant idConv : aidConv) {
            MethodStructure method;
            Component component;
            if (idConv == null) continue;
            assert (idConv.getRawParams().length == 0 || (component = idConv.getComponent()) instanceof MethodStructure && (method = (MethodStructure)component).getRequiredParamCount() == 0);
            assert (idConv.getRawReturns().length > 0);
            assert (!idConv.getComponent().isStatic());
        }
        this.m_aidConv = aidConv;
        if (expr.isSingle()) {
            assert (aidConv.length == 1 && aidConv[0] != null);
            TypeConstant type = aidConv[0].getRawReturns()[0];
            Constant val = null;
            if (expr.isConstant()) {
                val = this.convertConstant(expr.toConstant(), type);
            }
            this.finishValidation(null, null, type, expr.getTypeFit().addConversion(), val, errs);
        } else {
            Constant[] aVal = null;
            TypeConstant[] aType = (TypeConstant[])expr.getTypes().clone();
            for (MethodConstant idConv : aidConv) {
                if (idConv == null) continue;
                aType[i] = idConv.getRawReturns()[0];
            }
            if (expr.isConstant()) {
                aVal = (Constant[])expr.toConstants().clone();
                int c = aType.length;
                for (int i = 0; i < c; ++i) {
                    MethodConstant idConv;
                    idConv = aidConv[i];
                    if (idConv == null) continue;
                    Constant constNew = this.convertConstant(aVal[i], aType[i]);
                    if (constNew == null) {
                        System.err.println("No conversion found for " + String.valueOf(aVal[i]));
                    }
                    aVal[i] = constNew;
                }
            }
            this.finishValidations(null, null, aType, expr.getTypeFit().addConversion(), aVal, errs);
        }
    }

    @Override
    public boolean isConditionalResult() {
        return this.expr.isConditionalResult();
    }

    @Override
    protected boolean hasMultiValueImpl() {
        return true;
    }

    @Override
    public TypeConstant getImplicitType(Context ctx) {
        return this.getType();
    }

    @Override
    public TypeConstant[] getImplicitTypes(Context ctx) {
        return this.getTypes();
    }

    @Override
    protected Expression validate(Context ctx, TypeConstant typeRequired, ErrorListener errs) {
        return this;
    }

    @Override
    protected Expression validateMulti(Context ctx, TypeConstant[] atypeRequired, ErrorListener errs) {
        return this;
    }

    @Override
    public void generateVoid(Context ctx, MethodStructure.Code code, ErrorListener errs) {
        this.getUnderlyingExpression().generateVoid(ctx, code, errs);
    }

    @Override
    public void generateAssignment(Context ctx, MethodStructure.Code code, Expression.Assignable LVal, ErrorListener errs) {
        Expression expr = this.getUnderlyingExpression();
        MethodConstant idConv = this.m_aidConv[0];
        if (idConv == null) {
            expr.generateAssignment(ctx, code, LVal, errs);
            return;
        }
        Argument argIn = expr.generateArgument(ctx, code, true, true, errs);
        if (LVal.isLocalArgument()) {
            code.add(new Invoke_01(argIn, idConv, LVal.getLocalArgument()));
        } else {
            Register regResult = new Register(this.getType(), null, -1);
            code.add(new Invoke_01(argIn, idConv, regResult));
            LVal.assign(regResult, code, errs);
        }
    }

    @Override
    public void generateAssignments(Context ctx, MethodStructure.Code code, Expression.Assignable[] aLVal, ErrorListener errs) {
        Register regTemp;
        MethodConstant idConv;
        int i;
        int cVals = aLVal.length;
        if (cVals == 1) {
            this.generateAssignment(ctx, code, aLVal[0], errs);
            return;
        }
        MethodConstant[] aidConv = this.m_aidConv;
        int cConvs = aidConv.length;
        Expression expr = this.getUnderlyingExpression();
        Expression.Assignable[] aLValTemp = (Expression.Assignable[])aLVal.clone();
        boolean fCond = this.isConditionalResult();
        Register regCond = null;
        Label lblSkip = new Label("skip_conv");
        if (fCond) {
            Expression.Assignable aLValCond = aLValTemp[0];
            if (aLValCond.isNormalVariable()) {
                regCond = aLValCond.getRegister();
            } else {
                regCond = code.createRegister(this.pool().typeBoolean());
                code.add(new Var(regCond));
                aLValTemp[0] = new Expression.Assignable(this, regCond);
            }
        }
        for (i = 0; i < cConvs; ++i) {
            idConv = aidConv[i];
            if (idConv == null) continue;
            regTemp = code.createRegister(expr.getTypes()[i]);
            code.add(new Var(regTemp));
            aLValTemp[i] = new Expression.Assignable(this, regTemp);
        }
        expr.generateAssignments(ctx, code, aLValTemp, errs);
        if (fCond) {
            if (aLVal[0] != aLValTemp[0]) {
                aLVal[0].assign(regCond, code, errs);
            }
            code.add(new JumpFalse(regCond, lblSkip));
        }
        for (i = 0; i < cConvs; ++i) {
            idConv = aidConv[i];
            if (idConv == null) continue;
            regTemp = aLValTemp[i].getRegister();
            Expression.Assignable LVal = aLVal[i];
            if (LVal.isLocalArgument()) {
                code.add(new Invoke_01(regTemp, idConv, LVal.getLocalArgument()));
                continue;
            }
            Register regResult = new Register(this.getTypes()[i], null, -1);
            code.add(new Invoke_01(regTemp, idConv, regResult));
            LVal.assign(regResult, code, errs);
        }
        if (fCond) {
            code.add(lblSkip);
        }
    }

    @Override
    public ExprAST getExprAST(Context ctx) {
        return this.isConstant() ? new ConstantExprAST(this.toConstant()) : new ConvertExprAST(this.expr.getExprAST(ctx), this.getTypes(), this.m_aidConv);
    }

    public ExprAST unwrapConvertAST(Context ctx, ExprAST astLVal) {
        ExprAST astFrom = this.expr.getExprAST(ctx);
        int cVals = this.expr.getValueCount();
        assert (cVals > 1 && cVals == this.m_aidConv.length);
        TypeConstant[] atypeFrom = this.expr.getTypes();
        TypeConstant[] atypeTo = this.getTypes();
        Register[] aRegFrom = new Register[cVals];
        ExprAST[] aAstRegFrom = new ExprAST[cVals];
        for (int i = 0; i < cVals; ++i) {
            aRegFrom[i] = ctx.createRegister(atypeFrom[i], null);
            aAstRegFrom[i] = aRegFrom[i].getRegAllocAST();
        }
        ArrayList<AssignAST> listAst = new ArrayList<AssignAST>();
        listAst.add(new AssignAST(new MultiExprAST(aAstRegFrom), AssignAST.Operator.Asn, astFrom));
        ExprAST[] aAstRegTo = new ExprAST[cVals];
        for (int i = 0; i < cVals; ++i) {
            MethodConstant idConv = this.m_aidConv[i];
            Register regFrom = aRegFrom[i];
            if (idConv == null) {
                aAstRegTo[i] = regFrom.getRegisterAST();
                continue;
            }
            Register regTo = ctx.createRegister(atypeTo[i], null);
            InvokeExprAST astConvert = new InvokeExprAST(idConv, new TypeConstant[]{atypeTo[i]}, regFrom.getRegisterAST(), ExprAST.NO_EXPRS, false);
            listAst.add(new AssignAST(regTo.getRegAllocAST(), AssignAST.Operator.Asn, astConvert));
            aAstRegTo[i] = regTo.getRegisterAST();
        }
        listAst.add(new AssignAST(astLVal, AssignAST.Operator.Asn, new MultiExprAST(aAstRegTo)));
        return new StmtExprAST(new MultiExprAST(listAst.toArray(ExprAST.NO_EXPRS)), atypeTo);
    }

    @Override
    public String toString() {
        Expression expr = this.getUnderlyingExpression();
        MethodConstant[] aidConv = this.m_aidConv;
        if (expr.isSingle()) {
            return expr.toString() + "." + aidConv[0].getName() + (String)(this.isValidated() ? "<" + this.getType().getValueString() + ">()" : "<?>()");
        }
        StringBuilder sb = new StringBuilder("(");
        boolean fCond = this.isConditionalResult();
        int c = aidConv.length;
        for (int i = 0; i < c; ++i) {
            MethodConstant idConv = aidConv[i];
            if (i > (fCond ? 1 : 0)) {
                sb.append(", ");
            }
            if (idConv == null) {
                if (i == 0 && fCond) {
                    sb.append("conditional ");
                    continue;
                }
                sb.append(expr).append("[").append(i).append("]");
                continue;
            }
            sb.append(expr).append("[").append(i).append("].").append(idConv.getName());
            if (this.isValidated()) {
                sb.append('<').append(this.getTypes()[i].getValueString()).append(">()");
                continue;
            }
            sb.append("<?>()");
        }
        return sb.append(')').toString();
    }
}

