/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.compiler.ast;

import java.lang.reflect.Field;
import org.xvm.asm.ErrorListener;
import org.xvm.asm.constants.TypeConstant;
import org.xvm.compiler.Token;
import org.xvm.compiler.ast.AnonInnerClass;
import org.xvm.compiler.ast.Context;
import org.xvm.compiler.ast.TypeExpression;

public class DecoratedTypeExpression
extends TypeExpression {
    protected Token keyword;
    protected TypeExpression type;
    private static final Field[] CHILD_FIELDS = DecoratedTypeExpression.fieldsForNames(DecoratedTypeExpression.class, "type");

    public DecoratedTypeExpression(Token keyword, TypeExpression type) {
        this.keyword = keyword;
        this.type = type;
    }

    @Override
    protected boolean canResolveNames() {
        return super.canResolveNames() || this.type.canResolveNames();
    }

    @Override
    public long getStartPosition() {
        return this.keyword.getStartPosition();
    }

    @Override
    public long getEndPosition() {
        return this.type.getEndPosition();
    }

    @Override
    protected Field[] getChildFields() {
        return CHILD_FIELDS;
    }

    @Override
    protected TypeConstant instantiateTypeConstant(Context ctx, ErrorListener errs) {
        switch (this.keyword.getId()) {
            case IMMUTABLE: {
                break;
            }
            case CONDITIONAL: {
                throw this.notImplemented();
            }
            default: {
                throw new IllegalStateException("keyword=" + String.valueOf(this.keyword));
            }
        }
        return this.type.ensureTypeConstant(ctx, errs).freeze();
    }

    @Override
    public boolean isIntroductoryType() {
        return true;
    }

    @Override
    public TypeExpression unwrapIntroductoryType() {
        return this.type;
    }

    @Override
    public void replaceIntroducedType(TypeExpression type) {
        this.type = type;
        type.setParent(this);
    }

    @Override
    protected void collectAnonInnerClassInfo(AnonInnerClass info) {
        this.type.collectAnonInnerClassInfo(info);
        if (this.keyword.getId() == Token.Id.IMMUTABLE) {
            info.markImmutable();
        }
    }

    @Override
    public String toString() {
        return this.keyword.getId().TEXT + " " + String.valueOf(this.type);
    }

    @Override
    public String getDumpDesc() {
        return this.toString();
    }
}

