/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.compiler.ast;

import org.xvm.asm.Argument;
import org.xvm.asm.ErrorListener;
import org.xvm.asm.MethodStructure;
import org.xvm.asm.ast.ExprAST;
import org.xvm.asm.constants.TypeConstant;
import org.xvm.asm.op.Label;
import org.xvm.compiler.ast.Context;
import org.xvm.compiler.ast.Expression;

public abstract class DelegatingExpression
extends Expression {
    protected Expression expr;

    protected DelegatingExpression(Expression expr) {
        this.expr = expr;
    }

    public Expression getUnderlyingExpression() {
        return this.expr;
    }

    @Override
    public void markConditional() {
        this.expr.markConditional();
    }

    @Override
    protected boolean hasMultiValueImpl() {
        return true;
    }

    @Override
    public TypeConstant getImplicitType(Context ctx) {
        return this.expr.getImplicitType(ctx);
    }

    @Override
    public TypeConstant[] getImplicitTypes(Context ctx) {
        return this.expr.getImplicitTypes(ctx);
    }

    @Override
    public Expression.TypeFit testFit(Context ctx, TypeConstant typeRequired, boolean fExhaustive, ErrorListener errs) {
        return this.expr.testFit(ctx, typeRequired, fExhaustive, errs);
    }

    @Override
    public Expression.TypeFit testFitMulti(Context ctx, TypeConstant[] atypeRequired, boolean fExhaustive, ErrorListener errs) {
        return this.expr.testFitMulti(ctx, atypeRequired, fExhaustive, errs);
    }

    @Override
    protected Expression validate(Context ctx, TypeConstant typeRequired, ErrorListener errs) {
        Expression exprNew = this.expr.validate(ctx, typeRequired, errs);
        if (exprNew == null) {
            return this.finishValidation(ctx, typeRequired, null, Expression.TypeFit.NoFit, null, errs);
        }
        this.expr = exprNew;
        return this.finishValidation(ctx, typeRequired, exprNew.getType(), exprNew.getTypeFit(), exprNew.isConstant() ? exprNew.toConstant() : null, errs);
    }

    @Override
    protected Expression validateMulti(Context ctx, TypeConstant[] atypeRequired, ErrorListener errs) {
        Expression exprNew = this.expr.validateMulti(ctx, atypeRequired, errs);
        if (exprNew == null) {
            return this.finishValidations(ctx, atypeRequired, null, Expression.TypeFit.NoFit, null, errs);
        }
        this.expr = exprNew;
        return this.finishValidations(ctx, atypeRequired, exprNew.getTypes(), exprNew.getTypeFit(), exprNew.isConstant() ? exprNew.toConstants() : null, errs);
    }

    @Override
    public boolean isAssignable(Context ctx) {
        return this.expr.isAssignable(ctx);
    }

    @Override
    public void requireAssignable(Context ctx, ErrorListener errs) {
        this.expr.requireAssignable(ctx, errs);
    }

    @Override
    public void markAssignment(Context ctx, boolean fCond, ErrorListener errs) {
        this.expr.markAssignment(ctx, fCond, errs);
    }

    @Override
    public boolean isCompletable() {
        return this.expr.isCompletable();
    }

    @Override
    public boolean isShortCircuiting() {
        return this.expr.isShortCircuiting();
    }

    @Override
    public boolean isNonBinding() {
        return this.expr.isNonBinding();
    }

    @Override
    public boolean isRuntimeConstant() {
        return this.expr.isRuntimeConstant();
    }

    @Override
    public boolean hasSideEffects() {
        return this.expr.hasSideEffects();
    }

    @Override
    public void generateVoid(Context ctx, MethodStructure.Code code, ErrorListener errs) {
        this.expr.generateVoid(ctx, code, errs);
    }

    @Override
    public Argument generateArgument(Context ctx, MethodStructure.Code code, boolean fLocalPropOk, boolean fUsedOnce, ErrorListener errs) {
        return this.expr.generateArgument(ctx, code, fLocalPropOk, fUsedOnce, errs);
    }

    @Override
    public Argument[] generateArguments(Context ctx, MethodStructure.Code code, boolean fLocalPropOk, boolean fUsedOnce, ErrorListener errs) {
        return this.expr.generateArguments(ctx, code, fLocalPropOk, fUsedOnce, errs);
    }

    @Override
    public void generateAssignment(Context ctx, MethodStructure.Code code, Expression.Assignable LVal, ErrorListener errs) {
        this.expr.generateAssignment(ctx, code, LVal, errs);
    }

    @Override
    public void generateAssignments(Context ctx, MethodStructure.Code code, Expression.Assignable[] aLVal, ErrorListener errs) {
        this.expr.generateAssignments(ctx, code, aLVal, errs);
    }

    @Override
    public void generateConditionalJump(Context ctx, MethodStructure.Code code, Label label, boolean fWhenTrue, ErrorListener errs) {
        this.expr.generateConditionalJump(ctx, code, label, fWhenTrue, errs);
    }

    @Override
    public Expression.Assignable generateAssignable(Context ctx, MethodStructure.Code code, ErrorListener errs) {
        return this.expr.generateAssignable(ctx, code, errs);
    }

    @Override
    public Expression.Assignable[] generateAssignables(Context ctx, MethodStructure.Code code, ErrorListener errs) {
        return this.expr.generateAssignables(ctx, code, errs);
    }

    @Override
    public ExprAST getExprAST(Context ctx) {
        return this.expr.getExprAST(ctx);
    }

    @Override
    protected Expression.SideEffect mightAffect(Expression exprLeft, Argument arg) {
        return this.expr.mightAffect(exprLeft, arg);
    }

    @Override
    public String getDumpDesc() {
        return this.toString();
    }
}

