/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.compiler.ast;

import java.util.Map;
import org.xvm.asm.Argument;
import org.xvm.asm.Constant;
import org.xvm.asm.ErrorListener;
import org.xvm.asm.MethodStructure;
import org.xvm.asm.constants.TypeConstant;
import org.xvm.asm.op.Jump;
import org.xvm.asm.op.Label;
import org.xvm.compiler.Token;
import org.xvm.compiler.ast.AstNode;
import org.xvm.compiler.ast.BiExpression;
import org.xvm.compiler.ast.Context;
import org.xvm.compiler.ast.Expression;
import org.xvm.util.Severity;

public class ElseExpression
extends BiExpression {
    private static int s_nCounter;
    private transient int m_nLabel;
    private transient Label m_labelElse;
    private transient Map<String, Argument> m_mapElse;
    private transient boolean m_fCondFalse;

    public ElseExpression(Expression expr1, Token operator, Expression expr2) {
        super(expr1, operator, expr2);
    }

    @Override
    protected boolean allowsConditional(Expression exprChild) {
        return this.getParent().allowsShortCircuit(this) && (exprChild == this.expr1 || exprChild == this.expr2);
    }

    @Override
    protected boolean hasSingleValueImpl() {
        return false;
    }

    @Override
    protected boolean hasMultiValueImpl() {
        return true;
    }

    @Override
    public TypeConstant[] getImplicitTypes(Context ctx) {
        TypeConstant[] atype1 = this.expr1.getImplicitTypes(ctx);
        if (!this.expr2.isCompletable()) {
            return atype1;
        }
        TypeConstant[] atype2 = this.expr2.getImplicitTypes(ctx);
        if (atype1 == null || atype1.length == 0 || atype2 == null || atype2.length == 0) {
            return TypeConstant.NO_TYPES;
        }
        return this.selectCommonTypes(atype1, atype2);
    }

    @Override
    public Expression.TypeFit testFitMulti(Context ctx, TypeConstant[] atypeRequired, boolean fExhaustive, ErrorListener errs) {
        Expression.TypeFit fit = this.expr1.testFitMulti(ctx, atypeRequired, fExhaustive, errs);
        if (fit.isFit() && this.expr2.isCompletable()) {
            fit = fit.combineWith(this.expr2.testFitMulti(ctx, atypeRequired, fExhaustive, errs));
        }
        return fit;
    }

    @Override
    protected Expression validateMulti(Context ctx, TypeConstant[] atypeRequired, ErrorListener errs) {
        TypeConstant[] atypeResult;
        ctx = ctx.enterIf().enterFork(true);
        Expression expr1New = this.expr1.validateMulti(ctx, atypeRequired, errs);
        ctx = ctx.exit();
        if (expr1New == null) {
            return null;
        }
        this.expr1 = expr1New;
        TypeConstant[] atype1 = expr1New.getTypes();
        TypeConstant[] atype2Req = this.selectCommonTypes(atype1, new TypeConstant[atype1.length]);
        if (!(atypeRequired == null || atypeRequired.length <= 0 || atype2Req != null && this.expr2.testFitMulti(ctx, atype2Req, false, null).isFit())) {
            atype2Req = atypeRequired;
        }
        ctx = ctx.enterFork(false);
        ctx.replaceArguments(this.m_mapElse);
        Expression expr2New = this.expr2.validateMulti(ctx, atype2Req, errs);
        ctx = ctx.exit().exit();
        if (expr2New == null) {
            return null;
        }
        this.expr2 = expr2New;
        if (!expr1New.isShortCircuiting()) {
            expr1New.log(errs, Severity.ERROR, "COMPILER-74", new Object[0]);
            return null;
        }
        if (expr1New.isConditionalResult() && expr2New.isConstantFalse()) {
            atypeResult = atype1;
            this.m_fCondFalse = true;
        } else {
            atypeResult = this.selectCommonTypes(atype1, expr2New.getTypes());
        }
        Constant[] aconstVal = null;
        if (expr1New.isConstant()) {
            aconstVal = expr1New.toConstants();
        }
        if (this.m_labelElse != null) {
            this.m_labelElse.restoreNarrowed(ctx);
        }
        return this.finishValidations(ctx, atypeRequired, atypeResult, Expression.TypeFit.Fit, aconstVal, errs);
    }

    @Override
    public boolean isStandalone() {
        return this.expr1.isStandalone() && this.expr2.isStandalone();
    }

    @Override
    public boolean isShortCircuiting() {
        return this.expr2.isShortCircuiting();
    }

    @Override
    public boolean isCompletable() {
        return this.expr1.isCompletable();
    }

    @Override
    protected boolean allowsShortCircuit(AstNode nodeChild) {
        return nodeChild == this.expr1 || super.allowsShortCircuit(nodeChild);
    }

    @Override
    protected Label ensureShortCircuitLabel(AstNode nodeOrigin, Context ctxOrigin) {
        AstNode nodeChild = this.findChild(nodeOrigin);
        if (nodeChild != this.expr1) {
            assert (nodeChild == this.expr2);
            return super.ensureShortCircuitLabel(nodeOrigin, ctxOrigin);
        }
        this.m_mapElse = ctxOrigin.mergeNarrowedElseTypes(this.m_mapElse);
        Label label = this.m_labelElse;
        if (label == null) {
            this.m_nLabel = ++s_nCounter;
            this.m_labelElse = label = new Label("else_:_" + this.m_nLabel);
        }
        return label;
    }

    @Override
    public void generateAssignments(Context ctx, MethodStructure.Code code, Expression.Assignable[] aLVal, ErrorListener errs) {
        if (this.isConstant()) {
            super.generateAssignments(ctx, code, aLVal, errs);
            return;
        }
        this.expr1.generateAssignments(ctx, code, aLVal, errs);
        if (this.m_labelElse != null) {
            Label labelEnd = new Label("end_:_" + this.m_nLabel);
            code.add(new Jump(labelEnd));
            code.add(this.m_labelElse);
            if (this.m_fCondFalse) {
                aLVal[0].assign(this.pool().valFalse(), code, errs);
            } else {
                this.expr2.generateAssignments(ctx, code, aLVal, errs);
            }
            code.add(labelEnd);
        }
    }
}

