/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.compiler.ast;

import org.xvm.asm.Argument;
import org.xvm.asm.Constant;
import org.xvm.asm.ConstantPool;
import org.xvm.asm.ErrorListener;
import org.xvm.asm.MethodStructure;
import org.xvm.asm.Op;
import org.xvm.asm.constants.TypeConstant;
import org.xvm.asm.op.JumpNotNull;
import org.xvm.asm.op.JumpTrue;
import org.xvm.asm.op.Label;
import org.xvm.compiler.Token;
import org.xvm.compiler.ast.BiExpression;
import org.xvm.compiler.ast.Context;
import org.xvm.compiler.ast.Expression;
import org.xvm.util.Severity;

public class ElvisExpression
extends BiExpression {
    private static int s_nCounter;
    private transient boolean m_fCond;
    private transient Label m_labelEnd;

    public ElvisExpression(Expression expr1, Token operator, Expression expr2) {
        super(expr1, operator, expr2);
    }

    @Override
    public TypeConstant getImplicitType(Context ctx) {
        TypeConstant type1;
        TypeConstant[] atype1 = this.expr1.getImplicitTypes(ctx);
        switch (atype1.length) {
            case 0: {
                return null;
            }
            case 1: {
                type1 = atype1[0].removeNullable();
                break;
            }
            default: {
                TypeConstant type0 = atype1[0];
                type1 = type0.isA(this.pool().typeBoolean()) ? atype1[1] : type0.removeNullable();
            }
        }
        TypeConstant type2 = this.expr2.getImplicitType(ctx);
        if (type1 == null || type2 == null) {
            return null;
        }
        TypeConstant typeResult = Op.selectCommonType(type1, type2, ErrorListener.BLACKHOLE);
        return typeResult == null ? this.pool().ensureUnionTypeConstant(type1, type2) : typeResult;
    }

    @Override
    public Expression.TypeFit testFit(Context ctx, TypeConstant typeRequired, boolean fExhaustive, ErrorListener errs) {
        ErrorListener errsTemp = errs == null ? ErrorListener.BLACKHOLE : errs.branch(this);
        TypeConstant[] atypeCond = new TypeConstant[]{this.pool().typeBoolean(), typeRequired};
        Expression.TypeFit fit = this.expr1.testFitMulti(ctx, atypeCond, fExhaustive, errsTemp);
        if (fit.isFit()) {
            errsTemp.merge();
        } else {
            fit = this.expr1.testFit(ctx, typeRequired.ensureNullable(), fExhaustive, errs);
        }
        if (fit.isFit()) {
            fit = fit.combineWith(this.expr2.testFit(ctx, typeRequired, fExhaustive, errs));
        }
        return fit;
    }

    @Override
    protected Expression validate(Context ctx, TypeConstant typeRequired, ErrorListener errs) {
        TypeConstant type1Non;
        TypeConstant type2Req;
        Expression expr1New;
        ConstantPool pool = this.pool();
        Expression.TypeFit fit = Expression.TypeFit.Fit;
        boolean fCond = false;
        TypeConstant[] atypeCond = new TypeConstant[]{pool.typeBoolean(), pool.typeObject()};
        TypeConstant type1 = null;
        if (this.expr1.testFitMulti(ctx = ctx.enterIf(), atypeCond, true, ErrorListener.BLACKHOLE).isFit()) {
            fCond = true;
            this.m_fCond = true;
            if (typeRequired != null) {
                atypeCond[1] = typeRequired;
            }
            expr1New = this.expr1.validateMulti(ctx, atypeCond, errs);
        } else {
            TypeConstant type1Req = typeRequired == null ? null : typeRequired.ensureNullable();
            expr1New = this.expr1.validate(ctx, type1Req, errs);
        }
        if (expr1New == null) {
            fit = Expression.TypeFit.NoFit;
        } else {
            this.expr1 = expr1New;
            type1 = fCond ? expr1New.getTypes()[1] : expr1New.getType();
        }
        TypeConstant typeConstant = type2Req = type1 == null ? null : Op.selectCommonType(type1.removeNullable(), null, errs);
        if (typeRequired == null) {
            TypeConstant type2;
            if (type2Req != null && !this.expr2.testFit(ctx, type2Req, true, null).isFit() && (type2 = this.expr2.getImplicitType(ctx)) != null) {
                type2Req = type2Req.union(pool, type2);
            }
        } else if (type2Req == null || !this.expr2.testFit(ctx, type2Req, false, null).isFit()) {
            type2Req = typeRequired;
        }
        ctx = ctx.enterFork(true);
        ctx = ctx.exit();
        Expression expr2New = this.expr2.validate(ctx = ctx.enterFork(false), type2Req, errs);
        if (expr2New == null) {
            fit = Expression.TypeFit.NoFit;
        } else {
            this.expr2 = expr2New;
        }
        ctx = ctx.exit();
        ctx = ctx.exit();
        if (!fit.isFit()) {
            return this.finishValidation(ctx, typeRequired, null, fit, null, errs);
        }
        TypeConstant type2 = expr2New.getType();
        if (fCond) {
            type1Non = type1;
        } else {
            if (type1.isOnlyNullable()) {
                expr1New.log(errs, Severity.ERROR, "COMPILER-72", new Object[0]);
                return null;
            }
            if (!type1.isNullable() && !pool.typeNull().isA(type1.resolveConstraints())) {
                expr1New.log(errs, Severity.ERROR, "COMPILER-71", new Object[0]);
                return null;
            }
            type1Non = type1.removeNullable();
        }
        TypeConstant typeResult = Op.selectCommonType(type1Non, type2, errs);
        if (typeResult == null) {
            typeResult = pool.ensureUnionTypeConstant(type1Non, type2);
        }
        Constant constVal = null;
        if (expr1New.isConstant()) {
            if (fCond) {
                Constant[] aconst1 = expr1New.toConstants();
                if (aconst1[0] == this.pool().valTrue()) {
                    constVal = aconst1[1];
                } else if (aconst1[0] == this.pool().valFalse() && expr2New.isConstant()) {
                    constVal = expr2New.toConstant();
                }
            } else {
                Constant const1 = expr1New.toConstant();
                if (const1.equals(pool.valNull())) {
                    if (expr2New.isConstant()) {
                        constVal = expr2New.toConstant();
                    }
                } else {
                    constVal = const1;
                }
            }
        }
        return this.finishValidation(ctx, typeRequired, typeResult, fit, constVal, errs);
    }

    @Override
    protected boolean allowsConditional(Expression exprChild) {
        return this.m_fCond && exprChild == this.expr1;
    }

    @Override
    public boolean isCompletable() {
        return this.expr1.isCompletable();
    }

    @Override
    public Argument generateArgument(Context ctx, MethodStructure.Code code, boolean fLocalPropOk, boolean fUsedOnce, ErrorListener errs) {
        if (this.isConstant()) {
            return super.generateArgument(ctx, code, fLocalPropOk, fUsedOnce, errs);
        }
        if (this.m_fCond) {
            Label labelEnd = this.getEndLabel();
            Expression.Assignable varCond = this.createTempVar(code, this.pool().typeBoolean(), true);
            Expression.Assignable varVal = this.createTempVar(code, this.getType(), false);
            Expression.Assignable[] LVals = new Expression.Assignable[]{varCond, varVal};
            this.expr1.generateAssignments(ctx, code, LVals, errs);
            code.add(new JumpTrue(varCond.getRegister(), labelEnd));
            this.expr2.generateAssignment(ctx, code, varVal, errs);
            code.add(labelEnd);
            return varVal.getRegister();
        }
        TypeConstant typeTemp = this.getType().ensureNullable();
        Expression.Assignable var = this.createTempVar(code, typeTemp, false);
        this.generateAssignment(ctx, code, var, errs);
        return var.getRegister();
    }

    @Override
    public void generateAssignment(Context ctx, MethodStructure.Code code, Expression.Assignable LVal, ErrorListener errs) {
        if (this.isConstant() || !LVal.isNormalVariable() || !this.m_fCond && !this.pool().typeNull().isA(LVal.getType())) {
            super.generateAssignment(ctx, code, LVal, errs);
            return;
        }
        Label labelEnd = this.getEndLabel();
        if (this.m_fCond) {
            Expression.Assignable varCond = this.createTempVar(code, this.pool().typeBoolean(), true);
            Expression.Assignable[] LVals = new Expression.Assignable[]{varCond, LVal};
            this.expr1.generateAssignments(ctx, code, LVals, errs);
            code.add(new JumpTrue(varCond.getRegister(), labelEnd));
        } else {
            this.expr1.generateAssignment(ctx, code, LVal, errs);
            code.add(new JumpNotNull(LVal.getLocalArgument(), labelEnd));
        }
        this.expr2.generateAssignment(ctx, code, LVal, errs);
        code.add(labelEnd);
    }

    protected Label getEndLabel() {
        Label labelEnd = this.m_labelEnd;
        if (labelEnd == null) {
            this.m_labelEnd = labelEnd = new Label("end_?:_" + ++s_nCounter);
        }
        return labelEnd;
    }
}

