/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.compiler.ast;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.xvm.asm.Argument;
import org.xvm.asm.ClassStructure;
import org.xvm.asm.Constant;
import org.xvm.asm.ConstantPool;
import org.xvm.asm.Constants;
import org.xvm.asm.ErrorListener;
import org.xvm.asm.MethodStructure;
import org.xvm.asm.Op;
import org.xvm.asm.OpInPlaceAssign;
import org.xvm.asm.OpIndexInPlace;
import org.xvm.asm.OpPropInPlaceAssign;
import org.xvm.asm.Register;
import org.xvm.asm.ast.ExprAST;
import org.xvm.asm.constants.ConditionalConstant;
import org.xvm.asm.constants.MethodConstant;
import org.xvm.asm.constants.PropertyConstant;
import org.xvm.asm.constants.SingletonConstant;
import org.xvm.asm.constants.StringConstant;
import org.xvm.asm.constants.TypeConstant;
import org.xvm.asm.constants.TypeInfo;
import org.xvm.asm.op.IIP_Add;
import org.xvm.asm.op.IIP_And;
import org.xvm.asm.op.IIP_Dec;
import org.xvm.asm.op.IIP_Div;
import org.xvm.asm.op.IIP_Inc;
import org.xvm.asm.op.IIP_Mod;
import org.xvm.asm.op.IIP_Mul;
import org.xvm.asm.op.IIP_Or;
import org.xvm.asm.op.IIP_PostDec;
import org.xvm.asm.op.IIP_PostInc;
import org.xvm.asm.op.IIP_PreDec;
import org.xvm.asm.op.IIP_PreInc;
import org.xvm.asm.op.IIP_Shl;
import org.xvm.asm.op.IIP_Shr;
import org.xvm.asm.op.IIP_ShrAll;
import org.xvm.asm.op.IIP_Sub;
import org.xvm.asm.op.IIP_Xor;
import org.xvm.asm.op.IP_Add;
import org.xvm.asm.op.IP_And;
import org.xvm.asm.op.IP_Dec;
import org.xvm.asm.op.IP_Div;
import org.xvm.asm.op.IP_Inc;
import org.xvm.asm.op.IP_Mod;
import org.xvm.asm.op.IP_Mul;
import org.xvm.asm.op.IP_Or;
import org.xvm.asm.op.IP_PostDec;
import org.xvm.asm.op.IP_PostInc;
import org.xvm.asm.op.IP_PreDec;
import org.xvm.asm.op.IP_PreInc;
import org.xvm.asm.op.IP_Shl;
import org.xvm.asm.op.IP_Shr;
import org.xvm.asm.op.IP_ShrAll;
import org.xvm.asm.op.IP_Sub;
import org.xvm.asm.op.IP_Xor;
import org.xvm.asm.op.I_Get;
import org.xvm.asm.op.I_Set;
import org.xvm.asm.op.Jump;
import org.xvm.asm.op.JumpFalse;
import org.xvm.asm.op.JumpTrue;
import org.xvm.asm.op.L_Get;
import org.xvm.asm.op.L_Set;
import org.xvm.asm.op.Label;
import org.xvm.asm.op.Move;
import org.xvm.asm.op.PIP_Add;
import org.xvm.asm.op.PIP_And;
import org.xvm.asm.op.PIP_Dec;
import org.xvm.asm.op.PIP_Div;
import org.xvm.asm.op.PIP_Inc;
import org.xvm.asm.op.PIP_Mod;
import org.xvm.asm.op.PIP_Mul;
import org.xvm.asm.op.PIP_Or;
import org.xvm.asm.op.PIP_PostDec;
import org.xvm.asm.op.PIP_PostInc;
import org.xvm.asm.op.PIP_PreDec;
import org.xvm.asm.op.PIP_PreInc;
import org.xvm.asm.op.PIP_Shl;
import org.xvm.asm.op.PIP_Shr;
import org.xvm.asm.op.PIP_ShrAll;
import org.xvm.asm.op.PIP_Sub;
import org.xvm.asm.op.PIP_Xor;
import org.xvm.asm.op.P_Get;
import org.xvm.asm.op.P_Set;
import org.xvm.asm.op.Var;
import org.xvm.asm.op.Var_I;
import org.xvm.asm.op.Var_IN;
import org.xvm.compiler.Compiler;
import org.xvm.compiler.Token;
import org.xvm.compiler.ast.AstNode;
import org.xvm.compiler.ast.BadTypeExpression;
import org.xvm.compiler.ast.ComponentStatement;
import org.xvm.compiler.ast.Context;
import org.xvm.compiler.ast.ConvertExpression;
import org.xvm.compiler.ast.LiteralExpression;
import org.xvm.compiler.ast.StageMgr;
import org.xvm.compiler.ast.TraceExpression;
import org.xvm.compiler.ast.TypeExpression;
import org.xvm.compiler.ast.UnpackExpression;
import org.xvm.compiler.ast.VariableDeclarationStatement;
import org.xvm.util.Handy;
import org.xvm.util.Severity;

public abstract class Expression
extends AstNode {
    public static final Assignable[] NO_LVALUES = new Assignable[0];
    public static final Argument[] NO_RVALUES = new Argument[0];
    private static final int IN_ASSIGNMENT = 0x40000000;
    private static final int ILLEGAL_SHORT = 0x20000000;
    private TypeFit m_fit;
    private Object m_oType;
    private Object m_oConst;
    private transient int m_nFlags;

    @Override
    protected boolean usesSuper() {
        for (AstNode node : this.children()) {
            if (node instanceof ComponentStatement || !node.usesSuper()) continue;
            return true;
        }
        return false;
    }

    public TypeExpression toTypeExpression() {
        return new BadTypeExpression(this);
    }

    public boolean validateCondition(ErrorListener errs) {
        this.log(errs, Severity.ERROR, "COMPILER-27", new Object[0]);
        return false;
    }

    public ConditionalConstant toConditionalConstant() {
        throw this.notImplemented();
    }

    public void markConditional() {
    }

    protected boolean hasSingleValueImpl() {
        return true;
    }

    protected boolean hasMultiValueImpl() {
        return false;
    }

    public TypeConstant getImplicitType(Context ctx) {
        if (!this.hasMultiValueImpl()) {
            throw this.notImplemented();
        }
        TypeConstant[] aTypes = this.getImplicitTypes(ctx);
        return aTypes == null || aTypes.length == 0 ? null : aTypes[0];
    }

    public TypeConstant[] getImplicitTypes(Context ctx) {
        TypeConstant[] typeConstantArray;
        if (!this.hasSingleValueImpl()) {
            throw this.notImplemented();
        }
        TypeConstant type = this.getImplicitType(ctx);
        if (type == null) {
            typeConstantArray = TypeConstant.NO_TYPES;
        } else {
            TypeConstant[] typeConstantArray2 = new TypeConstant[1];
            typeConstantArray = typeConstantArray2;
            typeConstantArray2[0] = type;
        }
        return typeConstantArray;
    }

    public TypeFit testFit(Context ctx, TypeConstant typeRequired, boolean fExhaustive, ErrorListener errs) {
        if (typeRequired == null) {
            return TypeFit.Fit;
        }
        if (this.hasSingleValueImpl()) {
            return this.calcFit(ctx, this.getImplicitType(ctx), typeRequired);
        }
        if (this.hasMultiValueImpl()) {
            TypeConstant[] typeConstantArray;
            if (typeRequired == null) {
                typeConstantArray = TypeConstant.NO_TYPES;
            } else {
                TypeConstant[] typeConstantArray2 = new TypeConstant[1];
                typeConstantArray = typeConstantArray2;
                typeConstantArray2[0] = typeRequired;
            }
            return this.testFitMulti(ctx, typeConstantArray, fExhaustive, errs);
        }
        throw this.notImplemented();
    }

    public TypeFit testFitMulti(Context ctx, TypeConstant[] atypeRequired, boolean fExhaustive, ErrorListener errs) {
        switch (atypeRequired.length) {
            case 0: {
                return TypeFit.Fit;
            }
            case 1: {
                if (!this.hasSingleValueImpl()) break;
                return this.testFit(ctx, atypeRequired[0], fExhaustive, errs);
            }
        }
        return this.hasMultiValueImpl() ? this.calcFitMulti(ctx, this.getImplicitTypes(ctx), atypeRequired) : TypeFit.NoFit;
    }

    protected TypeFit testFitExhaustive(Context ctx, TypeConstant typeRequired, ErrorListener errs) {
        return this.testFitMultiExhaustive(ctx, new TypeConstant[]{typeRequired}, errs);
    }

    protected TypeFit testFitMultiExhaustive(Context ctx, TypeConstant[] atypeRequired, ErrorListener errs) {
        Expression exprTemp = (Expression)this.clone();
        Context ctxTemp = ctx.enter();
        Expression exprNew = exprTemp.validateMulti(ctxTemp, atypeRequired, errs == null ? ErrorListener.BLACKHOLE : errs);
        exprTemp.discard(true);
        ctxTemp.discard();
        return exprNew == null ? TypeFit.NoFit : TypeFit.Fit;
    }

    protected TypeFit calcFit(Context ctx, TypeConstant typeIn, TypeConstant typeOut) {
        if (typeIn == null) {
            return TypeFit.NoFit;
        }
        if (typeOut == null || this.isA(ctx, typeIn, typeOut)) {
            return TypeFit.Fit;
        }
        if (typeIn.getConverterTo(typeOut) != null) {
            return TypeFit.Conv;
        }
        return TypeFit.NoFit;
    }

    protected TypeFit calcFitMulti(Context ctx, TypeConstant[] atypeIn, TypeConstant[] atypeOut) {
        TypeConstant typeOut;
        int cTypesIn = atypeIn.length;
        int cTypesOut = atypeOut.length;
        if (cTypesIn < cTypesOut) {
            return TypeFit.NoFit;
        }
        TypeFit fitOut = TypeFit.Fit;
        if (cTypesOut == 1 && (typeOut = atypeOut[0]).isTuple() && typeOut.getParamsCount() <= cTypesIn && (cTypesIn > 1 || !atypeIn[0].isTuple())) {
            atypeOut = typeOut.getParamTypesArray();
            cTypesOut = atypeOut.length;
            fitOut = TypeFit.Pack;
        }
        for (int i = 0; i < cTypesOut; ++i) {
            TypeConstant typeIn = atypeIn[i];
            TypeConstant typeOut2 = atypeOut[i];
            TypeFit fitSingle = this.calcFit(ctx, typeIn, typeOut2);
            if (!fitOut.isFit()) {
                return TypeFit.NoFit;
            }
            fitOut = fitOut.combineWith(fitSingle);
        }
        return fitOut;
    }

    protected Expression validate(Context ctx, TypeConstant typeRequired, ErrorListener errs) {
        TypeConstant[] typeConstantArray;
        if (!this.hasMultiValueImpl()) {
            throw this.notImplemented();
        }
        if (typeRequired == null) {
            typeConstantArray = TypeConstant.NO_TYPES;
        } else {
            TypeConstant[] typeConstantArray2 = new TypeConstant[1];
            typeConstantArray = typeConstantArray2;
            typeConstantArray2[0] = typeRequired;
        }
        TypeConstant[] aTypes = typeConstantArray;
        return this.validateMulti(ctx, aTypes, errs);
    }

    protected Expression validateMulti(Context ctx, TypeConstant[] atypeRequired, ErrorListener errs) {
        int cTypesRequired;
        int n = cTypesRequired = atypeRequired == null ? 0 : atypeRequired.length;
        if (cTypesRequired > 1 && !this.getParent().allowsConditional(this)) {
            return new UnpackExpression(this, null).validateMulti(ctx, atypeRequired, errs);
        }
        if (this.hasSingleValueImpl()) {
            Expression exprNew = this.validate(ctx, cTypesRequired == 0 ? null : atypeRequired[0], errs);
            if (cTypesRequired > 1 && exprNew != null && !exprNew.getType().equals(this.pool().typeFalse())) {
                this.log(errs, Severity.ERROR, "COMPILER-44", cTypesRequired, 1);
            }
            return exprNew;
        }
        throw this.notImplemented();
    }

    protected TypeFit testFitAsType(Context ctx, TypeConstant typeRequired, boolean fExhaustive, ErrorListener errs) {
        TypeExpression exprType = this.toTypeExpression();
        return new StageMgr(exprType, Compiler.Stage.Validated, errs).fastForward(20) ? exprType.testFit(ctx, typeRequired, fExhaustive, ErrorListener.BLACKHOLE) : TypeFit.NoFit;
    }

    protected Expression validateAsType(Context ctx, TypeConstant typeRequired, ErrorListener errs) {
        ErrorListener errsTemp;
        Expression exprNew;
        TypeExpression exprType = this.toTypeExpression();
        if (new StageMgr(exprType, Compiler.Stage.Validated, ErrorListener.BLACKHOLE).fastForward(20) && (exprNew = exprType.validate(ctx, typeRequired, errsTemp = errs.branch(this))) != null) {
            errsTemp.merge();
            return exprNew;
        }
        return null;
    }

    protected Expression finishValidation(Context ctx, TypeConstant typeRequired, TypeConstant typeActual, TypeFit fit, Constant constVal, ErrorListener errs) {
        assert (fit != null);
        if (fit.isFit()) {
            this.checkShortCircuit(errs);
        }
        ConstantPool pool = this.pool();
        if (typeActual == null) {
            assert (!fit.isFit());
            assert (constVal == null);
            this.m_fit = TypeFit.NoFit;
            this.m_oType = typeRequired == null ? pool.typeObject() : typeRequired;
            this.m_oConst = null;
            return null;
        }
        if (constVal != null && !constVal.equals(pool.ensureMatchAnyConstant(typeActual)) && !typeActual.isA(pool.typeService())) {
            typeActual = typeActual.freeze();
        }
        MethodConstant idConv = null;
        if (typeRequired != null && fit.isFit() && !this.isA(ctx, typeActual, typeRequired)) {
            typeRequired = typeRequired.removeAutoNarrowing();
            if (fit.isConverting() || (idConv = typeActual.ensureTypeInfo(errs).findConversion(typeRequired)) == null) {
                this.reportTypeMismatch(typeRequired, typeActual, errs);
                fit = TypeFit.NoFit;
            } else if (constVal != null && !(constVal instanceof SingletonConstant)) {
                Constant constConv = this.convertConstant(constVal, typeRequired, errs);
                if (constConv == null) {
                    this.log(errs, Severity.ERROR, "COMPILER-NI", "Constant conversion from \"" + typeActual.getValueString() + "\" to \"" + typeRequired.getValueString() + "\"");
                    fit = TypeFit.NoFit;
                } else {
                    typeActual = constConv.getType().freeze();
                    idConv = null;
                    fit = TypeFit.Conv;
                }
                constVal = constConv;
            }
        }
        if (typeActual.containsUnresolved()) {
            typeActual = typeActual.resolveConstraints(true);
        }
        this.m_fit = fit;
        this.m_oType = typeActual;
        this.m_oConst = constVal;
        if (!fit.isFit()) {
            return null;
        }
        return idConv == null ? this : new ConvertExpression(this, new MethodConstant[]{idConv}, errs);
    }

    protected TypeConstant inferTypeFromRequired(TypeConstant typeActual, TypeConstant typeRequired) {
        if (typeRequired.isNullable() && !typeActual.isNullable()) {
            typeRequired = typeRequired.removeNullable();
        }
        if (typeRequired.isParameterizedDeep() && !typeActual.equals(typeRequired)) {
            if (typeActual.isParamsSpecified()) {
                TypeConstant[] atypeRequired = typeRequired.getParamTypesArray();
                TypeConstant[] atypeActual = typeActual.getParamTypesArray();
                int cRequired = atypeRequired.length;
                int cActual = atypeActual.length;
                TypeConstant[] atypeInferred = atypeActual;
                int c = Math.min(cRequired, cActual);
                for (int i = 0; i < c; ++i) {
                    TypeConstant typeInferred = this.inferTypeFromRequired(atypeActual[i], atypeRequired[i]);
                    if (typeInferred == null) continue;
                    if (atypeInferred == atypeActual) {
                        atypeInferred = (TypeConstant[])atypeInferred.clone();
                    }
                    atypeInferred[i] = typeInferred;
                }
                return atypeInferred == atypeActual ? null : typeActual.adoptParameters(this.pool(), atypeInferred);
            }
            TypeConstant typeInferred = typeActual.adoptParameters(this.pool(), typeRequired);
            if (typeInferred.isA(typeRequired)) {
                return typeInferred;
            }
        }
        return null;
    }

    protected TypeConstant inferTypeFromConstructor(Context ctx, ClassStructure clz, MethodStructure ctor, List<Expression> listExpr) {
        TypeConstant[] atypeParam = ctor.getParamTypes();
        int cArgs = listExpr.size();
        assert (cArgs <= atypeParam.length);
        HashMap<String, TypeConstant> mapResolve = new HashMap<String, TypeConstant>();
        for (Map.Entry<StringConstant, TypeConstant> entry : clz.getTypeParamsAsList()) {
            String sName = entry.getKey().getValue();
            for (int i = 0; i < cArgs; ++i) {
                TypeConstant typeResolved;
                TypeConstant typeActual = listExpr.get(i).getImplicitType(ctx);
                if (typeActual == null || (typeResolved = atypeParam[i].resolveTypeParameter(typeActual, sName)) == null) continue;
                if (typeResolved.isEnumValue()) {
                    typeResolved = typeResolved.getSingleUnderlyingClass(false).getNamespace().getType();
                }
                mapResolve.put(sName, typeResolved);
            }
        }
        return mapResolve.isEmpty() ? null : clz.getFormalType().resolveGenerics(this.pool(), mapResolve::get);
    }

    protected Expression finishValidations(Context ctx, TypeConstant[] atypeRequired, TypeConstant[] atypeActual, TypeFit fit, Constant[] aconstVal, ErrorListener errs) {
        int cTypeReqs;
        assert (fit != null);
        assert (atypeRequired == null || Handy.checkElementsNonNull(atypeRequired));
        assert (atypeActual == null || Handy.checkElementsNonNull(atypeActual));
        assert (aconstVal == null || Handy.checkElementsNonNull(aconstVal) && aconstVal.length == atypeActual.length);
        if (fit.isFit()) {
            this.checkShortCircuit(errs);
        }
        ConstantPool pool = this.pool();
        if (atypeActual == null) {
            assert (!fit.isFit() && aconstVal == null && (errs.hasSeriousErrors() || errs.isSilent()));
            this.m_fit = TypeFit.NoFit;
            return null;
        }
        int cActual = atypeActual.length;
        int n = cTypeReqs = atypeRequired == null ? 0 : atypeRequired.length;
        if (cTypeReqs > cActual && fit.isFit()) {
            this.log(errs, Severity.ERROR, "COMPILER-44", cTypeReqs, cActual);
            this.m_fit = TypeFit.NoFit;
            return null;
        }
        boolean fCloneActual = true;
        for (int i = 0; i < cActual; ++i) {
            TypeConstant typeImm;
            Constant constVal;
            TypeConstant typeActual = atypeActual[i];
            if (typeActual.containsUnresolved()) {
                typeActual = typeActual.resolveConstraints(true);
            }
            Constant constant = constVal = aconstVal == null ? null : aconstVal[i];
            if (constVal == null || constVal.equals(pool.ensureMatchAnyConstant(typeActual)) || typeActual.isA(pool.typeService()) || typeActual.equals(typeImm = typeActual.freeze())) continue;
            if (fCloneActual) {
                atypeActual = (TypeConstant[])atypeActual.clone();
                fCloneActual = false;
            }
            atypeActual[i] = typeImm;
        }
        MethodConstant[] aIdConv = null;
        if (cTypeReqs > 0 && fit.isFit()) {
            int c = Math.min(cActual, cTypeReqs);
            for (int i = 0; i < c; ++i) {
                Constant constVal;
                MethodConstant idConv;
                TypeConstant typeActual = atypeActual[i];
                TypeConstant typeRequired = atypeRequired[i];
                if (this.isA(ctx, typeActual, typeRequired)) continue;
                if (fit.isConverting() || (idConv = typeActual.ensureTypeInfo(errs).findConversion(typeRequired)) == null) {
                    this.reportTypeMismatch(typeRequired, typeActual, errs);
                    fit = TypeFit.NoFit;
                    continue;
                }
                Constant constant = constVal = aconstVal == null ? null : aconstVal[i];
                if (constVal != null) {
                    Constant constConv = this.convertConstant(constVal, typeRequired, errs);
                    if (constConv == null) {
                        System.err.println("No conversion found for " + String.valueOf(constVal));
                    } else {
                        if (fCloneActual) {
                            atypeActual = (TypeConstant[])atypeActual.clone();
                            fCloneActual = false;
                        }
                        atypeActual[i] = constConv.getType().freeze();
                        idConv = null;
                    }
                    aconstVal[i] = constConv;
                }
                if (idConv == null) continue;
                if (aIdConv == null) {
                    aIdConv = new MethodConstant[cActual];
                }
                aIdConv[i] = idConv;
            }
        }
        if (cTypeReqs > cActual && aconstVal != null) {
            Constant[] aconstNew = new Constant[cTypeReqs];
            System.arraycopy(aconstVal, 0, aconstNew, 0, cActual);
            aconstVal = aconstNew;
            for (int i = cActual; i < cTypeReqs; ++i) {
                aconstVal[i] = this.generateFakeConstant(atypeRequired[i]);
            }
        }
        this.m_fit = fit;
        this.m_oType = fit.isFit() || atypeRequired == null ? atypeActual : null;
        this.m_oConst = aconstVal;
        if (!fit.isFit()) {
            return null;
        }
        return aIdConv == null ? this : new ConvertExpression(this, aIdConv, errs);
    }

    protected boolean isA(Context ctx, TypeConstant typeIn, TypeConstant typeOut) {
        if (typeIn.isA(typeOut)) {
            return true;
        }
        if (ctx == null) {
            return false;
        }
        TypeConstant typeInR = ctx.resolveFormalType(typeIn);
        TypeConstant typeOutR = ctx.resolveFormalType(typeOut);
        return (typeInR != typeIn || typeOutR != typeOut) && typeInR.isA(typeOutR);
    }

    protected boolean isAssignable(Context ctx, TypeConstant typeIn, TypeConstant typeOut) {
        if (typeIn.isAssignableTo(typeOut)) {
            return true;
        }
        if (ctx == null) {
            return false;
        }
        TypeConstant typeOutResolved = ctx.resolveFormalType(typeOut);
        return typeOutResolved != typeOut && typeIn.isAssignableTo(typeOutResolved);
    }

    public boolean isStandalone() {
        return false;
    }

    protected Expression replaceThisWith(Expression that) {
        this.getParent().adopt(that);
        that.setStage(this.getStage());
        return that;
    }

    public boolean isValidated() {
        return this.m_fit != null;
    }

    protected void checkValidated() {
        if (!this.isValidated()) {
            throw new IllegalStateException("Expression has not been validated: " + String.valueOf(this));
        }
    }

    public int getValueCount() {
        int n;
        this.checkValidated();
        Object object = this.m_oType;
        if (object instanceof TypeConstant[]) {
            TypeConstant[] aTypes = (TypeConstant[])object;
            n = aTypes.length;
        } else {
            n = 1;
        }
        return n;
    }

    public boolean isVoid() {
        return this.getValueCount() == 0;
    }

    public boolean isSingle() {
        return this.getValueCount() == 1;
    }

    public boolean isConditionalResult() {
        return false;
    }

    public TypeFit getTypeFit() {
        this.checkValidated();
        return this.m_fit;
    }

    public TypeConstant getType() {
        this.checkValidated();
        Object object = this.m_oType;
        if (object instanceof TypeConstant) {
            TypeConstant type = (TypeConstant)object;
            return type;
        }
        TypeConstant[] atype = (TypeConstant[])this.m_oType;
        return atype.length == 0 ? null : atype[0];
    }

    public String getTypeString(Context ctx) {
        TypeConstant type;
        Object object = this.m_oType;
        if (object instanceof TypeConstant) {
            TypeConstant type2 = (TypeConstant)object;
            return type2.getValueString();
        }
        object = this.m_oType;
        if (object instanceof TypeConstant[]) {
            TypeConstant[] aTypes = (TypeConstant[])object;
            return switch (aTypes.length) {
                case 0 -> "void";
                case 1 -> aTypes[0].getValueString();
                default -> aTypes[0].getValueString() + " (+" + (aTypes.length - 1) + " more)";
            };
        }
        if (ctx != null && (type = this.getImplicitType(ctx)) != null) {
            return type.getValueString();
        }
        return "(unknown)";
    }

    public TypeConstant[] getTypes() {
        TypeConstant[] typeConstantArray;
        Object object = this.m_oType;
        if (object instanceof TypeConstant[]) {
            TypeConstant[] aTypes = (TypeConstant[])object;
            typeConstantArray = aTypes;
        } else {
            TypeConstant[] typeConstantArray2 = new TypeConstant[1];
            typeConstantArray = typeConstantArray2;
            typeConstantArray2[0] = this.getType();
        }
        return typeConstantArray;
    }

    public ExprAST getExprAST(Context ctx) {
        assert (this.isValidated());
        throw new UnsupportedOperationException("BAST for Expression: " + this.getClass().getSimpleName());
    }

    public boolean isTraceworthy() {
        assert (this.isValidated());
        return false;
    }

    public TraceExpression requireTrace() {
        if (!this.isValidated() || !this.isTraceworthy()) {
            throw new IllegalStateException("expr=" + String.valueOf(this));
        }
        AstNode parent = this.getParent();
        TraceExpression exprTrace = new TraceExpression(this);
        parent.replaceChild(this, exprTrace);
        this.setParent(exprTrace);
        return exprTrace;
    }

    public boolean isAssignable(Context ctx) {
        return false;
    }

    public void requireAssignable(Context ctx, ErrorListener errs) {
        if (!this.isAssignable(ctx)) {
            this.log(errs, Severity.ERROR, "COMPILER-70", new Object[0]);
        }
    }

    public void markAssignment(Context ctx, boolean fCond, ErrorListener errs) {
    }

    protected boolean isRValue() {
        return this.getParent().isRValue(this);
    }

    public boolean isShortCircuiting() {
        return false;
    }

    @Override
    protected boolean allowsShortCircuit(AstNode nodeChild) {
        return this.getParent().allowsShortCircuit(this);
    }

    @Override
    protected Label ensureShortCircuitLabel(AstNode nodeOrigin, Context ctxOrigin) {
        return this.getParent().ensureShortCircuitLabel(nodeOrigin, ctxOrigin);
    }

    public boolean isNonBinding() {
        return false;
    }

    public boolean isConstant() {
        return this.m_oConst != null;
    }

    public boolean isRuntimeConstant() {
        return this.isConstant();
    }

    public boolean hasSideEffects() {
        return !this.isConstant();
    }

    protected SideEffect mightAffect(Expression exprLeft, Argument arg) {
        if (this.isConstant() || exprLeft.isConstant()) {
            return SideEffect.DefNo;
        }
        if (arg instanceof PropertyConstant) {
            return SideEffect.AnyCompute;
        }
        return SideEffect.Unknown;
    }

    public boolean supportsCompactInit(VariableDeclarationStatement lvalue) {
        return this.isConstant();
    }

    public Constant toConstant() {
        if (!this.isConstant()) {
            return null;
        }
        Object object = this.m_oConst;
        if (object instanceof Constant) {
            Constant constant = (Constant)object;
            return constant;
        }
        return ((Constant[])this.m_oConst)[0];
    }

    public Constant[] toConstants() {
        Constant[] constantArray;
        if (!this.isConstant()) {
            return null;
        }
        Object object = this.m_oConst;
        if (object instanceof Constant[]) {
            Constant[] aConst = (Constant[])object;
            constantArray = aConst;
        } else {
            Constant[] constantArray2 = new Constant[1];
            constantArray = constantArray2;
            constantArray2[0] = this.toConstant();
        }
        return constantArray;
    }

    public void generateVoid(Context ctx, MethodStructure.Code code, ErrorListener errs) {
        if (this.hasSideEffects()) {
            if (this.isSingle() && this.hasSingleValueImpl()) {
                this.generateAssignment(ctx, code, new Assignable(), errs);
            } else {
                Object[] asnVoid = new Assignable[this.getValueCount()];
                Arrays.fill(asnVoid, new Assignable());
                this.generateAssignments(ctx, code, (Assignable[])asnVoid, errs);
            }
        }
    }

    public void generateCompactInit(Context ctx, MethodStructure.Code code, VariableDeclarationStatement lvalue, ErrorListener errs) {
        assert (this.supportsCompactInit(lvalue));
        StringConstant idName = this.pool().ensureStringConstant(lvalue.getName());
        code.add(new Var_IN(lvalue.getRegister(), idName, this.toConstant()));
    }

    public Argument generateArgument(Context ctx, MethodStructure.Code code, boolean fLocalPropOk, boolean fUsedOnce, ErrorListener errs) {
        assert (!this.isVoid());
        if (this.isConstant()) {
            return this.toConstant();
        }
        if (!(!this.hasMultiValueImpl() || this.hasSingleValueImpl() && this.isSingle())) {
            return this.generateArguments(ctx, code, fLocalPropOk, fUsedOnce, errs)[0];
        }
        if (this.hasSingleValueImpl() && !this.isVoid()) {
            Assignable var = this.createTempVar(code, this.getType(), fUsedOnce);
            this.generateAssignment(ctx, code, var, errs);
            return var.getRegister();
        }
        throw this.notImplemented();
    }

    public Argument[] generateArguments(Context ctx, MethodStructure.Code code, boolean fLocalPropOk, boolean fUsedOnce, ErrorListener errs) {
        if (this.isConstant()) {
            return this.toConstants();
        }
        if (this.isVoid()) {
            this.generateAssignments(ctx, code, NO_LVALUES, errs);
            return NO_RVALUES;
        }
        if (this.hasSingleValueImpl() && this.isSingle()) {
            return new Argument[]{this.generateArgument(ctx, code, fLocalPropOk, fUsedOnce, errs)};
        }
        TypeConstant[] aTypes = this.getTypes();
        int cTypes = aTypes.length;
        Assignable[] aLVals = new Assignable[cTypes];
        aLVals[0] = this.createTempVar(code, aTypes[0], fUsedOnce);
        for (int i = 1; i < cTypes; ++i) {
            aLVals[i] = this.createTempVar(code, aTypes[i], false);
        }
        this.generateAssignments(ctx, code, aLVals, errs);
        Argument[] aRegs = new Register[cTypes];
        for (int i = 0; i < cTypes; ++i) {
            aRegs[i] = aLVals[i].getRegister();
        }
        return aRegs;
    }

    public void generateAssignment(Context ctx, MethodStructure.Code code, Assignable LVal, ErrorListener errs) {
        if (this.hasSingleValueImpl()) {
            Argument arg = this.generateArgument(ctx, code, LVal.supportsLocalPropMode(), true, errs);
            LVal.assign(arg, code, errs);
            return;
        }
        if (this.hasMultiValueImpl()) {
            this.generateAssignments(ctx, code, new Assignable[]{LVal}, errs);
            return;
        }
        throw this.notImplemented();
    }

    public void generateAssignments(Context ctx, MethodStructure.Code code, Assignable[] aLVal, ErrorListener errs) {
        int cLVals = aLVal.length;
        int cRVals = this.getValueCount();
        boolean fCond = this.isConditionalResult();
        if (this.isCompletable()) {
            int cRValsActual;
            int n = cRValsActual = fCond ? cRVals + 1 : cRVals;
            if (cLVals > cRValsActual) {
                this.log(errs, Severity.ERROR, "COMPILER-44", cLVals, cRValsActual);
                return;
            }
        }
        if (cLVals < cRVals) {
            Object[] aLValNew = new Assignable[cRVals];
            Arrays.fill(aLValNew, new Assignable());
            System.arraycopy(aLVal, 0, aLValNew, 0, cLVals);
            aLVal = aLValNew;
            cLVals = cRVals;
        }
        if (!this.isInAssignment()) {
            switch (cLVals) {
                case 2: {
                    if (!fCond || cRVals != 1) break;
                }
                case 1: {
                    if (!this.hasSingleValueImpl()) break;
                    this.markInAssignment();
                    this.generateAssignment(ctx, code, aLVal[0], errs);
                    this.clearInAssignment();
                    return;
                }
                case 0: {
                    this.markInAssignment();
                    this.generateVoid(ctx, code, errs);
                    this.clearInAssignment();
                    return;
                }
            }
        }
        if (this.hasMultiValueImpl()) {
            boolean fLocalPropOk = true;
            for (int i = 0; i < cLVals; ++i) {
                fLocalPropOk &= aLVal[i].supportsLocalPropMode();
            }
            boolean fCheckArg0 = fCond && cLVals > 1;
            Argument[] aArg = this.generateArguments(ctx, code, fLocalPropOk, !fCheckArg0, errs);
            if (fCheckArg0) {
                Argument argCond = aArg[0];
                assert (!argCond.isStack());
                ((Assignable)aLVal[0]).assign(argCond, code, errs);
                Label label = new Label("skip_assign");
                code.add(new JumpFalse(argCond, label));
                for (int i = 1; i < cLVals; ++i) {
                    ((Assignable)aLVal[i]).assign(aArg[i], code, errs);
                }
                code.add(label);
            } else {
                for (int i = 0; i < cLVals; ++i) {
                    ((Assignable)aLVal[i]).assign(aArg[i], code, errs);
                }
            }
            return;
        }
        throw this.notImplemented();
    }

    public void generateConditionalJump(Context ctx, MethodStructure.Code code, Label label, boolean fWhenTrue, ErrorListener errs) {
        assert (!this.isVoid() && this.getType().isA(this.pool().typeBoolean()));
        if (this.isConstant()) {
            if (fWhenTrue == this.toConstant().equals(this.pool().valTrue())) {
                code.add(new Jump(label));
            }
            return;
        }
        Argument arg = this.generateArgument(ctx, code, true, true, errs);
        code.add(fWhenTrue ? new JumpTrue(arg, label) : new JumpFalse(arg, label));
    }

    protected Assignable createTempVar(MethodStructure.Code code, TypeConstant type, boolean fUsedOnce) {
        Register reg;
        if (fUsedOnce) {
            reg = new Register(type, null, -1);
        } else {
            reg = code.createRegister(type);
            code.add(new Var(reg));
        }
        return new Assignable(reg);
    }

    public Assignable generateAssignable(Context ctx, MethodStructure.Code code, ErrorListener errs) {
        if (!this.isAssignable(ctx) || this.isVoid()) {
            throw new IllegalStateException();
        }
        if (this.hasMultiValueImpl()) {
            return this.generateAssignables(ctx, code, errs)[0];
        }
        throw this.notImplemented();
    }

    public Assignable[] generateAssignables(Context ctx, MethodStructure.Code code, ErrorListener errs) {
        if (this.isVoid()) {
            this.generateVoid(ctx, code, errs);
            return NO_LVALUES;
        }
        if (this.hasSingleValueImpl() && this.isSingle()) {
            return new Assignable[]{this.generateAssignable(ctx, code, errs)};
        }
        assert (this.isAssignable(ctx));
        throw this.hasMultiValueImpl() ? this.notImplemented() : new IllegalStateException();
    }

    public boolean isAssignableTo(TypeConstant typeThat) {
        TypeConstant typeImplicit = this.getType();
        return typeImplicit.isA(typeThat) || typeImplicit.ensureTypeInfo().findConversion(typeThat) != null;
    }

    public boolean isTypeBoolean() {
        return this.getType().isEcstasy("Boolean");
    }

    public boolean isConstantFalse() {
        return this.isConstant() && this.toConstant().equals(this.pool().valFalse());
    }

    public boolean isConstantTrue() {
        return this.isConstant() && this.toConstant().equals(this.pool().valTrue());
    }

    public boolean isConstantNull() {
        return this.isConstant() && this.toConstant().equals(this.pool().valNull());
    }

    protected Constant convertConstant(Constant constIn, TypeConstant typeOut) {
        TypeConstant typeIn = constIn.getType();
        if (typeIn.isA(typeOut)) {
            return constIn;
        }
        try {
            return constIn.convertTo(typeOut);
        }
        catch (ArithmeticException e) {
            return null;
        }
    }

    protected Constant convertConstant(Constant constIn, TypeConstant typeOut, ErrorListener errs) {
        TypeConstant typeIn = constIn.getType();
        if (typeIn.isA(typeOut)) {
            return constIn;
        }
        try {
            return constIn.convertTo(typeOut);
        }
        catch (ArithmeticException e) {
            this.log(errs, Severity.ERROR, "COMPILER-45", typeOut, constIn.getValueString());
            return this.generateFakeConstant(typeOut);
        }
    }

    protected Constant validateAndConvertConstant(Constant constIn, TypeConstant typeOut, ErrorListener errs) {
        Constant constOut = this.convertConstant(constIn, typeOut, errs);
        if (constOut == null) {
            this.log(errs, Severity.ERROR, "COMPILER-43", typeOut, constIn.getType());
            constOut = this.generateFakeConstant(typeOut);
        }
        return constOut;
    }

    protected TypeInfo getTypeInfo(Context ctx, TypeConstant type, ErrorListener errs) {
        if (type == null) {
            return this.pool().ensureAccessTypeConstant(ctx.getThisType(), Constants.Access.PRIVATE).ensureTypeInfo(errs);
        }
        TypeInfo info = type.ensureTypeInfo(ctx.getThisClassId(), errs);
        if (info.getType().isAccessSpecified() || !type.isAccessModifiable()) {
            return info;
        }
        return type.ensureAccess(Constants.Access.PROTECTED).ensureTypeInfo(errs);
    }

    protected Register generateBlackHole(TypeConstant type) {
        return new Register(type == null ? this.pool().typeObject() : type, null, -2);
    }

    protected Constant generateFakeConstant(TypeConstant type) {
        return Constant.defaultValue(type);
    }

    protected boolean isInAssignment() {
        return (this.m_nFlags & 0x40000000) != 0;
    }

    protected void markInAssignment() {
        assert (!this.isInAssignment());
        this.m_nFlags |= 0x40000000;
    }

    protected void clearInAssignment() {
        assert (this.isInAssignment());
        this.m_nFlags &= 0xBFFFFFFF;
    }

    protected boolean isSuppressShortCircuit() {
        return (this.m_nFlags & 0x20000000) != 0;
    }

    protected void checkShortCircuit(ErrorListener errs) {
        if (!this.isSuppressShortCircuit() && this.isShortCircuiting() && !this.getParent().allowsShortCircuit(this)) {
            this.log(errs, Severity.ERROR, "COMPILER-73", new Object[0]);
            this.m_nFlags |= 0x20000000;
        }
    }

    protected TypeConstant[] selectCommonTypes(TypeConstant[] atypeThen, TypeConstant[] atypeElse) {
        int cTypes = Math.min(atypeThen.length, atypeElse.length);
        TypeConstant[] atypeCommon = new TypeConstant[cTypes];
        for (int i = 0; i < cTypes; ++i) {
            TypeConstant typeThen = atypeThen[i];
            TypeConstant typeElse = atypeElse[i];
            ConstantPool pool = this.pool();
            TypeConstant typeCommon = Op.selectCommonType(typeThen, typeElse, ErrorListener.BLACKHOLE);
            atypeCommon[i] = typeCommon == null && typeThen != null && typeElse != null ? (typeThen.isOnlyNullable() ? pool.ensureNullableTypeConstant(typeElse) : (typeElse.isOnlyNullable() ? pool.ensureNullableTypeConstant(typeThen) : pool.ensureUnionTypeConstant(typeThen, typeElse))) : typeCommon;
        }
        return atypeCommon;
    }

    protected Argument ensurePointInTime(MethodStructure.Code code, Argument arg, List<Expression> listExprs, int iExpr) {
        int cExprs = listExprs.size();
        if (iExpr < cExprs - 1 && !arg.isEffectivelyFinal()) {
            for (int iRight = iExpr + 1; iRight < cExprs; ++iRight) {
                if (listExprs.get(iRight).mightAffect(this, arg) != SideEffect.DefYes) continue;
                return this.ensurePointInTime(code, arg);
            }
        }
        return arg;
    }

    protected Argument ensurePointInTime(MethodStructure.Code code, Argument arg, Expression exprRight) {
        return !arg.isEffectivelyFinal() && exprRight.mightAffect(this, arg) == SideEffect.DefYes ? this.ensurePointInTime(code, arg) : arg;
    }

    private Argument ensurePointInTime(MethodStructure.Code code, Argument arg) {
        Register reg;
        if (arg instanceof PropertyConstant || arg instanceof Register && (!(reg = (Register)arg).isVar() || !reg.ensureRegType(true).isA(this.pool().clzFuture().getType()))) {
            Register regTemp = code.createRegister(arg.getType());
            regTemp.markEffectivelyFinal();
            code.add(new Var_I(regTemp, arg));
            arg = regTemp;
        }
        return arg;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void reportTypeMismatch(TypeConstant typeRequired, TypeConstant typeActual, ErrorListener errs) {
        Expression expression = this;
        if (expression instanceof LiteralExpression) {
            LiteralExpression lit = (LiteralExpression)expression;
            if (typeRequired.isA(this.pool().typeFileNode()) && lit.getLiteral().getId() == Token.Id.LIT_PATH) {
                this.log(errs, Severity.ERROR, "COMPILER-199", new Object[0]);
                return;
            }
        }
        this.log(errs, Severity.ERROR, "COMPILER-43", typeRequired.getValueString(), typeActual.getValueString());
    }

    public static enum TypeFit {
        NoFit(0),
        ConvPackUnpack(15),
        ConvPack(11),
        ConvUnpack(7),
        Conv(3),
        PackUnpack(13),
        Pack(5),
        Unpack(9),
        Fit(1);

        private static final TypeFit[] BY_ORDINAL;
        private static final TypeFit[] BY_FLAGS;
        public static final int FITS = 1;
        public static final int CONVERTS = 2;
        public static final int PACKS = 4;
        public static final int UNPACKS = 8;
        public final int FLAGS;

        private TypeFit(int nFlags) {
            this.FLAGS = nFlags;
        }

        public boolean isFit() {
            return (this.FLAGS & 1) != 0;
        }

        public TypeFit ensureFit() {
            return this.isFit() ? this : Fit;
        }

        public boolean isConverting() {
            return (this.FLAGS & 2) != 0;
        }

        public TypeFit addConversion() {
            return this.isFit() ? TypeFit.forFlags(this.FLAGS | 2) : NoFit;
        }

        public TypeFit removeConversion() {
            return this.isConverting() ? TypeFit.forFlags(this.FLAGS & 0xFFFFFFFD) : this;
        }

        public boolean isPacking() {
            return (this.FLAGS & 4) != 0;
        }

        public TypeFit addPack() {
            return this.isFit() ? TypeFit.forFlags(this.FLAGS | 4) : NoFit;
        }

        public TypeFit removePack() {
            return this.isPacking() ? TypeFit.forFlags(this.FLAGS & 0xFFFFFFFB) : this;
        }

        public boolean isUnpacking() {
            return (this.FLAGS & 8) != 0;
        }

        public TypeFit addUnpack() {
            return this.isFit() ? TypeFit.forFlags(this.FLAGS | 8) : NoFit;
        }

        public TypeFit removeUnpack() {
            return this.isConverting() ? TypeFit.forFlags(this.FLAGS & 0xFFFFFFF7) : this;
        }

        public TypeFit combineWith(TypeFit that) {
            return this.isFit() && that.isFit() ? TypeFit.forFlags(this.FLAGS | that.FLAGS) : NoFit;
        }

        public TypeFit betterOf(TypeFit that) {
            return this.ordinal() > that.ordinal() ? this : that;
        }

        public boolean betterThan(TypeFit that) {
            return this.ordinal() > that.ordinal();
        }

        public boolean worseThan(TypeFit that) {
            return this.ordinal() < that.ordinal();
        }

        public static TypeFit valueOf(int i) {
            return BY_ORDINAL[i];
        }

        public static TypeFit forFlags(int nFlags) {
            TypeFit fit;
            if (nFlags >= 0 && nFlags <= BY_FLAGS.length && (fit = BY_FLAGS[nFlags]) != null) {
                return fit;
            }
            throw new IllegalStateException("no fit for flag value: " + nFlags);
        }

        static {
            BY_ORDINAL = TypeFit.values();
            BY_FLAGS = new TypeFit[16];
            TypeFit[] typeFitArray = BY_ORDINAL;
            int n = typeFitArray.length;
            for (int i = 0; i < n; ++i) {
                TypeFit fit;
                TypeFit.BY_FLAGS[fit.FLAGS] = fit = typeFitArray[i];
            }
        }
    }

    public static enum SideEffect {
        DefNo,
        Unknown,
        AnyCompute,
        AnySeqOp,
        DefYes;

    }

    public class Assignable {
        private final AssignForm m_form;
        private Argument m_arg;
        private PropertyConstant m_prop;
        private Object m_oIndex;

        public Assignable() {
            this.m_form = AssignForm.BlackHole;
        }

        public Assignable(Register regVar) {
            this.m_form = AssignForm.LocalVar;
            this.m_arg = regVar;
        }

        public Assignable(Argument argTarget, PropertyConstant constProp) {
            if (argTarget instanceof Register) {
                Register reg = (Register)argTarget;
                if (reg.isPredefined()) {
                    switch (((Register)argTarget).getIndex()) {
                        case -10: 
                        case -6: 
                        case -5: {
                            this.m_form = AssignForm.LocalProp;
                            break;
                        }
                        default: {
                            this.m_form = AssignForm.TargetProp;
                            break;
                        }
                    }
                } else {
                    this.m_form = AssignForm.TargetProp;
                }
            } else {
                this.m_form = AssignForm.TargetProp;
            }
            this.m_arg = argTarget;
            this.m_prop = constProp;
        }

        public Assignable(Argument argArray, Argument index) {
            this.m_form = AssignForm.Indexed;
            this.m_arg = argArray;
            this.m_oIndex = index;
        }

        public Assignable(Argument regArray, Argument[] indexes) {
            assert (indexes != null && indexes.length > 0);
            this.m_form = indexes.length == 1 ? AssignForm.Indexed : AssignForm.IndexedN;
            this.m_arg = regArray;
            this.m_oIndex = indexes.length == 1 ? indexes[0] : indexes;
        }

        public Assignable(PropertyConstant constProp, Argument index) {
            this.m_form = AssignForm.IndexedProp;
            this.m_prop = constProp;
            this.m_oIndex = index;
        }

        public Assignable(PropertyConstant constProp, Argument[] indexes) {
            assert (indexes != null && indexes.length > 0);
            this.m_form = indexes.length == 1 ? AssignForm.IndexedProp : AssignForm.IndexedNProp;
            this.m_prop = constProp;
            this.m_oIndex = indexes.length == 1 ? indexes[0] : indexes;
        }

        public TypeConstant getType() {
            return switch (this.m_form.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> Expression.this.pool().typeObject();
                case 1 -> this.getRegister().getType();
                case 2, 3 -> this.getProperty().getType();
                case 4, 5 -> this.getArray().getType();
                case 6, 7 -> throw Expression.this.notImplemented();
            };
        }

        public AssignForm getForm() {
            return this.m_form;
        }

        public boolean isBlackhole() {
            return this.m_form == AssignForm.BlackHole;
        }

        public Register getRegister() {
            if (this.m_form != AssignForm.LocalVar) {
                throw new IllegalStateException();
            }
            return (Register)this.m_arg;
        }

        public boolean isNormalVariable() {
            return this.m_form == AssignForm.LocalVar && ((Register)this.m_arg).isNormal();
        }

        public boolean isStack() {
            return this.m_form == AssignForm.LocalVar && this.m_arg.isStack();
        }

        public boolean isLocalArgument() {
            return switch (this.m_form.ordinal()) {
                case 0, 1, 2 -> true;
                default -> false;
            };
        }

        public boolean isProperty() {
            return switch (this.m_form.ordinal()) {
                case 2, 3 -> true;
                default -> false;
            };
        }

        public Argument getLocalArgument() {
            return switch (this.m_form.ordinal()) {
                case 0 -> Expression.this.generateBlackHole(null);
                case 1 -> this.getRegister();
                case 2 -> this.getProperty();
                default -> throw new IllegalStateException();
            };
        }

        public Argument getTarget() {
            if (this.m_form != AssignForm.LocalProp && this.m_form != AssignForm.TargetProp) {
                throw new IllegalStateException();
            }
            return this.m_arg;
        }

        public PropertyConstant getProperty() {
            if (this.m_form != AssignForm.LocalProp && this.m_form != AssignForm.TargetProp && this.m_form != AssignForm.IndexedProp && this.m_form != AssignForm.IndexedNProp) {
                throw new IllegalStateException();
            }
            return this.m_prop;
        }

        public Argument getArray() {
            if (this.m_form != AssignForm.Indexed && this.m_form != AssignForm.IndexedN) {
                throw new IllegalStateException();
            }
            return this.m_arg;
        }

        public Argument getIndex() {
            if (this.m_form == AssignForm.Indexed || this.m_form == AssignForm.IndexedProp) {
                return (Argument)this.m_oIndex;
            }
            throw new IllegalStateException();
        }

        public Argument[] getIndexes() {
            if (this.m_form == AssignForm.Indexed || this.m_form == AssignForm.IndexedProp) {
                return new Argument[]{(Argument)this.m_oIndex};
            }
            if (this.m_form == AssignForm.IndexedN || this.m_form == AssignForm.IndexedNProp) {
                return (Argument[])this.m_oIndex;
            }
            throw new IllegalStateException();
        }

        public boolean supportsLocalPropMode() {
            return true;
        }

        public Argument getValue(Assignable LValResult, boolean fLocalPropOk, boolean fUsedOnce, MethodStructure.Code code, ErrorListener errs) {
            switch (this.m_form.ordinal()) {
                case 0: {
                    throw new IllegalStateException();
                }
                case 1: {
                    if (LValResult == null) {
                        return this.getRegister();
                    }
                    LValResult.assign(this.getRegister(), code, errs);
                    return null;
                }
                case 2: {
                    if (LValResult == null && fLocalPropOk) {
                        return this.getProperty();
                    }
                }
                case 3: {
                    Assignable LValTemp = LValResult == null || !LValResult.isLocalArgument() ? Expression.this.createTempVar(code, this.getType(), fUsedOnce) : LValResult;
                    code.add(new P_Get(this.getProperty(), this.getTarget(), LValTemp.getLocalArgument()));
                    if (LValResult == null) {
                        return LValTemp.getLocalArgument();
                    }
                    if (LValResult != LValTemp) {
                        LValResult.assign(LValTemp.getLocalArgument(), code, errs);
                    }
                    return null;
                }
                case 4: 
                case 6: {
                    Assignable LValTemp = LValResult == null || !LValResult.isLocalArgument() ? Expression.this.createTempVar(code, this.getType(), fUsedOnce) : LValResult;
                    Argument argTarget = this.m_form == AssignForm.Indexed ? this.getArray() : this.getProperty();
                    code.add(new I_Get(argTarget, this.getIndex(), LValTemp.getLocalArgument()));
                    if (LValResult == null) {
                        return LValTemp.getLocalArgument();
                    }
                    if (LValResult != LValTemp) {
                        LValResult.assign(LValTemp.getLocalArgument(), code, errs);
                    }
                    return null;
                }
                case 5: 
                case 7: {
                    throw Expression.this.notImplemented();
                }
            }
            throw new IllegalStateException();
        }

        public Argument generateArgument(Context ctx, MethodStructure.Code code, boolean fLocalPropOk, boolean fUsedOnce, ErrorListener errs) {
            switch (this.m_form.ordinal()) {
                case 1: {
                    return this.getRegister();
                }
                case 2: {
                    if (fLocalPropOk) {
                        return this.getProperty();
                    }
                    if (fUsedOnce) {
                        Register reg = new Register(this.getType(), null, -1);
                        code.add(new L_Get(this.getProperty(), reg));
                        return reg;
                    }
                    Register reg = code.createRegister(this.getType());
                    code.add(new Var_I(reg, this.getProperty()));
                    return reg;
                }
                case 3: {
                    Register reg;
                    if (fUsedOnce) {
                        reg = new Register(this.getType(), null, -1);
                    } else {
                        reg = code.createRegister(this.getType());
                        code.add(new Var(reg));
                    }
                    code.add(new P_Get(this.getProperty(), this.getTarget(), reg));
                    return reg;
                }
                case 4: {
                    Register reg;
                    if (fUsedOnce) {
                        reg = new Register(this.getType(), null, -1);
                    } else {
                        reg = code.createRegister(this.getType());
                        code.add(new Var(reg));
                    }
                    code.add(new I_Get(this.getArray(), this.getIndex(), reg));
                    return reg;
                }
                case 5: 
                case 6: 
                case 7: {
                    throw Expression.this.notImplemented();
                }
            }
            throw new IllegalStateException("form=" + String.valueOf((Object)this.m_form));
        }

        public void assign(Argument arg, MethodStructure.Code code, ErrorListener errs) {
            switch (this.m_form.ordinal()) {
                case 0: {
                    break;
                }
                case 1: {
                    code.add(new Move(arg, this.getRegister()));
                    break;
                }
                case 2: {
                    code.add(new L_Set(this.getProperty(), arg));
                    break;
                }
                case 3: {
                    code.add(new P_Set(this.getProperty(), this.getTarget(), arg));
                    break;
                }
                case 4: {
                    code.add(new I_Set(this.getArray(), this.getIndex(), arg));
                    break;
                }
                case 6: {
                    code.add(new I_Set(this.getProperty(), this.getIndex(), arg));
                    break;
                }
                case 5: 
                case 7: {
                    throw Expression.this.notImplemented();
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }

        public Argument assignSequential(Sequential seq, Assignable LValResult, boolean fUsedOnce, MethodStructure.Code code, ErrorListener errs) {
            assert (!seq.isBlind() || LValResult == null);
            if (LValResult != null && LValResult.isBlackhole()) {
                seq = seq.toBlind();
                LValResult = null;
            }
            switch (this.m_form.ordinal()) {
                case 1: 
                case 2: {
                    Argument argTarget = this.getLocalArgument();
                    switch (seq.ordinal()) {
                        case 0: {
                            code.add(new IP_Inc(argTarget));
                            return null;
                        }
                        case 3: {
                            code.add(new IP_Dec(argTarget));
                            return null;
                        }
                        case 1: 
                        case 4: {
                            if (LValResult != null && LValResult.isLocalArgument()) {
                                code.add(seq.isInc() ? new IP_PreInc(argTarget, LValResult.getLocalArgument()) : new IP_PreDec(argTarget, LValResult.getLocalArgument()));
                                return null;
                            }
                            Register regResult = code.createRegister(argTarget.getType(), fUsedOnce);
                            code.add(seq.isInc() ? new IP_PreInc(argTarget, regResult) : new IP_PreDec(argTarget, regResult));
                            if (LValResult == null) {
                                return regResult;
                            }
                            LValResult.assign(regResult, code, errs);
                            return null;
                        }
                        case 2: 
                        case 5: {
                            Assignable LValTemp = LValResult != null && LValResult.isLocalArgument() ? LValResult : Expression.this.createTempVar(code, this.getType(), fUsedOnce);
                            code.add(seq.isInc() ? new IP_PostInc(argTarget, LValTemp.getLocalArgument()) : new IP_PostDec(argTarget, LValTemp.getLocalArgument()));
                            if (LValResult == null) {
                                return LValTemp.getRegister();
                            }
                            if (LValResult != LValTemp) {
                                LValResult.assign(LValTemp.getRegister(), code, errs);
                            }
                            return null;
                        }
                    }
                    break;
                }
                case 3: {
                    PropertyConstant prop = this.getProperty();
                    Argument argTarget = this.getTarget();
                    if (seq.isBlind()) {
                        code.add(seq.isInc() ? new PIP_Inc(prop, argTarget) : new PIP_Dec(prop, argTarget));
                    } else {
                        Assignable LValTemp = LValResult != null && LValResult.isLocalArgument() ? LValResult : Expression.this.createTempVar(code, this.getType(), fUsedOnce);
                        Argument argReturn = LValTemp.getLocalArgument();
                        code.add(seq.isPre() ? (seq.isInc() ? new PIP_PreInc(prop, argTarget, argReturn) : new PIP_PreDec(prop, argTarget, argReturn)) : (seq.isInc() ? new PIP_PostInc(prop, argTarget, argReturn) : new PIP_PostDec(prop, argTarget, argReturn)));
                        if (LValResult == null) {
                            return argReturn;
                        }
                        if (LValResult != LValTemp) {
                            LValResult.assign(argReturn, code, errs);
                        }
                    }
                    return null;
                }
                case 4: 
                case 6: {
                    Argument argArray = this.m_form == AssignForm.Indexed ? this.getArray() : this.getProperty();
                    Argument argIndex = this.getIndex();
                    if (seq.isBlind()) {
                        code.add(seq.isInc() ? new IIP_Inc(argArray, argIndex) : new IIP_Dec(argArray, argIndex));
                    } else {
                        Assignable LValTemp = LValResult != null && LValResult.isLocalArgument() ? LValResult : Expression.this.createTempVar(code, this.getType().resolveGenericType("Element"), fUsedOnce);
                        Argument argReturn = LValTemp.getLocalArgument();
                        code.add(seq.isPre() ? (seq.isInc() ? new IIP_PreInc(argArray, argIndex, argReturn) : new IIP_PreDec(argArray, argIndex, argReturn)) : (seq.isInc() ? new IIP_PostInc(argArray, argIndex, argReturn) : new IIP_PostDec(argArray, argIndex, argReturn)));
                        if (LValResult == null) {
                            return argReturn;
                        }
                        if (LValResult != LValTemp) {
                            LValResult.assign(argReturn, code, errs);
                        }
                    }
                    return null;
                }
                case 5: 
                case 7: {
                    throw Expression.this.notImplemented();
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            switch (seq.ordinal()) {
                case 0: 
                case 3: {
                    Assignable LValTemp = Expression.this.createTempVar(code, this.getType(), false);
                    this.getValue(LValTemp, false, false, code, errs);
                    LValTemp.assignSequential(seq, null, false, code, errs);
                    this.assign(LValTemp.getRegister(), code, errs);
                    return null;
                }
                case 1: 
                case 4: {
                    Assignable LValTemp = LValResult != null && LValResult.isNormalVariable() ? LValResult : Expression.this.createTempVar(code, this.getType(), false);
                    this.getValue(LValTemp, false, false, code, errs);
                    Sequential seqVoid = seq.isInc() ? Sequential.Inc : Sequential.Dec;
                    LValTemp.assignSequential(seqVoid, null, false, code, errs);
                    this.assign(LValTemp.getRegister(), code, errs);
                    if (LValResult == null) {
                        return LValTemp.getRegister();
                    }
                    if (LValResult != LValTemp) {
                        LValResult.assign(LValTemp.getRegister(), code, errs);
                    }
                    return null;
                }
                case 2: 
                case 5: {
                    Assignable LValTemp = Expression.this.createTempVar(code, this.getType(), false);
                    Register argResult = null;
                    if (LValResult == null) {
                        LValResult = Expression.this.createTempVar(code, this.getType(), fUsedOnce);
                        argResult = LValResult.getRegister();
                    }
                    this.getValue(LValTemp, false, false, code, errs);
                    LValResult.assign(LValTemp.getRegister(), code, errs);
                    Sequential seqVoid = seq.isInc() ? Sequential.Inc : Sequential.Dec;
                    LValTemp.assignSequential(seqVoid, null, false, code, errs);
                    this.assign(LValTemp.getRegister(), code, errs);
                    return argResult;
                }
            }
            throw new IllegalStateException();
        }

        public void assignInPlaceResult(Token tokOp, Argument arg, MethodStructure.Code code, ErrorListener errs) {
            code.add(switch (this.m_form.ordinal()) {
                case 1, 2 -> {
                    Argument argTarget = this.getLocalArgument();
                    OpInPlaceAssign v0 = switch (tokOp.getId()) {
                        case Token.Id.ADD_ASN -> new IP_Add(argTarget, arg);
                        case Token.Id.SUB_ASN -> new IP_Sub(argTarget, arg);
                        case Token.Id.MUL_ASN -> new IP_Mul(argTarget, arg);
                        case Token.Id.DIV_ASN -> new IP_Div(argTarget, arg);
                        case Token.Id.MOD_ASN -> new IP_Mod(argTarget, arg);
                        case Token.Id.SHL_ASN -> new IP_Shl(argTarget, arg);
                        case Token.Id.SHR_ASN -> new IP_Shr(argTarget, arg);
                        case Token.Id.USHR_ASN -> new IP_ShrAll(argTarget, arg);
                        case Token.Id.BIT_AND_ASN -> new IP_And(argTarget, arg);
                        case Token.Id.BIT_OR_ASN -> new IP_Or(argTarget, arg);
                        case Token.Id.BIT_XOR_ASN -> new IP_Xor(argTarget, arg);
                        default -> throw new IllegalStateException("op=" + tokOp.getId().TEXT);
                    };
                    yield v0;
                }
                case 3 -> {
                    PropertyConstant prop = this.getProperty();
                    Argument argTarget = this.getTarget();
                    OpPropInPlaceAssign v1 = switch (tokOp.getId()) {
                        case Token.Id.ADD_ASN -> new PIP_Add(prop, argTarget, arg);
                        case Token.Id.SUB_ASN -> new PIP_Sub(prop, argTarget, arg);
                        case Token.Id.MUL_ASN -> new PIP_Mul(prop, argTarget, arg);
                        case Token.Id.DIV_ASN -> new PIP_Div(prop, argTarget, arg);
                        case Token.Id.MOD_ASN -> new PIP_Mod(prop, argTarget, arg);
                        case Token.Id.SHL_ASN -> new PIP_Shl(prop, argTarget, arg);
                        case Token.Id.SHR_ASN -> new PIP_Shr(prop, argTarget, arg);
                        case Token.Id.USHR_ASN -> new PIP_ShrAll(prop, argTarget, arg);
                        case Token.Id.BIT_AND_ASN -> new PIP_And(prop, argTarget, arg);
                        case Token.Id.BIT_OR_ASN -> new PIP_Or(prop, argTarget, arg);
                        case Token.Id.BIT_XOR_ASN -> new PIP_Xor(prop, argTarget, arg);
                        default -> throw new IllegalStateException("op=" + tokOp.getId().TEXT);
                    };
                    yield v1;
                }
                case 4, 6 -> {
                    Argument argArray = this.m_form == AssignForm.Indexed ? this.getArray() : this.getProperty();
                    Argument argIndex = this.getIndex();
                    OpIndexInPlace v2 = switch (tokOp.getId()) {
                        case Token.Id.ADD_ASN -> new IIP_Add(argArray, argIndex, arg);
                        case Token.Id.SUB_ASN -> new IIP_Sub(argArray, argIndex, arg);
                        case Token.Id.MUL_ASN -> new IIP_Mul(argArray, argIndex, arg);
                        case Token.Id.DIV_ASN -> new IIP_Div(argArray, argIndex, arg);
                        case Token.Id.MOD_ASN -> new IIP_Mod(argArray, argIndex, arg);
                        case Token.Id.SHL_ASN -> new IIP_Shl(argArray, argIndex, arg);
                        case Token.Id.SHR_ASN -> new IIP_Shr(argArray, argIndex, arg);
                        case Token.Id.USHR_ASN -> new IIP_ShrAll(argArray, argIndex, arg);
                        case Token.Id.BIT_AND_ASN -> new IIP_And(argArray, argIndex, arg);
                        case Token.Id.BIT_OR_ASN -> new IIP_Or(argArray, argIndex, arg);
                        case Token.Id.BIT_XOR_ASN -> new IIP_Xor(argArray, argIndex, arg);
                        default -> throw new IllegalStateException("op=" + tokOp.getId().TEXT);
                    };
                    yield v2;
                }
                case 5, 7 -> throw Expression.this.notImplemented();
                default -> throw new IllegalStateException();
            });
        }
    }

    public static enum Sequential {
        Inc,
        PreInc,
        PostInc,
        Dec,
        PreDec,
        PostDec;


        public boolean isInc() {
            return this.compareTo(PostInc) <= 0;
        }

        public boolean isBlind() {
            return this == Inc | this == Dec;
        }

        public Sequential toBlind() {
            return this.isInc() ? Inc : Dec;
        }

        public boolean isPre() {
            return this == PreInc | this == PreDec;
        }

        public boolean isPost() {
            return this == PostInc | this == PostDec;
        }
    }

    public static enum AssignForm {
        BlackHole,
        LocalVar,
        LocalProp,
        TargetProp,
        Indexed,
        IndexedN,
        IndexedProp,
        IndexedNProp;

    }
}

