/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.compiler.ast;

import java.lang.reflect.Field;
import org.xvm.asm.ErrorListener;
import org.xvm.asm.MethodStructure;
import org.xvm.compiler.ast.AstNode;
import org.xvm.compiler.ast.Context;
import org.xvm.compiler.ast.Expression;
import org.xvm.compiler.ast.Statement;
import org.xvm.util.Severity;

public class ExpressionStatement
extends Statement {
    protected Expression expr;
    protected boolean term;
    private static final Field[] CHILD_FIELDS = ExpressionStatement.fieldsForNames(ExpressionStatement.class, "expr");

    public ExpressionStatement(Expression expr) {
        this(expr, true);
    }

    public ExpressionStatement(Expression expr, boolean standalone) {
        this.expr = expr;
        this.term = standalone;
    }

    public Expression getExpression() {
        return this.expr;
    }

    @Override
    public long getStartPosition() {
        return this.expr.getStartPosition();
    }

    @Override
    public long getEndPosition() {
        return this.expr.getEndPosition();
    }

    @Override
    protected Field[] getChildFields() {
        return CHILD_FIELDS;
    }

    @Override
    public boolean isCompletable() {
        return this.expr.isCompletable();
    }

    @Override
    public boolean isTodo() {
        return this.expr.isTodo();
    }

    @Override
    protected Statement validateImpl(Context ctx, ErrorListener errs) {
        boolean fValid = true;
        Expression exprNew = this.expr.validate(ctx, null, errs);
        if (exprNew != this.expr) {
            fValid &= exprNew != null;
            if (exprNew != null) {
                this.expr = exprNew;
            }
        }
        if (fValid && !this.expr.isStandalone()) {
            this.log(errs, Severity.ERROR, "COMPILER-180", new Object[0]);
            fValid = false;
        }
        return fValid ? this : null;
    }

    @Override
    protected boolean emit(Context ctx, boolean fReachable, MethodStructure.Code code, ErrorListener errs) {
        boolean fCompletes = fReachable & this.expr.isCompletable();
        this.expr.generateAssignments(ctx, code, Expression.NO_LVALUES, errs);
        ctx.getHolder().setAst(this, this.expr.getExprAST(ctx));
        return fCompletes;
    }

    @Override
    protected boolean allowsShortCircuit(AstNode nodeChild) {
        return nodeChild == this.expr;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.expr);
        if (!this.term) {
            sb.append(';');
        }
        return sb.toString();
    }

    @Override
    public String getDumpDesc() {
        String s = this.toString();
        int of = s.indexOf(10);
        return of < 0 ? s : s.substring(0, of) + " ...";
    }
}

