/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.compiler.ast;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileTime;
import java.util.Set;
import org.xvm.asm.Constant;
import org.xvm.asm.ConstantPool;
import org.xvm.asm.ErrorListener;
import org.xvm.asm.ast.ExprAST;
import org.xvm.asm.constants.FSNodeConstant;
import org.xvm.asm.constants.FileStoreConstant;
import org.xvm.asm.constants.TypeConstant;
import org.xvm.asm.constants.ValueConstant;
import org.xvm.compiler.Token;
import org.xvm.compiler.ast.Context;
import org.xvm.compiler.ast.Expression;
import org.xvm.compiler.ast.TypeExpression;
import org.xvm.tool.ResourceDir;
import org.xvm.util.Handy;
import org.xvm.util.Severity;

public class FileExpression
extends Expression {
    private static final int FS = 1;
    private static final int DIR = 2;
    private static final int FILE = 4;
    private static final int PATH = 8;
    private static final int STRING = 16;
    private static final int BINARY = 32;
    private static final int ALL = 63;
    private static final int NONE = 0;
    protected TypeExpression type;
    protected Token path;
    private File m_file;
    private ResourceDir m_dir;
    private static final Field[] CHILD_FIELDS = FileExpression.fieldsForNames(FileExpression.class, "type");

    public FileExpression(TypeExpression type, Token path, Object resource) {
        this.type = type;
        this.path = path;
        if (resource instanceof File) {
            File file;
            this.m_file = file = (File)resource;
        } else if (resource instanceof ResourceDir) {
            ResourceDir dir;
            this.m_dir = dir = (ResourceDir)resource;
        }
    }

    public String getSimpleTypeName() {
        if (this.type == null) {
            return null;
        }
        String sType = this.type.toString();
        int of = sType.indexOf(60);
        return of < 0 ? sType : sType.substring(0, of);
    }

    @Override
    public long getStartPosition() {
        return this.type == null ? this.path.getStartPosition() : this.type.getStartPosition();
    }

    @Override
    public long getEndPosition() {
        return this.path.getEndPosition();
    }

    @Override
    protected Field[] getChildFields() {
        return CHILD_FIELDS;
    }

    @Override
    public TypeConstant getImplicitType(Context ctx) {
        ConstantPool pool = this.pool();
        String sType = this.getSimpleTypeName();
        if (sType == null) {
            if (this.m_dir != null) {
                return pool.typeFileStore();
            }
            if (this.m_file != null && this.m_file.exists()) {
                return this.m_file.isDirectory() ? pool.typeFileStore() : pool.typeFile();
            }
            return pool.typePath();
        }
        return switch (sType) {
            case "FileStore" -> pool.typeFileStore();
            case "Directory" -> pool.typeDirectory();
            case "File" -> pool.typeFile();
            case "Path" -> pool.typePath();
            case "String" -> pool.typeString();
            case "Array<Byte>", "Byte[]" -> pool.typeByteArray();
            default -> throw new IllegalStateException("type=" + sType);
        };
    }

    private int calcConsumes(TypeConstant typeRequired) {
        ConstantPool pool = this.pool();
        int nConsumes = 0;
        if (typeRequired == null) {
            nConsumes = 63;
        } else {
            if (pool.typeFileStore().isA(typeRequired)) {
                nConsumes |= 1;
            }
            if (pool.typeDirectory().isA(typeRequired)) {
                nConsumes |= 2;
            }
            if (pool.typeFile().isA(typeRequired)) {
                nConsumes |= 4;
            }
            if (pool.typePath().isA(typeRequired)) {
                nConsumes |= 8;
            }
            if (pool.typeString().isA(typeRequired)) {
                nConsumes |= 0x10;
            }
            if (pool.typeByteArray().isA(typeRequired)) {
                nConsumes |= 0x20;
            }
        }
        return nConsumes;
    }

    private int calcProduces() {
        String sType = this.getSimpleTypeName();
        if (sType == null) {
            if (this.m_dir != null) {
                return 11;
            }
            if (this.m_file != null && this.m_file.exists()) {
                return this.m_file.isDirectory() ? 11 : 60;
            }
            return 8;
        }
        return switch (sType) {
            case "FileStore" -> 1;
            case "Directory" -> 2;
            case "File" -> 4;
            case "Path" -> 8;
            case "String" -> 16;
            case "Array<Byte>" -> 32;
            case "Byte[]" -> 32;
            default -> throw new IllegalStateException("type=" + sType);
        };
    }

    @Override
    public Expression.TypeFit testFit(Context ctx, TypeConstant typeRequired, boolean fExhaustive, ErrorListener errs) {
        int nProduces;
        int nConsumes = this.calcConsumes(typeRequired);
        return (nConsumes & (nProduces = this.calcProduces())) == 0 ? Expression.TypeFit.NoFit : Expression.TypeFit.Fit;
    }

    @Override
    protected Expression validate(Context ctx, TypeConstant typeRequired, ErrorListener errs) {
        ConstantPool pool = this.pool();
        Expression.TypeFit fit = Expression.TypeFit.Fit;
        TypeConstant typeActual = null;
        ValueConstant constVal = null;
        int nConsumes = this.calcConsumes(typeRequired);
        int nProduces = this.calcProduces();
        try {
            switch (nConsumes & nProduces) {
                case 0: {
                    if ((nProduces & 1) != 0) {
                        typeActual = pool.typeFileStore();
                    }
                    if ((nProduces & 2) != 0) {
                        TypeConstant typeConstant = typeActual = typeActual == null ? pool.typeDirectory() : pool.ensureUnionTypeConstant(typeActual, pool.typeDirectory());
                    }
                    if ((nProduces & 4) != 0) {
                        TypeConstant typeConstant = typeActual = typeActual == null ? pool.typeFile() : pool.ensureUnionTypeConstant(typeActual, pool.typeFile());
                    }
                    if ((nProduces & 8) != 0) {
                        TypeConstant typeConstant = typeActual = typeActual == null ? pool.typePath() : pool.ensureUnionTypeConstant(typeActual, pool.typePath());
                    }
                    if ((nProduces & 0x10) != 0) {
                        TypeConstant typeConstant = typeActual = typeActual == null ? pool.typeString() : pool.ensureUnionTypeConstant(typeActual, pool.typeString());
                    }
                    if ((nProduces & 0x20) != 0) {
                        typeActual = typeActual == null ? pool.typeByteArray() : pool.ensureUnionTypeConstant(typeActual, pool.typeByteArray());
                    }
                    break;
                }
                case 1: {
                    typeActual = pool.typeFileStore();
                    constVal = this.buildFileStoreConstant();
                    break;
                }
                case 2: {
                    typeActual = pool.typeDirectory();
                    constVal = this.m_dir == null ? FileExpression.buildDirectoryConstant(pool, this.m_file) : FileExpression.buildDirectoryConstant(pool, this.m_dir);
                    break;
                }
                case 4: {
                    typeActual = pool.typeFile();
                    constVal = FileExpression.buildFileConstant(this.pool(), this.m_file);
                    break;
                }
                case 8: {
                    typeActual = pool.typePath();
                    constVal = pool.ensureLiteralConstant(Constant.Format.Path, (String)this.path.getValue());
                    break;
                }
                case 16: {
                    typeActual = pool.typeString();
                    constVal = pool.ensureStringConstant(new String(Handy.readFileChars(this.m_file)));
                    break;
                }
                case 32: {
                    typeActual = pool.typeByteArray();
                    constVal = pool.ensureByteStringConstant(Handy.readFileBytes(this.m_file));
                    break;
                }
                default: {
                    this.log(errs, Severity.ERROR, "COMPILER-184", new Object[0]);
                    fit = Expression.TypeFit.NoFit;
                    break;
                }
            }
        }
        catch (IOException e) {
            this.log(errs, Severity.ERROR, "COMPILER-01", e.getMessage());
            fit = Expression.TypeFit.NoFit;
            typeActual = null;
            constVal = null;
        }
        return this.finishValidation(ctx, typeRequired, typeActual, fit, constVal, errs);
    }

    @Override
    public ExprAST getExprAST(Context ctx) {
        assert (this.isConstant());
        return FileExpression.toExprAst(this.toConstant());
    }

    @Override
    public String toString() {
        String sType = this.getSimpleTypeName();
        String sPath = (String)this.path.getValue();
        return sType == null ? sPath : sType + ":" + sPath;
    }

    @Override
    public String getDumpDesc() {
        return this.toString();
    }

    protected FileStoreConstant buildFileStoreConstant() throws IOException {
        ConstantPool pool = this.pool();
        String sPath = (String)this.path.getValue();
        FSNodeConstant constDir = this.m_dir == null ? FileExpression.buildDirectoryConstant(pool, this.m_file) : FileExpression.buildDirectoryConstant(pool, this.m_dir);
        return pool.ensureFileStoreConstant(sPath, constDir);
    }

    public static FSNodeConstant buildDirectoryConstant(ConstantPool pool, File dir) throws IOException {
        File[] aFiles = dir.listFiles();
        if (aFiles == null) {
            throw new IOException("failed to obtain contents of directory: " + String.valueOf(dir));
        }
        int cFiles = aFiles.length;
        FSNodeConstant[] aConsts = new FSNodeConstant[cFiles];
        for (int i = 0; i < cFiles; ++i) {
            File file = aFiles[i];
            aConsts[i] = file.isDirectory() ? FileExpression.buildDirectoryConstant(pool, file) : FileExpression.buildFileConstant(pool, file);
        }
        return pool.ensureDirectoryConstant(dir.getName(), FileExpression.createdTime(dir), FileExpression.modifiedTime(dir), aConsts);
    }

    public static FSNodeConstant buildDirectoryConstant(ConstantPool pool, ResourceDir dir) throws IOException {
        Set<String> children = dir.getNames();
        int cConsts = children.size();
        FSNodeConstant[] aConsts = new FSNodeConstant[cConsts];
        int iConst = 0;
        for (String child : children) {
            assert (iConst < cConsts);
            Object resource = dir.getByName(child);
            if (resource instanceof ResourceDir) {
                ResourceDir subdir = (ResourceDir)resource;
                aConsts[iConst++] = FileExpression.buildDirectoryConstant(pool, subdir);
                continue;
            }
            if (resource instanceof File) {
                File file = (File)resource;
                aConsts[iConst++] = FileExpression.buildFileConstant(pool, file);
                continue;
            }
            throw new IllegalStateException("unknown resource \"" + child + "\" from " + String.valueOf(dir) + " : " + String.valueOf(resource));
        }
        assert (iConst == cConsts);
        return pool.ensureDirectoryConstant(dir.getName(), dir.getCreatedTime(), dir.getModifiedTime(), aConsts);
    }

    public static FSNodeConstant buildFileConstant(ConstantPool pool, File file) throws IOException {
        byte[] ab = Handy.readFileBytes(file);
        return pool.ensureFileConstant(file.getName(), FileExpression.createdTime(file), FileExpression.modifiedTime(file), ab);
    }

    public static FileTime createdTime(File file) {
        try {
            BasicFileAttributes attr = Files.readAttributes(file.toPath(), BasicFileAttributes.class, new LinkOption[0]);
            return attr.creationTime();
        }
        catch (IOException e) {
            return null;
        }
    }

    public static FileTime modifiedTime(File file) {
        try {
            BasicFileAttributes attr = Files.readAttributes(file.toPath(), BasicFileAttributes.class, new LinkOption[0]);
            return attr.lastModifiedTime();
        }
        catch (IOException e) {
            return null;
        }
    }
}

