/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.compiler.ast;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.xvm.asm.Argument;
import org.xvm.asm.Assignment;
import org.xvm.asm.Component;
import org.xvm.asm.ConstantPool;
import org.xvm.asm.ErrorListener;
import org.xvm.asm.MethodStructure;
import org.xvm.asm.Register;
import org.xvm.asm.ast.BinaryAST;
import org.xvm.asm.ast.ExprAST;
import org.xvm.asm.ast.ForEachStmtAST;
import org.xvm.asm.ast.RegAllocAST;
import org.xvm.asm.ast.StmtBlockAST;
import org.xvm.asm.constants.ClassConstant;
import org.xvm.asm.constants.FormalConstant;
import org.xvm.asm.constants.IntConstant;
import org.xvm.asm.constants.MethodConstant;
import org.xvm.asm.constants.MethodInfo;
import org.xvm.asm.constants.PropertyConstant;
import org.xvm.asm.constants.PropertyInfo;
import org.xvm.asm.constants.RangeConstant;
import org.xvm.asm.constants.StringConstant;
import org.xvm.asm.constants.TypeConstant;
import org.xvm.asm.constants.TypeInfo;
import org.xvm.asm.op.Enter;
import org.xvm.asm.op.Exit;
import org.xvm.asm.op.IP_Dec;
import org.xvm.asm.op.IP_Inc;
import org.xvm.asm.op.I_Get;
import org.xvm.asm.op.Invoke_01;
import org.xvm.asm.op.Invoke_0N;
import org.xvm.asm.op.IsEq;
import org.xvm.asm.op.Jump;
import org.xvm.asm.op.JumpFalse;
import org.xvm.asm.op.JumpGte;
import org.xvm.asm.op.JumpTrue;
import org.xvm.asm.op.Label;
import org.xvm.asm.op.Loop;
import org.xvm.asm.op.LoopEnd;
import org.xvm.asm.op.Move;
import org.xvm.asm.op.P_Get;
import org.xvm.asm.op.Var;
import org.xvm.asm.op.Var_IN;
import org.xvm.asm.op.Var_N;
import org.xvm.compiler.Source;
import org.xvm.compiler.Token;
import org.xvm.compiler.ast.AssignmentStatement;
import org.xvm.compiler.ast.AstNode;
import org.xvm.compiler.ast.ConditionalStatement;
import org.xvm.compiler.ast.Context;
import org.xvm.compiler.ast.Expression;
import org.xvm.compiler.ast.LabelAble;
import org.xvm.compiler.ast.LabeledStatement;
import org.xvm.compiler.ast.Statement;
import org.xvm.compiler.ast.StatementBlock;
import org.xvm.util.Handy;
import org.xvm.util.Severity;

public class ForEachStatement
extends ConditionalStatement
implements LabelAble {
    protected StatementBlock block;
    private transient Label m_labelContinue;
    private transient Expression m_exprLValue;
    private transient Expression m_exprRValue;
    private transient Plan m_plan;
    private transient Context m_ctxLabelVars;
    private transient ErrorListener m_errsLabelVars;
    private transient Register m_regFirst;
    private transient Register m_regLast;
    private transient Register m_regCount;
    private transient Register m_regEntry;
    private transient Register m_regKeyType;
    private transient Register m_regValType;
    private transient boolean m_fTupleLValue;
    private transient MethodConstant[] m_aidConvKey;
    private transient TypeConstant[] m_atypeConv;
    private transient List<Statement.Break> m_listContinues;
    private static final Field[] CHILD_FIELDS = ForEachStatement.fieldsForNames(ForEachStatement.class, "conds", "block");

    public ForEachStatement(Token keyword, AssignmentStatement cond, StatementBlock block) {
        super(keyword, Collections.singletonList(cond));
        this.block = block;
    }

    public AssignmentStatement getCondition() {
        return (AssignmentStatement)this.conds.getFirst();
    }

    @Override
    public boolean isNaturalGotoStatementTarget() {
        return true;
    }

    @Override
    public Label ensureContinueLabel(AstNode nodeOrigin, Context ctxOrigin) {
        Context ctxDest = this.ensureValidationContext();
        HashMap<String, Assignment> mapAsn = new HashMap<String, Assignment>();
        HashMap<String, Argument> mapArg = new HashMap<String, Argument>();
        ctxOrigin.prepareJump(ctxDest, mapAsn, mapArg);
        if (this.m_listContinues == null) {
            this.m_listContinues = new ArrayList<Statement.Break>();
        }
        Label label = this.getContinueLabel();
        this.m_listContinues.add(new Statement.Break(this, mapAsn, mapArg, label));
        return label;
    }

    public boolean hasContinueLabel() {
        return this.m_labelContinue != null;
    }

    public Label getContinueLabel() {
        Label label = this.m_labelContinue;
        if (label == null) {
            this.m_labelContinue = label = new Label("continue_foreach_" + this.getLabelId());
        }
        return label;
    }

    private TypeConstant getElementType() {
        assert (this.m_plan != Plan.MAP);
        assert (this.m_exprRValue != null);
        TypeConstant type = this.m_exprRValue.getType().resolveGenericType("Element");
        return type == null ? this.pool().typeObject() : type;
    }

    private TypeConstant getKeyType() {
        return this.getFormalMapType("Key");
    }

    private TypeConstant getValueType() {
        return this.getFormalMapType("Value");
    }

    private TypeConstant getFormalMapType(String sProp) {
        TypeConstant type;
        assert (this.m_plan == Plan.MAP);
        assert (this.m_exprRValue != null);
        TypeConstant typeMap = this.m_exprRValue.getType();
        assert (typeMap.isA(this.pool().typeMap()));
        if (typeMap.isFormalType()) {
            typeMap = ((FormalConstant)typeMap.getDefiningConstant()).getConstraintType();
            assert (typeMap.isA(this.pool().typeMap()));
        }
        return (type = typeMap.resolveGenericType(sProp)) == null ? this.pool().typeObject() : type;
    }

    private TypeConstant getEntryType() {
        ConstantPool pool = this.pool();
        ClassConstant idEntry = pool.ensureEcstasyClassConstant("maps.Map.Entry");
        return pool.ensureClassTypeConstant(idEntry, null, this.getKeyType(), this.getValueType());
    }

    private boolean isLabeled() {
        return this.getParent() instanceof LabeledStatement;
    }

    private String getLabelName() {
        return ((LabeledStatement)this.getParent()).getName();
    }

    private StringConstant toConst(String s) {
        return this.pool().ensureStringConstant(s);
    }

    @Override
    public long getEndPosition() {
        return this.block.getEndPosition();
    }

    @Override
    protected Field[] getChildFields() {
        return CHILD_FIELDS;
    }

    @Override
    public boolean hasLabelVar(String sName) {
        return switch (sName) {
            case "first", "count" -> true;
            case "last" -> {
                if (this.m_plan == Plan.RANGE || this.m_plan == Plan.LIST) {
                    yield true;
                }
                yield false;
            }
            case "entry", "Key", "Value" -> {
                if (this.m_plan == Plan.MAP) {
                    yield true;
                }
                yield false;
            }
            default -> false;
        };
    }

    @Override
    public Register getLabelVar(Context ctx, String sName) {
        assert (this.isLabeled());
        assert (this.hasLabelVar(sName));
        Register reg = switch (sName) {
            case "first" -> this.m_regFirst;
            case "last" -> this.m_regLast;
            case "count" -> this.m_regCount;
            case "entry" -> this.m_regEntry;
            case "Key" -> this.m_regKeyType;
            case "Value" -> this.m_regValType;
            default -> throw new IllegalStateException();
        };
        if (reg == null) {
            assert (this.m_ctxLabelVars != null);
            String sLabel = ((LabeledStatement)this.getParent()).getName();
            Token tok = new Token(this.keyword.getStartPosition(), this.keyword.getEndPosition(), Token.Id.IDENTIFIER, sLabel + "." + sName);
            ConstantPool pool = this.pool();
            TypeConstant type = switch (sName) {
                case "first", "last" -> pool.typeBoolean();
                case "count" -> pool.typeInt64();
                case "entry" -> this.getEntryType();
                case "Key" -> this.getKeyType().getType();
                case "Value" -> this.getValueType().getType();
                default -> throw new IllegalStateException();
            };
            reg = ctx.createRegister(type, this.getLabelName() + "." + sName);
            this.m_ctxLabelVars.registerVar(tok, reg, this.m_errsLabelVars);
            switch (sName) {
                case "first": {
                    this.m_regFirst = reg;
                    break;
                }
                case "last": {
                    this.m_regLast = reg;
                    break;
                }
                case "count": {
                    this.m_regCount = reg;
                    break;
                }
                case "entry": {
                    this.m_regEntry = reg;
                    break;
                }
                case "Key": {
                    this.m_regKeyType = reg;
                    break;
                }
                case "Value": {
                    this.m_regValType = reg;
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
        return reg;
    }

    @Override
    protected Statement validateImpl(Context ctx, ErrorListener errs) {
        boolean fValid;
        AssignmentStatement condOrig;
        StatementBlock blockOrig;
        block49: {
            ErrorListener errsOrig = errs;
            Context ctxOrig = ctx;
            HashMap<String, Assignment> mapLoopAsn = new HashMap<String, Assignment>();
            HashMap<String, Argument> mapLoopArg = new HashMap<String, Argument>();
            blockOrig = this.block;
            condOrig = this.getCondition();
            int cTries = 0;
            while (true) {
                List<Statement.Break> listContinues;
                Expression exprRValNew;
                fValid = true;
                this.conds = Collections.singletonList(condOrig.clone());
                this.block = (StatementBlock)blockOrig.clone();
                errs = errsOrig.branch(this);
                ctx = ctxOrig.enter();
                ctx.merge(mapLoopAsn, mapLoopArg);
                ctx.setReachable(true);
                this.m_ctxLabelVars = ctx;
                this.m_errsLabelVars = errs;
                AssignmentStatement cond = this.getCondition();
                assert (cond.isForEachCondition());
                ctx = ctx.enterIf();
                AstNode condLVal = cond.getLValue();
                if (condLVal instanceof Statement) {
                    Statement condOld = (Statement)condLVal;
                    Statement condNew = condOld.validate(ctx, errs);
                    if (condNew == null) {
                        fValid = false;
                    } else {
                        condLVal = condNew;
                    }
                } else {
                    Expression condOld = (Expression)condLVal;
                    Expression condNew = condOld.validate(ctx, null, errs);
                    if (condNew == null) {
                        fValid = false;
                    } else {
                        condLVal = condNew;
                    }
                }
                Expression exprLVal = condLVal.getLValueExpression();
                if (!exprLVal.isValidated()) {
                    Expression exprNew = exprLVal.validate(ctx, null, errs);
                    if (exprNew == null) {
                        fValid = false;
                    } else {
                        exprLVal = exprNew;
                    }
                }
                this.m_exprLValue = exprLVal;
                exprLVal.requireAssignable(ctx, errs);
                Expression exprRVal = cond.getRValue();
                ConstantPool pool = this.pool();
                Plan plan = null;
                TypeConstant typeLVal = fValid ? exprLVal.getType() : null;
                TypeConstant typeRVal = null;
                int cLVals = 0;
                boolean fConvert = false;
                if (typeLVal != null) {
                    ctx = ctx.enterInferring(typeLVal);
                }
                TypeConstant[] atypeLVals = null;
                for (int i = Plan.ITERATOR.ordinal(); i <= Plan.ITERABLE.ordinal(); ++i) {
                    plan = Plan.valueOf(i);
                    switch (plan.ordinal()) {
                        default: {
                            throw new MatchException(null, null);
                        }
                        case 0: {
                            TypeConstant typeConstant = pool.typeIterator();
                            break;
                        }
                        case 1: {
                            TypeConstant typeConstant = pool.typeRange();
                            break;
                        }
                        case 2: {
                            TypeConstant typeConstant = pool.typeList();
                            break;
                        }
                        case 3: {
                            TypeConstant typeConstant = pool.typeMap();
                            break;
                        }
                        case 4: {
                            TypeConstant typeConstant = typeRVal = pool.typeIterable();
                        }
                    }
                    if (!exprRVal.testFit(ctx, typeRVal, false, null).isFit()) continue;
                    atypeLVals = exprLVal.getTypes();
                    break;
                }
                this.m_plan = plan;
                if (fValid && atypeLVals != null) {
                    TypeConstant typeRValExact = null;
                    int cMaxLVals = plan == Plan.MAP ? 2 : 1;
                    cLVals = atypeLVals.length;
                    if (cLVals < 1 || cLVals > cMaxLVals) {
                        if (cLVals > 1 && cMaxLVals == 1) {
                            this.m_fTupleLValue = true;
                            typeRValExact = pool.ensureParameterizedTypeConstant(typeRVal, pool.ensureTupleType(atypeLVals));
                        } else {
                            condLVal.log(errs, Severity.ERROR, "COMPILER-95", 1, cMaxLVals);
                            fValid = false;
                        }
                    } else {
                        typeRValExact = pool.ensureParameterizedTypeConstant(typeRVal, atypeLVals);
                    }
                    if (exprRVal.testFit(ctx, typeRValExact, false, null).isFit()) {
                        typeRVal = typeRValExact;
                    } else {
                        fConvert = true;
                    }
                }
                if ((exprRValNew = exprRVal.validate(ctx, typeRVal, errs)) == null) {
                    fValid = false;
                } else {
                    this.m_exprRValue = exprRValNew;
                    if (fValid) {
                        TypeConstant[] atypeRVals;
                        switch (plan.ordinal()) {
                            default: {
                                TypeConstant typeEl = this.getElementType();
                                if (this.m_fTupleLValue) {
                                    if (!typeEl.isTuple()) {
                                        condLVal.log(errs, Severity.ERROR, "COMPILER-43", pool.typeTuple(), typeEl);
                                        atypeRVals = null;
                                        fValid = false;
                                        break;
                                    }
                                    int cRVals = typeEl.getParamsCount();
                                    if (cLVals <= cRVals) {
                                        atypeRVals = typeEl.getParamTypesArray();
                                        break;
                                    }
                                    condLVal.log(errs, Severity.ERROR, "COMPILER-95", 1, cRVals);
                                    atypeRVals = null;
                                    fValid = false;
                                    break;
                                }
                                atypeRVals = new TypeConstant[]{typeEl};
                                break;
                            }
                            case 3: {
                                Register regLabel;
                                atypeRVals = new TypeConstant[]{this.getKeyType(), this.getValueType()};
                                if (!this.isLabeled() || (regLabel = (Register)ctx.getVar(this.getLabelName())) == null) break;
                                regLabel.specifyActualType(pool.ensureParameterizedTypeConstant(regLabel.getType(), atypeRVals));
                            }
                        }
                        if (fValid) {
                            assert (atypeRVals.length >= cLVals);
                            if (fConvert) {
                                atypeRVals = (TypeConstant[])atypeRVals.clone();
                                for (int i = 0; i < cLVals; ++i) {
                                    TypeConstant typeL = atypeLVals[i];
                                    TypeConstant typeR = atypeRVals[i];
                                    if (typeL.isA(typeR)) continue;
                                    atypeRVals[i] = typeL;
                                    MethodConstant idConv = typeR.ensureTypeInfo(errs).findConversion(typeL);
                                    if (idConv == null) {
                                        exprRVal.log(errs, Severity.ERROR, "COMPILER-43", typeL.getValueString(), typeR.getValueString());
                                        fValid = false;
                                        continue;
                                    }
                                    if (this.m_aidConvKey == null) {
                                        this.m_aidConvKey = new MethodConstant[cLVals];
                                        this.m_atypeConv = new TypeConstant[cLVals];
                                    }
                                    this.m_aidConvKey[i] = idConv;
                                    this.m_atypeConv[i] = typeR;
                                }
                            }
                            exprLVal.updateLValueFromRValueTypes(ctx, Context.Branch.Always, false, atypeRVals);
                        }
                    }
                }
                if (typeLVal != null) {
                    ctx = ctx.exit();
                }
                exprLVal.markAssignment(ctx, false, errs);
                StatementBlock blockOld = this.block;
                ctx = ctx.enterFork(true);
                StatementBlock blockNew = (StatementBlock)blockOld.validate(ctx, errs);
                if (blockNew != blockOld) {
                    if (blockNew == null) {
                        fValid = false;
                    } else {
                        this.block = blockNew;
                    }
                }
                if ((listContinues = this.m_listContinues) != null) {
                    for (Statement.Break continueInfo : listContinues) {
                        ctx.merge(continueInfo.mapAssign(), continueInfo.mapNarrow());
                    }
                    ctx.setReachable(true);
                }
                HashMap<String, Assignment> mapAsnAfter = new HashMap<String, Assignment>();
                HashMap<String, Argument> mapArgAfter = new HashMap<String, Argument>();
                ctx.prepareJump(ctxOrig, mapAsnAfter, mapArgAfter);
                if (mapAsnAfter.equals(mapLoopAsn)) break block49;
                if (++cTries >= 10) break;
                mapLoopAsn = mapAsnAfter;
                mapLoopArg = mapArgAfter;
                cond.discard(true);
                this.block.discard(true);
            }
            if (!errs.hasSeriousErrors()) {
                this.log(errs, Severity.ERROR, "COMPILER-01", new Object[0]);
            }
            fValid = false;
        }
        condOrig.discard(true);
        blockOrig.discard(true);
        ctx = ctx.exit();
        ctx = ctx.exit();
        ctx = ctx.exit();
        this.m_ctxLabelVars = null;
        this.m_errsLabelVars = null;
        errs.merge();
        return fValid ? this : null;
    }

    @Override
    protected boolean emit(Context ctx, boolean fReachable, MethodStructure.Code code, ErrorListener errs) {
        boolean fCompletes = fReachable;
        Statement.AstHolder holder = ctx.getHolder();
        code.add(new Enter());
        ArrayList<RegAllocAST> listSpecial = new ArrayList<RegAllocAST>();
        if (this.isLabeled()) {
            ConstantPool pool = this.pool();
            if (this.m_regFirst != null) {
                code.add(new Var_IN(this.m_regFirst, this.toConst(this.m_regFirst.getName()), pool.valTrue()));
                listSpecial.add(this.m_regFirst.getRegAllocAST());
            }
            if (this.m_regCount != null) {
                code.add(new Var_IN(this.m_regCount, this.toConst(this.m_regCount.getName()), pool.val0()));
                listSpecial.add(this.m_regCount.getRegAllocAST());
            }
            if (this.m_regLast != null) {
                code.add(new Var_N(this.m_regLast, this.toConst(this.m_regLast.getName())));
                listSpecial.add(this.m_regLast.getRegAllocAST());
            }
            if (this.m_regEntry != null) {
                code.add(new Var_N(this.m_regEntry, this.toConst(this.m_regEntry.getName())));
                listSpecial.add(this.m_regEntry.getRegAllocAST());
            }
            if (this.m_regKeyType != null) {
                code.add(new Var_N(this.m_regKeyType, this.toConst(this.m_regKeyType.getName())));
                listSpecial.add(this.m_regKeyType.getRegAllocAST());
            }
            if (this.m_regValType != null) {
                code.add(new Var_N(this.m_regValType, this.toConst(this.m_regValType.getName())));
                listSpecial.add(this.m_regValType.getRegAllocAST());
            }
        }
        ExprAST astLVal = this.m_exprLValue.getExprAST(ctx);
        AstNode astNode = this.getCondition().getLValue();
        if (astNode instanceof Statement) {
            Statement stmt = (Statement)astNode;
            fCompletes = stmt.completes(ctx, fCompletes, code, errs);
            astLVal = AssignmentStatement.combineLValueAST((ExprAST)ctx.getHolder().getAst(stmt), astLVal);
        }
        BinaryAST.NodeType nodeType = switch (this.m_plan.ordinal()) {
            case 0 -> {
                fCompletes = this.emitIterator(ctx, fCompletes, code, errs);
                yield BinaryAST.NodeType.ForIterableStmt;
            }
            case 1 -> {
                fCompletes = this.emitRange(ctx, fCompletes, code, errs);
                yield BinaryAST.NodeType.ForRangeStmt;
            }
            case 2 -> {
                fCompletes = this.emitList(ctx, fCompletes, code, errs);
                yield BinaryAST.NodeType.ForListStmt;
            }
            case 3 -> {
                fCompletes = this.emitMap(ctx, fCompletes, code, errs);
                yield BinaryAST.NodeType.ForMapStmt;
            }
            case 4 -> {
                fCompletes = this.emitIterable(ctx, fCompletes, code, errs);
                yield BinaryAST.NodeType.ForIterableStmt;
            }
            default -> throw new IllegalStateException();
        };
        code.add(new Exit());
        if (fCompletes) {
            holder.setAst(this, new ForEachStmtAST(nodeType, listSpecial.toArray(BinaryAST.NO_ALLOCS), astLVal, this.m_exprRValue.getExprAST(ctx), holder.getAst(this.block)));
        }
        return fCompletes;
    }

    private boolean emitIterator(Context ctx, boolean fReachable, MethodStructure.Code code, ErrorListener errs) {
        ConstantPool pool = this.pool();
        TypeConstant typeIter = pool.ensureParameterizedTypeConstant(pool.typeIterator(), this.getElementType());
        Register regIter = code.createRegister(typeIter);
        code.add(new Var(regIter));
        Expression expression = this.m_exprRValue;
        Objects.requireNonNull(expression);
        this.m_exprRValue.generateAssignment(ctx, code, expression.new Expression.Assignable(regIter), errs);
        return this.emitAnyIterator(ctx, fReachable, code, regIter, errs);
    }

    private boolean emitAnyIterator(Context ctx, boolean fReachable, MethodStructure.Code code, Register regIter, ErrorListener errs) {
        MethodConstant idConv;
        ConstantPool pool = this.pool();
        TypeInfo infoIter = pool.typeIterator().ensureTypeInfo(errs);
        MethodConstant idNext = this.findWellKnownMethod(infoIter, "next", errs);
        if (idNext == null) {
            return false;
        }
        if (this.m_regLast != null) {
            this.log(errs, Severity.ERROR, "COMPILER-94", "last", this.getLabelName());
            return false;
        }
        Register regCond = code.createRegister(pool.typeBoolean());
        code.add(new Var(regCond));
        Expression.Assignable lvalVal = this.m_exprLValue.generateAssignable(ctx, code, errs);
        boolean fTempVal = !lvalVal.isLocalArgument();
        Argument argVal = fTempVal ? new Register(lvalVal.getType(), null, -1) : lvalVal.getLocalArgument();
        code.add(new Loop());
        MethodConstant methodConstant = idConv = this.m_aidConvKey == null ? null : this.m_aidConvKey[0];
        if (idConv == null) {
            code.add(new Invoke_0N(regIter, idNext, new Argument[]{regCond, argVal}));
            code.add(new JumpFalse(regCond, this.getEndLabel()));
        } else {
            Register regTemp = new Register(this.m_atypeConv[0], null, -1);
            code.add(new Invoke_0N(regIter, idNext, new Argument[]{regCond, regTemp}));
            code.add(new JumpFalse(regCond, this.getEndLabel()));
            code.add(new Invoke_01(regTemp, idConv, argVal));
        }
        if (fTempVal) {
            lvalVal.assign(argVal, code, errs);
        }
        this.block.completes(ctx, fReachable, code, errs);
        if (this.hasContinueLabel()) {
            code.add(this.getContinueLabel());
        }
        if (this.m_regFirst != null) {
            code.add(new Move(pool.valFalse(), this.m_regFirst));
        }
        if (this.m_regCount != null) {
            code.add(new IP_Inc(this.m_regCount));
        }
        code.add(new LoopEnd());
        return fReachable;
    }

    private boolean emitRange(Context ctx, boolean fReachable, MethodStructure.Code code, ErrorListener errs) {
        TypeConstant typeElement = this.getElementType().removeAutoNarrowing();
        if (this.m_exprRValue.toConstant() instanceof RangeConstant) {
            switch (this.m_exprRValue.getType().getParamType(0).removeAutoNarrowing().getEcstasyClassName()) {
                case "numbers.Bit": 
                case "numbers.Nibble": 
                case "text.Char": 
                case "numbers.Int8": 
                case "numbers.Int16": 
                case "numbers.Int32": 
                case "numbers.Int64": 
                case "numbers.Int128": 
                case "numbers.IntN": 
                case "numbers.UInt8": 
                case "numbers.UInt16": 
                case "numbers.UInt32": 
                case "numbers.UInt64": 
                case "numbers.UInt128": 
                case "numbers.UIntN": {
                    return this.emitConstantRange(ctx, fReachable, code, typeElement, errs);
                }
            }
            if (typeElement.isExplicitClassIdentity(false) && typeElement.getExplicitClassFormat() == Component.Format.ENUM) {
                return this.emitConstantRange(ctx, fReachable, code, typeElement, errs);
            }
        }
        if (!typeElement.isA(this.pool().typeSequential())) {
            this.log(errs, Severity.ERROR, "COMPILER-43", this.pool().typeSequential().getValueString(), typeElement.getValueString());
            return false;
        }
        return this.emitVariableRange(ctx, fReachable, code, typeElement, errs);
    }

    private boolean emitConstantRange(Context ctx, boolean fReachable, MethodStructure.Code code, TypeConstant typeSeq, ErrorListener errs) {
        ConstantPool pool = this.pool();
        RangeConstant range = (RangeConstant)this.m_exprRValue.toConstant();
        if (range.size() < 1L) {
            this.block.completes(ctx, false, code, errs);
            ctx.getHolder().setAst(this.block, StmtBlockAST.EMPTY);
            return fReachable;
        }
        Expression.Assignable LVal = this.m_exprLValue.generateAssignable(ctx, code, errs);
        Register regVal = code.createRegister(typeSeq);
        code.add(new Var_IN(regVal, pool.ensureStringConstant(this.getLoopPrefix() + "current"), range.getEffectiveFirst()));
        Register regLast = this.m_regLast;
        if (regLast == null) {
            regLast = code.createRegister(pool.typeBoolean());
            code.add(new Var_N(regLast, pool.ensureStringConstant(this.getLoopPrefix() + "last")));
        }
        code.add(new Loop());
        code.add(new IsEq(regVal.getType(), regVal, range.getEffectiveLast(), regLast));
        LVal.assign(regVal, code, errs);
        this.block.completes(ctx, fReachable, code, errs);
        code.add(this.getContinueLabel());
        code.add(new JumpTrue(regLast, this.getEndLabel()));
        code.add(range.isReverse() ? new IP_Dec(regVal) : new IP_Inc(regVal));
        if (this.m_regFirst != null) {
            code.add(new Move(pool.valFalse(), this.m_regFirst));
        }
        if (this.m_regCount != null) {
            code.add(new IP_Inc(this.m_regCount));
        }
        code.add(new LoopEnd());
        return fReachable;
    }

    private boolean emitVariableRange(Context ctx, boolean fReachable, MethodStructure.Code code, TypeConstant typeSeq, ErrorListener errs) {
        ConstantPool pool = this.pool();
        Argument argRange = this.m_exprRValue.generateArgument(ctx, code, true, false, errs);
        TypeInfo infoRange = pool.ensureRangeType(typeSeq).ensureTypeInfo(errs);
        MethodConstant idLimits = this.findWellKnownMethod(infoRange, "effectiveLimits", errs);
        PropertyConstant idDescend = this.findWellKnownProperty(infoRange, "descending", errs);
        if (idLimits == null || idDescend == null) {
            return false;
        }
        Register regCond = code.createRegister(pool.typeBoolean());
        Register regFirstValue = code.createRegister(typeSeq);
        Register regLastValue = code.createRegister(typeSeq);
        code.add(new Var(regCond));
        code.add(new Var(regFirstValue));
        code.add(new Var(regLastValue));
        code.add(new Invoke_0N(argRange, idLimits, new Argument[]{regCond, regFirstValue, regLastValue}));
        code.add(new JumpFalse(regCond, this.getEndLabel()));
        Register regDescend = code.createRegister(pool.typeBoolean());
        code.add(new Var(regDescend));
        code.add(new P_Get(idDescend, argRange, regDescend));
        Expression.Assignable LVal = this.m_exprLValue.generateAssignable(ctx, code, errs);
        Register regVal = code.createRegister(typeSeq);
        code.add(new Var_IN(regVal, pool.ensureStringConstant(this.getLoopPrefix() + "current"), regFirstValue));
        Register regLast = this.m_regLast;
        if (regLast == null) {
            regLast = code.createRegister(pool.typeBoolean());
            code.add(new Var_N(regLast, pool.ensureStringConstant(this.getLoopPrefix() + "last")));
        }
        code.add(new Loop());
        code.add(new IsEq(regVal.getType(), regVal, regLastValue, regLast));
        LVal.assign(regVal, code, errs);
        this.block.completes(ctx, fReachable, code, errs);
        code.add(this.getContinueLabel());
        code.add(new JumpTrue(regLast, this.getEndLabel()));
        Label labelDecrement = new Label("decrement" + this.getLabelId());
        Label labelUpdateVars = new Label("update_vars" + this.getLabelId());
        code.add(new JumpTrue(regDescend, labelDecrement));
        code.add(new IP_Inc(regVal));
        code.add(new Jump(labelUpdateVars));
        code.add(labelDecrement);
        code.add(new IP_Dec(regVal));
        code.add(labelUpdateVars);
        if (this.m_regFirst != null) {
            code.add(new Move(pool.valFalse(), this.m_regFirst));
        }
        if (this.m_regCount != null) {
            code.add(new IP_Inc(this.m_regCount));
        }
        code.add(new LoopEnd());
        return fReachable;
    }

    private boolean emitList(Context ctx, boolean fReachable, MethodStructure.Code code, ErrorListener errs) {
        MethodConstant idConv;
        Argument argVal;
        ConstantPool pool = this.pool();
        TypeConstant typeElem = this.getElementType();
        TypeConstant typeList = pool.ensureParameterizedTypeConstant(pool.typeList(), typeElem);
        TypeInfo infoList = typeList.ensureTypeInfo(errs);
        PropertyConstant idSize = infoList.findProperty("size").getIdentity();
        Register regCount = this.m_regCount;
        if (regCount == null) {
            regCount = code.createRegister(pool.typeInt64());
            code.add(new Var_IN(regCount, pool.ensureStringConstant(this.getLoopPrefix() + "count"), pool.val0()));
        }
        Register regEnd = code.createRegister(pool.typeInt64());
        code.add(new Var(regEnd));
        Register regList = code.createRegister(typeList);
        code.add(new Var(regList));
        Expression expression = this.m_exprRValue;
        Objects.requireNonNull(expression);
        this.m_exprRValue.generateAssignment(ctx, code, expression.new Expression.Assignable(regList), errs);
        code.add(new P_Get(idSize, regList, regEnd));
        code.add(new JumpGte(pool.typeInt64(), regCount, regEnd, this.getEndLabel()));
        code.add(new IP_Dec(regEnd));
        Expression.Assignable lvalVal = null;
        Expression.Assignable[] alvalVal = null;
        boolean fTempVal = false;
        if (this.m_fTupleLValue) {
            assert (typeElem.isTuple());
            alvalVal = this.m_exprLValue.generateAssignables(ctx, code, errs);
            Register regElem = code.createRegister(typeElem);
            code.add(new Var(regElem));
            argVal = regElem;
        } else {
            lvalVal = this.m_exprLValue.generateAssignable(ctx, code, errs);
            fTempVal = !lvalVal.isLocalArgument();
            argVal = fTempVal ? new Register(typeElem, null, -1) : lvalVal.getLocalArgument();
        }
        Register regLast = this.m_regLast;
        if (regLast == null) {
            regLast = code.createRegister(pool.typeBoolean());
            code.add(new Var_N(regLast, pool.ensureStringConstant(this.getLoopPrefix() + "last")));
        }
        code.add(new Loop());
        code.add(new IsEq(pool.typeInt64(), regCount, regEnd, regLast));
        MethodConstant methodConstant = idConv = this.m_aidConvKey == null ? null : this.m_aidConvKey[0];
        if (idConv == null) {
            code.add(new I_Get(regList, regCount, argVal));
        } else {
            Register regTemp = new Register(this.m_atypeConv[0], null, -1);
            code.add(new I_Get(regList, regCount, regTemp));
            code.add(new Invoke_01(regTemp, idConv, argVal));
        }
        if (this.m_fTupleLValue) {
            int c = alvalVal.length;
            for (int i = 0; i < c; ++i) {
                Expression.Assignable lval = alvalVal[i];
                IntConstant index = pool.ensureIntConstant(i);
                if (lval.isLocalArgument()) {
                    code.add(new I_Get(argVal, index, lval.getLocalArgument()));
                    continue;
                }
                Register regTemp = code.createRegister(lval.getType());
                code.add(new Var(regTemp));
                code.add(new I_Get(argVal, index, regTemp));
                lvalVal.assign(regTemp, code, errs);
            }
        } else if (fTempVal) {
            lvalVal.assign(argVal, code, errs);
        }
        this.block.completes(ctx, fReachable, code, errs);
        code.add(this.getContinueLabel());
        code.add(new JumpTrue(regLast, this.getEndLabel()));
        code.add(new IP_Inc(regCount));
        if (this.m_regFirst != null) {
            code.add(new Move(pool.valFalse(), this.m_regFirst));
        }
        code.add(new LoopEnd());
        return fReachable;
    }

    private boolean emitMap(Context ctx, boolean fReachable, MethodStructure.Code code, ErrorListener errs) {
        ConstantPool pool = this.pool();
        TypeConstant typeKey = this.getKeyType();
        TypeConstant typeValue = this.getValueType();
        TypeConstant typeMap = pool.ensureMapType(typeKey, typeValue);
        TypeConstant typeEntry = this.getEntryType();
        TypeInfo infoMap = typeMap.ensureTypeInfo(errs);
        boolean fKeysOnly = this.m_exprLValue.getValueCount() == 1 && this.m_regEntry == null;
        TypeConstant typeEach = fKeysOnly ? typeKey : typeEntry;
        TypeConstant typeIter = pool.ensureParameterizedTypeConstant(pool.typeIterator(), typeEach);
        MethodConstant idNext = this.findWellKnownMethod(typeIter.ensureTypeInfo(errs), "next", errs);
        if (idNext == null) {
            return false;
        }
        Argument argMap = this.m_exprRValue.generateArgument(ctx, code, true, true, errs);
        if (this.m_exprLValue.getValueCount() == 2 || this.m_regEntry != null) {
            MethodConstant idConvKey;
            MethodConstant idIterator = this.findWellKnownMethod(infoMap, "iterator", errs);
            if (idIterator == null) {
                return false;
            }
            TypeInfo infoEntry = typeEntry.ensureTypeInfo(errs);
            PropertyConstant idKey = infoEntry.findProperty("key").getIdentity();
            PropertyConstant idValue = infoEntry.findProperty("value").getIdentity();
            Register regIter = code.createRegister(typeIter);
            code.add(new Var(regIter));
            code.add(new Invoke_01(argMap, idIterator, regIter));
            Register regCond = code.createRegister(pool.typeBoolean());
            code.add(new Var(regCond));
            code.add(new Loop());
            Register regEntry = this.m_regEntry;
            if (regEntry == null) {
                regEntry = code.createRegister(typeEntry);
                code.add(new Var_N(regEntry, pool.ensureStringConstant(this.getLoopPrefix() + "entry")));
            }
            code.add(new Invoke_0N(regIter, idNext, new Argument[]{regCond, regEntry}));
            code.add(new JumpFalse(regCond, this.getEndLabel()));
            Expression.Assignable[] aLVal = this.m_exprLValue.generateAssignables(ctx, code, errs);
            Expression.Assignable lvalKey = aLVal[0];
            boolean fTempKey = !lvalKey.isLocalArgument();
            Argument argKey = fTempKey ? new Register(typeKey, null, -1) : lvalKey.getLocalArgument();
            MethodConstant methodConstant = idConvKey = this.m_aidConvKey == null ? null : this.m_aidConvKey[0];
            if (idConvKey == null) {
                code.add(new P_Get(idKey, regEntry, argKey));
            } else {
                Register regTemp = new Register(this.m_atypeConv[0], null, -1);
                code.add(new P_Get(idKey, regEntry, regTemp));
                code.add(new Invoke_01(regTemp, idConvKey, argKey));
            }
            if (fTempKey) {
                lvalKey.assign(argKey, code, errs);
            }
            if (aLVal.length == 2) {
                MethodConstant idConvVal;
                Expression.Assignable lvalVal = aLVal[1];
                boolean fTempVal = !lvalVal.isLocalArgument();
                Argument argVal = fTempVal ? new Register(typeValue, null, -1) : lvalVal.getLocalArgument();
                MethodConstant methodConstant2 = idConvVal = this.m_aidConvKey == null ? null : this.m_aidConvKey[1];
                if (idConvVal == null) {
                    code.add(new P_Get(idValue, regEntry, argVal));
                } else {
                    Register regTemp = new Register(this.m_atypeConv[1], null, -1);
                    code.add(new P_Get(idValue, regEntry, regTemp));
                    code.add(new Invoke_01(regTemp, idConvVal, argVal));
                }
                if (fTempVal) {
                    lvalVal.assign(argVal, code, errs);
                }
            }
        } else {
            MethodConstant idConv;
            TypeConstant typeSet = pool.ensureParameterizedTypeConstant(pool.typeSet(), typeEach);
            MethodConstant idIterator = this.findWellKnownMethod(typeSet.ensureTypeInfo(errs), "iterator", errs);
            if (idIterator == null) {
                return false;
            }
            PropertyConstant idKeys = infoMap.findProperty("keys").getIdentity();
            Register regSet = new Register(typeSet, null, -1);
            code.add(new P_Get(idKeys, argMap, regSet));
            Register regIter = code.createRegister(typeIter);
            code.add(new Var(regIter));
            code.add(new Invoke_01(regSet, idIterator, regIter));
            Register regCond = code.createRegister(pool.typeBoolean());
            code.add(new Var(regCond));
            code.add(new Loop());
            Expression.Assignable lvalKey = this.m_exprLValue.generateAssignable(ctx, code, errs);
            boolean fTempKey = !lvalKey.isLocalArgument();
            Argument argKey = fTempKey ? new Register(typeKey, null, -1) : lvalKey.getLocalArgument();
            MethodConstant methodConstant = idConv = this.m_aidConvKey == null ? null : this.m_aidConvKey[0];
            if (idConv == null) {
                code.add(new Invoke_0N(regIter, idNext, new Argument[]{regCond, argKey}));
                code.add(new JumpFalse(regCond, this.getEndLabel()));
            } else {
                Register regTemp = new Register(this.m_atypeConv[0], null, -1);
                code.add(new Invoke_0N(regIter, idNext, new Argument[]{regCond, regTemp}));
                code.add(new JumpFalse(regCond, this.getEndLabel()));
                code.add(new Invoke_01(regTemp, idConv, argKey));
            }
            if (fTempKey) {
                lvalKey.assign(argKey, code, errs);
            }
        }
        this.block.completes(ctx, fReachable, code, errs);
        if (this.hasContinueLabel()) {
            code.add(this.getContinueLabel());
        }
        if (this.m_regFirst != null) {
            code.add(new Move(pool.valFalse(), this.m_regFirst));
        }
        if (this.m_regCount != null) {
            code.add(new IP_Inc(this.m_regCount));
        }
        code.add(new LoopEnd());
        return fReachable;
    }

    private boolean emitIterable(Context ctx, boolean fReachable, MethodStructure.Code code, ErrorListener errs) {
        ConstantPool pool = this.pool();
        TypeConstant typeElement = this.getElementType();
        TypeConstant typeAble = pool.ensureParameterizedTypeConstant(pool.typeIterable(), typeElement);
        TypeConstant typeIter = pool.ensureParameterizedTypeConstant(pool.typeIterator(), this.getElementType());
        Register regIter = code.createRegister(typeIter);
        code.add(new Var(regIter));
        Argument argAble = this.m_exprRValue.generateArgument(ctx, code, true, true, errs);
        TypeInfo infoAble = typeAble.ensureTypeInfo(errs);
        MethodConstant idIterator = this.findWellKnownMethod(infoAble, "iterator", errs);
        if (idIterator == null) {
            return false;
        }
        code.add(new Invoke_01(argAble, idIterator, regIter));
        return this.emitAnyIterator(ctx, fReachable, code, regIter, errs);
    }

    private MethodConstant findWellKnownMethod(TypeInfo infoTarget, String sMethodName, ErrorListener errs) {
        Set<MethodConstant> setId = infoTarget.findMethods(sMethodName, 0, TypeInfo.MethodKind.Method);
        if (setId.isEmpty()) {
            this.log(errs, Severity.ERROR, "COMPILER-56", sMethodName, infoTarget.getType().getValueString());
            return null;
        }
        HashMap<MethodConstant, MethodStructure> mapMethods = new HashMap<MethodConstant, MethodStructure>();
        for (MethodConstant id : setId) {
            MethodInfo info = infoTarget.getMethodById(id);
            MethodStructure method = info.getTopmostMethodStructure(infoTarget);
            mapMethods.put(id, method);
        }
        return this.chooseBest(setId, infoTarget.getType(), mapMethods, errs);
    }

    private PropertyConstant findWellKnownProperty(TypeInfo info, String sPropName, ErrorListener errs) {
        PropertyInfo prop = info.findProperty(sPropName);
        if (prop == null) {
            this.log(errs, Severity.ERROR, "COMPILER-56", sPropName + ".get()", info.getType().getValueString());
            return null;
        }
        return prop.getIdentity();
    }

    private String getLoopPrefix() {
        return "loop#" + Source.calculateLine(this.getStartPosition()) + ".";
    }

    @Override
    public String toString() {
        return this.keyword.getId().TEXT + " (" + String.valueOf(this.getCondition()) + ")\n" + Handy.indentLines(this.block.toString(), "    ");
    }

    static enum Plan {
        ITERATOR,
        RANGE,
        LIST,
        MAP,
        ITERABLE;

        private static final Plan[] BY_ORDINAL;

        public static Plan valueOf(int i) {
            return BY_ORDINAL[i];
        }

        static {
            BY_ORDINAL = Plan.values();
        }
    }
}

