/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.compiler.ast;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.xvm.asm.Argument;
import org.xvm.asm.Assignment;
import org.xvm.asm.ErrorListener;
import org.xvm.asm.MethodStructure;
import org.xvm.asm.Op;
import org.xvm.asm.Register;
import org.xvm.asm.ast.BinaryAST;
import org.xvm.asm.ast.ExprAST;
import org.xvm.asm.ast.ForStmtAST;
import org.xvm.asm.ast.RegAllocAST;
import org.xvm.asm.ast.StmtBlockAST;
import org.xvm.asm.constants.StringConstant;
import org.xvm.asm.op.Enter;
import org.xvm.asm.op.Exit;
import org.xvm.asm.op.IP_Inc;
import org.xvm.asm.op.Jump;
import org.xvm.asm.op.JumpFalse;
import org.xvm.asm.op.JumpTrue;
import org.xvm.asm.op.Label;
import org.xvm.asm.op.Loop;
import org.xvm.asm.op.LoopEnd;
import org.xvm.asm.op.Move;
import org.xvm.asm.op.Var_IN;
import org.xvm.compiler.Token;
import org.xvm.compiler.ast.AssignmentStatement;
import org.xvm.compiler.ast.AstNode;
import org.xvm.compiler.ast.ConditionalStatement;
import org.xvm.compiler.ast.Context;
import org.xvm.compiler.ast.Expression;
import org.xvm.compiler.ast.LabelAble;
import org.xvm.compiler.ast.LabeledStatement;
import org.xvm.compiler.ast.Statement;
import org.xvm.compiler.ast.StatementBlock;
import org.xvm.util.Handy;
import org.xvm.util.Severity;

public class ForStatement
extends ConditionalStatement
implements LabelAble {
    protected List<Statement> init;
    protected List<Statement> update;
    protected StatementBlock block;
    private transient Label m_labelContinue;
    private transient Context m_ctxLabelVars;
    private transient ErrorListener m_errsLabelVars;
    private transient Register m_regFirst;
    private transient Register m_regCount;
    private transient List<Statement.Break> m_listContinues;
    private transient List<Statement.Break> m_listShorts;
    private transient Label[] m_alabelInitGround;
    private transient Label[] m_alabelUpdateGround;
    private static final Field[] CHILD_FIELDS = ForStatement.fieldsForNames(ForStatement.class, "init", "conds", "update", "block");

    public ForStatement(Token keyword, List<Statement> init, List<AstNode> conds, List<Statement> update, StatementBlock block) {
        super(keyword, conds);
        this.init = init == null ? Collections.emptyList() : init;
        this.update = update == null ? Collections.emptyList() : update;
        this.block = block;
    }

    @Override
    public boolean isNaturalGotoStatementTarget() {
        return true;
    }

    @Override
    public Label ensureContinueLabel(AstNode nodeOrigin, Context ctxOrigin) {
        Context ctxDest = this.ensureValidationContext();
        Label label = this.getContinueLabel();
        if (ctxOrigin.isReachable()) {
            HashMap<String, Assignment> mapAsn = new HashMap<String, Assignment>();
            HashMap<String, Argument> mapArg = new HashMap<String, Argument>();
            ctxOrigin.prepareJump(ctxDest, mapAsn, mapArg);
            if (this.m_listContinues == null) {
                this.m_listContinues = new ArrayList<Statement.Break>();
            }
            this.m_listContinues.add(new Statement.Break(nodeOrigin, mapAsn, mapArg, label));
        }
        return label;
    }

    public boolean hasContinueLabel() {
        return this.m_labelContinue != null;
    }

    public Label getContinueLabel() {
        Label label = this.m_labelContinue;
        if (label == null) {
            this.m_labelContinue = label = new Label("continue_for_" + this.getLabelId());
        }
        return label;
    }

    @Override
    protected boolean allowsShortCircuit(AstNode nodeChild) {
        return this.findInitializer(nodeChild) >= 0 || this.findCondition(nodeChild) >= 0 || this.findUpdate(nodeChild) >= 0;
    }

    @Override
    protected Label ensureShortCircuitLabel(AstNode nodeOrigin, Context ctxOrigin) {
        Label[] labels;
        String desc;
        int count;
        boolean fInit;
        AstNode nodeChild = this.findChild(nodeOrigin);
        assert (nodeChild != null);
        assert (this.allowsShortCircuit(nodeChild));
        if (this.findCondition(nodeChild) >= 0) {
            return this.ensureBreakLabel(nodeOrigin, ctxOrigin);
        }
        int index = this.findInitializer(nodeChild);
        boolean bl = fInit = index >= 0;
        if (fInit) {
            count = this.init.size();
            desc = "init";
        } else {
            index = this.findUpdate(nodeChild);
            count = this.update.size();
            desc = "update";
            assert (index >= 0);
        }
        if (ctxOrigin.isReachable()) {
            Context ctxDest = this.ensureValidationContext();
            if (this.m_listShorts == null) {
                this.m_listShorts = new ArrayList<Statement.Break>();
            }
            HashMap<String, Assignment> mapAsn = new HashMap<String, Assignment>();
            HashMap<String, Argument> mapArg = new HashMap<String, Argument>();
            ctxOrigin.prepareJump(ctxDest, mapAsn, mapArg);
            this.m_listShorts.add(new Statement.Break(nodeOrigin, mapAsn, mapArg, null));
        }
        Label label = new Label("ground_" + desc + "_" + index + "_of_" + count + "_for_" + this.getLabelId());
        Label[] labelArray = labels = fInit ? this.m_alabelInitGround : this.m_alabelUpdateGround;
        if (labels == null) {
            labels = new Label[count];
            if (fInit) {
                this.m_alabelInitGround = labels;
            } else {
                this.m_alabelUpdateGround = labels;
            }
        }
        labels[index] = label;
        return label;
    }

    protected int findInitializer(AstNode node) {
        if (node instanceof Statement) {
            int c = this.init.size();
            for (int i = 0; i < c; ++i) {
                if (node != this.init.get(i)) continue;
                return i;
            }
        }
        return -1;
    }

    protected int findUpdate(AstNode node) {
        if (node instanceof Statement) {
            int c = this.update.size();
            for (int i = 0; i < c; ++i) {
                if (node != this.update.get(i)) continue;
                return i;
            }
        }
        return -1;
    }

    @Override
    public long getEndPosition() {
        return this.block.getEndPosition();
    }

    @Override
    protected Field[] getChildFields() {
        return CHILD_FIELDS;
    }

    @Override
    public boolean hasLabelVar(String sName) {
        return "first".equals(sName) || "count".equals(sName);
    }

    @Override
    public Register getLabelVar(Context ctx, String sName) {
        Register reg;
        assert (this.hasLabelVar(sName));
        boolean fFirst = "first".equals(sName);
        Register register = reg = fFirst ? this.m_regFirst : this.m_regCount;
        if (reg == null) {
            assert (this.m_ctxLabelVars != null);
            String sLabel = ((LabeledStatement)this.getParent()).getName();
            Token tok = new Token(this.keyword.getStartPosition(), this.keyword.getEndPosition(), Token.Id.IDENTIFIER, sLabel + "." + sName);
            reg = ctx.createRegister(fFirst ? this.pool().typeBoolean() : this.pool().typeInt64(), sLabel + "." + sName);
            this.m_ctxLabelVars.registerVar(tok, reg, this.m_errsLabelVars);
            if (fFirst) {
                this.m_regFirst = reg;
            } else {
                this.m_regCount = reg;
            }
        }
        return reg;
    }

    @Override
    protected Statement validateImpl(Context ctx, ErrorListener errs) {
        boolean fAlwaysTrue;
        boolean fValid;
        StatementBlock blockOrig;
        List<Statement> updateOrig;
        List condsOrig;
        boolean fValidInit;
        block38: {
            fValidInit = true;
            ctx = ctx.enter();
            List<Statement> listInit = this.init;
            int cInit = listInit.size();
            for (int i = 0; i < cInit; ++i) {
                Statement stmtOld = listInit.get(i);
                Statement stmtNew = stmtOld.validate(ctx, errs);
                if (stmtNew == null) {
                    fValidInit = false;
                } else if (stmtNew != stmtOld) {
                    listInit.set(i, stmtNew);
                }
                if (this.m_listShorts == null) continue;
                boolean fContinues = false;
                for (Statement.Break shortInfo : this.m_listShorts) {
                    if (shortInfo.node().isDiscarded()) continue;
                    ctx.merge(shortInfo.mapAssign(), shortInfo.mapNarrow());
                    fContinues = true;
                }
                if (fContinues) {
                    ctx.setReachable(true);
                }
                this.m_listShorts = null;
            }
            ErrorListener errsOrig = errs;
            Context ctxOrig = ctx;
            HashMap<String, Assignment> mapLoopAsn = new HashMap<String, Assignment>();
            HashMap<String, Argument> mapLoopArg = new HashMap<String, Argument>();
            int cConds = this.getConditionCount();
            int cUpdates = this.update.size();
            condsOrig = this.conds;
            updateOrig = this.update;
            blockOrig = this.block;
            int cTries = 0;
            while (true) {
                fValid = true;
                this.conds = new ArrayList(cConds);
                for (AstNode cond : condsOrig) {
                    this.conds.add(cond.clone());
                }
                this.update = new ArrayList<Statement>(cUpdates);
                for (Statement stmt : updateOrig) {
                    this.update.add((Statement)stmt.clone());
                }
                this.block = (StatementBlock)blockOrig.clone();
                errs = errsOrig.branch(this);
                ctx = ctxOrig.enter();
                ctx.merge(mapLoopAsn, mapLoopArg);
                ctx.setReachable(true);
                this.m_ctxLabelVars = ctx;
                this.m_errsLabelVars = errs;
                ctx = ctx.enterIf();
                fAlwaysTrue = cConds == 0;
                for (int i = 0; i < cConds; ++i) {
                    Expression expr;
                    AstNode cond = this.getCondition(i);
                    if (cond instanceof AssignmentStatement) {
                        AssignmentStatement stmtOld = (AssignmentStatement)cond;
                        if (stmtOld.isNegated()) {
                            ctx = ctx.enterNot();
                        }
                        AssignmentStatement stmtNew = (AssignmentStatement)stmtOld.validate(ctx, errs);
                        if (stmtOld.isNegated()) {
                            ctx = ctx.exit();
                        }
                        if (stmtNew == null) {
                            fValid = false;
                            continue;
                        }
                        if (stmtNew == stmtOld) continue;
                        cond = stmtNew;
                        this.conds.set(i, cond);
                        continue;
                    }
                    Expression exprOld = (Expression)cond;
                    Expression exprNew = exprOld.validate(ctx, this.pool().typeBoolean(), errs);
                    if (exprNew == null) {
                        fValid = false;
                    } else if (exprNew != exprOld) {
                        cond = exprNew;
                        this.conds.set(i, cond);
                    }
                    fAlwaysTrue = cond instanceof Expression && (expr = (Expression)cond).isConstantTrue();
                }
                if (fAlwaysTrue) {
                    if (this.init.isEmpty() && cConds == 0 && cUpdates == 0 && this.block.getStatements().isEmpty()) {
                        this.log(errs, Severity.ERROR, "COMPILER-155", new Object[0]);
                        return null;
                    }
                    ctx = ctx.enterInfiniteLoop();
                } else {
                    ctx = ctx.enterFork(true);
                }
                StatementBlock blockOld = this.block;
                StatementBlock blockNew = (StatementBlock)blockOld.validate(ctx, errs);
                if (blockNew != blockOld) {
                    if (blockNew == null) {
                        fValid = false;
                    } else {
                        this.block = blockNew;
                    }
                }
                if (this.m_listContinues != null) {
                    boolean fContinues = false;
                    for (Statement.Break continueInfo : this.m_listContinues) {
                        if (continueInfo.node().isDiscarded()) continue;
                        ctx.merge(continueInfo.mapAssign(), continueInfo.mapNarrow());
                        fContinues = true;
                    }
                    if (fContinues) {
                        ctx.setReachable(true);
                    }
                    this.m_listContinues = null;
                }
                List<Statement> listUpdate = this.update;
                for (int i = 0; i < cUpdates; ++i) {
                    Statement stmtOld = listUpdate.get(i);
                    Statement stmtNew = stmtOld.validate(ctx, errs);
                    if (stmtNew == null) {
                        fValid = false;
                    } else if (stmtNew != stmtOld) {
                        listUpdate.set(i, stmtNew);
                    }
                    if (this.m_listShorts == null) continue;
                    boolean fContinues = false;
                    for (Statement.Break shortInfo : this.m_listShorts) {
                        if (shortInfo.node().isDiscarded()) continue;
                        ctx.merge(shortInfo.mapAssign(), shortInfo.mapNarrow());
                        fContinues = true;
                    }
                    if (fContinues) {
                        ctx.setReachable(true);
                    }
                    this.m_listShorts = null;
                }
                HashMap<String, Assignment> mapAsnAfter = new HashMap<String, Assignment>();
                HashMap<String, Argument> mapArgAfter = new HashMap<String, Argument>();
                ctx.prepareJump(ctxOrig, mapAsnAfter, mapArgAfter);
                if (mapAsnAfter.equals(mapLoopAsn)) break block38;
                if (++cTries >= 10) break;
                mapLoopAsn = mapAsnAfter;
                mapLoopArg = mapArgAfter;
                for (AstNode cond : this.conds) {
                    cond.discard(true);
                }
                for (Statement stmt : this.update) {
                    stmt.discard(true);
                }
                this.block.discard(true);
            }
            if (!errs.hasSeriousErrors()) {
                this.log(errs, Severity.ERROR, "COMPILER-01", new Object[0]);
            }
            fValid = false;
        }
        for (AstNode cond : condsOrig) {
            cond.discard(true);
        }
        for (Statement stmt : updateOrig) {
            stmt.discard(true);
        }
        blockOrig.discard(true);
        ctx = ctx.exit();
        ctx = ctx.exit();
        ctx = ctx.exit();
        ctx = ctx.exit();
        if (fAlwaysTrue) {
            ctx.setReachable(false);
        }
        this.m_ctxLabelVars = null;
        this.m_errsLabelVars = null;
        errs.merge();
        return fValidInit && fValid ? this : null;
    }

    @Override
    protected boolean emit(Context ctx, boolean fReachable, MethodStructure.Code code, ErrorListener errs) {
        BinaryAST astBody;
        StringConstant name;
        boolean fCompletes = fReachable;
        Register regFirst = this.m_regFirst;
        Register regCount = this.m_regCount;
        Statement.AstHolder holder = ctx.getHolder();
        code.add(new Enter());
        RegAllocAST[] aAllocSpecial = null;
        if (regFirst != null) {
            name = this.pool().ensureStringConstant(((LabeledStatement)this.getParent()).getName() + ".first");
            code.add(new Var_IN(this.m_regFirst, name, this.pool().valTrue()));
            aAllocSpecial = new RegAllocAST[regCount == null ? 1 : 2];
            aAllocSpecial[0] = regFirst.getRegAllocAST();
        }
        if (regCount != null) {
            name = this.pool().ensureStringConstant(((LabeledStatement)this.getParent()).getName() + ".count");
            code.add(new Var_IN(this.m_regCount, name, this.pool().val0()));
            RegAllocAST astCount = regCount.getRegAllocAST();
            if (aAllocSpecial == null) {
                aAllocSpecial = new RegAllocAST[]{astCount};
            } else {
                aAllocSpecial[1] = astCount;
            }
        }
        List<Statement> listInit = this.init;
        int cInit = listInit.size();
        Label[] aInitLabel = this.m_alabelInitGround;
        BinaryAST[] aAstInit = new BinaryAST[cInit];
        for (int i = 0; i < cInit; ++i) {
            Iterator labelGround;
            Statement stmt = listInit.get(i);
            fCompletes = stmt.completes(ctx, fCompletes, code, errs);
            aAstInit[i] = holder.getAst(stmt);
            Iterator iterator = labelGround = aInitLabel == null ? null : aInitLabel[i];
            if (labelGround == null) continue;
            code.add((Op)((Object)labelGround));
        }
        code.add(new Loop());
        boolean fAlwaysTrue = true;
        boolean fAlwaysFalse = !this.conds.isEmpty();
        for (AstNode cond : this.conds) {
            Expression expr;
            if (cond instanceof Expression && (expr = (Expression)cond).isConstant()) {
                if (expr.isConstantFalse()) {
                    fAlwaysTrue = false;
                    break;
                }
                assert (expr.isConstantTrue());
                fAlwaysFalse = false;
                continue;
            }
            fAlwaysTrue = false;
            fAlwaysFalse = false;
            break;
        }
        boolean fBlockReachable = fCompletes;
        ExprAST[] aCondAST = null;
        if (fAlwaysFalse) {
            code.add(new Jump(this.getEndLabel()));
            fBlockReachable = false;
            holder.setAst(this, new StmtBlockAST(aAstInit, false));
        } else if (fAlwaysTrue) {
            aCondAST = BinaryAST.NO_EXPRS;
        } else {
            int cConds = this.getConditionCount();
            aCondAST = new ExprAST[cConds];
            for (int i = 0; i < cConds; ++i) {
                AstNode cond = this.getCondition(i);
                if (cond instanceof AssignmentStatement) {
                    AssignmentStatement stmtCond = (AssignmentStatement)cond;
                    fBlockReachable &= stmtCond.completes(ctx, fCompletes, code, errs);
                    code.add(stmtCond.isNegated() ? new JumpTrue(stmtCond.getConditionRegister(), this.getEndLabel()) : new JumpFalse(stmtCond.getConditionRegister(), this.getEndLabel()));
                    aCondAST[i] = (ExprAST)holder.getAst(stmtCond);
                    continue;
                }
                Expression exprCond = (Expression)cond;
                exprCond.generateConditionalJump(ctx, code, this.getEndLabel(), false, errs);
                fBlockReachable &= exprCond.isCompletable();
                aCondAST[i] = exprCond.getExprAST(ctx);
            }
        }
        Op opLast = null;
        if (fAlwaysTrue) {
            opLast = code.getLastOp();
            this.block.suppressScope();
        }
        fCompletes &= this.block.completes(ctx, fBlockReachable, code, errs) || !fAlwaysTrue;
        BinaryAST binaryAST = astBody = fAlwaysFalse ? null : holder.getAst(this.block);
        if (this.hasContinueLabel()) {
            code.add(this.getContinueLabel());
        }
        List<Statement> listUpdate = this.update;
        int cUpdate = listUpdate.size();
        Label[] aUpdateLabel = this.m_alabelUpdateGround;
        BinaryAST[] aAstUpdate = new BinaryAST[cUpdate];
        for (int i = 0; i < cUpdate; ++i) {
            Label labelGround;
            Statement stmt = listUpdate.get(i);
            fCompletes &= stmt.completes(ctx, fBlockReachable, code, errs) || !fAlwaysTrue;
            if (!fAlwaysFalse) {
                aAstUpdate[i] = holder.getAst(stmt);
            }
            Label label = labelGround = aUpdateLabel == null ? null : aUpdateLabel[i];
            if (labelGround == null) continue;
            code.add(labelGround);
        }
        if (regFirst != null) {
            code.add(new Move(this.pool().valFalse(), regFirst));
        }
        if (regCount != null) {
            code.add(new IP_Inc(regCount));
        }
        if (fAlwaysTrue && code.getLastOp() == opLast) {
            this.log(errs, Severity.ERROR, "COMPILER-155", new Object[0]);
        }
        code.add(new LoopEnd());
        code.add(new Exit());
        if (!fAlwaysFalse) {
            holder.setAst(this, new ForStmtAST(aAllocSpecial, BinaryAST.makeMultiStatement(aAstInit), BinaryAST.makeCondition(aCondAST), BinaryAST.makeMultiStatement(aAstUpdate), astBody));
        }
        return !fAlwaysTrue && fCompletes;
    }

    @Override
    public String toString() {
        boolean first;
        StringBuilder sb = new StringBuilder();
        sb.append("for (");
        if (this.init != null) {
            first = true;
            for (Statement stmt : this.init) {
                if (first) {
                    first = false;
                } else {
                    sb.append(", ");
                }
                sb.append(stmt);
            }
        }
        sb.append("; ");
        if (this.conds != null && !this.conds.isEmpty()) {
            sb.append(this.conds.get(0));
            int c = this.conds.size();
            for (int i = 1; i < c; ++i) {
                sb.append(", ").append(this.conds.get(i));
            }
        }
        sb.append("; ");
        if (this.update != null) {
            first = true;
            for (Statement stmt : this.update) {
                if (first) {
                    first = false;
                } else {
                    sb.append(", ");
                }
                sb.append(stmt);
            }
        }
        sb.append(")\n").append(Handy.indentLines(this.block.toString(), "    "));
        return sb.toString();
    }
}

