/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.compiler.ast;

import java.lang.reflect.Field;
import java.util.List;
import org.xvm.asm.ConstantPool;
import org.xvm.asm.ErrorListener;
import org.xvm.asm.constants.TypeConstant;
import org.xvm.compiler.Token;
import org.xvm.compiler.ast.Context;
import org.xvm.compiler.ast.Expression;
import org.xvm.compiler.ast.Parameter;
import org.xvm.compiler.ast.TypeExpression;
import org.xvm.util.Severity;

public class FunctionTypeExpression
extends TypeExpression {
    protected Token function;
    protected Token conditional;
    protected List<Parameter> returnValues;
    protected List<TypeExpression> paramTypes;
    protected long lEndPos;
    private static final Field[] CHILD_FIELDS = FunctionTypeExpression.fieldsForNames(FunctionTypeExpression.class, "returnValues", "paramTypes");

    public FunctionTypeExpression(Token function, Token conditional, List<Parameter> returnValues, List<TypeExpression> params, long lEndPos) {
        this.function = function;
        this.conditional = conditional;
        this.returnValues = returnValues;
        this.paramTypes = params;
        this.lEndPos = lEndPos;
    }

    public boolean isConditional() {
        return this.conditional != null;
    }

    public List<Parameter> getReturnValues() {
        return this.returnValues;
    }

    public List<TypeExpression> getParamTypes() {
        return this.paramTypes;
    }

    @Override
    public long getStartPosition() {
        return this.function.getStartPosition();
    }

    @Override
    public long getEndPosition() {
        return this.lEndPos;
    }

    @Override
    protected Field[] getChildFields() {
        return CHILD_FIELDS;
    }

    @Override
    protected TypeConstant instantiateTypeConstant(Context ctx, ErrorListener errs) {
        ConstantPool pool = this.pool();
        return pool.ensureClassTypeConstant(pool.clzFunction(), null, this.toTupleType(FunctionTypeExpression.toTypeConstantArray(this.paramTypes)), this.isConditional() ? this.toConditionalTupleType(FunctionTypeExpression.toParamTypeConstantArray(this.returnValues)) : this.toTupleType(FunctionTypeExpression.toParamTypeConstantArray(this.returnValues)));
    }

    @Override
    protected Expression validate(Context ctx, TypeConstant typeRequired, ErrorListener errs) {
        List<TypeExpression> listTypes = this.paramTypes;
        boolean fValid = true;
        int c = listTypes.size();
        for (int i = 0; i < c; ++i) {
            TypeExpression exprOld = listTypes.get(i);
            TypeExpression exprNew = (TypeExpression)exprOld.validate(ctx, null, errs);
            if (exprNew == null) {
                fValid = false;
                continue;
            }
            if (exprNew.isDynamic()) {
                this.log(errs, Severity.ERROR, "COMPILER-136", new Object[0]);
                fValid = false;
            }
            if (exprNew == exprOld) continue;
            listTypes.set(i, exprNew);
        }
        return fValid ? super.validate(ctx, typeRequired, errs) : null;
    }

    private TypeConstant toTupleType(TypeConstant[] atypes) {
        return this.pool().ensureTupleType(atypes);
    }

    private TypeConstant toConditionalTupleType(TypeConstant[] atypes) {
        ConstantPool pool = this.pool();
        int cTypes = atypes.length;
        TypeConstant[] aconstCond = new TypeConstant[cTypes + 1];
        aconstCond[0] = pool.typeBoolean();
        System.arraycopy(atypes, 0, aconstCond, 1, cTypes);
        return pool.ensureParameterizedTypeConstant(pool.typeCondTuple(), aconstCond);
    }

    static TypeConstant[] toTypeConstantArray(List<TypeExpression> list) {
        int c = list.size();
        TypeConstant[] aconst = new TypeConstant[c];
        for (int i = 0; i < c; ++i) {
            aconst[i] = list.get(i).ensureTypeConstant();
        }
        return aconst;
    }

    private static TypeConstant[] toParamTypeConstantArray(List<Parameter> list) {
        int c = list.size();
        TypeConstant[] aconst = new TypeConstant[c];
        for (int i = 0; i < c; ++i) {
            aconst[i] = list.get(i).getType().ensureTypeConstant();
        }
        return aconst;
    }

    @Override
    public String toString() {
        boolean first;
        StringBuilder sb = new StringBuilder();
        sb.append("function ");
        if (this.isConditional()) {
            sb.append("conditional ");
        }
        if (this.returnValues.isEmpty()) {
            sb.append("void");
        } else if (this.returnValues.size() == 1) {
            sb.append(this.returnValues.get(0));
        } else {
            first = true;
            for (Parameter param : this.returnValues) {
                if (first) {
                    first = false;
                } else {
                    sb.append(", ");
                }
                sb.append(param);
            }
        }
        sb.append(" (");
        first = true;
        for (TypeExpression type : this.paramTypes) {
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            sb.append(type);
        }
        sb.append(')');
        return sb.toString();
    }

    @Override
    public String getDumpDesc() {
        return this.toString();
    }
}

