/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.compiler.ast;

import org.xvm.asm.op.Label;
import org.xvm.compiler.Token;
import org.xvm.compiler.ast.AstNode;
import org.xvm.compiler.ast.LabeledStatement;
import org.xvm.compiler.ast.Statement;
import org.xvm.compiler.ast.StatementExpression;

public abstract class GotoStatement
extends Statement {
    protected Token keyword;
    protected Token name;
    protected transient Label m_label;

    public GotoStatement(Token keyword, Token name) {
        this.keyword = keyword;
        this.name = name;
    }

    @Override
    public long getStartPosition() {
        return this.keyword.getStartPosition();
    }

    @Override
    public long getEndPosition() {
        return this.name == null ? this.keyword.getEndPosition() : this.name.getEndPosition();
    }

    public boolean isLabeled() {
        return this.name != null;
    }

    public String getLabeledName() {
        return this.isLabeled() ? this.name.getValueText() : null;
    }

    public Label getJumpLabel() {
        return this.m_label;
    }

    protected void setJumpLabel(Label label) {
        assert (this.m_label == null);
        this.m_label = label;
    }

    protected Statement getTargetStatement() {
        if (this.isLabeled()) {
            String sLabel = this.getLabeledName();
            AstNode node = this.getParent();
            while (true) {
                LabeledStatement stmtLabeled;
                AstNode nodeParent;
                if ((nodeParent = node.getParent()) instanceof LabeledStatement && (stmtLabeled = (LabeledStatement)nodeParent).getName().equals(sLabel)) {
                    return (Statement)node;
                }
                if (nodeParent.isComponentNode() || nodeParent instanceof StatementExpression) {
                    return null;
                }
                node = nodeParent;
            }
        }
        AstNode node = this.getParent();
        while (true) {
            if (node instanceof Statement) {
                Statement stmt = (Statement)node;
                if (stmt.isNaturalGotoStatementTarget()) {
                    return stmt;
                }
                if (stmt.isComponentNode()) {
                    return null;
                }
            }
            node = node.getParent();
        }
    }

    protected int getTargetDepth() {
        if (!this.isLabeled()) {
            return 0;
        }
        int nDepth = 0;
        String sLabel = this.getLabeledName();
        AstNode node = this.getParent();
        LabeledStatement stmtLabeled;
        AstNode nodeParent;
        while (!((nodeParent = node.getParent()) instanceof LabeledStatement) || !(stmtLabeled = (LabeledStatement)nodeParent).getName().equals(sLabel)) {
            Statement stmt;
            if (node instanceof Statement && (stmt = (Statement)node).isNaturalGotoStatementTarget()) {
                ++nDepth;
            }
            if (nodeParent.isComponentNode() || nodeParent instanceof StatementExpression) {
                return -1;
            }
            node = nodeParent;
        }
        return nDepth;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.keyword.getId().TEXT);
        if (this.name != null) {
            sb.append(' ').append(this.name.getValue());
        }
        sb.append(';');
        return sb.toString();
    }

    @Override
    public String getDumpDesc() {
        return this.toString();
    }
}

