/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.compiler.ast;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.xvm.asm.Argument;
import org.xvm.asm.Assignment;
import org.xvm.asm.ErrorListener;
import org.xvm.asm.MethodStructure;
import org.xvm.asm.ast.AssignAST;
import org.xvm.asm.ast.BinaryAST;
import org.xvm.asm.ast.ExprAST;
import org.xvm.asm.ast.IfStmtAST;
import org.xvm.asm.ast.MultiExprAST;
import org.xvm.asm.op.Enter;
import org.xvm.asm.op.Exit;
import org.xvm.asm.op.Jump;
import org.xvm.asm.op.JumpFalse;
import org.xvm.asm.op.JumpTrue;
import org.xvm.asm.op.Label;
import org.xvm.compiler.Token;
import org.xvm.compiler.ast.AssignmentStatement;
import org.xvm.compiler.ast.AstNode;
import org.xvm.compiler.ast.ConditionalStatement;
import org.xvm.compiler.ast.Context;
import org.xvm.compiler.ast.Expression;
import org.xvm.compiler.ast.Statement;
import org.xvm.compiler.ast.StatementBlock;
import org.xvm.util.Handy;

public class IfStatement
extends ConditionalStatement {
    protected Statement stmtThen;
    protected Statement stmtElse;
    private transient Label m_labelElse;
    private transient List<Statement.Break> m_listShorts;
    private static final Field[] CHILD_FIELDS = IfStatement.fieldsForNames(IfStatement.class, "conds", "stmtThen", "stmtElse");

    public IfStatement(Token keyword, List<AstNode> conds, StatementBlock block) {
        this(keyword, conds, block, null);
    }

    public IfStatement(Token keyword, List<AstNode> conds, StatementBlock stmtThen, Statement stmtElse) {
        super(keyword, conds);
        this.stmtThen = stmtThen;
        this.stmtElse = stmtElse;
    }

    @Override
    public long getEndPosition() {
        return this.stmtElse == null ? this.stmtThen.getEndPosition() : this.stmtElse.getEndPosition();
    }

    public Label getElseLabel() {
        Label label = this.m_labelElse;
        if (label == null) {
            this.m_labelElse = label = new Label("else_if_" + this.getLabelId());
        }
        return label;
    }

    @Override
    protected Label ensureShortCircuitLabel(AstNode nodeOrigin, Context ctxOrigin) {
        if (this.stmtElse == null) {
            return this.ensureBreakLabel(nodeOrigin, ctxOrigin);
        }
        AstNode nodeChild = this.findChild(nodeOrigin);
        assert (nodeChild != null);
        assert (this.allowsShortCircuit(nodeChild));
        Context ctxDest = this.ensureValidationContext();
        Label label = this.getElseLabel();
        if (ctxOrigin.isReachable()) {
            if (this.m_listShorts == null) {
                this.m_listShorts = new ArrayList<Statement.Break>();
            }
            HashMap<String, Assignment> mapAsn = new HashMap<String, Assignment>();
            HashMap<String, Argument> mapArg = new HashMap<String, Argument>();
            ctxOrigin.prepareJump(ctxDest, mapAsn, mapArg);
            this.m_listShorts.add(new Statement.Break(nodeOrigin, mapAsn, mapArg, label));
        }
        return label;
    }

    @Override
    protected Field[] getChildFields() {
        return CHILD_FIELDS;
    }

    @Override
    protected Statement validateImpl(Context ctx, ErrorListener errs) {
        boolean fValid = true;
        ctx = ctx.enterIf();
        int cConditions = this.getConditionCount();
        for (int i = 0; i < cConditions; ++i) {
            AstNode cond = this.getCondition(i);
            if (i > 0) {
                ctx = ctx.enterAndIf();
            }
            if (cond instanceof AssignmentStatement) {
                AssignmentStatement stmtOld = (AssignmentStatement)cond;
                if (stmtOld.isNegated()) {
                    ctx = ctx.enterNot();
                }
                AssignmentStatement stmtNew = (AssignmentStatement)stmtOld.validate(ctx, errs);
                if (stmtOld.isNegated()) {
                    ctx = ctx.exit();
                }
                if (stmtNew == null) {
                    fValid = false;
                    continue;
                }
                if (stmtNew == stmtOld) continue;
                cond = stmtNew;
                this.conds.set(i, cond);
                continue;
            }
            Expression exprOld = (Expression)cond;
            Expression exprNew = exprOld.validate(ctx, this.pool().typeBoolean(), errs);
            if (exprNew == null) {
                fValid = false;
                continue;
            }
            if (exprNew == exprOld) continue;
            cond = exprNew;
            this.conds.set(i, cond);
        }
        ctx = ctx.enterFork(true);
        Statement stmtThenNew = this.stmtThen.validate(ctx, errs);
        ctx = ctx.exit();
        if (stmtThenNew == null) {
            fValid = false;
        } else {
            this.stmtThen = stmtThenNew;
        }
        while (--cConditions > 0) {
            ctx = ctx.exit();
        }
        ctx = ctx.enterFork(false);
        if (this.stmtElse != null) {
            Statement stmtElseNew;
            if (this.m_listShorts != null) {
                boolean fContinues = false;
                for (Statement.Break shortInfo : this.m_listShorts) {
                    if (shortInfo.node().isDiscarded()) continue;
                    ctx.merge(shortInfo.mapAssign(), shortInfo.mapNarrow());
                    fContinues = true;
                }
                if (fContinues) {
                    ctx.setReachable(true);
                }
            }
            if ((stmtElseNew = this.stmtElse.validate(ctx, errs)) == null) {
                fValid = false;
            } else {
                this.stmtElse = stmtElseNew;
            }
        }
        ctx = ctx.exit();
        ctx = ctx.exit();
        return fValid ? this : null;
    }

    @Override
    protected boolean emit(Context ctx, boolean fReachable, MethodStructure.Code code, ErrorListener errs) {
        boolean fAlwaysTrue = true;
        for (AstNode cond : this.conds) {
            if (cond instanceof Expression && ((Expression)cond).isConstant()) {
                if (((Expression)cond).isConstantFalse()) {
                    if (this.stmtElse == null) {
                        ctx.getHolder().setAst(this, new MultiExprAST(BinaryAST.NO_EXPRS));
                        return fReachable;
                    }
                    boolean fCompletes = this.stmtElse.completes(ctx, fReachable, code, errs);
                    ctx.getHolder().setAst(this, ctx.getHolder().getAst(this.stmtElse));
                    return fCompletes;
                }
                assert (((Expression)cond).isConstantTrue());
                continue;
            }
            fAlwaysTrue = false;
            break;
        }
        if (fAlwaysTrue) {
            boolean fCompletes = this.stmtThen.completes(ctx, fReachable, code, errs);
            ctx.getHolder().setAst(this, ctx.getHolder().getAst(this.stmtThen));
            return fCompletes;
        }
        Label labelElse = this.getElseLabel();
        Label labelExit = new Label(this.getCodeContainerCounter());
        boolean fScope = false;
        for (AstNode cond : this.conds) {
            if (!(cond instanceof AssignmentStatement) || !((AssignmentStatement)cond).hasDeclarations()) continue;
            code.add(new Enter());
            fScope = true;
            break;
        }
        ArrayList<ExprAST> listExprs = new ArrayList<ExprAST>();
        boolean fFirst = true;
        boolean fReachesThen = fReachable;
        boolean fReachesElse = fReachable;
        for (AstNode cond : this.conds) {
            boolean fCompletes;
            if (cond instanceof AssignmentStatement) {
                AssignmentStatement stmtCond = (AssignmentStatement)cond;
                fCompletes = stmtCond.completes(ctx, fReachable, code, errs);
                if (stmtCond.isNegated()) {
                    code.add(new JumpTrue(stmtCond.getConditionRegister(), labelElse));
                } else {
                    code.add(new JumpFalse(stmtCond.getConditionRegister(), labelElse));
                }
                listExprs.add((AssignAST)ctx.getHolder().getAst(stmtCond));
            } else {
                Expression exprCond = (Expression)cond;
                if (exprCond.isConstantTrue()) continue;
                if (exprCond.isConstantFalse()) {
                    fReachesThen = false;
                    code.add(new Jump(labelElse));
                    listExprs.add(exprCond.getExprAST(ctx));
                    break;
                }
                fCompletes = exprCond.isCompletable();
                exprCond.generateConditionalJump(ctx, code, labelElse, false, errs);
                listExprs.add(exprCond.getExprAST(ctx));
            }
            fReachesThen &= fCompletes;
            if (fFirst) {
                fReachesElse &= fCompletes;
            }
            fFirst = false;
        }
        ExprAST bastCond = listExprs.size() == 1 ? (ExprAST)listExprs.get(0) : new MultiExprAST(listExprs.toArray(new ExprAST[0]));
        BinaryAST bastThen = null;
        boolean fCompletesThen = fReachesThen;
        if (fReachesThen) {
            fCompletesThen = this.stmtThen.completes(ctx, fReachesThen, code, errs);
            bastThen = ctx.getHolder().getAst(this.stmtThen);
            if (this.stmtElse != null) {
                code.add(new Jump(labelExit));
            }
        }
        BinaryAST bastElse = null;
        boolean fCompletesElse = fReachesElse;
        code.add(labelElse);
        if (fReachesElse && this.stmtElse != null) {
            fCompletesElse = this.stmtElse.completes(ctx, fReachesElse, code, errs);
            bastElse = ctx.getHolder().getAst(this.stmtElse);
        }
        code.add(labelExit);
        if (fScope) {
            code.add(new Exit());
        }
        ctx.getHolder().setAst(this, new IfStmtAST(bastCond, bastThen, bastElse));
        return fCompletesThen | fCompletesElse;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("if (").append(this.conds.get(0));
        int c = this.conds.size();
        for (int i = 1; i < c; ++i) {
            sb.append(", ").append(this.conds.get(i));
        }
        sb.append(")\n").append(Handy.indentLines(this.stmtThen.toString(), "    "));
        if (this.stmtElse != null) {
            if (this.stmtElse instanceof IfStatement) {
                sb.append("\nelse ").append(this.stmtElse);
            } else {
                sb.append("\nelse\n").append(Handy.indentLines(this.stmtElse.toString(), "    "));
            }
        }
        return sb.toString();
    }
}

