/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.compiler.ast;

import java.util.Collections;
import java.util.Map;
import org.xvm.asm.Argument;
import org.xvm.asm.ErrorListener;
import org.xvm.asm.MethodStructure;
import org.xvm.asm.ast.ExprAST;
import org.xvm.asm.ast.RegisterAST;
import org.xvm.asm.constants.TypeConstant;
import org.xvm.compiler.Token;
import org.xvm.compiler.ast.BadTypeExpression;
import org.xvm.compiler.ast.Context;
import org.xvm.compiler.ast.Expression;
import org.xvm.compiler.ast.NameExpression;
import org.xvm.compiler.ast.TypeExpression;

public class IgnoredNameExpression
extends NameExpression {
    public IgnoredNameExpression(Token name) {
        super(name);
    }

    @Override
    public TypeExpression toTypeExpression() {
        return new BadTypeExpression(this);
    }

    @Override
    public TypeConstant getImplicitType(Context ctx) {
        return this.pool().typeObject();
    }

    @Override
    public Expression.TypeFit testFit(Context ctx, TypeConstant typeRequired, boolean fExhaustive, ErrorListener errs) {
        return Expression.TypeFit.Fit;
    }

    @Override
    protected Expression validate(Context ctx, TypeConstant typeRequired, ErrorListener errs) {
        TypeConstant type = typeRequired == null ? this.pool().typeObject() : typeRequired;
        return this.finishValidation(ctx, type, type, Expression.TypeFit.Fit, this.pool().ensureMatchAnyConstant(type), errs);
    }

    @Override
    public boolean isAssignable(Context ctx) {
        return true;
    }

    @Override
    public Expression.Assignable generateAssignable(Context ctx, MethodStructure.Code code, ErrorListener errs) {
        return new Expression.Assignable();
    }

    @Override
    public Argument generateArgument(Context ctx, MethodStructure.Code code, boolean fLocalPropOk, boolean fUsedOnce, ErrorListener errs) {
        return this.generateBlackHole(null);
    }

    @Override
    public ExprAST getExprAST(Context ctx) {
        return new RegisterAST(-2, this.pool().typeObject(), null);
    }

    @Override
    protected Expression.SideEffect mightAffect(Expression exprLeft, Argument arg) {
        return Expression.SideEffect.DefNo;
    }

    @Override
    public String toString() {
        return "_";
    }

    @Override
    public String getDumpDesc() {
        return this.toString();
    }

    @Override
    public Map<String, Object> getDumpChildren() {
        return Collections.emptyMap();
    }
}

