/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.compiler.ast;

import java.lang.reflect.Field;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.xvm.asm.ErrorListener;
import org.xvm.asm.MethodStructure;
import org.xvm.asm.constants.IdentityConstant;
import org.xvm.compiler.Compiler;
import org.xvm.compiler.Token;
import org.xvm.compiler.ast.AstNode;
import org.xvm.compiler.ast.Context;
import org.xvm.compiler.ast.Expression;
import org.xvm.compiler.ast.NameResolver;
import org.xvm.compiler.ast.StageMgr;
import org.xvm.compiler.ast.Statement;
import org.xvm.util.Severity;

public class ImportStatement
extends Statement
implements NameResolver.NameResolving {
    protected Expression cond;
    protected Token keyword;
    protected Token alias;
    protected List<Token> qualifiedName;
    protected Token star;
    private transient NameResolver m_resolver;
    private transient boolean m_fImportRegistered;
    private static final Field[] CHILD_FIELDS = ImportStatement.fieldsForNames(ImportStatement.class, "cond");

    public ImportStatement(Expression cond, Token keyword, Token alias, List<Token> qualifiedName) {
        assert (alias != null);
        this.cond = cond;
        this.keyword = keyword;
        this.alias = alias;
        this.qualifiedName = qualifiedName;
    }

    public ImportStatement(Expression cond, Token keyword, List<Token> qualifiedName, Token star) {
        assert (star != null);
        this.cond = cond;
        this.keyword = keyword;
        this.qualifiedName = qualifiedName;
        this.star = star;
    }

    public String getAliasName() {
        return this.alias == null ? null : this.alias.getValueText();
    }

    public boolean isWildcard() {
        return this.star != null;
    }

    public int getQualifiedNameLength() {
        return this.qualifiedName.size();
    }

    public String getQualifiedNamePart(int i) {
        return (String)this.qualifiedName.get(i).getValue();
    }

    public String[] getQualifiedName() {
        int cNames = this.getQualifiedNameLength();
        String[] asName = new String[cNames];
        for (int i = 0; i < cNames; ++i) {
            asName[i] = this.getQualifiedNamePart(i);
        }
        return asName;
    }

    public String getQualifiedNameString() {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (Token name : this.qualifiedName) {
            if (first) {
                first = false;
            } else {
                sb.append('.');
            }
            sb.append(name.getValueText());
        }
        return sb.toString();
    }

    @Override
    public long getStartPosition() {
        return this.keyword.getStartPosition();
    }

    @Override
    public long getEndPosition() {
        return (this.alias == null ? this.star : this.alias).getEndPosition();
    }

    @Override
    protected Field[] getChildFields() {
        return CHILD_FIELDS;
    }

    @Override
    public NameResolver getNameResolver() {
        NameResolver resolver = this.m_resolver;
        if (resolver == null || resolver.getNode() != this) {
            Iterator<String> iter = this.star == null ? this.qualifiedName.stream().map(t -> (String)t.getValue()).iterator() : this.qualifiedName.stream().map(t -> (String)t.getValue()).filter(Objects::nonNull).iterator();
            this.m_resolver = resolver = new NameResolver((AstNode)this, iter);
        }
        return resolver;
    }

    @Override
    protected void registerStructures(StageMgr mgr, ErrorListener errs) {
        if (this.cond != null) {
            this.log(errs, Severity.WARNING, "COMPILER-29", new Object[0]);
        }
    }

    @Override
    public void resolveNames(StageMgr mgr, ErrorListener errs) {
        this.setStage(Compiler.Stage.Resolving);
        if (!this.m_fImportRegistered) {
            this.getParentBlock().registerImport(this, errs);
            this.m_fImportRegistered = true;
        }
        NameResolver resolver = this.getNameResolver();
        switch (resolver.resolve(errs)) {
            case DEFERRED: {
                mgr.requestRevisit();
                return;
            }
            case RESOLVED: {
                if (resolver.getConstant() instanceof IdentityConstant) break;
                this.log(errs, Severity.ERROR, "COMPILER-106", this.getQualifiedNameString());
            }
        }
    }

    @Override
    protected Statement validateImpl(Context ctx, ErrorListener errs) {
        String sName = this.getAliasName();
        if (sName != null) {
            if (ctx.getVar(sName) != null && !ctx.isVarHideable(sName)) {
                this.log(errs, Severity.ERROR, "COMPILER-105", sName);
            } else {
                NameResolver resolver = this.getNameResolver();
                if (resolver.getResult() != NameResolver.Result.RESOLVED && resolver.resolve(errs) != NameResolver.Result.RESOLVED) {
                    return null;
                }
            }
        }
        return this;
    }

    @Override
    protected boolean emit(Context ctx, boolean fReachable, MethodStructure.Code code, ErrorListener errs) {
        return fReachable;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.cond != null) {
            sb.append("if (").append(this.cond).append(") { ");
        }
        sb.append("import ");
        boolean first = true;
        String last = null;
        for (Token name : this.qualifiedName) {
            if (first) {
                first = false;
            } else {
                sb.append('.');
            }
            last = String.valueOf(name.getValue());
            sb.append(last);
        }
        if (this.alias != null && !last.equals(this.alias.getValue())) {
            sb.append(" as ").append(this.alias.getValue());
        } else if (this.star != null) {
            sb.append(".*");
        }
        sb.append(';');
        if (this.cond != null) {
            sb.append(" }");
        }
        return sb.toString();
    }
}

