/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.compiler.ast;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.xvm.asm.Argument;
import org.xvm.asm.ClassStructure;
import org.xvm.asm.Component;
import org.xvm.asm.Constant;
import org.xvm.asm.ConstantPool;
import org.xvm.asm.Constants;
import org.xvm.asm.ErrorListener;
import org.xvm.asm.GenericTypeResolver;
import org.xvm.asm.MethodStructure;
import org.xvm.asm.PropertyStructure;
import org.xvm.asm.Register;
import org.xvm.asm.Version;
import org.xvm.asm.ast.BinaryAST;
import org.xvm.asm.ast.BindFunctionAST;
import org.xvm.asm.ast.BindMethodAST;
import org.xvm.asm.ast.CallExprAST;
import org.xvm.asm.ast.ConstantExprAST;
import org.xvm.asm.ast.ConvertExprAST;
import org.xvm.asm.ast.ExprAST;
import org.xvm.asm.ast.InvokeExprAST;
import org.xvm.asm.ast.OuterExprAST;
import org.xvm.asm.ast.RegisterAST;
import org.xvm.asm.ast.TupleExprAST;
import org.xvm.asm.constants.ConditionalConstant;
import org.xvm.asm.constants.FormalConstant;
import org.xvm.asm.constants.FormalTypeChildConstant;
import org.xvm.asm.constants.IdentityConstant;
import org.xvm.asm.constants.MethodConstant;
import org.xvm.asm.constants.MethodInfo;
import org.xvm.asm.constants.MultiMethodConstant;
import org.xvm.asm.constants.NamedConstant;
import org.xvm.asm.constants.PendingTypeConstant;
import org.xvm.asm.constants.PropertyConstant;
import org.xvm.asm.constants.PropertyInfo;
import org.xvm.asm.constants.SignatureConstant;
import org.xvm.asm.constants.TypeConstant;
import org.xvm.asm.constants.TypeInfo;
import org.xvm.asm.op.Call_00;
import org.xvm.asm.op.Call_01;
import org.xvm.asm.op.Call_0N;
import org.xvm.asm.op.Call_0T;
import org.xvm.asm.op.Call_10;
import org.xvm.asm.op.Call_11;
import org.xvm.asm.op.Call_1N;
import org.xvm.asm.op.Call_1T;
import org.xvm.asm.op.Call_N0;
import org.xvm.asm.op.Call_N1;
import org.xvm.asm.op.Call_NN;
import org.xvm.asm.op.Call_NT;
import org.xvm.asm.op.Call_T0;
import org.xvm.asm.op.Call_T1;
import org.xvm.asm.op.Call_TN;
import org.xvm.asm.op.Call_TT;
import org.xvm.asm.op.Construct_0;
import org.xvm.asm.op.Construct_1;
import org.xvm.asm.op.Construct_N;
import org.xvm.asm.op.FBind;
import org.xvm.asm.op.Invoke_00;
import org.xvm.asm.op.Invoke_01;
import org.xvm.asm.op.Invoke_0N;
import org.xvm.asm.op.Invoke_0T;
import org.xvm.asm.op.Invoke_10;
import org.xvm.asm.op.Invoke_11;
import org.xvm.asm.op.Invoke_1N;
import org.xvm.asm.op.Invoke_1T;
import org.xvm.asm.op.Invoke_N0;
import org.xvm.asm.op.Invoke_N1;
import org.xvm.asm.op.Invoke_NN;
import org.xvm.asm.op.Invoke_NT;
import org.xvm.asm.op.Invoke_T0;
import org.xvm.asm.op.Invoke_T1;
import org.xvm.asm.op.Invoke_TN;
import org.xvm.asm.op.Invoke_TT;
import org.xvm.asm.op.MBind;
import org.xvm.asm.op.Move;
import org.xvm.asm.op.MoveThis;
import org.xvm.asm.op.MoveVar;
import org.xvm.asm.op.Var_D;
import org.xvm.compiler.Source;
import org.xvm.compiler.Token;
import org.xvm.compiler.ast.AstNode;
import org.xvm.compiler.ast.Context;
import org.xvm.compiler.ast.Expression;
import org.xvm.compiler.ast.LiteralExpression;
import org.xvm.compiler.ast.NameExpression;
import org.xvm.compiler.ast.ReturnStatement;
import org.xvm.compiler.ast.StatementBlock;
import org.xvm.compiler.ast.TraceExpression;
import org.xvm.compiler.ast.TypeExpression;
import org.xvm.util.ListMap;
import org.xvm.util.Severity;

public class InvocationExpression
extends Expression {
    static final int _00 = 12336;
    static final int _01 = 12337;
    static final int _0N = 12366;
    static final int _10 = 12592;
    static final int _11 = 12593;
    static final int _1N = 12622;
    static final int _N0 = 20016;
    static final int _N1 = 20017;
    static final int _NN = 20046;
    protected Expression expr;
    protected boolean async;
    protected List<Expression> args;
    protected long lEndPos;
    private transient boolean m_fBindTarget;
    private transient boolean m_fBindParams;
    private transient boolean m_fCall;
    private transient boolean m_fTupleArg;
    private transient boolean m_fNamedArgs;
    private transient StatementBlock.TargetInfo m_targetInfo;
    private transient Argument m_argMethod;
    private transient MethodStructure m_method;
    private transient TypeConstant m_typeTarget;
    private transient boolean m_fCondResult;
    private transient boolean m_fBjarne;
    private transient boolean m_fPack;
    private transient FormalConstant m_idFormal;
    private transient Argument[] m_aargTypeParams;
    private transient MethodConstant m_idConvert;
    private transient boolean m_fAutoFuture;
    private transient ExprAST m_astTarget;
    private transient ExprAST m_astInvoke;
    private static final Field[] CHILD_FIELDS = InvocationExpression.fieldsForNames(InvocationExpression.class, "expr", "args");

    public InvocationExpression(Expression expr, boolean async, List<Expression> args, long lEndPos) {
        this.expr = expr;
        this.async = async;
        this.args = args;
        this.lEndPos = lEndPos;
    }

    public boolean isAsync() {
        return this.async;
    }

    @Override
    public boolean validateCondition(ErrorListener errs) {
        LiteralExpression argLit;
        NameExpression exprName;
        Expression expression = this.expr;
        return expression instanceof NameExpression && "versionMatches".equals((exprName = (NameExpression)expression).getName()) && this.args.size() == 1 && (expression = this.args.get(0)) instanceof LiteralExpression && (argLit = (LiteralExpression)expression).getLiteral().getId() == Token.Id.LIT_VERSION && exprName.getLeftExpression() != null && exprName.isOnlyNames() || super.validateCondition(errs);
    }

    @Override
    public ConditionalConstant toConditionalConstant() {
        if (this.validateCondition(null)) {
            StringBuilder sb = new StringBuilder();
            List<Token> names = ((NameExpression)this.expr).getNameTokens();
            int c = names.size() - 1;
            for (int i = 0; i < c; ++i) {
                if (i > 0) {
                    sb.append('.');
                }
                sb.append(names.get(i).getValueText());
            }
            ConstantPool pool = this.pool();
            String sModule = sb.toString();
            Version version = ((LiteralExpression)this.args.get(0)).getVersion();
            return pool.ensureImportVersionCondition(pool.ensureModuleConstant(sModule), pool.ensureVersionConstant(version));
        }
        return super.toConditionalConstant();
    }

    @Override
    public long getStartPosition() {
        return this.expr.getStartPosition();
    }

    @Override
    public long getEndPosition() {
        return this.lEndPos;
    }

    @Override
    protected void updateLineNumber(MethodStructure.Code code) {
        Expression expression = this.expr;
        if (expression instanceof NameExpression) {
            NameExpression exprName = (NameExpression)expression;
            code.updateLineNumber(Source.calculateLine(exprName.getNameToken().getStartPosition()));
        } else {
            super.updateLineNumber(code);
        }
    }

    @Override
    protected Field[] getChildFields() {
        return CHILD_FIELDS;
    }

    @Override
    protected boolean hasSingleValueImpl() {
        return false;
    }

    @Override
    protected boolean hasMultiValueImpl() {
        return true;
    }

    @Override
    public TypeConstant[] getImplicitTypes(Context ctx) {
        return this.resolveReturnTypes(ctx, null, false, ErrorListener.BLACKHOLE);
    }

    @Override
    public Expression.TypeFit testFitMulti(Context ctx, TypeConstant[] atypeRequired, boolean fExhaustive, ErrorListener errs) {
        if (atypeRequired == null || atypeRequired.length == 0) {
            return Expression.TypeFit.Fit;
        }
        TypeConstant[] atype = this.resolveReturnTypes(ctx, atypeRequired, fExhaustive, errs == null ? ErrorListener.BLACKHOLE : errs);
        return this.calcFitMulti(ctx, atype, atypeRequired);
    }

    protected TypeConstant[] resolveReturnTypes(Context ctx, TypeConstant[] atypeRequired, boolean fExhaustive, ErrorListener errs) {
        if (this.isValidated()) {
            return this.getTypes();
        }
        ConstantPool pool = this.pool();
        Expression expression = this.expr;
        if (expression instanceof NameExpression) {
            TypeConstant typeArg;
            NameExpression exprName = (NameExpression)expression;
            Expression exprLeft = exprName.left;
            TypeConstant typeLeft = null;
            if (exprLeft != null && (typeLeft = exprLeft.getImplicitType(ctx)) == null) {
                exprLeft.testFit(ctx, pool.typeObject(), fExhaustive, errs);
                return TypeConstant.NO_TYPES;
            }
            TypeConstant[] atypeReturn = atypeRequired;
            List<TypeExpression> listRedundant = exprName.getTrailingTypeParams();
            if (listRedundant != null && (atypeReturn = this.applyRedundantTypes(ctx, atypeRequired, listRedundant, false, errs)) == null) {
                return TypeConstant.NO_TYPES;
            }
            Argument argMethod = this.resolveName(ctx, false, typeLeft, atypeReturn, errs);
            if (argMethod == null) {
                return TypeConstant.NO_TYPES;
            }
            if (this.m_idConvert != null) {
                TypeConstant[] atypeConvRets = this.m_idConvert.getRawReturns();
                TypeConstant typeFn = atypeConvRets[0];
                assert (typeFn.isA(pool.typeFunction()));
                if (this.m_fCall) {
                    return pool.extractFunctionReturns(typeFn);
                }
                if (this.m_fBindParams) {
                    typeFn = this.bindFunctionParameters(typeFn);
                }
                return new TypeConstant[]{typeFn};
            }
            if (argMethod instanceof MethodConstant) {
                TypeConstant typeFn;
                MethodConstant idMethod = (MethodConstant)argMethod;
                MethodStructure method = this.m_method;
                int cTypeParams = method.getTypeParamCount();
                int cReturns = method.getReturnCount();
                GenericTypeResolver resolver = null;
                if (cTypeParams > 0) {
                    TypeConstant[] atype = this.m_fCall || cReturns == 0 || atypeReturn == null ? atypeReturn : pool.extractFunctionReturns(atypeReturn[0]);
                    resolver = this.makeTypeParameterResolver(ctx, method, false, typeLeft, atype, ErrorListener.BLACKHOLE);
                }
                if (this.m_fCall) {
                    if (cReturns == 0) {
                        return atypeReturn != null && atypeReturn.length == 1 && InvocationExpression.isVoid(atypeReturn) ? atypeReturn : TypeConstant.NO_TYPES;
                    }
                    if (method.isFunction() || method.isConstructor()) {
                        return this.resolveTypes(resolver, idMethod.getSignature().getRawReturns());
                    }
                    if (typeLeft == null) {
                        typeLeft = this.m_targetInfo == null ? ctx.getThisType() : this.m_targetInfo.getTargetType();
                    }
                    SignatureConstant sigMethod = idMethod.getSignature();
                    return this.resolveTypes(resolver, sigMethod.resolveAutoNarrowing(pool, typeLeft, null).getRawReturns());
                }
                TypeConstant typeConstant = this.m_fBindTarget ? (method.isVirtualConstructor() ? idMethod.getSignature().asConstructorType(pool, typeLeft) : idMethod.getSignature().asFunctionType()) : (typeFn = idMethod.getValueType(pool, typeLeft));
                if (cTypeParams > 0) {
                    typeFn = this.removeTypeParameters(typeFn, cTypeParams);
                }
                if (resolver != null) {
                    typeFn = typeFn.resolveGenerics(pool, resolver);
                }
                if (this.m_fBindParams) {
                    typeFn = this.bindFunctionParameters(typeFn);
                }
                return new TypeConstant[]{typeFn};
            }
            if (argMethod instanceof PropertyConstant) {
                PropertyConstant idProp = (PropertyConstant)argMethod;
                TypeInfo infoLeft = this.getTypeInfo(ctx, typeLeft, errs);
                PropertyInfo infoProp = infoLeft.findProperty(idProp);
                typeArg = infoProp == null ? pool.typeObject() : infoProp.inferImmutable(typeLeft);
            } else {
                assert (argMethod instanceof Register);
                typeArg = argMethod.getType().resolveTypedefs();
            }
            if (typeArg.isA(pool.typeFunction()) || typeArg.isA(pool.typeMethod())) {
                return this.calculateReturnType(typeArg);
            }
            if (argMethod instanceof PropertyConstant) {
                if (typeLeft == null) {
                    typeLeft = ctx.getThisType();
                }
                this.log(errs, Severity.ERROR, "COMPILER-178", exprName.getName(), typeLeft.getValueString());
            }
        } else {
            TypeConstant typeFn = this.expr.getImplicitType(ctx);
            if (typeFn != null) {
                this.m_fBindTarget = false;
                this.m_fBindParams = this.isAnyArgBound();
                this.m_fCall = !this.isSuppressCall();
                this.m_fNamedArgs = this.containsNamedArgs(this.args);
                if ((typeFn = this.testFunction(ctx, typeFn, 0, 0, atypeRequired, errs)) != null) {
                    return this.calculateReturnType(typeFn);
                }
            }
        }
        return TypeConstant.NO_TYPES;
    }

    /*
     * Enabled aggressive block sorting
     */
    private TypeConstant[] applyRedundantTypes(Context ctx, TypeConstant[] atypeRequired, List<TypeExpression> listRedundant, boolean fValidate, ErrorListener errs) {
        TypeConstant[] atypeReturn;
        TypeConstant typeFn;
        boolean fNoCall;
        ConstantPool pool;
        block15: {
            block16: {
                block17: {
                    pool = this.pool();
                    fNoCall = this.isSuppressCall();
                    if (!fNoCall) break block16;
                    if (atypeRequired != null) break block17;
                    typeFn = pool.typeFunction();
                    atypeReturn = TypeConstant.NO_TYPES;
                    break block15;
                }
                typeFn = atypeRequired[0];
                if (typeFn.isA(pool.typeFunction())) {
                    atypeReturn = pool.extractFunctionReturns(typeFn);
                    break block15;
                } else if (pool.typeFunction().isA(typeFn)) {
                    typeFn = pool.typeFunction();
                    atypeReturn = TypeConstant.NO_TYPES;
                    break block15;
                } else {
                    if (!fValidate) return null;
                    this.log(errs, Severity.ERROR, "COMPILER-43", "Function", typeFn.getValueString());
                    return null;
                }
            }
            typeFn = null;
            atypeReturn = atypeRequired == null ? TypeConstant.NO_TYPES : (TypeConstant[])atypeRequired.clone();
        }
        int cRequired = atypeReturn.length;
        int cRedundant = listRedundant.size();
        boolean fCond = false;
        if (cRedundant > cRequired) {
            atypeReturn = Arrays.copyOf(atypeReturn, cRedundant);
        } else if (cRedundant < cRequired) {
            if (cRequired == cRedundant + 1 && atypeRequired[0].isA(pool.typeBoolean())) {
                fCond = true;
            } else {
                if (!fValidate) return null;
                this.log(errs, Severity.ERROR, "COMPILER-18", new Object[0]);
                return null;
            }
        }
        for (int i = 0; i < cRedundant; ++i) {
            TypeExpression exprType = listRedundant.get(i);
            if (fValidate) {
                int ixType = fCond ? i + 1 : i;
                TypeConstant typeTypeReq = i < cRequired ? atypeReturn[ixType].getType() : pool.typeType();
                TypeExpression exprTypeNew = (TypeExpression)exprType.validate(ctx, typeTypeReq, errs);
                if (exprTypeNew == null) {
                    return null;
                }
                if (exprTypeNew != exprType) {
                    listRedundant.set(i, exprTypeNew);
                }
                atypeReturn[ixType] = exprTypeNew.getType().getParamType(0);
                continue;
            }
            TypeConstant typeParam = exprType.getImplicitType(ctx);
            if (typeParam == null) return null;
            if (!typeParam.isTypeOfType()) {
                return null;
            }
            TypeConstant typeReturn = typeParam.getParamType(0);
            if (typeReturn.containsUnresolved()) {
                return null;
            }
            atypeReturn[i] = typeReturn;
        }
        if (!fNoCall) return atypeReturn;
        typeFn = pool.buildFunctionType(pool.extractFunctionParams(typeFn), atypeReturn);
        return new TypeConstant[]{typeFn};
    }

    @Override
    protected Expression validateMulti(Context ctx, TypeConstant[] atypeRequired, ErrorListener errs) {
        ConstantPool pool = this.pool();
        boolean fCall = !this.isSuppressCall();
        TypeConstant[] atypeResult = null;
        Expression expression = this.expr;
        if (expression instanceof NameExpression) {
            NameExpression exprName = (NameExpression)expression;
            Expression exprLeft = exprName.left;
            TypeConstant typeLeft = null;
            if (exprLeft != null) {
                Expression exprNew = exprLeft.validate(ctx, null, errs);
                if (exprNew == null) {
                    return null;
                }
                if (exprNew != exprLeft) {
                    exprName.left = exprLeft = exprNew;
                }
                if ((typeLeft = exprLeft.getType()) == null) {
                    exprLeft.log(errs, Severity.ERROR, "COMPILER-49", new Object[0]);
                    return null;
                }
            }
            TypeConstant[] atypeReturn = atypeRequired;
            List<TypeExpression> listRedundant = exprName.getTrailingTypeParams();
            if (listRedundant != null && (atypeReturn = this.applyRedundantTypes(ctx, atypeRequired, listRedundant, true, errs)) == null) {
                return null;
            }
            if (atypeReturn != null) {
                int c = atypeReturn.length;
                for (int i = 0; i < c; ++i) {
                    TypeConstant typeRetR;
                    TypeConstant typeRet = atypeReturn[i];
                    if (typeRet == null || !typeRet.containsGenericType(true) || (typeRetR = typeRet.resolveGenerics(pool, ctx.getThisType())) == typeRet) continue;
                    if (atypeReturn == atypeRequired) {
                        atypeReturn = (TypeConstant[])atypeRequired.clone();
                    }
                    atypeReturn[i] = typeRetR;
                }
            }
            List<Expression> listArgs = this.args;
            ErrorListener errsTemp = errs.branch(this);
            Argument argMethod = this.resolveName(ctx, true, typeLeft, atypeReturn, errsTemp);
            if (argMethod == null) {
                ErrorListener errsMain = errs.branch(this);
                TypeConstant[] atypeArgs = this.validateExpressions(ctx, listArgs, null, errsMain);
                if (atypeArgs == null) {
                    errsTemp.merge();
                    errsMain.merge();
                    return null;
                }
                errsMain.merge();
                argMethod = this.resolveName(ctx, true, typeLeft, atypeReturn, errs);
                if (argMethod == null) {
                    return null;
                }
            }
            if (this.m_idFormal != null) {
                assert (typeLeft.isTypeOfType());
                typeLeft = typeLeft.getParamType(0);
            }
            if (this.m_fNamedArgs) {
                assert (argMethod instanceof MethodConstant);
                if ((listArgs = this.rearrangeNamedArgs(this.m_method, listArgs, errs)) == null) {
                    return null;
                }
                this.args = listArgs;
            }
            if (exprLeft == null) {
                if (argMethod instanceof Register) {
                    ctx.markVarRead(exprName.getNameToken(), true, errs);
                } else {
                    boolean fStatic;
                    if (argMethod instanceof MethodConstant) {
                        MethodConstant idMethod = (MethodConstant)argMethod;
                        v0 = this.getMethod(ctx, idMethod).isFunction();
                    } else {
                        v0 = fStatic = this.getProperty(ctx, (PropertyConstant)argMethod).isStatic();
                    }
                    if (!fStatic) {
                        Token tokName = exprName.getNameToken();
                        long lPos = tokName.getStartPosition();
                        Token tokThis = new Token(lPos, lPos, Token.Id.THIS);
                        ctx.markVarRead(tokThis, true, errs);
                    }
                }
            } else if (this.m_fBjarne) {
                listArgs.add(0, exprLeft);
                typeLeft = null;
            }
            if (this.m_idConvert != null) {
                TypeConstant[] atypeConvRets = this.m_idConvert.getRawReturns();
                TypeConstant typeFn = atypeConvRets[0];
                assert (typeFn.isA(pool.typeFunction()));
                if (fCall) {
                    atypeResult = pool.extractFunctionReturns(typeFn);
                } else {
                    if (this.m_fBindParams) {
                        typeFn = this.bindFunctionParameters(typeFn);
                    }
                    atypeResult = new TypeConstant[]{typeFn};
                }
            } else if (argMethod instanceof MethodConstant) {
                TypeConstant[] atypeArgs;
                boolean fCondReturn;
                MethodConstant idMethod = (MethodConstant)argMethod;
                MethodStructure method = this.m_method;
                TypeConstant[] atypeParams = idMethod.getRawParams();
                int cTypeParams = method.getTypeParamCount();
                int cParams = method.getVisibleParamCount();
                int cReturns = atypeReturn == null ? 0 : atypeReturn.length;
                boolean bl = fCondReturn = method.isConditionalReturn() && cReturns > 1;
                if (cParams > 0) {
                    if (cTypeParams > 0) {
                        GenericTypeResolver resolver = this.makeTypeParameterResolver(ctx, method, true, typeLeft, fCall || cReturns == 0 ? atypeReturn : pool.extractFunctionReturns(atypeReturn[0]), errs);
                        if (resolver == null) {
                            return null;
                        }
                        TypeConstant[] atype = new TypeConstant[cParams];
                        System.arraycopy(atypeParams, cTypeParams, atype, 0, cParams);
                        atypeParams = this.resolveTypes(resolver, atype);
                    } else {
                        atypeParams = (TypeConstant[])atypeParams.clone();
                    }
                } else {
                    atypeParams = TypeConstant.NO_TYPES;
                }
                int c = atypeParams.length;
                for (int i = 0; i < c; ++i) {
                    TypeConstant type = atypeParams[i];
                    if (type instanceof PendingTypeConstant) {
                        this.log(errs, Severity.ERROR, "COMPILER-145", method.getParam(i).getName());
                        return null;
                    }
                    if (!type.containsFormalType(true)) continue;
                    atypeParams[i] = type.union(pool, ctx.resolveFormalType(type));
                }
                if (typeLeft == null && !this.m_method.isFunction()) {
                    TypeConstant typeConstant = typeLeft = this.m_targetInfo == null ? ctx.getThisType() : this.m_targetInfo.getTargetType();
                }
                if ((atypeArgs = this.validateExpressions(ctx, listArgs, atypeParams, errs)) == null) {
                    return null;
                }
                Map<FormalConstant, TypeConstant> mapTypeParams = Collections.emptyMap();
                if (cTypeParams > 0) {
                    this.transformTypeArguments(ctx, listArgs, atypeArgs);
                    mapTypeParams = method.resolveTypeParameters(pool, typeLeft, atypeArgs, fCall || cReturns == 0 ? atypeReturn : pool.extractFunctionReturns(atypeReturn[0]), false);
                    if (mapTypeParams.size() < cTypeParams) {
                        this.log(errs, Severity.ERROR, "COMPILER-145", method.collectUnresolvedTypeParameters(mapTypeParams.keySet().stream().map(NamedConstant::getName).collect(Collectors.toSet())));
                        return null;
                    }
                    Argument[] aargTypeParam = new Argument[mapTypeParams.size()];
                    ArrayList<String> listUnresolved = null;
                    int iArg = 0;
                    for (TypeConstant typeArg : mapTypeParams.values()) {
                        if (typeArg.containsUnresolved()) {
                            if (listUnresolved == null) {
                                listUnresolved = new ArrayList<String>();
                            }
                            listUnresolved.add(method.getParam(iArg++).getName());
                            continue;
                        }
                        TypeConstant typeConstraint = idMethod.getRawParams()[iArg].getParamType(0);
                        if (typeConstraint.containsTypeParameter(true)) {
                            typeConstraint = typeConstraint.resolveGenerics(pool, GenericTypeResolver.of(mapTypeParams));
                        }
                        if (!typeArg.isA(typeConstraint)) {
                            this.log(errs, Severity.ERROR, "COMPILER-43", typeConstraint.getValueString(), typeArg.getValueString());
                            return null;
                        }
                        aargTypeParam[iArg++] = typeArg.getType();
                    }
                    if (listUnresolved != null) {
                        this.log(errs, Severity.ERROR, "COMPILER-145", listUnresolved);
                        return null;
                    }
                    this.m_aargTypeParams = aargTypeParam;
                }
                if (fCall) {
                    SignatureConstant sigMethod = idMethod.getSignature();
                    if (sigMethod.containsAutoNarrowing(true)) {
                        sigMethod = sigMethod.resolveAutoNarrowing(pool, typeLeft, null);
                    }
                    if (!mapTypeParams.isEmpty()) {
                        sigMethod = sigMethod.resolveGenericTypes(pool, GenericTypeResolver.of(mapTypeParams));
                    }
                    atypeResult = sigMethod.getRawReturns();
                    if (fCondReturn) {
                        if (this.getParent().allowsConditional(this)) {
                            this.m_fCondResult = true;
                        } else {
                            this.log(errs, Severity.ERROR, "COMPILER-139", method.getIdentityConstant().getValueString());
                            return null;
                        }
                    }
                    if (cReturns > 0) {
                        if (atypeReturn.length == 0) {
                            atypeResult = atypeReturn;
                        } else if (this.calculateReturnFit(sigMethod, fCall, atypeReturn, ctx.getThisType(), ErrorListener.BLACKHOLE).isPacking()) {
                            atypeResult = new TypeConstant[]{pool.ensureTupleType(atypeResult)};
                            this.m_fPack = true;
                        }
                    }
                } else {
                    TypeConstant typeFn;
                    if (atypeReturn == null || atypeReturn.length == 0) {
                        this.log(errs, Severity.ERROR, "COMPILER-48", new Object[0]);
                        return null;
                    }
                    TypeConstant typeConstant = this.m_fBindTarget ? (method.isVirtualConstructor() ? idMethod.getSignature().asConstructorType(pool, typeLeft) : idMethod.getSignature().asFunctionType()) : (typeFn = idMethod.getValueType(pool, typeLeft));
                    if (cTypeParams > 0) {
                        typeFn = this.removeTypeParameters(typeFn, cTypeParams);
                    }
                    if (this.m_fBindParams) {
                        typeFn = this.bindFunctionParameters(typeFn);
                    }
                    if (!mapTypeParams.isEmpty()) {
                        typeFn = typeFn.resolveGenerics(pool, GenericTypeResolver.of(mapTypeParams));
                    }
                    atypeResult = new TypeConstant[]{typeFn};
                }
            } else {
                TypeConstant typeFn;
                int cTypeParams = 0;
                int cDefaults = 0;
                if (argMethod instanceof PropertyConstant) {
                    PropertyConstant idProp = (PropertyConstant)argMethod;
                    if (this.m_targetInfo != null) {
                        typeLeft = this.m_targetInfo.getTargetType();
                    } else if (this.m_typeTarget != null) {
                        typeLeft = this.m_typeTarget;
                    }
                    TypeInfo infoLeft = this.getTypeInfo(ctx, typeLeft, errs);
                    PropertyInfo infoProp = infoLeft.findProperty(idProp);
                    if (infoProp == null) {
                        this.log(errs, Severity.ERROR, "COMPILER-162", idProp.getValueString(), typeLeft.getValueString());
                        return null;
                    }
                    typeFn = infoProp.inferImmutable(typeLeft);
                } else {
                    assert (argMethod instanceof Register);
                    typeFn = argMethod.getType().resolveTypedefs();
                    if (((Register)argMethod).isSuper()) {
                        MethodStructure method = ctx.getMethod();
                        cDefaults = method.getDefaultParamCount();
                        cTypeParams = method.getTypeParamCount();
                        if (cTypeParams > 0 && typeFn.isA(pool.typeFunction())) {
                            Argument[] aargTypeParam = new Argument[cTypeParams];
                            for (int i = 0; i < cTypeParams; ++i) {
                                aargTypeParam[i] = ctx.getParameter(i);
                            }
                            this.m_aargTypeParams = aargTypeParam;
                        }
                    }
                }
                if (!typeFn.isA(pool.typeFunction()) && !typeFn.isA(pool.typeMethod())) {
                    this.log(errs, Severity.ERROR, "COMPILER-43", "Function", typeFn.getValueString());
                    return null;
                }
                if (exprName.isSuppressDeref()) {
                    if (typeFn.isA(pool.typeMethod())) {
                        this.log(errs, Severity.ERROR, "COMPILER-146", new Object[0]);
                        return null;
                    }
                    assert (argMethod instanceof Register && !fCall);
                    if (((Register)argMethod).isSuper() && cTypeParams > 0) {
                        TypeConstant[] atypeFnParams = pool.extractFunctionParams(typeFn);
                        TypeConstant[] atypeFnReturns = pool.extractFunctionReturns(typeFn);
                        typeFn = pool.buildFunctionType(Arrays.copyOfRange(atypeFnParams, cTypeParams, atypeFnParams.length), atypeFnReturns);
                        cTypeParams = 0;
                    }
                } else {
                    Expression exprNew = exprName.validate(ctx, typeFn, errs);
                    if (exprNew == null) {
                        return null;
                    }
                    this.expr = exprNew;
                    typeFn = exprNew.getType();
                    if (typeFn.isA(pool.typeMethod())) {
                        TypeConstant typeTarget = typeFn.getParamType(0);
                        if (!typeLeft.isA(typeTarget)) {
                            this.log(errs, Severity.ERROR, "COMPILER-58", typeTarget.getValueString(), exprName.getName());
                            return null;
                        }
                        this.m_fBindTarget = true;
                        this.m_argMethod = argMethod;
                    }
                }
                atypeResult = this.validateFunction(ctx, typeFn, cTypeParams, cDefaults, atypeRequired, errs);
            }
        } else {
            Expression exprNew = this.expr.validate(ctx, pool.typeFunction(), errs);
            if (exprNew != null) {
                this.expr = exprNew;
                this.m_fBindTarget = false;
                this.m_fBindParams = this.isAnyArgBound();
                this.m_fCall = fCall;
                this.m_fNamedArgs = this.containsNamedArgs(this.args);
                TypeConstant typeFn = this.testFunction(ctx, exprNew.getType(), 0, 0, atypeRequired, errs);
                if (typeFn == null) {
                    return null;
                }
                atypeResult = this.validateFunction(ctx, typeFn, 0, 0, atypeRequired, errs);
            }
        }
        if (atypeResult == null) {
            return null;
        }
        if (this.async) {
            if (!fCall) {
                this.log(errs, Severity.ERROR, "COMPILER-167", new Object[0]);
                return null;
            }
            if (atypeRequired == null || atypeRequired.length == 0) {
                this.m_fAutoFuture = true;
                if (atypeResult.length > 0) {
                    atypeResult = (TypeConstant[])atypeResult.clone();
                    int c = atypeResult.length;
                    for (int i = 0; i < c; ++i) {
                        atypeResult[i] = pool.ensureFuture(atypeResult[i]);
                    }
                } else {
                    atypeResult = new TypeConstant[]{pool.ensureFuture(pool.typeTuple0())};
                }
            }
        }
        return this.finishValidations(ctx, atypeRequired, atypeResult, Expression.TypeFit.Fit, null, errs);
    }

    @Override
    public boolean isStandalone() {
        return true;
    }

    @Override
    public boolean isTraceworthy() {
        return this.m_fCall;
    }

    @Override
    public boolean isCompletable() {
        for (Expression arg : this.args) {
            if (arg.isCompletable()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isShortCircuiting() {
        return this.expr.isShortCircuiting() || this.args.stream().anyMatch(Expression::isShortCircuiting);
    }

    @Override
    protected boolean allowsShortCircuit(AstNode nodeChild) {
        Expression exprChild;
        return super.allowsShortCircuit(nodeChild) && (nodeChild == this.expr || nodeChild instanceof Expression && this.args.contains(exprChild = (Expression)nodeChild));
    }

    @Override
    protected Expression.SideEffect mightAffect(Expression exprLeft, Argument arg) {
        switch (super.mightAffect(exprLeft, arg)) {
            case DefNo: {
                return Expression.SideEffect.DefNo;
            }
            case AnyCompute: {
                if (!this.isSuppressCall()) {
                    return Expression.SideEffect.DefYes;
                }
            }
            case Unknown: {
                Expression.SideEffect effect = Expression.SideEffect.DefNo;
                for (Expression expr : this.args) {
                    switch (expr.mightAffect(exprLeft, arg)) {
                        case DefNo: 
                        case Unknown: 
                        case AnyCompute: {
                            break;
                        }
                        case DefYes: {
                            return Expression.SideEffect.DefYes;
                        }
                    }
                }
                return effect;
            }
        }
        throw new IllegalStateException();
    }

    @Override
    public boolean isConditionalResult() {
        return this.m_fCondResult;
    }

    @Override
    public Argument[] generateArguments(Context ctx, MethodStructure.Code code, boolean fLocalPropOk, boolean fUsedOnce, ErrorListener errs) {
        if (this.async) {
            TypeConstant[] atype = this.getTypes();
            int cRVals = this.getValueCount();
            Expression.Assignable[] aLVal = new Expression.Assignable[cRVals];
            if (this.m_fAutoFuture) {
                for (int i = 0; i < cRVals; ++i) {
                    Register reg = code.createRegister(atype[i], null);
                    code.add(new Var_D(reg));
                    aLVal[i] = new Expression.Assignable(reg);
                }
                this.generateAssignments(ctx, code, aLVal, errs);
                Argument[] aargResult = new Argument[cRVals];
                for (int i = 0; i < cRVals; ++i) {
                    Register regVar = code.createRegister(atype[i], null);
                    code.add(new MoveVar(aLVal[i].getRegister(), (Argument)regVar));
                    aargResult[i] = regVar;
                }
                return aargResult;
            }
            if (this.getParent() instanceof ReturnStatement) {
                ConstantPool pool = this.pool();
                Argument[] aargResult = new Argument[cRVals];
                for (int i = 0; i < cRVals; ++i) {
                    Register reg = code.createRegister(pool.ensureFuture(atype[i]), null);
                    code.add(new Var_D(reg));
                    aLVal[i] = new Expression.Assignable(reg);
                    aargResult[i] = reg;
                }
                this.generateAssignments(ctx, code, aLVal, errs);
                return aargResult;
            }
        }
        return super.generateArguments(ctx, code, fLocalPropOk, fUsedOnce & !this.async, errs);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @Override
    public void generateAssignments(Context ctx, MethodStructure.Code code, Expression.Assignable[] aLVal, ErrorListener errs) {
        void var25_55;
        Register regFn;
        TypeConstant[] atypeParams;
        int cAll;
        Argument argFn;
        ExprAST astFn;
        boolean fTargetOnStack;
        int cTypeParams;
        Argument[] aargTypeParams;
        boolean fConstruct;
        int cRets;
        int cArgs;
        Argument[] aargResult;
        boolean fAsync;
        int cLVals;
        ConstantPool pool;
        block117: {
            block118: {
                Argument idProp;
                Argument argTarget;
                Expression exprLeft;
                NameExpression exprName;
                boolean fLocalPropOk;
                block119: {
                    MethodConstant idMethod;
                    block122: {
                        block123: {
                            int chRets;
                            ExprAST[] aAsts;
                            int chArgs;
                            Argument[] aArgs;
                            block116: {
                                int i;
                                int n;
                                int cAll2;
                                block125: {
                                    block124: {
                                        block120: {
                                            block121: {
                                                pool = this.pool();
                                                cLVals = aLVal.length;
                                                int cRVals = this.getValueCount();
                                                fAsync = this.async;
                                                assert (!this.m_fPack || cLVals == 1);
                                                aargResult = new Argument[cRVals];
                                                for (int i2 = 0; i2 < cRVals; ++i2) {
                                                    if (i2 < cLVals) {
                                                        Expression.Assignable LVal = aLVal[i2];
                                                        if (!LVal.isLocalArgument()) {
                                                            super.generateAssignments(ctx, code, aLVal, errs);
                                                            return;
                                                        }
                                                        aargResult[i2] = LVal.getLocalArgument();
                                                        continue;
                                                    }
                                                    aargResult[i2] = new Register(pool.typeObject(), null, fAsync ? -3 : -2);
                                                }
                                                cArgs = this.args.size();
                                                cRets = aargResult.length;
                                                fConstruct = false;
                                                fLocalPropOk = cArgs == 0;
                                                aargTypeParams = this.m_aargTypeParams;
                                                cTypeParams = aargTypeParams == null ? 0 : aargTypeParams.length;
                                                fTargetOnStack = cArgs == 0 || this.args.stream().allMatch(Expression::isConstant);
                                                Expression expression = this.expr;
                                                if (!(expression instanceof NameExpression)) break block118;
                                                exprName = (NameExpression)expression;
                                                exprLeft = exprName.left;
                                                Argument argument = this.m_argMethod;
                                                if (!(argument instanceof MethodConstant)) break block119;
                                                idMethod = (MethodConstant)argument;
                                                idMethod = this.rebaseMethodConstant(idMethod, this.m_method);
                                                astFn = new ConstantExprAST(idMethod);
                                                if (!this.m_method.isFunction() && !this.m_method.isConstructor()) break block120;
                                                if (!this.m_fBindTarget) break block121;
                                                assert (this.m_method.isVirtualConstructor());
                                                argTarget = this.generateTarget(ctx, code, exprLeft, fLocalPropOk, fTargetOnStack, errs);
                                                argFn = code.createRegister(idMethod.getSignature().asConstructorType(pool, argTarget.getType()));
                                                code.add(new MBind(argTarget, idMethod, argFn));
                                                astFn = new BindMethodAST(this.m_astTarget, idMethod, argFn.getType());
                                                break block117;
                                            }
                                            assert (exprLeft == null || !exprLeft.hasSideEffects() || this.m_fBjarne || this.m_idFormal != null);
                                            if (this.m_idFormal == null) {
                                                argFn = this.m_method.getIdentityConstant();
                                                fConstruct = this.m_method.isConstructor();
                                                if (exprLeft instanceof TraceExpression) {
                                                    exprLeft.generateVoid(ctx, code, errs);
                                                }
                                                break block117;
                                            } else {
                                                if (exprLeft != null) {
                                                    TypeConstant typeType = exprLeft.getType();
                                                    assert (typeType.isTypeOfType());
                                                    TypeConstant typeLeft = typeType.getParamType(0);
                                                    if (typeLeft.isFormalType()) {
                                                        if (exprLeft instanceof TraceExpression) {
                                                            exprLeft.generateVoid(ctx, code, errs);
                                                        }
                                                    } else {
                                                        Register register = (Register)exprLeft.generateArgument(ctx, code, fLocalPropOk, false, errs);
                                                        this.m_idFormal = pool.ensureDynamicFormal(ctx.getMethod().getIdentityConstant(), register, this.m_idFormal, exprName.getName());
                                                    }
                                                }
                                                argFn = pool.ensureMethodConstant(this.m_idFormal, idMethod.getSignature());
                                                fConstruct = false;
                                            }
                                            break block117;
                                        }
                                        if (!this.m_fBindTarget) break block122;
                                        argTarget = this.generateTarget(ctx, code, exprLeft, fLocalPropOk, fTargetOnStack, errs);
                                        if (!this.m_fCall) break block123;
                                        this.updateLineNumber(code);
                                        cAll2 = idMethod.getRawParams().length;
                                        n = cAll2 - cTypeParams - cArgs;
                                        Object var25_42 = null;
                                        aArgs = null;
                                        assert (cTypeParams + cArgs + n == cAll2);
                                        if (cAll2 != 0) break block124;
                                        chArgs = 48;
                                        aArgs = NO_RVALUES;
                                        aAsts = BinaryAST.NO_EXPRS;
                                        break block116;
                                    }
                                    if (cAll2 != 1) break block125;
                                    chArgs = 49;
                                    if (cArgs == 1) {
                                        Expression expr = this.args.get(0);
                                        Argument argument = expr.generateArgument(ctx, code, true, true, errs);
                                        aAsts = new ExprAST[]{expr.getExprAST(ctx)};
                                        break block116;
                                    } else if (cTypeParams == 1) {
                                        Argument argument = aargTypeParams[0];
                                        aAsts = new ExprAST[]{InvocationExpression.toTypeParameterAst(ctx, argument)};
                                        break block116;
                                    } else {
                                        Register register = Register.DEFAULT;
                                        aAsts = new ExprAST[]{RegisterAST.defaultReg(idMethod.getRawParams()[0])};
                                    }
                                    break block116;
                                }
                                chArgs = 78;
                                aArgs = new Argument[cAll2];
                                aAsts = new ExprAST[cAll2];
                                if (cTypeParams > 0) {
                                    System.arraycopy(aargTypeParams, 0, aArgs, 0, cTypeParams);
                                    for (i = 0; i < cTypeParams; ++i) {
                                        aAsts[i] = InvocationExpression.toTypeParameterAst(ctx, aargTypeParams[i]);
                                    }
                                }
                                for (i = 0; i < cArgs; ++i) {
                                    Expression expr = this.args.get(i);
                                    Argument arg = expr.generateArgument(ctx, code, true, true, errs);
                                    int iArg = cTypeParams + i;
                                    aArgs[iArg] = expr.ensurePointInTime(code, arg, this.args, i);
                                    aAsts[iArg] = expr.getExprAST(ctx);
                                }
                                for (i = 0; i < n; ++i) {
                                    int iArg = cTypeParams + cArgs + i;
                                    aArgs[iArg] = Register.DEFAULT;
                                    aAsts[iArg] = RegisterAST.defaultReg(idMethod.getRawParams()[cArgs + i]);
                                }
                            }
                            switch (cRets) {
                                case 0: {
                                    if (!fAsync) {
                                        chRets = 48;
                                        break;
                                    }
                                    aargResult = new Argument[]{Register.ASYNC};
                                }
                                case 1: {
                                    chRets = 49;
                                    break;
                                }
                                default: {
                                    chRets = 78;
                                }
                            }
                            switch (InvocationExpression.combine(chArgs, chRets)) {
                                case 12336: {
                                    code.add(new Invoke_00(argTarget, idMethod));
                                    break;
                                }
                                case 12592: {
                                    void var25_46;
                                    if (this.m_fTupleArg) {
                                        code.add(new Invoke_T0(argTarget, idMethod, (Argument)var25_46));
                                        break;
                                    }
                                    code.add(new Invoke_10(argTarget, idMethod, (Argument)var25_46));
                                    break;
                                }
                                case 20016: {
                                    code.add(new Invoke_N0(argTarget, idMethod, aArgs));
                                    break;
                                }
                                case 12337: {
                                    if (this.m_fPack) {
                                        code.add(new Invoke_0T(argTarget, idMethod, aargResult[0]));
                                        break;
                                    }
                                    code.add(new Invoke_01(argTarget, idMethod, aargResult[0]));
                                    break;
                                }
                                case 12593: {
                                    void var25_46;
                                    if (this.m_fPack) {
                                        if (this.m_fTupleArg) {
                                            code.add(new Invoke_TT(argTarget, idMethod, (Argument)var25_46, aargResult[0]));
                                            break;
                                        }
                                        code.add(new Invoke_1T(argTarget, idMethod, (Argument)var25_46, aargResult[0]));
                                        break;
                                    }
                                    if (this.m_fTupleArg) {
                                        code.add(new Invoke_T1(argTarget, idMethod, (Argument)var25_46, aargResult[0]));
                                        break;
                                    }
                                    code.add(new Invoke_11(argTarget, idMethod, (Argument)var25_46, aargResult[0]));
                                    break;
                                }
                                case 20017: {
                                    if (this.m_fPack) {
                                        code.add(new Invoke_NT(argTarget, idMethod, aArgs, aargResult[0]));
                                        break;
                                    }
                                    code.add(new Invoke_N1(argTarget, idMethod, aArgs, aargResult[0]));
                                    break;
                                }
                                case 12366: {
                                    code.add(new Invoke_0N(argTarget, idMethod, aargResult));
                                    break;
                                }
                                case 12622: {
                                    void var25_46;
                                    if (this.m_fTupleArg) {
                                        code.add(new Invoke_TN(argTarget, idMethod, (Argument)var25_46, aargResult));
                                        break;
                                    }
                                    code.add(new Invoke_1N(argTarget, idMethod, (Argument)var25_46, aargResult));
                                    break;
                                }
                                case 20046: {
                                    code.add(new Invoke_NN(argTarget, idMethod, aArgs, aargResult));
                                    break;
                                }
                                default: {
                                    throw new UnsupportedOperationException("invocation: " + InvocationExpression.combine(chArgs, chRets));
                                }
                            }
                            if (!this.m_fPack) {
                                this.m_astInvoke = new InvokeExprAST(idMethod, this.getTypes(), this.m_astTarget, aAsts, fAsync);
                                return;
                            }
                            TypeConstant typeTuple = this.getType();
                            assert (typeTuple.isTuple());
                            InvokeExprAST astInvoke = new InvokeExprAST(idMethod, typeTuple.getParamTypesArray(), this.m_astTarget, aAsts, fAsync);
                            this.m_astInvoke = new TupleExprAST(typeTuple, new ExprAST[]{astInvoke});
                            return;
                        }
                        argFn = code.createRegister(idMethod.getSignature().asFunctionType());
                        code.add(new MBind(argTarget, idMethod, argFn));
                        astFn = new BindMethodAST(this.m_astTarget, idMethod, argFn.getType());
                        break block117;
                    }
                    if (!$assertionsDisabled) {
                        if (this.m_idConvert != null) throw new AssertionError();
                        if (this.m_fBindParams) throw new AssertionError();
                        if (this.m_fCall) {
                            throw new AssertionError();
                        }
                    }
                    if (cLVals <= 0) return;
                    aLVal[0].assign(idMethod, code, errs);
                    return;
                }
                if (this.m_fBindTarget) {
                    argTarget = this.generateTarget(ctx, code, exprLeft, fLocalPropOk, fTargetOnStack, errs);
                    Argument argument = this.m_argMethod;
                    if (!(argument instanceof PropertyConstant)) {
                        this.log(errs, Severity.ERROR, "COMPILER-NI", "Dynamic method invocation");
                        return;
                    }
                    idProp = (PropertyConstant)argument;
                    PropertyStructure propertyStructure = (PropertyStructure)((IdentityConstant)idProp).getComponent();
                    if (propertyStructure.isConstant() && propertyStructure.hasInitialValue()) {
                        MethodConstant methodConstant = (MethodConstant)propertyStructure.getInitialValue();
                        argFn = code.createRegister(methodConstant.getSignature().asFunctionType());
                        astFn = new ConstantExprAST((Constant)idProp);
                        code.add(new MBind(argTarget, methodConstant, argFn));
                        break block117;
                    } else {
                        this.log(errs, Severity.ERROR, "COMPILER-NI", "Dynamic method invocation");
                        return;
                    }
                }
                idProp = this.m_argMethod;
                if (idProp instanceof Register) {
                    Register regFn2 = (Register)idProp;
                    argFn = regFn2;
                    astFn = regFn2.getRegisterAST();
                    break block117;
                } else {
                    argFn = exprName.generateArgument(ctx, code, false, fTargetOnStack, errs);
                    astFn = exprName.getExprAST(ctx);
                }
                break block117;
            }
            assert (!this.m_fBindTarget);
            argFn = this.expr.generateArgument(ctx, code, false, fTargetOnStack, errs);
            astFn = this.expr.getExprAST(ctx);
            assert (argFn.getType().isA(pool.typeFunction()));
        }
        TypeConstant typeFn = argFn.getType().resolveTypedefs();
        MethodConstant idConv = this.m_idConvert;
        if (idConv == null) {
            if (!(argFn instanceof MethodConstant) && !(argFn instanceof Register)) {
                regFn = code.createRegister(typeFn, fTargetOnStack);
                code.add(new Move(argFn, regFn));
                argFn = regFn;
            }
        } else {
            typeFn = idConv.getRawReturns()[0];
            regFn = code.createRegister(typeFn, fTargetOnStack);
            code.add(new Invoke_01(argFn, idConv, regFn));
            argFn = regFn;
            astFn = new ConvertExprAST(astFn, typeFn, idConv);
        }
        int n = cAll = (atypeParams = pool.extractFunctionParams(typeFn)) == null ? 0 : atypeParams.length;
        if (this.m_fCall) {
            int chRets;
            void var25_51;
            void var24_37;
            ExprAST[] aAsts;
            int chArgs;
            this.updateLineNumber(code);
            int cDefaults = cAll - cTypeParams - cArgs;
            Object var24_33 = null;
            Object var25_48 = null;
            assert (!this.m_fBindParams || cArgs > 0);
            assert (cDefaults >= 0);
            switch (cAll) {
                case 0: {
                    chArgs = 48;
                    Argument[] argumentArray = NO_RVALUES;
                    aAsts = BinaryAST.NO_EXPRS;
                    break;
                }
                case 1: {
                    chArgs = 49;
                    if (cArgs == 1) {
                        Expression expr = this.args.get(0);
                        Argument argument = expr.generateArgument(ctx, code, true, true, errs);
                        aAsts = new ExprAST[]{expr.getExprAST(ctx)};
                        break;
                    }
                    if (cTypeParams == 1) {
                        Argument argument = aargTypeParams[0];
                        aAsts = new ExprAST[]{InvocationExpression.toTypeParameterAst(ctx, argument)};
                        break;
                    }
                    Register register = Register.DEFAULT;
                    aAsts = new ExprAST[]{RegisterAST.defaultReg(atypeParams[0])};
                    break;
                }
                default: {
                    int i;
                    chArgs = 78;
                    Argument[] argumentArray = new Argument[cAll];
                    aAsts = new ExprAST[cAll];
                    if (cTypeParams > 0) {
                        System.arraycopy(aargTypeParams, 0, argumentArray, 0, cTypeParams);
                        for (i = 0; i < cTypeParams; ++i) {
                            aAsts[i] = InvocationExpression.toTypeParameterAst(ctx, argumentArray[i]);
                        }
                    }
                    for (i = 0; i < cArgs; ++i) {
                        Expression expr = this.args.get(i);
                        Argument arg = expr.generateArgument(ctx, code, true, true, errs);
                        int iArg = cTypeParams + i;
                        argumentArray[iArg] = expr.ensurePointInTime(code, arg, this.args, i);
                        aAsts[iArg] = expr.getExprAST(ctx);
                    }
                    for (i = 0; i < cDefaults; ++i) {
                        int iArg = cTypeParams + cArgs + i;
                        argumentArray[iArg] = Register.DEFAULT;
                        aAsts[iArg] = RegisterAST.defaultReg(atypeParams[i]);
                    }
                }
            }
            if (fConstruct) {
                MethodConstant idConstruct = (MethodConstant)argFn;
                switch (chArgs) {
                    case 48: {
                        code.add(new Construct_0(idConstruct));
                        break;
                    }
                    case 49: {
                        code.add(new Construct_1(idConstruct, (Argument)var24_37));
                        break;
                    }
                    case 78: {
                        code.add(new Construct_N(idConstruct, (Argument[])var25_51));
                        break;
                    }
                    case 84: {
                        throw new UnsupportedOperationException("TODO: Construct_T");
                    }
                    default: {
                        throw new IllegalStateException();
                    }
                }
                this.m_astInvoke = new CallExprAST(astFn, TypeConstant.NO_TYPES, aAsts, fAsync);
                return;
            }
            switch (cRets) {
                case 0: {
                    if (!fAsync) {
                        chRets = 48;
                        break;
                    }
                    aargResult = new Argument[]{Register.ASYNC};
                }
                case 1: {
                    chRets = 49;
                    break;
                }
                default: {
                    chRets = 78;
                }
            }
            switch (InvocationExpression.combine(chArgs, chRets)) {
                case 12336: {
                    code.add(new Call_00(argFn));
                    break;
                }
                case 12592: {
                    if (this.m_fTupleArg) {
                        code.add(new Call_T0(argFn, (Argument)var24_37));
                        break;
                    }
                    code.add(new Call_10(argFn, (Argument)var24_37));
                    break;
                }
                case 20016: {
                    code.add(new Call_N0(argFn, (Argument[])var25_51));
                    break;
                }
                case 12337: {
                    if (this.m_fPack) {
                        code.add(new Call_0T(argFn, aargResult[0]));
                        break;
                    }
                    code.add(new Call_01(argFn, aargResult[0]));
                    break;
                }
                case 12593: {
                    if (this.m_fPack) {
                        if (this.m_fTupleArg) {
                            code.add(new Call_TT(argFn, (Argument)var24_37, aargResult[0]));
                            break;
                        }
                        code.add(new Call_1T(argFn, (Argument)var24_37, aargResult[0]));
                        break;
                    }
                    if (this.m_fTupleArg) {
                        code.add(new Call_T1(argFn, (Argument)var24_37, aargResult[0]));
                        break;
                    }
                    code.add(new Call_11(argFn, (Argument)var24_37, aargResult[0]));
                    break;
                }
                case 20017: {
                    if (this.m_fPack) {
                        code.add(new Call_NT(argFn, (Argument[])var25_51, aargResult[0]));
                        break;
                    }
                    code.add(new Call_N1(argFn, (Argument[])var25_51, aargResult[0]));
                    break;
                }
                case 12366: {
                    code.add(new Call_0N(argFn, aargResult));
                    break;
                }
                case 12622: {
                    if (this.m_fTupleArg) {
                        code.add(new Call_TN(argFn, (Argument)var24_37, aargResult));
                        break;
                    }
                    code.add(new Call_1N(argFn, (Argument)var24_37, aargResult));
                    break;
                }
                case 20046: {
                    code.add(new Call_NN(argFn, (Argument[])var25_51, aargResult));
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("invocation " + InvocationExpression.combine(chArgs, chRets));
                }
            }
            if (!this.m_fPack) {
                this.m_astInvoke = new CallExprAST(astFn, this.getTypes(), aAsts, fAsync);
                return;
            }
            TypeConstant typeTuple = this.getType();
            assert (typeTuple.isTuple());
            CallExprAST astCall = new CallExprAST(astFn, typeTuple.getParamTypesArray(), aAsts, fAsync);
            this.m_astInvoke = new TupleExprAST(typeTuple, new ExprAST[]{astCall});
            return;
        }
        int[] aiArg = null;
        Object var24_38 = null;
        Object var25_52 = null;
        int cBind = cTypeParams;
        for (int i = 0; i < cArgs; ++i) {
            if (this.args.get(i).isNonBinding()) continue;
            ++cBind;
        }
        if (cBind > 0) {
            int i;
            aiArg = new int[cBind];
            Argument[] argumentArray = new Argument[cBind];
            ExprAST[] exprASTArray = new ExprAST[cBind];
            for (i = 0; i < cTypeParams; ++i) {
                aiArg[i] = i;
                argumentArray[i] = aargTypeParams[i];
                exprASTArray[i] = InvocationExpression.toTypeParameterAst(ctx, aargTypeParams[i]);
            }
            int iBind = cTypeParams;
            for (i = 0; i < cArgs; ++i) {
                Expression exprArg = this.args.get(i);
                if (exprArg.isNonBinding()) continue;
                Argument arg = exprArg.generateArgument(ctx, code, false, true, errs);
                aiArg[iBind] = cTypeParams + i;
                argumentArray[iBind] = exprArg.ensurePointInTime(code, arg, this.args, i);
                exprASTArray[iBind] = exprArg.getExprAST(ctx);
                ++iBind;
            }
        } else if (argFn instanceof Register && (regFn = (Register)argFn).isSuper()) {
            aiArg = new int[]{};
            Argument[] argumentArray = NO_RVALUES;
            ExprAST[] exprASTArray = ExprAST.NO_EXPRS;
        }
        if (cLVals == 0) {
            this.log(errs, Severity.ERROR, "COMPILER-48", new Object[0]);
            return;
        }
        Expression.Assignable lval = aLVal[0];
        if (aiArg == null) {
            lval.assign(argFn, code, errs);
            this.m_astInvoke = astFn;
            return;
        }
        if (lval.isLocalArgument()) {
            code.add(new FBind(argFn, aiArg, (Argument[])var24_41, lval.getLocalArgument()));
        } else {
            Register regFn3 = code.createRegister(this.getType());
            code.add(new FBind(argFn, aiArg, (Argument[])var24_41, regFn3));
            lval.assign(regFn3, code, errs);
        }
        this.m_astInvoke = new BindFunctionAST(astFn, aiArg, (ExprAST[])var25_55, this.getType());
    }

    private Argument generateTarget(Context ctx, MethodStructure.Code code, Expression exprLeft, boolean fLocalPropOk, boolean fTargetOnStack, ErrorListener errs) {
        Argument argTarget;
        if (exprLeft == null) {
            Register regTarget;
            StatementBlock.TargetInfo targetInfo = this.m_targetInfo;
            if (targetInfo == null) {
                regTarget = ctx.getThisRegister();
                this.m_astTarget = regTarget.getRegisterAST();
            } else {
                TypeConstant typeTarget = targetInfo.getTargetType();
                int cStepsOut = targetInfo.getStepsOut();
                if (cStepsOut > 0) {
                    regTarget = code.createRegister(typeTarget, fTargetOnStack);
                    code.add(new MoveThis(cStepsOut, regTarget));
                    this.m_astTarget = new OuterExprAST(ctx.getThisRegisterAST(), cStepsOut, typeTarget);
                } else {
                    regTarget = ctx.getThisRegister();
                    if (!typeTarget.equals(regTarget.getType())) {
                        regTarget = regTarget.narrowType(typeTarget);
                    }
                    this.m_astTarget = regTarget.getRegisterAST();
                }
            }
            argTarget = regTarget;
        } else {
            argTarget = exprLeft.generateArgument(ctx, code, fLocalPropOk, fTargetOnStack, errs);
            this.m_astTarget = exprLeft.getExprAST(ctx);
        }
        return argTarget;
    }

    @Override
    public ExprAST getExprAST(Context ctx) {
        return this.m_astInvoke == null ? super.getExprAST(ctx) : this.m_astInvoke;
    }

    protected boolean isSuppressCall() {
        NameExpression exprName;
        Expression expression = this.expr;
        return expression instanceof NameExpression && (exprName = (NameExpression)expression).isSuppressDeref() || this.isAnyArgUnbound();
    }

    protected boolean isAnyArgBound() {
        for (Expression expr : this.args) {
            if (expr.isNonBinding()) continue;
            return true;
        }
        return false;
    }

    protected boolean isAnyArgUnbound() {
        for (Expression expr : this.args) {
            if (!expr.isNonBinding()) continue;
            return true;
        }
        return false;
    }

    protected Argument resolveName(Context ctx, boolean fForce, TypeConstant typeLeft, TypeConstant[] atypeReturn, ErrorListener errs) {
        ErrorListener errsMain;
        TypeInfo.MethodKind kind;
        TypeInfo infoLeft;
        IdentityConstant arg;
        MethodConstant idMethod;
        MethodConstant idMethod2;
        if (!fForce && this.m_argMethod != null) {
            return this.m_argMethod;
        }
        boolean fNoFBind = !this.isAnyArgBound();
        boolean fNoCall = this.isSuppressCall();
        boolean fNamedArgs = this.containsNamedArgs(this.args);
        this.m_targetInfo = null;
        this.m_argMethod = null;
        this.m_idConvert = null;
        this.m_fBindTarget = false;
        this.m_fBindParams = !fNoFBind;
        this.m_fCall = !fNoCall;
        this.m_fNamedArgs = fNamedArgs;
        ConstantPool pool = this.pool();
        if (atypeReturn != null && atypeReturn.length > 0 && fNoCall) {
            if (atypeReturn.length > 1) {
                this.log(errs, Severity.ERROR, "COMPILER-44", 1, atypeReturn.length);
                return null;
            }
            TypeConstant typeFn = atypeReturn[0];
            if (typeFn.containsFunctionType()) {
                atypeReturn = pool.extractFunctionReturns(typeFn);
            } else if (pool.typeFunction().isA(typeFn)) {
                atypeReturn = TypeConstant.NO_TYPES;
            } else {
                this.log(errs, Severity.ERROR, "COMPILER-43", "Function", typeFn.getValueString());
                return null;
            }
        }
        NameExpression exprName = (NameExpression)this.expr;
        Token tokName = exprName.getNameToken();
        String sName = exprName.getName();
        boolean fConstruct = "construct".equals(sName);
        boolean fSingleton = false;
        Expression exprLeft = exprName.left;
        if (exprLeft == null) {
            Argument arg2 = ctx.resolveName(tokName, ErrorListener.BLACKHOLE);
            if (arg2 == null) {
                TypeInfo infoLeft2;
                typeLeft = ctx.getThisType();
                if (ctx.isMethod() && (arg2 = this.findCallable(ctx, typeLeft, infoLeft2 = this.getTypeInfo(ctx, typeLeft, errs), sName, TypeInfo.MethodKind.Any, true, atypeReturn, ErrorListener.BLACKHOLE)) instanceof MethodConstant) {
                    MethodConstant idMethod3 = (MethodConstant)arg2;
                    MethodStructure method = this.getMethod(ctx, typeLeft, infoLeft2, idMethod3);
                    if (method == null) {
                        this.log(errs, Severity.ERROR, "COMPILER-177", idMethod3.getValueString(), typeLeft.getValueString());
                        return null;
                    }
                    this.m_argMethod = idMethod3;
                    this.m_method = method;
                    this.m_fBindTarget = !method.isFunction();
                    this.m_targetInfo = new StatementBlock.TargetInfo(sName, method, typeLeft, 0);
                    return idMethod3;
                }
                if ("construct".equals(sName)) {
                    this.log(errs, Severity.ERROR, "COMPILER-65", ctx.getThisType().getValueString());
                } else if ("super".equals(sName)) {
                    this.log(errs, Severity.ERROR, "COMPILER-53", new Object[0]);
                } else {
                    TypeConstant typeTarget = ctx.getThisType();
                    TypeInfo infoTarget = this.getTypeInfo(ctx, null, ErrorListener.BLACKHOLE);
                    if (ctx.isConstructor() && this.findCallable(ctx, typeTarget, infoTarget, sName, TypeInfo.MethodKind.Any, true, atypeReturn, ErrorListener.BLACKHOLE) != null) {
                        this.log(errs, Severity.ERROR, "COMPILER-176", sName);
                    } else {
                        this.log(errs, Severity.ERROR, "COMPILER-56", sName, typeTarget.getValueString());
                    }
                }
                return null;
            }
            if (arg2 instanceof Register) {
                Register reg = (Register)arg2;
                int cTypeParams = 0;
                int cDefaults = 0;
                if (reg.isPredefined()) {
                    switch (reg.getIndex()) {
                        case -10: 
                        case -9: 
                        case -8: 
                        case -7: 
                        case -6: 
                        case -5: {
                            if (!ctx.isFunction()) break;
                            exprName.log(errs, Severity.ERROR, "COMPILER-52", new Object[0]);
                            return null;
                        }
                        case -13: {
                            if (ctx.isFunction()) {
                                exprName.log(errs, Severity.ERROR, "COMPILER-53", new Object[0]);
                                return null;
                            }
                            if (ctx.isConstructor()) {
                                TypeInfo infoSuper;
                                Component.Contribution contribExtends = ctx.getThisClass().findContribution(Component.Composition.Extends);
                                if (contribExtends == null || ctx.isFunction()) {
                                    exprName.log(errs, Severity.ERROR, "COMPILER-186", new Object[0]);
                                    return null;
                                }
                                if (fNoCall) {
                                    exprName.log(errs, Severity.ERROR, "COMPILER-104", new Object[0]);
                                    return null;
                                }
                                TypeConstant typeSuper = pool.ensureAccessTypeConstant(contribExtends.getTypeConstant(), Constants.Access.PROTECTED);
                                MethodConstant idConstruct = (MethodConstant)this.findCallable(ctx, typeSuper, infoSuper = typeSuper.ensureTypeInfo(errs), "construct", TypeInfo.MethodKind.Constructor, false, atypeReturn, ErrorListener.BLACKHOLE);
                                if (idConstruct == null) {
                                    this.log(errs, Severity.ERROR, "COMPILER-103", ctx.getThisType().getValueString(), typeSuper.getValueString());
                                    return null;
                                }
                                MethodStructure ctor = this.getMethod(ctx, typeSuper, infoSuper, idConstruct);
                                if (ctor == null) {
                                    this.log(errs, Severity.ERROR, "COMPILER-177", idConstruct.getValueString(), typeSuper.getValueString());
                                    return null;
                                }
                                this.m_argMethod = idConstruct;
                                this.m_method = ctor;
                                this.m_fBindTarget = false;
                                return idConstruct;
                            }
                            MethodStructure method = ctx.getMethod();
                            cTypeParams = method.getTypeParamCount();
                            cDefaults = method.getDefaultParamCount();
                            break;
                        }
                    }
                }
                if (this.testFunction(ctx, arg2.getType(), cTypeParams, cDefaults, atypeReturn, errs) == null) {
                    return null;
                }
                this.m_argMethod = arg2;
                return arg2;
            }
            if (arg2 instanceof StatementBlock.TargetInfo) {
                StatementBlock.TargetInfo target = (StatementBlock.TargetInfo)arg2;
                TypeConstant typeTarget = target.getTargetType();
                TypeInfo infoTarget = typeTarget.ensureTypeInfo(errs);
                IdentityConstant id = target.getId();
                if (id instanceof MultiMethodConstant) {
                    TypeInfo.MethodKind kind2 = fConstruct ? TypeInfo.MethodKind.Constructor : (fNoCall && fNoFBind || target.hasThis() ? TypeInfo.MethodKind.Any : TypeInfo.MethodKind.Function);
                    ErrorListener errsTemp = errs.branch(this);
                    MethodConstant idCallable = this.findMethod(ctx, typeTarget, infoTarget, sName, this.args, kind2, !fNoCall, id.isNested(), atypeReturn, errsTemp);
                    if (idCallable == null) {
                        if (kind2 == TypeInfo.MethodKind.Function && this.findMethod(ctx, typeTarget, infoTarget, sName, this.args, TypeInfo.MethodKind.Method, !fNoCall, id.isNested(), atypeReturn, ErrorListener.BLACKHOLE) != null) {
                            if (target.getStepsOut() > 0) {
                                exprName.log(errs, Severity.ERROR, "COMPILER-160", target.getTargetType().removeAccess().getValueString(), sName);
                            } else {
                                exprName.log(errs, Severity.ERROR, "COMPILER-108", sName, target.getTargetType().removeAccess().getValueString());
                            }
                        } else {
                            errsTemp.merge();
                        }
                        return null;
                    }
                    this.m_targetInfo = target;
                    this.m_argMethod = idCallable;
                    this.m_method = this.getMethod(ctx, typeTarget, infoTarget, idCallable);
                    if (this.m_method == null) {
                        this.log(errs, Severity.ERROR, "COMPILER-177", idCallable.getValueString(), typeTarget.getValueString());
                        return null;
                    }
                    this.m_fBindTarget = !this.m_method.isFunction();
                    errsTemp.merge();
                    return idCallable;
                }
                if (id instanceof PropertyConstant) {
                    PropertyConstant idProp = (PropertyConstant)id;
                    PropertyInfo prop = infoTarget.findProperty(idProp);
                    if (prop == null) {
                        this.log(errs, Severity.ERROR, "COMPILER-162", idProp.getName(), target.getTargetType().getValueString());
                        return null;
                    }
                    if (this.testFunction(ctx, prop.getType(), 0, 0, atypeReturn, errs) == null) {
                        return null;
                    }
                    if (prop.isConstant() || infoTarget.isSingleton() || target.hasThis()) {
                        this.m_targetInfo = target;
                        this.m_argMethod = id;
                        return id;
                    }
                    exprName.log(errs, Severity.ERROR, "COMPILER-107", sName, target.getTargetType());
                    return null;
                }
                this.log(errs, Severity.ERROR, "COMPILER-129", target.getName());
                return null;
            }
            assert (!(arg2 instanceof MethodConstant));
            if (arg2 instanceof MultiMethodConstant) {
                TypeInfo infoTarget;
                MultiMethodConstant idMM = (MultiMethodConstant)arg2;
                IdentityConstant idClz = idMM.getParentConstant();
                TypeConstant typeTarget = idClz.getFormalType();
                MethodConstant idMethod4 = this.findMethod(ctx, typeTarget, infoTarget = this.getTypeInfo(ctx, typeTarget, errs), sName, this.args, TypeInfo.MethodKind.Any, !fNoCall, false, atypeReturn, errs);
                if (idMethod4 == null) {
                    return null;
                }
                MethodStructure method = this.getMethod(ctx, typeTarget, infoTarget, idMethod4);
                if (method == null) {
                    this.log(errs, Severity.ERROR, "COMPILER-177", idMethod4.getValueString(), typeTarget.getValueString());
                    return null;
                }
                if (!method.isFunction()) {
                    exprName.log(errs, Severity.ERROR, "COMPILER-107", sName, idMethod4.getParentConstant().getValueString());
                    return null;
                }
                this.m_method = method;
                this.m_argMethod = idMethod4;
                this.m_fBindTarget = false;
                return idMethod4;
            }
            if (arg2 instanceof PropertyConstant) {
                PropertyConstant idProp = (PropertyConstant)arg2;
                return this.testStaticProperty(ctx, idProp, atypeReturn, errs);
            }
            this.log(errs, Severity.ERROR, "COMPILER-129", tokName.getValueText());
            return null;
        }
        if (tokName.isSpecial()) {
            tokName.log(errs, this.getSource(), Severity.ERROR, "COMPILER-15", tokName.getValueText());
            return null;
        }
        boolean fIdentityMode = false;
        if (exprLeft instanceof NameExpression) {
            NameExpression nameLeft = (NameExpression)exprLeft;
            if ("super".equals(nameLeft.getName())) {
                this.log(errs, Severity.ERROR, "COMPILER-104", new Object[0]);
                return null;
            }
            if (nameLeft.isIdentityMode(ctx, true)) {
                TypeInfo infoLeft3;
                Constants.Access access;
                IdentityConstant idLeft = nameLeft.getIdentity(ctx);
                Constants.Access access2 = access = fConstruct ? Constants.Access.PROTECTED : Constants.Access.PUBLIC;
                if (ctx.getThisClassId().isNestMateOf(idLeft)) {
                    access = Constants.Access.PRIVATE;
                }
                if (nameLeft.getMeaning() == NameExpression.Meaning.Type) {
                    assert (typeLeft.isTypeOfType());
                    if (access != (typeLeft = typeLeft.getParamType(0)).getAccess()) {
                        typeLeft = pool.ensureAccessTypeConstant(typeLeft, access);
                    }
                    infoLeft3 = typeLeft.ensureTypeInfo(errs);
                } else if (fConstruct) {
                    ClassStructure clzThis = ctx.getThisClass();
                    Component.Contribution contrib = clzThis.findContribution(idLeft);
                    if (contrib == null) {
                        this.log(errs, Severity.ERROR, "COMPILER-156", idLeft.getValueString());
                        return null;
                    }
                    TypeConstant typeContrib = contrib.getTypeConstant();
                    switch (contrib.getComposition()) {
                        case Equal: {
                            assert (typeContrib.equals(ctx.getThisType()));
                            access = Constants.Access.PRIVATE;
                            break;
                        }
                        case Annotation: 
                        case Incorporates: {
                            TypeConstant typeParent;
                            if (!clzThis.isVirtualChild() || !typeContrib.isA(typeParent = ctx.getThisType().getParentType())) break;
                            this.log(errs, Severity.ERROR, "VERIFY-11", clzThis.getIdentityConstant().getPathString(), typeContrib.getValueString());
                            return null;
                        }
                        case Extends: {
                            if (clzThis.getSuper().getIdentityConstant().equals(idLeft)) break;
                            this.log(errs, Severity.WARNING, "COMPILER-157", new Object[0]);
                            break;
                        }
                    }
                    typeLeft = pool.ensureAccessTypeConstant(typeContrib, access);
                    infoLeft3 = typeLeft.ensureTypeInfo(errs);
                } else {
                    TypeConstant typeTarget = idLeft.getType();
                    if (access != Constants.Access.PUBLIC) {
                        typeTarget = typeTarget.ensureAccess(access);
                    }
                    infoLeft3 = typeTarget.ensureTypeInfo(errs);
                    if (typeTarget.isParamsSpecified()) {
                        if (infoLeft3.isSingleton() || typeTarget.isA(pool.typeClass())) {
                            exprLeft.log(errs, Severity.ERROR, "COMPILER-12", new Object[0]);
                            return null;
                        }
                        this.m_typeTarget = typeTarget;
                    }
                }
                fSingleton = infoLeft3.isSingleton();
                TypeInfo.MethodKind kind3 = fConstruct ? TypeInfo.MethodKind.Constructor : (fNoFBind && fNoCall || fSingleton ? TypeInfo.MethodKind.Any : TypeInfo.MethodKind.Function);
                ErrorListener errsTemp = errs.branch(this);
                IdentityConstant arg3 = this.findCallable(ctx, infoLeft3.getType(), infoLeft3, sName, kind3, false, atypeReturn, errsTemp);
                if (arg3 == null && kind3 == TypeInfo.MethodKind.Function && this.findCallable(ctx, infoLeft3.getType(), infoLeft3, sName, TypeInfo.MethodKind.Any, false, atypeReturn, ErrorListener.BLACKHOLE) != null) {
                    exprName.log(errs, Severity.ERROR, "COMPILER-108", sName, infoLeft3.getType().getValueString());
                    return null;
                }
                if (arg3 instanceof MethodConstant) {
                    idMethod2 = (MethodConstant)arg3;
                    errsTemp.merge();
                    MethodInfo infoMethod = infoLeft3.getMethodById(idMethod2);
                    assert (infoMethod != null);
                    if (infoMethod.isAbstractFunction()) {
                        this.log(errs, Severity.ERROR, "COMPILER-127", idMethod2.getValueString());
                        return null;
                    }
                    this.m_argMethod = idMethod2;
                    this.m_method = infoMethod.getTopmostMethodStructure(infoLeft3);
                    this.m_fBindTarget = fSingleton && !this.m_method.isFunction();
                    return idMethod2;
                }
                if (arg3 instanceof PropertyConstant) {
                    PropertyConstant idProp = (PropertyConstant)arg3;
                    errsTemp.merge();
                    return this.testStaticProperty(ctx, idProp, atypeReturn, errs);
                }
                fIdentityMode = true;
            }
            switch (nameLeft.getMeaning()) {
                case Class: {
                    fSingleton = typeLeft.ensureTypeInfo(errs).isSingleton();
                    break;
                }
                case Property: {
                    ErrorListener errsTemp;
                    TypeInfo infoType;
                    TypeConstant type;
                    IdentityConstant arg4;
                    PropertyConstant idProp = (PropertyConstant)nameLeft.resolveRawArgument(ctx, false, errs);
                    if (!idProp.isFormalType() || !((arg4 = this.findCallable(ctx, type = nameLeft.getImplicitType(ctx).getParamType(0), infoType = this.getTypeInfo(ctx, type, errs), sName, TypeInfo.MethodKind.Function, false, atypeReturn, errsTemp = errs.branch(this))) instanceof MethodConstant)) break;
                    idMethod = (MethodConstant)arg4;
                    this.m_argMethod = idMethod;
                    this.m_method = this.getMethod(ctx, type, infoType, idMethod);
                    if (this.m_method == null) {
                        this.log(errs, Severity.ERROR, "COMPILER-177", idMethod.getValueString(), type.getValueString());
                        return null;
                    }
                    this.m_fBindTarget = false;
                    this.m_idFormal = idProp;
                    errsTemp.merge();
                    return idMethod;
                }
                case FormalChildType: {
                    ErrorListener errsTemp;
                    TypeInfo infoFormal;
                    assert (typeLeft.isTypeOfType());
                    TypeConstant typeFormal = typeLeft.getParamType(0);
                    IdentityConstant arg5 = this.findCallable(ctx, typeFormal, infoFormal = typeFormal.ensureTypeInfo(errs), sName, TypeInfo.MethodKind.Function, false, atypeReturn, errsTemp = errs.branch(this));
                    if (!(arg5 instanceof MethodConstant)) break;
                    MethodConstant idMethod5 = (MethodConstant)arg5;
                    this.m_argMethod = idMethod5;
                    this.m_method = this.getMethod(ctx, typeFormal, infoFormal, idMethod5);
                    if (this.m_method == null) {
                        this.log(errs, Severity.ERROR, "COMPILER-177", idMethod5.getValueString(), typeFormal.getValueString());
                        return null;
                    }
                    this.m_fBindTarget = false;
                    this.m_idFormal = (FormalTypeChildConstant)nameLeft.getIdentity(ctx);
                    errsTemp.merge();
                    return idMethod5;
                }
            }
        }
        if ((arg = this.findCallable(ctx, typeLeft, infoLeft = this.getTypeInfo(ctx, typeLeft, errs), sName, kind = fConstruct ? TypeInfo.MethodKind.Constructor : (fSingleton ? TypeInfo.MethodKind.Any : TypeInfo.MethodKind.Method), false, atypeReturn, errsMain = errs.branch(this))) != null) {
            if (arg instanceof MethodConstant) {
                MethodConstant idMethod6 = (MethodConstant)arg;
                this.m_argMethod = idMethod6;
                this.m_method = this.getMethod(ctx, typeLeft, infoLeft, idMethod6);
                if (this.m_method == null) {
                    this.log(errs, Severity.ERROR, "COMPILER-177", idMethod6.getValueString(), typeLeft.getValueString());
                    return null;
                }
                this.m_fBindTarget = !this.m_method.isFunction();
            } else assert (arg instanceof PropertyConstant);
            errsMain.merge();
            return arg;
        }
        if (typeLeft.isFormalTypeType()) {
            ErrorListener errsAlt;
            TypeInfo infoConstraint;
            FormalConstant idFormal = (FormalConstant)typeLeft.getParamType(0).getDefiningConstant();
            TypeConstant typeConstraint = idFormal.getConstraintType();
            MethodConstant idMethod7 = this.findMethod(ctx, typeConstraint, infoConstraint = this.getTypeInfo(ctx, typeConstraint, errs), sName, this.args, TypeInfo.MethodKind.Function, !fNoCall, false, atypeReturn, errsAlt = errs.branch(this));
            if (idMethod7 != null) {
                this.m_argMethod = idMethod7;
                this.m_method = this.getMethod(ctx, typeConstraint, infoConstraint, idMethod7);
                if (this.m_method == null) {
                    this.log(errs, Severity.ERROR, "COMPILER-177", idMethod7.getValueString(), typeConstraint.getValueString());
                    return null;
                }
                this.m_fBindTarget = false;
                this.m_idFormal = idFormal;
                errsAlt.merge();
                return idMethod7;
            }
        } else if (typeLeft.isTypeOfType()) {
            ErrorListener errsAlt;
            TypeInfo infoDataType;
            TypeConstant typeDataType = typeLeft.getParamType(0);
            idMethod2 = this.findMethod(ctx, typeDataType, infoDataType = this.getTypeInfo(ctx, typeDataType, errs), sName, this.args, TypeInfo.MethodKind.Function, !fNoCall, false, atypeReturn, errsAlt = errs.branch(this));
            if (idMethod2 != null) {
                this.m_argMethod = idMethod2;
                this.m_method = this.getMethod(ctx, typeDataType, infoDataType, idMethod2);
                if (this.m_method == null) {
                    this.log(errs, Severity.ERROR, "COMPILER-177", idMethod2.getValueString(), typeDataType.getValueString());
                    return null;
                }
                this.m_fBindTarget = false;
                this.m_idFormal = (PropertyConstant)pool.clzType().getComponent().getChild("DataType").getIdentityConstant();
                errsAlt.merge();
                return idMethod2;
            }
        } else if (!(this.isSuppressCall() || this.isAnyArgUnbound() || fIdentityMode)) {
            ArrayList<Expression> listArgs = new ArrayList<Expression>(this.args);
            listArgs.add(0, exprLeft);
            ErrorListener errsAlt = errs.branch(this);
            idMethod = this.findMethod(ctx, typeLeft, infoLeft, sName, listArgs, TypeInfo.MethodKind.Function, !fNoCall, false, atypeReturn, errsAlt);
            if (idMethod != null) {
                this.m_argMethod = idMethod;
                this.m_method = this.getMethod(ctx, typeLeft, infoLeft, idMethod);
                if (this.m_method == null) {
                    this.log(errs, Severity.ERROR, "COMPILER-177", idMethod.getValueString(), typeLeft.getValueString());
                    return null;
                }
                this.m_fBindTarget = false;
                this.m_fBjarne = true;
                errsAlt.merge();
                return idMethod;
            }
        }
        if (exprLeft instanceof NameExpression) {
            NameExpression nameLeft = (NameExpression)exprLeft;
            if (typeLeft.isA(pool.typeFunction()) && errsMain.hasError("COMPILER-56") && infoLeft.findMethods(sName, -1, TypeInfo.MethodKind.Any).isEmpty()) {
                IdentityConstant idParent;
                if (nameLeft.isIdentityMode(ctx, false)) {
                    v1 = nameLeft.getIdentity(ctx).getNamespace();
                } else {
                    switch (nameLeft.getMeaning()) {
                        case Property: {
                            v1 = ((PropertyConstant)nameLeft.resolveRawArgument(ctx, false, errs)).getNamespace();
                            break;
                        }
                        case Variable: {
                            v1 = ctx.getMethod().getIdentityConstant();
                            break;
                        }
                        default: {
                            v1 = idParent = null;
                        }
                    }
                }
                if (idParent != null) {
                    this.log(errsMain, Severity.ERROR, "COMPILER-138", nameLeft.getName(), idParent.getValueString());
                }
            }
        }
        errsMain.merge();
        return null;
    }

    private MethodStructure getMethod(Context ctx, MethodConstant idMethod) {
        MethodStructure method = this.m_method;
        if (method == null && (method = (MethodStructure)idMethod.getComponent()) == null) {
            TypeConstant type = this.m_targetInfo.getTargetType();
            TypeInfo info = this.getTypeInfo(ctx, type, ErrorListener.BLACKHOLE);
            method = this.getMethod(ctx, type, info, idMethod);
        }
        return method;
    }

    private MethodStructure getMethod(Context ctx, TypeConstant typeTarget, TypeInfo infoTarget, MethodConstant idMethod) {
        MethodInfo infoMethod = infoTarget.getMethodById(idMethod);
        if (infoMethod != null && !typeTarget.isAccessSpecified() && infoTarget.getType().getAccess() != Constants.Access.PRIVATE && !infoMethod.isVisible(ctx.getThisClassId())) {
            return null;
        }
        return infoMethod.getTopmostMethodStructure(infoTarget);
    }

    private PropertyStructure getProperty(Context ctx, PropertyConstant idProp) {
        PropertyStructure prop = (PropertyStructure)idProp.getComponent();
        if (prop == null) {
            TypeConstant type = this.m_targetInfo.getTargetType();
            TypeInfo info = this.getTypeInfo(ctx, type, ErrorListener.BLACKHOLE);
            prop = info.findProperty(idProp).getHead().getStructure();
        }
        return prop;
    }

    protected IdentityConstant findCallable(Context ctx, TypeConstant typeParent, TypeInfo infoParent, String sName, TypeInfo.MethodKind kind, boolean fAllowNested, TypeConstant[] aRedundant, ErrorListener errs) {
        PropertyInfo prop = infoParent.findProperty(sName);
        if (prop != null) {
            return prop.getIdentity();
        }
        if (sName.equals("new")) {
            sName = "construct";
            kind = TypeInfo.MethodKind.Constructor;
            aRedundant = TypeConstant.NO_TYPES;
        }
        return this.findMethod(ctx, typeParent, infoParent, sName, this.args, kind, this.m_fCall, fAllowNested, aRedundant, errs);
    }

    protected Argument testStaticProperty(Context ctx, PropertyConstant idProp, TypeConstant[] atypeReturn, ErrorListener errs) {
        ConstantPool pool = this.pool();
        String sName = idProp.getName();
        PropertyStructure prop = (PropertyStructure)idProp.getComponent();
        if (!prop.isConstant()) {
            this.expr.log(errs, Severity.ERROR, "COMPILER-107", sName, idProp.getParentConstant().getValueString());
            return null;
        }
        if (this.testFunction(ctx, prop.getType(), 0, 0, atypeReturn, errs) == null) {
            this.expr.log(errs, Severity.ERROR, "COMPILER-134", sName, pool.typeFunction().getValueString());
            return null;
        }
        this.m_typeTarget = idProp.getParentConstant().getType();
        this.m_argMethod = idProp;
        return idProp;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected TypeConstant testFunction(Context ctx, TypeConstant typeFn, int cTypeParams, int cDefaults, TypeConstant[] atypeReturn, ErrorListener errs) {
        TypeConstant[] atypeParams;
        ConstantPool pool = this.pool();
        typeFn = typeFn.resolveTypedefs();
        boolean fFunction = typeFn.isA(pool.typeFunction());
        MethodConstant idConvert = null;
        if (!fFunction) {
            if (typeFn.isA(pool.typeMethod())) {
                TypeConstant typeTarget;
                if (!ctx.isMethod()) {
                    this.log(errs, Severity.ERROR, "COMPILER-52", new Object[0]);
                    return null;
                }
                TypeConstant typeThis = ctx.getThisType();
                if (!typeThis.isA(typeTarget = typeFn.getParamType(0))) {
                    this.log(errs, Severity.ERROR, "COMPILER-58", typeTarget.getValueString(), typeThis.getValueString());
                    return null;
                }
                ctx.requireThis(this.getStartPosition(), errs);
            } else {
                idConvert = typeFn.getConverterTo(pool.typeFunction());
                if (idConvert == null) {
                    this.log(errs, Severity.ERROR, "COMPILER-43", "Function", typeFn.getValueString());
                    return null;
                }
                typeFn = idConvert.getRawReturns()[0];
            }
        }
        if ((atypeParams = pool.extractFunctionParams(typeFn)) == null) {
            this.log(errs, Severity.ERROR, "COMPILER-55", new Object[0]);
            return null;
        }
        if (this.m_fNamedArgs) {
            this.log(errs, Severity.ERROR, "COMPILER-141", new Object[0]);
            return null;
        }
        int cAllParams = atypeParams.length;
        int cVisible = cAllParams - cTypeParams;
        int cRequired = cVisible - cDefaults;
        boolean fValid = true;
        List<Expression> listArgs = this.args;
        int cArgs = listArgs.size();
        if (cArgs > cVisible || cArgs < cRequired) {
            this.log(errs, Severity.ERROR, "COMPILER-84", cRequired, cArgs);
            fValid = false;
        }
        int c = Math.min(cVisible, cArgs);
        for (int i = 0; i < c; ctx = ctx.exit(), ++i) {
            TypeConstant typeParam = atypeParams[cTypeParams + i];
            Expression exprArg = listArgs.get(i);
            if (exprArg.testFit(ctx = ctx.enterInferring(typeParam), typeParam, false, errs).isFit()) continue;
            if (!errs.hasSeriousErrors()) {
                this.log(errs, Severity.ERROR, "COMPILER-43", typeParam.getValueString(), exprArg.getTypeString(ctx));
            }
            fValid = false;
        }
        if (cArgs < cVisible) {
            typeFn = pool.buildFunctionType(Arrays.copyOfRange(atypeParams, 0, cArgs), pool.extractFunctionReturns(typeFn));
        }
        if (atypeReturn != null) {
            TypeConstant[] atypeFnRet = pool.extractFunctionReturns(typeFn);
            if (atypeFnRet == null) {
                this.log(errs, Severity.ERROR, "COMPILER-55", new Object[0]);
                return null;
            }
            Expression.TypeFit fit = this.calculateReturnFit(atypeFnRet, this.expr.toString(), this.m_fCall, atypeReturn, ctx.getThisType(), errs);
            this.m_fPack = fit.isPacking();
            fValid = fit.isFit();
        }
        if (fValid) {
            this.m_idConvert = idConvert;
            return typeFn;
        }
        return null;
    }

    protected TypeConstant[] validateFunction(Context ctx, TypeConstant typeFn, int cTypeParams, int cDefaults, TypeConstant[] atypeRequired, ErrorListener errs) {
        TypeConstant typeReqFn;
        ConstantPool pool = this.pool();
        TypeConstant[] atypeParams = pool.extractFunctionParams(typeFn);
        int cAllParams = atypeParams.length;
        int cVisible = cAllParams - cTypeParams;
        int cRequired = cVisible - cDefaults;
        int cArgs = this.args.size();
        if (cArgs > cVisible || cArgs < cRequired) {
            this.log(errs, Severity.ERROR, "COMPILER-84", cRequired, cArgs);
            return null;
        }
        if (cTypeParams > 0) {
            atypeParams = Arrays.copyOfRange(atypeParams, cTypeParams, cAllParams);
        }
        if (this.validateExpressions(ctx, this.args, atypeParams, errs) == null) {
            return null;
        }
        if (this.m_fCall) {
            TypeConstant[] typeConstantArray;
            if (this.m_fPack) {
                TypeConstant[] typeConstantArray2 = new TypeConstant[1];
                typeConstantArray = typeConstantArray2;
                typeConstantArray2[0] = typeFn.getParamType(1);
            } else {
                typeConstantArray = pool.extractFunctionReturns(typeFn);
            }
            return typeConstantArray;
        }
        if (this.m_fBindParams) {
            typeFn = this.bindFunctionParameters(typeFn);
        }
        if (atypeRequired != null && atypeRequired.length > 0 && !(typeReqFn = atypeRequired[0]).equals(pool.typeObject())) {
            int cFnParams;
            TypeConstant[] atypeReqParams = pool.extractFunctionParams(typeReqFn);
            TypeConstant[] atypeFnParams = pool.extractFunctionParams(typeFn);
            int cReqParams = atypeReqParams == null ? 0 : atypeReqParams.length;
            int n = cFnParams = atypeFnParams == null ? 0 : atypeFnParams.length;
            if (cReqParams < cFnParams) {
                this.log(errs, Severity.ERROR, "COMPILER-43", typeReqFn, typeFn);
                return null;
            }
        }
        return new TypeConstant[]{typeFn};
    }

    protected TypeConstant[] calculateReturnType(TypeConstant typeFn) {
        if (this.m_fCall) {
            TypeConstant[] typeConstantArray;
            TypeConstant[] atypeReturn = this.pool().extractFunctionReturns(typeFn);
            if (atypeReturn == null) {
                typeConstantArray = TypeConstant.NO_TYPES;
            } else if (this.m_fPack) {
                TypeConstant[] typeConstantArray2 = new TypeConstant[1];
                typeConstantArray = typeConstantArray2;
                typeConstantArray2[0] = this.pool().ensureTupleType(atypeReturn);
            } else {
                typeConstantArray = atypeReturn;
            }
            return typeConstantArray;
        }
        if (this.m_fBindParams) {
            if (this.args.size() > this.pool().extractFunctionParams(typeFn).length) {
                return TypeConstant.NO_TYPES;
            }
            typeFn = this.bindFunctionParameters(typeFn);
        }
        return new TypeConstant[]{typeFn};
    }

    private GenericTypeResolver makeTypeParameterResolver(Context ctx, MethodStructure method, boolean fAllowPending, TypeConstant typeTarget, TypeConstant[] atypeReturn, ErrorListener errs) {
        List<Expression> listArgs = this.args;
        int cArgs = listArgs.size();
        TypeConstant[] atypeArgs = new TypeConstant[cArgs];
        for (int i = 0; i < cArgs; ++i) {
            atypeArgs[i] = listArgs.get(i).getImplicitType(ctx);
        }
        this.transformTypeArguments(ctx, listArgs, atypeArgs);
        ListMap<FormalConstant, TypeConstant> mapTypeParams = method.resolveTypeParameters(this.pool(), typeTarget, atypeArgs, atypeReturn, fAllowPending);
        if (mapTypeParams.size() == method.getTypeParamCount()) {
            return GenericTypeResolver.of(mapTypeParams);
        }
        this.log(errs, Severity.ERROR, "COMPILER-145", method.collectUnresolvedTypeParameters(mapTypeParams.keySet().stream().map(NamedConstant::getName).collect(Collectors.toSet())));
        return null;
    }

    private TypeConstant[] resolveTypes(GenericTypeResolver resolver, TypeConstant[] atype) {
        TypeConstant[] atypeResolved = atype;
        if (resolver != null) {
            ConstantPool pool = this.pool();
            int c = atype.length;
            for (int i = 0; i < c; ++i) {
                TypeConstant typeOriginal = atype[i];
                TypeConstant typeResolved = typeOriginal.resolveGenerics(pool, resolver);
                if (typeResolved == typeOriginal) continue;
                if (atypeResolved == atype) {
                    atypeResolved = (TypeConstant[])atype.clone();
                }
                atypeResolved[i] = typeResolved;
            }
        }
        return atypeResolved;
    }

    private TypeConstant bindFunctionParameters(TypeConstant typeFn) {
        ConstantPool pool = this.pool();
        List<Expression> listArgs = this.args;
        for (int i = listArgs.size() - 1; i >= 0; --i) {
            Expression expr = listArgs.get(i);
            if (expr.isNonBinding()) continue;
            typeFn = pool.bindFunctionParam(typeFn, i);
        }
        return typeFn;
    }

    private TypeConstant removeTypeParameters(TypeConstant typeFn, int cTypeParams) {
        ConstantPool pool = this.pool();
        TypeConstant[] atypeParams = pool.extractFunctionParams(typeFn);
        return pool.buildFunctionType(Arrays.copyOfRange(atypeParams, cTypeParams, atypeParams.length), pool.extractFunctionReturns(typeFn));
    }

    private MethodConstant rebaseMethodConstant(MethodConstant idMethod, MethodStructure method) {
        if (!method.equals(idMethod.getComponent())) {
            Component parentMethod;
            Component parentId;
            if (method.getAccess() == Constants.Access.PRIVATE) {
                idMethod = method.getIdentityConstant();
            } else if (idMethod.isTopLevel() && !(parentId = idMethod.getNamespace().getComponent()).equals(parentMethod = method.getParent().getParent())) {
                idMethod = this.pool().ensureMethodConstant(parentMethod.getIdentityConstant(), idMethod.getSignature());
            }
        }
        return idMethod;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.expr);
        if (this.async) {
            sb.append('^');
        }
        sb.append('(');
        boolean first = true;
        for (Expression arg : this.args) {
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            sb.append(arg);
        }
        sb.append(')');
        return sb.toString();
    }

    @Override
    public String getDumpDesc() {
        return this.toString();
    }

    static int combine(int p, int r) {
        return p << 8 | r;
    }
}

