/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.compiler.ast;

import org.xvm.asm.Argument;
import org.xvm.asm.Constant;
import org.xvm.asm.ConstantPool;
import org.xvm.asm.ErrorListener;
import org.xvm.asm.MethodStructure;
import org.xvm.asm.Register;
import org.xvm.asm.ast.ExprAST;
import org.xvm.asm.ast.IsExprAST;
import org.xvm.asm.constants.FormalConstant;
import org.xvm.asm.constants.TypeConstant;
import org.xvm.asm.op.IsType;
import org.xvm.asm.op.JumpFalse;
import org.xvm.asm.op.JumpNType;
import org.xvm.asm.op.JumpType;
import org.xvm.asm.op.Label;
import org.xvm.asm.op.Move;
import org.xvm.compiler.Token;
import org.xvm.compiler.ast.BiExpression;
import org.xvm.compiler.ast.Context;
import org.xvm.compiler.ast.Expression;
import org.xvm.compiler.ast.NameExpression;
import org.xvm.compiler.ast.NamedTypeExpression;
import org.xvm.util.Severity;

public class IsExpression
extends BiExpression {
    private final long lEndPos;

    public IsExpression(Expression expr1, Token operator, Expression expr2, Token tokClose) {
        super(expr1, operator, expr2);
        this.lEndPos = tokClose.getEndPosition();
    }

    @Override
    public long getEndPosition() {
        return this.lEndPos;
    }

    @Override
    protected boolean hasSingleValueImpl() {
        return false;
    }

    @Override
    protected boolean hasMultiValueImpl() {
        return true;
    }

    @Override
    public TypeConstant[] getImplicitTypes(Context ctx) {
        TypeConstant type = this.expr2.getImplicitType(ctx);
        return new TypeConstant[]{this.pool().typeBoolean(), type == null || type.containsUnresolved() ? this.pool().typeObject() : type.getParamType(0)};
    }

    @Override
    protected Expression validateMulti(Context ctx, TypeConstant[] atypeRequired, ErrorListener errs) {
        Constant[] aconstVal;
        TypeConstant[] atypeActual;
        Expression.TypeFit fit;
        block26: {
            boolean fSingle;
            block23: {
                TypeConstant typeInferred;
                TypeConstant typeTest;
                TypeConstant typeTarget;
                Expression exprTest;
                ConstantPool pool;
                Expression exprTarget;
                block24: {
                    block25: {
                        fit = Expression.TypeFit.Fit;
                        exprTarget = this.expr1.validate(ctx, null, errs);
                        if (exprTarget == null) {
                            fit = Expression.TypeFit.NoFit;
                        } else {
                            this.expr1 = exprTarget;
                        }
                        pool = this.pool();
                        exprTest = this.expr2.validate(ctx, pool.typeType(), errs);
                        if (exprTest == null) {
                            fit = Expression.TypeFit.NoFit;
                        } else {
                            this.expr2 = exprTest;
                        }
                        fSingle = atypeRequired == null || atypeRequired.length <= 1;
                        atypeActual = new TypeConstant[fSingle ? 1 : 2];
                        aconstVal = null;
                        if (!fSingle && !this.getParent().allowsConditional(this)) {
                            this.log(errs, Severity.ERROR, "COMPILER-139", "(Boolean, Object) is()");
                            return null;
                        }
                        atypeActual[0] = pool.typeBoolean();
                        if (!fit.isFit()) break block23;
                        typeTarget = exprTarget.getType();
                        if (typeTarget.isIncompatibleCombo(typeTest = exprTest.getType().getParamType(0).resolveAutoNarrowingBase())) {
                            this.log(errs, Severity.ERROR, "COMPILER-187", exprTarget.toString(), typeTarget.getValueString(), typeTest.getValueString());
                            return null;
                        }
                        typeInferred = typeTest;
                        if (typeTest.isFormalType() || !exprTest.isConstant()) break block24;
                        if (!typeTarget.isTypeOfType()) break block25;
                        if (!typeTest.isTypeOfType()) {
                            if (pool.typeConst().isA(typeTest)) {
                                this.log(errs, Severity.WARNING, "COMPILER-137", exprTarget.toString(), pool.typeType().getValueString(), typeTest.getValueString());
                            } else {
                                this.log(errs, Severity.ERROR, "COMPILER-134", exprTarget.toString(), typeTest.getValueString());
                                return null;
                            }
                        }
                        if (typeTarget.getParamType(0).isFormalType()) break block24;
                    }
                    if (typeTarget.isA(typeTest)) {
                        this.log(errs, Severity.WARNING, "COMPILER-137", exprTarget.toString(), typeTarget.getValueString(), typeTest.getValueString());
                    }
                }
                if (exprTarget.isConstant()) {
                    NamedTypeExpression exprNameType;
                    if (exprTest.isConstant() && fSingle) {
                        aconstVal = new Constant[]{pool.valOf(typeTarget.isA(typeTest))};
                    } else if (exprTest instanceof NamedTypeExpression && !(exprNameType = (NamedTypeExpression)exprTest).isDynamic() && typeTest.isFormalType()) {
                        FormalConstant constTest = (FormalConstant)typeTest.getDefiningConstant();
                        ctx.replaceGenericType(constTest, Context.Branch.WhenTrue, typeTest.union(pool, typeTarget).getType());
                    }
                } else if (exprTarget instanceof NameExpression) {
                    NameExpression exprName = (NameExpression)exprTarget;
                    TypeConstant typeTrue = typeTarget.combine(pool, typeTest);
                    TypeConstant typeFalse = typeTarget.andNot(pool, typeTest);
                    exprName.narrowType(ctx, Context.Branch.WhenTrue, typeTrue);
                    if (typeFalse != null) {
                        exprName.narrowType(ctx, Context.Branch.WhenFalse, typeFalse);
                    }
                    typeInferred = typeTrue;
                }
                if (!fSingle) {
                    atypeActual[1] = typeInferred;
                }
                break block26;
            }
            if (!fSingle) {
                atypeActual[1] = atypeRequired[1];
            }
        }
        return this.finishValidations(ctx, atypeRequired, atypeActual, fit, aconstVal, errs);
    }

    @Override
    public boolean isConditionalResult() {
        return true;
    }

    @Override
    public void generateAssignments(Context ctx, MethodStructure.Code code, Expression.Assignable[] aLVal, ErrorListener errs) {
        Argument argType;
        int cLVals = aLVal.length;
        if (cLVals == 0) {
            return;
        }
        if (!aLVal[0].isLocalArgument()) {
            super.generateAssignments(ctx, code, aLVal, errs);
            return;
        }
        Argument argCond = aLVal[0].getLocalArgument();
        Argument argTarget = this.expr1.generateArgument(ctx, code, true, cLVals == 1, errs);
        Expression exprTest = this.expr2;
        if (exprTest.isConstant()) {
            argType = exprTest.getType().getParamType(0).resolveAutoNarrowingBase();
        } else {
            argType = exprTest.generateArgument(ctx, code, false, true, errs);
            if (argType instanceof TypeConstant) {
                Argument type = argType;
                argType = ((TypeConstant)type).getParamType(0);
            }
        }
        code.add(new IsType(argTarget, argType, argCond));
        if (cLVals > 1) {
            if (argCond.isStack()) {
                Expression.Assignable varDupe = this.createTempVar(code, this.pool().typeBoolean(), false);
                Register regDupe = varDupe.getRegister();
                code.add(new Move(argCond, regDupe));
                code.add(new Move(regDupe, argCond));
                argCond = regDupe;
            }
            Label label = new Label("skip_assign");
            code.add(new JumpFalse(argCond, label));
            aLVal[1].assign(argTarget, code, errs);
            code.add(label);
        }
    }

    @Override
    public void generateConditionalJump(Context ctx, MethodStructure.Code code, Label label, boolean fWhenTrue, ErrorListener errs) {
        Argument argTarget = this.expr1.generateArgument(ctx, code, true, true, errs);
        TypeConstant argType = this.expr2.getType().getParamType(0).resolveAutoNarrowingBase();
        code.add(fWhenTrue ? new JumpType(argTarget, argType, label) : new JumpNType(argTarget, argType, label));
    }

    @Override
    public ExprAST getExprAST(Context ctx) {
        TypeConstant[] atypeRet = this.getTypes();
        return new IsExprAST(this.expr1.getExprAST(ctx), this.expr2.getExprAST(ctx), atypeRet.length == 1 ? null : atypeRet[1]);
    }

    @Override
    public String toString() {
        return String.valueOf(this.expr1) + "." + this.operator.getId().TEXT + "(" + String.valueOf(this.expr2) + ")";
    }
}

