/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.compiler.ast;

import org.xvm.asm.Constant;
import org.xvm.asm.ConstantPool;
import org.xvm.asm.ErrorListener;
import org.xvm.asm.constants.TypeConstant;
import org.xvm.compiler.Token;
import org.xvm.compiler.ast.Context;
import org.xvm.compiler.ast.TypeExpression;
import org.xvm.util.Severity;

public class KeywordTypeExpression
extends TypeExpression {
    protected Token keyword;

    public KeywordTypeExpression(Token keyword) {
        this.keyword = keyword;
    }

    public Token getKeyword() {
        return this.keyword;
    }

    @Override
    public long getStartPosition() {
        return this.keyword.getStartPosition();
    }

    @Override
    public long getEndPosition() {
        return this.keyword.getEndPosition();
    }

    @Override
    protected TypeConstant instantiateTypeConstant(Context ctx, ErrorListener errs) {
        ConstantPool pool = this.pool();
        if (this.keyword.getId() == Token.Id.ANY) {
            this.log(errs, Severity.ERROR, "COMPILER-15", this.keyword.getValueText());
            return pool.typeObject();
        }
        return switch (this.keyword.getId()) {
            case Token.Id.IMMUTABLE -> pool.ensureImmutableTypeConstant(pool.typeObject());
            case Token.Id.SERVICE -> pool.ensureServiceTypeConstant(pool.typeObject());
            case Token.Id.CONST -> pool.ensureTerminalTypeConstant(pool.ensureKeywordConstant(Constant.Format.IsConst));
            case Token.Id.ENUM -> pool.ensureTerminalTypeConstant(pool.ensureKeywordConstant(Constant.Format.IsEnum));
            case Token.Id.MODULE -> pool.ensureTerminalTypeConstant(pool.ensureKeywordConstant(Constant.Format.IsModule));
            case Token.Id.PACKAGE -> pool.ensureTerminalTypeConstant(pool.ensureKeywordConstant(Constant.Format.IsPackage));
            case Token.Id.CLASS -> pool.ensureTerminalTypeConstant(pool.ensureKeywordConstant(Constant.Format.IsClass));
            default -> throw new IllegalStateException("keyword=" + String.valueOf(this.keyword));
        };
    }

    @Override
    public String toString() {
        return this.keyword.getId().TEXT;
    }

    @Override
    public String getDumpDesc() {
        return this.toString();
    }
}

