/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.compiler.ast;

import java.lang.reflect.Field;
import org.xvm.asm.ErrorListener;
import org.xvm.asm.MethodStructure;
import org.xvm.asm.Register;
import org.xvm.compiler.Token;
import org.xvm.compiler.ast.Context;
import org.xvm.compiler.ast.LabelAble;
import org.xvm.compiler.ast.Statement;
import org.xvm.util.Severity;

public class LabeledStatement
extends Statement
implements LabelAble {
    protected Token label;
    protected Statement stmt;
    private static final Field[] CHILD_FIELDS = LabeledStatement.fieldsForNames(LabeledStatement.class, "stmt");

    public LabeledStatement(Token label, Statement stmt) {
        this.label = label;
        this.stmt = stmt;
    }

    public String getName() {
        return this.label.getValueText();
    }

    @Override
    public long getStartPosition() {
        return this.label.getStartPosition();
    }

    @Override
    public long getEndPosition() {
        return this.stmt.getEndPosition();
    }

    @Override
    protected Field[] getChildFields() {
        return CHILD_FIELDS;
    }

    @Override
    public boolean hasLabelVar(String sName) {
        return this.stmt instanceof LabelAble && ((LabelAble)((Object)this.stmt)).hasLabelVar(sName);
    }

    @Override
    public Register getLabelVar(Context ctx, String sName) {
        return ((LabelAble)((Object)this.stmt)).getLabelVar(ctx, sName);
    }

    @Override
    protected Statement validateImpl(Context ctx, ErrorListener errs) {
        String sName = this.label.getValueText();
        if (ctx.getVar(sName) != null) {
            this.label.log(errs, this.getSource(), Severity.ERROR, "COMPILER-93", sName);
        }
        ctx.registerVar(this.label, new LabelVar(), errs);
        Statement stmtOld = this.stmt;
        Statement stmtNew = stmtOld.validate(ctx, errs);
        if (stmtNew == null) {
            return null;
        }
        this.stmt = stmtNew;
        ctx.unregisterVar(this.label);
        return this;
    }

    @Override
    protected boolean emit(Context ctx, boolean fReachable, MethodStructure.Code code, ErrorListener errs) {
        return this.stmt.completes(ctx, fReachable, code, errs);
    }

    @Override
    public String toString() {
        return String.valueOf(this.label.getValue()) + ": " + String.valueOf(this.stmt);
    }

    @Override
    public String getDumpDesc() {
        return String.valueOf(this.label.getValue()) + ":";
    }

    public class LabelVar
    extends Register {
        public LabelVar() {
            super(LabeledStatement.this.pool().ensureEcstasyTypeConstant("reflect.Label"), null, -16);
        }

        public boolean isPropReadable(String sProp) {
            Statement stmt = LabeledStatement.this.stmt;
            return stmt instanceof LabelAble && ((LabelAble)((Object)stmt)).hasLabelVar(sProp);
        }

        public void markPropRead(Context ctx, String sProp) {
            assert (this.isPropReadable(sProp));
            ((LabelAble)((Object)LabeledStatement.this.stmt)).getLabelVar(ctx, sProp);
        }

        public Register getPropRegister(Context ctx, String sProp) {
            assert (this.isPropReadable(sProp));
            return ((LabelAble)((Object)LabeledStatement.this.stmt)).getLabelVar(ctx, sProp);
        }

        @Override
        public String toString() {
            return LabeledStatement.this.getName() + ":";
        }
    }
}

