/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.compiler.ast;

import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.xvm.asm.Argument;
import org.xvm.asm.Assignment;
import org.xvm.asm.Component;
import org.xvm.asm.ConstantPool;
import org.xvm.asm.ErrorListener;
import org.xvm.asm.GenericTypeResolver;
import org.xvm.asm.MethodStructure;
import org.xvm.asm.MultiMethodStructure;
import org.xvm.asm.Register;
import org.xvm.asm.ast.BindFunctionAST;
import org.xvm.asm.ast.BindMethodAST;
import org.xvm.asm.ast.ConstantExprAST;
import org.xvm.asm.ast.ExprAST;
import org.xvm.asm.ast.OuterExprAST;
import org.xvm.asm.ast.PropertyExprAST;
import org.xvm.asm.ast.UnaryOpExprAST;
import org.xvm.asm.constants.DynamicFormalConstant;
import org.xvm.asm.constants.FormalConstant;
import org.xvm.asm.constants.MethodConstant;
import org.xvm.asm.constants.ParameterizedTypeConstant;
import org.xvm.asm.constants.PendingTypeConstant;
import org.xvm.asm.constants.PropertyConstant;
import org.xvm.asm.constants.SignatureConstant;
import org.xvm.asm.constants.TypeCollector;
import org.xvm.asm.constants.TypeConstant;
import org.xvm.asm.constants.TypeParameterConstant;
import org.xvm.asm.constants.UnionTypeConstant;
import org.xvm.asm.op.FBind;
import org.xvm.asm.op.L_Get;
import org.xvm.asm.op.MBind;
import org.xvm.asm.op.MoveRef;
import org.xvm.asm.op.MoveThis;
import org.xvm.asm.op.MoveVar;
import org.xvm.asm.op.P_Get;
import org.xvm.compiler.Compiler;
import org.xvm.compiler.Token;
import org.xvm.compiler.ast.AstNode;
import org.xvm.compiler.ast.Context;
import org.xvm.compiler.ast.Expression;
import org.xvm.compiler.ast.IgnoredNameExpression;
import org.xvm.compiler.ast.LabeledStatement;
import org.xvm.compiler.ast.NameExpression;
import org.xvm.compiler.ast.Parameter;
import org.xvm.compiler.ast.StageMgr;
import org.xvm.compiler.ast.StatementBlock;
import org.xvm.util.Handy;
import org.xvm.util.Severity;

public class LambdaExpression
extends Expression {
    private static final String[] NO_NAMES = Handy.NO_ARGS;
    private static final String METHOD_NAME = "->";
    protected List<Parameter> params;
    protected List<Expression> paramNames;
    protected Token operator;
    protected StatementBlock body;
    protected long lStartPos;
    private transient boolean m_fPrepared;
    private transient TypeConstant m_typeRequired;
    private transient TypeCollector m_collector;
    private transient MethodStructure m_lambda;
    private transient LambdaContext m_ctxLambda;
    private transient Argument[] m_aBindArgs = NO_RVALUES;
    private transient ExprAST m_astLambda;
    private transient ExprAST[] m_aAstBind;
    private static final Field[] CHILD_FIELDS = LambdaExpression.fieldsForNames(LambdaExpression.class, "params", "paramNames", "body");

    public LambdaExpression(List params, Token operator, StatementBlock body, long lStartPos) {
        if (!params.isEmpty() && params.get(0) instanceof Expression) {
            assert (params.stream().allMatch(Expression.class::isInstance));
            this.paramNames = params;
        } else {
            assert (params.stream().allMatch(Parameter.class::isInstance));
            this.params = params;
        }
        this.operator = operator;
        this.body = body;
        this.lStartPos = lStartPos;
    }

    @Override
    public boolean isComponentNode() {
        return true;
    }

    @Override
    public Component getComponent() {
        MethodStructure method = this.m_lambda;
        return method == null ? super.getComponent() : method;
    }

    public MethodStructure getLambda() {
        return this.m_lambda;
    }

    public boolean hasParameters() {
        return this.paramNames != null && !this.paramNames.isEmpty() || this.params != null && !this.params.isEmpty();
    }

    public int getParamCount() {
        if (this.paramNames != null && !this.paramNames.isEmpty()) {
            return this.paramNames.size();
        }
        if (this.params != null && !this.params.isEmpty()) {
            return this.params.size();
        }
        return 0;
    }

    public String[] getParamNames() {
        int c = this.getParamCount();
        if (c == 0) {
            return NO_NAMES;
        }
        String[] as = new String[c];
        if (this.hasOnlyParamNames()) {
            for (int i = 0; i < c; ++i) {
                String string;
                Expression expr = this.paramNames.get(i);
                if (expr instanceof NameExpression) {
                    NameExpression exprName = (NameExpression)expr;
                    string = exprName.getName();
                } else {
                    string = null;
                }
                as[i] = string;
            }
        } else {
            for (int i = 0; i < c; ++i) {
                Parameter param = this.params.get(i);
                as[i] = param.getName();
            }
        }
        return as;
    }

    public boolean hasOnlyParamNames() {
        return this.paramNames != null && !this.paramNames.isEmpty();
    }

    @Override
    public long getStartPosition() {
        return this.lStartPos;
    }

    @Override
    public long getEndPosition() {
        return this.body.getEndPosition();
    }

    @Override
    protected Field[] getChildFields() {
        return CHILD_FIELDS;
    }

    @Override
    public TypeConstant[] getReturnTypes() {
        TypeConstant typeFn = this.isValidated() ? this.getType() : this.m_typeRequired;
        return this.pool().extractFunctionReturns(typeFn);
    }

    @Override
    public boolean isReturnConditional() {
        TypeConstant typeFn = this.isValidated() ? this.getType() : this.m_typeRequired;
        return typeFn != null && this.pool().isConditionalReturn(typeFn);
    }

    @Override
    public void collectReturnTypes(TypeConstant[] atypeRet) {
        TypeCollector collector = this.m_collector;
        if (collector == null) {
            this.m_collector = collector = new TypeCollector(this.pool());
            collector.setConditional(this.isReturnConditional());
        }
        collector.add(atypeRet);
    }

    @Override
    protected void registerStructures(StageMgr mgr, ErrorListener errs) {
        if (this.m_lambda == null) {
            mgr.deferChildren();
        }
    }

    @Override
    public void resolveNames(StageMgr mgr, ErrorListener errs) {
        if (this.m_lambda == null) {
            mgr.deferChildren();
        }
    }

    @Override
    public void validateContent(StageMgr mgr, ErrorListener errs) {
        if (this.m_lambda == null) {
            mgr.deferChildren();
        }
    }

    @Override
    public void generateCode(StageMgr mgr, ErrorListener errs) {
        MethodStructure method = this.m_lambda;
        if (method == null) {
            mgr.requestRevisit();
            mgr.deferChildren();
            return;
        }
        if (this.getParentBlock().isTerminatedAbnormally()) {
            if (method.getIdentityConstant().isNascent()) {
                this.configureLambda(TypeConstant.NO_TYPES, Handy.NO_ARGS, 0, new boolean[0], TypeConstant.NO_TYPES, false);
            }
            mgr.deferChildren();
            mgr.markComplete();
            return;
        }
        if (this.catchUpChildren(errs) && !this.body.compileMethod(method.createCode(), errs)) {
            mgr.deferChildren();
        }
    }

    @Override
    public TypeConstant getImplicitType(Context ctx) {
        TypeConstant[] atypeParams;
        if (!this.ensurePrepared(ErrorListener.BLACKHOLE)) {
            return null;
        }
        if (this.isValidated()) {
            return this.getType();
        }
        assert (this.m_typeRequired == null && this.m_collector == null);
        if (this.hasOnlyParamNames()) {
            return null;
        }
        int cParams = this.getParamCount();
        String[] asParams = cParams == 0 ? NO_NAMES : new String[cParams];
        TypeConstant[] typeConstantArray = atypeParams = cParams == 0 ? TypeConstant.NO_TYPES : new TypeConstant[cParams];
        if (!this.collectParamNamesAndTypes(null, atypeParams, asParams, ErrorListener.BLACKHOLE)) {
            return null;
        }
        TypeConstant[] atypeReturns = this.extractReturnTypes(ctx, atypeParams, asParams, null, false, ErrorListener.BLACKHOLE);
        return atypeReturns == null ? null : this.pool().buildFunctionType(this.buildParamTypes(), atypeReturns);
    }

    @Override
    public Expression.TypeFit testFit(Context ctx, TypeConstant typeRequired, boolean fExhaustive, ErrorListener errs) {
        if (errs == null) {
            errs = ErrorListener.BLACKHOLE;
        }
        if (!this.ensurePrepared(errs)) {
            return Expression.TypeFit.NoFit;
        }
        if (this.isValidated()) {
            return this.calcFit(ctx, this.getType(), typeRequired);
        }
        ConstantPool pool = this.pool();
        Expression.TypeFit fit = this.calcFit(ctx, pool.typeFunction(), typeRequired);
        if (fit.isFit()) {
            return fit;
        }
        assert (typeRequired != null);
        TypeConstant typeConstant = typeRequired.resolveTypedefs();
        if (typeConstant instanceof UnionTypeConstant) {
            UnionTypeConstant typeUnion = (UnionTypeConstant)typeConstant;
            Set<TypeConstant> setFunctions = typeUnion.collectMatching(pool.typeFunction(), null);
            for (TypeConstant typeFunction : setFunctions) {
                boolean fCondReturn;
                TypeConstant[] atypeReqReturns;
                TypeConstant[] atypeReqParams = pool.extractFunctionParams(typeFunction);
                fit = this.calculateTypeFitImpl(ctx, atypeReqParams, atypeReqReturns = pool.extractFunctionReturns(typeFunction), fCondReturn = pool.isConditionalReturn(typeFunction), errs);
                if (!fit.isFit()) continue;
                return fit;
            }
            return Expression.TypeFit.NoFit;
        }
        TypeConstant[] atypeReqParams = pool.extractFunctionParams(typeRequired);
        TypeConstant[] atypeReqReturns = pool.extractFunctionReturns(typeRequired);
        boolean fCondReturn = pool.isConditionalReturn(typeRequired);
        return this.calculateTypeFitImpl(ctx, atypeReqParams, atypeReqReturns, fCondReturn, errs);
    }

    private Expression.TypeFit calculateTypeFitImpl(Context ctx, TypeConstant[] atypeReqParams, TypeConstant[] atypeReqReturns, boolean fCondReturn, ErrorListener errs) {
        int cParams = this.getParamCount();
        if (atypeReqParams != null && atypeReqParams.length == cParams && atypeReqReturns != null) {
            TypeConstant[] atypeParams;
            String[] asParams = cParams == 0 ? NO_NAMES : new String[cParams];
            TypeConstant[] typeConstantArray = atypeParams = cParams == 0 ? TypeConstant.NO_TYPES : new TypeConstant[cParams];
            if (!this.collectParamNamesAndTypes(atypeReqParams, atypeParams, asParams, errs)) {
                return Expression.TypeFit.NoFit;
            }
            TypeConstant[] atypeReturns = this.extractReturnTypes(ctx, atypeParams, asParams, atypeReqReturns, fCondReturn, errs);
            if (atypeReturns == null) {
                return Expression.TypeFit.NoFit;
            }
            int cReturns = atypeReturns.length;
            if (cReturns == 0 && LambdaExpression.isPending(atypeReqReturns)) {
                return Expression.TypeFit.Fit;
            }
            int cReqReturns = atypeReqReturns.length;
            if (cReqReturns <= cReturns) {
                for (int i = 0; i < cReqReturns; ++i) {
                    TypeConstant typeReturn = atypeReturns[i];
                    if (typeReturn != null && typeReturn.isA(atypeReqReturns[i])) continue;
                    return Expression.TypeFit.NoFit;
                }
                return Expression.TypeFit.Fit;
            }
            if (fCondReturn && cReturns == 1 && atypeReqReturns[0].isA(this.pool().typeBoolean())) {
                return Expression.TypeFit.Fit;
            }
        }
        return Expression.TypeFit.NoFit;
    }

    @Override
    protected Expression validate(Context ctx, TypeConstant typeRequired, ErrorListener errs) {
        boolean fCond;
        Object[] atypeRets;
        TypeConstant[] atypeParams;
        if (!this.ensurePrepared(errs)) {
            return this.finishValidation(ctx, typeRequired, null, Expression.TypeFit.NoFit, null, errs);
        }
        assert (this.m_typeRequired == null && this.m_collector == null && this.m_lambda == null);
        ConstantPool pool = this.pool();
        TypeConstant typeReqFn = null;
        TypeConstant[] atypeReqParams = null;
        TypeConstant[] atypeReqReturns = null;
        if (typeRequired != null) {
            typeReqFn = typeRequired = typeRequired.resolveTypedefs();
            if (typeRequired instanceof UnionTypeConstant) {
                UnionTypeConstant typeUnion = (UnionTypeConstant)typeRequired;
                Set<TypeConstant> setFunctions = typeUnion.collectMatching(pool.typeFunction(), null);
                for (TypeConstant typeFunction : setFunctions) {
                    boolean fCondTestR;
                    TypeConstant[] atypeTestR;
                    TypeConstant[] atypeTestP = pool.extractFunctionParams(typeFunction);
                    if (!this.calculateTypeFitImpl(ctx, atypeTestP, atypeTestR = pool.extractFunctionReturns(typeFunction), fCondTestR = pool.isConditionalReturn(typeFunction), errs).isFit()) continue;
                    atypeReqParams = atypeTestP;
                    atypeReqReturns = atypeTestR;
                    typeReqFn = fCondTestR ? pool.buildConditionalFunctionType(atypeReqParams, this.replacePending(atypeReqReturns)) : pool.buildFunctionType(atypeReqParams, this.replacePending(atypeReqReturns));
                    break;
                }
            } else if (typeRequired.isA(pool.typeFunction())) {
                atypeReqParams = pool.extractFunctionParams(typeRequired);
                atypeReqReturns = pool.extractFunctionReturns(typeRequired);
                boolean fCondReturn = pool.isConditionalReturn(typeRequired);
                typeReqFn = fCondReturn ? pool.buildConditionalFunctionType(atypeReqParams, this.replacePending(atypeReqReturns)) : pool.buildFunctionType(atypeReqParams, this.replacePending(atypeReqReturns));
            }
        }
        boolean fValid = true;
        int cReqParams = atypeReqParams == null ? -1 : atypeReqParams.length;
        int cReqReturns = atypeReqReturns == null ? -1 : atypeReqReturns.length;
        int cParams = this.getParamCount();
        if (cReqParams != -1 && cParams != cReqParams) {
            errs.log(Severity.ERROR, "COMPILER-84", new Object[]{cReqParams, cParams}, this.getSource(), this.getStartPosition(), this.operator.getStartPosition());
            fValid = false;
        }
        String[] asParams = cParams == 0 ? NO_NAMES : new String[cParams];
        TypeConstant[] typeConstantArray = atypeParams = cParams == 0 ? TypeConstant.NO_TYPES : new TypeConstant[cParams];
        if (!(fValid &= this.collectParamNamesAndTypes(atypeReqParams, atypeParams, asParams, errs))) {
            return null;
        }
        this.m_lambda = this.instantiateLambda(errs);
        LambdaContext ctxLambda = this.createContext(ctx, typeReqFn, atypeParams, asParams, errs);
        if (ctxLambda == null) {
            return null;
        }
        Expression.TypeFit fit = Expression.TypeFit.Fit;
        if (this.m_collector == null) {
            atypeRets = TypeConstant.NO_TYPES;
            fCond = false;
            if (cReqReturns > 0) {
                if (LambdaExpression.isPending(atypeReqReturns)) {
                    atypeRets = new TypeConstant[cReqReturns];
                    Arrays.fill(atypeRets, pool.typeTuple0());
                } else {
                    this.log(errs, Severity.ERROR, "COMPILER-41", new Object[0]);
                    fit = Expression.TypeFit.NoFit;
                }
            }
        } else {
            atypeRets = this.replacePending(this.m_collector.inferMulti(atypeReqReturns));
            fCond = cReqReturns > 1 && this.m_collector.isConditional();
            this.m_collector = null;
            if (atypeRets == null) {
                this.log(errs, Severity.ERROR, "COMPILER-41", new Object[0]);
                fit = Expression.TypeFit.NoFit;
            } else {
                int cReturns = atypeRets.length;
                for (int i = 0; i < cReturns; ++i) {
                    Object typeRet = atypeRets[i];
                    if (!((TypeConstant)typeRet).containsDynamicType()) continue;
                    ConstraintResolver resolver = new ConstraintResolver(ctxLambda.ensureRegisterMap().values());
                    atypeRets[i] = ((TypeConstant)typeRet).resolveGenerics(pool, resolver);
                }
                if (cReqReturns != -1 && cReturns > cReqReturns) {
                    atypeRets = (TypeConstant[])Arrays.copyOfRange(atypeRets, 0, cReqReturns);
                } else if (fCond && cReturns == 1) {
                    atypeRets = atypeReqReturns;
                }
            }
        }
        TypeConstant typeActual = null;
        MethodConstant constVal = null;
        if (fit.isFit()) {
            this.m_ctxLambda = ctxLambda;
            TypeConstant typeConstant = typeActual = fCond ? pool.buildConditionalFunctionType(atypeParams, (TypeConstant[])atypeRets) : pool.buildFunctionType(atypeParams, (TypeConstant[])atypeRets);
            if (ctxLambda.getCaptureMap().isEmpty() && ctxLambda.getFormalMap().isEmpty() && !ctxLambda.isLambdaMethod()) {
                this.configureLambda(atypeParams, asParams, 0, null, (TypeConstant[])atypeRets, fCond);
                constVal = this.m_lambda.getIdentityConstant();
            }
        }
        return this.finishValidation(ctx, typeRequired, typeActual, fit, constVal, errs);
    }

    protected boolean collectParamNamesAndTypes(TypeConstant[] atypeReqParams, TypeConstant[] atypeParams, String[] asParams, ErrorListener errs) {
        boolean fValid = true;
        int cReqParams = atypeReqParams == null ? 0 : atypeReqParams.length;
        int cParams = atypeParams.length;
        if (this.hasOnlyParamNames()) {
            if (atypeReqParams == null) {
                errs.log(Severity.ERROR, "COMPILER-86", null, this.getSource(), this.paramNames.get(0).getStartPosition(), this.paramNames.get(cParams - 1).getEndPosition());
                fValid = false;
            }
            HashSet<String> setNames = new HashSet<String>();
            for (int i = 0; i < cParams; ++i) {
                Expression expr = this.paramNames.get(i);
                if (expr instanceof NameExpression) {
                    String sName;
                    NameExpression exprName = (NameExpression)expr;
                    asParams[i] = sName = exprName.getName();
                    if (!(expr instanceof IgnoredNameExpression) && !setNames.add(sName)) {
                        expr.log(errs, Severity.ERROR, "COMPILER-85", sName);
                        fValid = false;
                    }
                } else {
                    expr.log(errs, Severity.ERROR, "COMPILER-83", new Object[0]);
                    fValid = false;
                }
                atypeParams[i] = i < cReqParams ? atypeReqParams[i] : this.pool().typeObject();
            }
        } else {
            HashSet<String> setNames = new HashSet<String>();
            for (int i = 0; i < cParams; ++i) {
                TypeConstant typeReq;
                TypeConstant typeParam;
                Parameter param = this.params.get(i);
                asParams[i] = param.getName();
                String sName = asParams[i];
                if (!sName.equals(Token.Id.ANY.TEXT) && !setNames.add(sName)) {
                    param.log(errs, Severity.ERROR, "COMPILER-85", sName);
                    asParams[i] = Token.Id.ANY.TEXT;
                    fValid = false;
                }
                if ((typeParam = param.getType().ensureTypeConstant()).containsUnresolved()) {
                    atypeParams[i] = this.pool().typeObject();
                    this.log(errs, Severity.ERROR, "COMPILER-38", typeParam.getValueString());
                    fValid = false;
                    continue;
                }
                atypeParams[i] = typeParam;
                if (i >= cReqParams || (typeReq = atypeReqParams[i]) == null || typeReq.isA(typeParam)) continue;
                param.log(errs, Severity.ERROR, "COMPILER-43", typeReq.getValueString(), typeParam.getValueString());
                fValid = false;
            }
        }
        return fValid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TypeConstant[] extractReturnTypes(Context ctx, TypeConstant[] atypeParams, String[] asParams, TypeConstant[] atypeReturns, boolean fCondReturn, ErrorListener errs) {
        TypeConstant typeReqFn = atypeReturns == null ? null : (fCondReturn ? this.pool().buildConditionalFunctionType(atypeParams, this.replacePending(atypeReturns)) : this.pool().buildFunctionType(atypeParams, this.replacePending(atypeReturns)));
        this.createContext(ctx, typeReqFn, atypeParams, asParams, errs);
        try {
            TypeConstant[] typeConstantArray = this.m_collector == null ? TypeConstant.NO_TYPES : this.m_collector.inferMulti(atypeReturns);
            return typeConstantArray;
        }
        finally {
            this.m_collector = null;
        }
    }

    private LambdaContext createContext(Context ctx, TypeConstant typeRequired, TypeConstant[] atypeParams, String[] asParams, ErrorListener errs) {
        LambdaContext ctxLambda;
        ErrorListener errsTemp;
        boolean fValid;
        StatementBlock blockOrig;
        block6: {
            StatementBlock blockTemp = (StatementBlock)this.body.clone();
            if (!new StageMgr(blockTemp, Compiler.Stage.Validated, errs).fastForward(20)) {
                blockTemp.discard(true);
                return null;
            }
            this.m_typeRequired = typeRequired;
            Context ctxOrig = ctx;
            HashMap<String, Assignment> mapAsnBefore = new HashMap<String, Assignment>();
            HashMap<String, Argument> mapArgBefore = new HashMap<String, Argument>();
            blockOrig = blockTemp;
            int cTries = 0;
            while (true) {
                fValid = true;
                blockTemp = (StatementBlock)blockOrig.clone();
                errsTemp = errs.branch(this);
                ctx = ctxOrig.enter();
                ctx.merge(mapAsnBefore, mapArgBefore);
                ctxLambda = LambdaExpression.enterCapture(ctx, blockTemp, atypeParams, asParams);
                StatementBlock blockNew = (StatementBlock)blockTemp.validate(ctxLambda, errsTemp);
                if (blockNew != blockTemp) {
                    if (blockNew == null) {
                        fValid = false;
                    } else {
                        blockOrig = blockNew;
                    }
                }
                blockTemp.discard(true);
                HashMap<String, Assignment> mapAsnAfter = new HashMap<String, Assignment>();
                HashMap<String, Argument> mapArgAfter = new HashMap<String, Argument>();
                ctxLambda.prepareJump(ctxOrig, mapAsnAfter, mapArgAfter);
                if (mapAsnAfter.equals(mapAsnBefore)) break block6;
                if (++cTries >= 10) break;
                mapAsnBefore = mapAsnAfter;
                mapArgBefore = mapArgAfter;
            }
            if (!errsTemp.hasSeriousErrors()) {
                this.log(errsTemp, Severity.ERROR, "COMPILER-01", new Object[0]);
            }
            fValid = false;
        }
        blockOrig.discard(true);
        errsTemp.merge();
        ctxLambda.exit().exit();
        this.m_typeRequired = null;
        return fValid ? ctxLambda : null;
    }

    @Override
    public Argument generateArgument(Context ctx, MethodStructure.Code code, boolean fLocalPropOk, boolean fUsedOnce, ErrorListener errs) {
        Argument[] aargBind = this.calculateBindings(ctx, code, errs);
        if (this.m_lambda.isFunction() && aargBind.length == 0) {
            MethodConstant idLambda = this.m_lambda.getIdentityConstant();
            this.m_astLambda = new ConstantExprAST(idLambda);
            return idLambda;
        }
        return super.generateArgument(ctx, code, fLocalPropOk, fUsedOnce, errs);
    }

    @Override
    public void generateAssignment(Context ctx, MethodStructure.Code code, Expression.Assignable LVal, ErrorListener errs) {
        Argument[] aBindArgs = this.calculateBindings(ctx, code, errs);
        int cBindArgs = aBindArgs.length;
        boolean fBindTarget = !this.m_lambda.isFunction();
        boolean fBindParams = cBindArgs > 0;
        int[] anBind = null;
        if (fBindParams) {
            anBind = new int[cBindArgs];
            for (int i = 0; i < cBindArgs; ++i) {
                anBind[i] = i;
            }
        }
        MethodConstant idLambda = this.m_lambda.getIdentityConstant();
        this.m_astLambda = new ConstantExprAST(idLambda);
        if (fBindTarget | fBindParams) {
            if (LVal.isLocalArgument()) {
                Argument argResult = LVal.getLocalArgument();
                if (fBindTarget & fBindParams) {
                    Register regThis = ctx.getThisRegister();
                    Register regTemp = new Register(idLambda.getSignature().asFunctionType(), null, -1);
                    code.add(new MBind(regThis, idLambda, regTemp));
                    code.add(new FBind(regTemp, anBind, aBindArgs, argResult));
                    this.m_astLambda = new BindMethodAST(regThis.getRegisterAST(), idLambda, regTemp.getType());
                    this.m_astLambda = new BindFunctionAST(this.m_astLambda, anBind, this.m_aAstBind, this.getType());
                } else if (fBindTarget) {
                    code.add(new MBind(ctx.getThisRegister(), idLambda, argResult));
                    this.m_astLambda = new BindMethodAST(ctx.getThisRegisterAST(), idLambda, this.getType());
                } else {
                    code.add(new FBind(idLambda, anBind, aBindArgs, argResult));
                    this.m_astLambda = new BindFunctionAST(this.m_astLambda, anBind, this.m_aAstBind, this.getType());
                }
            } else {
                super.generateAssignment(ctx, code, LVal, errs);
            }
        } else {
            LVal.assign(idLambda, code, errs);
        }
    }

    @Override
    protected void discard(boolean fRecurse) {
        super.discard(fRecurse);
        if (this.m_lambda != null) {
            this.m_lambda.getParent().removeChild(this.m_lambda);
            this.m_lambda = null;
        }
    }

    @Override
    public AstNode clone() {
        LambdaExpression that = (LambdaExpression)super.clone();
        that.m_lambda = null;
        return that;
    }

    @Override
    public ExprAST getExprAST(Context ctx) {
        return this.m_astLambda == null ? (this.isConstant() ? new ConstantExprAST(this.toConstant()) : super.getExprAST(ctx)) : this.m_astLambda;
    }

    @Override
    protected Expression.SideEffect mightAffect(Expression exprLeft, Argument arg) {
        return Expression.SideEffect.DefNo;
    }

    protected boolean ensurePrepared(ErrorListener errs) {
        if (this.m_fPrepared || this.params == null || this.params.isEmpty()) {
            this.m_fPrepared = true;
            return true;
        }
        boolean fPrepared = true;
        for (AstNode astNode : this.params) {
            fPrepared &= new StageMgr(astNode, Compiler.Stage.Validated, errs).fastForward(20);
        }
        this.m_fPrepared = fPrepared;
        return this.m_fPrepared;
    }

    protected TypeConstant[] buildParamTypes() {
        if (!this.hasParameters()) {
            return TypeConstant.NO_TYPES;
        }
        assert (!this.hasOnlyParamNames());
        List<Parameter> list = this.params;
        int cTypes = list.size();
        TypeConstant[] aTypes = new TypeConstant[cTypes];
        for (int i = 0; i < cTypes; ++i) {
            Parameter param = list.get(i);
            aTypes[i] = param.getType().ensureTypeConstant();
        }
        return aTypes;
    }

    MethodStructure instantiateLambda(ErrorListener errs) {
        String[] asParams;
        TypeConstant[] atypes = null;
        if (this.paramNames == null) {
            cParams = this.params == null ? 0 : this.params.size();
            atypes = new TypeConstant[cParams];
            asParams = new String[cParams];
            for (i = 0; i < cParams; ++i) {
                Parameter param = this.params.get(i);
                atypes[i] = param.getType().ensureTypeConstant();
                asParams[i] = param.getName();
            }
        } else {
            cParams = this.paramNames.size();
            asParams = new String[cParams];
            for (i = 0; i < cParams; ++i) {
                Expression expr = this.paramNames.get(i);
                if (expr instanceof NameExpression) {
                    NameExpression exprName = (NameExpression)expr;
                    asParams[i] = exprName.getName();
                    continue;
                }
                expr.log(errs, Severity.ERROR, "COMPILER-83", new Object[0]);
                asParams[i] = Token.Id.ANY.TEXT;
            }
        }
        Component container = this.getParent().getComponent();
        MultiMethodStructure structMM = container.ensureMultiMethodStructure(METHOD_NAME);
        MethodStructure method = structMM.createLambda(atypes, asParams);
        this.donateSource(method);
        return method;
    }

    /*
     * WARNING - void declaration
     */
    protected Argument[] calculateBindings(Context ctx, MethodStructure.Code code, ErrorListener errs) {
        MethodStructure lambda = this.m_lambda;
        LambdaContext ctxLambda = this.m_ctxLambda;
        assert (lambda != null && lambda.isLambda());
        assert (ctxLambda != null);
        MethodConstant idLambda = lambda.getIdentityConstant();
        if (idLambda.isNascent()) {
            ConstantPool pool = ctx.pool();
            TypeConstant typeFn = this.getType();
            String[] asParams = this.getParamNames();
            TypeConstant[] atypeParams = pool.extractFunctionParams(typeFn);
            TypeConstant[] atypeReturns = pool.extractFunctionReturns(typeFn);
            boolean fCondReturn = pool.isConditionalReturn(typeFn);
            Map<String, Argument> mapFormal = ctxLambda.getFormalMap();
            Map<String, Boolean> mapCapture = ctxLambda.getCaptureMap();
            int cTypeParams = mapFormal.size();
            int cCaptures = mapCapture.size();
            if (cTypeParams > 0 && cCaptures > 0 && mapCapture.keySet().removeAll(mapFormal.keySet())) {
                cCaptures = mapCapture.size();
            }
            int cBindArgs = cTypeParams + cCaptures;
            Argument[] aBindArgs = NO_RVALUES;
            ExprAST[] aAstBind = null;
            boolean[] afImplicitDeref = null;
            lambda.setStatic(!ctxLambda.isLambdaMethod());
            if (cBindArgs > 0) {
                String sCapture;
                Map<String, Register> mapRegisters = ctxLambda.ensureRegisterMap();
                int cLambdaParams = atypeParams.length;
                int cAllParams = cBindArgs + cLambdaParams;
                TypeConstant[] atypeAllParams = new TypeConstant[cAllParams];
                String[] asAllParams = new String[cAllParams];
                int iParam = 0;
                aBindArgs = new Argument[cBindArgs];
                aAstBind = new ExprAST[cBindArgs];
                final HashMap<FormalConstant, TypeConstant> mapRedefine = new HashMap<FormalConstant, TypeConstant>();
                for (Map.Entry<String, Argument> entry : mapFormal.entrySet()) {
                    Register regFormal;
                    TypeConstant typeFormal;
                    sCapture = entry.getKey();
                    Argument argFormal = entry.getValue();
                    TypeConstant typeReg = pool.ensureRegisterConstant(idLambda, iParam, sCapture).getType();
                    if (argFormal instanceof StatementBlock.TargetInfo) {
                        StatementBlock.TargetInfo infoGeneric = (StatementBlock.TargetInfo)argFormal;
                        typeFormal = infoGeneric.getType();
                        regFormal = new Register(typeFormal, null, -1);
                        PropertyConstant idGeneric = (PropertyConstant)infoGeneric.getId();
                        mapRedefine.put(idGeneric, typeReg);
                        int cSteps = infoGeneric.getStepsOut();
                        if (cSteps > 0) {
                            Register regTarget = new Register(infoGeneric.getTargetType(), null, -1);
                            code.add(new MoveThis(cSteps, regTarget));
                            code.add(new P_Get(idGeneric, regTarget, regFormal));
                            aAstBind[iParam] = new PropertyExprAST(new OuterExprAST(ctx.getThisRegisterAST(), cSteps, regTarget.getType()), idGeneric);
                        } else {
                            code.add(new L_Get(idGeneric, regFormal));
                            aAstBind[iParam] = new PropertyExprAST(ctx.getThisRegisterAST(), idGeneric);
                        }
                    } else {
                        regFormal = ((Register)argFormal).getOriginalRegister();
                        TypeConstant typeParam = regFormal.getType().getParamType(0);
                        mapRedefine.put((TypeParameterConstant)typeParam.getDefiningConstant(), typeReg);
                        typeFormal = typeParam.resolveConstraints().getType();
                        aAstBind[iParam] = regFormal.getRegisterAST();
                    }
                    asAllParams[iParam] = sCapture;
                    atypeAllParams[iParam] = typeFormal;
                    aBindArgs[iParam] = regFormal;
                    ++iParam;
                }
                for (Map.Entry<String, Object> entry : mapCapture.entrySet()) {
                    boolean fAllowRefCapture;
                    boolean fVar;
                    sCapture = entry.getKey();
                    Register regCapture = mapRegisters.get(sCapture);
                    TypeConstant typeCapture = regCapture.getType();
                    boolean fImplicitDeref = false;
                    if (regCapture instanceof LabeledStatement.LabelVar) {
                        this.log(errs, Severity.ERROR, "COMPILER-NI", "Label capturing (\"" + sCapture + "\")");
                    }
                    TypeConstant typeVar = (fVar = (regCapture = regCapture.getOriginalRegister()).isVar()) ? regCapture.ensureRegType(true) : null;
                    boolean bl = fAllowRefCapture = fVar && typeVar.isA(pool.clzVolatile().getType());
                    if (((Boolean)entry.getValue()).booleanValue()) {
                        if (!fAllowRefCapture) {
                            this.log(errs, Severity.ERROR, "COMPILER-197", sCapture);
                        }
                        typeCapture = fVar ? typeVar : pool.ensureParameterizedTypeConstant(pool.typeVar(), typeCapture);
                        regVal = regCapture;
                        regVar = new Register(typeCapture, null, -1);
                        code.add(new MoveVar(regVal, (Argument)regVar));
                        regCapture = regVar;
                        fImplicitDeref = true;
                        aAstBind[iParam] = new UnaryOpExprAST(regVal.getRegisterAST(), UnaryOpExprAST.Operator.Var, typeCapture);
                    } else if (fVar && !typeVar.isA(pool.clzInject().getType()) || !regCapture.isEffectivelyFinal() && fAllowRefCapture) {
                        typeCapture = fVar ? typeVar : pool.ensureParameterizedTypeConstant(pool.typeVar(), typeCapture);
                        regVal = regCapture;
                        regVar = new Register(typeCapture, null, -1);
                        code.add(new MoveRef(regVal, (Argument)regVar));
                        regCapture = regVar;
                        fImplicitDeref = true;
                        aAstBind[iParam] = new UnaryOpExprAST(regVal.getRegisterAST(), UnaryOpExprAST.Operator.Ref, typeCapture);
                    } else {
                        aAstBind[iParam] = regCapture.getRegisterAST();
                    }
                    asAllParams[iParam] = sCapture;
                    atypeAllParams[iParam] = typeCapture;
                    aBindArgs[iParam] = regCapture;
                    if (fImplicitDeref) {
                        if (afImplicitDeref == null) {
                            afImplicitDeref = new boolean[cBindArgs];
                        }
                        afImplicitDeref[iParam] = true;
                    }
                    ++iParam;
                }
                assert (iParam == cBindArgs);
                System.arraycopy(atypeParams, 0, atypeAllParams, cBindArgs, cLambdaParams);
                System.arraycopy(asParams, 0, asAllParams, cBindArgs, cLambdaParams);
                atypeParams = atypeAllParams;
                asParams = asAllParams;
                if (!mapRedefine.isEmpty()) {
                    void var29_33;
                    GenericTypeResolver resolver = new GenericTypeResolver(){

                        @Override
                        public TypeConstant resolveGenericType(String sFormalName) {
                            return null;
                        }

                        @Override
                        public TypeConstant resolveFormalType(FormalConstant constFormal) {
                            return (TypeConstant)mapRedefine.get(constFormal);
                        }
                    };
                    int n = cTypeParams;
                    int c = atypeParams.length;
                    while (var29_33 < c) {
                        TypeConstant typeOld = atypeParams[var29_33].resolveTypedefs();
                        TypeConstant typeNew = typeOld.resolveGenerics(pool, resolver);
                        if (typeNew != typeOld) {
                            atypeParams[var29_33] = typeNew;
                        }
                        ++var29_33;
                    }
                }
            }
            this.m_aBindArgs = aBindArgs;
            this.m_aAstBind = aAstBind;
            this.configureLambda(atypeParams, asParams, cTypeParams, afImplicitDeref, atypeReturns, fCondReturn);
        }
        return this.m_aBindArgs;
    }

    protected void configureLambda(TypeConstant[] atypeParams, String[] asParams, int cFormal, boolean[] afImpliedDeref, TypeConstant[] atypeRets, boolean fCondReturn) {
        MethodStructure lambda = this.m_lambda;
        ConstantPool pool = this.pool();
        SignatureConstant sig = pool.ensureSignatureConstant(METHOD_NAME, atypeParams, atypeRets);
        int cParams = atypeParams.length;
        int cNames = asParams.length;
        org.xvm.asm.Parameter[] aparamParams = new org.xvm.asm.Parameter[cParams];
        for (int i = 0; i < cParams; ++i) {
            String sName = i < cNames ? asParams[i] : null;
            TypeConstant type = atypeParams[i];
            assert (!type.containsUnresolved());
            aparamParams[i] = new org.xvm.asm.Parameter(pool, type, sName, null, false, i, i < cFormal);
            if (afImpliedDeref == null || afImpliedDeref.length <= i || !afImpliedDeref[i]) continue;
            aparamParams[i].markImplicitDeref();
        }
        int cRets = atypeRets.length;
        org.xvm.asm.Parameter[] aparamRets = new org.xvm.asm.Parameter[cRets];
        for (int i = 0; i < cRets; ++i) {
            TypeConstant type = atypeRets[i];
            assert (!type.containsUnresolved());
            aparamRets[i] = new org.xvm.asm.Parameter(pool, type, null, null, true, i, false);
        }
        lambda.configureLambda(aparamParams, cFormal, aparamRets);
        lambda.setConditionalReturn(fCondReturn);
        lambda.getIdentityConstant().setSignature(sig);
    }

    protected boolean isRequiredThis() {
        assert (this.isValidated());
        return this.m_ctxLambda.isLambdaMethod();
    }

    private TypeConstant[] replacePending(TypeConstant[] atype) {
        int c;
        TypeConstant[] atypeRets = atype;
        int n = c = atype == null ? 0 : atype.length;
        for (int i = 0; i < c; ++i) {
            ParameterizedTypeConstant typeParams;
            TypeConstant[] atypeOld;
            TypeConstant[] atypeNew;
            TypeConstant typeOld;
            TypeConstant typeNew = typeOld = atype[i];
            if (typeOld instanceof PendingTypeConstant) {
                typeNew = this.pool().typeObject();
            } else if (typeOld instanceof ParameterizedTypeConstant && (atypeNew = this.replacePending(atypeOld = (typeParams = (ParameterizedTypeConstant)typeOld).getParamTypesArray())) != atypeOld) {
                typeNew = this.pool().ensureParameterizedTypeConstant(typeParams.getUnderlyingType(), atypeNew);
            }
            if (typeNew == typeOld) continue;
            if (atypeRets == atype) {
                atypeRets = (TypeConstant[])atype.clone();
            }
            atypeRets[i] = typeNew;
        }
        return atypeRets;
    }

    public String toSignatureString() {
        StringBuilder sb = new StringBuilder();
        sb.append('(');
        boolean first = true;
        for (AstNode param : this.params == null ? this.paramNames : this.params) {
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            sb.append(param);
        }
        sb.append(')').append(' ').append(this.operator.getId().TEXT);
        return sb.toString();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.toSignatureString());
        String s = this.body.toString();
        if (s.indexOf(10) >= 0) {
            sb.append('\n').append(Handy.indentLines(s, "    "));
        } else {
            sb.append(' ').append(s);
        }
        return sb.toString();
    }

    @Override
    public String toDumpString() {
        return this.toSignatureString() + " {...}";
    }

    protected static LambdaContext enterCapture(Context ctx, StatementBlock body, TypeConstant[] atypeParams, String[] asParams) {
        return new LambdaContext(ctx, body, atypeParams, asParams);
    }

    public static class LambdaContext
    extends Context.CaptureContext {
        private final TypeConstant[] f_atypeParams;
        private final String[] f_asParams;

        public LambdaContext(Context ctxOuter, StatementBlock body, TypeConstant[] atypeParams, String[] asParams) {
            super(ctxOuter);
            assert (atypeParams == null && asParams == null || atypeParams != null && asParams != null && atypeParams.length == asParams.length);
            this.f_atypeParams = atypeParams;
            this.f_asParams = asParams;
        }

        @Override
        protected void promoteNarrowedTypes() {
            this.restoreOriginalTypes();
        }

        @Override
        protected void promoteNonCompleting(Context ctxInner) {
            ctxInner.restoreOriginalTypes();
            ctxInner.promoteNarrowedTypes();
        }

        @Override
        public boolean requireThis(long lPos, ErrorListener errs) {
            if (this.getOuterContext().requireThis(lPos, errs)) {
                this.captureThis();
                return true;
            }
            return false;
        }

        @Override
        protected void markVarRead(boolean fNested, String sName, Token tokName, boolean fDeref, ErrorListener errs) {
            Context ctxOuter = this.getOuterContext();
            if (!this.isVarDeclaredInThisScope(sName) && ctxOuter.isVarReadable(sName) && this.isReservedName(sName)) {
                boolean fAllowConstructor = false;
                switch (sName) {
                    case "this": 
                    case "this:struct": 
                    case "this:class": {
                        fAllowConstructor = true;
                    }
                    case "this:target": 
                    case "this:public": 
                    case "this:protected": 
                    case "this:private": {
                        if (fAllowConstructor && ctxOuter.isConstructor()) {
                            this.captureThis();
                        } else {
                            this.requireThis(tokName.getStartPosition(), errs);
                        }
                        return;
                    }
                    case "this:service": 
                    case "this:module": {
                        return;
                    }
                }
            }
            super.markVarRead(fNested, sName, tokName, fDeref, errs);
        }

        public boolean isLambdaMethod() {
            return this.isThisCaptured();
        }

        @Override
        protected boolean hasInitialNames() {
            return true;
        }

        @Override
        public Map<String, Argument> getFormalMap() {
            Map<String, Argument> mapFormal = super.getFormalMap();
            if (this.isLambdaMethod() && !mapFormal.isEmpty()) {
                mapFormal = new HashMap<String, Argument>(mapFormal);
                mapFormal.values().removeIf(arg -> {
                    TypeConstant type = arg.getType();
                    return type.isTypeOfType() && type.getParamType(0).isGenericType();
                });
            }
            return mapFormal;
        }

        @Override
        protected void initNameMap(Map<String, Argument> mapByName) {
            Context ctxOuter = this.getOuterContext();
            int cParams = this.f_atypeParams == null ? 0 : this.f_atypeParams.length;
            for (int i = 0; i < cParams; ++i) {
                TypeConstant type = this.f_atypeParams[i];
                String sName = this.f_asParams[i];
                if (sName == null || sName.equals(Token.Id.ANY.TEXT) || type == null || type.containsUnresolved()) continue;
                Register reg = this.createRegister(type, sName);
                TypeConstant typeNarrowed = ctxOuter.resolveFormalType(type);
                if (typeNarrowed != type) {
                    reg = reg.narrowType(typeNarrowed);
                    reg.markInPlace();
                }
                mapByName.put(sName, reg);
                this.ensureDefiniteAssignments().put(sName, Assignment.AssignedOnce);
            }
        }
    }

    protected static class ConstraintResolver
    implements GenericTypeResolver {
        private final Collection<Register> f_setCapture;

        public ConstraintResolver(Collection<Register> setCapture) {
            this.f_setCapture = setCapture;
        }

        @Override
        public TypeConstant resolveFormalType(FormalConstant constFormal) {
            DynamicFormalConstant constDynamic;
            Register register;
            if (constFormal instanceof DynamicFormalConstant && ((register = (constDynamic = (DynamicFormalConstant)constFormal).getRegister()) == null || !this.f_setCapture.contains(register))) {
                return constDynamic.getConstraintType();
            }
            return null;
        }

        @Override
        public TypeConstant resolveGenericType(String sFormalName) {
            return null;
        }
    }
}

