/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.compiler.ast;

import java.lang.reflect.Field;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.xvm.asm.Argument;
import org.xvm.asm.Constant;
import org.xvm.asm.ConstantPool;
import org.xvm.asm.ErrorListener;
import org.xvm.asm.MethodStructure;
import org.xvm.asm.Register;
import org.xvm.asm.ast.ConstantExprAST;
import org.xvm.asm.ast.ExprAST;
import org.xvm.asm.ast.ListExprAST;
import org.xvm.asm.constants.ArrayConstant;
import org.xvm.asm.constants.StringConstant;
import org.xvm.asm.constants.TypeCollector;
import org.xvm.asm.constants.TypeConstant;
import org.xvm.asm.constants.UnionTypeConstant;
import org.xvm.asm.op.Var_S;
import org.xvm.asm.op.Var_SN;
import org.xvm.compiler.ast.Context;
import org.xvm.compiler.ast.Expression;
import org.xvm.compiler.ast.MapExpression;
import org.xvm.compiler.ast.NamedTypeExpression;
import org.xvm.compiler.ast.TypeExpression;
import org.xvm.compiler.ast.VariableDeclarationStatement;
import org.xvm.util.ListSet;
import org.xvm.util.Severity;

public class ListExpression
extends Expression {
    protected TypeExpression type;
    protected List<Expression> exprs;
    protected long lStartPos;
    protected long lEndPos;
    private static final Field[] CHILD_FIELDS = ListExpression.fieldsForNames(ListExpression.class, "type", "exprs");

    public ListExpression(TypeExpression type, List<Expression> exprs, long lStartPos, long lEndPos) {
        this.type = type;
        this.exprs = exprs;
        this.lStartPos = lStartPos;
        this.lEndPos = lEndPos;
    }

    public List<Expression> getExpressions() {
        return this.exprs;
    }

    @Override
    public long getStartPosition() {
        return this.lStartPos;
    }

    @Override
    public long getEndPosition() {
        return this.lEndPos;
    }

    @Override
    protected Field[] getChildFields() {
        return CHILD_FIELDS;
    }

    @Override
    public TypeConstant getImplicitType(Context ctx) {
        TypeConstant typeElement;
        TypeConstant typeBase = this.getBaseType(ctx, null);
        if (!typeBase.isParamsSpecified() && (typeElement = this.getImplicitElementType(ctx)) != null) {
            typeBase = this.pool().ensureParameterizedTypeConstant(typeBase, typeElement);
        }
        return typeBase;
    }

    private TypeConstant getBaseType(Context ctx, TypeConstant typeRequired) {
        if (this.type == null) {
            ConstantPool pool = this.pool();
            if (typeRequired != null && typeRequired.isSingleUnderlyingClass(true)) {
                TypeConstant typeBase = typeRequired.getSingleUnderlyingClass(true).getType();
                if (!pool.typeArray().isA(typeBase) && pool.typeSet().isA(typeBase)) {
                    return pool.typeSet();
                }
            }
            return pool.typeArray();
        }
        return this.type.ensureTypeConstant(ctx, null);
    }

    private TypeConstant getImplicitElementType(Context ctx) {
        int cElements = this.exprs.size();
        if (cElements > 0) {
            TypeConstant[] aElementTypes = new TypeConstant[cElements];
            for (int i = 0; i < cElements; ++i) {
                aElementTypes[i] = this.exprs.get(i).getImplicitType(ctx);
            }
            return TypeCollector.inferFrom(aElementTypes, this.pool());
        }
        return null;
    }

    @Override
    public Expression.TypeFit testFit(Context ctx, TypeConstant typeRequired, boolean fExhaustive, ErrorListener errs) {
        ConstantPool pool = this.pool();
        if (typeRequired.isA(pool.typeMap()) && this.exprs.isEmpty()) {
            MapExpression exprNew = new MapExpression(new NamedTypeExpression(this, typeRequired), Collections.emptyList(), Collections.emptyList(), this.getEndPosition());
            exprNew.setParent(this);
            return exprNew.testFit(ctx, typeRequired, fExhaustive, errs);
        }
        if (typeRequired != null) {
            TypeConstant typeElement = this.getImplicitElementType(ctx);
            if (typeElement != null && (pool.ensureArrayType(typeElement).isA(typeRequired) || pool.ensureSetType(typeElement).isA(typeRequired))) {
                return Expression.TypeFit.Fit;
            }
            typeElement = this.resolveElementType(typeRequired);
            if (typeElement != null) {
                Expression expr;
                TypeConstant typeTarget;
                TypeConstant typeBase = this.getBaseType(ctx, typeRequired);
                TypeConstant typeConstant = typeTarget = typeBase.isParamsSpecified() ? typeBase : pool.ensureParameterizedTypeConstant(typeBase, typeElement);
                if (!this.isA(ctx, typeTarget, typeRequired)) {
                    return Expression.TypeFit.NoFit;
                }
                Expression.TypeFit fit = Expression.TypeFit.Fit;
                Iterator<Expression> iterator = this.exprs.iterator();
                while (iterator.hasNext() && (fit = fit.combineWith((expr = iterator.next()).testFit(ctx, typeElement, fExhaustive, errs))).isFit()) {
                }
                return fit;
            }
        }
        return super.testFit(ctx, typeRequired, fExhaustive, errs);
    }

    @Override
    protected Expression validate(Context ctx, TypeConstant typeRequired, ErrorListener errs) {
        ConstantPool pool = this.pool();
        if (typeRequired != null && typeRequired.isA(pool.typeMap()) && this.exprs.isEmpty()) {
            MapExpression exprNew = new MapExpression(new NamedTypeExpression(this, typeRequired), Collections.emptyList(), Collections.emptyList(), this.getEndPosition());
            return this.replaceThisWith(exprNew).validate(ctx, typeRequired, errs);
        }
        Expression.TypeFit fit = Expression.TypeFit.Fit;
        List<Expression> listExprs = this.exprs;
        int cExprs = listExprs.size();
        boolean fConstant = true;
        TypeConstant typeElement = this.getImplicitElementType(ctx);
        if (typeRequired != null && (typeElement == null || !pool.ensureArrayType(typeElement).isA(typeRequired) && !pool.ensureSetType(typeElement).isA(typeRequired))) {
            typeElement = this.resolveElementType(typeRequired);
        }
        if (typeElement == null) {
            typeElement = pool.typeObject();
        }
        TypeConstant typeActual = this.getBaseType(ctx, typeRequired);
        boolean fSet = typeActual.isA(pool.typeSet());
        TypeExpression exprTypeOld = this.type;
        if (exprTypeOld != null) {
            TypeConstant typeSeqType = pool.typeCollection().getType();
            TypeExpression exprTypeNew = (TypeExpression)exprTypeOld.validate(ctx, typeSeqType, errs);
            if (exprTypeNew == null) {
                fit = Expression.TypeFit.NoFit;
                fConstant = false;
            } else {
                TypeConstant typeElementNew;
                if (exprTypeNew != exprTypeOld) {
                    this.type = exprTypeNew;
                }
                if ((typeElementNew = this.resolveElementType(typeActual = exprTypeNew.ensureTypeConstant(ctx, errs).resolveAutoNarrowingBase())) != null) {
                    typeElement = typeElementNew;
                }
            }
        }
        typeActual = pool.ensureParameterizedTypeConstant(typeActual, typeElement);
        if (typeElement.isImmutable() || typeElement.isService()) {
            typeActual = typeActual.freeze();
        }
        if (cExprs > 0) {
            ctx = ctx.enterList();
            for (int i = 0; i < cExprs; ++i) {
                Expression exprOld = listExprs.get(i);
                Expression exprNew = exprOld.validate(ctx, typeElement, errs);
                if (exprNew == null) {
                    fit = Expression.TypeFit.NoFit;
                    fConstant = false;
                    continue;
                }
                if (exprNew != exprOld) {
                    listExprs.set(i, exprNew);
                }
                fConstant &= exprNew.isConstant();
            }
            ctx = ctx.exit();
        }
        ArrayConstant constVal = null;
        if (fConstant) {
            if (typeElement == null) {
                typeElement = pool.typeObject();
            }
            TypeConstant typeImpl = pool.ensureImmutableTypeConstant(fSet ? pool.ensureSetType(typeElement) : pool.ensureArrayType(typeElement));
            if (typeRequired == null || typeImpl.isA(typeRequired)) {
                if (fSet) {
                    ListSet<Constant> listVal = new ListSet<Constant>(cExprs);
                    for (int i = 0; i < cExprs; ++i) {
                        Constant constEl = listExprs.get(i).toConstant();
                        if (listVal.add(constEl)) continue;
                        this.log(errs, Severity.ERROR, "COMPILER-164", constEl.getValueString());
                    }
                    constVal = pool.ensureSetConstant(typeImpl, listVal.toArray(Constant.NO_CONSTS));
                } else {
                    Constant[] aconstVal = new Constant[cExprs];
                    for (int i = 0; i < cExprs; ++i) {
                        aconstVal[i] = listExprs.get(i).toConstant();
                    }
                    constVal = pool.ensureArrayConstant(typeImpl, aconstVal);
                }
            }
        }
        return this.finishValidation(ctx, typeRequired, typeActual, fit, constVal, errs);
    }

    @Override
    public boolean isCompletable() {
        for (Expression expr : this.exprs) {
            if (expr.isCompletable()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isShortCircuiting() {
        for (Expression expr : this.exprs) {
            if (!expr.isShortCircuiting()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean supportsCompactInit(VariableDeclarationStatement lvalue) {
        return lvalue.getRegister().getType().resolveGenericType("Element") != null;
    }

    @Override
    public void generateCompactInit(Context ctx, MethodStructure.Code code, VariableDeclarationStatement lvalue, ErrorListener errs) {
        if (this.isConstant()) {
            super.generateCompactInit(ctx, code, lvalue, errs);
        } else {
            StringConstant idName = this.pool().ensureStringConstant(lvalue.getName());
            code.add(new Var_SN(lvalue.getRegister(), idName, this.collectArguments(ctx, code, errs)));
        }
    }

    @Override
    public Argument generateArgument(Context ctx, MethodStructure.Code code, boolean fLocalPropOk, boolean fUsedOnce, ErrorListener errs) {
        if (this.isConstant()) {
            return this.toConstant();
        }
        Register reg = code.createRegister(this.getType());
        code.add(new Var_S(reg, this.collectArguments(ctx, code, errs)));
        return reg;
    }

    private TypeConstant resolveElementType(TypeConstant typeRequired) {
        TypeConstant typeConstant = typeRequired.resolveTypedefs();
        if (typeConstant instanceof UnionTypeConstant) {
            UnionTypeConstant typeUnion = (UnionTypeConstant)typeConstant;
            TypeConstant typeElement = null;
            Set<TypeConstant> setSeqType = typeUnion.collectMatching(this.pool().typeList(), null);
            if (!setSeqType.isEmpty()) {
                for (TypeConstant typeSeq : setSeqType) {
                    TypeConstant typeGuess = typeSeq.resolveGenericType("Element");
                    if (typeGuess == null) continue;
                    if (typeElement == null) {
                        typeElement = typeGuess;
                        continue;
                    }
                    if (typeElement.isA(typeGuess)) {
                        typeElement = typeGuess;
                        continue;
                    }
                    if (typeGuess.isA(typeElement)) continue;
                    return null;
                }
            }
            if (typeElement != null) {
                return typeElement;
            }
        }
        return typeRequired.resolveGenericType("Element");
    }

    private Argument[] collectArguments(Context ctx, MethodStructure.Code code, ErrorListener errs) {
        List<Expression> listExprs = this.exprs;
        int cArgs = listExprs.size();
        Argument[] aArgs = new Argument[cArgs];
        for (int i = 0; i < cArgs; ++i) {
            Expression expr = listExprs.get(i);
            Argument arg = expr.generateArgument(ctx, code, true, false, errs);
            aArgs[i] = expr.ensurePointInTime(code, arg, listExprs, i);
        }
        return aArgs;
    }

    @Override
    public ExprAST getExprAST(Context ctx) {
        if (this.isConstant()) {
            return new ConstantExprAST(this.toConstant());
        }
        List<Expression> listExprs = this.exprs;
        int cArgs = listExprs.size();
        ExprAST[] aAstArg = new ExprAST[cArgs];
        for (int i = 0; i < cArgs; ++i) {
            aAstArg[i] = listExprs.get(i).getExprAST(ctx);
        }
        return new ListExprAST(this.getType(), aAstArg);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        boolean first = true;
        for (Expression expr : this.exprs) {
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            sb.append(expr);
        }
        sb.append(']');
        return sb.toString();
    }

    @Override
    public String getDumpDesc() {
        return this.toString();
    }
}

