/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.compiler.ast;

import java.math.BigDecimal;
import org.xvm.asm.Constant;
import org.xvm.asm.ConstantPool;
import org.xvm.asm.ErrorListener;
import org.xvm.asm.Version;
import org.xvm.asm.ast.ConstantExprAST;
import org.xvm.asm.ast.ExprAST;
import org.xvm.asm.constants.TypeConstant;
import org.xvm.compiler.Token;
import org.xvm.compiler.ast.Context;
import org.xvm.compiler.ast.Expression;
import org.xvm.util.Handy;
import org.xvm.util.PackedInteger;
import org.xvm.util.Severity;

public class LiteralExpression
extends Expression {
    protected Token literal;

    public LiteralExpression(Token literal) {
        this.literal = literal;
    }

    public Token getLiteral() {
        return this.literal;
    }

    public Version getVersion() {
        assert (this.literal.getId() == Token.Id.LIT_VERSION);
        return (Version)this.literal.getValue();
    }

    @Override
    public long getStartPosition() {
        return this.literal.getStartPosition();
    }

    @Override
    public long getEndPosition() {
        return this.literal.getEndPosition();
    }

    @Override
    public TypeConstant getImplicitType(Context ctx) {
        ConstantPool pool = this.pool();
        return switch (this.literal.getId()) {
            case Token.Id.LIT_BIT -> pool.typeBit();
            case Token.Id.LIT_NIBBLE -> pool.typeNibble();
            case Token.Id.LIT_CHAR -> pool.typeChar();
            case Token.Id.TODO, Token.Id.LIT_STRING -> pool.typeString();
            case Token.Id.LIT_BINSTR -> pool.typeBinary();
            case Token.Id.LIT_INT -> pool.typeIntLiteral();
            case Token.Id.LIT_INT8 -> pool.typeInt8();
            case Token.Id.LIT_INT16 -> pool.typeInt16();
            case Token.Id.LIT_INT32 -> pool.typeInt32();
            case Token.Id.LIT_INT64 -> pool.typeInt64();
            case Token.Id.LIT_INT128 -> pool.typeInt128();
            case Token.Id.LIT_INTN -> pool.typeIntN();
            case Token.Id.LIT_UINT8 -> pool.typeUInt8();
            case Token.Id.LIT_UINT16 -> pool.typeUInt16();
            case Token.Id.LIT_UINT32 -> pool.typeUInt32();
            case Token.Id.LIT_UINT64 -> pool.typeUInt64();
            case Token.Id.LIT_UINT128 -> pool.typeUInt128();
            case Token.Id.LIT_UINTN -> pool.typeUIntN();
            case Token.Id.LIT_DEC -> pool.typeFPLiteral();
            case Token.Id.LIT_DECA -> pool.typeDec64();
            case Token.Id.LIT_DEC32, Token.Id.LIT_DEC64, Token.Id.LIT_DEC128, Token.Id.LIT_DECN -> pool.ensureEcstasyTypeConstant("numbers." + this.literal.getId().TEXT);
            case Token.Id.LIT_FLOAT -> pool.typeFPLiteral();
            case Token.Id.LIT_FLOAT8E4, Token.Id.LIT_FLOAT8E5, Token.Id.LIT_BFLOAT16, Token.Id.LIT_FLOAT16, Token.Id.LIT_FLOAT32, Token.Id.LIT_FLOAT64, Token.Id.LIT_FLOAT128, Token.Id.LIT_FLOATN -> pool.ensureEcstasyTypeConstant("numbers." + this.literal.getId().TEXT);
            case Token.Id.LIT_DATE -> pool.typeDate();
            case Token.Id.LIT_TIMEOFDAY -> pool.typeTimeOfDay();
            case Token.Id.LIT_TIME -> pool.typeTime();
            case Token.Id.LIT_TIMEZONE -> pool.typeTimeZone();
            case Token.Id.LIT_DURATION -> pool.typeDuration();
            case Token.Id.LIT_VERSION -> pool.typeVersion();
            case Token.Id.LIT_PATH -> pool.typePath();
            default -> throw new IllegalStateException(this.literal.getId().name() + "=" + String.valueOf(this.literal.getValue()));
        };
    }

    Expression adoptUnaryPrefix(Token tokenPrefix, ErrorListener errs) {
        Object oValue;
        assert (tokenPrefix.getId() == Token.Id.ADD || tokenPrefix.getId() == Token.Id.SUB);
        boolean fNegate = tokenPrefix.getId() == Token.Id.SUB;
        Token tokNumber = this.literal;
        switch (tokNumber.getId()) {
            default: {
                tokenPrefix.log(errs, this.getSource(), Severity.ERROR, "COMPILER-67", tokenPrefix.getValueText(), this.getImplicitType(null).getValueString());
                return this;
            }
            case LIT_INT: 
            case LIT_INT8: 
            case LIT_INT16: 
            case LIT_INT32: 
            case LIT_INT64: 
            case LIT_INT128: 
            case LIT_INTN: 
            case LIT_UINT8: 
            case LIT_UINT16: 
            case LIT_UINT32: 
            case LIT_UINT64: 
            case LIT_UINT128: 
            case LIT_UINTN: {
                PackedInteger pint = (PackedInteger)tokNumber.getValue();
                oValue = fNegate ? PackedInteger.ZERO.sub(pint) : pint;
                break;
            }
            case LIT_DEC: 
            case LIT_DECA: 
            case LIT_DEC32: 
            case LIT_DEC64: 
            case LIT_DEC128: 
            case LIT_DECN: {
                BigDecimal dec = (BigDecimal)tokNumber.getValue();
                oValue = fNegate ? dec.negate() : dec;
                break;
            }
            case LIT_FLOAT: 
            case LIT_FLOAT8E4: 
            case LIT_FLOAT8E5: 
            case LIT_BFLOAT16: 
            case LIT_FLOAT16: 
            case LIT_FLOAT32: 
            case LIT_FLOAT64: 
            case LIT_FLOAT128: 
            case LIT_FLOATN: {
                oValue = this.getSource().toString(tokenPrefix.getStartPosition(), tokNumber.getEndPosition());
            }
        }
        Token tokenMerged = new Token(tokenPrefix.getStartPosition(), tokNumber.getEndPosition(), tokNumber.getId(), oValue);
        return this.replaceThisWith(new LiteralExpression(tokenMerged));
    }

    @Override
    protected Expression validate(Context ctx, TypeConstant typeRequired, ErrorListener errs) {
        Constant constVal;
        TypeConstant typeActual = this.getImplicitType(ctx);
        try {
            constVal = this.getLiteralConstant();
        }
        catch (RuntimeException e) {
            this.log(errs, Severity.ERROR, "COMPILER-163", this.toString());
            return null;
        }
        assert (constVal != null);
        if (typeRequired != null && typeRequired.isFormalType()) {
            typeRequired = typeRequired.resolveConstraints();
        }
        return this.finishValidation(ctx, typeRequired, typeActual, Expression.TypeFit.Fit, constVal, errs);
    }

    @Override
    public ExprAST getExprAST(Context ctx) {
        return new ConstantExprAST(this.toConstant());
    }

    public Constant getLiteralConstant() {
        Constant.Format format;
        ConstantPool pool = this.pool();
        switch (this.literal.getId()) {
            case LIT_BIT: {
                format = Constant.Format.Bit;
                break;
            }
            case LIT_NIBBLE: {
                format = Constant.Format.Nibble;
                break;
            }
            case LIT_CHAR: {
                return pool.ensureCharConstant(((Character)this.literal.getValue()).charValue());
            }
            case TODO: 
            case LIT_STRING: {
                return pool.ensureStringConstant((String)this.literal.getValue());
            }
            case LIT_BINSTR: {
                return pool.ensureByteStringConstant((byte[])this.literal.getValue());
            }
            case LIT_INT: {
                format = Constant.Format.IntLiteral;
                break;
            }
            case LIT_INT8: {
                format = Constant.Format.Int8;
                break;
            }
            case LIT_INT16: {
                format = Constant.Format.Int16;
                break;
            }
            case LIT_INT32: {
                format = Constant.Format.Int32;
                break;
            }
            case LIT_INT64: {
                format = Constant.Format.Int64;
                break;
            }
            case LIT_INT128: {
                format = Constant.Format.Int128;
                break;
            }
            case LIT_INTN: {
                format = Constant.Format.IntN;
                break;
            }
            case LIT_UINT8: {
                format = Constant.Format.UInt8;
                break;
            }
            case LIT_UINT16: {
                format = Constant.Format.UInt16;
                break;
            }
            case LIT_UINT32: {
                format = Constant.Format.UInt32;
                break;
            }
            case LIT_UINT64: {
                format = Constant.Format.UInt64;
                break;
            }
            case LIT_UINT128: {
                format = Constant.Format.UInt128;
                break;
            }
            case LIT_UINTN: {
                format = Constant.Format.UIntN;
                break;
            }
            case LIT_DEC: 
            case LIT_FLOAT: {
                format = Constant.Format.FPLiteral;
                break;
            }
            case LIT_DEC32: {
                format = Constant.Format.Dec32;
                break;
            }
            case LIT_DECA: 
            case LIT_DEC64: {
                format = Constant.Format.Dec64;
                break;
            }
            case LIT_DEC128: {
                format = Constant.Format.Dec128;
                break;
            }
            case LIT_DECN: {
                format = Constant.Format.DecN;
                break;
            }
            case LIT_FLOAT8E4: {
                format = Constant.Format.Float8e4;
                break;
            }
            case LIT_FLOAT8E5: {
                format = Constant.Format.Float8e5;
                break;
            }
            case LIT_BFLOAT16: {
                format = Constant.Format.BFloat16;
                break;
            }
            case LIT_FLOAT16: {
                format = Constant.Format.Float16;
                break;
            }
            case LIT_FLOAT32: {
                format = Constant.Format.Float32;
                break;
            }
            case LIT_FLOAT64: {
                format = Constant.Format.Float64;
                break;
            }
            case LIT_FLOAT128: {
                format = Constant.Format.Float128;
                break;
            }
            case LIT_FLOATN: {
                format = Constant.Format.FloatN;
                break;
            }
            case LIT_DATE: {
                return pool.ensureLiteralConstant(Constant.Format.Date, (String)this.literal.getValue());
            }
            case LIT_TIMEOFDAY: {
                return pool.ensureLiteralConstant(Constant.Format.TimeOfDay, (String)this.literal.getValue());
            }
            case LIT_TIME: {
                return pool.ensureLiteralConstant(Constant.Format.Time, (String)this.literal.getValue());
            }
            case LIT_TIMEZONE: {
                return pool.ensureLiteralConstant(Constant.Format.TimeZone, (String)this.literal.getValue());
            }
            case LIT_DURATION: {
                return pool.ensureLiteralConstant(Constant.Format.Duration, (String)this.literal.getValue());
            }
            case LIT_VERSION: {
                return pool.ensureVersionConstant((Version)this.literal.getValue());
            }
            case LIT_PATH: {
                return pool.ensureLiteralConstant(Constant.Format.Path, (String)this.literal.getValue());
            }
            default: {
                throw new IllegalStateException(this.literal.getId().name() + "=" + String.valueOf(this.literal.getValue()));
            }
        }
        return pool.ensureLiteralConstant(format, this.literal.getString(this.getSource()), this.literal.getValue());
    }

    @Override
    public String toString() {
        return switch (this.literal.getId()) {
            case Token.Id.LIT_INT, Token.Id.LIT_DEC, Token.Id.LIT_FLOAT -> String.valueOf(this.literal.getValue());
            case Token.Id.LIT_BIT, Token.Id.LIT_NIBBLE, Token.Id.LIT_INT8, Token.Id.LIT_INT16, Token.Id.LIT_INT32, Token.Id.LIT_INT64, Token.Id.LIT_INT128, Token.Id.LIT_INTN, Token.Id.LIT_UINT8, Token.Id.LIT_UINT16, Token.Id.LIT_UINT32, Token.Id.LIT_UINT64, Token.Id.LIT_UINT128, Token.Id.LIT_UINTN, Token.Id.LIT_DECA, Token.Id.LIT_DEC32, Token.Id.LIT_DEC64, Token.Id.LIT_DEC128, Token.Id.LIT_DECN, Token.Id.LIT_FLOAT8E4, Token.Id.LIT_FLOAT8E5, Token.Id.LIT_BFLOAT16, Token.Id.LIT_FLOAT16, Token.Id.LIT_FLOAT32, Token.Id.LIT_FLOAT64, Token.Id.LIT_FLOAT128, Token.Id.LIT_FLOATN -> this.literal.toString();
            case Token.Id.LIT_CHAR -> Handy.quotedChar(((Character)this.literal.getValue()).charValue());
            case Token.Id.LIT_STRING -> Handy.quotedString(String.valueOf(this.literal.getValue()));
            case Token.Id.LIT_BINSTR -> "#" + Handy.byteArrayToHexString((byte[])this.literal.getValue()).substring(2);
            case Token.Id.LIT_DATE -> "Date:" + String.valueOf(this.literal.getValue());
            case Token.Id.LIT_TIMEOFDAY -> "TimeOfDay:" + String.valueOf(this.literal.getValue());
            case Token.Id.LIT_TIME -> "Time:" + String.valueOf(this.literal.getValue());
            case Token.Id.LIT_TIMEZONE -> "TimeZone:" + String.valueOf(this.literal.getValue());
            case Token.Id.LIT_DURATION -> "Duration:" + String.valueOf(this.literal.getValue());
            case Token.Id.LIT_VERSION -> "v:" + String.valueOf(this.literal.getValue());
            case Token.Id.LIT_PATH -> "Path:" + String.valueOf(this.literal.getValue());
            case Token.Id.TODO -> "TODO(" + Handy.quotedString(String.valueOf(this.literal.getValue())) + ")";
            default -> throw new IllegalStateException(this.literal.getId().name() + "=" + String.valueOf(this.literal.getValue()));
        };
    }

    @Override
    public String getDumpDesc() {
        return this.toString();
    }
}

