/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.compiler.ast;

import java.lang.reflect.Field;
import java.util.List;
import org.xvm.asm.Argument;
import org.xvm.asm.Constant;
import org.xvm.asm.ConstantPool;
import org.xvm.asm.ErrorListener;
import org.xvm.asm.MethodStructure;
import org.xvm.asm.Register;
import org.xvm.asm.ast.ConstantExprAST;
import org.xvm.asm.ast.ExprAST;
import org.xvm.asm.ast.MapExprAST;
import org.xvm.asm.constants.IntConstant;
import org.xvm.asm.constants.MapConstant;
import org.xvm.asm.constants.StringConstant;
import org.xvm.asm.constants.TypeCollector;
import org.xvm.asm.constants.TypeConstant;
import org.xvm.asm.op.Var_M;
import org.xvm.asm.op.Var_MN;
import org.xvm.compiler.ast.Context;
import org.xvm.compiler.ast.Expression;
import org.xvm.compiler.ast.TypeExpression;
import org.xvm.compiler.ast.VariableDeclarationStatement;
import org.xvm.util.ListMap;
import org.xvm.util.Severity;

public class MapExpression
extends Expression {
    protected TypeExpression type;
    protected List<Expression> keys;
    protected List<Expression> values;
    protected long lEndPos;
    private transient ExprAST[] m_aKeyAST;
    private transient ExprAST[] m_aValueAST;
    private static final Field[] CHILD_FIELDS = MapExpression.fieldsForNames(MapExpression.class, "type", "keys", "values");

    public MapExpression(TypeExpression type, List<Expression> keys, List<Expression> values, long lEndPos) {
        assert (type != null);
        this.type = type;
        this.keys = keys;
        this.values = values;
        this.lEndPos = lEndPos;
    }

    @Override
    public long getStartPosition() {
        return this.type.getStartPosition();
    }

    @Override
    public long getEndPosition() {
        return this.lEndPos;
    }

    @Override
    protected Field[] getChildFields() {
        return CHILD_FIELDS;
    }

    @Override
    public TypeConstant getImplicitType(Context ctx) {
        TypeConstant typeExplicit = this.type.ensureTypeConstant(ctx, null);
        TypeConstant typeKey = null;
        TypeConstant typeVal = null;
        if (typeExplicit != null) {
            if (typeExplicit.containsUnresolved()) {
                return null;
            }
            typeKey = typeExplicit.resolveGenericType("Key");
            typeVal = typeExplicit.resolveGenericType("Value");
            if (typeKey != null && typeVal != null) {
                return typeExplicit;
            }
        }
        ConstantPool pool = this.pool();
        TypeConstant typeMap = typeExplicit == null ? pool.typeMap() : typeExplicit;
        int cEntries = this.keys.size();
        assert (cEntries == this.values.size());
        if (cEntries > 0 && (typeKey == null || typeVal == null)) {
            int i;
            TypeConstant[] aTypes = new TypeConstant[cEntries];
            if (typeKey == null) {
                for (i = 0; i < cEntries; ++i) {
                    aTypes[i] = this.keys.get(i).getImplicitType(ctx);
                }
                typeKey = TypeCollector.inferFrom(aTypes, pool);
            }
            if (typeVal == null) {
                for (i = 0; i < cEntries; ++i) {
                    aTypes[i] = this.values.get(i).getImplicitType(ctx);
                }
                typeVal = TypeCollector.inferFrom(aTypes, pool);
            }
            if (typeKey != null) {
                TypeConstant[] typeConstantArray;
                if (typeVal == null) {
                    TypeConstant[] typeConstantArray2 = new TypeConstant[1];
                    typeConstantArray = typeConstantArray2;
                    typeConstantArray2[0] = typeKey;
                } else {
                    TypeConstant[] typeConstantArray3 = new TypeConstant[2];
                    typeConstantArray3[0] = typeKey;
                    typeConstantArray = typeConstantArray3;
                    typeConstantArray3[1] = typeVal;
                }
                typeMap = typeMap.adoptParameters(pool, typeConstantArray);
            }
        }
        if (typeKey != null && typeVal != null && typeKey.isImmutable() && typeVal.isImmutable()) {
            typeMap = typeMap.freeze();
        }
        return typeMap;
    }

    @Override
    public Expression.TypeFit testFit(Context ctx, TypeConstant typeRequired, boolean fExhaustive, ErrorListener errs) {
        if (typeRequired != null) {
            if (!(this.checkMapType(typeRequired, errs) && this.type.testFit(ctx, this.pool().typeMap().getType(), fExhaustive, errs).isFit() && this.checkMapType(this.type.getTypeConstant(), errs))) {
                return Expression.TypeFit.NoFit;
            }
            TypeConstant typeKey = typeRequired.resolveGenericType("Key");
            TypeConstant typeVal = typeRequired.resolveGenericType("Value");
            if (typeKey != null && typeVal != null) {
                Expression.TypeFit fit = Expression.TypeFit.Fit;
                for (Expression key : this.keys) {
                    Expression.TypeFit fitKey = key.testFit(ctx, typeKey, fExhaustive, errs);
                    if (!fitKey.isFit()) {
                        return Expression.TypeFit.NoFit;
                    }
                    fit = fit.combineWith(fitKey);
                }
                for (Expression val : this.values) {
                    Expression.TypeFit fitVal = val.testFit(ctx, typeVal, fExhaustive, errs);
                    if (!fitVal.isFit()) {
                        return Expression.TypeFit.NoFit;
                    }
                    fit = fit.combineWith(fitVal);
                }
                return fit;
            }
        }
        return super.testFit(ctx, typeRequired, fExhaustive, errs);
    }

    @Override
    protected Expression validate(Context ctx, TypeConstant typeRequired, ErrorListener errs) {
        TypeConstant typeMapType;
        TypeExpression exprOldType;
        TypeExpression exprNewType;
        ConstantPool pool = this.pool();
        Expression.TypeFit fit = Expression.TypeFit.Fit;
        List<Expression> listKeys = this.keys;
        List<Expression> listVals = this.values;
        boolean fConstKeys = true;
        boolean fConstVals = true;
        TypeConstant typeActual = pool.typeMap();
        TypeConstant typeKey = null;
        TypeConstant typeVal = null;
        int cExprs = listKeys.size();
        assert (cExprs == listVals.size());
        if (typeRequired != null && typeRequired.isA(pool.typeMap())) {
            typeKey = typeRequired.resolveGenericType("Key");
            typeVal = typeRequired.resolveGenericType("Value");
        }
        if ((exprNewType = (TypeExpression)(exprOldType = this.type).validate(ctx, typeMapType = pool.typeMap().getType(), errs)) == null) {
            fit = Expression.TypeFit.NoFit;
            fConstKeys = false;
        } else {
            TypeConstant typeValTemp;
            TypeConstant typeKeyTemp;
            if (exprNewType != exprOldType) {
                this.type = exprNewType;
            }
            if ((typeKeyTemp = (typeActual = exprNewType.ensureTypeConstant(ctx, errs).resolveAutoNarrowingBase()).resolveGenericType("Key")) != null) {
                typeKey = typeKeyTemp;
            }
            if ((typeValTemp = typeActual.resolveGenericType("Value")) != null) {
                typeVal = typeValTemp;
            }
        }
        TypeConstant[] aTypes = null;
        if (typeKey == null && cExprs > 0) {
            aTypes = new TypeConstant[cExprs];
            for (int i = 0; i < cExprs; ++i) {
                aTypes[i] = listKeys.get(i).getImplicitType(ctx);
            }
            typeKey = TypeCollector.inferFrom(aTypes, pool);
        }
        if (typeVal == null && cExprs > 0) {
            if (aTypes == null) {
                aTypes = new TypeConstant[cExprs];
            }
            for (int i = 0; i < cExprs; ++i) {
                aTypes[i] = listVals.get(i).getImplicitType(ctx);
            }
            typeVal = TypeCollector.inferFrom(aTypes, pool);
        }
        if (typeKey != null && (!typeKey.equals(typeActual.resolveGenericType("Key")) || typeVal != null && !typeVal.equals(typeActual.resolveGenericType("Value")))) {
            TypeConstant[] typeConstantArray;
            if (typeVal == null) {
                TypeConstant[] typeConstantArray2 = new TypeConstant[1];
                typeConstantArray = typeConstantArray2;
                typeConstantArray2[0] = typeKey;
            } else {
                TypeConstant[] typeConstantArray3 = new TypeConstant[2];
                typeConstantArray3[0] = typeKey;
                typeConstantArray = typeConstantArray3;
                typeConstantArray3[1] = typeVal;
            }
            typeActual = typeActual.adoptParameters(pool, typeConstantArray);
        }
        for (int i = 0; i < cExprs; ++i) {
            Expression exprOld = listKeys.get(i);
            Expression exprNew = exprOld.validate(ctx, typeKey, errs);
            if (exprNew == null) {
                fit = Expression.TypeFit.NoFit;
                fConstKeys = false;
            } else {
                if (exprNew != exprOld) {
                    listKeys.set(i, exprNew);
                }
                fConstKeys &= exprNew.isConstant();
            }
            exprOld = listVals.get(i);
            exprNew = exprOld.validate(ctx, typeVal, errs);
            if (exprNew == null) {
                fit = Expression.TypeFit.NoFit;
                fConstVals = false;
                continue;
            }
            if (exprNew != exprOld) {
                listVals.set(i, exprNew);
            }
            fConstVals &= exprNew.isConstant();
        }
        if (!this.checkMapType(typeActual, errs)) {
            return null;
        }
        MapConstant constVal = null;
        if (fConstKeys) {
            ListMap<Constant, IntConstant> map = new ListMap<Constant, IntConstant>(cExprs);
            for (int i = 0; i < cExprs; ++i) {
                Constant constKey = listKeys.get(i).toConstant();
                if (map.containsKey(constKey)) {
                    this.log(errs, Severity.ERROR, "COMPILER-154", constKey.getValueString());
                    return null;
                }
                map.put(constKey, (IntConstant)(fConstVals ? listVals.get(i).toConstant() : pool.val0()));
            }
            if (fConstVals) {
                constVal = pool.ensureMapConstant(typeActual, map);
            }
        }
        if (constVal != null || typeKey != null && typeKey.isImmutable() && typeVal != null && typeVal.isImmutable()) {
            typeActual = typeActual.freeze();
        }
        return this.finishValidation(ctx, typeRequired, typeActual, fit, constVal, errs);
    }

    @Override
    public boolean isCompletable() {
        for (Expression key : this.keys) {
            if (key.isCompletable()) continue;
            return false;
        }
        for (Expression val : this.values) {
            if (val.isCompletable()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isShortCircuiting() {
        for (Expression key : this.keys) {
            if (!key.isShortCircuiting()) continue;
            return true;
        }
        for (Expression val : this.values) {
            if (!val.isShortCircuiting()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean supportsCompactInit(VariableDeclarationStatement lvalue) {
        TypeConstant typeMap = lvalue.getRegister().getType();
        return typeMap.resolveGenericType("Key") != null && typeMap.resolveGenericType("Value") != null;
    }

    @Override
    public void generateCompactInit(Context ctx, MethodStructure.Code code, VariableDeclarationStatement lvalue, ErrorListener errs) {
        if (this.isConstant()) {
            super.generateCompactInit(ctx, code, lvalue, errs);
        } else {
            StringConstant idName = this.pool().ensureStringConstant(lvalue.getName());
            code.add(new Var_MN(lvalue.getRegister(), idName, this.collectArguments(ctx, code, true, errs), this.collectArguments(ctx, code, false, errs)));
        }
    }

    @Override
    public Argument generateArgument(Context ctx, MethodStructure.Code code, boolean fLocalPropOk, boolean fUsedOnce, ErrorListener errs) {
        if (this.isConstant()) {
            return this.toConstant();
        }
        Register reg = code.createRegister(this.getType());
        code.add(new Var_M(reg, this.collectArguments(ctx, code, true, errs), this.collectArguments(ctx, code, false, errs)));
        return reg;
    }

    private Argument[] collectArguments(Context ctx, MethodStructure.Code code, boolean fKeys, ErrorListener errs) {
        List<Expression> listArgs = fKeys ? this.keys : this.values;
        int cArgs = listArgs.size();
        Argument[] aArg = new Argument[cArgs];
        ExprAST[] aAST = new ExprAST[cArgs];
        for (int i = 0; i < cArgs; ++i) {
            Expression expr = listArgs.get(i);
            Argument arg = expr.generateArgument(ctx, code, true, false, errs);
            aArg[i] = expr.ensurePointInTime(code, arg, listArgs, i);
            aAST[i] = expr.getExprAST(ctx);
        }
        if (fKeys) {
            this.m_aKeyAST = aAST;
        } else {
            this.m_aValueAST = aAST;
        }
        return aArg;
    }

    @Override
    public ExprAST getExprAST(Context ctx) {
        if (this.m_aKeyAST == null) {
            assert (this.isConstant());
            return new ConstantExprAST(this.toConstant());
        }
        return new MapExprAST(this.getType(), this.m_aKeyAST, this.m_aValueAST);
    }

    private boolean checkMapType(TypeConstant type, ErrorListener errs) {
        ConstantPool pool = this.pool();
        if (!type.isSingleUnderlyingClass(true) || !type.getSingleUnderlyingClass(true).equals(pool.clzMap())) {
            this.log(errs, Severity.ERROR, "COMPILER-43", pool.typeMap().getValueString(), type.getValueString());
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("\n    {");
        int c = this.keys.size();
        for (int i = 0; i < c; ++i) {
            if (i > 0) {
                sb.append(',');
            }
            sb.append("\n    ").append(this.keys.get(i)).append(" = ").append(this.values.get(i));
        }
        sb.append("\n}");
        return sb.toString();
    }

    @Override
    public String getDumpDesc() {
        return "size=" + this.keys.size();
    }
}

