/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.compiler.ast;

import java.lang.reflect.Field;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.xvm.asm.Annotation;
import org.xvm.asm.ClassStructure;
import org.xvm.asm.Component;
import org.xvm.asm.Constant;
import org.xvm.asm.ConstantPool;
import org.xvm.asm.Constants;
import org.xvm.asm.ErrorListener;
import org.xvm.asm.MethodStructure;
import org.xvm.asm.ModuleStructure;
import org.xvm.asm.MultiMethodStructure;
import org.xvm.asm.PropertyStructure;
import org.xvm.asm.constants.AnnotatedTypeConstant;
import org.xvm.asm.constants.ClassConstant;
import org.xvm.asm.constants.IdentityConstant;
import org.xvm.asm.constants.MethodConstant;
import org.xvm.asm.constants.MethodInfo;
import org.xvm.asm.constants.PropertyConstant;
import org.xvm.asm.constants.PropertyInfo;
import org.xvm.asm.constants.TypeConstant;
import org.xvm.compiler.Token;
import org.xvm.compiler.ast.AnnotatedTypeExpression;
import org.xvm.compiler.ast.AnnotationExpression;
import org.xvm.compiler.ast.AstNode;
import org.xvm.compiler.ast.ComponentStatement;
import org.xvm.compiler.ast.Context;
import org.xvm.compiler.ast.Expression;
import org.xvm.compiler.ast.Parameter;
import org.xvm.compiler.ast.PropertyDeclarationStatement;
import org.xvm.compiler.ast.ReturnStatement;
import org.xvm.compiler.ast.StageMgr;
import org.xvm.compiler.ast.Statement;
import org.xvm.compiler.ast.StatementBlock;
import org.xvm.compiler.ast.TypeExpression;
import org.xvm.util.Handy;
import org.xvm.util.Severity;

public class MethodDeclarationStatement
extends ComponentStatement {
    protected Expression condition;
    protected List<Token> modifiers;
    protected List<AnnotationExpression> annotations;
    protected List<Parameter> typeParams;
    protected Token conditional;
    protected List<Parameter> returns;
    protected Token name;
    protected List<TypeExpression> redundant;
    protected List<Parameter> params;
    protected StatementBlock body;
    protected Token doc;
    private transient Token m_tokFinally;
    private transient StatementBlock m_bodyFinally;
    private transient MethodDeclarationStatement m_stmtComplement;
    protected static int m_counter;
    private static final Field[] CHILD_FIELDS;

    public MethodDeclarationStatement(long lStartPos, long lEndPos, Expression condition, List<Token> modifiers, List<AnnotationExpression> annotations, List<Parameter> typeParams, Token conditional, List<Parameter> returns, Token name, List<TypeExpression> redundant, List<Parameter> params, StatementBlock body, Token tokFinally, StatementBlock bodyFinally, Token doc) {
        super(lStartPos, lEndPos);
        assert (name != null);
        this.condition = condition;
        this.modifiers = modifiers;
        this.annotations = annotations;
        this.conditional = conditional;
        this.typeParams = typeParams;
        this.returns = returns;
        this.name = name;
        this.redundant = redundant;
        this.params = params;
        this.body = body;
        this.m_tokFinally = tokFinally;
        this.m_bodyFinally = bodyFinally;
        this.doc = doc;
    }

    public MethodDeclarationStatement(MethodStructure struct, Expression expr) {
        super(expr.getStartPosition(), expr.getEndPosition());
        this.setComponent(struct);
        Token fakeReturn = new Token(expr.getStartPosition(), expr.getStartPosition(), Token.Id.RETURN);
        ReturnStatement stmt = new ReturnStatement(fakeReturn, expr);
        stmt.adopt(expr);
        this.body = new StatementBlock(Collections.singletonList(stmt), expr.getStartPosition(), expr.getEndPosition());
        this.body.adopt(stmt);
        this.adopt(this.body);
    }

    public MethodDeclarationStatement(MethodStructure struct, StatementBlock body) {
        super(body.getStartPosition(), body.getEndPosition());
        this.body = body;
        this.setComponent(struct);
        this.adopt(body);
    }

    public boolean isConstructor() {
        return this.name != null && this.name.getId() == Token.Id.CONSTRUCT;
    }

    public boolean isConstructorFinally() {
        return this.name != null && this.name.getId() == Token.Id.FINALLY;
    }

    public boolean isValidator() {
        return this.name != null && this.name.getId() == Token.Id.ASSERT;
    }

    public MethodDeclarationStatement getConstructorFinally() {
        if (!this.isConstructor()) {
            return null;
        }
        MethodDeclarationStatement stmtFinally = this.m_stmtComplement;
        if (stmtFinally != null) {
            return stmtFinally;
        }
        StatementBlock bodyFinally = this.m_bodyFinally;
        if (bodyFinally == null) {
            return null;
        }
        stmtFinally = new MethodDeclarationStatement(bodyFinally.getStartPosition(), bodyFinally.getEndPosition(), this.condition, this.modifiers, this.annotations, this.typeParams, this.conditional, this.returns, this.m_tokFinally, this.redundant, this.params, bodyFinally, null, null, this.doc);
        stmtFinally.bindConstructor(this);
        this.m_stmtComplement = stmtFinally;
        return this.m_stmtComplement;
    }

    private void bindConstructor(MethodDeclarationStatement stmtConstructor) {
        assert (this.isConstructorFinally());
        this.m_stmtComplement = stmtConstructor;
    }

    private String getName() {
        if (this.name != null) {
            return this.name.getValueText();
        }
        MethodStructure struct = (MethodStructure)this.getComponent();
        return struct == null ? "???" : struct.getName();
    }

    @Override
    public Constants.Access getDefaultAccess() {
        Constants.Access access = MethodDeclarationStatement.getAccess(this.modifiers);
        return access == null ? Constants.Access.PUBLIC : access;
    }

    @Override
    public boolean isAutoNarrowingAllowed(TypeExpression type) {
        return this.getComponent().isAutoNarrowingAllowed();
    }

    @Override
    protected Field[] getChildFields() {
        return CHILD_FIELDS;
    }

    @Override
    protected boolean usesSuper() {
        return this.body != null && this.body.usesSuper();
    }

    public Expression getInitializerExpression() {
        List<Statement> list = this.body.stmts;
        if (list.isEmpty()) {
            return null;
        }
        Statement stmtFirst = list.get(0);
        if (stmtFirst instanceof ReturnStatement) {
            ReturnStatement stmtRet = (ReturnStatement)stmtFirst;
            if (stmtRet.exprs.size() == 1) {
                return stmtRet.exprs.get(0);
            }
        }
        return null;
    }

    @Override
    public TypeConstant[] getReturnTypes() {
        return ((MethodStructure)this.getComponent()).getReturnTypes();
    }

    @Override
    public boolean isReturnConditional() {
        return this.conditional != null;
    }

    @Override
    public void collectReturnTypes(TypeConstant[] atypeRet) {
    }

    @Override
    protected AstNode getCodeContainer() {
        return null;
    }

    @Override
    protected int getCodeContainerCounter() {
        return m_counter++;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void registerStructures(StageMgr mgr, ErrorListener errs) {
        block21: {
            String sName;
            Component container;
            block22: {
                MethodStructure method;
                boolean fUsesSuper;
                org.xvm.asm.Parameter[] aParams;
                org.xvm.asm.Parameter[] aReturns;
                Annotation[] aAnnotations;
                ConstantPool pool;
                boolean fFunction;
                boolean fValidator;
                boolean fFinally;
                boolean fConstructor;
                block25: {
                    block23: {
                        block24: {
                            mgr.deferChildren();
                            if (this.getComponent() != null) break block21;
                            container = this.getParent().getComponent();
                            if (container == null) {
                                return;
                            }
                            sName = this.getName();
                            if (!container.isMethodContainer()) break block22;
                            fConstructor = this.isConstructor();
                            fFinally = this.isConstructorFinally();
                            fValidator = this.isValidator();
                            fFunction = MethodDeclarationStatement.isStatic(this.modifiers) || fConstructor || container.isStatic() && !(container instanceof ClassStructure);
                            pool = container.getConstantPool();
                            aAnnotations = this.buildAnnotations(pool);
                            if (this.returns != null) break block23;
                            if (!(container instanceof PropertyStructure)) break block24;
                            if (fFunction) {
                                this.log(errs, Severity.ERROR, "COMPILER-125", sName);
                                return;
                            }
                            break block21;
                        }
                        if (!fConstructor && !fFinally && !fValidator) throw new IllegalStateException("missing returns");
                        aReturns = org.xvm.asm.Parameter.NO_PARAMS;
                        break block25;
                    }
                    int ofReturn = 0;
                    int cReturns = this.returns.size();
                    if (this.conditional != null) {
                        ++ofReturn;
                        ++cReturns;
                    }
                    aReturns = new org.xvm.asm.Parameter[cReturns];
                    if (this.conditional != null) {
                        aReturns[0] = new org.xvm.asm.Parameter(pool, pool.typeBoolean(), null, null, true, 0, true);
                    }
                    for (int i = ofReturn; i < cReturns; ++i) {
                        Parameter param = this.returns.get(i - ofReturn);
                        aReturns[i] = new org.xvm.asm.Parameter(pool, param.getType().ensureTypeConstant(), param.getName(), null, true, i, false);
                    }
                }
                if (fValidator) {
                    if (this.modifiers != null && !this.modifiers.isEmpty()) {
                        Token tok = this.modifiers.getFirst();
                        errs.log(Severity.ERROR, "COMPILER-09", null, this.getSource(), tok.getStartPosition(), tok.getEndPosition());
                        return;
                    }
                    if (this.params != null && !this.params.isEmpty()) {
                        this.params.getFirst().log(errs, Severity.ERROR, "COMPILER-13", new Object[0]);
                        return;
                    }
                    if (this.body == null) {
                        this.log(errs, Severity.ERROR, "COMPILER-147", new Object[0]);
                        return;
                    }
                }
                if ((aParams = this.buildParameters(pool, errs)) == null) {
                    return;
                }
                Constants.Access access = container instanceof MethodStructure ? Constants.Access.PRIVATE : this.getDefaultAccess();
                boolean bl = fUsesSuper = !fFunction && !fFinally && !fValidator && access != Constants.Access.PRIVATE && this.usesSuper();
                if (fFinally) {
                    MethodStructure methodConstruct;
                    method = container.createMethod(false, Constants.Access.PRIVATE, null, aReturns, "finally", aParams, true, false);
                    if (this.body != null) {
                        this.body.donateSource(method);
                    }
                    if ((methodConstruct = (MethodStructure)this.m_stmtComplement.getComponent()) != null && method != null) {
                        methodConstruct.setConstructFinally(method);
                    }
                } else {
                    MethodStructure methodFinally;
                    MethodDeclarationStatement stmtFinally;
                    if (this.body == null) {
                        ClassStructure clz;
                        if (fFunction && container.getFormat() != Component.Format.INTERFACE) {
                            this.log(errs, Severity.ERROR, "COMPILER-126", sName);
                            return;
                        }
                        if (!fFunction && container instanceof ClassStructure && (clz = (ClassStructure)container).isSingleton()) {
                            this.log(errs, Severity.ERROR, "COMPILER-182", sName);
                            return;
                        }
                    }
                    if (fConstructor && container.getFormat() == Component.Format.INTERFACE && (this.body != null || access != Constants.Access.PUBLIC)) {
                        this.log(errs, Severity.ERROR, "COMPILER-161", new Object[0]);
                        return;
                    }
                    method = container.createMethod(fFunction, access, aAnnotations, aReturns, sName, aParams, this.body != null, fUsesSuper);
                    if (method != null && fConstructor && (stmtFinally = this.m_stmtComplement) != null && (methodFinally = (MethodStructure)stmtFinally.getComponent()) != null) {
                        method.setConstructFinally(methodFinally);
                    }
                    if (this.body != null) {
                        this.body.donateSource(method);
                    }
                }
                if (method == null) {
                    this.log(errs, Severity.ERROR, "COMPILER-133", sName);
                    return;
                }
                this.setComponent(method);
                break block21;
            }
            this.log(errs, Severity.ERROR, "COMPILER-33", sName, container);
            return;
        }
        mgr.processChildrenExcept(child -> child == this.body);
    }

    @Override
    public void resolveNames(StageMgr mgr, ErrorListener errs) {
        MethodStructure method;
        mgr.deferChildren();
        if (this.getComponent() == null) {
            Component container = this.getParent().getComponent();
            String sName = this.getName();
            if (container != null && container.isMethodContainer() && this.returns == null && container instanceof PropertyStructure) {
                PropertyStructure property = (PropertyStructure)container;
                List<AnnotationExpression> annotations = ((PropertyDeclarationStatement)this.getParent().getParent()).annotations;
                MethodStructure methodSuper = this.findRefMethod(property, annotations, sName, this.params);
                if (methodSuper == null) {
                    TypeConstant type;
                    if (annotations != null) {
                        for (AnnotationExpression anno : annotations) {
                            type = anno.toTypeExpression().getTypeConstant();
                            if (type == null || !type.containsUnresolved()) continue;
                            mgr.requestRevisit();
                            return;
                        }
                    }
                    for (Parameter param : this.params) {
                        type = param.getType().getTypeConstant();
                        if (type == null || !type.containsUnresolved()) continue;
                        mgr.requestRevisit();
                        return;
                    }
                    this.log(errs, Severity.ERROR, "COMPILER-38", sName);
                    return;
                }
                ConstantPool pool = container.getConstantPool();
                int cReturns = methodSuper.getReturnCount();
                org.xvm.asm.Parameter[] aReturns = new org.xvm.asm.Parameter[cReturns];
                for (int i = 0; i < cReturns; ++i) {
                    Constant constReturn;
                    org.xvm.asm.Parameter param = methodSuper.getReturn(i);
                    TypeConstant type = param.getType();
                    if (type.containsUnresolved()) {
                        mgr.requestRevisit();
                        return;
                    }
                    if (type.getFormat() == Constant.Format.TerminalType && (constReturn = type.getDefiningConstant()).getFormat() == Constant.Format.Property && "Referent".equals(((PropertyConstant)constReturn).getName())) {
                        param = new org.xvm.asm.Parameter(pool, property.getType(), param.getName(), null, true, i, false);
                    }
                    aReturns[i] = param;
                }
                org.xvm.asm.Parameter[] aParams = this.buildParameters(pool, errs);
                if (aParams == null) {
                    return;
                }
                Annotation[] annos = new Annotation[]{pool.ensureAnnotation(pool.clzOverride(), new Constant[0])};
                MethodStructure method2 = container.createMethod(false, methodSuper.getAccess(), annos, aReturns, sName, aParams, this.body != null, this.usesSuper());
                if (this.body != null) {
                    this.body.donateSource(method2);
                }
                this.setComponent(method2);
            }
        }
        if ((method = (MethodStructure)this.getComponent()) != null) {
            mgr.processChildrenExcept(child -> child == this.body);
            List<Parameter> listParams = this.params;
            if (listParams != null) {
                int c = listParams.size();
                for (int i = 0; i < c; ++i) {
                    Parameter param = listParams.get(i);
                    TypeExpression exprType = param.getType();
                    while (exprType instanceof AnnotatedTypeExpression) {
                        AnnotatedTypeExpression exprAnno = (AnnotatedTypeExpression)exprType;
                        if (exprAnno.isDisassociated()) {
                            method.getParam(i).addAnnotation(exprAnno.getAnnotation().ensureAnnotation(this.pool()));
                        }
                        exprType = exprAnno.type;
                    }
                }
            }
            if (!method.resolveAnnotations() || !method.resolveTypedefs()) {
                mgr.requestRevisit();
            } else if (method.isFunction()) {
                for (TypeConstant type : method.getIdentityConstant().getRawParams()) {
                    if (!type.containsGenericType(true)) continue;
                    this.log(errs, Severity.ERROR, "COMPILER-144", method.getName(), type.getValueString());
                }
                for (TypeConstant type : method.getIdentityConstant().getRawReturns()) {
                    if (!type.containsGenericType(true)) continue;
                    this.log(errs, Severity.ERROR, "COMPILER-144", method.getName(), type.getValueString());
                }
            }
        }
    }

    @Override
    public void validateContent(StageMgr mgr, ErrorListener errs) {
        TypeConstant typeParent;
        PropertyInfo prop;
        MethodStructure method = (MethodStructure)this.getComponent();
        if (method == null || !this.catchUpChildren(errs)) {
            mgr.deferChildren();
            return;
        }
        if (!method.isLambda() && method.getParent().getParent().findMethod(method.getIdentityConstant().getSignature()) != method) {
            this.log(errs, Severity.ERROR, "COMPILER-133", method.getIdentityConstant().getValueString());
            return;
        }
        ConstantPool pool = this.pool();
        ClassStructure clzParent = method.getContainingClass();
        if (method.getChildrenCount() > 0) {
            IdentityConstant idClz = clzParent.getIdentityConstant();
            ConstantPool poolId = idClz.getConstantPool();
            pool.invalidateTypeInfos(idClz);
            if (pool != poolId) {
                poolId.invalidateTypeInfos(idClz);
            }
        }
        if (!errs.isSilent() && !method.isConstructor() && (prop = this.ensureTypeInfo(typeParent = pool.ensureAccessTypeConstant(clzParent.getFormalType(), Constants.Access.PRIVATE), errs).findProperty(method.getName())) != null && prop.getIdentity().getNestedDepth() == method.getIdentityConstant().getNestedDepth() - 1) {
            this.log(errs, Severity.ERROR, "COMPILER-142", method.getName(), prop.getIdentity().getNamespace().getPathString());
            return;
        }
        Object[] aAnno = method.getAnnotations();
        int cAnnos = aAnno.length;
        if (cAnnos > 0) {
            boolean fReordered;
            block25: {
                fReordered = false;
                TypeConstant typeBase = method.getIdentityConstant().getValueType(pool, null);
                if (cAnnos == 1) {
                    Annotation anno = aAnno[0];
                    if (anno.getAnnotationClass().equals(pool.clzOverride())) {
                        if (!this.validateOverride(clzParent, method, errs)) {
                            return;
                        }
                    } else {
                        boolean fApplicable;
                        TypeConstant typeAnno = anno.getFormalType();
                        if (typeAnno.getExplicitClassFormat() != Component.Format.ANNOTATION) {
                            this.findAnnotationExpression(anno, this.annotations).log(errs, Severity.ERROR, "VERIFY-27", anno.getValueString());
                            return;
                        }
                        TypeConstant typeInto = typeAnno.getExplicitClassInto();
                        boolean bl = fApplicable = typeInto.isIntoMetaData(typeBase, true) && typeBase.isA(typeInto.resolveGenerics(pool, typeBase));
                        if (!fApplicable) {
                            this.findAnnotationExpression(anno, this.annotations).log(errs, Severity.ERROR, "COMPILER-140", anno.getValueString(), typeBase);
                            return;
                        }
                    }
                } else {
                    Object[] atypeAnno = new TypeConstant[cAnnos];
                    Object[] atypeInto = new TypeConstant[cAnnos];
                    HashSet<TypeConstant> setTypes = new HashSet<TypeConstant>();
                    for (int i = 0; i < cAnnos; ++i) {
                        Annotation anno = aAnno[i];
                        if (anno.getAnnotationClass().equals(pool.clzOverride()) && !this.validateOverride(clzParent, method, errs)) {
                            return;
                        }
                        TypeConstant typeAnno = anno.getFormalType();
                        if (typeAnno.getExplicitClassFormat() != Component.Format.ANNOTATION) {
                            this.findAnnotationExpression(anno, this.annotations).log(errs, Severity.ERROR, "VERIFY-27", anno.getValueString());
                            return;
                        }
                        if (!setTypes.add(typeAnno)) {
                            this.findAnnotationExpression(anno, this.annotations).log(errs, Severity.ERROR, "VERIFY-28", anno.getValueString());
                        }
                        atypeAnno[i] = typeAnno;
                        atypeInto[i] = typeAnno.getExplicitClassInto();
                    }
                    ErrorListener errsTemp = errs.branch(this);
                    if (!this.validateAnnotations(typeBase, (Annotation[])aAnno, (TypeConstant[])atypeAnno, (TypeConstant[])atypeInto, errsTemp)) {
                        Object typeNext = null;
                        int iNext = atypeInto.length - 1;
                        while (true) {
                            int iFound = -1;
                            for (int i = --iNext; i >= 0; --i) {
                                if (!this.isApplicable(atypeInto[i], typeBase, (TypeConstant)typeNext)) continue;
                                iFound = i;
                                break;
                            }
                            if (iFound == -1) break;
                            MethodDeclarationStatement.shuffle(aAnno, iFound, iNext);
                            MethodDeclarationStatement.shuffle(atypeInto, iFound, iNext);
                            MethodDeclarationStatement.shuffle(atypeAnno, iFound, iNext);
                            if (this.validateAnnotations(typeBase, (Annotation[])aAnno, (TypeConstant[])atypeAnno, (TypeConstant[])atypeInto, ErrorListener.BLACKHOLE)) {
                                fReordered = true;
                                break block25;
                            }
                            typeNext = typeNext == null ? atypeAnno[iNext] : new AnnotatedTypeConstant(pool, (Annotation)aAnno[iNext], (TypeConstant)typeNext);
                        }
                        errsTemp.merge();
                        return;
                    }
                }
            }
            if (fReordered) {
                method.reorderAnnotations((Annotation[])aAnno);
            }
        }
        ClassStructure clzTop = method.getContainingClass(false);
        for (org.xvm.asm.Parameter param : method.getParamArray()) {
            String sInvalid = clzTop.checkGenericTypeVisibility(param.getType());
            if (sInvalid == null || clzParent != clzTop && clzParent.checkGenericTypeVisibility(param.getType()) == null) continue;
            this.log(errs, Severity.ERROR, "COMPILER-145", sInvalid);
            return;
        }
        org.xvm.asm.Parameter[] aReturns = method.getReturnArray();
        if (aReturns.length > 0) {
            for (org.xvm.asm.Parameter param : aReturns) {
                String sInvalid = clzTop.checkGenericTypeVisibility(param.getType());
                if (sInvalid == null || clzParent != clzTop && clzParent.checkGenericTypeVisibility(param.getType()) == null) continue;
                this.log(errs, Severity.ERROR, "COMPILER-145", sInvalid);
                return;
            }
            TypeConstant typeRet = (aReturns[0].isConditionalReturn() ? aReturns[1] : aReturns[0]).getType();
            ErrorListener errsTemp = errs.branch(this.returns == null ? this : (AstNode)this.returns.getFirst());
            typeRet.validate(errsTemp);
            errsTemp.merge();
        }
    }

    private boolean validateOverride(ClassStructure clzParent, MethodStructure method, ErrorListener errs) {
        if (method.isConstructor() || clzParent.getIdentityConstant().equals(this.pool().clzObject())) {
            return true;
        }
        TypeConstant typeParent = clzParent.getFormalType().ensureAccess(Constants.Access.PRIVATE);
        MethodInfo infoMethod = this.ensureTypeInfo(typeParent, errs).getMethodById(method.getIdentityConstant());
        if (infoMethod == null || errs.hasSeriousErrors()) {
            return true;
        }
        if (infoMethod.getChain().length < 2) {
            this.log(errs, Severity.ERROR, "COMPILER-195", new Object[0]);
            return false;
        }
        return true;
    }

    private boolean validateAnnotations(TypeConstant typeBase, Annotation[] aAnno, TypeConstant[] atypeAnno, TypeConstant[] atypeInto, ErrorListener errs) {
        ConstantPool pool = this.pool();
        TypeConstant typeNext = null;
        int iNext = aAnno.length - 1;
        while (true) {
            TypeConstant typeInto;
            if (!this.isApplicable(typeInto = atypeInto[iNext], typeBase, typeNext)) {
                Annotation anno = aAnno[iNext];
                this.findAnnotationExpression(anno, this.annotations).log(errs, Severity.ERROR, "COMPILER-140", anno.getValueString(), typeBase.getValueString());
                return false;
            }
            if (iNext == 0) {
                return true;
            }
            typeNext = typeNext == null ? atypeAnno[iNext] : new AnnotatedTypeConstant(pool, aAnno[iNext], typeNext);
            --iNext;
        }
    }

    private boolean isApplicable(TypeConstant typeInto, TypeConstant typeBase, TypeConstant typeNext) {
        if (typeInto.isIntoMetaData(typeBase, true)) {
            return typeBase.isA(typeInto.resolveGenerics(this.pool(), typeBase));
        }
        return typeNext != null && typeNext.isA(typeInto);
    }

    private static void shuffle(Object[] ao, int i, int j) {
        assert (i < j);
        Object t = ao[i];
        System.arraycopy(ao, i + 1, ao, i, j - i);
        ao[j] = t;
    }

    @Override
    public void generateCode(StageMgr mgr, ErrorListener errs) {
        MethodStructure method = (MethodStructure)this.getComponent();
        if (method == null) {
            mgr.deferChildren();
            return;
        }
        int cDefaults = method.getDefaultParamCount();
        if (cDefaults > 0) {
            StatementBlock block = this.adopt(new StatementBlock(Collections.emptyList()));
            StatementBlock.RootContext ctxMethod = new StatementBlock.RootContext(block, method);
            Context ctx = ctxMethod.validatingContext();
            int cParamExprs = this.params.size();
            int cTypeParams = method.getTypeParamCount();
            assert (cParamExprs == method.getParamCount() - cTypeParams);
            for (int i = cParamExprs - cDefaults; i < cParamExprs; ++i) {
                org.xvm.asm.Parameter parameter = method.getParam(cTypeParams + i);
                assert (parameter.hasDefaultValue());
                TypeConstant typeParam = parameter.getType();
                Parameter param = this.params.get(i);
                Expression value = param.value;
                assert (value != null);
                ctx = ctx.enterInferring(typeParam);
                Expression valueNew = value.validate(ctx, typeParam, errs);
                ctx = ctx.exit();
                if (valueNew == null) continue;
                value = valueNew;
                if (valueNew.isConstant()) {
                    parameter.setDefaultValue(value.toConstant());
                    continue;
                }
                value.log(errs, Severity.ERROR, "COMPILER-47", new Object[0]);
            }
        }
        this.compileBody(mgr, method, errs);
    }

    protected void compileBody(StageMgr mgr, MethodStructure method, ErrorListener errs) {
        if (this.body != null && !this.body.compileMethod(method.createCode(), errs)) {
            mgr.deferChildren();
        }
    }

    @Override
    protected Statement validateImpl(Context ctx, ErrorListener errs) {
        return this;
    }

    @Override
    protected boolean emit(Context ctx, boolean fReachable, MethodStructure.Code code, ErrorListener errs) {
        return true;
    }

    protected Annotation[] buildAnnotations(ConstantPool pool) {
        Annotation[] aAnnotations = Annotation.NO_ANNOTATIONS;
        if (this.annotations != null) {
            int cAnnotations = this.annotations.size();
            aAnnotations = new Annotation[cAnnotations];
            for (int i = 0; i < cAnnotations; ++i) {
                aAnnotations[i] = this.annotations.get(i).ensureAnnotation(pool);
            }
        }
        return aAnnotations;
    }

    protected org.xvm.asm.Parameter[] buildParameters(ConstantPool pool, ErrorListener errs) {
        int cTypes = this.typeParams == null ? 0 : this.typeParams.size();
        int cParams = cTypes + this.params.size();
        HashSet<String> setNames = cParams < 2 ? null : new HashSet<String>();
        org.xvm.asm.Parameter[] aParams = new org.xvm.asm.Parameter[cParams];
        for (int i = 0; i < cTypes; ++i) {
            Parameter param = this.typeParams.get(i);
            String sName = param.getName();
            TypeExpression exprType = param.getType();
            TypeConstant typeParam = pool.ensureClassTypeConstant(pool.clzType(), null, exprType == null ? pool.typeObject() : exprType.ensureTypeConstant());
            if (setNames != null && !setNames.add(sName)) {
                this.log(errs, Severity.ERROR, "COMPILER-51", sName);
                return null;
            }
            aParams[i] = new org.xvm.asm.Parameter(pool, typeParam, sName, null, false, i, true);
        }
        boolean fDefaultRequired = false;
        for (int i = cTypes; i < cParams; ++i) {
            Parameter param = this.params.get(i - cTypes);
            String sName = param.getName();
            TypeExpression exprType = param.getType();
            TypeConstant typeArg = exprType.ensureTypeConstant();
            if (setNames != null && !setNames.add(sName)) {
                this.log(errs, Severity.ERROR, "COMPILER-51", sName);
                return null;
            }
            aParams[i] = new org.xvm.asm.Parameter(pool, typeArg, sName, null, false, i, false);
            if (param.value == null) {
                if (!fDefaultRequired) continue;
                param.log(errs, Severity.ERROR, "COMPILER-153", sName);
                continue;
            }
            aParams[i].markDefaultValue();
            fDefaultRequired = true;
        }
        return aParams;
    }

    protected MethodStructure findRefMethod(PropertyStructure property, List<AnnotationExpression> annotations, String sMethName, List<Parameter> params) {
        MethodStructure method;
        block5: {
            ClassStructure clzMixin;
            AnnotationExpression annotation;
            String sAnnotation;
            ClassConstant constClass;
            ConstantPool pool = property.getConstantPool();
            ClassStructure clzRef = (ClassStructure)pool.clzRef().getComponent();
            if (clzRef == null) {
                return null;
            }
            method = this.findMethod(pool, clzRef, sMethName, params);
            if (method != null) {
                return method;
            }
            ClassStructure clzVar = (ClassStructure)pool.clzVar().getComponent();
            if (clzVar == null) {
                return null;
            }
            method = this.findMethod(pool, clzVar, sMethName, params);
            if (method != null) {
                return method;
            }
            if (annotations == null) break block5;
            Iterator<AnnotationExpression> iterator = annotations.iterator();
            while (iterator.hasNext() && ((constClass = (ClassConstant)pool.getImplicitlyImportedIdentity(sAnnotation = (annotation = iterator.next()).toTypeExpression().getName())) == null || (clzMixin = (ClassStructure)constClass.getComponent()) == null || (method = this.findMethod(pool, clzMixin, sMethName, params)) == null)) {
            }
        }
        return method;
    }

    protected MethodStructure findMethod(ConstantPool pool, ClassStructure clz, String sMethName, List<Parameter> parameters) {
        Component child = clz.getChild(sMethName);
        if (child instanceof MultiMethodStructure) {
            MultiMethodStructure mms = (MultiMethodStructure)child;
            for (Component component : mms.children()) {
                MethodStructure method = (MethodStructure)component;
                if (parameters.size() != method.getParamCount()) continue;
                return method;
            }
        }
        return null;
    }

    private String path() {
        MethodConstant idMethod = ((MethodStructure)this.getComponent()).getIdentityConstant();
        ModuleStructure module = (ModuleStructure)idMethod.getModuleConstant().getComponent();
        return module.getName() + "/" + idMethod.getPathString();
    }

    public String toSignatureString() {
        if (this.name == null) {
            MethodStructure struct = (MethodStructure)this.getComponent();
            return struct == null ? "?()" : struct.getIdentityConstant().getValueString();
        }
        StringBuilder sb = new StringBuilder();
        if (this.modifiers != null) {
            for (Token token : this.modifiers) {
                sb.append(token.getId().TEXT).append(' ');
            }
        }
        if (this.annotations != null) {
            for (AnnotationExpression annotation : this.annotations) {
                sb.append(annotation).append(' ');
            }
        }
        if (this.typeParams != null) {
            sb.append('<');
            boolean first = true;
            for (Parameter param : this.typeParams) {
                if (first) {
                    first = false;
                } else {
                    sb.append(", ");
                }
                sb.append(param.toTypeParamString());
            }
            sb.append("> ");
        }
        if (this.returns == null) {
            sb.append("<Unknown> ");
        } else if (this.returns.isEmpty()) {
            sb.append("void ");
        } else if (this.returns.size() == 1) {
            sb.append(this.returns.get(0)).append(' ');
        } else {
            sb.append(" (");
            boolean first = true;
            for (Parameter param : this.returns) {
                if (first) {
                    first = false;
                } else {
                    sb.append(", ");
                }
                sb.append(param);
            }
            sb.append(") ");
        }
        sb.append(this.getName());
        if (this.redundant != null) {
            sb.append('<');
            boolean first = true;
            for (TypeExpression type : this.redundant) {
                if (first) {
                    first = false;
                } else {
                    sb.append(", ");
                }
                sb.append(type);
            }
            sb.append('>');
        }
        if (this.params != null) {
            sb.append('(');
            boolean first = true;
            for (Parameter param : this.params) {
                if (first) {
                    first = false;
                } else {
                    sb.append(", ");
                }
                sb.append(param);
            }
            sb.append(')');
        }
        if (this.m_bodyFinally != null) {
            sb.append(" {..} finally {..}");
        }
        return sb.toString();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.doc != null) {
            Object sDoc = String.valueOf(this.doc.getValue());
            if (((String)sDoc).length() > 100) {
                sDoc = ((String)sDoc).substring(0, 97) + "...";
            }
            Handy.appendString(sb.append("/*"), (String)sDoc).append("*/\n");
        }
        sb.append(this.toSignatureString());
        if (this.body == null) {
            sb.append(';');
        } else {
            try {
                String sBody = this.body.toString();
                if (sBody.indexOf(10) >= 0) {
                    sb.append('\n').append(Handy.indentLines(sBody, "    "));
                } else {
                    sb.append(' ').append(sBody);
                }
            }
            catch (RuntimeException e) {
                sb.append("[body]");
            }
            if (this.m_bodyFinally != null) {
                try {
                    String sFinally = this.m_bodyFinally.toString();
                    sb.append("\nfinally");
                    if (sFinally.indexOf(10) >= 0) {
                        sb.append('\n').append(Handy.indentLines(sFinally, "    "));
                    } else {
                        sb.append(' ').append(sFinally);
                    }
                }
                catch (RuntimeException e) {
                    sb.append("[finally]");
                }
            }
        }
        return sb.toString();
    }

    @Override
    public String getDumpDesc() {
        return this.toSignatureString();
    }

    static {
        CHILD_FIELDS = MethodDeclarationStatement.fieldsForNames(MethodDeclarationStatement.class, "condition", "annotations", "typeParams", "returns", "redundant", "params", "body");
    }
}

